/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.core;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.artifact.repository.Activator;
import org.eclipse.equinox.internal.p2.artifact.repository.ArtifactRepositoryManager;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepository;
import org.eclipse.equinox.internal.p2.metadata.repository.MetadataRepositoryManager;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.internal.p2.repository.helpers.AbstractRepositoryManager;
import org.eclipse.equinox.internal.p2.repository.helpers.LocationProperties;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.repository.IRepository;
import org.eclipse.oomph.p2.internal.core.CachingTransport;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingRepositoryManager<T> {
    private static final Method METHOD_checkValidLocation = ReflectUtil.getMethod(AbstractRepositoryManager.class, (String)"checkValidLocation", (Class[])new Class[]{URI.class});
    private static final Method METHOD_enterLoad = ReflectUtil.getMethod(AbstractRepositoryManager.class, (String)"enterLoad", (Class[])new Class[]{URI.class, IProgressMonitor.class});
    private static final Method METHOD_basicGetRepository = ReflectUtil.getMethod(AbstractRepositoryManager.class, (String)"basicGetRepository", (Class[])new Class[]{URI.class});
    private static final Method METHOD_fail = ReflectUtil.getMethod(AbstractRepositoryManager.class, (String)"fail", (Class[])new Class[]{URI.class, Integer.TYPE});
    private static final Method METHOD_addRepository1 = ReflectUtil.getMethod(AbstractRepositoryManager.class, (String)"addRepository", (Class[])new Class[]{URI.class, Boolean.TYPE, Boolean.TYPE});
    private static final Method METHOD_loadIndexFile = ReflectUtil.getMethod(AbstractRepositoryManager.class, (String)"loadIndexFile", (Class[])new Class[]{URI.class, IProgressMonitor.class});
    private static final Method METHOD_getPreferredRepositorySearchOrder = ReflectUtil.getMethod(AbstractRepositoryManager.class, (String)"getPreferredRepositorySearchOrder", (Class[])new Class[]{LocationProperties.class});
    private static final Method METHOD_getAllSuffixes = ReflectUtil.getMethod(AbstractRepositoryManager.class, (String)"getAllSuffixes", (Class[])new Class[0]);
    private static final Method METHOD_loadRepository = ReflectUtil.getMethod(AbstractRepositoryManager.class, (String)"loadRepository", (Class[])new Class[]{URI.class, String.class, String.class, Integer.TYPE, SubMonitor.class});
    private static final Method METHOD_addRepository2 = ReflectUtil.getMethod(AbstractRepositoryManager.class, (String)"addRepository", (Class[])new Class[]{IRepository.class, Boolean.TYPE, String.class});
    private static final Method METHOD_removeRepository = ReflectUtil.getMethod(AbstractRepositoryManager.class, (String)"removeRepository", (Class[])new Class[]{URI.class, Boolean.TYPE});
    private static final Method METHOD_exitLoad = ReflectUtil.getMethod(AbstractRepositoryManager.class, (String)"exitLoad", (Class[])new Class[]{URI.class});
    private static final Method METHOD_broadcastChangeEvent = ReflectUtil.getMethod(AbstractRepositoryManager.class, (String)"broadcastChangeEvent", (Class[])new Class[]{URI.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE});
    private static final String PROPERTY_VERSION = "version";
    private final AbstractRepositoryManager<T> delegate;
    private final int repositoryType;
    private final CachingTransport transport;

    public CachingRepositoryManager(AbstractRepositoryManager<T> delegate, int repositoryType, CachingTransport transport) {
        Object t;
        this.delegate = delegate;
        this.repositoryType = repositoryType;
        if (transport == null && (t = delegate.getAgent().getService(Transport.SERVICE_NAME)) instanceof CachingTransport) {
            transport = (CachingTransport)((Object)t);
        }
        this.transport = transport;
    }

    public IRepository<T> loadRepository(URI location, IProgressMonitor monitor, String type, int flags) throws ProvisionException {
        this.checkValidLocation(location);
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean added = false;
        IRepository<T> result = null;
        try {
            CachingTransport.startLoadingRepository(location);
            this.enterLoad(location, (IProgressMonitor)sub.newChild(5));
            result = this.basicGetRepository(location);
            if (result != null) {
                IRepository<T> iRepository = result;
                return iRepository;
            }
            added = this.addRepository(location, true, false);
            LocationProperties indexFile = this.loadIndexFile(location, (IProgressMonitor)sub.newChild(15));
            String[] preferredOrder = this.getPreferredRepositorySearchOrder(indexFile);
            String[] allSuffixes = this.getAllSuffixes();
            String[] suffixes = this.sortSuffixes(allSuffixes, preferredOrder);
            sub = SubMonitor.convert((IProgressMonitor)sub, (String)NLS.bind((String)"Adding repository {0}", (Object)location), (int)(suffixes.length * 100));
            ProvisionException failure = null;
            try {
                int i = 0;
                while (i < suffixes.length) {
                    if (sub.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    try {
                        result = this.loadRepository(location, suffixes[i], type, flags, sub.newChild(100));
                    }
                    catch (ProvisionException e) {
                        failure = e;
                        break;
                    }
                    if (result != null) {
                        this.addRepository(result, false, suffixes[i]);
                        this.cacheIndexFile(location, suffixes[i]);
                        break;
                    }
                    ++i;
                }
            }
            finally {
                sub.done();
            }
            if (result == null) {
                if (added) {
                    this.removeRepository(location, false);
                }
                if (Boolean.valueOf(this.delegate.getRepositoryProperty(location, "p2.system")).booleanValue()) {
                    this.delegate.removeRepository(location);
                }
                if (failure != null) {
                    throw failure;
                }
                this.fail(location, 1000);
            }
        }
        finally {
            CachingTransport.stopLoadingRepository();
            this.exitLoad(location);
        }
        if (added) {
            this.broadcastChangeEvent(location, this.repositoryType, 0, true);
        }
        return result;
    }

    private File getCachedIndexFile(URI location) {
        try {
            String path = location.toString();
            if (!path.endsWith("/")) {
                path = String.valueOf(path) + "/";
            }
            return this.transport.getCacheFile(new URI(String.valueOf(path) + "p2.index"));
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void cacheIndexFile(URI location, String suffix) {
        if ("file".equals(location.getScheme())) {
            return;
        }
        File cachedIndexFile = this.getCachedIndexFile(location);
        Map properties = PropertiesUtil.getProperties((File)cachedIndexFile);
        if (!properties.containsKey(PROPERTY_VERSION)) {
            properties.put(PROPERTY_VERSION, "1");
        }
        if (this.repositoryType == 0) {
            properties.put("metadata.repository.factory.order", suffix);
        } else {
            properties.put("artifact.repository.factory.order", suffix);
        }
        properties.remove("generated");
        PropertiesUtil.saveProperties((File)cachedIndexFile, (Map)properties, (boolean)false);
    }

    private URI checkValidLocation(URI location) {
        return (URI)ReflectUtil.invokeMethod((Method)METHOD_checkValidLocation, this.delegate, (Object[])new Object[]{location});
    }

    private void enterLoad(URI location, IProgressMonitor monitor) {
        ReflectUtil.invokeMethod((Method)METHOD_enterLoad, this.delegate, (Object[])new Object[]{location, monitor});
    }

    protected IRepository<T> basicGetRepository(URI location) {
        return (IRepository)ReflectUtil.invokeMethod((Method)METHOD_basicGetRepository, this.delegate, (Object[])new Object[]{location});
    }

    private void fail(URI location, int code) throws ProvisionException {
        try {
            ReflectUtil.invokeMethod((Method)METHOD_fail, this.delegate, (Object[])new Object[]{location, code});
        }
        catch (ReflectUtil.ReflectionException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof ProvisionException) {
                throw (ProvisionException)cause;
            }
            throw ex;
        }
    }

    private boolean addRepository(URI location, boolean isEnabled, boolean signalAdd) {
        return (Boolean)ReflectUtil.invokeMethod((Method)METHOD_addRepository1, this.delegate, (Object[])new Object[]{location, isEnabled, signalAdd});
    }

    private LocationProperties loadIndexFile(URI location, IProgressMonitor monitor) {
        return (LocationProperties)ReflectUtil.invokeMethod((Method)METHOD_loadIndexFile, this.delegate, (Object[])new Object[]{location, monitor});
    }

    protected String[] getPreferredRepositorySearchOrder(LocationProperties properties) {
        return (String[])ReflectUtil.invokeMethod((Method)METHOD_getPreferredRepositorySearchOrder, this.delegate, (Object[])new Object[]{properties});
    }

    protected String[] getAllSuffixes() {
        return (String[])ReflectUtil.invokeMethod((Method)METHOD_getAllSuffixes, this.delegate, (Object[])new Object[0]);
    }

    private String[] sortSuffixes(String[] allSuffixes, String[] preferredOrder) {
        ArrayList<String> suffixes = new ArrayList<String>(Arrays.asList(allSuffixes));
        int i = preferredOrder.length - 1;
        while (i >= 0) {
            String suffix = preferredOrder[i].trim();
            if (!"!".equals(suffix)) {
                suffixes.remove(suffix);
                suffixes.add(0, suffix);
            }
            --i;
        }
        return suffixes.toArray(new String[suffixes.size()]);
    }

    private IRepository<T> loadRepository(URI location, String suffix, String type, int flags, SubMonitor monitor) throws ProvisionException {
        try {
            return (IRepository)ReflectUtil.invokeMethod((Method)METHOD_loadRepository, this.delegate, (Object[])new Object[]{location, suffix, type, flags, monitor});
        }
        catch (ReflectUtil.ReflectionException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof ProvisionException) {
                throw (ProvisionException)cause;
            }
            throw ex;
        }
    }

    protected void addRepository(IRepository<T> repository, boolean signalAdd, String suffix) {
        ReflectUtil.invokeMethod((Method)METHOD_addRepository2, this.delegate, (Object[])new Object[]{repository, signalAdd, suffix});
    }

    private boolean removeRepository(URI toRemove, boolean signalRemove) {
        return (Boolean)ReflectUtil.invokeMethod((Method)METHOD_removeRepository, this.delegate, (Object[])new Object[]{toRemove, signalRemove});
    }

    private void exitLoad(URI location) {
        ReflectUtil.invokeMethod((Method)METHOD_exitLoad, this.delegate, (Object[])new Object[]{location});
    }

    private void broadcastChangeEvent(URI location, int repositoryType, int kind, boolean isEnabled) {
        ReflectUtil.invokeMethod((Method)METHOD_broadcastChangeEvent, this.delegate, (Object[])new Object[]{location, repositoryType, kind, isEnabled});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Artifact
    extends ArtifactRepositoryManager {
        private static final String GLOBAL_MAX_THREADS = Activator.getContext().getProperty("eclipse.p2.max.threads");
        private final CachingRepositoryManager<IArtifactKey> loader;

        public Artifact(IProvisioningAgent agent, CachingTransport transport) {
            super(agent);
            this.loader = new CachingRepositoryManager(this, 1, transport);
        }

        protected IRepository<IArtifactKey> loadRepository(URI location, IProgressMonitor monitor, String type, int flags) throws ProvisionException {
            Map properties;
            String respositoryMaxThreads;
            IRepository<IArtifactKey> result = this.loader.loadRepository(location, monitor, type, flags);
            if (GLOBAL_MAX_THREADS != null && !result.isModifiable() && result instanceof SimpleArtifactRepository && (respositoryMaxThreads = (String)(properties = (Map)ReflectUtil.getValue((String)"properties", result)).get("eclipse.p2.max.threads")) == null) {
                properties.put("eclipse.p2.max.threads", GLOBAL_MAX_THREADS);
            }
            return result;
        }

        public URI[] getKnownRepositories(int flags) {
            return Metadata.filter(super.getKnownRepositories(flags));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flushCache() {
            Object object = this.repositoryLock;
            synchronized (object) {
                if (this.repositories != null) {
                    super.flushCache();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Metadata
    extends MetadataRepositoryManager {
        private final CachingRepositoryManager<IInstallableUnit> loader;

        public Metadata(IProvisioningAgent agent, CachingTransport transport) {
            super(agent);
            this.loader = new CachingRepositoryManager(this, 0, transport);
        }

        protected IRepository<IInstallableUnit> loadRepository(URI location, IProgressMonitor monitor, String type, int flags) throws ProvisionException {
            return this.loader.loadRepository(location, monitor, type, flags);
        }

        public URI[] getKnownRepositories(int flags) {
            return Metadata.filter(super.getKnownRepositories(flags));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flushCache() {
            Object object = this.repositoryLock;
            synchronized (object) {
                if (this.repositories != null) {
                    super.flushCache();
                }
            }
        }

        static URI[] filter(URI[] uris) {
            ArrayList<URI> result = new ArrayList<URI>(uris.length);
            URI[] uRIArray = uris;
            int n = uris.length;
            int n2 = 0;
            while (n2 < n) {
                URI uri = uRIArray[n2];
                try {
                    if (!"file".equalsIgnoreCase(uri.getScheme()) || new File(uri).isDirectory()) {
                        result.add(uri);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                ++n2;
            }
            return result.toArray(new URI[result.size()]);
        }
    }
}

