/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnuarmeclipse.core;

import ilg.gnuarmeclipse.core.Activator;
import ilg.gnuarmeclipse.core.SystemUIJob;
import java.net.URL;
import java.util.LinkedList;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.IValueVariable;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.WorkbenchWindow;

public class EclipseUtils {
    private static final String PROPERTY_OS_NAME = "os.name";

    public static boolean isWindows() {
        return System.getProperty(PROPERTY_OS_NAME).toLowerCase().startsWith("win");
    }

    public static boolean isWindowsXP() {
        return System.getProperty(PROPERTY_OS_NAME).toLowerCase().equalsIgnoreCase("Windows XP");
    }

    public static boolean isLinux() {
        return System.getProperty(PROPERTY_OS_NAME).toLowerCase().startsWith("linux");
    }

    public static boolean isMacOSX() {
        return System.getProperty(PROPERTY_OS_NAME).toLowerCase().startsWith("mac");
    }

    public static String getOsFamily() {
        if (EclipseUtils.isWindows()) {
            return "windows";
        }
        if (EclipseUtils.isLinux()) {
            return "linux";
        }
        if (EclipseUtils.isMacOSX()) {
            return "osx";
        }
        return "other";
    }

    public static String getKeyOs(String key) {
        String os = EclipseUtils.getOsFamily();
        String keyOs = String.format(key, os);
        return keyOs;
    }

    public static String getPathSeparator() {
        if (EclipseUtils.isWindows()) {
            return ";";
        }
        return ":";
    }

    public static void openExternalBrowser(URL url) throws PartInitException {
        PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(url);
    }

    public static void openExternalFile(IPath path) throws PartInitException {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IFileStore fileStore = EFS.getLocalFileSystem().getStore(path);
        IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
    }

    public static void openFileWithInternalEditor(IPath path) throws PartInitException {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IFileStore fileStore = EFS.getLocalFileSystem().getStore(path);
        IDE.openInternalEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
    }

    public static IProject getProjectByName(String name) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(name);
    }

    public static IProject getSelectedProject() {
        Object firstElement;
        ISelection selection;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (selection = window.getSelectionService().getSelection()) != null && selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof IAdaptable) {
            IProject project = (IProject)((IAdaptable)firstElement).getAdapter(IProject.class);
            return project;
        }
        return null;
    }

    public static IWorkbenchPage getActivePage() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    public static IWorkbenchPage getActivePage(IWorkbenchPart part) {
        return part.getSite().getWorkbenchWindow().getActivePage();
    }

    public static Shell getShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public static IConfiguration getConfigurationFromDescription(ICConfigurationDescription configDescription) {
        return ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)configDescription);
    }

    public static void openError(final String title, final String message, final Exception e) {
        SystemUIJob uiJob = new SystemUIJob("open error"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                String msg = message;
                if (e != null) {
                    msg = "\n" + e.getMessage();
                }
                MessageDialog.openError((Shell)EclipseUtils.getShell(), (String)title, (String)msg);
                return Status.OK_STATUS;
            }
        };
        uiJob.schedule();
    }

    public static void clearStatusMessage() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window instanceof WorkbenchWindow) {
                    WorkbenchWindow w = (WorkbenchWindow)window;
                    w.getStatusLineManager().setErrorMessage("");
                }
            }
        });
    }

    public static void showStatusMessage(final String message) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println(message);
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window instanceof WorkbenchWindow) {
                    WorkbenchWindow w = (WorkbenchWindow)window;
                    w.getStatusLineManager().setMessage(message);
                }
            }
        });
    }

    public static void showStatusErrorMessage(final String message) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println(message);
        }
        Activator.log(message);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window instanceof WorkbenchWindow) {
                    WorkbenchWindow w = (WorkbenchWindow)window;
                    w.getStatusLineManager().setErrorMessage("  " + message);
                }
            }
        });
    }

    public static String getPreferenceValueForId(String pluginId, String key, String defaultValue, IScopeContext[] contexts) {
        String value = null;
        int i = 0;
        while (i < contexts.length) {
            value = contexts[i].getNode(pluginId).get(key, null);
            if (value != null && !(value = value.trim()).isEmpty()) break;
            ++i;
        }
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public static IScopeContext[] getPreferenceScopeContexts(IProject project) {
        IScopeContext[] contexts = project != null ? new IScopeContext[]{new ProjectScope(project), InstanceScope.INSTANCE, ConfigurationScope.INSTANCE, DefaultScope.INSTANCE} : new IScopeContext[]{InstanceScope.INSTANCE, ConfigurationScope.INSTANCE, DefaultScope.INSTANCE};
        return contexts;
    }

    public static String getPreferenceValueForId(String pluginId, String key, String defaultValue, IProject project) {
        IScopeContext[] contexts = EclipseUtils.getPreferenceScopeContexts(project);
        return EclipseUtils.getPreferenceValueForId(pluginId, key, defaultValue, contexts);
    }

    public static String getVariableValue(String name) {
        IValueVariable variable = VariablesPlugin.getDefault().getStringVariableManager().getValueVariable(name);
        if (variable != null) {
            return variable.getValue();
        }
        Activator.log("Variable \"" + name + "\" not found.");
        return null;
    }

    public static void setVariableValue(String name, String value) {
        IValueVariable variable = VariablesPlugin.getDefault().getStringVariableManager().getValueVariable(name);
        if (variable != null) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("Variable \"" + name + "\"=\"" + value + "\"");
            }
            variable.setValue(value);
        } else {
            Activator.log("Variable \"" + name + "\" not set.");
        }
    }

    public static void setVariableValue(String name, String description, String value) {
        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
        IValueVariable variable = manager.getValueVariable(name);
        if (variable == null) {
            variable = manager.newValueVariable(name, description);
            try {
                manager.addVariables(new IValueVariable[]{variable});
            }
            catch (CoreException e) {
                Activator.log(e);
                variable = null;
            }
        }
        if (variable != null) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("Variable \"" + name + "\"=\"" + value + "\"");
            }
            variable.setValue(value);
        } else {
            Activator.log("Variable \"" + name + "\" not set.");
        }
    }

    public static IConfiguration[] getConfigurationsForProject(IProject project) {
        ICProjectDescription cProjectDescription = CoreModel.getDefault().getProjectDescription(project);
        if (cProjectDescription == null) {
            return null;
        }
        ICConfigurationDescription[] cfgs = cProjectDescription.getConfigurations();
        if (cfgs == null) {
            return null;
        }
        LinkedList<IConfiguration> list = new LinkedList<IConfiguration>();
        int i = 0;
        while (i < cfgs.length) {
            IConfiguration config;
            IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
            if (info != null && (config = info.getManagedProject().getConfiguration(cfgs[i].getId())) != null) {
                list.add(config);
            }
            ++i;
        }
        if (list.size() == 0) {
            return null;
        }
        return list.toArray(new IConfiguration[list.size()]);
    }

    public static ICConfigurationDescription getBuildConfigDescription(ILaunchConfiguration config) {
        ICProjectDescription projDesc;
        ICConfigurationDescription cfg;
        block11: {
            IProject project;
            block10: {
                String projectName;
                block9: {
                    block8: {
                        cfg = null;
                        projectName = config.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", null);
                        if (projectName != null) break block8;
                        return null;
                    }
                    projectName = projectName.trim();
                    if (!projectName.isEmpty()) break block9;
                    return null;
                }
                project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                if (project != null && project.isAccessible()) break block10;
                return null;
            }
            projDesc = CoreModel.getDefault().getProjectDescription(project, false);
            if (projDesc != null) break block11;
            return null;
        }
        try {
            String buildConfigID = config.getAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR", "");
            if (buildConfigID.length() != 0) {
                cfg = projDesc.getConfigurationById(buildConfigID);
            }
            if (cfg == null) {
                cfg = projDesc.getActiveConfiguration();
            }
        }
        catch (CoreException e) {
            Activator.log(e);
        }
        return cfg;
    }
}

