/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnuarmeclipse.core;

import ilg.gnuarmeclipse.core.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Xml {
    public static Document parseFile(File file) throws ParserConfigurationException, SAXException, IOException {
        InputSource inputSource = new InputSource(new FileInputStream(file));
        DocumentBuilder xml = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = xml.parse(inputSource);
        return document;
    }

    public static Element getFirstChildElement(Element el) {
        return Xml.getFirstChildElement(el, null);
    }

    public static Element getFirstChildElement(Element el, String name) {
        NodeList nodeList = el.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1 && node.getNodeName().equals(name)) {
                return (Element)node;
            }
            ++i;
        }
        return null;
    }

    public static List<Element> getChildrenElementsList(Element el) {
        return Xml.getChildrenElementsList(el, null);
    }

    public static List<Element> getChildrenElementsList(Element el, String name) {
        NodeList nodeList = el.getChildNodes();
        ArrayList<Element> list = new ArrayList<Element>(nodeList.getLength());
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1 && (name == null || node.getNodeName().equals(name))) {
                list.add((Element)node);
            }
            ++i;
        }
        return list;
    }

    public static String getElementContent(Element el) {
        String content = "";
        if (el != null && el.getNodeType() == 1 && (content = el.getTextContent()) != null) {
            content = content.trim();
        }
        return content;
    }

    public static String getElementMultiLineContent(Element el) {
        String s = Xml.getElementContent(el);
        String[] sa = s.split("\\r?\\n");
        if (sa.length > 1) {
            s = "";
            int i = 0;
            while (i < sa.length) {
                if (i > 0) {
                    s = String.valueOf(s) + '\n';
                }
                s = String.valueOf(s) + sa[i].trim();
                ++i;
            }
        }
        return s;
    }

    public static Element getParentElement(Element el) {
        while ((el = (Element)el.getParentNode()) != null && el.getNodeType() != 1) {
        }
        return el;
    }

    public static List<String> getAttributesNames(Element el) {
        LinkedList<String> list = new LinkedList<String>();
        NamedNodeMap attribs = el.getAttributes();
        int i = 0;
        while (i < attribs.getLength()) {
            String name = attribs.item(i).getNodeName();
            list.add(name);
            ++i;
        }
        return list;
    }

    public static List<String> getAttributesNames(Element el, String[] sa) {
        LinkedList<String> list = new LinkedList<String>();
        NamedNodeMap attribs = el.getAttributes();
        int i = 0;
        while (i < attribs.getLength()) {
            String name = attribs.item(i).getNodeName();
            list.add(name);
            ++i;
        }
        LinkedList<String> listOut = new LinkedList<String>();
        String[] stringArray = sa;
        int n = sa.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (list.contains(s)) {
                list.remove(s);
                listOut.add(s);
            }
            ++n2;
        }
        listOut.addAll(list);
        return listOut;
    }

    public static String xmlEscape(String value) {
        value = value.replaceAll("\\&", "&amp;");
        value = value.replaceAll("\\\"", "&quot;");
        value = value.replaceAll("\\'", "&apos;");
        value = value.replaceAll("\\<", "&lt;");
        value = value.replaceAll("\\>", "&gt;");
        return value;
    }

    public static String joinMultiLine(String str) {
        assert (str != null);
        String[] sa = str.split("\\r?\\n");
        if (sa.length == 1) {
            return str;
        }
        return StringUtils.join(sa, " ");
    }
}

