/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.remote.core.shell;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteProcess;
import org.eclipse.remote.core.IRemoteProcessService;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.remote.core.messages.Messages;
import org.eclipse.tracecompass.internal.tmf.remote.core.preferences.TmfRemotePreferences;
import org.eclipse.tracecompass.internal.tmf.remote.core.shell.CommandInput;
import org.eclipse.tracecompass.internal.tmf.remote.core.shell.CommandResult;
import org.eclipse.tracecompass.internal.tmf.remote.core.shell.InputReader;
import org.eclipse.tracecompass.tmf.remote.core.shell.ICommandInput;
import org.eclipse.tracecompass.tmf.remote.core.shell.ICommandOutputListener;
import org.eclipse.tracecompass.tmf.remote.core.shell.ICommandResult;
import org.eclipse.tracecompass.tmf.remote.core.shell.ICommandShell2;

public class CommandShell
implements ICommandShell2 {
    private final IRemoteConnection fConnection;
    private final ExecutorService fExecutor = (ExecutorService)NonNullUtils.checkNotNull((Object)Executors.newFixedThreadPool(1));

    public CommandShell(IRemoteConnection connection) {
        this.fConnection = connection;
    }

    @Override
    public void dispose() {
        this.fExecutor.shutdown();
    }

    @Override
    public ICommandInput createCommand() {
        return new CommandInput();
    }

    @Override
    public ICommandResult executeCommand(ICommandInput command, IProgressMonitor aMonitor) throws ExecutionException {
        return this.executeCommand(command, aMonitor, null);
    }

    @Override
    public ICommandResult executeCommand(final ICommandInput command, final IProgressMonitor aMonitor, final ICommandOutputListener listener) throws ExecutionException {
        if (this.fConnection.isOpen()) {
            FutureTask<CommandResult> future = new FutureTask<CommandResult>(new Callable<CommandResult>(){

                @Override
                public CommandResult call() throws IOException, InterruptedException {
                    IProgressMonitor monitor = aMonitor;
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    if (!monitor.isCanceled()) {
                        IRemoteProcessService service = (IRemoteProcessService)CommandShell.this.fConnection.getService(IRemoteProcessService.class);
                        if (service == null) {
                            return new CommandResult(1, new String[0], new String[]{NonNullUtils.nullToEmptyString((Object)Messages.RemoteConnection_ServiceNotDefined)});
                        }
                        IRemoteProcess process = service.getProcessBuilder(command.getInput()).start();
                        InputReader stdout = new InputReader((InputStream)NonNullUtils.checkNotNull((Object)process.getInputStream()), listener, true);
                        InputReader stderr = new InputReader((InputStream)NonNullUtils.checkNotNull((Object)process.getErrorStream()), listener, false);
                        try {
                            stdout.waitFor(monitor);
                            stderr.waitFor(monitor);
                            if (!monitor.isCanceled()) {
                                CommandResult commandResult = CommandShell.createResult(process.waitFor(), stdout.toString(), stderr.toString());
                                return commandResult;
                            }
                        }
                        catch (OperationCanceledException operationCanceledException) {
                        }
                        catch (InterruptedException e) {
                            CommandResult commandResult = new CommandResult(1, new String[0], new String[]{e.getMessage()});
                            return commandResult;
                        }
                        finally {
                            stdout.stop();
                            stderr.stop();
                            process.destroy();
                        }
                    }
                    return new CommandResult(1, new String[0], new String[]{"cancelled"});
                }
            });
            this.fExecutor.execute(future);
            try {
                ICommandResult iCommandResult = (ICommandResult)NonNullUtils.checkNotNull((Object)future.get(TmfRemotePreferences.getCommandTimeout(), TimeUnit.SECONDS));
                return iCommandResult;
            }
            catch (InterruptedException ex) {
                throw new ExecutionException(Messages.RemoteConnection_ExecutionCancelled, (Throwable)ex);
            }
            catch (TimeoutException ex) {
                throw new ExecutionException(Messages.RemoteConnection_ExecutionTimeout, (Throwable)ex);
            }
            catch (Exception ex) {
                throw new ExecutionException(Messages.RemoteConnection_ExecutionFailure, (Throwable)ex);
            }
            finally {
                future.cancel(true);
            }
        }
        throw new ExecutionException(Messages.RemoteConnection_ShellNotConnected, null);
    }

    private static CommandResult createResult(int origResult, String origStdout, String origStderr) {
        int result = origResult;
        String stdout = origStdout;
        String stderr = origStderr;
        String[] output = CommandShell.splitLines(stdout);
        String[] error = CommandShell.splitLines(stderr);
        return new CommandResult(result, output, error);
    }

    @NonNull
    private static String[] splitLines(String output) {
        return (String[])NonNullUtils.checkNotNull((Object)output.split("\\r?\\n"));
    }
}

