/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.push;

import org.eclipse.egit.core.op.PushOperationResult;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.push.PushResultTable;
import org.eclipse.egit.ui.internal.push.SimpleConfigurePushDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

class PushResultDialog
extends TitleAreaDialog {
    private static final int CONFIGURE = 99;
    private final Repository localDb;
    private final PushOperationResult result;
    private final String destinationString;
    private boolean hideConfigure = false;

    public static void show(final Repository repository, final PushOperationResult result, final String sourceString, final boolean showConfigureButton, final boolean modal) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                        PushResultDialog dialog = new PushResultDialog(shell, repository, result, sourceString, modal);
                        dialog.showConfigureButton(showConfigureButton);
                        dialog.open();
                    }
                });
            }
        });
    }

    PushResultDialog(Shell parentShell, Repository localDb, PushOperationResult result, String destinationString, boolean modal) {
        super(parentShell);
        int shellStyle = this.getShellStyle() | 0x10;
        if (!modal) {
            shellStyle &= 0xFFFEFFFF;
        }
        this.setShellStyle(shellStyle);
        this.localDb = localDb;
        this.result = result;
        this.destinationString = destinationString;
        this.setHelpAvailable(false);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (!this.hideConfigure && SimpleConfigurePushDialog.getConfiguredRemote(this.localDb) != null) {
            this.createButton(parent, 99, UIText.PushResultDialog_ConfigureButton, false);
        }
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        if (buttonId == 99) {
            super.buttonPressed(0);
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Dialog dlg = SimpleConfigurePushDialog.getDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), PushResultDialog.this.localDb);
                    dlg.open();
                }
            });
        }
    }

    protected Control createDialogArea(Composite parent) {
        String title;
        Composite composite = (Composite)super.createDialogArea(parent);
        String pushErrors = this.getPushErrors();
        if (pushErrors != null && pushErrors.length() > 0) {
            this.setErrorMessage(pushErrors);
            title = NLS.bind((String)UIText.PushResultDialog_label_failed, (Object)this.destinationString);
        } else {
            title = NLS.bind((String)UIText.PushResultDialog_label, (Object)this.destinationString);
        }
        this.setTitle(title);
        PushResultTable table = new PushResultTable(composite, this.getDialogBoundsSettings());
        table.setData(this.localDb, this.result);
        Control tableControl = table.getControl();
        GridData tableLayout = new GridData(4, 4, true, true);
        tableLayout.widthHint = 650;
        tableLayout.heightHint = 300;
        tableControl.setLayoutData((Object)tableLayout);
        this.getShell().setText(NLS.bind((String)UIText.PushResultDialog_title, (Object)this.destinationString));
        PushResultDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private String getPushErrors() {
        StringBuilder messages = new StringBuilder();
        for (URIish uri : this.result.getURIs()) {
            String errorMessage = this.result.getErrorMessage(uri);
            if (errorMessage == null || errorMessage.length() <= 0) continue;
            if (messages.length() > 0) {
                messages.append(System.getProperty("line.separator"));
            }
            messages.append(errorMessage);
        }
        return messages.toString();
    }

    public void showConfigureButton(boolean show) {
        this.hideConfigure = !show;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogBoundSettings(((Object)((Object)this)).getClass());
    }
}

