/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.massif;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.internal.valgrind.massif.MassifHeapTreeNode;
import org.eclipse.linuxtools.internal.valgrind.massif.MassifPlugin;
import org.eclipse.linuxtools.internal.valgrind.massif.MassifTreeLabelProvider;
import org.eclipse.linuxtools.valgrind.ui.CollapseAction;
import org.eclipse.linuxtools.valgrind.ui.ExpandAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class MassifTreeViewer {
    private IDoubleClickListener doubleClickListener;
    private ITreeContentProvider contentProvider;
    private Action expandAction;
    private Action collapseAction;
    private TreeViewer viewer;

    public MassifTreeViewer(Composite parent) {
        this.viewer = new TreeViewer(parent, 772);
        this.contentProvider = new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                return ((MassifHeapTreeNode)parentElement).getChildren();
            }

            public Object getParent(Object element) {
                return ((MassifHeapTreeNode)element).getParent();
            }

            public boolean hasChildren(Object element) {
                MassifHeapTreeNode[] children = ((MassifHeapTreeNode)element).getChildren();
                return children != null && children.length > 0;
            }

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new MassifTreeLabelProvider());
        this.doubleClickListener = new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                MassifHeapTreeNode element = (MassifHeapTreeNode)((TreeSelection)event.getSelection()).getFirstElement();
                if (element.hasSourceFile()) {
                    MassifPlugin.getDefault().openEditorForNode(element);
                }
                if (MassifTreeViewer.this.contentProvider.hasChildren((Object)element)) {
                    MassifTreeViewer.this.viewer.expandToLevel((Object)element, 1);
                }
            }
        };
        this.viewer.addDoubleClickListener(this.doubleClickListener);
        this.expandAction = new ExpandAction(this.viewer);
        this.collapseAction = new CollapseAction(this.viewer);
        MenuManager manager = new MenuManager();
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ITreeSelection selection = (ITreeSelection)MassifTreeViewer.this.viewer.getSelection();
                MassifHeapTreeNode element = (MassifHeapTreeNode)selection.getFirstElement();
                if (MassifTreeViewer.this.contentProvider.hasChildren((Object)element)) {
                    manager.add((IAction)MassifTreeViewer.this.expandAction);
                    manager.add((IAction)MassifTreeViewer.this.collapseAction);
                }
            }
        });
        manager.setRemoveAllWhenShown(true);
        Menu contextMenu = manager.createContextMenu((Control)this.viewer.getTree());
        this.viewer.getControl().setMenu(contextMenu);
    }

    public IDoubleClickListener getDoubleClickListener() {
        return this.doubleClickListener;
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }
}

