/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.internal;

import com.ibm.icu.text.DateFormat;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate2;
import org.eclipse.cdt.launch.internal.ui.LaunchMessages;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.cdt.utils.CommandLineUtil;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class LocalRunLaunchDelegate
extends AbstractCLaunchDelegate2 {
    public LocalRunLaunchDelegate() {
        super(false);
    }

    @Override
    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        assert (mode.equals("run"));
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (mode.equals("run")) {
            this.runLocalApplication(config, launch, monitor);
        }
    }

    private void runLocalApplication(ILaunchConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(LaunchMessages.LocalCDILaunchDelegate_0, 10);
        if (monitor.isCanceled()) {
            return;
        }
        monitor.worked(1);
        try {
            String args;
            IPath exePath = this.checkBinaryDetails(config);
            File wd = this.verifyWorkingDirectory(config);
            if (wd == null) {
                wd = new File(System.getProperty("user.home", "."));
            }
            if ((args = config.getAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", "")).length() != 0) {
                args = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(args);
            }
            String[] arguments = CommandLineUtil.argumentsToArray((String)args);
            ArrayList<String> command = new ArrayList<String>(1 + arguments.length);
            command.add(exePath.toOSString());
            command.addAll(Arrays.asList(arguments));
            monitor.worked(2);
            String[] commandArray = command.toArray(new String[command.size()]);
            String[] environment = DebugPlugin.getDefault().getLaunchManager().getEnvironment(config);
            Process process = this.exec(commandArray, environment, wd);
            monitor.worked(6);
            String timestamp = DateFormat.getInstance().format(new Date(System.currentTimeMillis()));
            String processLabel = String.format("%s (%s)", commandArray[0], timestamp);
            DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)processLabel, this.createProcessAttributes());
        }
        finally {
            monitor.done();
        }
    }

    protected Map<String, String> createProcessAttributes() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("org.eclipse.cdt.dsf.gdb.createProcessType", "org.eclipse.cdt.dsf.gdb.inferiorProcess");
        attributes.put("org.eclipse.cdt.dsf.gdb.inferiorExited", "");
        return attributes;
    }

    protected IPath checkBinaryDetails(ILaunchConfiguration config) throws CoreException {
        ICProject project = this.verifyCProject(config);
        IPath exePath = this.verifyProgramPath(config, project);
        return exePath;
    }

    protected Process exec(String[] cmdLine, String[] environ, File workingDirectory) throws CoreException {
        try {
            if (PTY.isSupported()) {
                return ProcessFactory.getFactory().exec(cmdLine, environ, workingDirectory, new PTY());
            }
            return ProcessFactory.getFactory().exec(cmdLine, environ, workingDirectory);
        }
        catch (IOException e) {
            this.abort(LaunchMessages.LocalCDILaunchDelegate_8, e, 150);
            return null;
        }
    }

    public boolean preLaunchCheck(ILaunchConfiguration config, String mode, IProgressMonitor monitor) throws CoreException {
        this.setDefaultProcessFactory(config);
        return super.preLaunchCheck(config, mode, monitor);
    }

    protected void setDefaultProcessFactory(ILaunchConfiguration config) throws CoreException {
        if (!config.hasAttribute("process_factory_id")) {
            ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
            wc.setAttribute("process_factory_id", "org.eclipse.cdt.dsf.gdb.GdbProcessFactory");
            wc.doSave();
        }
    }

    @Override
    protected String getPluginID() {
        return LaunchUIPlugin.getUniqueIdentifier();
    }
}

