/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.internal.ui;

import java.io.File;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.launch.internal.ui.LaunchMessages;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.cdt.launch.ui.CLaunchConfigurationTab;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class WorkingDirectoryBlock
extends CLaunchConfigurationTab {
    protected Text fWorkingDirText;
    protected Button fWorkspaceButton;
    protected Button fFileSystemButton;
    protected Button fVariablesButton;
    protected Button fUseDefaultWorkingDirButton;
    protected ILaunchConfiguration fLaunchConfiguration;
    private WidgetListener fListener = new WidgetListener();

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        GridLayout workingDirLayout = new GridLayout();
        workingDirLayout.makeColumnsEqualWidth = false;
        group.setLayout((Layout)workingDirLayout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        group.setFont(font);
        this.setControl((Control)group);
        group.setText(LaunchMessages.WorkingDirectoryBlock_Working_directory);
        this.fWorkingDirText = new Text((Composite)group, 2052);
        this.fWorkingDirText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = LaunchMessages.WorkingDirectoryBlock_Working_directory;
            }
        });
        gd = new GridData(768);
        this.fWorkingDirText.setLayoutData((Object)gd);
        this.fWorkingDirText.setFont(font);
        this.fWorkingDirText.addModifyListener((ModifyListener)this.fListener);
        this.fUseDefaultWorkingDirButton = new Button((Composite)group, 32);
        this.fUseDefaultWorkingDirButton.setText(LaunchMessages.WorkingDirectoryBlock_Use_default);
        gd = new GridData(4, 1, true, false);
        this.fUseDefaultWorkingDirButton.setLayoutData((Object)gd);
        this.fUseDefaultWorkingDirButton.setFont(font);
        this.fUseDefaultWorkingDirButton.addSelectionListener((SelectionListener)this.fListener);
        Composite buttonComp = new Composite((Composite)group, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonComp.setLayout((Layout)layout);
        gd = new GridData(128);
        buttonComp.setLayoutData((Object)gd);
        buttonComp.setFont(font);
        this.fWorkspaceButton = this.createPushButton(buttonComp, LaunchMessages.WorkingDirectoryBlock_0, null);
        this.fWorkspaceButton.addSelectionListener((SelectionListener)this.fListener);
        this.fFileSystemButton = this.createPushButton(buttonComp, LaunchMessages.WorkingDirectoryBlock_1, null);
        this.fFileSystemButton.addSelectionListener((SelectionListener)this.fListener);
        this.fVariablesButton = this.createVariablesButton(buttonComp, LaunchMessages.WorkingDirectoryBlock_17, null);
    }

    public void dispose() {
    }

    protected void handleWorkingDirBrowseButtonSelected() {
        String selectedDirectory;
        File path;
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setMessage(LaunchMessages.WorkingDirectoryBlock_7);
        String currentWorkingDir = this.fWorkingDirText.getText();
        if (!currentWorkingDir.trim().equals("") && (path = new File(currentWorkingDir)).exists()) {
            dialog.setFilterPath(currentWorkingDir);
        }
        if ((selectedDirectory = dialog.open()) != null) {
            this.fWorkingDirText.setText(selectedDirectory);
        }
    }

    protected void handleWorkspaceDirBrowseButtonSelected() {
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, LaunchMessages.WorkingDirectoryBlock_4);
        IContainer currentContainer = this.getContainer();
        if (currentContainer != null) {
            IPath path = currentContainer.getFullPath();
            dialog.setInitialSelections(new Object[]{path});
        }
        dialog.showClosedProjects(false);
        dialog.open();
        Object[] results = dialog.getResult();
        if (results != null && results.length > 0 && results[0] instanceof IPath) {
            IPath path = (IPath)results[0];
            String containerName = path.makeRelative().toString();
            this.fWorkingDirText.setText("${workspace_loc:" + containerName + "}");
        }
    }

    protected IContainer getContainer() {
        IWorkspaceRoot root;
        IResource res;
        String path = this.fWorkingDirText.getText().trim();
        if (path.length() > 0 && (res = (root = ResourcesPlugin.getWorkspace().getRoot()).findMember(path)) instanceof IContainer) {
            return (IContainer)res;
        }
        return null;
    }

    protected void handleUseDefaultWorkingDirButtonSelected() {
        boolean def = this.isDefaultWorkingDirectory();
        if (def) {
            this.setDefaultWorkingDir();
        }
        this.fWorkingDirText.setEnabled(!def);
        this.fWorkspaceButton.setEnabled(!def);
        this.fVariablesButton.setEnabled(!def);
        this.fFileSystemButton.setEnabled(!def);
    }

    protected void setDefaultWorkingDir() {
        try {
            ICProject cProject;
            ILaunchConfiguration config = this.getLaunchConfiguration();
            if (config != null && (cProject = CDebugUtils.getCProject((ILaunchConfiguration)config)) != null) {
                this.fWorkingDirText.setText("${workspace_loc:" + cProject.getPath().makeRelative().toOSString() + "}");
                return;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.fWorkingDirText.setText(System.getProperty("user.dir"));
    }

    public boolean isValid(ILaunchConfiguration config) {
        IContainer container;
        this.setErrorMessage(null);
        this.setMessage(null);
        String workingDirPath = this.fWorkingDirText.getText().trim();
        if (workingDirPath.indexOf("${") >= 0) {
            IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
            try {
                manager.validateStringVariables(workingDirPath);
            }
            catch (CoreException e) {
                this.setErrorMessage(e.getMessage());
                return false;
            }
        } else if (workingDirPath.length() > 0 && (container = this.getContainer()) == null) {
            File dir = new File(workingDirPath);
            if (dir.isDirectory()) {
                return true;
            }
            this.setErrorMessage(LaunchMessages.WorkingDirectoryBlock_10);
            return false;
        }
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.setLaunchConfiguration(configuration);
        try {
            String wd = configuration.getAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", null);
            this.fWorkingDirText.setText("");
            if (wd == null) {
                this.fUseDefaultWorkingDirButton.setSelection(true);
            } else {
                this.fWorkingDirText.setText(wd);
                this.fUseDefaultWorkingDirButton.setSelection(false);
            }
            this.handleUseDefaultWorkingDirButtonSelected();
        }
        catch (CoreException e) {
            this.setErrorMessage(String.valueOf(LaunchMessages.WorkingDirectoryBlock_Exception_occurred_reading_configuration_15) + e.getStatus().getMessage());
            LaunchUIPlugin.log(e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String wd = null;
        if (!this.isDefaultWorkingDirectory()) {
            wd = this.getAttributeValueFrom(this.fWorkingDirText);
        }
        configuration.setAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", wd);
    }

    protected String getAttributeValueFrom(Text text) {
        String content = text.getText().trim();
        if (content.length() > 0) {
            return content;
        }
        return null;
    }

    public String getName() {
        return LaunchMessages.WorkingDirectoryBlock_Working_Directory_8;
    }

    protected boolean isDefaultWorkingDirectory() {
        return this.fUseDefaultWorkingDirButton.getSelection();
    }

    protected void setLaunchConfiguration(ILaunchConfiguration config) {
        this.fLaunchConfiguration = config;
    }

    protected ILaunchConfiguration getLaunchConfiguration() {
        return this.fLaunchConfiguration;
    }

    private class WidgetListener
    extends SelectionAdapter
    implements ModifyListener {
        private WidgetListener() {
        }

        public void modifyText(ModifyEvent e) {
            WorkingDirectoryBlock.this.updateLaunchConfigurationDialog();
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == WorkingDirectoryBlock.this.fWorkspaceButton) {
                WorkingDirectoryBlock.this.handleWorkspaceDirBrowseButtonSelected();
            } else if (source == WorkingDirectoryBlock.this.fFileSystemButton) {
                WorkingDirectoryBlock.this.handleWorkingDirBrowseButtonSelected();
            } else if (source == WorkingDirectoryBlock.this.fUseDefaultWorkingDirButton) {
                WorkingDirectoryBlock.this.handleUseDefaultWorkingDirButtonSelected();
            }
        }
    }
}

