/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.handlers;

import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.editors.ITmfTraceEditor;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class RefreshTraceContentHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        TmfTraceElement trace;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        Iterator iterator = ((IStructuredSelection)selection).iterator();
        boolean refreshed = false;
        while (iterator.hasNext()) {
            Object element = iterator.next();
            if (!(element instanceof TmfTraceElement)) continue;
            trace = (TmfTraceElement)element;
            RefreshTraceContentHandler.refreshTrace(trace);
            refreshed = true;
        }
        if (refreshed) {
            return null;
        }
        IEditorPart activeEditor = HandlerUtil.getActiveEditorChecked((ExecutionEvent)event);
        if (activeEditor instanceof ITmfTraceEditor) {
            trace = ((ITmfTraceEditor)activeEditor).getTrace();
            RefreshTraceContentHandler.refreshTrace((ITmfTrace)trace);
        }
        return null;
    }

    private static void refreshTrace(TmfTraceElement t) {
        TmfTraceElement traceElement = t.getElementUnderTraceFolder();
        ITmfTrace trace = traceElement.getTrace();
        if (trace != null) {
            RefreshTraceContentHandler.refreshTrace(trace);
        }
    }

    private static void refreshTrace(ITmfTrace trace) {
        TmfTimeRange range = new TmfTimeRange(TmfTimestamp.BIG_BANG, TmfTimestamp.BIG_CRUNCH);
        TmfTraceRangeUpdatedSignal signal = new TmfTraceRangeUpdatedSignal((Object)trace, trace, range);
        trace.broadcastAsync((TmfSignal)signal);
    }
}

