/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg;

import org.eclipse.swt.graphics.Image;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageFilesElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfNavigatorLabelProvider;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;

public class TracePackageTraceElement
extends TracePackageElement {
    private final TmfTraceElement fTraceElement;
    private String fImportName;
    private String fTraceType;

    public TracePackageTraceElement(TracePackageElement parent, TmfTraceElement traceElement) {
        super(parent);
        this.fTraceElement = traceElement;
        this.fImportName = null;
        this.fTraceType = null;
    }

    public TracePackageTraceElement(TracePackageElement parent, String importName, String traceType) {
        super(parent);
        this.fImportName = importName;
        this.fTraceElement = null;
        this.fTraceType = traceType;
    }

    @Override
    public String getText() {
        return this.fTraceElement != null ? this.fTraceElement.getElementPath() : this.getDestinationElementPath();
    }

    public String getDestinationElementPath() {
        String traceName = this.getImportName();
        TracePackageElement[] tracePackageElementArray = this.getChildren();
        int n = tracePackageElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            TracePackageElement element = tracePackageElementArray[n2];
            if (element instanceof TracePackageFilesElement) {
                TracePackageFilesElement tracePackageFilesElement = (TracePackageFilesElement)element;
                String fileName = tracePackageFilesElement.getFileName();
                String parentDir = TracePackageTraceElement.removeLastSegment(fileName);
                return TracePackageTraceElement.append(parentDir, traceName);
            }
            ++n2;
        }
        return traceName;
    }

    private static String removeLastSegment(String str) {
        String ret = TracePackageTraceElement.removeAllTrailing(str, '/');
        int lastIndexOf = ret.lastIndexOf(47);
        if (lastIndexOf != -1) {
            ret = ret.substring(0, lastIndexOf);
            ret = TracePackageTraceElement.removeAllTrailing(ret, '/');
        } else {
            ret = "";
        }
        return ret;
    }

    private static String removeAllTrailing(String str, char toRemove) {
        String ret = str;
        while (ret.endsWith(Character.toString(toRemove))) {
            ret = ret.substring(0, ret.length() - 1);
        }
        return ret;
    }

    private static String append(String path, String str) {
        if (!path.isEmpty()) {
            return String.valueOf(path) + '/' + str;
        }
        return str;
    }

    public TmfTraceElement getTraceElement() {
        return this.fTraceElement;
    }

    public void setImportName(String importName) {
        this.fImportName = importName;
    }

    public String getImportName() {
        return this.fImportName;
    }

    public String getTraceType() {
        return this.fTraceType;
    }

    public void setTraceType(String traceType) {
        this.fTraceType = traceType;
    }

    @Override
    public Image getImage() {
        TmfNavigatorLabelProvider tmfNavigatorLabelProvider = new TmfNavigatorLabelProvider();
        return tmfNavigatorLabelProvider.getImage(this.fTraceElement);
    }
}

