/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor.hyperlink;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.linuxtools.internal.rpm.ui.editor.UiUtils;
import org.eclipse.linuxtools.internal.rpm.ui.editor.hyperlink.SourcesFileCreateHyperlink;
import org.eclipse.linuxtools.internal.rpm.ui.editor.hyperlink.SourcesFileDownloadHyperlink;
import org.eclipse.linuxtools.internal.rpm.ui.editor.hyperlink.SourcesFileHyperlink;
import org.eclipse.linuxtools.rpm.ui.editor.SpecfileEditor;
import org.eclipse.linuxtools.rpm.ui.editor.utils.RPMUtils;
import org.eclipse.ui.part.FileEditorInput;

public class SourcesFileHyperlinkDetector
extends AbstractHyperlinkDetector {
    private SpecfileEditor editor;
    private static final String PATCH_IDENTIFIER = "Patch";
    private static final String SOURCE_IDENTIFIER = "Source";
    private static final String URL_IDENTIFIER = "URL";

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        String line;
        IRegion lineInfo;
        if (region == null || textViewer == null) {
            return null;
        }
        if (this.editor == null) {
            this.editor = (SpecfileEditor)((Object)this.getAdapter(SpecfileEditor.class));
            if (this.editor == null) {
                return null;
            }
        }
        IDocument document = textViewer.getDocument();
        int offset = region.getOffset();
        if (document == null) {
            return null;
        }
        try {
            lineInfo = document.getLineInformationOfOffset(offset);
            line = document.get(lineInfo.getOffset(), lineInfo.getLength());
        }
        catch (BadLocationException ex) {
            return null;
        }
        ArrayList<Object> tempHList = new ArrayList<Object>();
        if (this.editor.getEditorInput() instanceof FileEditorInput) {
            IFile original = ((FileEditorInput)this.editor.getEditorInput()).getFile();
            if (line.startsWith(SOURCE_IDENTIFIER) || line.startsWith(PATCH_IDENTIFIER) || line.startsWith(URL_IDENTIFIER)) {
                int delimiterIndex = line.indexOf(58) + 1;
                String identifierValue = line.substring(delimiterIndex).trim();
                boolean validURL = RPMUtils.isValidUrl(identifierValue);
                String fileName = validURL ? RPMUtils.getURLFilename(identifierValue) : identifierValue;
                String resolvedFileName = UiUtils.resolveDefines(this.editor.getSpecfile(), fileName);
                boolean fileExists = RPMUtils.fileExistsInSources(original, resolvedFileName);
                if (region.getOffset() > lineInfo.getOffset() + line.indexOf(identifierValue)) {
                    Region fileNameRegion = new Region(lineInfo.getOffset() + line.indexOf(identifierValue), identifierValue.length());
                    if (fileExists) {
                        tempHList.add(new SourcesFileHyperlink(original, resolvedFileName, (IRegion)fileNameRegion));
                    } else if (line.startsWith(PATCH_IDENTIFIER) && !identifierValue.endsWith("/")) {
                        tempHList.add(new SourcesFileCreateHyperlink(original, resolvedFileName, (IRegion)fileNameRegion));
                    }
                    if (validURL && !identifierValue.endsWith("/")) {
                        tempHList.add(new SourcesFileDownloadHyperlink(original, UiUtils.resolveDefines(this.editor.getSpecfile(), identifierValue), (IRegion)fileNameRegion));
                    }
                }
            }
        }
        return tempHList.isEmpty() ? null : tempHList.toArray(new IHyperlink[tempHList.size()]);
    }

    public void setEditor(SpecfileEditor editor) {
        this.editor = editor;
    }
}

