/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnuarmeclipse.packs.core.data;

import ilg.gnuarmeclipse.packs.core.Preferences;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.IPreferenceStore;

public class PacksStorage {
    public static final String CACHE_FOLDER = ".cache";
    public static final String CONTENT_FILE_NAME_PREFIX = ".content_";
    public static final String CONTENT_FILE_NAME_SUFFIX = ".xml";
    public static final String CONTENT_XML_VERSION = "1.1";
    public static final String INSTALLED_DEVICES_FILE_NAME = ".installed_devices_boards_books.xml";
    private static IPath fgFolderPath = null;

    public static File getFileObject(String name) throws IOException {
        IPath path = PacksStorage.getFolderPath().append(name);
        File file = path.toFile();
        if (file == null) {
            throw new IOException(String.valueOf(name) + " File object null.");
        }
        return file;
    }

    public static File getCachedFileObject(String name) throws IOException {
        IPath path = PacksStorage.getFolderPath().append(CACHE_FOLDER).append(name);
        File file = path.toFile();
        if (file == null) {
            throw new IOException(String.valueOf(name) + " File object null.");
        }
        return file;
    }

    public static File getPackageFileObject(String vendor, String packageName, String version, String name) throws IOException {
        IPath path = PacksStorage.getFolderPath().append(vendor).append(packageName).append(version).append(name);
        File file = path.toFile();
        if (file == null) {
            throw new IOException(String.valueOf(name) + " File object null.");
        }
        return file;
    }

    public static synchronized IPath getFolderPath() throws IOException {
        if (fgFolderPath == null) {
            fgFolderPath = new Path(PacksStorage.getFolderPathString());
        }
        return fgFolderPath;
    }

    public static String getFolderPathString() throws IOException {
        IPreferenceStore store = Preferences.getPreferenceStore();
        String folderPath = store.getString("packs.folder.path").trim();
        if (folderPath == null) {
            throw new IOException("Missing folder path.");
        }
        if (folderPath.endsWith(String.valueOf('/'))) {
            folderPath = folderPath.substring(0, folderPath.length() - 1);
        }
        if (folderPath.length() == 0) {
            throw new IOException("Missing folder path.");
        }
        return folderPath;
    }

    public static String makeCachedPdscName(String pdscName, String version) {
        String s = pdscName;
        int ix = s.lastIndexOf(46);
        if (ix > 0) {
            s = String.valueOf(s.substring(0, ix)) + "." + version + s.substring(ix);
        }
        return s;
    }
}

