/*
 * Decompiled with CFR 0.152.
 */
package com.nuvoton.debug.gdbjtag.nulink.ui;

import com.nuvoton.debug.gdbjtag.nulink.Activator;
import com.nuvoton.debug.gdbjtag.nulink.DefaultPreferences;
import com.nuvoton.debug.gdbjtag.nulink.PersistentPreferences;
import com.nuvoton.debug.gdbjtag.nulink.ui.Messages;
import com.nuvoton.debug.gdbjtag.nulink.ui.TabStartup;
import ilg.gnuarmeclipse.core.EclipseUtils;
import java.io.File;
import org.eclipse.cdt.debug.gdbjtag.ui.GDBJtagImages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;

public class TabDebugger
extends AbstractLaunchConfigurationTab {
    private static final String TAB_NAME = "Debugger";
    private static final String TAB_ID = "com.nuvoton.debug.gdbjtag.nulink.ui.debuggertab";
    private Button fDoStartGdbServer;
    private Text fGdbClientExecutable;
    private Text fGdbClientGdbPort;
    private Text fGdbClientOtherOptions;
    private Text fGdbClientOtherCommands;
    private Text fTargetIpAddress;
    private Text fTargetPortNumber;
    private Text fGdbServerGdbPort;
    private Text fGdbServerTelnetPort;
    private static Text fGdbServerExecutable;
    private Button fGdbServerBrowseButton;
    private Button fGdbServerVariablesButton;
    private static Text fGdbServerOtherOptions;
    private Button fDoGdbServerAllocateConsole;
    private Button fDoGdbServerAllocateTelnetConsole;
    protected Button fUpdateThreadlistOnSuspend;
    private static final String GDB_SERVER_OTHER_M0 = "-f ../scripts/interface/nulink.cfg -f ../scripts/target/numicroM0.cfg\n";
    private static final String GDB_SERVER_OTHER_M4 = "-f ../scripts/interface/nulink.cfg -f ../scripts/target/numicroM4.cfg\n";
    private static final String GDB_SERVER_OTHER_M23 = "-f ../scripts/interface/nulink.cfg -f ../scripts/target/numicroM23.cfg\n";
    private static final String GDB_SERVER_OTHER_M23_NS = "-f ../scripts/interface/nulink.cfg -f ../scripts/target/numicroM23_NS.cfg\n";
    private static final String GDB_SERVER_OTHER_MA35D1 = "-f ../scripts/interface/cmsis-dap.cfg -f ../scripts/target/numicroMA35D1.cfg\n";

    protected TabDebugger(TabStartup tabStartup) {
    }

    public static void putGdbServerOtherOptions(String value) {
        String currentOption = fGdbServerOtherOptions.getText();
        String currentGdbServerExecutable = fGdbServerExecutable.getText();
        if (currentOption.indexOf("numicro") < 0) {
            if (value.equals("M23")) {
                fGdbServerOtherOptions.setText(GDB_SERVER_OTHER_M23);
            } else if (value.equals("M23_NS")) {
                fGdbServerOtherOptions.setText(GDB_SERVER_OTHER_M23_NS);
            } else if (value.equals("M4")) {
                fGdbServerOtherOptions.setText(GDB_SERVER_OTHER_M4);
            } else if (value.equals("MA35D1")) {
                fGdbServerOtherOptions.setText(GDB_SERVER_OTHER_MA35D1);
            } else {
                fGdbServerOtherOptions.setText(GDB_SERVER_OTHER_M0);
            }
        } else {
            String newOption = currentOption;
            String newGdbServerExecutable = currentGdbServerExecutable;
            if (currentOption.indexOf("numicro.cfg") > 0) {
                newOption = currentOption.replace("numicro.cfg", "numicro" + value + ".cfg");
            } else if (currentOption.indexOf("numicroM0.cfg") > 0) {
                newOption = currentOption.replace("numicroM0.cfg", "numicro" + value + ".cfg");
            } else if (currentOption.indexOf("numicroM4.cfg") > 0) {
                newOption = currentOption.replace("numicroM4.cfg", "numicro" + value + ".cfg");
            } else if (currentOption.indexOf("numicroM23.cfg") > 0) {
                newOption = currentOption.replace("numicroM23.cfg", "numicro" + value + ".cfg");
            } else if (currentOption.indexOf("numicroM23_NS.cfg") > 0) {
                newOption = currentOption.replace("numicroM23_NS.cfg", "numicro" + value + ".cfg");
            } else if (currentOption.indexOf("numicroMA35D1.cfg") > 0) {
                newOption = currentOption.replace("numicroMA35D1.cfg", "numicro" + value + ".cfg");
            }
            if (newOption.indexOf("A35") > 0) {
                newOption = newOption.replace("nulink.cfg", "cmsis-dap.cfg");
                newGdbServerExecutable = currentGdbServerExecutable.replace("${openocd_nulink_executable}", "openocd_cmsis-dap.exe");
                newGdbServerExecutable = newGdbServerExecutable.replace("openocd.exe", "openocd_cmsis-dap.exe");
            } else {
                newOption = newOption.replace("cmsis-dap.cfg", "nulink.cfg");
                newGdbServerExecutable = currentGdbServerExecutable.replace("openocd_cmsis-dap.exe", "${openocd_nulink_executable}");
            }
            fGdbServerOtherOptions.setText(newOption);
            fGdbServerExecutable.setText(newGdbServerExecutable);
        }
    }

    public String getName() {
        return TAB_NAME;
    }

    public Image getImage() {
        return GDBJtagImages.getDebuggerTabImage();
    }

    public void createControl(Composite parent) {
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        this.setControl((Control)sc);
        Composite comp = new Composite((Composite)sc, 0);
        sc.setContent((Control)comp);
        GridLayout layout = new GridLayout();
        comp.setLayout((Layout)layout);
        this.createGdbServerGroup(comp);
        this.createGdbClientControls(comp);
        this.createRemoteControl(comp);
        this.fUpdateThreadlistOnSuspend = new Button(comp, 32);
        this.fUpdateThreadlistOnSuspend.setText(Messages.getString("DebuggerTab.update_thread_list_on_suspend_Text"));
        this.fUpdateThreadlistOnSuspend.setToolTipText(Messages.getString("DebuggerTab.update_thread_list_on_suspend_ToolTipText"));
        Link restoreDefaults = new Link(comp, 0);
        restoreDefaults.setText(Messages.getString("DebuggerTab.restoreDefaults_Link"));
        restoreDefaults.setToolTipText(Messages.getString("DebuggerTab.restoreDefaults_ToolTipText"));
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 131072;
        gd.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns;
        restoreDefaults.setLayoutData((Object)gd);
        this.fUpdateThreadlistOnSuspend.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.updateLaunchConfigurationDialog();
            }
        });
        restoreDefaults.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TabDebugger.this.initializeFromDefaults();
                TabDebugger.this.scheduleUpdateJob();
            }
        });
    }

    private void browseButtonSelected(String title, Text text) {
        FileDialog dialog = new FileDialog(this.getShell(), 0);
        dialog.setText(title);
        String str = text.getText().trim();
        int lastSeparatorIndex = str.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(str.substring(0, lastSeparatorIndex));
        }
        if ((str = dialog.open()) != null) {
            text.setText(str);
        }
    }

    private void variablesButtonSelected(Text text) {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
        if (dialog.open() == 0) {
            text.insert(dialog.getVariableExpression());
        }
    }

    private void createGdbServerGroup(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        group.setText(Messages.getString("DebuggerTab.gdbServerGroup_Text"));
        Composite comp = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.numColumns = 5;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        gd = new GridData(768);
        comp.setLayoutData((Object)gd);
        this.fDoStartGdbServer = new Button(comp, 32);
        this.fDoStartGdbServer.setText(Messages.getString("DebuggerTab.doStartGdbServer_Text"));
        this.fDoStartGdbServer.setToolTipText(Messages.getString("DebuggerTab.doStartGdbServer_ToolTipText"));
        gd = new GridData();
        gd.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns;
        this.fDoStartGdbServer.setLayoutData((Object)gd);
        Label label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.gdbServerExecutable_Label"));
        label.setToolTipText(Messages.getString("DebuggerTab.gdbServerExecutable_ToolTipText"));
        Composite local = new Composite(comp, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        local.setLayout((Layout)layout);
        gd = new GridData(768);
        gd.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        local.setLayoutData((Object)gd);
        fGdbServerExecutable = new Text(local, 2052);
        gd = new GridData(768);
        fGdbServerExecutable.setLayoutData((Object)gd);
        this.fGdbServerBrowseButton = new Button(local, 0);
        this.fGdbServerBrowseButton.setText(Messages.getString("DebuggerTab.gdbServerExecutableBrowse"));
        this.fGdbServerVariablesButton = new Button(local, 0);
        this.fGdbServerVariablesButton.setText(Messages.getString("DebuggerTab.gdbServerExecutableVariable"));
        label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.gdbServerGdbPort_Label"));
        label.setToolTipText(Messages.getString("DebuggerTab.gdbServerGdbPort_ToolTipText"));
        this.fGdbServerGdbPort = new Text(comp, 2052);
        gd = new GridData();
        gd.widthHint = 70;
        gd.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        this.fGdbServerGdbPort.setLayoutData((Object)gd);
        label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.gdbServerTelnetPort_Label"));
        label.setToolTipText(Messages.getString("DebuggerTab.gdbServerTelnetPort_ToolTipText"));
        this.fGdbServerTelnetPort = new Text(comp, 2052);
        gd = new GridData();
        gd.widthHint = 70;
        gd.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        this.fGdbServerTelnetPort.setLayoutData((Object)gd);
        label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.gdbServerOther_Label"));
        label.setToolTipText(Messages.getString("DebuggerTab.gdbServerOther_ToolTipText"));
        gd = new GridData();
        gd.verticalAlignment = 128;
        label.setLayoutData((Object)gd);
        fGdbServerOtherOptions = new Text(comp, 2626);
        gd = new GridData(4, 4, true, true);
        gd.heightHint = 60;
        gd.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        fGdbServerOtherOptions.setLayoutData((Object)gd);
        local = new Composite(comp, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.makeColumnsEqualWidth = true;
        local.setLayout((Layout)layout);
        gd = new GridData(768);
        gd.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns;
        local.setLayoutData((Object)gd);
        this.fDoGdbServerAllocateConsole = new Button(local, 32);
        this.fDoGdbServerAllocateConsole.setText(Messages.getString("DebuggerTab.gdbServerAllocateConsole_Label"));
        this.fDoGdbServerAllocateConsole.setToolTipText(Messages.getString("DebuggerTab.gdbServerAllocateConsole_ToolTipText"));
        gd = new GridData(768);
        this.fDoGdbServerAllocateConsole.setLayoutData((Object)gd);
        this.fDoGdbServerAllocateTelnetConsole = new Button(local, 32);
        this.fDoGdbServerAllocateTelnetConsole.setText(Messages.getString("DebuggerTab.gdbServerAllocateTelnetConsole_Label"));
        this.fDoGdbServerAllocateTelnetConsole.setToolTipText(Messages.getString("DebuggerTab.gdbServerAllocateTelnetConsole_ToolTipText"));
        gd = new GridData(768);
        this.fDoGdbServerAllocateTelnetConsole.setLayoutData((Object)gd);
        this.fDoGdbServerAllocateTelnetConsole.setEnabled(false);
        ModifyListener scheduleUpdateJobModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        };
        SelectionAdapter scheduleUpdateJobSelectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        };
        this.fDoStartGdbServer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.doStartGdbServerChanged();
                if (TabDebugger.this.fDoStartGdbServer.getSelection()) {
                    TabDebugger.this.fTargetIpAddress.setText("localhost");
                }
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        fGdbServerExecutable.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.fGdbServerBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.browseButtonSelected(Messages.getString("DebuggerTab.gdbServerExecutableBrowse_Title"), fGdbServerExecutable);
            }
        });
        this.fGdbServerVariablesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.variablesButtonSelected(fGdbServerExecutable);
            }
        });
        this.fGdbServerGdbPort.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.fGdbClientGdbPort.setText(TabDebugger.this.fGdbServerGdbPort.getText());
                TabDebugger.this.fTargetPortNumber.setText(TabDebugger.this.fGdbServerGdbPort.getText());
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.fGdbServerTelnetPort.addModifyListener(scheduleUpdateJobModifyListener);
        fGdbServerOtherOptions.addModifyListener(scheduleUpdateJobModifyListener);
        this.fDoGdbServerAllocateConsole.addSelectionListener((SelectionListener)scheduleUpdateJobSelectionAdapter);
        this.fDoGdbServerAllocateTelnetConsole.addSelectionListener((SelectionListener)scheduleUpdateJobSelectionAdapter);
    }

    private void createGdbClientControls(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.getString("DebuggerTab.gdbSetupGroup_Text"));
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        Composite comp = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        gd = new GridData(768);
        comp.setLayoutData((Object)gd);
        Label label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.gdbCommand_Label"));
        label.setToolTipText(Messages.getString("DebuggerTab.gdbCommand_ToolTipText"));
        Composite local = new Composite(comp, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        local.setLayout((Layout)layout);
        gd = new GridData(768);
        local.setLayoutData((Object)gd);
        this.fGdbClientExecutable = new Text(local, 2052);
        gd = new GridData(768);
        this.fGdbClientExecutable.setLayoutData((Object)gd);
        Button browseButton = new Button(local, 0);
        browseButton.setText(Messages.getString("DebuggerTab.gdbCommandBrowse"));
        Button variableButton = new Button(local, 0);
        variableButton.setText(Messages.getString("DebuggerTab.gdbCommandVariable"));
        label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.gdbCommandGdbPort_Label"));
        label.setToolTipText(Messages.getString("DebuggerTab.gdbCommandGdbPort_ToolTipText"));
        this.fGdbClientGdbPort = new Text(comp, 2052);
        gd = new GridData();
        gd.widthHint = 70;
        gd.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        this.fGdbClientGdbPort.setLayoutData((Object)gd);
        label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.gdbOtherOptions_Label"));
        label.setToolTipText(Messages.getString("DebuggerTab.gdbOtherOptions_ToolTipText"));
        gd = new GridData();
        label.setLayoutData((Object)gd);
        this.fGdbClientOtherOptions = new Text(comp, 2052);
        gd = new GridData(768);
        this.fGdbClientOtherOptions.setLayoutData((Object)gd);
        label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.gdbOtherCommands_Label"));
        label.setToolTipText(Messages.getString("DebuggerTab.gdbOtherCommands_ToolTipText"));
        gd = new GridData();
        gd.verticalAlignment = 128;
        label.setLayoutData((Object)gd);
        this.fGdbClientOtherCommands = new Text(comp, 2626);
        gd = new GridData(4, 4, true, true);
        gd.heightHint = 60;
        this.fGdbClientOtherCommands.setLayoutData((Object)gd);
        this.fGdbClientExecutable.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.fGdbClientGdbPort.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.fGdbClientOtherOptions.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.fGdbClientOtherCommands.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.browseButtonSelected(Messages.getString("DebuggerTab.gdbCommandBrowse_Title"), TabDebugger.this.fGdbClientExecutable);
            }
        });
        variableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.variablesButtonSelected(TabDebugger.this.fGdbClientExecutable);
            }
        });
    }

    private void createRemoteControl(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.getString("DebuggerTab.remoteGroup_Text"));
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        Composite comp = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        gd = new GridData(768);
        comp.setLayoutData((Object)gd);
        Label label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.ipAddressLabel"));
        this.fTargetIpAddress = new Text(comp, 2048);
        gd = new GridData();
        gd.widthHint = 125;
        this.fTargetIpAddress.setLayoutData((Object)gd);
        label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.portNumberLabel"));
        this.fTargetPortNumber = new Text(comp, 2048);
        gd = new GridData();
        gd.widthHint = 125;
        this.fTargetPortNumber.setLayoutData((Object)gd);
        this.fTargetIpAddress.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.fTargetPortNumber.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = Character.isDigit(e.character) || Character.isISOControl(e.character);
            }
        });
        this.fTargetPortNumber.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        });
    }

    private void doStartGdbServerChanged() {
        boolean enabled = this.fDoStartGdbServer.getSelection();
        fGdbServerExecutable.setEnabled(enabled);
        this.fGdbServerBrowseButton.setEnabled(enabled);
        this.fGdbServerVariablesButton.setEnabled(enabled);
        fGdbServerOtherOptions.setEnabled(enabled);
        this.fGdbServerGdbPort.setEnabled(enabled);
        this.fGdbServerTelnetPort.setEnabled(enabled);
        if (EclipseUtils.isWindows()) {
            this.fDoGdbServerAllocateConsole.setEnabled(false);
        } else {
            this.fDoGdbServerAllocateConsole.setEnabled(enabled);
        }
        this.fTargetIpAddress.setEnabled(!enabled);
        this.fTargetPortNumber.setEnabled(!enabled);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            Boolean booleanDefault = PersistentPreferences.getGdbServerDoStart();
            this.fDoStartGdbServer.setSelection(configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.doStartGdbServer", booleanDefault.booleanValue()));
            String stringDefault = PersistentPreferences.getGdbServerExecutable();
            fGdbServerExecutable.setText(configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.gdbServerExecutable", stringDefault));
            this.fGdbServerGdbPort.setText(Integer.toString(configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.gdbServerGdbPortNumber", 3333)));
            this.fGdbServerTelnetPort.setText(Integer.toString(configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.gdbServerTelnetPortNumber", 4444)));
            stringDefault = PersistentPreferences.getGdbServerOtherOptions();
            fGdbServerOtherOptions.setText(configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.gdbServerOther", stringDefault));
            if (EclipseUtils.isWindows()) {
                this.fDoGdbServerAllocateConsole.setSelection(true);
            } else {
                this.fDoGdbServerAllocateConsole.setSelection(configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.doGdbServerAllocateConsole", true));
            }
            this.fDoGdbServerAllocateTelnetConsole.setSelection(configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.doGdbServerAllocateTelnetConsole", false));
            stringDefault = PersistentPreferences.getGdbClientExecutable();
            String gdbCommandAttr = configuration.getAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", stringDefault);
            this.fGdbClientExecutable.setText(gdbCommandAttr);
            this.fGdbClientGdbPort.setText(Integer.toString(configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.gdbClientGdbPortNumber", 3333)));
            stringDefault = PersistentPreferences.getGdbClientOtherOptions();
            this.fGdbClientOtherOptions.setText(configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.gdbClientOtherOptions", stringDefault));
            stringDefault = PersistentPreferences.getGdbClientCommands();
            this.fGdbClientOtherCommands.setText(configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.gdbClientOtherCommands", stringDefault));
            this.fTargetIpAddress.setText(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.ipAddress", "localhost"));
            int storedPort = 0;
            storedPort = configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.portNumber", 0);
            if (storedPort <= 0 || 65535 < storedPort) {
                storedPort = 3333;
            }
            String portString = Integer.toString(storedPort);
            this.fTargetPortNumber.setText(portString);
            this.doStartGdbServerChanged();
            boolean updateThreadsOnSuspend = configuration.getAttribute("org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", false);
            this.fUpdateThreadlistOnSuspend.setSelection(updateThreadsOnSuspend);
        }
        catch (CoreException e) {
            Activator.log((IStatus)e.getStatus());
        }
    }

    public void initializeFromDefaults() {
        this.fDoStartGdbServer.setSelection(true);
        String stringDefault = DefaultPreferences.getGdbServerExecutable();
        fGdbServerExecutable.setText(stringDefault);
        this.fGdbServerGdbPort.setText(Integer.toString(3333));
        this.fGdbServerTelnetPort.setText(Integer.toString(4444));
        stringDefault = GDB_SERVER_OTHER_M4;
        fGdbServerOtherOptions.setText(stringDefault);
        if (EclipseUtils.isWindows()) {
            this.fDoGdbServerAllocateConsole.setSelection(true);
        } else {
            this.fDoGdbServerAllocateConsole.setSelection(true);
        }
        this.fDoGdbServerAllocateTelnetConsole.setSelection(false);
        stringDefault = DefaultPreferences.getGdbClientExecutable();
        this.fGdbClientExecutable.setText(stringDefault);
        this.fGdbClientGdbPort.setText(Integer.toString(3333));
        this.fGdbClientOtherOptions.setText("");
        this.fGdbClientOtherCommands.setText("set mem inaccessible-by-default off\n");
        this.fTargetIpAddress.setText("localhost");
        String portString = Integer.toString(3333);
        this.fTargetPortNumber.setText(portString);
        this.doStartGdbServerChanged();
        this.fUpdateThreadlistOnSuspend.setSelection(false);
    }

    public String getId() {
        return TAB_ID;
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("TabDebugger: activated() " + workingCopy.getName());
        }
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("TabDebugger: deactivated() " + workingCopy.getName());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.jtagDevice", "GNU ARM OpenOCD");
        boolean booleanValue = this.fDoStartGdbServer.getSelection();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.doStartGdbServer", booleanValue);
        PersistentPreferences.putGdbServerDoStart(booleanValue);
        String stringValue = fGdbServerExecutable.getText().trim();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.gdbServerExecutable", stringValue);
        PersistentPreferences.putGdbServerExecutable(stringValue);
        int port = Integer.parseInt(this.fGdbServerGdbPort.getText().trim());
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.gdbServerGdbPortNumber", port);
        port = Integer.parseInt(this.fGdbServerTelnetPort.getText().trim());
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.gdbServerTelnetPortNumber", port);
        stringValue = fGdbServerOtherOptions.getText().trim();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.gdbServerOther", stringValue);
        PersistentPreferences.putGdbServerOtherOptions(stringValue);
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.doGdbServerAllocateConsole", this.fDoGdbServerAllocateConsole.getSelection());
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.doGdbServerAllocateTelnetConsole", this.fDoGdbServerAllocateTelnetConsole.getSelection());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useRemoteTarget", true);
        stringValue = this.fGdbClientExecutable.getText().trim();
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", stringValue);
        PersistentPreferences.putGdbClientExecutable(stringValue);
        stringValue = this.fGdbClientOtherOptions.getText().trim();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.gdbClientOtherOptions", stringValue);
        PersistentPreferences.putGdbClientOtherOptions(stringValue);
        stringValue = this.fGdbClientOtherCommands.getText().trim();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.gdbClientOtherCommands", stringValue);
        PersistentPreferences.putGdbClientCommands(stringValue);
        if (this.fDoStartGdbServer.getSelection()) {
            configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.ipAddress", "localhost");
            try {
                port = Integer.parseInt(this.fGdbClientGdbPort.getText().trim());
                configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.gdbClientGdbPortNumber", port);
                configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.portNumber", port);
            }
            catch (NumberFormatException e) {
                Activator.log((Throwable)e);
            }
        } else {
            String ip = this.fTargetIpAddress.getText().trim();
            configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.ipAddress", ip);
            try {
                int port2 = Integer.valueOf(this.fTargetPortNumber.getText().trim());
                configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.portNumber", port2);
            }
            catch (NumberFormatException e) {
                Activator.log((Throwable)e);
            }
        }
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", this.fUpdateThreadlistOnSuspend.getSelection());
        PersistentPreferences.flush();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.jtagDevice", "GNU ARM OpenOCD");
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", false);
        boolean defaultBoolean = PersistentPreferences.getGdbServerDoStart();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.doStartGdbServer", defaultBoolean);
        String defaultString = PersistentPreferences.getGdbServerExecutable();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.gdbServerExecutable", defaultString);
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.gdbServerConnectionAddress", "");
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.gdbServerGdbPortNumber", 3333);
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.gdbServerTelnetPortNumber", 4444);
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.gdbServerLog", "");
        defaultString = PersistentPreferences.getGdbServerOtherOptions();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.gdbServerOther", defaultString);
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.doGdbServerAllocateConsole", true);
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.doGdbServerAllocateTelnetConsole", false);
        defaultString = PersistentPreferences.getGdbClientExecutable();
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", defaultString);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useRemoteTarget", true);
        defaultString = PersistentPreferences.getGdbClientOtherOptions();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.gdbClientOtherOptions", defaultString);
        defaultString = PersistentPreferences.getGdbClientCommands();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.gdbClientOtherCommands", defaultString);
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", false);
    }
}

