/*
 * Decompiled with CFR 0.152.
 */
package com.nuvoton.debug.gdbjtag.nulink.ui;

import com.nuvoton.debug.gdbjtag.nulink.Activator;
import com.nuvoton.debug.gdbjtag.nulink.PersistentPreferences;
import com.nuvoton.debug.gdbjtag.nulink.ui.IniFile;
import com.nuvoton.debug.gdbjtag.nulink.ui.Messages;
import com.nuvoton.debug.gdbjtag.nulink.ui.TabDebugger;
import ilg.gnuarmeclipse.debug.gdbjtag.DebugUtils;
import ilg.gnuarmeclipse.managedbuild.cross.Option;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.gdbjtag.ui.GDBJtagImages;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class TabStartup
extends AbstractLaunchConfigurationTab {
    private static final String TAB_NAME = "Startup";
    private static final String TAB_ID = "com.nuvoton.debug.gdbjtag.nulink.ui.startuptab";
    private Text fInitCommands;
    private Button fDoFirstReset;
    private Text fFirstResetType;
    private Button fDoSecondReset;
    private Text fSecondResetType;
    private Label fSecondResetWarning;
    private Button fEnableSemihosting;
    private Button fChipErase;
    private Combo fChipSeries = null;
    private Label fLabelTargetChip;
    private Text fTargetChip = null;
    private Button fNonSecure;
    private Button fWriteConfig;
    private Label fLabelConfig0;
    private Label fLabelConfig1;
    private Label fLabelConfig2;
    private Label fLabelConfig3;
    private Text fInitialConfig0;
    private Text fInitialConfig1;
    private Text fInitialConfig2;
    private Text fInitialConfig3;
    private Button fWriteLock;
    private Label fLabellNSCBA;
    private Label fLabelSCRLOCK;
    private Label fLabelARLOCK;
    private Text fInitialNSCBA;
    private Text fInitialSCRLOCK;
    private Text fInitialARLOCK;
    private Button fLoadExecutableF;
    private Text fImageFileNameF;
    private Button fImageFileBrowseWsF;
    private Button fImageFileBrowseF;
    private Text fImageOffsetF;
    private Button fLoadExecutable;
    private Text fImageFileName;
    private Button fImageFileBrowseWs;
    private Button fImageFileBrowse;
    private Text fImageOffset;
    private Button fLoadSymbols;
    private Text fSymbolsFileName;
    private Button fSymbolsFileBrowseWs;
    private Button fSymbolsFileBrowse;
    private Text fSymbolsOffset;
    private Button fSetPcRegister;
    private Text fPcRegister;
    private Button fSetStopAt;
    private Text fStopAt;
    private Text fRunCommands;
    private Button fDoContinue;
    private Button fDoDebugInRam;
    private Button fUseProjectBinaryForImageF;
    private Button fUseFileForImageF;
    private Button fUseProjectBinaryForImage;
    private Button fUseFileForImage;
    private Button fUseProjectBinaryForSymbols;
    private Button fUseFileForSymbols;
    private Label fImageOffsetLabelF;
    private Label fImageOffsetLabel;
    private Label fSymbolsOffsetLabel;
    private Label fProjBinaryLabel1;
    private Label fProjBinaryLabel2;
    private Label fProjBinaryLabelF;
    private String fSavedProgName = null;
    private String fSavedProgNameF = null;

    public static String getManagedOutputName(String programName) {
        String managedOutputName = null;
        if (programName == null) {
            return "hex";
        }
        int lastSlash = programName.lastIndexOf(92);
        if (lastSlash >= 0) {
            programName = programName.substring(lastSlash + 1);
        }
        if ((lastSlash = programName.lastIndexOf(47)) >= 0) {
            programName = programName.substring(lastSlash + 1);
        }
        programName = programName.substring(0, programName.lastIndexOf(46));
        IProject projectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(programName);
        try {
            IConfiguration[] projectConfigs;
            IConfiguration[] iConfigurationArray = projectConfigs = ManagedBuildManager.getBuildInfo((IResource)projectHandle).getManagedProject().getConfigurations();
            int n = projectConfigs.length;
            int n2 = 0;
            while (n2 < n) {
                ITool[] tools;
                IConfiguration config = iConfigurationArray[n2];
                ITool[] iToolArray = tools = config.getTools();
                int n3 = tools.length;
                int n4 = 0;
                while (n4 < n3) {
                    ITool tool = iToolArray[n4];
                    String value = null;
                    IOption option = tool.getOptionBySuperClassId(Option.OPTION_CREATEFLASH_CHOICE);
                    if (option != null) {
                        value = (String)option.getValue();
                    }
                    if (value != null && managedOutputName == null) {
                        if (value.endsWith(".ihex")) {
                            managedOutputName = "hex";
                        } else if (value.endsWith(".srec")) {
                            managedOutputName = "srec";
                        } else if (value.endsWith(".symbolsrec")) {
                            managedOutputName = "symbolsrec";
                        } else if (value.endsWith(".binary")) {
                            managedOutputName = "bin";
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (NullPointerException nullPointerException) {
            managedOutputName = "elf";
        }
        return managedOutputName;
    }

    public static boolean isNumeric(String cadena) {
        if (cadena.length() == 0 || cadena.charAt(0) != '-' && Character.digit(cadena.charAt(0), 16) == -1) {
            return false;
        }
        if (cadena.length() == 1 && cadena.charAt(0) == '-') {
            return false;
        }
        int i = 1;
        while (i < cadena.length()) {
            if (Character.digit(cadena.charAt(i), 16) == -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getInitialInitialConfig0() {
        return this.fInitialConfig0.getText();
    }

    public void putInitialInitialConfig0(String value) {
        this.fInitialConfig0.setText(value);
    }

    public String getInitialInitialConfig1() {
        return this.fInitialConfig1.getText();
    }

    public void putInitialInitialConfig1(String value) {
        this.fInitialConfig1.setText(value);
    }

    public String getInitialInitialConfig2() {
        return this.fInitialConfig2.getText();
    }

    public void putInitialInitialConfig2(String value) {
        this.fInitialConfig2.setText(value);
    }

    public String getInitialInitialConfig3() {
        return this.fInitialConfig3.getText();
    }

    public void putInitialInitialConfig3(String value) {
        this.fInitialConfig3.setText(value);
    }

    private int getStringArrayIndex(String[] arr, String value) {
        int k = -1;
        int i = 0;
        while (i < arr.length) {
            if (arr[i].equals(value)) {
                k = i;
                break;
            }
            ++i;
        }
        return k;
    }

    private IniFile getIniFromProgramPath(ILaunchConfiguration launchConfig) throws CoreException {
        ICProject cproject = CDebugUtils.verifyCProject((ILaunchConfiguration)launchConfig);
        IPath programPath = null;
        String programPathString = null;
        IniFile ini = null;
        if (cproject != null) {
            programPath = cproject.getProject().getLocation();
            if (programPath != null) {
                programPathString = programPath.toOSString();
                int lastSlash = programPathString.lastIndexOf(92);
                programPathString = lastSlash >= 0 ? String.valueOf(programPathString) + "\\preferences.ini" : String.valueOf(programPathString) + "/preferences.ini";
                try {
                    ini = new IniFile(programPathString);
                    return ini;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
        } else {
            programPath = CDebugUtils.verifyProgramPath((ILaunchConfiguration)launchConfig);
            if (programPath != null) {
                programPathString = programPath.toOSString();
                int lastSlash = programPathString.lastIndexOf(92);
                if (lastSlash >= 0) {
                    lastSlash = programPathString.substring(0, lastSlash).lastIndexOf(92);
                    programPathString = String.valueOf(programPathString.substring(0, lastSlash + 1)) + "preferences.ini";
                } else {
                    lastSlash = programPathString.lastIndexOf(47);
                    if (lastSlash >= 0) {
                        lastSlash = programPathString.substring(0, lastSlash).lastIndexOf(47);
                        programPathString = String.valueOf(programPathString.substring(0, lastSlash + 1)) + "preferences.ini";
                    }
                }
                try {
                    ini = new IniFile(programPathString);
                    return ini;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
        }
        return null;
    }

    private String updateDefaultConfig0(String defaultConfig0) {
        String commandStr1 = "";
        if (this.fTargetChip != null && (commandStr1 = this.fTargetChip.getText()).toUpperCase().indexOf("0X") == 0) {
            commandStr1 = commandStr1.substring(2);
        }
        if (this.fChipSeries != null && this.fTargetChip != null) {
            if (this.fChipSeries.getText().equals("NuMicro M4") && (commandStr1.toUpperCase().indexOf("M451") != -1 || TabStartup.isNumeric(commandStr1) && Integer.parseInt(commandStr1, 16) == 15)) {
                defaultConfig0 = "FFFEFFFF";
            } else if (this.fChipSeries.getText().equals("NuMicro M4") && (commandStr1.toUpperCase().indexOf("M4521") != -1 || TabStartup.isNumeric(commandStr1) && Integer.parseInt(commandStr1, 16) == 22)) {
                defaultConfig0 = "FFFEFFFF";
            }
        }
        return defaultConfig0;
    }

    private String updateDefaultConfig2(String defaultConfig2) {
        String commandStr1 = "";
        if (this.fTargetChip != null && (commandStr1 = this.fTargetChip.getText()).toUpperCase().indexOf("0X") == 0) {
            commandStr1 = commandStr1.substring(2);
        }
        if (this.fChipSeries != null && this.fTargetChip != null) {
            if (this.fChipSeries.getText().equals("NuMicro M0") && (commandStr1.toUpperCase().indexOf("NUC121") != -1 || commandStr1.toUpperCase().indexOf("NUC125") != -1 || TabStartup.isNumeric(commandStr1) && Integer.parseInt(commandStr1, 16) == 20)) {
                defaultConfig2 = "FFFFFF5A";
            } else if (this.fChipSeries.getText().equals("NuMicro M0") && (commandStr1.toUpperCase().indexOf("NANO103") != -1 || TabStartup.isNumeric(commandStr1) && Integer.parseInt(commandStr1, 16) == 19)) {
                defaultConfig2 = "FFFFFF5A";
            } else if (this.fChipSeries.getText().equals("NuMicro M0") && (commandStr1.toUpperCase().indexOf("MINI58") != -1 || TabStartup.isNumeric(commandStr1) && Integer.parseInt(commandStr1, 16) == 17)) {
                defaultConfig2 = "FFFFFF5A";
            } else if (this.fChipSeries.getText().equals("NuMicro M0") && (commandStr1.toUpperCase().indexOf("M030") != -1 || commandStr1.toUpperCase().indexOf("M031") != -1 || TabStartup.isNumeric(commandStr1) && (Integer.parseInt(commandStr1, 16) == 23 || Integer.parseInt(commandStr1, 16) == 24 || Integer.parseInt(commandStr1, 16) == 25 || Integer.parseInt(commandStr1, 16) == 26 || Integer.parseInt(commandStr1, 16) == 28 || Integer.parseInt(commandStr1, 16) == 29 || Integer.parseInt(commandStr1, 16) == 31 || Integer.parseInt(commandStr1, 16) == 33 || Integer.parseInt(commandStr1, 16) == 58))) {
                defaultConfig2 = "FFFFFF5A";
            } else if (this.fChipSeries.getText().equals("NuMicro M0") && (commandStr1.toUpperCase().indexOf("M0A21") != -1 || TabStartup.isNumeric(commandStr1) && Integer.parseInt(commandStr1, 16) == 32)) {
                defaultConfig2 = "FFFFFF5A";
            } else if (this.fChipSeries.getText().equals("NuMicro M23") && (commandStr1.toUpperCase().indexOf("M251") != -1 || commandStr1.toUpperCase().indexOf("M252") != -1 || commandStr1.toUpperCase().indexOf("M253") != -1 || commandStr1.toUpperCase().indexOf("M258") != -1 || TabStartup.isNumeric(commandStr1) && (Integer.parseInt(commandStr1, 16) == 46 || Integer.parseInt(commandStr1, 16) == 47 || Integer.parseInt(commandStr1, 16) == 48 || Integer.parseInt(commandStr1, 16) == 49 || Integer.parseInt(commandStr1, 16) == 51 || Integer.parseInt(commandStr1, 16) == 57))) {
                defaultConfig2 = "FFFFFF5A";
            } else if (this.fChipSeries.getText().equals("NuMicro M4") && (commandStr1.toUpperCase().indexOf("M471") != -1 || TabStartup.isNumeric(commandStr1) && Integer.parseInt(commandStr1, 16) == 34)) {
                defaultConfig2 = "FFFFFF5A";
            } else if (this.fChipSeries.getText().equals("NuMicro M4") && (commandStr1.toUpperCase().indexOf("M479") != -1 || TabStartup.isNumeric(commandStr1) && Integer.parseInt(commandStr1, 16) == 54)) {
                defaultConfig2 = "FFFF5A5A";
            } else if (this.fChipSeries.getText().equals("NuMicro M4") && (commandStr1.toUpperCase().indexOf("M480") != -1 || TabStartup.isNumeric(commandStr1) && Integer.parseInt(commandStr1, 16) == 52)) {
                defaultConfig2 = "FFFF5A5A";
            }
        }
        return defaultConfig2;
    }

    private void updateNUC400AEConfig3() {
        String commandStr1 = "";
        if (this.fTargetChip != null && (commandStr1 = this.fTargetChip.getText()).toUpperCase().indexOf("0X") == 0) {
            commandStr1 = commandStr1.substring(2);
        }
        if (!this.fChipSeries.getText().equals("NuMicro M4") || !commandStr1.toUpperCase().equals("NUC400AE") && (!TabStartup.isNumeric(commandStr1) || Integer.parseInt(commandStr1, 16) != 11) || this.fInitialConfig0.getText().equals("") || this.fInitialConfig1.getText().equals("") || this.fInitialConfig2.getText().equals("") || this.fInitialConfig3.getText().equals("")) {
            return;
        }
        long[] configValues012 = new long[]{Long.parseLong(this.fInitialConfig0.getText(), 16), Long.parseLong(this.fInitialConfig1.getText(), 16), Long.parseLong(this.fInitialConfig2.getText(), 16)};
        String configString3 = Long.toHexString(this.getCRC8(configValues012, 3)).toUpperCase();
        configString3 = configString3.substring(configString3.length() - 8);
        this.fInitialConfig3.setText(configString3);
    }

    private long getCRC8(long[] data, int count) {
        int[] crc = new int[]{255, 255, 255, 255};
        int byteIdx = 0;
        while (byteIdx < 4) {
            int localCount = 0;
            while (localCount < count) {
                int i = 128;
                while (i != 0) {
                    if ((crc[byteIdx] & 0x80) != 0) {
                        int n = byteIdx;
                        crc[n] = crc[n] * 2;
                        int n2 = byteIdx;
                        crc[n2] = crc[n2] ^ 7;
                    } else {
                        int n = byteIdx;
                        crc[n] = crc[n] * 2;
                    }
                    long inData = data[localCount] >> byteIdx * 8 & 0xFFL;
                    if ((inData & (long)i) != 0L) {
                        int n = byteIdx;
                        crc[n] = crc[n] ^ 7;
                    }
                    i /= 2;
                }
                ++localCount;
            }
            ++byteIdx;
        }
        return crc[0] & 0xFF | (crc[1] & 0xFF) << 8 | (crc[2] & 0xFF) << 16 | (crc[3] & 0xFF) << 24;
    }

    private boolean stringToBoolean(String data) {
        return !(data = data.toLowerCase()).equals("0") && !data.equals("false") && !data.equals("");
    }

    private String booleanToString(boolean data) {
        if (data) {
            return "1";
        }
        return "0";
    }

    private String stringConformToHex(String data) {
        int index = data.toLowerCase().indexOf("0x");
        if (index != -1) {
            data = data.substring(index + 2);
        }
        if (data.matches("^[0-9A-Fa-f//]+$")) {
            return data;
        }
        return "";
    }

    public String getName() {
        return TAB_NAME;
    }

    public Image getImage() {
        return GDBJtagImages.getStartupTabImage();
    }

    public void createControl(Composite parent) {
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        this.setControl((Control)sc);
        Composite comp = new Composite((Composite)sc, 0);
        sc.setContent((Control)comp);
        GridLayout layout = new GridLayout();
        comp.setLayout((Layout)layout);
        this.createInitGroup(comp);
        this.createLoadGroup(comp);
        this.createRunGroup(comp);
        Link restoreDefaults = new Link(comp, 0);
        restoreDefaults.setText(Messages.getString("DebuggerTab.restoreDefaults_Link"));
        restoreDefaults.setToolTipText(Messages.getString("DebuggerTab.restoreDefaults_ToolTipText"));
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 131072;
        gd.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns;
        restoreDefaults.setLayoutData((Object)gd);
        sc.setMinSize(comp.computeSize(-1, -1));
        restoreDefaults.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TabStartup.this.initializeFromDefaults();
                TabStartup.this.scheduleUpdateJob();
            }
        });
    }

    private void browseButtonSelected(String title, Text text) {
        FileDialog dialog = new FileDialog(this.getShell(), 0);
        dialog.setText(title);
        String str = text.getText().trim();
        int lastSeparatorIndex = str.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(str.substring(0, lastSeparatorIndex));
        }
        if ((str = dialog.open()) != null) {
            text.setText(str);
        }
    }

    private void browseWsButtonSelected(String title, Text text) {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setTitle(title);
        dialog.setMessage(Messages.getString("StartupTab.FileBrowseWs_Message"));
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        if (dialog.open() == 0) {
            IResource resource = (IResource)dialog.getFirstResult();
            String arg = resource.getFullPath().toOSString();
            String fileLoc = VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression("workspace_loc", arg);
            text.setText(fileLoc);
        }
    }

    public void createInitGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.getString("StartupTab.initGroup_Text"));
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        Composite comp = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        gd = new GridData(768);
        comp.setLayoutData((Object)gd);
        Composite local = new Composite(comp, 0);
        layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        local.setLayout((Layout)layout);
        this.fDoFirstReset = new Button(local, 32);
        this.fDoFirstReset.setText(Messages.getString("StartupTab.doFirstReset_Text"));
        this.fDoFirstReset.setToolTipText(Messages.getString("StartupTab.doFirstReset_ToolTipText"));
        Label label = new Label(local, 0);
        label.setText(Messages.getString("StartupTab.firstResetType_Text"));
        label.setToolTipText(Messages.getString("StartupTab.firstResetType_ToolTipText"));
        this.fFirstResetType = new Text(local, 2048);
        this.fFirstResetType.setToolTipText(Messages.getString("StartupTab.firstResetType_ToolTipText"));
        gd = new GridData();
        gd.widthHint = 30;
        this.fFirstResetType.setLayoutData((Object)gd);
        this.fInitCommands = new Text(comp, 2626);
        this.fInitCommands.setToolTipText(Messages.getString("StartupTab.initCommands_ToolTipText"));
        gd = new GridData(1808);
        gd.heightHint = 60;
        this.fInitCommands.setLayoutData((Object)gd);
        local = new Composite(comp, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        local.setLayout((Layout)layout);
        this.fEnableSemihosting = new Button(local, 32);
        this.fEnableSemihosting.setText(Messages.getString("StartupTab.enableSemihosting_Text"));
        this.fEnableSemihosting.setToolTipText(Messages.getString("StartupTab.enableSemihosting_ToolTipText"));
        local = new Composite(comp, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        local.setLayout((Layout)layout);
        this.fChipErase = new Button(local, 32);
        this.fChipErase.setText(Messages.getString("StartupTab.chipErase_Text"));
        this.fChipErase.setToolTipText(Messages.getString("StartupTab.chipErase_ToolTipText"));
        local = new Composite(comp, 0);
        layout = new GridLayout();
        layout.numColumns = 5;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        local.setLayout((Layout)layout);
        label = new Label(local, 0);
        label.setText(Messages.getString("StartupTab.chipSeries_Text"));
        this.fChipSeries = new Combo(local, 8);
        this.fChipSeries.setBounds(50, 85, 150, 65);
        String[] series = new String[]{"NuMicro M0", "NuMicro M23", "NuMicro M4"};
        this.fChipSeries.setItems(series);
        this.fNonSecure = new Button(local, 32);
        this.fNonSecure.setText(Messages.getString("StartupTab.nonSecure_Text"));
        this.fNonSecure.setToolTipText(Messages.getString("StartupTab.nonSecure_ToolTipText"));
        this.fLabelTargetChip = new Label(local, 0);
        this.fLabelTargetChip.setText(Messages.getString("StartupTab.targetChip_Text"));
        this.fLabelTargetChip.setVisible(false);
        this.fTargetChip = new Text(local, 2048);
        gd = new GridData();
        gd.widthHint = 110;
        this.fTargetChip.setLayoutData((Object)gd);
        this.fTargetChip.setVisible(false);
        local = new Composite(comp, 0);
        layout = new GridLayout();
        layout.numColumns = 9;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        local.setLayout((Layout)layout);
        this.fWriteConfig = new Button(local, 32);
        this.fWriteConfig.setText(Messages.getString("StartupTab.writeConfig_Text"));
        this.fWriteConfig.setToolTipText(Messages.getString("StartupTab.writeConfig_ToolTipText"));
        this.fLabelConfig0 = new Label(local, 0);
        this.fLabelConfig0.setText(Messages.getString("StartupTab.initialConfig0_Text"));
        this.fInitialConfig0 = new Text(local, 2048);
        gd = new GridData();
        gd.widthHint = 70;
        this.fInitialConfig0.setLayoutData((Object)gd);
        this.fLabelConfig1 = new Label(local, 0);
        this.fLabelConfig1.setText(Messages.getString("StartupTab.initialConfig1_Text"));
        this.fInitialConfig1 = new Text(local, 2048);
        gd = new GridData();
        gd.widthHint = 70;
        this.fInitialConfig1.setLayoutData((Object)gd);
        this.fLabelConfig2 = new Label(local, 0);
        this.fLabelConfig2.setText(Messages.getString("StartupTab.initialConfig2_Text"));
        this.fInitialConfig2 = new Text(local, 2048);
        gd = new GridData();
        gd.widthHint = 70;
        this.fInitialConfig2.setLayoutData((Object)gd);
        this.fLabelConfig3 = new Label(local, 0);
        this.fLabelConfig3.setText(Messages.getString("StartupTab.initialConfig3_Text"));
        this.fInitialConfig3 = new Text(local, 2048);
        gd = new GridData();
        gd.widthHint = 70;
        this.fInitialConfig3.setLayoutData((Object)gd);
        local = new Composite(comp, 0);
        layout = new GridLayout();
        layout.numColumns = 7;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        local.setLayout((Layout)layout);
        this.fWriteLock = new Button(local, 32);
        this.fWriteLock.setText(Messages.getString("StartupTab.writeLock_Text"));
        this.fWriteLock.setToolTipText(Messages.getString("StartupTab.writeLock_ToolTipText"));
        this.fLabellNSCBA = new Label(local, 0);
        this.fLabellNSCBA.setText(Messages.getString("StartupTab.NSCBA_Text"));
        this.fInitialNSCBA = new Text(local, 2048);
        gd = new GridData();
        gd.widthHint = 70;
        this.fInitialNSCBA.setLayoutData((Object)gd);
        this.fLabelSCRLOCK = new Label(local, 0);
        this.fLabelSCRLOCK.setText(Messages.getString("StartupTab.SCRLOCK_Text"));
        this.fInitialSCRLOCK = new Text(local, 2048);
        gd = new GridData();
        gd.widthHint = 70;
        this.fInitialSCRLOCK.setLayoutData((Object)gd);
        this.fLabelARLOCK = new Label(local, 0);
        this.fLabelARLOCK.setText(Messages.getString("StartupTab.ARLOCK_Text"));
        this.fInitialARLOCK = new Text(local, 2048);
        gd = new GridData();
        gd.widthHint = 70;
        this.fInitialARLOCK.setLayoutData((Object)gd);
        this.fDoFirstReset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.doFirstResetChanged();
                TabStartup.this.scheduleUpdateJob();
            }
        });
        this.fEnableSemihosting.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.scheduleUpdateJob();
            }
        });
        this.fChipErase.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.scheduleUpdateJob();
            }
        });
        this.fChipSeries.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.chipSeriesChanged();
                TabStartup.this.scheduleUpdateJob();
                TabStartup.this.fInitialConfig0.setText(TabStartup.this.updateDefaultConfig0("FFFFFFFF"));
                TabStartup.this.fInitialConfig1.setText("FFFFFFFF");
                TabStartup.this.fInitialConfig2.setText(TabStartup.this.updateDefaultConfig2("FFFFFFFF"));
                TabStartup.this.fInitialConfig3.setText("FFFFFFFF");
                TabStartup.this.updateNUC400AEConfig3();
            }
        });
        this.fTargetChip.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabStartup.this.chipSeriesChanged();
                TabStartup.this.scheduleUpdateJob();
                TabStartup.this.fInitialConfig0.setText(TabStartup.this.updateDefaultConfig0("FFFFFFFF"));
                TabStartup.this.fInitialConfig1.setText("FFFFFFFF");
                TabStartup.this.fInitialConfig2.setText(TabStartup.this.updateDefaultConfig2("FFFFFFFF"));
                TabStartup.this.fInitialConfig3.setText("FFFFFFFF");
                TabStartup.this.updateNUC400AEConfig3();
            }
        });
        this.fNonSecure.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.chipSeriesChanged();
                TabStartup.this.scheduleUpdateJob();
            }
        });
        this.fWriteConfig.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.writeConfigChanged();
                TabStartup.this.scheduleUpdateJob();
            }
        });
        this.fWriteLock.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.writeLockChanged();
                TabStartup.this.scheduleUpdateJob();
            }
        });
        ModifyListener scheduleUpdateJobModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabStartup.this.scheduleUpdateJob();
            }
        };
        ModifyListener configModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabStartup.this.updateNUC400AEConfig3();
                TabStartup.this.scheduleUpdateJob();
            }
        };
        this.fFirstResetType.addModifyListener(scheduleUpdateJobModifyListener);
        this.fInitCommands.addModifyListener(scheduleUpdateJobModifyListener);
        this.fInitialConfig0.addModifyListener(configModifyListener);
        this.fInitialConfig1.addModifyListener(configModifyListener);
        this.fInitialConfig2.addModifyListener(scheduleUpdateJobModifyListener);
        this.fInitialConfig3.addModifyListener(scheduleUpdateJobModifyListener);
        this.fInitialNSCBA.addModifyListener(scheduleUpdateJobModifyListener);
        this.fInitialSCRLOCK.addModifyListener(scheduleUpdateJobModifyListener);
        this.fInitialARLOCK.addModifyListener(scheduleUpdateJobModifyListener);
        VerifyListener initialVerifyListener = new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = Character.isDigit(e.character) || Character.isISOControl(e.character) || "abcdef".contains(String.valueOf(e.character).toLowerCase());
            }
        };
        this.fInitialConfig0.addVerifyListener(initialVerifyListener);
        this.fInitialConfig1.addVerifyListener(initialVerifyListener);
        this.fInitialConfig2.addVerifyListener(initialVerifyListener);
        this.fInitialConfig3.addVerifyListener(initialVerifyListener);
        this.fInitialConfig0.setTextLimit(8);
        this.fInitialConfig1.setTextLimit(8);
        this.fInitialConfig2.setTextLimit(8);
        this.fInitialConfig3.setTextLimit(8);
        this.fInitialNSCBA.addVerifyListener(initialVerifyListener);
        this.fInitialSCRLOCK.addVerifyListener(initialVerifyListener);
        this.fInitialARLOCK.addVerifyListener(initialVerifyListener);
        this.fInitialNSCBA.setTextLimit(6);
        this.fInitialSCRLOCK.setTextLimit(2);
        this.fInitialARLOCK.setTextLimit(2);
        new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = Character.isDigit(e.character) || Character.isISOControl(e.character) || "abcdef/".contains(String.valueOf(e.character).toLowerCase());
            }
        };
    }

    private void doFirstResetChanged() {
        boolean enabled = this.fDoFirstReset.getSelection();
        this.fFirstResetType.setEnabled(enabled);
    }

    private void chipSeriesChanged() {
        String[] isM4 = new String[]{"NuMicro M4", "NUC400AE", "NUC505", "M451AE", "M4521AE", "M479AE", "M480AE"};
        String[] isM23 = new String[]{"NuMicro M23", "M2351", "M2354", "M251", "M261"};
        String commandStr1 = "";
        if (this.fTargetChip != null && (commandStr1 = this.fTargetChip.getText()).toUpperCase().indexOf("0X") == 0) {
            commandStr1 = commandStr1.substring(2);
        }
        if (this.fChipSeries.getText().equals("NuMicro M23") && (commandStr1.toUpperCase().indexOf("M2351") != -1 || TabStartup.isNumeric(commandStr1) && Integer.parseInt(commandStr1, 16) == 53)) {
            this.fNonSecure.setVisible(true);
            this.fWriteLock.setVisible(true);
            this.fLabellNSCBA.setVisible(true);
            this.fLabelSCRLOCK.setVisible(true);
            this.fLabelARLOCK.setVisible(false);
            this.fInitialNSCBA.setVisible(true);
            this.fInitialSCRLOCK.setVisible(true);
            this.fInitialARLOCK.setVisible(false);
            this.fLabelARLOCK.moveBelow((Control)this.fInitialSCRLOCK);
            this.fInitialARLOCK.moveBelow((Control)this.fInitialSCRLOCK);
            this.updateLoadExecutableFEnabledSelection(true);
        } else if (this.fChipSeries.getText().equals("NuMicro M23") && (commandStr1.toUpperCase().indexOf("M2354") != -1 || TabStartup.isNumeric(commandStr1) && Integer.parseInt(commandStr1, 16) == 55)) {
            this.fNonSecure.setVisible(true);
            this.fWriteLock.setVisible(true);
            this.fLabellNSCBA.setVisible(true);
            this.fLabelSCRLOCK.setVisible(true);
            this.fLabelARLOCK.setVisible(false);
            this.fInitialNSCBA.setVisible(true);
            this.fInitialSCRLOCK.setVisible(true);
            this.fInitialARLOCK.setVisible(false);
            this.fLabelARLOCK.moveBelow((Control)this.fInitialSCRLOCK);
            this.fInitialARLOCK.moveBelow((Control)this.fInitialSCRLOCK);
            this.updateLoadExecutableFEnabledSelection(true);
        } else if (this.fChipSeries.getText().equals("NuMicro M23") && (commandStr1.toUpperCase().indexOf("M261") != -1 || TabStartup.isNumeric(commandStr1) && Integer.parseInt(commandStr1, 16) == 53)) {
            this.fNonSecure.setVisible(false);
            this.fWriteLock.setVisible(true);
            this.fLabellNSCBA.setVisible(false);
            this.fLabelSCRLOCK.setVisible(false);
            this.fLabelARLOCK.setVisible(true);
            this.fInitialNSCBA.setVisible(false);
            this.fInitialSCRLOCK.setVisible(false);
            this.fInitialARLOCK.setVisible(true);
            this.fLabelARLOCK.moveAbove((Control)this.fLabellNSCBA);
            this.fInitialARLOCK.moveAbove((Control)this.fLabellNSCBA);
            this.updateLoadExecutableFEnabledSelection(true);
        } else if (this.fChipSeries.getText().equals("NuMicro A35") && (commandStr1.toUpperCase().indexOf("MA35D1") != -1 || TabStartup.isNumeric(commandStr1) && Integer.parseInt(commandStr1, 16) == 160)) {
            this.fNonSecure.setVisible(false);
            this.fWriteLock.setVisible(false);
            this.fLabellNSCBA.setVisible(false);
            this.fLabelSCRLOCK.setVisible(false);
            this.fLabelARLOCK.setVisible(false);
            this.fInitialNSCBA.setVisible(false);
            this.fInitialSCRLOCK.setVisible(false);
            this.fInitialARLOCK.setVisible(false);
            this.fLabelARLOCK.moveBelow((Control)this.fInitialSCRLOCK);
            this.fInitialARLOCK.moveBelow((Control)this.fInitialSCRLOCK);
            this.updateLoadExecutableFEnabledSelection(false);
        } else {
            this.fNonSecure.setVisible(false);
            this.fWriteLock.setVisible(false);
            this.fLabellNSCBA.setVisible(false);
            this.fLabelSCRLOCK.setVisible(false);
            this.fLabelARLOCK.setVisible(false);
            this.fInitialNSCBA.setVisible(false);
            this.fInitialSCRLOCK.setVisible(false);
            this.fInitialARLOCK.setVisible(false);
            this.fLabelARLOCK.moveBelow((Control)this.fInitialSCRLOCK);
            this.fInitialARLOCK.moveBelow((Control)this.fInitialSCRLOCK);
            this.updateLoadExecutableFEnabledSelection(true);
        }
        if (this.fChipSeries.getText().equals("NuMicro M4") && (commandStr1.toUpperCase().indexOf("NUC505") != -1 || TabStartup.isNumeric(commandStr1) && Integer.parseInt(commandStr1, 16) == 44)) {
            this.fChipErase.setSelection(false);
            this.fChipErase.setEnabled(false);
            this.fWriteConfig.setSelection(false);
            this.fWriteConfig.setEnabled(false);
        } else {
            this.fChipErase.setEnabled(true);
            this.fWriteConfig.setEnabled(true);
        }
        this.fLabelConfig0.setVisible(true);
        this.fLabelConfig1.setVisible(true);
        this.fLabelConfig2.setVisible(true);
        this.fLabelConfig3.setVisible(true);
        this.fInitialConfig0.setVisible(true);
        this.fInitialConfig1.setVisible(true);
        this.fInitialConfig2.setVisible(true);
        this.fInitialConfig3.setVisible(true);
        if (this.getStringArrayIndex(isM4, this.fChipSeries.getText()) != -1) {
            TabDebugger.putGdbServerOtherOptions("M4");
        } else if (this.getStringArrayIndex(isM23, this.fChipSeries.getText()) != -1) {
            if (this.fNonSecure.getSelection()) {
                TabDebugger.putGdbServerOtherOptions("M23_NS");
            } else {
                TabDebugger.putGdbServerOtherOptions("M23");
            }
        } else if (this.fChipSeries.getText().equals("NuMicro A35")) {
            TabDebugger.putGdbServerOtherOptions("MA35D1");
        } else {
            TabDebugger.putGdbServerOtherOptions("M0");
        }
    }

    private void writeConfigChanged() {
        boolean enabled = this.fWriteConfig.getSelection();
        this.fInitialConfig0.setEnabled(enabled);
        this.fInitialConfig1.setEnabled(enabled);
        this.fInitialConfig2.setEnabled(enabled);
        this.fInitialConfig3.setEnabled(enabled);
    }

    private void writeLockChanged() {
        boolean enabled = this.fWriteLock.getSelection();
        this.fInitialNSCBA.setEnabled(enabled);
        this.fInitialSCRLOCK.setEnabled(enabled);
        this.fInitialARLOCK.setEnabled(enabled);
    }

    private void createLoadGroup(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        group.setText(Messages.getString("StartupTab.loadGroup_Text"));
        Composite comp = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        gd = new GridData(768);
        comp.setLayoutData((Object)gd);
        this.fLoadSymbols = new Button(comp, 32);
        this.fLoadSymbols.setText(Messages.getString("StartupTab.loadSymbols_Text"));
        Composite local = new Composite(comp, 0);
        layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginHeight = 0;
        local.setLayout((Layout)layout);
        local.setLayoutData((Object)new GridData(768));
        this.fUseProjectBinaryForSymbols = new Button(local, 16);
        this.fUseProjectBinaryForSymbols.setText(Messages.getString("StartupTab.useProjectBinary_Label"));
        this.fUseProjectBinaryForSymbols.setToolTipText(Messages.getString("StartupTab.useProjectBinary_ToolTipText"));
        this.fProjBinaryLabel2 = new Label(local, 0);
        gd = new GridData(768);
        gd.horizontalSpan = ((GridLayout)local.getLayout()).numColumns - 1;
        this.fProjBinaryLabel2.setLayoutData((Object)gd);
        this.fUseFileForSymbols = new Button(local, 16);
        this.fUseFileForSymbols.setText(Messages.getString("StartupTab.useFile_Label"));
        this.fSymbolsFileName = new Text(local, 2048);
        gd = new GridData(768);
        this.fSymbolsFileName.setLayoutData((Object)gd);
        this.fSymbolsFileBrowseWs = this.createPushButton(local, Messages.getString("StartupTab.FileBrowseWs_Label"), null);
        this.fSymbolsFileBrowse = this.createPushButton(local, Messages.getString("StartupTab.FileBrowse_Label"), null);
        this.fSymbolsOffsetLabel = new Label(local, 0);
        this.fSymbolsOffsetLabel.setText(Messages.getString("StartupTab.symbolsOffsetLabel_Text"));
        this.fSymbolsOffset = new Text(local, 2048);
        gd = new GridData();
        gd.horizontalSpan = ((GridLayout)local.getLayout()).numColumns - 1;
        gd.widthHint = 100;
        this.fSymbolsOffset.setLayoutData((Object)gd);
        this.fLoadExecutableF = new Button(comp, 32);
        this.fLoadExecutableF.setText(Messages.getString("StartupTab.loadImageToFlash_Text"));
        local = new Composite(comp, 0);
        layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginHeight = 0;
        local.setLayout((Layout)layout);
        local.setLayoutData((Object)new GridData(768));
        this.fUseProjectBinaryForImageF = new Button(local, 16);
        this.fUseProjectBinaryForImageF.setText(Messages.getString("StartupTab.useProjectBinary_Label"));
        this.fUseProjectBinaryForImageF.setToolTipText(Messages.getString("StartupTab.useProjectBinary_ToolTipText"));
        this.fProjBinaryLabelF = new Label(local, 0);
        gd = new GridData(768);
        gd.horizontalSpan = ((GridLayout)local.getLayout()).numColumns - 1;
        this.fProjBinaryLabelF.setLayoutData((Object)gd);
        this.fUseFileForImageF = new Button(local, 16);
        this.fUseFileForImageF.setText(Messages.getString("StartupTab.useFile_Label"));
        this.fImageFileNameF = new Text(local, 2048);
        gd = new GridData(768);
        this.fImageFileNameF.setLayoutData((Object)gd);
        this.fImageFileBrowseWsF = this.createPushButton(local, Messages.getString("StartupTab.FileBrowseWs_Label"), null);
        this.fImageFileBrowseF = this.createPushButton(local, Messages.getString("StartupTab.FileBrowse_Label"), null);
        this.fImageOffsetLabelF = new Label(local, 0);
        this.fImageOffsetLabelF.setText(Messages.getString("StartupTab.imageOffsetLabel_Text"));
        this.fImageOffsetF = new Text(local, 2048);
        gd = new GridData();
        gd.horizontalSpan = ((GridLayout)local.getLayout()).numColumns - 1;
        gd.widthHint = ((GridData)this.fSymbolsOffset.getLayoutData()).widthHint;
        this.fImageOffsetF.setLayoutData((Object)gd);
        this.fLoadExecutable = new Button(comp, 32);
        this.fLoadExecutable.setText(Messages.getString("StartupTab.loadImageToSRAM_Text"));
        local = new Composite(comp, 0);
        layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginHeight = 0;
        local.setLayout((Layout)layout);
        local.setLayoutData((Object)new GridData(768));
        this.fUseProjectBinaryForImage = new Button(local, 16);
        this.fUseProjectBinaryForImage.setText(Messages.getString("StartupTab.useProjectBinary_Label"));
        this.fUseProjectBinaryForImage.setToolTipText(Messages.getString("StartupTab.useProjectBinary_ToolTipText"));
        this.fProjBinaryLabel1 = new Label(local, 0);
        gd = new GridData(768);
        gd.horizontalSpan = ((GridLayout)local.getLayout()).numColumns - 1;
        this.fProjBinaryLabel1.setLayoutData((Object)gd);
        this.fUseFileForImage = new Button(local, 16);
        this.fUseFileForImage.setText(Messages.getString("StartupTab.useFile_Label"));
        this.fImageFileName = new Text(local, 2048);
        gd = new GridData(768);
        this.fImageFileName.setLayoutData((Object)gd);
        this.fImageFileBrowseWs = this.createPushButton(local, Messages.getString("StartupTab.FileBrowseWs_Label"), null);
        this.fImageFileBrowse = this.createPushButton(local, Messages.getString("StartupTab.FileBrowse_Label"), null);
        this.fImageOffsetLabel = new Label(local, 0);
        this.fImageOffsetLabel.setText(Messages.getString("StartupTab.imageOffsetLabel_Text"));
        this.fImageOffset = new Text(local, 2048);
        gd = new GridData();
        gd.horizontalSpan = ((GridLayout)local.getLayout()).numColumns - 1;
        gd.widthHint = ((GridData)this.fSymbolsOffset.getLayoutData()).widthHint;
        this.fImageOffset.setLayoutData((Object)gd);
        this.fLoadExecutableF.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.loadExecutableFChanged();
                TabStartup.this.scheduleUpdateJob();
            }
        });
        this.fLoadExecutable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.loadExecutableChanged();
                TabStartup.this.scheduleUpdateJob();
            }
        });
        SelectionListener radioButtonListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.updateUseFileEnablement();
                TabStartup.this.scheduleUpdateJob();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.fUseProjectBinaryForImageF.addSelectionListener(radioButtonListener);
        this.fUseFileForImageF.addSelectionListener(radioButtonListener);
        this.fUseProjectBinaryForImage.addSelectionListener(radioButtonListener);
        this.fUseFileForImage.addSelectionListener(radioButtonListener);
        this.fUseProjectBinaryForSymbols.addSelectionListener(radioButtonListener);
        this.fUseFileForSymbols.addSelectionListener(radioButtonListener);
        this.fImageFileNameF.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabStartup.this.scheduleUpdateJob();
            }
        });
        this.fImageFileBrowseWsF.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.browseWsButtonSelected(Messages.getString("StartupTab.imageFileBrowseWs_Title"), TabStartup.this.fImageFileNameF);
            }
        });
        this.fImageFileBrowseF.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.browseButtonSelected(Messages.getString("StartupTab.imageFileBrowse_Title"), TabStartup.this.fImageFileNameF);
            }
        });
        this.fImageOffsetF.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = Character.isDigit(e.character) || Character.isISOControl(e.character) || "abcdef".contains(String.valueOf(e.character).toLowerCase());
            }
        });
        this.fImageOffsetF.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabStartup.this.scheduleUpdateJob();
            }
        });
        this.fImageFileName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabStartup.this.scheduleUpdateJob();
            }
        });
        this.fImageFileBrowseWs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.browseWsButtonSelected(Messages.getString("StartupTab.imageFileBrowseWs_Title"), TabStartup.this.fImageFileName);
            }
        });
        this.fImageFileBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.browseButtonSelected(Messages.getString("StartupTab.imageFileBrowse_Title"), TabStartup.this.fImageFileName);
            }
        });
        this.fImageOffset.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = Character.isDigit(e.character) || Character.isISOControl(e.character) || "abcdef".contains(String.valueOf(e.character).toLowerCase());
            }
        });
        this.fImageOffset.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabStartup.this.scheduleUpdateJob();
            }
        });
        this.fLoadSymbols.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.loadSymbolsChanged();
                TabStartup.this.scheduleUpdateJob();
            }
        });
        this.fSymbolsFileName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabStartup.this.scheduleUpdateJob();
            }
        });
        this.fSymbolsFileBrowseWs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.browseWsButtonSelected(Messages.getString("StartupTab.symbolsFileBrowseWs_Title"), TabStartup.this.fSymbolsFileName);
            }
        });
        this.fSymbolsFileBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.browseButtonSelected(Messages.getString("StartupTab.symbolsFileBrowse_Title"), TabStartup.this.fSymbolsFileName);
            }
        });
        this.fSymbolsOffset.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = Character.isDigit(e.character) || Character.isISOControl(e.character) || "abcdef".contains(String.valueOf(e.character).toLowerCase());
            }
        });
        this.fSymbolsOffset.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabStartup.this.scheduleUpdateJob();
            }
        });
    }

    private void updateUseFileEnablement() {
        boolean enabled = this.fLoadExecutable.getSelection() && this.fUseFileForImage.getSelection();
        this.fImageFileName.setEnabled(enabled);
        this.fImageFileBrowseWs.setEnabled(enabled);
        this.fImageFileBrowse.setEnabled(enabled);
        enabled = this.fLoadSymbols.getSelection() && this.fUseFileForSymbols.getSelection();
        this.fSymbolsFileName.setEnabled(enabled);
        this.fSymbolsFileBrowseWs.setEnabled(enabled);
        this.fSymbolsFileBrowse.setEnabled(enabled);
        enabled = this.fLoadExecutableF.getSelection() && this.fUseFileForImageF.getSelection();
        this.fImageFileNameF.setEnabled(enabled);
        this.fImageFileBrowseWsF.setEnabled(enabled);
        this.fImageFileBrowseF.setEnabled(enabled);
    }

    private void updateLoadExecutableFEnabledSelection(boolean enabled) {
        if (enabled) {
            this.fLoadExecutableF.setEnabled(true);
        } else {
            this.fLoadExecutableF.setEnabled(false);
            this.fLoadExecutableF.setSelection(false);
            this.loadExecutableFChanged();
        }
    }

    public void createRunOptionGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.getString("StartupTab.runOptionGroup_Text"));
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        Composite comp = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        gd = new GridData(768);
        comp.setLayoutData((Object)gd);
        this.fDoDebugInRam = new Button(comp, 32);
        this.fDoDebugInRam.setText(Messages.getString("StartupTab.doDebugInRam_Text"));
        this.fDoDebugInRam.setToolTipText(Messages.getString("StartupTab.doDebugInRam_ToolTipText"));
        this.fDoDebugInRam.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.scheduleUpdateJob();
            }
        });
    }

    private void doSecondResetChanged() {
        boolean enabled = this.fDoSecondReset.getSelection();
        this.fSecondResetType.setEnabled(enabled);
        this.fSecondResetWarning.setEnabled(enabled);
    }

    private void loadExecutableFChanged() {
        boolean enabled = this.fLoadExecutableF.getSelection();
        this.fUseProjectBinaryForImageF.setEnabled(enabled);
        this.fUseFileForImageF.setEnabled(enabled);
        this.fImageOffsetF.setEnabled(enabled);
        this.fImageOffsetLabelF.setEnabled(enabled);
        this.updateUseFileEnablement();
    }

    private void loadExecutableChanged() {
        boolean enabled = this.fLoadExecutable.getSelection();
        this.fUseProjectBinaryForImage.setEnabled(enabled);
        this.fUseFileForImage.setEnabled(enabled);
        this.fImageOffset.setEnabled(enabled);
        this.fImageOffsetLabel.setEnabled(enabled);
        this.updateUseFileEnablement();
    }

    private void loadSymbolsChanged() {
        boolean enabled = this.fLoadSymbols.getSelection();
        this.fUseProjectBinaryForSymbols.setEnabled(enabled);
        this.fUseFileForSymbols.setEnabled(enabled);
        this.fSymbolsOffset.setEnabled(enabled);
        this.fSymbolsOffsetLabel.setEnabled(enabled);
        this.updateUseFileEnablement();
    }

    private void pcRegisterChanged() {
        this.fPcRegister.setEnabled(this.fSetPcRegister.getSelection());
    }

    private void stopAtChanged() {
        this.fStopAt.setEnabled(this.fSetStopAt.getSelection());
    }

    public void createRunGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.getString("StartupTab.runGroup_Text"));
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        Composite comp = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        gd = new GridData(768);
        comp.setLayoutData((Object)gd);
        this.fDoSecondReset = new Button(comp, 32);
        this.fDoSecondReset.setText(Messages.getString("StartupTab.doSecondReset_Text"));
        this.fDoSecondReset.setToolTipText(Messages.getString("StartupTab.doSecondReset_ToolTipText"));
        Label label = new Label(comp, 0);
        label.setText(Messages.getString("StartupTab.secondResetType_Text"));
        label.setToolTipText(Messages.getString("StartupTab.secondResetType_ToolTipText"));
        this.fSecondResetType = new Text(comp, 2048);
        this.fSecondResetType.setToolTipText(Messages.getString("StartupTab.secondResetType_ToolTipText"));
        gd = new GridData();
        gd.widthHint = 30;
        this.fSecondResetType.setLayoutData((Object)gd);
        this.fSecondResetWarning = new Label(comp, 0);
        this.fSecondResetWarning.setText(Messages.getString("StartupTab.secondResetWarning_Text"));
        gd = new GridData();
        gd.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 3;
        this.fSecondResetWarning.setLayoutData((Object)gd);
        this.fRunCommands = new Text(comp, 2626);
        this.fRunCommands.setToolTipText(Messages.getString("StartupTab.runCommands_ToolTipText"));
        gd = new GridData(1808);
        gd.heightHint = 60;
        gd.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns;
        this.fRunCommands.setLayoutData((Object)gd);
        this.fSetPcRegister = new Button(comp, 32);
        this.fSetPcRegister.setText(Messages.getString("StartupTab.setPcRegister_Text"));
        this.fSetPcRegister.setToolTipText(Messages.getString("StartupTab.setPcRegister_ToolTipText"));
        this.fPcRegister = new Text(comp, 2048);
        this.fPcRegister.setToolTipText(Messages.getString("StartupTab.pcRegister_ToolTipText"));
        gd = new GridData();
        gd.widthHint = 100;
        gd.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        this.fPcRegister.setLayoutData((Object)gd);
        this.fSetStopAt = new Button(comp, 32);
        this.fSetStopAt.setText(Messages.getString("StartupTab.setStopAt_Text"));
        this.fSetStopAt.setToolTipText(Messages.getString("StartupTab.setStopAt_ToolTipText"));
        this.fStopAt = new Text(comp, 2048);
        gd = new GridData();
        gd.widthHint = 100;
        gd.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        this.fStopAt.setLayoutData((Object)gd);
        this.fDoContinue = new Button(comp, 32);
        this.fDoContinue.setText(Messages.getString("StartupTab.doContinue_Text"));
        this.fDoContinue.setToolTipText(Messages.getString("StartupTab.doContinue_ToolTipText"));
        gd = new GridData();
        gd.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns;
        this.fDoContinue.setLayoutData((Object)gd);
        this.fDoSecondReset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.doSecondResetChanged();
                TabStartup.this.scheduleUpdateJob();
            }
        });
        this.fSetPcRegister.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.pcRegisterChanged();
                TabStartup.this.scheduleUpdateJob();
            }
        });
        this.fPcRegister.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = Character.isDigit(e.character) || Character.isISOControl(e.character) || "abcdef".contains(String.valueOf(e.character).toLowerCase());
            }
        });
        this.fPcRegister.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabStartup.this.scheduleUpdateJob();
            }
        });
        this.fSetStopAt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.stopAtChanged();
                TabStartup.this.scheduleUpdateJob();
            }
        });
        this.fStopAt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabStartup.this.scheduleUpdateJob();
            }
        });
        ModifyListener scheduleUpdateJobModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabStartup.this.scheduleUpdateJob();
            }
        };
        SelectionAdapter scheduleUpdateJobSelectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabStartup.this.scheduleUpdateJob();
            }
        };
        this.fSecondResetType.addModifyListener(scheduleUpdateJobModifyListener);
        this.fRunCommands.addModifyListener(scheduleUpdateJobModifyListener);
        this.fDoContinue.addSelectionListener((SelectionListener)scheduleUpdateJobSelectionAdapter);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        Path filePath;
        String path;
        if (!super.isValid(launchConfig)) {
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.fLoadExecutableF.getSelection()) {
            if (!this.fUseProjectBinaryForImageF.getSelection()) {
                if (this.fImageFileNameF.getText().trim().length() == 0) {
                    this.setErrorMessage(Messages.getString("StartupTab.imageFileName_not_specified"));
                    return false;
                }
                try {
                    path = this.fImageFileNameF.getText().trim();
                    path = DebugUtils.resolveAll((String)path, (Map)launchConfig.getAttributes());
                    filePath = new Path(path);
                    if (!filePath.toFile().exists()) {
                        this.setErrorMessage(Messages.getString("StartupTab.imageFileName_does_not_exist"));
                        return false;
                    }
                }
                catch (CoreException coreException) {
                    this.setErrorMessage(Messages.getString("StartupTab.imageFileName_does_not_exist"));
                    return false;
                }
            }
        } else {
            this.setErrorMessage(null);
        }
        if (this.fLoadExecutable.getSelection()) {
            if (!this.fUseProjectBinaryForImage.getSelection()) {
                if (this.fImageFileName.getText().trim().length() == 0) {
                    this.setErrorMessage(Messages.getString("StartupTab.imageFileName_not_specified"));
                    return false;
                }
                try {
                    path = this.fImageFileName.getText().trim();
                    path = DebugUtils.resolveAll((String)path, (Map)launchConfig.getAttributes());
                    filePath = new Path(path);
                    if (!filePath.toFile().exists()) {
                        this.setErrorMessage(Messages.getString("StartupTab.imageFileName_does_not_exist"));
                        return false;
                    }
                }
                catch (CoreException coreException) {
                    this.setErrorMessage(Messages.getString("StartupTab.imageFileName_does_not_exist"));
                    return false;
                }
            }
        } else {
            this.setErrorMessage(null);
        }
        if (this.fLoadSymbols.getSelection()) {
            if (!this.fUseProjectBinaryForSymbols.getSelection()) {
                if (this.fSymbolsFileName.getText().trim().length() == 0) {
                    this.setErrorMessage(Messages.getString("StartupTab.symbolsFileName_not_specified"));
                    return false;
                }
                try {
                    path = this.fSymbolsFileName.getText().trim();
                    path = DebugUtils.resolveAll((String)path, (Map)launchConfig.getAttributes());
                    filePath = new Path(path);
                    if (!filePath.toFile().exists()) {
                        this.setErrorMessage(Messages.getString("StartupTab.symbolsFileName_does_not_exist"));
                        return false;
                    }
                }
                catch (CoreException coreException) {
                    this.setErrorMessage(Messages.getString("StartupTab.symbolsFileName_does_not_exist"));
                    return false;
                }
            }
        } else {
            this.setErrorMessage(null);
        }
        if (this.fSetPcRegister.getSelection()) {
            if (this.fPcRegister.getText().trim().length() == 0) {
                this.setErrorMessage(Messages.getString("StartupTab.pcRegister_not_specified"));
                return false;
            }
        } else {
            this.setErrorMessage(null);
        }
        if (this.fSetStopAt.getSelection()) {
            if (this.fStopAt.getText().trim().length() == 0) {
                this.setErrorMessage(Messages.getString("StartupTab.stopAt_not_specified"));
            }
        } else {
            this.setErrorMessage(null);
        }
        return true;
    }

    public String getId() {
        return TAB_ID;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            boolean booleanDefault;
            String[] isM4 = new String[]{"NuMicro M4", "NUC400AE", "NUC505", "M451AE", "M4521AE", "M479AE", "M480AE"};
            String[] isM23 = new String[]{"NuMicro M23", "M2351", "M2354", "M251", "M261"};
            String[] isNuMicro = new String[]{"NuMicro M0", "NuMicro M4", "NuMicro M23", "NuMicro A35"};
            IniFile ini = null;
            try {
                ini = this.getIniFromProgramPath(configuration);
            }
            catch (CoreException coreException) {}
            String stringDefault = null;
            if (ini != null) {
                stringDefault = ini.getString("startup", "initResetEnable", this.booleanToString(true));
                this.fDoFirstReset.setSelection(this.stringToBoolean(stringDefault));
            } else {
                booleanDefault = PersistentPreferences.getOpenOCDDoInitialReset();
                this.fDoFirstReset.setSelection(configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.doFirstReset", booleanDefault));
            }
            stringDefault = null;
            if (ini != null) {
                stringDefault = ini.getString("startup", "initResetType", "init");
                this.fFirstResetType.setText(stringDefault);
            } else {
                stringDefault = PersistentPreferences.getOpenOCDInitialResetType();
                this.fFirstResetType.setText(configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.firstResetType", stringDefault));
            }
            stringDefault = null;
            if (ini != null) {
                stringDefault = ini.getString("startup", "initOther", "");
                this.fInitCommands.setText(stringDefault);
            } else {
                stringDefault = PersistentPreferences.getOpenOCDInitOther();
                this.fInitCommands.setText(configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.otherInitCommands", stringDefault));
            }
            stringDefault = null;
            if (ini != null) {
                stringDefault = ini.getString("startup", "enableSemihosting", this.booleanToString(true));
                this.fEnableSemihosting.setSelection(this.stringToBoolean(stringDefault));
            } else {
                booleanDefault = PersistentPreferences.getOpenOCDEnableSemihosting();
                this.fEnableSemihosting.setSelection(configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.enableSemihosting", booleanDefault));
            }
            stringDefault = null;
            if (ini != null) {
                stringDefault = ini.getString("startup", "chipErase", this.booleanToString(false));
                this.fChipErase.setSelection(this.stringToBoolean(stringDefault));
            } else {
                booleanDefault = PersistentPreferences.getOpenOCDChipErase();
                this.fChipErase.setSelection(configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.chipErase", booleanDefault));
            }
            stringDefault = null;
            if (ini != null) {
                stringDefault = ini.getString("startup", "chipSeries", "NuMicro M4");
                if (this.getStringArrayIndex(isM4, stringDefault) != -1) {
                    this.fChipSeries.setText("NuMicro M4");
                } else if (this.getStringArrayIndex(isM23, stringDefault) != -1) {
                    this.fChipSeries.setText("NuMicro M23");
                } else if (stringDefault.equals("NuMicro A35")) {
                    this.fChipSeries.setText("NuMicro A35");
                } else {
                    this.fChipSeries.setText("NuMicro M0");
                }
            } else {
                stringDefault = PersistentPreferences.getOpenOCDChipSeries();
                this.fChipSeries.setText(configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.chipSeries", stringDefault));
            }
            stringDefault = null;
            if (ini != null) {
                stringDefault = ini.getString("startup", "chipSeries", "NuMicro M4");
                if (this.getStringArrayIndex(isNuMicro, stringDefault) != -1) {
                    stringDefault = ini.getString("startup", "targetChip", "");
                }
                this.fTargetChip.setText(stringDefault);
            } else {
                stringDefault = PersistentPreferences.getOpenOCDTargetChip();
                this.fTargetChip.setText(configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.targetChip", stringDefault));
            }
            stringDefault = null;
            if (ini != null) {
                stringDefault = ini.getString("startup", "nonSecure", this.booleanToString(false));
                this.fNonSecure.setSelection(this.stringToBoolean(stringDefault));
            } else {
                booleanDefault = PersistentPreferences.getOpenOCDInitialNonSecure();
                this.fNonSecure.setSelection(configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.nonSecure", booleanDefault));
            }
            stringDefault = null;
            if (ini != null) {
                stringDefault = ini.getString("startup", "writeConfig", this.booleanToString(false));
                this.fWriteConfig.setSelection(this.stringToBoolean(stringDefault));
            } else {
                booleanDefault = PersistentPreferences.getOpenOCDInitialWriteConfig();
                this.fWriteConfig.setSelection(configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.writeConifg", booleanDefault));
            }
            stringDefault = null;
            if (ini != null) {
                stringDefault = ini.getString("startup", "config0", this.updateDefaultConfig0("FFFFFFFF"));
                this.fInitialConfig0.setText(this.stringConformToHex(stringDefault));
            } else {
                stringDefault = this.updateDefaultConfig0(PersistentPreferences.getOpenOCDInitialConfig0());
                this.fInitialConfig0.setText(configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.initialConfig0", stringDefault));
            }
            stringDefault = null;
            if (ini != null) {
                stringDefault = ini.getString("startup", "config1", "FFFFFFFF");
                this.fInitialConfig1.setText(this.stringConformToHex(stringDefault));
            } else {
                stringDefault = PersistentPreferences.getOpenOCDInitialConfig1();
                this.fInitialConfig1.setText(configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.initialConfig1", stringDefault));
            }
            stringDefault = null;
            if (ini != null) {
                stringDefault = ini.getString("startup", "config2", this.updateDefaultConfig2("FFFFFFFF"));
                this.fInitialConfig2.setText(this.stringConformToHex(stringDefault));
            } else {
                stringDefault = this.updateDefaultConfig2(PersistentPreferences.getOpenOCDInitialConfig2());
                this.fInitialConfig2.setText(configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.initialConfig2", stringDefault));
            }
            stringDefault = null;
            if (ini != null) {
                stringDefault = ini.getString("startup", "config3", "FFFFFFFF");
                this.fInitialConfig3.setText(this.stringConformToHex(stringDefault));
            } else {
                stringDefault = PersistentPreferences.getOpenOCDInitialConfig3();
                this.fInitialConfig3.setText(configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.initialConfig3", stringDefault));
            }
            this.updateNUC400AEConfig3();
            stringDefault = null;
            if (ini != null) {
                stringDefault = ini.getString("startup", "writeLock", this.booleanToString(false));
                this.fWriteLock.setSelection(this.stringToBoolean(stringDefault));
            } else {
                booleanDefault = PersistentPreferences.getOpenOCDInitialWriteLock();
                this.fWriteLock.setSelection(configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.writeLock", booleanDefault));
            }
            stringDefault = null;
            if (ini != null) {
                stringDefault = ini.getString("startup", "NSCBA", "080000");
                this.fInitialNSCBA.setText(this.stringConformToHex(stringDefault));
            } else {
                stringDefault = PersistentPreferences.getOpenOCDInitialNSCBA();
                this.fInitialNSCBA.setText(configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.initialNSCBA", stringDefault));
            }
            stringDefault = null;
            if (ini != null) {
                stringDefault = ini.getString("startup", "SCRLOCK", "5A");
                this.fInitialSCRLOCK.setText(this.stringConformToHex(stringDefault));
            } else {
                stringDefault = PersistentPreferences.getOpenOCDInitialSCRLOCK();
                this.fInitialSCRLOCK.setText(configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.initialSCRLOCK", stringDefault));
            }
            stringDefault = null;
            if (ini != null) {
                stringDefault = ini.getString("startup", "ARLOCK", "5A");
                this.fInitialARLOCK.setText(this.stringConformToHex(stringDefault));
            } else {
                stringDefault = PersistentPreferences.getOpenOCDInitialARLOCK();
                this.fInitialARLOCK.setText(configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.initialARLOCK", stringDefault));
            }
            stringDefault = null;
            if (ini != null) {
                stringDefault = ini.getString("startup", "loadSymbols", this.booleanToString(true));
                this.fLoadSymbols.setSelection(this.stringToBoolean(stringDefault));
            } else {
                this.fLoadSymbols.setSelection(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.loadSymbols", true));
            }
            this.fUseProjectBinaryForSymbols.setSelection(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForSymbols", true));
            this.fUseFileForSymbols.setSelection(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.useFileForSymbols", false));
            this.fSymbolsFileName.setText(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.symbolsFileName", ""));
            stringDefault = null;
            if (ini != null) {
                stringDefault = ini.getString("startup", "symbolsOffset", "");
                this.fSymbolsOffset.setText(this.stringConformToHex(stringDefault));
            } else {
                this.fSymbolsOffset.setText(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.symbolsOffset", ""));
            }
            stringDefault = null;
            if (ini != null) {
                stringDefault = ini.getString("startup", "loadExecutable", this.booleanToString(true));
                this.fLoadExecutable.setSelection(this.stringToBoolean(stringDefault));
            } else {
                this.fLoadExecutable.setSelection(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.loadImage", true));
            }
            this.fUseProjectBinaryForImage.setSelection(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForImage", true));
            this.fUseFileForImage.setSelection(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.useFileForImage", false));
            this.fImageFileName.setText(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.imageFileName", ""));
            stringDefault = null;
            if (ini != null) {
                stringDefault = ini.getString("startup", "imageOffset", "");
                this.fImageOffset.setText(this.stringConformToHex(stringDefault));
            } else {
                this.fImageOffset.setText(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.imageOffset", ""));
            }
            stringDefault = null;
            if (ini != null) {
                stringDefault = ini.getString("startup", "loadExecutableToFlash", this.booleanToString(true));
                this.fLoadExecutableF.setSelection(this.stringToBoolean(stringDefault));
            } else {
                booleanDefault = PersistentPreferences.getOpenOCDLoadImage();
                this.fLoadExecutableF.setSelection(configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.loadImage", booleanDefault));
            }
            booleanDefault = PersistentPreferences.getOpenOCDUseProjectBinaryForImage();
            this.fUseProjectBinaryForImageF.setSelection(configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.useProjBinaryForImage", booleanDefault));
            booleanDefault = PersistentPreferences.getOpenOCDUseFileForImage();
            this.fUseFileForImageF.setSelection(configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.useFileForImage", booleanDefault));
            stringDefault = PersistentPreferences.getOpenOCDImageFileName();
            this.fImageFileNameF.setText(configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.imageFileName", stringDefault));
            stringDefault = null;
            if (ini != null) {
                stringDefault = ini.getString("startup", "imageOffsetInFlash", "");
                this.fImageOffsetF.setText(this.stringConformToHex(stringDefault));
            } else {
                stringDefault = PersistentPreferences.getOpenOCDImageOffset();
                this.fImageOffsetF.setText(configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.imageOffset", stringDefault));
            }
            String programName = CDebugUtils.getProgramName((ILaunchConfiguration)configuration);
            if (programName != null) {
                int lastSlash = programName.indexOf(92);
                if (lastSlash >= 0) {
                    programName = programName.substring(lastSlash + 1);
                }
                if ((lastSlash = programName.indexOf(47)) >= 0) {
                    programName = programName.substring(lastSlash + 1);
                }
                this.fProjBinaryLabel2.setText(programName);
            }
            this.fSavedProgName = programName;
            if (programName != null) {
                int lastDot = programName.indexOf(46);
                if (lastDot >= 0) {
                    programName = String.valueOf(programName.substring(0, lastDot + 1)) + TabStartup.getManagedOutputName(this.fSavedProgName);
                }
                this.fProjBinaryLabel1.setText(programName);
                this.fProjBinaryLabelF.setText(programName);
            }
            this.fSavedProgNameF = programName;
            stringDefault = null;
            if (ini != null) {
                stringDefault = ini.getString("startup", "runResetEnable", this.booleanToString(true));
                this.fDoSecondReset.setSelection(this.stringToBoolean(stringDefault));
            } else {
                booleanDefault = PersistentPreferences.getOpenOCDDoPreRunReset();
                this.fDoSecondReset.setSelection(configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.doSecondReset", booleanDefault));
            }
            stringDefault = null;
            if (ini != null) {
                stringDefault = ini.getString("startup", "runResetType", "init");
                this.fSecondResetType.setText(stringDefault);
            } else {
                stringDefault = PersistentPreferences.getOpenOCDPreRunResetType();
                this.fSecondResetType.setText(configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.secondResetType", stringDefault));
            }
            stringDefault = null;
            if (ini != null) {
                stringDefault = ini.getString("startup", "runOther", "");
                this.fRunCommands.setText(stringDefault);
            } else {
                stringDefault = PersistentPreferences.getOpenOCDPreRunOther();
                this.fRunCommands.setText(configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.otherRunCommands", stringDefault));
            }
            stringDefault = null;
            if (ini != null) {
                stringDefault = ini.getString("startup", "setPCRegister", this.booleanToString(false));
                this.fSetPcRegister.setSelection(this.stringToBoolean(stringDefault));
            } else {
                this.fSetPcRegister.setSelection(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.setPcRegister", false));
            }
            stringDefault = null;
            if (ini != null) {
                stringDefault = ini.getString("startup", "pcRegisterValue", "");
                this.fPcRegister.setText(this.stringConformToHex(stringDefault));
            } else {
                this.fPcRegister.setText(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.pcRegister", ""));
            }
            stringDefault = null;
            if (ini != null) {
                stringDefault = ini.getString("startup", "setStopAtMain", this.booleanToString(true));
                this.fSetStopAt.setSelection(this.stringToBoolean(stringDefault));
            } else {
                this.fSetStopAt.setSelection(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.setStopAt", true));
            }
            this.fStopAt.setText(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.stopAt", "main"));
            stringDefault = null;
            if (ini != null) {
                stringDefault = ini.getString("startup", "doContinue", this.booleanToString(true));
                this.fDoContinue.setSelection(this.stringToBoolean(stringDefault));
            } else {
                this.fDoContinue.setSelection(configuration.getAttribute("com.nuvoton.debug.gdbjtag.nulink.doContinue", true));
            }
            this.doFirstResetChanged();
            this.chipSeriesChanged();
            this.writeConfigChanged();
            this.writeLockChanged();
            this.doSecondResetChanged();
            this.loadExecutableFChanged();
            this.loadExecutableChanged();
            this.loadSymbolsChanged();
            this.pcRegisterChanged();
            this.stopAtChanged();
            this.updateUseFileEnablement();
        }
        catch (CoreException e) {
            Activator.log((IStatus)e.getStatus());
        }
    }

    public void initializeFromDefaults() {
        this.fDoFirstReset.setSelection(true);
        this.fFirstResetType.setText("init");
        this.fEnableSemihosting.setSelection(true);
        this.fChipErase.setSelection(false);
        this.fNonSecure.setSelection(false);
        this.fWriteConfig.setSelection(false);
        this.fInitialConfig0.setText(this.updateDefaultConfig0("FFFFFFFF"));
        this.fInitialConfig1.setText("FFFFFFFF");
        this.fInitialConfig2.setText(this.updateDefaultConfig2("FFFFFFFF"));
        this.fInitialConfig3.setText("FFFFFFFF");
        this.updateNUC400AEConfig3();
        this.fWriteLock.setSelection(false);
        this.fInitialNSCBA.setText("080000");
        this.fInitialSCRLOCK.setText("5A");
        this.fInitialARLOCK.setText("5A");
        this.fInitCommands.setText("");
        this.fLoadSymbols.setSelection(true);
        this.fUseProjectBinaryForSymbols.setSelection(true);
        this.fUseFileForSymbols.setSelection(false);
        this.fSymbolsFileName.setText("");
        this.fSymbolsOffset.setText("");
        this.fLoadExecutable.setSelection(true);
        this.fUseProjectBinaryForImage.setSelection(true);
        this.fUseFileForImage.setSelection(false);
        this.fImageFileName.setText("");
        this.fImageOffset.setText("");
        this.fLoadExecutableF.setSelection(true);
        this.fUseProjectBinaryForImageF.setSelection(true);
        this.fUseFileForImageF.setSelection(false);
        this.fImageFileNameF.setText("");
        this.fImageOffsetF.setText("");
        String programName = this.fSavedProgName;
        if (programName != null) {
            this.fProjBinaryLabel2.setText(programName);
        }
        if ((programName = this.fSavedProgNameF) != null) {
            this.fProjBinaryLabel1.setText(programName);
            this.fProjBinaryLabelF.setText(programName);
        }
        this.fDoSecondReset.setSelection(true);
        this.fSecondResetType.setText("init");
        this.fRunCommands.setText("");
        this.fSetPcRegister.setSelection(false);
        this.fPcRegister.setText("");
        this.fSetStopAt.setSelection(true);
        this.fStopAt.setText("main");
        this.fDoContinue.setSelection(true);
        this.doFirstResetChanged();
        this.chipSeriesChanged();
        this.writeConfigChanged();
        this.writeLockChanged();
        this.doSecondResetChanged();
        this.loadExecutableFChanged();
        this.loadExecutableChanged();
        this.loadSymbolsChanged();
        this.pcRegisterChanged();
        this.stopAtChanged();
        this.updateUseFileEnablement();
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        IniFile ini = null;
        try {
            ini = this.getIniFromProgramPath((ILaunchConfiguration)configuration);
        }
        catch (CoreException coreException) {}
        boolean booleanValue = this.fDoFirstReset.getSelection();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.doFirstReset", booleanValue);
        PersistentPreferences.putOpenOCDDoInitialReset(booleanValue);
        if (ini != null) {
            ini.putString("startup", "initResetEnable", this.booleanToString(booleanValue));
        }
        String stringValue = this.fFirstResetType.getText().trim();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.firstResetType", stringValue);
        PersistentPreferences.putOpenOCDInitialResetType(stringValue);
        if (ini != null) {
            ini.putString("startup", "initResetType", stringValue);
        }
        stringValue = this.fInitCommands.getText().trim();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.otherInitCommands", stringValue);
        PersistentPreferences.putOpenOCDInitOther(stringValue);
        if (ini != null) {
            ini.putString("startup", "initOther", stringValue);
        }
        booleanValue = this.fEnableSemihosting.getSelection();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.enableSemihosting", booleanValue);
        PersistentPreferences.putOpenOCDEnableSemihosting(booleanValue);
        if (ini != null) {
            ini.putString("startup", "enableSemihosting", this.booleanToString(booleanValue));
        }
        booleanValue = this.fChipErase.getSelection();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.chipErase", booleanValue);
        PersistentPreferences.putOpenOCDChipErase(booleanValue);
        if (ini != null) {
            ini.putString("startup", "chipErase", this.booleanToString(booleanValue));
        }
        stringValue = this.fChipSeries.getText().trim();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.chipSeries", stringValue);
        PersistentPreferences.putOpenOCDChipSeries(stringValue);
        if (ini != null) {
            ini.putString("startup", "chipSeries", stringValue);
        }
        stringValue = this.fTargetChip.getText().trim();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.targetChip", stringValue);
        PersistentPreferences.putOpenOCDTargetChip(stringValue);
        if (ini != null) {
            ini.putString("startup", "targetChip", stringValue);
        }
        booleanValue = this.fNonSecure.getSelection();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.nonSecure", booleanValue);
        PersistentPreferences.putOpenOCDInitialNonSecure(booleanValue);
        if (ini != null) {
            if (this.fNonSecure.isVisible()) {
                ini.putString("startup", "nonSecure", this.booleanToString(booleanValue));
            } else {
                ini.removeSetByKey("startup", "nonSecure");
            }
        }
        booleanValue = this.fWriteConfig.getSelection();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.writeConifg", booleanValue);
        PersistentPreferences.putOpenOCDInitialWriteConfig(booleanValue);
        if (ini != null) {
            ini.putString("startup", "writeConfig", this.booleanToString(booleanValue));
        }
        if (this.fInitialConfig0.getText().length() == 0) {
            this.fInitialConfig0.setText(this.updateDefaultConfig0("FFFFFFFF"));
        }
        stringValue = this.fInitialConfig0.getText().trim();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.initialConfig0", stringValue);
        PersistentPreferences.putOpenOCDInitialConfig0(stringValue);
        if (ini != null) {
            if (this.fInitialConfig0.isVisible()) {
                ini.putString("startup", "config0", stringValue == "" ? "" : "0x" + stringValue);
            } else {
                ini.removeSetByKey("startup", "config0");
            }
        }
        if (this.fInitialConfig1.getText().length() == 0) {
            this.fInitialConfig1.setText("FFFFFFFF");
        }
        stringValue = this.fInitialConfig1.getText().trim();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.initialConfig1", stringValue);
        PersistentPreferences.putOpenOCDInitialConfig1(stringValue);
        if (ini != null) {
            if (this.fInitialConfig1.isVisible()) {
                ini.putString("startup", "config1", stringValue == "" ? "" : "0x" + stringValue);
            } else {
                ini.removeSetByKey("startup", "config1");
            }
        }
        if (this.fInitialConfig2.getText().length() == 0) {
            this.fInitialConfig2.setText(this.updateDefaultConfig2("FFFFFFFF"));
        }
        stringValue = this.fInitialConfig2.getText().trim();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.initialConfig2", stringValue);
        PersistentPreferences.putOpenOCDInitialConfig2(stringValue);
        if (ini != null) {
            if (this.fInitialConfig2.isVisible()) {
                ini.putString("startup", "config2", stringValue == "" ? "" : "0x" + stringValue);
            } else {
                ini.removeSetByKey("startup", "config2");
            }
        }
        if (this.fInitialConfig3.getText().length() == 0) {
            this.fInitialConfig3.setText("FFFFFFFF");
            this.updateNUC400AEConfig3();
        }
        stringValue = this.fInitialConfig3.getText().trim();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.initialConfig3", stringValue);
        PersistentPreferences.putOpenOCDInitialConfig3(stringValue);
        if (ini != null) {
            if (this.fInitialConfig3.isVisible()) {
                ini.putString("startup", "config3", stringValue == "" ? "" : "0x" + stringValue);
            } else {
                ini.removeSetByKey("startup", "config3");
            }
        }
        booleanValue = this.fWriteLock.getSelection();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.writeLock", booleanValue);
        PersistentPreferences.putOpenOCDInitialWriteLock(booleanValue);
        if (ini != null) {
            if (this.fWriteLock.isVisible()) {
                ini.putString("startup", "writeLock", this.booleanToString(booleanValue));
            } else {
                ini.removeSetByKey("startup", "writeLock");
            }
        }
        if (this.fInitialNSCBA.getText().length() == 0) {
            this.fInitialNSCBA.setText("080000");
        }
        stringValue = this.fInitialNSCBA.getText().trim();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.initialNSCBA", stringValue);
        PersistentPreferences.putOpenOCDInitialNSCBA(stringValue);
        if (ini != null) {
            if (this.fInitialNSCBA.isVisible()) {
                ini.putString("startup", "NSCBA", stringValue == "" ? "" : "0x" + stringValue);
            } else {
                ini.removeSetByKey("startup", "NSCBA");
            }
        }
        if (this.fInitialSCRLOCK.getText().length() == 0) {
            this.fInitialSCRLOCK.setText("5A");
        }
        stringValue = this.fInitialSCRLOCK.getText().trim();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.initialSCRLOCK", stringValue);
        PersistentPreferences.putOpenOCDInitialSCRLOCK(stringValue);
        if (ini != null) {
            if (this.fInitialSCRLOCK.isVisible()) {
                ini.putString("startup", "SCRLOCK", stringValue == "" ? "" : "0x" + stringValue);
            } else {
                ini.removeSetByKey("startup", "SCRLOCK");
            }
        }
        if (this.fInitialARLOCK.getText().length() == 0) {
            this.fInitialARLOCK.setText("5A");
        }
        stringValue = this.fInitialARLOCK.getText().trim();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.initialARLOCK", stringValue);
        PersistentPreferences.putOpenOCDInitialARLOCK(stringValue);
        if (ini != null) {
            if (this.fInitialARLOCK.isVisible()) {
                ini.putString("startup", "ARLOCK", stringValue == "" ? "" : "0x" + stringValue);
            } else {
                ini.removeSetByKey("startup", "ARLOCK");
            }
        }
        booleanValue = this.fLoadSymbols.getSelection();
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.loadSymbols", booleanValue);
        if (ini != null) {
            ini.putString("startup", "loadSymbols", this.booleanToString(booleanValue));
        }
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForSymbols", this.fUseProjectBinaryForSymbols.getSelection());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useFileForSymbols", this.fUseFileForSymbols.getSelection());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.symbolsFileName", this.fSymbolsFileName.getText().trim());
        stringValue = this.fSymbolsOffset.getText().trim();
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.symbolsOffset", stringValue);
        if (ini != null) {
            ini.putString("startup", "symbolsOffset", stringValue == "" ? "" : "0x" + stringValue);
        }
        booleanValue = this.fLoadExecutable.getSelection();
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.loadImage", booleanValue);
        if (ini != null) {
            ini.putString("startup", "loadExecutable", this.booleanToString(booleanValue));
        }
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForImage", this.fUseProjectBinaryForImage.getSelection());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useFileForImage", this.fUseFileForImage.getSelection());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.imageFileName", this.fImageFileName.getText().trim());
        stringValue = this.fImageOffset.getText().trim();
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.imageOffset", stringValue);
        if (ini != null) {
            ini.putString("startup", "imageOffset", stringValue == "" ? "" : "0x" + stringValue);
        }
        booleanValue = this.fLoadExecutableF.getSelection();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.loadImage", booleanValue);
        if (ini != null) {
            ini.putString("startup", "loadExecutableToFlash", this.booleanToString(booleanValue));
        }
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.useProjBinaryForImage", this.fUseProjectBinaryForImageF.getSelection());
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.useFileForImage", this.fUseFileForImageF.getSelection());
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.imageFileName", this.fImageFileNameF.getText().trim());
        stringValue = this.fImageOffsetF.getText().trim();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.imageOffset", stringValue);
        if (ini != null) {
            ini.putString("startup", "imageOffsetInFlash", stringValue == "" ? "" : "0x" + stringValue);
        }
        booleanValue = this.fDoSecondReset.getSelection();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.doSecondReset", booleanValue);
        PersistentPreferences.putOpenOCDDoPreRunReset(booleanValue);
        if (ini != null) {
            ini.putString("startup", "runResetEnable", this.booleanToString(booleanValue));
        }
        stringValue = this.fSecondResetType.getText().trim();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.secondResetType", stringValue);
        PersistentPreferences.putOpenOCDPreRunResetType(stringValue);
        if (ini != null) {
            ini.putString("startup", "runResetType", stringValue);
        }
        stringValue = this.fRunCommands.getText().trim();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.otherRunCommands", stringValue);
        PersistentPreferences.putOpenOCDPreRunOther(stringValue);
        if (ini != null) {
            ini.putString("startup", "runOther", stringValue);
        }
        booleanValue = this.fSetPcRegister.getSelection();
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.setPcRegister", booleanValue);
        if (ini != null) {
            ini.putString("startup", "setPCRegister", this.booleanToString(booleanValue));
        }
        stringValue = this.fPcRegister.getText().trim();
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.pcRegister", stringValue);
        if (ini != null) {
            ini.putString("startup", "pcRegisterValue", stringValue == "" ? "" : "0x" + stringValue);
        }
        booleanValue = this.fSetStopAt.getSelection();
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.setStopAt", booleanValue);
        if (ini != null) {
            ini.putString("startup", "setStopAtMain", this.booleanToString(booleanValue));
        }
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.stopAt", this.fStopAt.getText());
        booleanValue = this.fDoContinue.getSelection();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.doContinue", booleanValue);
        if (ini != null) {
            ini.putString("startup", "doContinue", this.booleanToString(booleanValue));
        }
        PersistentPreferences.flush();
        if (ini != null) {
            try {
                ini.unload();
            }
            catch (IOException iOException) {}
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        boolean defaultBoolean = PersistentPreferences.getOpenOCDDoInitialReset();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.doFirstReset", defaultBoolean);
        String defaultString = PersistentPreferences.getOpenOCDInitialResetType();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.firstResetType", defaultString);
        defaultBoolean = PersistentPreferences.getOpenOCDEnableSemihosting();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.enableSemihosting", defaultBoolean);
        defaultString = PersistentPreferences.getOpenOCDChipSeries();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.chipSeries", defaultString);
        defaultString = PersistentPreferences.getOpenOCDTargetChip();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.targetChip", defaultString);
        defaultString = PersistentPreferences.getOpenOCDInitOther();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.otherInitCommands", defaultString);
        defaultBoolean = PersistentPreferences.getOpenOCDInitialWriteConfig();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.writeConifg", defaultBoolean);
        defaultString = this.updateDefaultConfig0(PersistentPreferences.getOpenOCDInitialConfig0());
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.initialConfig0", defaultString);
        defaultString = PersistentPreferences.getOpenOCDInitialConfig1();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.initialConfig1", defaultString);
        defaultString = this.updateDefaultConfig2(PersistentPreferences.getOpenOCDInitialConfig2());
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.initialConfig2", defaultString);
        defaultString = PersistentPreferences.getOpenOCDInitialConfig3();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.initialConfig3", defaultString);
        defaultBoolean = PersistentPreferences.getOpenOCDInitialWriteLock();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.writeLock", defaultBoolean);
        defaultString = PersistentPreferences.getOpenOCDInitialNSCBA();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.initialNSCBA", defaultString);
        defaultString = PersistentPreferences.getOpenOCDInitialSCRLOCK();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.initialSCRLOCK", defaultString);
        defaultString = PersistentPreferences.getOpenOCDInitialARLOCK();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.initialARLOCK", defaultString);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.loadImage", true);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForImage", true);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useFileForImage", false);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.imageFileName", "");
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.imageOffset", "");
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.loadSymbols", true);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForSymbols", true);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useFileForSymbols", false);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.symbolsFileName", "");
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.symbolsOffset", "");
        defaultBoolean = PersistentPreferences.getOpenOCDLoadImage();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.loadImage", defaultBoolean);
        defaultBoolean = PersistentPreferences.getOpenOCDUseProjectBinaryForImage();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.useProjBinaryForImage", defaultBoolean);
        defaultBoolean = PersistentPreferences.getOpenOCDUseFileForImage();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.useFileForImage", defaultBoolean);
        defaultString = PersistentPreferences.getOpenOCDImageFileName();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.imageFileName", defaultString);
        defaultString = PersistentPreferences.getOpenOCDImageOffset();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.imageOffset", defaultString);
        defaultBoolean = PersistentPreferences.getOpenOCDDebugInRam();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.doDebugInRam", defaultBoolean);
        defaultBoolean = PersistentPreferences.getOpenOCDDoPreRunReset();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.doSecondReset", defaultBoolean);
        defaultString = PersistentPreferences.getOpenOCDPreRunResetType();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.secondResetType", defaultString);
        defaultString = PersistentPreferences.getOpenOCDPreRunOther();
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.otherRunCommands", defaultString);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.setPcRegister", false);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.pcRegister", "");
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.setStopAt", true);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.stopAt", "main");
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.setResume", false);
        configuration.setAttribute("com.nuvoton.debug.gdbjtag.nulink.doContinue", true);
    }
}

