/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.trace.indexer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.Arrays;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.internal.tmf.core.trace.indexer.BTree;
import org.eclipse.tracecompass.internal.tmf.core.trace.indexer.Messages;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint.ITmfCheckpoint;
import org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint.TmfCheckpoint;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;

class BTreeNode {
    static final int NULL_CHILD = -1;
    private final ITmfCheckpoint[] fEntries;
    private final long[] fChildrenFileOffsets;
    private final long fFileOffset;
    private final BTree fTree;
    private int fNumEntries = 0;
    private boolean fIsDirty = true;

    BTreeNode(BTree tree, long offset) {
        if (offset < 0L) {
            throw new IllegalStateException("Invalid node offset: " + offset);
        }
        this.fTree = tree;
        this.fFileOffset = offset;
        this.fEntries = new ITmfCheckpoint[this.fTree.getMaxNumEntries()];
        this.fChildrenFileOffsets = new long[this.fTree.getMaxNumChildren()];
        Arrays.fill(this.fChildrenFileOffsets, -1L);
    }

    long getOffset() {
        return this.fFileOffset;
    }

    void serializeIn() {
        try {
            this.fTree.getRandomAccessFile().seek(this.fFileOffset);
            ByteBuffer bb = this.fTree.getNodeByteBuffer();
            bb.clear();
            this.fTree.getRandomAccessFile().read(bb.array());
            int i = 0;
            while (i < this.fTree.getMaxNumChildren()) {
                long offset = bb.getLong();
                if (offset < 0L && offset != -1L) {
                    throw new IllegalStateException("Invalid node offset: " + offset);
                }
                this.fChildrenFileOffsets[i] = offset;
                ++i;
            }
            this.fNumEntries = bb.getInt();
            i = 0;
            while (i < this.fNumEntries) {
                ITmfLocation location = this.fTree.getTrace().restoreLocation(bb);
                TmfTimestamp timeStamp = new TmfTimestamp(bb);
                TmfCheckpoint c = new TmfCheckpoint((ITmfTimestamp)timeStamp, location, bb);
                this.fEntries[i] = c;
                ++i;
            }
            this.fIsDirty = false;
        }
        catch (IOException e) {
            Activator.logError(MessageFormat.format(Messages.BTreeNode_IOErrorLoading, this.fFileOffset, this.fTree.getRandomAccessFile()), e);
        }
    }

    void serializeOut() {
        try {
            this.fTree.getRandomAccessFile().seek(this.fFileOffset);
            ByteBuffer bb = this.fTree.getNodeByteBuffer();
            bb.clear();
            int i = 0;
            while (i < this.fTree.getMaxNumChildren()) {
                bb.putLong(this.fChildrenFileOffsets[i]);
                ++i;
            }
            bb.putInt(this.fNumEntries);
            i = 0;
            while (i < this.fNumEntries) {
                ITmfCheckpoint key = this.fEntries[i];
                key.serialize(bb);
                ++i;
            }
            this.fTree.getRandomAccessFile().write(bb.array());
            this.fIsDirty = false;
        }
        catch (IOException e) {
            Activator.logError(MessageFormat.format(Messages.BTreeNode_IOErrorWriting, this.fFileOffset, this.fTree.getRandomAccessFile()), e);
        }
    }

    ITmfCheckpoint getEntry(int index) {
        return this.fEntries[index];
    }

    long getChild(int index) {
        long childOffset = this.fChildrenFileOffsets[index];
        if (childOffset < 0L && childOffset != -1L) {
            throw new IllegalStateException("Invalid node offset: " + childOffset);
        }
        return childOffset;
    }

    void setEntry(int index, ITmfCheckpoint checkpoint) {
        this.fIsDirty = true;
        if (this.fEntries[index] == null && checkpoint != null) {
            ++this.fNumEntries;
        } else if (this.fEntries[index] != null && checkpoint == null) {
            this.fNumEntries = Math.max(0, this.fNumEntries - 1);
        }
        this.fEntries[index] = checkpoint;
    }

    void setChild(int index, long offset) {
        this.fIsDirty = true;
        this.fChildrenFileOffsets[index] = offset;
    }

    boolean isDirty() {
        return this.fIsDirty;
    }
}

