/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.ui.views.resources;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.ui.views.resources.ResourcesEntry;
import org.eclipse.tracecompass.analysis.os.linux.ui.views.resources.ResourcesPresentationProvider;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.Messages;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractStateSystemTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public class ResourcesView
extends AbstractStateSystemTimeGraphView {
    public static final String ID = "org.eclipse.tracecompass.analysis.os.linux.views.resources";
    private static final String[] FILTER_COLUMN_NAMES = new String[]{Messages.ResourcesView_stateTypeName};
    private static final long BUILD_UPDATE_TIMEOUT = 500L;

    public ResourcesView() {
        super(ID, (TimeGraphPresentationProvider)new ResourcesPresentationProvider());
        this.setFilterColumns(FILTER_COLUMN_NAMES);
        this.setFilterLabelProvider(new ResourcesFilterLabelProvider());
        this.setEntryComparator(new ResourcesEntryComparator());
    }

    protected String getNextText() {
        return Messages.ResourcesView_nextResourceActionNameText;
    }

    protected String getNextTooltip() {
        return Messages.ResourcesView_nextResourceActionToolTipText;
    }

    protected String getPrevText() {
        return Messages.ResourcesView_previousResourceActionNameText;
    }

    protected String getPrevTooltip() {
        return Messages.ResourcesView_previousResourceActionToolTipText;
    }

    protected void buildEventList(ITmfTrace trace, ITmfTrace parentTrace, final IProgressMonitor monitor) {
        long startTime;
        final ITmfStateSystem ssq = TmfStateSystemAnalysisModule.getStateSystem((ITmfTrace)trace, (String)"org.eclipse.tracecompass.analysis.os.linux.kernel");
        if (ssq == null) {
            return;
        }
        HashMap<Integer, ResourcesEntry> entryMap = new HashMap<Integer, ResourcesEntry>();
        ResourcesEntry traceEntry = null;
        long start = startTime = ssq.getStartTime();
        this.setStartTime(Math.min(this.getStartTime(), startTime));
        boolean complete = false;
        while (!complete) {
            if (monitor.isCanceled()) {
                return;
            }
            complete = ssq.waitUntilBuilt(500L);
            if (ssq.isCancelled()) {
                return;
            }
            long end = ssq.getCurrentEndTime();
            if (start == end && !complete) continue;
            long endTime = end + 1L;
            this.setEndTime(Math.max(this.getEndTime(), endTime));
            if (traceEntry == null) {
                traceEntry = new ResourcesEntry(trace, trace.getName(), startTime, endTime, 0);
                List<ResourcesEntry> entryList = Collections.singletonList(traceEntry);
                this.addToEntryList(parentTrace, ssq, entryList);
            } else {
                traceEntry.updateEndTime(endTime);
            }
            List cpuQuarks = ssq.getQuarks(new String[]{"CPUs", "*"});
            for (Integer cpuQuark : cpuQuarks) {
                int cpu = Integer.parseInt(ssq.getAttributeName(cpuQuark.intValue()));
                ResourcesEntry entry = (ResourcesEntry)entryMap.get(cpuQuark);
                if (entry == null) {
                    entry = new ResourcesEntry(cpuQuark, trace, startTime, endTime, ResourcesEntry.Type.CPU, cpu);
                    entryMap.put(cpuQuark, entry);
                    traceEntry.addChild(entry);
                    continue;
                }
                entry.updateEndTime(endTime);
            }
            List irqQuarks = ssq.getQuarks(new String[]{"Resources", "IRQs", "*"});
            for (Integer irqQuark : irqQuarks) {
                int irq = Integer.parseInt(ssq.getAttributeName(irqQuark.intValue()));
                ResourcesEntry entry = (ResourcesEntry)entryMap.get(irqQuark);
                if (entry == null) {
                    entry = new ResourcesEntry(irqQuark, trace, startTime, endTime, ResourcesEntry.Type.IRQ, irq);
                    entryMap.put(irqQuark, entry);
                    traceEntry.addChild(entry);
                    continue;
                }
                entry.updateEndTime(endTime);
            }
            List softIrqQuarks = ssq.getQuarks(new String[]{"Resources", "Soft_IRQs", "*"});
            for (Integer softIrqQuark : softIrqQuarks) {
                int softIrq = Integer.parseInt(ssq.getAttributeName(softIrqQuark.intValue()));
                ResourcesEntry entry = (ResourcesEntry)entryMap.get(softIrqQuark);
                if (entry == null) {
                    entry = new ResourcesEntry(softIrqQuark, trace, startTime, endTime, ResourcesEntry.Type.SOFT_IRQ, softIrq);
                    entryMap.put(softIrqQuark, entry);
                    traceEntry.addChild(entry);
                    continue;
                }
                entry.updateEndTime(endTime);
            }
            if (parentTrace.equals(this.getTrace())) {
                this.refresh();
            }
            final List traceEntryChildren = traceEntry.getChildren();
            long resolution = Math.max(1L, (endTime - ssq.getStartTime()) / (long)this.getDisplayWidth());
            long qStart = start;
            long qEnd = end;
            this.queryFullStates(ssq, qStart, qEnd, resolution, monitor, new AbstractStateSystemTimeGraphView.IQueryHandler(){

                public void handle(List<List<ITmfStateInterval>> fullStates, List<ITmfStateInterval> prevFullState) {
                    for (ITimeGraphEntry child : traceEntryChildren) {
                        TimeGraphEntry entry;
                        List<ITimeEvent> eventList;
                        if (monitor.isCanceled()) {
                            return;
                        }
                        if (!(child instanceof TimeGraphEntry) || (eventList = ResourcesView.this.getEventList(entry = (TimeGraphEntry)child, ssq, fullStates, prevFullState, monitor)) == null) continue;
                        for (ITimeEvent event : eventList) {
                            entry.addEvent(event);
                        }
                    }
                }
            });
            start = end;
        }
    }

    @Nullable
    protected List<ITimeEvent> getEventList(@NonNull TimeGraphEntry entry, ITmfStateSystem ssq, @NonNull List<List<ITmfStateInterval>> fullStates, @Nullable List<ITmfStateInterval> prevFullState, @NonNull IProgressMonitor monitor) {
        ArrayList<Object> eventList;
        block13: {
            int quark;
            ResourcesEntry resourcesEntry;
            block12: {
                int statusQuark;
                resourcesEntry = (ResourcesEntry)entry;
                eventList = null;
                quark = resourcesEntry.getQuark();
                if (!resourcesEntry.getType().equals((Object)ResourcesEntry.Type.CPU)) break block12;
                try {
                    statusQuark = ssq.getQuarkRelative(quark, new String[]{"Status"});
                }
                catch (AttributeNotFoundException e) {
                    return null;
                }
                eventList = new ArrayList(fullStates.size());
                ITmfStateInterval lastInterval = prevFullState == null || statusQuark >= prevFullState.size() ? null : prevFullState.get(statusQuark);
                long lastStartTime = lastInterval == null ? -1L : lastInterval.getStartTime();
                long lastEndTime = lastInterval == null ? -1L : lastInterval.getEndTime() + 1L;
                for (List<ITmfStateInterval> fullState : fullStates) {
                    if (monitor.isCanceled()) {
                        return null;
                    }
                    if (statusQuark >= fullState.size()) continue;
                    ITmfStateInterval statusInterval = fullState.get(statusQuark);
                    int status = statusInterval.getStateValue().unboxInt();
                    long time = statusInterval.getStartTime();
                    long duration = statusInterval.getEndTime() - time + 1L;
                    if (time == lastStartTime) continue;
                    if (!statusInterval.getStateValue().isNull()) {
                        if (lastEndTime != time && lastEndTime != -1L) {
                            eventList.add(new TimeEvent((ITimeGraphEntry)entry, lastEndTime, time - lastEndTime));
                        }
                        eventList.add(new TimeEvent((ITimeGraphEntry)entry, time, duration, status));
                    } else {
                        eventList.add(new NullTimeEvent((ITimeGraphEntry)entry, time, duration));
                    }
                    lastStartTime = time;
                    lastEndTime = time + duration;
                }
                break block13;
            }
            if (!resourcesEntry.getType().equals((Object)ResourcesEntry.Type.IRQ) && !resourcesEntry.getType().equals((Object)ResourcesEntry.Type.SOFT_IRQ)) break block13;
            eventList = new ArrayList<ITimeEvent>(fullStates.size());
            ITmfStateInterval lastInterval = prevFullState == null ? null : prevFullState.get(quark);
            long lastStartTime = lastInterval == null ? -1L : lastInterval.getStartTime();
            long lastEndTime = lastInterval == null ? -1L : lastInterval.getEndTime() + 1L;
            boolean lastIsNull = lastInterval == null ? false : lastInterval.getStateValue().isNull();
            for (List<ITmfStateInterval> fullState : fullStates) {
                if (monitor.isCanceled()) {
                    return null;
                }
                ITmfStateInterval irqInterval = fullState.get(quark);
                long time = irqInterval.getStartTime();
                long duration = irqInterval.getEndTime() - time + 1L;
                if (time == lastStartTime) continue;
                if (!irqInterval.getStateValue().isNull()) {
                    int cpu = irqInterval.getStateValue().unboxInt();
                    eventList.add(new TimeEvent((ITimeGraphEntry)entry, time, duration, cpu));
                    lastIsNull = false;
                } else {
                    if (lastEndTime != time && lastIsNull) {
                        eventList.add(new TimeEvent((ITimeGraphEntry)entry, lastEndTime, time - lastEndTime, -1));
                    }
                    eventList.add((ITimeEvent)new NullTimeEvent((ITimeGraphEntry)entry, time, duration));
                    lastIsNull = true;
                }
                lastStartTime = time;
                lastEndTime = time + duration;
            }
        }
        return eventList;
    }

    private static class ResourcesEntryComparator
    implements Comparator<ITimeGraphEntry> {
        private ResourcesEntryComparator() {
        }

        @Override
        public int compare(ITimeGraphEntry o1, ITimeGraphEntry o2) {
            ResourcesEntry entry1 = (ResourcesEntry)o1;
            ResourcesEntry entry2 = (ResourcesEntry)o2;
            if (entry1.getType() == ResourcesEntry.Type.NULL && entry2.getType() == ResourcesEntry.Type.NULL) {
                return entry1.getName().compareTo(entry2.getName());
            }
            return entry1.compareTo((ITimeGraphEntry)entry2);
        }
    }

    private static class ResourcesFilterLabelProvider
    extends AbstractTimeGraphView.TreeLabelProvider {
        private ResourcesFilterLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            ResourcesEntry entry = (ResourcesEntry)element;
            if (columnIndex == 0) {
                return entry.getName();
            }
            return "";
        }
    }
}

