/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferListener;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.ui.IQueryListener;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search.ui.text.MatchEvent;
import org.eclipse.search.ui.text.RemoveAllEvent;

public class PositionTracker
implements IQueryListener,
ISearchResultListener,
IFileBufferListener {
    private Map fMatchesToPositions = new HashMap();
    private Map fMatchesToSearchResults = new HashMap();
    private Map fFileBuffersToMatches = new HashMap();

    public PositionTracker() {
        NewSearchUI.addQueryListener(this);
        FileBuffers.getTextFileBufferManager().addFileBufferListener((IFileBufferListener)this);
    }

    public void queryAdded(ISearchQuery query) {
        if (query.getSearchResult() instanceof AbstractTextSearchResult) {
            query.getSearchResult().addListener(this);
        }
    }

    public void queryRemoved(ISearchQuery query) {
        ISearchResult result = query.getSearchResult();
        if (result instanceof AbstractTextSearchResult) {
            this.untrackAll((AbstractTextSearchResult)result);
            result.removeListener(this);
        }
    }

    public void searchResultChanged(SearchResultEvent e) {
        if (e instanceof MatchEvent) {
            MatchEvent evt = (MatchEvent)e;
            Match[] matches = evt.getMatches();
            int kind = evt.getKind();
            AbstractTextSearchResult result = (AbstractTextSearchResult)e.getSearchResult();
            int i = 0;
            while (i < matches.length) {
                ITextFileBuffer fb = this.getTrackedFileBuffer(result, matches[i].getElement());
                if (fb != null) {
                    this.updateMatch(matches[i], fb, kind, result);
                }
                ++i;
            }
        } else if (e instanceof RemoveAllEvent) {
            RemoveAllEvent evt = (RemoveAllEvent)e;
            ISearchResult result = evt.getSearchResult();
            this.untrackAll((AbstractTextSearchResult)result);
        }
    }

    private void updateMatch(Match match, ITextFileBuffer fb, int kind, AbstractTextSearchResult result) {
        if (kind == 1) {
            this.trackPosition(result, fb, match);
        } else if (kind == 2) {
            this.untrackPosition(fb, match);
        }
    }

    private void untrackAll(AbstractTextSearchResult result) {
        HashSet matchSet = new HashSet(this.fMatchesToPositions.keySet());
        Iterator matches = matchSet.iterator();
        while (matches.hasNext()) {
            ITextFileBuffer fb;
            Match match = (Match)matches.next();
            AbstractTextSearchResult matchContainer = (AbstractTextSearchResult)this.fMatchesToSearchResults.get(match);
            if (!result.equals(matchContainer) || (fb = this.getTrackedFileBuffer(result, match.getElement())) == null) continue;
            this.untrackPosition(fb, match);
        }
    }

    private void untrackPosition(ITextFileBuffer fb, Match match) {
        Position position = (Position)this.fMatchesToPositions.get(match);
        if (position != null) {
            this.removeFileBufferMapping(fb, match);
            this.fMatchesToSearchResults.remove(match);
            this.fMatchesToPositions.remove(match);
            fb.getDocument().removePosition(position);
        }
    }

    private void trackPosition(AbstractTextSearchResult result, ITextFileBuffer fb, Match match) {
        int offset = match.getOffset();
        int length = match.getLength();
        if (offset < 0 || length < 0) {
            return;
        }
        try {
            IDocument doc = fb.getDocument();
            Position position = new Position(offset, length);
            if (match.getBaseUnit() == 1) {
                position = PositionTracker.convertToCharacterPosition(position, doc);
            }
            doc.addPosition(position);
            this.fMatchesToSearchResults.put(match, result);
            this.fMatchesToPositions.put(match, position);
            this.addFileBufferMapping(fb, match);
        }
        catch (BadLocationException badLocationException) {
            result.removeMatch(match);
        }
    }

    public static Position convertToCharacterPosition(Position linePosition, IDocument doc) throws BadLocationException {
        int lineOffset = linePosition.getOffset();
        int lineLength = linePosition.getLength();
        int charOffset = doc.getLineOffset(lineOffset);
        int charLength = 0;
        if (lineLength > 0) {
            int lastLine = lineOffset + lineLength - 1;
            int endPosition = doc.getLineOffset(lastLine) + doc.getLineLength(lastLine);
            charLength = endPosition - charOffset;
        }
        return new Position(charOffset, charLength);
    }

    private void addFileBufferMapping(ITextFileBuffer fb, Match match) {
        HashSet<Match> matches = (HashSet<Match>)this.fFileBuffersToMatches.get(fb);
        if (matches == null) {
            matches = new HashSet<Match>();
            this.fFileBuffersToMatches.put(fb, matches);
        }
        matches.add(match);
    }

    private void removeFileBufferMapping(ITextFileBuffer fb, Match match) {
        Set matches = (Set)this.fFileBuffersToMatches.get(fb);
        if (matches != null) {
            matches.remove(match);
            if (matches.size() == 0) {
                this.fFileBuffersToMatches.remove(fb);
            }
        }
    }

    private ITextFileBuffer getTrackedFileBuffer(AbstractTextSearchResult result, Object element) {
        IFileMatchAdapter adapter = result.getFileMatchAdapter();
        if (adapter == null) {
            return null;
        }
        IFile file = adapter.getFile(element);
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            return null;
        }
        return FileBuffers.getTextFileBufferManager().getTextFileBuffer(file.getFullPath(), LocationKind.IFILE);
    }

    public Position getCurrentPosition(Match match) {
        ITextFileBuffer fb;
        Position pos = (Position)this.fMatchesToPositions.get(match);
        if (pos == null) {
            return pos;
        }
        AbstractTextSearchResult result = (AbstractTextSearchResult)this.fMatchesToSearchResults.get(match);
        if (match.getBaseUnit() == 1 && result != null && (fb = this.getTrackedFileBuffer(result, match.getElement())) != null) {
            IDocument doc = fb.getDocument();
            try {
                pos = PositionTracker.convertToLinePosition(pos, doc);
            }
            catch (BadLocationException badLocationException) {}
        }
        return pos;
    }

    public static Position convertToLinePosition(Position pos, IDocument doc) throws BadLocationException {
        int offset = doc.getLineOfOffset(pos.getOffset());
        int end = doc.getLineOfOffset(pos.getOffset() + pos.getLength());
        int lineLength = end - offset;
        if (pos.getLength() > 0 && lineLength == 0) {
            ++lineLength;
        }
        return new Position(offset, lineLength);
    }

    public void dispose() {
        NewSearchUI.removeQueryListener(this);
        FileBuffers.getTextFileBufferManager().removeFileBufferListener((IFileBufferListener)this);
    }

    public void bufferCreated(IFileBuffer buffer) {
        int[] trackCount = new int[1];
        if (!(buffer instanceof ITextFileBuffer)) {
            return;
        }
        IPath location = buffer.getLocation();
        if (location == null) {
            return;
        }
        IFile file = FileBuffers.getWorkspaceFileAtLocation((IPath)location);
        if (file == null) {
            return;
        }
        ISearchQuery[] queries = NewSearchUI.getQueries();
        int i = 0;
        while (i < queries.length) {
            AbstractTextSearchResult textResult;
            IFileMatchAdapter adapter;
            ISearchResult result = queries[i].getSearchResult();
            if (result instanceof AbstractTextSearchResult && (adapter = (textResult = (AbstractTextSearchResult)result).getFileMatchAdapter()) != null) {
                Match[] matches = adapter.computeContainedMatches(textResult, file);
                int j = 0;
                while (j < matches.length) {
                    trackCount[0] = trackCount[0] + 1;
                    this.trackPosition((AbstractTextSearchResult)result, (ITextFileBuffer)buffer, matches[j]);
                    ++j;
                }
            }
            ++i;
        }
    }

    private void doForExistingMatchesIn(IFileBuffer buffer, IFileBufferMatchOperation operation) {
        if (!(buffer instanceof ITextFileBuffer)) {
            return;
        }
        Set matches = (Set)this.fFileBuffersToMatches.get(buffer);
        if (matches != null) {
            HashSet matchSet = new HashSet(matches);
            Iterator matchIterator = matchSet.iterator();
            while (matchIterator.hasNext()) {
                Match element = (Match)matchIterator.next();
                operation.run((ITextFileBuffer)buffer, element);
            }
        }
    }

    public void bufferDisposed(IFileBuffer buffer) {
        final int[] trackCount = new int[1];
        this.doForExistingMatchesIn(buffer, new IFileBufferMatchOperation(){

            public void run(ITextFileBuffer textBuffer, Match match) {
                trackCount[0] = trackCount[0] + 1;
                PositionTracker.this.untrackPosition(textBuffer, match);
            }
        });
    }

    public void bufferContentAboutToBeReplaced(IFileBuffer buffer) {
    }

    public void bufferContentReplaced(IFileBuffer buffer) {
        final int[] trackCount = new int[1];
        this.doForExistingMatchesIn(buffer, new IFileBufferMatchOperation(){

            public void run(ITextFileBuffer textBuffer, Match match) {
                trackCount[0] = trackCount[0] + 1;
                AbstractTextSearchResult result = (AbstractTextSearchResult)PositionTracker.this.fMatchesToSearchResults.get(match);
                PositionTracker.this.untrackPosition(textBuffer, match);
                PositionTracker.this.trackPosition(result, textBuffer, match);
            }
        });
    }

    public void stateChanging(IFileBuffer buffer) {
    }

    public void dirtyStateChanged(IFileBuffer buffer, boolean isDirty) {
        if (isDirty) {
            return;
        }
        final int[] trackCount = new int[1];
        this.doForExistingMatchesIn(buffer, new IFileBufferMatchOperation(){

            public void run(ITextFileBuffer textBuffer, Match match) {
                trackCount[0] = trackCount[0] + 1;
                Position pos = (Position)PositionTracker.this.fMatchesToPositions.get(match);
                if (pos != null) {
                    if (pos.isDeleted()) {
                        AbstractTextSearchResult result = (AbstractTextSearchResult)PositionTracker.this.fMatchesToSearchResults.get(match);
                        if (result != null) {
                            result.removeMatch(match);
                        }
                        PositionTracker.this.untrackPosition(textBuffer, match);
                    } else {
                        if (match.getBaseUnit() == 1) {
                            try {
                                pos = PositionTracker.convertToLinePosition(pos, textBuffer.getDocument());
                            }
                            catch (BadLocationException e) {
                                SearchPlugin.getDefault().getLog().log((IStatus)new Status(4, SearchPlugin.getID(), 0, e.getLocalizedMessage(), (Throwable)e));
                            }
                        }
                        match.setOffset(pos.getOffset());
                        match.setLength(pos.getLength());
                    }
                }
            }
        });
    }

    public void stateValidationChanged(IFileBuffer buffer, boolean isStateValidated) {
    }

    public void underlyingFileMoved(IFileBuffer buffer, IPath path) {
    }

    public void underlyingFileDeleted(IFileBuffer buffer) {
    }

    public void stateChangeFailed(IFileBuffer buffer) {
    }

    public void queryStarting(ISearchQuery query) {
    }

    public void queryFinished(ISearchQuery query) {
    }

    private static interface IFileBufferMatchOperation {
        public void run(ITextFileBuffer var1, Match var2);
    }
}

