/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.buildproperties;

import org.eclipse.cdt.internal.core.SafeStringInterner;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildProperty;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyType;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyValue;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.buildproperties.BuildPropertiesMessages;
import org.eclipse.cdt.managedbuilder.internal.buildproperties.BuildPropertyManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class BuildProperty
implements IBuildProperty {
    private IBuildPropertyType fType;
    private IBuildPropertyValue fValue;

    BuildProperty(String property) throws CoreException {
        String value;
        String type;
        int index = property.indexOf("=");
        if (index != -1) {
            type = SafeStringInterner.safeIntern((String)property.substring(0, index));
            value = SafeStringInterner.safeIntern((String)property.substring(index + 1));
        } else {
            type = SafeStringInterner.safeIntern((String)property);
            value = null;
        }
        this.fType = BuildPropertyManager.getInstance().getPropertyType(type);
        if (this.fType == null) {
            throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), BuildPropertiesMessages.getString("BuildProperty.0")));
        }
        this.setValue(value);
    }

    BuildProperty(IBuildPropertyType type, String valueId) throws CoreException {
        this.fType = type;
        this.setValue(valueId);
    }

    @Override
    public IBuildPropertyType getPropertyType() {
        return this.fType;
    }

    private void setValue(String id) throws CoreException {
        IBuildPropertyValue value = this.fType.getSupportedValue(id);
        if (value == null) {
            throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), String.valueOf(BuildPropertiesMessages.getString("BuildProperty.1")) + id));
        }
        this.setValue(value);
    }

    private void setValue(IBuildPropertyValue value) {
        this.fValue = value;
    }

    @Override
    public IBuildPropertyValue getValue() {
        return this.fValue;
    }

    public String toString() {
        return BuildProperty.toString(this.fType.toString(), this.fValue.toString());
    }

    public static String toString(String type, String value) {
        StringBuffer buf = new StringBuffer();
        buf.append(type).append("=").append(value);
        return buf.toString();
    }
}

