/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.analysis.xml.core.model.ITmfXmlModelFactory;
import org.eclipse.tracecompass.tmf.analysis.xml.core.model.ITmfXmlStateAttribute;
import org.eclipse.tracecompass.tmf.analysis.xml.core.model.ITmfXmlStateValue;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.w3c.dom.Element;

public class TmfXmlCondition {
    private final List<TmfXmlCondition> fConditions = new ArrayList<TmfXmlCondition>();
    @Nullable
    private final ITmfXmlStateValue fStateValue;
    private final LogicalOperator fOperator;
    private final IXmlStateSystemContainer fContainer;
    private final ConditionOperator fConditionOperator;

    public TmfXmlCondition(ITmfXmlModelFactory modelFactory, Element node, IXmlStateSystemContainer container) {
        this.fContainer = container;
        Element rootNode = node;
        List<Element> childElements = XmlUtils.getChildElements(rootNode);
        if (node.getNodeName().equals("if")) {
            if (childElements.isEmpty()) {
                throw new IllegalArgumentException("TmfXmlCondition constructor: IF node has no child element");
            }
            rootNode = childElements.get(0);
            childElements = XmlUtils.getChildElements(rootNode);
        }
        switch (rootNode.getNodeName()) {
            case "condition": {
                String equationType;
                this.fOperator = LogicalOperator.NONE;
                switch (equationType = rootNode.getAttribute("operator")) {
                    case "eq": {
                        this.fConditionOperator = ConditionOperator.EQ;
                        break;
                    }
                    case "ne": {
                        this.fConditionOperator = ConditionOperator.NE;
                        break;
                    }
                    case "ge": {
                        this.fConditionOperator = ConditionOperator.GE;
                        break;
                    }
                    case "gt": {
                        this.fConditionOperator = ConditionOperator.GT;
                        break;
                    }
                    case "le": {
                        this.fConditionOperator = ConditionOperator.LE;
                        break;
                    }
                    case "lt": {
                        this.fConditionOperator = ConditionOperator.LT;
                        break;
                    }
                    case "": {
                        this.fConditionOperator = ConditionOperator.EQ;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("TmfXmlCondition: invalid comparison operator.");
                    }
                }
                Element stateValueElement = childElements.remove(childElements.size() - 1);
                if (stateValueElement == null) {
                    throw new IllegalStateException();
                }
                if (childElements.size() == 1 && childElements.get(0).getNodeName().equals("field")) {
                    String attribute = childElements.get(0).getAttribute("name");
                    if (attribute == null) {
                        throw new IllegalArgumentException();
                    }
                    this.fStateValue = modelFactory.createStateValue(stateValueElement, this.fContainer, attribute);
                    break;
                }
                ArrayList<ITmfXmlStateAttribute> attributes = new ArrayList<ITmfXmlStateAttribute>();
                for (Element element : childElements) {
                    if (!element.getNodeName().equals("stateAttribute")) {
                        throw new IllegalArgumentException("TmfXmlCondition: a condition either has a eventField element or a number of TmfXmlStateAttribute elements before the state value");
                    }
                    ITmfXmlStateAttribute attribute = modelFactory.createStateAttribute(element, this.fContainer);
                    attributes.add(attribute);
                }
                this.fStateValue = modelFactory.createStateValue(stateValueElement, this.fContainer, attributes);
                break;
            }
            case "not": {
                this.fOperator = LogicalOperator.NOT;
                this.fStateValue = null;
                this.fConditionOperator = ConditionOperator.NONE;
                Element element = childElements.get(0);
                if (element == null) {
                    throw new IllegalArgumentException();
                }
                this.fConditions.add(modelFactory.createCondition(element, this.fContainer));
                break;
            }
            case "and": {
                this.fOperator = LogicalOperator.AND;
                this.fStateValue = null;
                this.fConditionOperator = ConditionOperator.NONE;
                for (Element condition : childElements) {
                    if (condition == null) continue;
                    this.fConditions.add(modelFactory.createCondition(condition, this.fContainer));
                }
                break;
            }
            case "or": {
                this.fOperator = LogicalOperator.OR;
                this.fStateValue = null;
                this.fConditionOperator = ConditionOperator.NONE;
                for (Element condition : childElements) {
                    if (condition == null) continue;
                    this.fConditions.add(modelFactory.createCondition(condition, this.fContainer));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("TmfXmlCondition constructor: XML node is of the wrong type");
            }
        }
    }

    public boolean testForEvent(ITmfEvent event) throws AttributeNotFoundException {
        ITmfStateSystem ss = this.fContainer.getStateSystem();
        if (this.fStateValue != null) {
            ITmfStateValue valueState;
            ITmfXmlStateValue filter = this.fStateValue;
            int quark = -1;
            for (ITmfXmlStateAttribute attribute : filter.getAttributes()) {
                quark = attribute.getAttributeQuark(event, quark);
                if (quark != -1) continue;
                throw new AttributeNotFoundException(String.valueOf(ss.getSSID()) + " Attribute:" + attribute);
            }
            ITmfStateValue valueXML = filter.getValue(event);
            ITmfStateValue iTmfStateValue = valueState = quark != -1 ? ss.queryOngoingState(quark) : filter.getEventFieldValue(event);
            if (valueState == null) {
                throw new IllegalStateException();
            }
            return this.compare(valueState, valueXML, this.fConditionOperator);
        }
        if (!this.fConditions.isEmpty()) {
            switch (this.fOperator) {
                case AND: {
                    for (TmfXmlCondition childCondition : this.fConditions) {
                        if (childCondition.testForEvent(event)) continue;
                        return false;
                    }
                    return true;
                }
                case NONE: {
                    break;
                }
                case NOT: {
                    return !this.fConditions.get(0).testForEvent(event);
                }
                case OR: {
                    for (TmfXmlCondition childCondition : this.fConditions) {
                        if (!childCondition.testForEvent(event)) continue;
                        return true;
                    }
                    return false;
                }
            }
        } else {
            throw new IllegalStateException("TmfXmlCondition: the condition should be either a state value or be the result of a condition tree");
        }
        return true;
    }

    public String toString() {
        return "TmfXmlCondition: " + (Object)((Object)this.fOperator) + " on " + this.fConditions;
    }

    public boolean compare(ITmfStateValue source, ITmfStateValue dest, ConditionOperator comparisonOperator) {
        switch (comparisonOperator) {
            case EQ: {
                return source.compareTo((Object)dest) == 0;
            }
            case NE: {
                return source.compareTo((Object)dest) != 0;
            }
            case GE: {
                return source.compareTo((Object)dest) >= 0;
            }
            case GT: {
                return source.compareTo((Object)dest) > 0;
            }
            case LE: {
                return source.compareTo((Object)dest) <= 0;
            }
            case LT: {
                return source.compareTo((Object)dest) < 0;
            }
        }
        throw new IllegalArgumentException("TmfXmlCondition: invalid comparison operator.");
    }

    private static enum ConditionOperator {
        NONE,
        EQ,
        NE,
        GE,
        GT,
        LE,
        LT;

    }

    private static enum LogicalOperator {
        NONE,
        NOT,
        AND,
        OR;

    }
}

