/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model;

import java.util.Arrays;
import org.eclipse.cdt.debug.core.cdi.ICDICondition;
import org.eclipse.cdt.debug.core.cdi.model.ICDIEventBreakpoint;
import org.eclipse.cdt.debug.mi.core.cdi.model.Breakpoint;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.output.MIBreakpoint;
import org.eclipse.cdt.gdb.internal.eventbkpts.GdbCatchpoints;

public class EventBreakpoint
extends Breakpoint
implements ICDIEventBreakpoint {
    private String eventType;
    private String arg;

    public EventBreakpoint(Target target, String event, String arg, ICDICondition cond, boolean enabled) {
        super(target, 0, cond, enabled);
        this.eventType = event;
        this.arg = arg == null ? "" : arg;
    }

    public String getEventType() {
        return this.eventType;
    }

    public String getExtraArgument() {
        return this.arg;
    }

    public String getGdbEvent() {
        return GdbCatchpoints.eventToGdbCatchpointKeyword((String)this.getEventType());
    }

    public String getGdbArg() {
        return this.getExtraArgument();
    }

    public int hashCode() {
        return this.eventType.hashCode();
    }

    public boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (!(arg0 instanceof EventBreakpoint)) {
            return false;
        }
        Object[] breakpoints = this.getMIBreakpoints();
        if (breakpoints == null || breakpoints.length == 0) {
            return super.equals(arg0);
        }
        return Arrays.equals(breakpoints, ((EventBreakpoint)arg0).getMIBreakpoints());
    }

    public static String getEventTypeFromMI(MIBreakpoint miBreakpoint) {
        if (miBreakpoint.getWhat().equals("exception catch")) {
            return "org.eclipse.cdt.debug.gdb.catch";
        }
        if (miBreakpoint.getWhat().equals("exception throw")) {
            return "org.eclipse.cdt.debug.gdb.throw";
        }
        String miType = miBreakpoint.getType();
        String PREFIX = "catch ";
        if (miType.startsWith("catch ")) {
            String keyword = miType.substring("catch ".length());
            return GdbCatchpoints.gdbCatchpointKeywordToEvent((String)keyword);
        }
        return null;
    }

    public static String getEventArgumentFromMI(MIBreakpoint miBreakpoint) {
        return "";
    }
}

