/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.event;

import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.event.MIStoppedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIExecAsyncOutput;
import org.eclipse.cdt.debug.mi.core.output.MIFrame;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MIResultRecord;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MISignalEvent
extends MIStoppedEvent {
    String sigName = "";
    String sigMeaning = "";

    public MISignalEvent(MISession source, MIExecAsyncOutput async) {
        super(source, async);
        this.parse();
    }

    public MISignalEvent(MISession source, MIResultRecord record) {
        super(source, record);
        this.parse();
    }

    public String getName() {
        return this.sigName;
    }

    public String getMeaning() {
        return this.sigMeaning;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("signal-name=" + this.sigName + "\n");
        buffer.append("signal-meaning=" + this.sigMeaning + "\n");
        buffer.append("thread-id=").append(this.getThreadId()).append('\n');
        MIFrame f = this.getFrame();
        if (f != null) {
            buffer.append(f.toString());
        }
        return buffer.toString();
    }

    @Override
    void parse() {
        MIExecAsyncOutput exec = this.getMIExecAsyncOutput();
        MIResultRecord rr = this.getMIResultRecord();
        MIResult[] results = null;
        if (exec != null) {
            results = exec.getMIResults();
        } else if (rr != null) {
            results = rr.getMIResults();
        }
        if (results != null) {
            int i = 0;
            while (i < results.length) {
                String var = results[i].getVariable();
                MIValue value = results[i].getMIValue();
                String str = "";
                if (value instanceof MIConst) {
                    str = ((MIConst)value).getString();
                }
                if (var.equals("signal-name")) {
                    this.sigName = str;
                } else if (var.equals("signal-meaning")) {
                    this.sigMeaning = str;
                } else if (var.equals("thread-id")) {
                    try {
                        int id = Integer.parseInt(str.trim());
                        this.setThreadId(id);
                    }
                    catch (NumberFormatException id) {}
                } else if (var.equals("frame") && value instanceof MITuple) {
                    MIFrame f = new MIFrame((MITuple)value);
                    this.setFrame(f);
                }
                ++i;
            }
        }
    }
}

