/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import java.util.ArrayList;
import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIList;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MIRegisterValue {
    int number;
    String value;

    public MIRegisterValue(int n, String v) {
        this.number = n;
        this.value = v;
    }

    public int getNumber() {
        return this.number;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("number=\"").append(this.number).append('\"');
        buffer.append(',').append("value=\"" + this.value + "\"");
        return buffer.toString();
    }

    public static MIRegisterValue[] getMIRegisterValues(MIList miList) {
        ArrayList<MIRegisterValue> aList = new ArrayList<MIRegisterValue>();
        MIValue[] values = miList.getMIValues();
        int i = 0;
        while (i < values.length) {
            MIRegisterValue reg;
            if (values[i] instanceof MITuple && (reg = MIRegisterValue.getMIRegisterValue((MITuple)values[i])) != null) {
                aList.add(reg);
            }
            ++i;
        }
        return aList.toArray(new MIRegisterValue[aList.size()]);
    }

    public static MIRegisterValue getMIRegisterValue(MITuple tuple) {
        MIResult[] args = tuple.getMIResults();
        MIRegisterValue arg = null;
        if (args.length == 2) {
            String aName = "";
            MIValue value = args[0].getMIValue();
            aName = value != null && value instanceof MIConst ? ((MIConst)value).getCString() : "";
            String aValue = "";
            value = args[1].getMIValue();
            aValue = value != null && value instanceof MIConst ? ((MIConst)value).getCString() : "";
            try {
                int reg = Integer.parseInt(aName.trim());
                arg = new MIRegisterValue(reg, aValue.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return arg;
    }
}

