/*
 * Decompiled with CFR 0.152.
 */
package com.nuvoton.debug.gdbjtag.nulink.ui;

import com.nuvoton.debug.gdbjtag.nulink.ui.Messages;
import com.nuvoton.debug.gdbjtag.nulink.ui.TabStartup;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ConfigDialogCore
extends TitleAreaDialog {
    private String fChipSeries = "";
    private TabStartup fTabStartup;
    private long[] fConfigValueArray = new long[4];
    private Button fCheckWatchdog;
    private Button fCheckWatchdogPowerDown;
    private Text fBaseAddress = null;
    private Text fDisplayConfig0 = null;
    private Text fDisplayConfig1 = null;
    private Text fDisplayConfig2 = null;
    private Text fDisplayConfig3 = null;
    private final int radioButtonMax = 15;
    private final int checkButtonMax = 15;
    private final int controlWidthHint = 200;

    public ConfigDialogCore(Shell parentShell, String chipSeries, TabStartup caller) {
        super(parentShell);
        this.setHelpAvailable(false);
        if (chipSeries != null) {
            this.fChipSeries = chipSeries;
        }
        if (caller != null) {
            this.fTabStartup = caller;
            this.fConfigValueArray[0] = Long.parseLong(this.fTabStartup.getInitialInitialConfig0(), 16);
            this.fConfigValueArray[1] = Long.parseLong(this.fTabStartup.getInitialInitialConfig1(), 16);
            this.fConfigValueArray[2] = Long.parseLong(this.fTabStartup.getInitialInitialConfig2(), 16);
            this.fConfigValueArray[3] = Long.parseLong(this.fTabStartup.getInitialInitialConfig3(), 16);
        }
    }

    private long getConfigFieldValue(long configValue, int[] bitPositions) {
        long fieldValue = 0L;
        int i = 0;
        while (i < bitPositions.length) {
            long mask = 1L << bitPositions[i];
            fieldValue += (configValue & mask) >> bitPositions[i] - i;
            ++i;
        }
        return fieldValue;
    }

    private long setConfigFieldValue(long configValue, int[] bitPositions, int controlValue) {
        int i = 0;
        while (i < bitPositions.length) {
            long mask = 1L << bitPositions[i];
            configValue &= mask ^ 0xFFFFFFFFFFFFFFFFL;
            if ((controlValue & 1 << i) != 0) {
                configValue += mask;
            }
            ++i;
        }
        return configValue;
    }

    private void updateDisplayConfig0() {
        this.fDisplayConfig0.setText(Long.toHexString(this.fConfigValueArray[0]).toUpperCase());
    }

    private void updateDisplayConfig1() {
        this.fDisplayConfig1.setText(Long.toHexString(this.fConfigValueArray[1]).toUpperCase());
    }

    private void updateDisplayConfig2() {
        this.fDisplayConfig2.setText(Long.toHexString(this.fConfigValueArray[2]).toUpperCase());
    }

    private void updateDisplayConfig3() {
        this.fDisplayConfig3.setText(Long.toHexString(this.fConfigValueArray[3]).toUpperCase());
    }

    protected void specialHandleConfigValue(String MaskConfig0, String MaskConfig1, String MaskConfig2, String MaskConfig3) {
        this.fConfigValueArray[0] = this.fConfigValueArray[0] & (Long.parseLong(MaskConfig0, 16) ^ 0xFFFFFFFFFFFFFFFFL);
        this.fConfigValueArray[1] = this.fConfigValueArray[1] & (Long.parseLong(MaskConfig1, 16) ^ 0xFFFFFFFFFFFFFFFFL);
        this.fConfigValueArray[2] = this.fConfigValueArray[2] & (Long.parseLong(MaskConfig2, 16) ^ 0xFFFFFFFFFFFFFFFFL);
        this.fConfigValueArray[3] = this.fConfigValueArray[3] & (Long.parseLong(MaskConfig3, 16) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private void saveResult() {
        long[] configValues012 = new long[]{this.fConfigValueArray[0], this.fConfigValueArray[1], this.fConfigValueArray[2]};
        if (this.fDisplayConfig0 != null) {
            this.fTabStartup.putInitialInitialConfig0(this.fDisplayConfig0.getText());
        }
        if (this.fDisplayConfig1 != null) {
            this.fTabStartup.putInitialInitialConfig1(this.fDisplayConfig1.getText());
        }
        if (this.fDisplayConfig2 != null) {
            this.fTabStartup.putInitialInitialConfig2(this.fDisplayConfig2.getText());
        }
        if (this.fChipSeries.equals("NUC400AE")) {
            this.fConfigValueArray[3] = this.getCRC8(configValues012, 3);
            String configString3 = Long.toHexString(this.fConfigValueArray[3]).toUpperCase();
            configString3 = configString3.substring(configString3.length() - 8);
            this.fTabStartup.putInitialInitialConfig3(configString3);
        } else if (this.fDisplayConfig3 != null) {
            this.fTabStartup.putInitialInitialConfig3(this.fDisplayConfig3.getText());
        }
    }

    private long getCRC8(long[] data, int count) {
        int[] crc = new int[]{255, 255, 255, 255};
        int byteIdx = 0;
        while (byteIdx < 4) {
            int localCount = 0;
            while (localCount < count) {
                int i = 128;
                while (i != 0) {
                    if ((crc[byteIdx] & 0x80) != 0) {
                        int n = byteIdx;
                        crc[n] = crc[n] * 2;
                        int n2 = byteIdx;
                        crc[n2] = crc[n2] ^ 7;
                    } else {
                        int n = byteIdx;
                        crc[n] = crc[n] * 2;
                    }
                    long inData = data[localCount] >> byteIdx * 8 & 0xFFL;
                    if ((inData & (long)i) != 0L) {
                        int n = byteIdx;
                        crc[n] = crc[n] ^ 7;
                    }
                    i /= 2;
                }
                ++localCount;
            }
            ++byteIdx;
        }
        return crc[0] & 0xFF | (crc[1] & 0xFF) << 8 | (crc[2] & 0xFF) << 16 | (crc[3] & 0xFF) << 24;
    }

    private int getIntArrayIndex(int[] arr, int value) {
        int k = -1;
        int i = 0;
        while (i < arr.length) {
            if (arr[i] == value) {
                k = i;
                break;
            }
            ++i;
        }
        return k;
    }

    public void create() {
        super.create();
        this.setTitle("Chip Options - " + this.fChipSeries + " Series");
        this.setMessage("Please note that these options do not reflect the actucal ones on the target chip.", 0);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        return area;
    }

    protected void createRadioAndCheckButtonGroup(Composite parentDialogArea, String groupName, int numRadioColumn, String[] radioControlNames, final int[] radioBitPositions, int[] radioControlValues, int numCheckColumn, String[] checkControlNames, int[] checkBitPositions, final int whichConfig) {
        int i;
        long fieldValue;
        Composite local;
        Group group = new Group(parentDialogArea, 0);
        group.setText(groupName);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        Composite comp = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        comp.setLayout((Layout)layout);
        gd = new GridData(768);
        comp.setLayoutData((Object)gd);
        if (radioControlNames.length > 0) {
            local = new Composite(comp, 0);
            layout = new GridLayout();
            layout.numColumns = numRadioColumn;
            local.setLayout((Layout)layout);
            Button[] radios = new Button[15];
            fieldValue = this.getConfigFieldValue(this.fConfigValueArray[whichConfig], radioBitPositions);
            i = 0;
            while (i < radioControlNames.length) {
                radios[i] = new Button(local, 16);
                radios[i].setText(radioControlNames[i]);
                if ((long)radioControlValues[i] == fieldValue) {
                    radios[i].setSelection(true);
                }
                final int controlValue = radioControlValues[i];
                radios[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ((ConfigDialogCore)ConfigDialogCore.this).fConfigValueArray[whichConfig] = ConfigDialogCore.this.setConfigFieldValue(ConfigDialogCore.this.fConfigValueArray[whichConfig], radioBitPositions, controlValue);
                        switch (whichConfig) {
                            case 0: {
                                ConfigDialogCore.this.updateDisplayConfig0();
                                break;
                            }
                            case 1: {
                                ConfigDialogCore.this.updateDisplayConfig1();
                                break;
                            }
                            case 2: {
                                ConfigDialogCore.this.updateDisplayConfig2();
                                break;
                            }
                            case 3: {
                                ConfigDialogCore.this.updateDisplayConfig3();
                                break;
                            }
                            default: {
                                ConfigDialogCore.this.updateDisplayConfig0();
                            }
                        }
                    }
                });
                ++i;
            }
        }
        if (checkControlNames.length > 0) {
            local = new Composite(comp, 0);
            layout = new GridLayout();
            layout.numColumns = numCheckColumn;
            local.setLayout((Layout)layout);
            Button[] checks = new Button[15];
            fieldValue = 0L;
            i = 0;
            while (i < checkControlNames.length) {
                final int[] localBitPositions = new int[]{checkBitPositions[i]};
                fieldValue = this.getConfigFieldValue(this.fConfigValueArray[whichConfig], localBitPositions);
                checks[i] = new Button(local, 32);
                checks[i].setText(checkControlNames[i]);
                if (fieldValue == 0L) {
                    checks[i].setSelection(true);
                } else {
                    checks[i].setSelection(false);
                }
                checks[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Button btn = (Button)e.getSource();
                        ((ConfigDialogCore)ConfigDialogCore.this).fConfigValueArray[whichConfig] = !btn.getSelection() ? ConfigDialogCore.this.setConfigFieldValue(ConfigDialogCore.this.fConfigValueArray[whichConfig], localBitPositions, 1) : ConfigDialogCore.this.setConfigFieldValue(ConfigDialogCore.this.fConfigValueArray[whichConfig], localBitPositions, 0);
                        switch (whichConfig) {
                            case 0: {
                                ConfigDialogCore.this.updateDisplayConfig0();
                                break;
                            }
                            case 1: {
                                ConfigDialogCore.this.updateDisplayConfig1();
                                break;
                            }
                            case 2: {
                                ConfigDialogCore.this.updateDisplayConfig2();
                                break;
                            }
                            case 3: {
                                ConfigDialogCore.this.updateDisplayConfig3();
                                break;
                            }
                            default: {
                                ConfigDialogCore.this.updateDisplayConfig0();
                            }
                        }
                    }
                });
                ++i;
            }
        }
    }

    protected void createDataFlashGroup(Composite parentDialogArea, String[] checkControlNames, int[] checkBitPositions) {
        Group group = new Group(parentDialogArea, 0);
        group.setText(Messages.getString("ConfigDialogCore.GroupNameDataFlashOptions_Text"));
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        Composite comp = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        comp.setLayout((Layout)layout);
        gd = new GridData(768);
        comp.setLayoutData((Object)gd);
        Composite local = new Composite(comp, 0);
        layout = new GridLayout();
        layout.numColumns = 4;
        local.setLayout((Layout)layout);
        Button checkDFEN = new Button(local, 32);
        checkDFEN.setText(checkControlNames[0]);
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.widthHint = 200;
        checkDFEN.setLayoutData((Object)gd);
        Label label = new Label(local, 0);
        label.setText(Messages.getString("ConfigDialogCore.DataFlashOptions_Base_Text"));
        this.fBaseAddress = new Text(local, 2048);
        gd = new GridData();
        gd.widthHint = 70;
        this.fBaseAddress.setLayoutData((Object)gd);
        this.fBaseAddress.setText(Long.toHexString(this.fConfigValueArray[1]).toUpperCase());
        this.fBaseAddress.setEnabled(true);
        final int[] localBitPositions = new int[]{checkBitPositions[0]};
        long fieldDFENValue = this.getConfigFieldValue(this.fConfigValueArray[0], localBitPositions);
        if (fieldDFENValue == 0L) {
            checkDFEN.setSelection(true);
        } else {
            checkDFEN.setSelection(false);
        }
        checkDFEN.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button btn = (Button)e.getSource();
                ((ConfigDialogCore)ConfigDialogCore.this).fConfigValueArray[0] = !btn.getSelection() ? ConfigDialogCore.this.setConfigFieldValue(ConfigDialogCore.this.fConfigValueArray[0], localBitPositions, 1) : ConfigDialogCore.this.setConfigFieldValue(ConfigDialogCore.this.fConfigValueArray[0], localBitPositions, 0);
                ConfigDialogCore.this.updateDisplayConfig0();
            }
        });
        this.fBaseAddress.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ((ConfigDialogCore)ConfigDialogCore.this).fConfigValueArray[1] = Long.parseLong(ConfigDialogCore.this.fBaseAddress.getText(), 16);
                ConfigDialogCore.this.updateDisplayConfig1();
            }
        });
        if (checkBitPositions.length > 1) {
            Button checkDFVSEN = new Button(local, 32);
            checkDFVSEN.setText(checkControlNames[1]);
            gd = new GridData();
            gd.horizontalSpan = 2;
            checkDFVSEN.setLayoutData((Object)gd);
            final int[] localBitPositions1 = new int[]{checkBitPositions[1]};
            long fieldDFVSENValue = this.getConfigFieldValue(this.fConfigValueArray[0], localBitPositions1);
            if (fieldDFVSENValue == 0L) {
                checkDFVSEN.setSelection(true);
            } else {
                checkDFVSEN.setSelection(false);
            }
            checkDFVSEN.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button btn = (Button)e.getSource();
                    ((ConfigDialogCore)ConfigDialogCore.this).fConfigValueArray[0] = !btn.getSelection() ? ConfigDialogCore.this.setConfigFieldValue(ConfigDialogCore.this.fConfigValueArray[0], localBitPositions1, 1) : ConfigDialogCore.this.setConfigFieldValue(ConfigDialogCore.this.fConfigValueArray[0], localBitPositions1, 0);
                    ConfigDialogCore.this.updateDisplayConfig0();
                }
            });
        }
    }

    protected Composite createWatchdogCheckButtons(Composite parentDialogArea, final int[] watchdogBitPositions, final int watchdogDisableValue, final int watchdogEnableValue, final int[] watchdogPowerDownBitPositions) {
        Composite comp = new Composite(parentDialogArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        comp.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        comp.setLayoutData((Object)gd);
        Composite local = new Composite(comp, 0);
        layout = new GridLayout();
        layout.numColumns = 4;
        local.setLayout((Layout)layout);
        this.fCheckWatchdog = new Button(local, 32);
        gd = new GridData();
        gd.horizontalIndent = 8;
        gd.horizontalSpan = 2;
        gd.widthHint = 200;
        this.fCheckWatchdog.setLayoutData((Object)gd);
        this.fCheckWatchdog.setText(Messages.getString("ConfigDialogCore.CheckNameWatchdog_Text"));
        long fieldValue = 0L;
        fieldValue = this.getConfigFieldValue(this.fConfigValueArray[0], watchdogBitPositions);
        if (fieldValue == (long)watchdogDisableValue) {
            this.fCheckWatchdog.setSelection(false);
        } else {
            this.fCheckWatchdog.setSelection(true);
        }
        this.fCheckWatchdogPowerDown = new Button(local, 32);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fCheckWatchdogPowerDown.setLayoutData((Object)gd);
        this.fCheckWatchdogPowerDown.setText(Messages.getString("ConfigDialogCore.CheckNameWatchdogPowerDown_Text"));
        fieldValue = this.getConfigFieldValue(this.fConfigValueArray[0], watchdogPowerDownBitPositions);
        if (fieldValue == 0L) {
            this.fCheckWatchdogPowerDown.setSelection(true);
        } else {
            this.fCheckWatchdogPowerDown.setSelection(false);
        }
        this.fCheckWatchdog.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button btn = (Button)e.getSource();
                if (btn.getSelection()) {
                    ((ConfigDialogCore)ConfigDialogCore.this).fConfigValueArray[0] = ConfigDialogCore.this.setConfigFieldValue(ConfigDialogCore.this.fConfigValueArray[0], watchdogBitPositions, 0);
                } else {
                    if (ConfigDialogCore.this.fCheckWatchdogPowerDown.getSelection()) {
                        ConfigDialogCore.this.fCheckWatchdogPowerDown.setSelection(false);
                        ((ConfigDialogCore)ConfigDialogCore.this).fConfigValueArray[0] = ConfigDialogCore.this.setConfigFieldValue(ConfigDialogCore.this.fConfigValueArray[0], watchdogPowerDownBitPositions, 1);
                    }
                    ((ConfigDialogCore)ConfigDialogCore.this).fConfigValueArray[0] = ConfigDialogCore.this.setConfigFieldValue(ConfigDialogCore.this.fConfigValueArray[0], watchdogBitPositions, watchdogDisableValue);
                }
                ConfigDialogCore.this.updateDisplayConfig0();
            }
        });
        this.fCheckWatchdogPowerDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button btn = (Button)e.getSource();
                if (btn.getSelection()) {
                    if (!ConfigDialogCore.this.fCheckWatchdog.getSelection()) {
                        ConfigDialogCore.this.fCheckWatchdog.setSelection(true);
                    }
                    ((ConfigDialogCore)ConfigDialogCore.this).fConfigValueArray[0] = ConfigDialogCore.this.setConfigFieldValue(ConfigDialogCore.this.fConfigValueArray[0], watchdogBitPositions, watchdogEnableValue);
                    ((ConfigDialogCore)ConfigDialogCore.this).fConfigValueArray[0] = ConfigDialogCore.this.setConfigFieldValue(ConfigDialogCore.this.fConfigValueArray[0], watchdogPowerDownBitPositions, 0);
                } else {
                    ((ConfigDialogCore)ConfigDialogCore.this).fConfigValueArray[0] = ConfigDialogCore.this.setConfigFieldValue(ConfigDialogCore.this.fConfigValueArray[0], watchdogBitPositions, 0);
                    ((ConfigDialogCore)ConfigDialogCore.this).fConfigValueArray[0] = ConfigDialogCore.this.setConfigFieldValue(ConfigDialogCore.this.fConfigValueArray[0], watchdogPowerDownBitPositions, 1);
                }
                ConfigDialogCore.this.updateDisplayConfig0();
            }
        });
        return local;
    }

    protected void createCheckButtons(Composite parentDialogArea, Composite parentLocal, String[] checkControlNames, int[] checkBitPositions, final int[] inverseBitPositions, final int whichConfig) {
        GridData gd;
        Composite local = null;
        if (parentLocal != null) {
            local = parentLocal;
        } else {
            Composite comp = new Composite(parentDialogArea, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            comp.setLayout((Layout)layout);
            gd = new GridData(768);
            comp.setLayoutData((Object)gd);
            local = new Composite(comp, 0);
            layout = new GridLayout();
            layout.numColumns = 4;
            local.setLayout((Layout)layout);
        }
        if (checkControlNames.length > 0) {
            Button[] checks = new Button[15];
            long fieldValue = 0L;
            int i = 0;
            while (i < checkControlNames.length) {
                final int[] localBitPositions = new int[]{checkBitPositions[i]};
                fieldValue = this.getConfigFieldValue(this.fConfigValueArray[whichConfig], localBitPositions);
                checks[i] = new Button(local, 32);
                gd = new GridData();
                if (i % 2 == 0) {
                    gd.horizontalIndent = 8;
                }
                gd.horizontalSpan = 2;
                gd.widthHint = 200;
                checks[i].setLayoutData((Object)gd);
                checks[i].setText(checkControlNames[i]);
                if (this.getIntArrayIndex(inverseBitPositions, checkBitPositions[i]) == -1) {
                    if (fieldValue == 0L) {
                        checks[i].setSelection(true);
                    } else {
                        checks[i].setSelection(false);
                    }
                } else if (fieldValue == 0L) {
                    checks[i].setSelection(false);
                } else {
                    checks[i].setSelection(true);
                }
                checks[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Button btn = (Button)e.getSource();
                        ((ConfigDialogCore)ConfigDialogCore.this).fConfigValueArray[whichConfig] = ConfigDialogCore.this.getIntArrayIndex(inverseBitPositions, localBitPositions[0]) == -1 ? (!btn.getSelection() ? ConfigDialogCore.this.setConfigFieldValue(ConfigDialogCore.this.fConfigValueArray[whichConfig], localBitPositions, 1) : ConfigDialogCore.this.setConfigFieldValue(ConfigDialogCore.this.fConfigValueArray[whichConfig], localBitPositions, 0)) : (!btn.getSelection() ? ConfigDialogCore.this.setConfigFieldValue(ConfigDialogCore.this.fConfigValueArray[whichConfig], localBitPositions, 0) : ConfigDialogCore.this.setConfigFieldValue(ConfigDialogCore.this.fConfigValueArray[whichConfig], localBitPositions, 1));
                        switch (whichConfig) {
                            case 0: {
                                ConfigDialogCore.this.updateDisplayConfig0();
                                break;
                            }
                            case 1: {
                                ConfigDialogCore.this.updateDisplayConfig1();
                                break;
                            }
                            case 2: {
                                ConfigDialogCore.this.updateDisplayConfig2();
                                break;
                            }
                            case 3: {
                                ConfigDialogCore.this.updateDisplayConfig3();
                                break;
                            }
                            default: {
                                ConfigDialogCore.this.updateDisplayConfig0();
                            }
                        }
                    }
                });
                ++i;
            }
        }
    }

    protected void createCheckButtonsForMultiBits(Composite parentDialogArea, Composite parentLocal, String[] checkControlNames, int[][] checkBitPositions, int[] checkedValues, int[] uncheckedValues, final int whichConfig) {
        GridData gd;
        Composite local = null;
        if (parentLocal != null) {
            local = parentLocal;
        } else {
            Composite comp = new Composite(parentDialogArea, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            comp.setLayout((Layout)layout);
            gd = new GridData(768);
            comp.setLayoutData((Object)gd);
            local = new Composite(comp, 0);
            layout = new GridLayout();
            layout.numColumns = 4;
            local.setLayout((Layout)layout);
        }
        if (checkControlNames.length > 0) {
            Button[] checks = new Button[15];
            long fieldValue = 0L;
            int i = 0;
            while (i < checkControlNames.length) {
                final int[] localBitPositions = checkBitPositions[i];
                final int localcheckedValue = checkedValues[i];
                final int localuncheckedValue = uncheckedValues[i];
                fieldValue = this.getConfigFieldValue(this.fConfigValueArray[whichConfig], localBitPositions);
                checks[i] = new Button(local, 32);
                gd = new GridData();
                gd.horizontalSpan = 2;
                gd.widthHint = 200;
                checks[i].setLayoutData((Object)gd);
                checks[i].setText(checkControlNames[i]);
                if (fieldValue == (long)checkedValues[i]) {
                    checks[i].setSelection(true);
                } else {
                    checks[i].setSelection(false);
                }
                checks[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Button btn = (Button)e.getSource();
                        ((ConfigDialogCore)ConfigDialogCore.this).fConfigValueArray[whichConfig] = btn.getSelection() ? ConfigDialogCore.this.setConfigFieldValue(ConfigDialogCore.this.fConfigValueArray[whichConfig], localBitPositions, localcheckedValue) : ConfigDialogCore.this.setConfigFieldValue(ConfigDialogCore.this.fConfigValueArray[whichConfig], localBitPositions, localuncheckedValue);
                        switch (whichConfig) {
                            case 0: {
                                ConfigDialogCore.this.updateDisplayConfig0();
                                break;
                            }
                            case 1: {
                                ConfigDialogCore.this.updateDisplayConfig1();
                                break;
                            }
                            case 2: {
                                ConfigDialogCore.this.updateDisplayConfig2();
                                break;
                            }
                            case 3: {
                                ConfigDialogCore.this.updateDisplayConfig3();
                                break;
                            }
                            default: {
                                ConfigDialogCore.this.updateDisplayConfig0();
                            }
                        }
                    }
                });
                ++i;
            }
        }
    }

    protected void createConfigValueGroup(Composite parentDialogArea, int numConfigToShow) {
        Group group = new Group(parentDialogArea, 0);
        group.setText(Messages.getString("ConfigDialogCore.GroupNameDisplayConfig_Text"));
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        Composite comp = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        comp.setLayout((Layout)layout);
        gd = new GridData(768);
        comp.setLayoutData((Object)gd);
        Composite local = new Composite(comp, 0);
        layout = new GridLayout();
        layout.numColumns = 4;
        local.setLayout((Layout)layout);
        Label label = new Label(local, 0);
        label.setText(Messages.getString("ConfigDialogCore.DisplayConfig_0_Text"));
        this.fDisplayConfig0 = new Text(local, 2056);
        gd = new GridData();
        gd.widthHint = 70;
        this.fDisplayConfig0.setLayoutData((Object)gd);
        this.updateDisplayConfig0();
        if (numConfigToShow > 1) {
            label = new Label(local, 0);
            gd = new GridData();
            gd.horizontalIndent = 55;
            label.setLayoutData((Object)gd);
            label.setText(Messages.getString("ConfigDialogCore.DisplayConfig_1_Text"));
            this.fDisplayConfig1 = new Text(local, 2056);
            gd = new GridData();
            gd.widthHint = 70;
            this.fDisplayConfig1.setLayoutData((Object)gd);
            this.updateDisplayConfig1();
        }
        if (numConfigToShow > 2) {
            label = new Label(local, 0);
            label.setText(Messages.getString("ConfigDialogCore.DisplayConfig_2_Text"));
            this.fDisplayConfig2 = new Text(local, 2056);
            gd = new GridData();
            gd.widthHint = 70;
            this.fDisplayConfig2.setLayoutData((Object)gd);
            this.updateDisplayConfig2();
        }
        if (numConfigToShow > 3) {
            label = new Label(local, 0);
            gd = new GridData();
            gd.horizontalIndent = 55;
            label.setLayoutData((Object)gd);
            label.setText(Messages.getString("ConfigDialogCore.DisplayConfig_3_Text"));
            this.fDisplayConfig3 = new Text(local, 2056);
            gd = new GridData();
            gd.widthHint = 70;
            this.fDisplayConfig3.setLayoutData((Object)gd);
            this.updateDisplayConfig3();
        }
    }

    protected void okPressed() {
        this.saveResult();
        super.okPressed();
    }
}

