/*
 * Decompiled with CFR 0.152.
 */
package com.nuvoton.debug.gdbjtag.nulink.ui;

import com.nuvoton.debug.gdbjtag.nulink.ui.TabStartup;
import ilg.gnuarmeclipse.core.EclipseUtils;
import ilg.gnuarmeclipse.core.StringUtils;
import ilg.gnuarmeclipse.debug.gdbjtag.Activator;
import ilg.gnuarmeclipse.debug.gdbjtag.DebugUtils;
import ilg.gnuarmeclipse.debug.gdbjtag.dsf.GnuArmDebuggerCommandsService;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.gdbjtag.core.Messages;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.osgi.framework.BundleContext;

public class DebuggerCommands
extends GnuArmDebuggerCommandsService {
    public DebuggerCommands(DsfSession session, ILaunchConfiguration lc, String mode) {
        super(session, lc, mode, true);
    }

    protected BundleContext getBundleContext() {
        return Activator.getInstance().getBundle().getBundleContext();
    }

    public IStatus addGdbInitCommandsCommands(List<String> commandsList) {
        String otherInits = ((String)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.gdbClientOtherCommands", (Object)"set mem inaccessible-by-default off\n")).trim();
        otherInits = DebugUtils.resolveAll((String)otherInits, (Map)this.fAttributes);
        DebugUtils.addMultiLine((String)otherInits, commandsList);
        return Status.OK_STATUS;
    }

    public IStatus addGnuArmResetCommands(List<String> commandsList) {
        IStatus status = this.addFirstResetCommands(commandsList);
        if (!status.isOK()) {
            return status;
        }
        status = this.addLoadSymbolsCommands(commandsList);
        if (!status.isOK()) {
            return status;
        }
        if (((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"org.eclipse.cdt.debug.gdbjtag.core.loadImage", (Object)true)).booleanValue() && !((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.doDebugInRam", (Object)false)).booleanValue() && !(status = this.addLoadImageCommands(commandsList)).isOK()) {
            return status;
        }
        if (((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.loadImage", (Object)true)).booleanValue() && !((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.doDebugInRam", (Object)false)).booleanValue() && !(status = this.addLoadImageToFlashCommands(commandsList)).isOK()) {
            return status;
        }
        return Status.OK_STATUS;
    }

    public IStatus addGnuArmStartCommands(List<String> commandsList) {
        IStatus status = this.addStartRestartCommands(true, commandsList);
        if (!status.isOK()) {
            return status;
        }
        return Status.OK_STATUS;
    }

    public IStatus addFirstResetCommands(List<String> commandsList) {
        String configValue;
        String commandStr;
        if (((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.doFirstReset", (Object)true)).booleanValue()) {
            String commandStr2 = "monitor reset ";
            String resetType = (String)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.firstResetType", (Object)"init");
            commandsList.add(String.valueOf(commandStr2) + resetType);
            commandStr2 = "monitor halt";
            commandsList.add(commandStr2);
        }
        String otherInits = ((String)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.otherInitCommands", (Object)"")).trim();
        otherInits = DebugUtils.resolveAll((String)otherInits, (Map)this.fAttributes);
        if (this.fDoDoubleBackslash && EclipseUtils.isWindows()) {
            otherInits = StringUtils.duplicateBackslashes((String)otherInits);
        }
        DebugUtils.addMultiLine((String)otherInits, commandsList);
        if (((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.enableSemihosting", (Object)true)).booleanValue()) {
            commandStr = "monitor arm semihosting enable";
            commandsList.add(commandStr);
        }
        if (((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.chipErase", (Object)false)).booleanValue()) {
            commandStr = ((String)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.targetChip", (Object)"")).trim();
            commandStr = commandStr.toUpperCase().equals("M2351") ? "monitor numicro M2351_erase" : "monitor numicro chip_erase";
            commandsList.add(commandStr);
            commandStr = "monitor sleep 500";
            commandsList.add(commandStr);
            commandStr = "monitor reset ";
            commandsList.add(commandStr);
            commandStr = "monitor halt";
            commandsList.add(commandStr);
        }
        if (((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.writeConifg", (Object)false)).booleanValue()) {
            commandStr = "monitor numicro write_isp 0x300000 ";
            configValue = "0x" + (String)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.initialConfig0", (Object)"FFFFFFFF");
            commandsList.add(String.valueOf(commandStr) + configValue);
            commandStr = "monitor numicro write_isp 0x300004 ";
            configValue = "0x" + (String)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.initialConfig1", (Object)"FFFFFFFF");
            commandsList.add(String.valueOf(commandStr) + configValue);
            commandStr = "monitor numicro write_isp 0x300008 ";
            configValue = "0x" + (String)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.initialConfig2", (Object)"FFFFFFFF");
            commandsList.add(String.valueOf(commandStr) + configValue);
            commandStr = "monitor numicro write_isp 0x30000C ";
            configValue = "0x" + (String)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.initialConfig3", (Object)"FFFFFFFF");
            commandsList.add(String.valueOf(commandStr) + configValue);
        }
        if (((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.writeLock", (Object)false)).booleanValue()) {
            commandStr = "monitor numicro write_isp 0x200800 ";
            configValue = "0x" + (String)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.initialNSCBA", (Object)"080000");
            commandsList.add(String.valueOf(commandStr) + configValue);
            commandStr = "monitor numicro write_isp 0x200804 ";
            configValue = "0x" + (String)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.initialSCRLOCK", (Object)"5A");
            commandsList.add(String.valueOf(commandStr) + configValue);
            commandStr = "monitor numicro write_isp 0x210804";
            configValue = "0x" + (String)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.initialARLOCK", (Object)"5A");
            commandsList.add(String.valueOf(commandStr) + configValue);
        }
        return Status.OK_STATUS;
    }

    public IStatus addStartRestartCommands(boolean doReset, List<String> commandsList) {
        IStatus status;
        if (doReset && ((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.doSecondReset", (Object)true)).booleanValue()) {
            String commandStr = "monitor reset ";
            String resetType = (String)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.secondResetType", (Object)"init");
            commandsList.add(String.valueOf(commandStr) + resetType);
            commandStr = "monitor halt";
            commandsList.add(commandStr);
        }
        if (((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"org.eclipse.cdt.debug.gdbjtag.core.loadImage", (Object)true)).booleanValue() && ((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.doDebugInRam", (Object)false)).booleanValue() && !(status = this.addLoadImageCommands(commandsList)).isOK()) {
            return status;
        }
        String userCmd = ((String)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.otherRunCommands", (Object)"")).trim();
        userCmd = DebugUtils.resolveAll((String)userCmd, (Map)this.fAttributes);
        if (this.fDoDoubleBackslash && EclipseUtils.isWindows()) {
            userCmd = StringUtils.duplicateBackslashes((String)userCmd);
        }
        DebugUtils.addMultiLine((String)userCmd, commandsList);
        this.addSetPcCommands(commandsList);
        this.addStopAtCommands(commandsList);
        commandsList.add("monitor reg");
        if (((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.doContinue", (Object)true)).booleanValue()) {
            commandsList.add("continue");
        }
        return Status.OK_STATUS;
    }

    public IStatus addLoadImageToFlashCommands(List<String> commandsList) {
        int lastDot;
        String imageOffset;
        IPath programPath = this.fGdbBackend.getProgramPath();
        String imageFileName = null;
        boolean bUseProjBinaryForImage = false;
        if (((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.useProjBinaryForImage", (Object)true)).booleanValue()) {
            if (programPath != null) {
                imageFileName = programPath.toOSString();
            }
            bUseProjBinaryForImage = true;
        } else {
            imageFileName = (String)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.imageFileName", (Object)"");
            imageFileName = !imageFileName.isEmpty() ? DebugUtils.resolveAll((String)imageFileName, (Map)this.fAttributes) : null;
        }
        if (imageFileName == null) {
            return new Status(4, "ilg.gnuarmeclipse.debug.gdbjtag", -1, Messages.getString((String)"GDBJtagDebugger.err_no_img_file"), null);
        }
        imageFileName = DebugUtils.resolveAll((String)imageFileName, (Map)this.fAttributes);
        if (EclipseUtils.isWindows()) {
            imageFileName = StringUtils.duplicateBackslashes((String)imageFileName);
        }
        if (!(imageOffset = ((String)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.imageOffset", (Object)"")).trim()).isEmpty()) {
            imageOffset = imageFileName.endsWith(".hex") ? "" : "0x" + imageOffset;
        }
        String file = this.escapeSpaces(imageFileName);
        String fileOutputName = TabStartup.getManagedOutputName(file);
        if (bUseProjBinaryForImage && (lastDot = file.lastIndexOf(46)) >= 0) {
            file = String.valueOf(file.substring(0, lastDot + 1)) + fileOutputName;
        }
        file = this.escapeSpaces(file);
        if (((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"com.nuvoton.debug.gdbjtag.nulink.chipErase", (Object)false)).booleanValue()) {
            commandsList.add("monitor flash write_image " + file + ' ' + imageOffset);
        } else {
            commandsList.add("monitor flash write_image erase " + file + ' ' + imageOffset);
        }
        return Status.OK_STATUS;
    }
}

