/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.logging.aeri.core.util;

import org.eclipse.epp.logging.aeri.core.ILink;
import org.eclipse.epp.logging.aeri.core.ILinkable;
import org.eclipse.epp.logging.aeri.core.IModelFactory;

public class Links {
    public static final String REL_PROVIDER = "provider";
    public static final String REL_HELP = "help";
    public static final String REL_DISCOVERY = "discovery";
    public static final String REL_TERMS_OF_USE = "terms-of-use";
    public static final String REL_PRIVACY_POLICY = "privacy-policy";
    public static final String REL_SUBMISSION = "submission";
    public static final String REL_BUG = "bug";

    public static ILink createLink(String rel, String href, String title) {
        ILink res = IModelFactory.eINSTANCE.createLink();
        res.setRel(rel);
        res.setHref(href);
        res.setTitle(title);
        return res;
    }

    public static ILink createSubmissionLink(String href, String title) {
        return Links.createLink(REL_SUBMISSION, href, title);
    }

    public static ILink createBugLink(String href, String title) {
        return Links.createLink(REL_BUG, href, title);
    }

    public static ILink createDiscoveryLink(String href) {
        return Links.createLink(REL_DISCOVERY, href, "Discovery");
    }

    public static ILink createProviderLink(String href, String title) {
        return Links.createLink(REL_PROVIDER, href, title);
    }

    public static ILink Link(ILinkable linkable, String rel) {
        return (ILink)linkable.getLinks().get((Object)rel);
    }

    public static void addLink(ILinkable linkable, String rel, String href, String title) {
        ILink link = Links.createLink(rel, href, title);
        linkable.getLinks().put((Object)rel, (Object)link);
    }

    public static boolean hasLink(ILinkable linkable, String rel) {
        return linkable.getLinks().contains((Object)rel);
    }

    public static ILink getLink(ILinkable linkable, String rel) {
        return (ILink)linkable.getLinks().get((Object)rel);
    }
}

