/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnuarmeclipse.packs.cmsis;

import com.github.zafarkhaja.semver.Version;
import ilg.gnuarmeclipse.core.Xml;
import ilg.gnuarmeclipse.packs.cmsis.PdscParser;
import ilg.gnuarmeclipse.packs.cmsis.PdscUtils;
import ilg.gnuarmeclipse.packs.core.tree.Leaf;
import ilg.gnuarmeclipse.packs.core.tree.Node;
import ilg.gnuarmeclipse.packs.data.Activator;
import ilg.gnuarmeclipse.packs.data.Utils;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.w3c.dom.Element;

public class PdscParserForContent
extends PdscParser {
    public void parse(String pdscNname, String version, Node parent) {
        long endTime;
        long duration;
        Element examplesElement;
        Element componentsElement;
        Element boardsElement;
        Object vendor;
        Element devicesElement;
        long beginTime = System.currentTimeMillis();
        this.fOut.println("Processing \"" + this.fPath + "\" for content.xml ...");
        Element packageElement = this.fDocument.getDocumentElement();
        String firstElementName = packageElement.getNodeName();
        if (!"package".equals(firstElementName)) {
            Activator.log((String)("Missing <package>, <" + firstElementName + "> encountered"));
            return;
        }
        String schemaVersion = packageElement.getAttribute("schemaVersion").trim();
        Version semVer = Version.valueOf((String)schemaVersion);
        String msg = "Schema version \"" + schemaVersion + "\"";
        if (!PdscUtils.isSchemaValid(semVer)) {
            msg = String.valueOf(msg) + " not recognised, package " + pdscNname + " ignored.";
            this.fOut.println(msg);
            Utils.reportWarning(msg);
            return;
        }
        this.fOut.println(String.valueOf(msg) + ".");
        String urlRef = "";
        Element urlElement = Xml.getFirstChildElement((Element)packageElement, (String)"url");
        urlRef = Xml.getElementContent((Element)urlElement);
        if (urlRef.length() == 0) {
            return;
        }
        Element nameElement = Xml.getFirstChildElement((Element)packageElement, (String)"name");
        if (nameElement == null) {
            this.fOut.println("Missing <name>.");
            return;
        }
        String packName = Xml.getElementContent((Element)nameElement);
        Node packNode = Node.addUniqueChild((Node)parent, (String)"package", (String)packName);
        Element packDescriptionElement = Xml.getFirstChildElement((Element)packageElement, (String)"description");
        if (packDescriptionElement == null) {
            this.fOut.println("Missing <description>.");
            return;
        }
        String packDescription = Xml.getElementMultiLineContent((Element)packDescriptionElement);
        packNode.setDescription(packDescription);
        Element vendorElement = Xml.getFirstChildElement((Element)packageElement, (String)"vendor");
        if (vendorElement == null) {
            this.fOut.println("Missing <vendor>.");
            return;
        }
        String packVendorName = Xml.getElementContent((Element)vendorElement);
        Element releasesElement = Xml.getFirstChildElement((Element)packageElement, (String)"releases");
        if (releasesElement == null) {
            this.fOut.println("Missing <releases>.");
            return;
        }
        String shortUrl = urlRef;
        if (shortUrl.endsWith("/")) {
            shortUrl = shortUrl.substring(0, shortUrl.length() - 1);
        }
        shortUrl = shortUrl.replaceAll("http:", "https:");
        Node versionNode = null;
        boolean isFirst = true;
        List releaseElements = Xml.getChildrenElementsList((Element)releasesElement, (String)"release");
        for (Element releaseElement : releaseElements) {
            String releaseName = releaseElement.getAttribute("version").trim();
            String releaseDate = releaseElement.getAttribute("date").trim();
            String description = Xml.getElementMultiLineContent((Element)releaseElement);
            Node verNode = Node.addUniqueChild((Node)packNode, (String)"version", (String)releaseName);
            verNode.putProperty("type", "cmsis.pack");
            verNode.putProperty("vendor.name", packVendorName);
            verNode.putProperty("pack.name", packName);
            verNode.putProperty("version.name", releaseName);
            String archiveName = String.valueOf(packVendorName) + "." + packName + "." + releaseName + ".pack";
            String archiveUrl = String.valueOf(shortUrl) + "/" + archiveName;
            verNode.putProperty("archive.url", archiveUrl);
            verNode.putProperty("archive.name", archiveName);
            String size = "0";
            try {
                int sz = Utils.getRemoteFileSize(new URL(archiveUrl));
                if (sz > 0) {
                    size = String.valueOf(sz);
                }
            }
            catch (IOException sz) {
                // empty catch block
            }
            verNode.putProperty("archive.size", size);
            String unpackFolder = String.valueOf(packVendorName) + "/" + packName + "/" + releaseName;
            verNode.putProperty("dest.folder", unpackFolder);
            String pdscName = String.valueOf(packVendorName) + "." + packName + ".pdsc";
            verNode.putProperty("pdsc.name", pdscName);
            if (releaseDate.length() > 0) {
                verNode.putProperty("date", releaseDate);
            }
            verNode.setDescription(description);
            if (isFirst) {
                if (!version.equals(releaseName)) {
                    this.fOut.println("Index version=\"" + version + "\" not the most recent (" + releaseName + ").");
                }
                versionNode = verNode;
            }
            isFirst = false;
        }
        Node outlineNode = new Node("outline");
        versionNode.addChild((Leaf)outlineNode);
        Node externNode = new Node("external");
        Element keywordsElement = Xml.getFirstChildElement((Element)packageElement, (String)"keywords");
        if (keywordsElement != null) {
            List childElements = Xml.getChildrenElementsList((Element)keywordsElement);
            for (Element childElement : childElements) {
                String elementName2 = childElement.getNodeName();
                if (!"keyword".equals(elementName2)) continue;
                String keyword = Xml.getElementContent((Element)childElement);
                Node.addUniqueChild((Node)outlineNode, (String)"keyword", (String)keyword);
            }
        }
        if ((devicesElement = Xml.getFirstChildElement((Element)packageElement, (String)"devices")) != null) {
            List familyElements = Xml.getChildrenElementsList((Element)devicesElement, (String)"family");
            for (Element familyElement : familyElements) {
                String family = familyElement.getAttribute("Dfamily").trim();
                vendor = familyElement.getAttribute("Dvendor").trim();
                Element deviceDescriptionElement = Xml.getFirstChildElement((Element)familyElement, (String)"description");
                String description = "";
                description = this.extendDescription(description, Xml.getElementMultiLineContent((Element)deviceDescriptionElement));
                String[] va = ((String)vendor).split("[:]");
                if (va.length < 2) {
                    this.fOut.println("Dvendor=\"" + (String)vendor + "\" not enumeration, ignored.");
                    continue;
                }
                Node deviceFamilyNode = Node.addUniqueChild((Node)outlineNode, (String)"family", (String)family);
                deviceFamilyNode.setDescription(description);
                deviceFamilyNode.putNonEmptyProperty("vendor.name", va[0]);
                deviceFamilyNode.putNonEmptyProperty("vendor.id", va[1]);
            }
        }
        if ((boardsElement = Xml.getFirstChildElement((Element)packageElement, (String)"boards")) != null) {
            List boardElements = Xml.getChildrenElementsList((Element)boardsElement, (String)"board");
            for (Element boardElement : boardElements) {
                vendor = boardElement.getAttribute("vendor").trim();
                String boardName = boardElement.getAttribute("name").trim();
                Element descriptionElement = Xml.getFirstChildElement((Element)boardElement, (String)"description");
                String description = "";
                description = Xml.getElementMultiLineContent((Element)descriptionElement);
                Node boardNode = Node.addUniqueChild((Node)outlineNode, (String)"board", (String)boardName);
                boardNode.putProperty("vendor.name", (String)vendor);
                boardNode.setDescription(description);
                List compatibleDevicesElements = Xml.getChildrenElementsList((Element)boardElement, (String)"compatibleDevice");
                for (Element compatibleDevicesElement : compatibleDevicesElements) {
                    String family = compatibleDevicesElement.getAttribute("Dfamily").trim();
                    if (family.length() <= 0) continue;
                    String vendor2 = compatibleDevicesElement.getAttribute("Dvendor").trim();
                    String[] va = vendor2.split("[:]");
                    if (va.length < 2) {
                        this.fOut.println("Dvendor=\"" + vendor2 + "\" not enumeration, ignored.");
                        continue;
                    }
                    Node deviceFamilyNode = Node.addUniqueChild((Node)externNode, (String)"family", (String)family);
                    deviceFamilyNode.putProperty("vendor.name", va[0]);
                    deviceFamilyNode.putProperty("vendor.id", va[1]);
                }
            }
        }
        if ((componentsElement = Xml.getFirstChildElement((Element)packageElement, (String)"components")) != null) {
            List componentElements = Xml.getChildrenElementsList((Element)componentsElement, (String)"component");
            for (Element componentElement : componentElements) {
                String Cclass = componentElement.getAttribute("Cclass").trim();
                String Cgroup = componentElement.getAttribute("Cgroup").trim();
                String Csub = componentElement.getAttribute("Csub").trim();
                String Cvariant = componentElement.getAttribute("Cvariant").trim();
                String Cvendor = componentElement.getAttribute("Cvendor").trim();
                Node componentNode = new Node("component");
                outlineNode.addChild((Leaf)componentNode);
                String name = "";
                name = this.extendName(name, Cvendor);
                name = this.extendName(name, Cclass);
                name = this.extendName(name, Cgroup);
                name = this.extendName(name, Csub);
                name = this.extendName(name, Cvariant);
                componentNode.setName(name);
                Element componentsDescriptionElement = Xml.getFirstChildElement((Element)componentElement, (String)"description");
                if (componentsDescriptionElement == null) continue;
                String componentDescription = Xml.getElementMultiLineContent((Element)componentsDescriptionElement);
                componentNode.setDescription(componentDescription);
            }
            List bundleElements = Xml.getChildrenElementsList((Element)componentsElement, (String)"bundle");
            for (Element el : bundleElements) {
                String Cbundle = el.getAttribute("Cbundle").trim();
                String Cclass = el.getAttribute("Cclass").trim();
                Node bundleNode = new Node("bundle");
                outlineNode.addChild((Leaf)bundleNode);
                String name = "";
                name = this.extendName(name, Cclass);
                name = this.extendName(name, Cbundle);
                bundleNode.setName(name);
                Element bundleDescriptionElement = Xml.getFirstChildElement((Element)el, (String)"description");
                if (bundleDescriptionElement == null) continue;
                String bundleDescription = Xml.getElementMultiLineContent((Element)bundleDescriptionElement);
                bundleNode.setDescription(bundleDescription);
            }
        }
        if ((examplesElement = Xml.getFirstChildElement((Element)packageElement, (String)"examples")) != null) {
            List exampleElements = Xml.getChildrenElementsList((Element)examplesElement, (String)"example");
            for (Element exampleElement : exampleElements) {
                Element attributesElement;
                String firstBoardName = "";
                Element boardElement = Xml.getFirstChildElement((Element)exampleElement, (String)"board");
                if (boardElement != null) {
                    String boardVendor = boardElement.getAttribute("vendor").trim();
                    String boardName = boardElement.getAttribute("name").trim();
                    Node boardNode = Node.addUniqueChild((Node)externNode, (String)"board", (String)boardName);
                    boardNode.putProperty("vendor.name", boardVendor);
                    if (firstBoardName.length() == 0) {
                        firstBoardName = boardName;
                    }
                }
                String exampleName = exampleElement.getAttribute("name").trim();
                Node exampleNode = new Node("example");
                outlineNode.addChild((Leaf)exampleNode);
                if (firstBoardName.length() > 0) {
                    exampleNode.putProperty("example.name", exampleName);
                    String suffix = " (" + firstBoardName + ")";
                    if (!exampleName.endsWith(suffix)) {
                        exampleName = String.valueOf(exampleName) + suffix;
                    }
                }
                exampleNode.setName(exampleName);
                Element exampleDescriptionElement = Xml.getFirstChildElement((Element)exampleElement, (String)"description");
                if (exampleDescriptionElement != null) {
                    String exampleDescription = Xml.getElementMultiLineContent((Element)exampleDescriptionElement);
                    exampleNode.setDescription(exampleDescription);
                }
                if ((attributesElement = Xml.getFirstChildElement((Element)exampleElement, (String)"attributes")) == null) continue;
                List keywordElements = Xml.getChildrenElementsList((Element)attributesElement, (String)"keyword");
                for (Element keywordElement : keywordElements) {
                    String keyword = Xml.getElementContent((Element)keywordElement);
                    Node.addUniqueChild((Node)outlineNode, (String)"keyword", (String)keyword);
                }
            }
        }
        if (externNode.hasChildren()) {
            versionNode.addChild((Leaf)externNode);
        }
        if ((duration = (endTime = System.currentTimeMillis()) - beginTime) == 0L) {
            duration = 1L;
        }
        this.fOut.println("Completed in " + duration + "ms.");
    }
}

