/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnuarmeclipse.packs.cmsis;

import com.github.zafarkhaja.semver.Version;
import ilg.gnuarmeclipse.packs.cmsis.PdscUtils;
import ilg.gnuarmeclipse.packs.core.ConsoleStream;
import ilg.gnuarmeclipse.packs.core.tree.Leaf;
import ilg.gnuarmeclipse.packs.core.tree.Node;
import ilg.gnuarmeclipse.packs.data.Activator;
import ilg.gnuarmeclipse.packs.data.Utils;
import org.eclipse.ui.console.MessageConsoleStream;

public class PdscTreeParser {
    protected MessageConsoleStream fOut = ConsoleStream.getConsoleOut();
    protected Version fSemVer;

    protected boolean checkValid(Node node) {
        if (node == null || !node.hasChildren()) {
            return false;
        }
        Leaf firstChild = node.getFirstChild();
        if (!firstChild.isType("package")) {
            String msg = "Missing <package>; instead, <" + firstChild.getType() + "> encountered";
            this.fOut.println("Error+" + msg);
            Utils.reportError(msg);
            return false;
        }
        String schemaVersion = firstChild.getProperty("schemaVersion");
        this.fSemVer = Version.valueOf((String)schemaVersion);
        if (!PdscUtils.isSchemaValid(this.fSemVer)) {
            Activator.log((String)("Unrecognised schema version " + schemaVersion));
            return false;
        }
        return true;
    }

    protected Node addUniqueVendor(Node parent, String vendorName, String vendorId) {
        if (parent.hasChildren()) {
            for (Leaf child : parent.getChildren()) {
                if (!vendorId.equals(child.getProperty("vendor.id"))) continue;
                return (Node)child;
            }
        }
        Node vendor = Node.addNewChild((Node)parent, (String)"vendor");
        vendor.setName(vendorName);
        vendor.putProperty("vendor.id", vendorId);
        return vendor;
    }

    protected String updatePosixSeparators(String spath) {
        return spath.replace('\\', '/');
    }
}

