/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.event;

import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.event.MIStoppedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIExecAsyncOutput;
import org.eclipse.cdt.debug.mi.core.output.MIFrame;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MIResultRecord;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MIBreakpointHitEvent
extends MIStoppedEvent {
    int bkptno;
    MIFrame frame;

    public MIBreakpointHitEvent(MISession source, MIExecAsyncOutput record) {
        super(source, record);
        this.parse();
    }

    public MIBreakpointHitEvent(MISession source, MIResultRecord record) {
        super(source, record);
        this.parse();
    }

    public MIBreakpointHitEvent(MISession source, MIExecAsyncOutput record, int bkptNumber) {
        super(source, record);
        this.parse();
        this.bkptno = bkptNumber;
        assert (bkptNumber > 0);
    }

    public int getNumber() {
        return this.bkptno;
    }

    public MIFrame getMIFrame() {
        return this.frame;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("number=").append(this.bkptno).append('\n');
        buffer.append("thread-id=").append(this.getThreadId()).append('\n');
        buffer.append(this.frame.toString());
        return buffer.toString();
    }

    @Override
    void parse() {
        MIResult[] results = null;
        MIExecAsyncOutput exec = this.getMIExecAsyncOutput();
        MIResultRecord rr = this.getMIResultRecord();
        if (exec != null) {
            results = exec.getMIResults();
        } else if (rr != null) {
            results = rr.getMIResults();
        }
        if (results != null) {
            int i = 0;
            while (i < results.length) {
                String var = results[i].getVariable();
                MIValue value = results[i].getMIValue();
                String str = "";
                if (value != null && value instanceof MIConst) {
                    str = ((MIConst)value).getString();
                }
                if (var.equals("bkptno")) {
                    try {
                        this.bkptno = Integer.parseInt(str.trim());
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (var.equals("thread-id")) {
                    try {
                        int id = Integer.parseInt(str.trim());
                        this.setThreadId(id);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (var.equals("frame") && value instanceof MITuple) {
                    this.frame = new MIFrame((MITuple)value);
                }
                ++i;
            }
        }
    }
}

