/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.graphing.ui.charts.listeners;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.eclipse.linuxtools.systemtap.graphing.ui.charts.listeners.AbstractChartMouseMoveListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.swtchart.Chart;

public class ToolTipChartMouseMoveListener
extends AbstractChartMouseMoveListener {
    private static final int TIP_OFFSET = 20;
    protected final Shell tipShell = new Shell(Display.getCurrent().getActiveShell(), 16388);
    protected final Text tipText = new Text((Composite)this.tipShell, 3);

    public ToolTipChartMouseMoveListener(Chart chart, Composite parent) {
        super(chart, parent);
        this.tipShell.setVisible(false);
    }

    @Override
    public void exit() {
        super.exit();
        this.tipShell.setVisible(false);
    }

    protected void setTextTip(String message) {
        Point cursorLocation = Display.getCurrent().getCursorLocation();
        this.tipShell.setLocation(cursorLocation.x + 20, cursorLocation.y + 20);
        if (!message.equals(this.tipText.getText())) {
            this.tipText.setText(message);
            this.tipText.pack();
            this.tipShell.pack();
        }
        if (!this.tipShell.isVisible()) {
            this.tipShell.setVisible(true);
        }
    }

    @Override
    public String getMouseMessage() {
        FutureTask<String> f = new FutureTask<String>(new Callable<String>(){

            @Override
            public String call() {
                return ToolTipChartMouseMoveListener.this.tipText.isVisible() ? ToolTipChartMouseMoveListener.this.tipText.getText() : "";
            }
        });
        this.tipText.getDisplay().syncExec(f);
        try {
            return (String)f.get();
        }
        catch (InterruptedException | ExecutionException e) {
            return null;
        }
    }
}

