/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.mediawiki.core.tasks;

import java.io.File;
import java.net.URL;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.tasks.HtmlSourceImageFetchingStrategy;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.tasks.ImageFetchingStrategy;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.tasks.MediaWikiApiImageFetchingStrategy;

public class MediaWikiImageFetcher
extends Task {
    private String base;
    private File dest;
    private File src;
    private URL url;
    private String pageName;

    public void execute() throws BuildException {
        ImageFetchingStrategy strategy;
        if (this.dest == null) {
            throw new BuildException("Must specify @dest");
        }
        if (!this.dest.exists()) {
            throw new BuildException("@dest does not exist: " + this.dest);
        }
        if (!this.dest.isDirectory()) {
            throw new BuildException("@dest is not a directory: " + this.dest);
        }
        if (this.src == null && this.url == null) {
            throw new BuildException("Must specify @src or @url");
        }
        if (this.src != null) {
            this.log("@src is deprecated, please use @url instead", 1);
            HtmlSourceImageFetchingStrategy srcStrategy = new HtmlSourceImageFetchingStrategy();
            srcStrategy.setBase(this.base);
            srcStrategy.setSrc(this.src);
            strategy = srcStrategy;
        } else {
            if (this.base != null) {
                throw new BuildException("When @url is specified @base cannot be specified");
            }
            MediaWikiApiImageFetchingStrategy apiStrategy = new MediaWikiApiImageFetchingStrategy();
            apiStrategy.setUrl(this.url);
            apiStrategy.setPageName(this.pageName);
            strategy = apiStrategy;
        }
        strategy.setDest(this.dest);
        strategy.setTask(this);
        strategy.fetchImages();
    }

    @Deprecated
    public String getBase() {
        return this.base;
    }

    public File getDest() {
        return this.dest;
    }

    @Deprecated
    public File getSrc() {
        return this.src;
    }

    @Deprecated
    public void setBase(String base) {
        this.base = base;
    }

    public void setDest(File dest) {
        this.dest = dest;
    }

    @Deprecated
    public void setSrc(File src) {
        this.src = src;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public String getPageName() {
        return this.pageName;
    }

    public void setPageName(String pageName) {
        this.pageName = pageName;
    }
}

