/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.statesystem.core;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.statesystem.core.Activator;
import org.eclipse.tracecompass.internal.statesystem.core.AttributeTree;
import org.eclipse.tracecompass.internal.statesystem.core.TransientState;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.backend.IStateHistoryBackend;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;

public class StateSystem
implements ITmfStateSystemBuilder {
    private final AttributeTree attributeTree;
    private final TransientState transState;
    private final IStateHistoryBackend backend;
    private final CountDownLatch finishedLatch = new CountDownLatch(1);
    private boolean buildCancelled = false;
    private boolean isDisposed = false;

    public StateSystem(@NonNull IStateHistoryBackend backend) {
        this.backend = backend;
        this.transState = new TransientState(backend);
        this.attributeTree = new AttributeTree(this);
    }

    public StateSystem(@NonNull IStateHistoryBackend backend, boolean newFile) throws IOException {
        this.backend = backend;
        this.transState = new TransientState(backend);
        if (newFile) {
            this.attributeTree = new AttributeTree(this);
        } else {
            this.attributeTree = new AttributeTree(this, backend.supplyAttributeTreeReader());
            this.transState.setInactive();
            this.finishedLatch.countDown();
        }
    }

    @Override
    public String getSSID() {
        return this.backend.getSSID();
    }

    @Override
    public boolean isCancelled() {
        return this.buildCancelled;
    }

    @Override
    public void waitUntilBuilt() {
        try {
            this.finishedLatch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean waitUntilBuilt(long timeout) {
        boolean ret = false;
        try {
            ret = this.finishedLatch.await(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Override
    public synchronized void dispose() {
        this.isDisposed = true;
        if (this.transState.isActive()) {
            this.transState.setInactive();
            this.buildCancelled = true;
        }
        this.backend.dispose();
    }

    public AttributeTree getAttributeTree() {
        return this.attributeTree;
    }

    public void addEmptyAttribute() {
        this.transState.addEmptyEntry();
    }

    @Override
    public int getNbAttributes() {
        return this.getAttributeTree().getNbAttributes();
    }

    @Override
    public String getAttributeName(int attributeQuark) {
        return this.getAttributeTree().getAttributeName(attributeQuark);
    }

    @Override
    public String getFullAttributePath(int attributeQuark) {
        return this.getAttributeTree().getFullAttributeName(attributeQuark);
    }

    @Override
    public String[] getFullAttributePathArray(int attributeQuark) {
        return this.getAttributeTree().getFullAttributePathArray(attributeQuark);
    }

    @Override
    public long getStartTime() {
        return this.backend.getStartTime();
    }

    @Override
    public long getCurrentEndTime() {
        return this.backend.getEndTime();
    }

    @Override
    public void closeHistory(long endTime) throws TimeRangeException {
        long realEndTime = endTime;
        if (realEndTime < this.backend.getEndTime()) {
            realEndTime = this.backend.getEndTime();
        }
        this.transState.closeTransientState(realEndTime);
        this.backend.finishedBuilding(realEndTime);
        File attributeTreeFile = this.backend.supplyAttributeTreeWriterFile();
        long attributeTreeFilePos = this.backend.supplyAttributeTreeWriterFilePosition();
        if (attributeTreeFile != null) {
            this.getAttributeTree().writeSelf(attributeTreeFile, attributeTreeFilePos);
        }
        this.finishedLatch.countDown();
    }

    @Override
    public int getQuarkAbsolute(String ... attribute) throws AttributeNotFoundException {
        return this.getAttributeTree().getQuarkDontAdd(-1, attribute);
    }

    @Override
    public int getQuarkAbsoluteAndAdd(String ... attribute) {
        return this.getAttributeTree().getQuarkAndAdd(-1, attribute);
    }

    @Override
    public int getQuarkRelative(int startingNodeQuark, String ... subPath) throws AttributeNotFoundException {
        return this.getAttributeTree().getQuarkDontAdd(startingNodeQuark, subPath);
    }

    @Override
    public int getQuarkRelativeAndAdd(int startingNodeQuark, String ... subPath) {
        return this.getAttributeTree().getQuarkAndAdd(startingNodeQuark, subPath);
    }

    @Override
    public List<Integer> getSubAttributes(int quark, boolean recursive) throws AttributeNotFoundException {
        return this.getAttributeTree().getSubAttributes(quark, recursive);
    }

    @Override
    public List<Integer> getSubAttributes(int quark, boolean recursive, String pattern) throws AttributeNotFoundException {
        List<Integer> all = this.getSubAttributes(quark, recursive);
        LinkedList<Integer> ret = new LinkedList<Integer>();
        for (Integer attQuark : all) {
            String name = this.getAttributeName(attQuark);
            if (!name.matches(pattern)) continue;
            ret.add(attQuark);
        }
        return ret;
    }

    @Override
    public int getParentAttributeQuark(int quark) {
        return this.getAttributeTree().getParentAttributeQuark(quark);
    }

    @Override
    public List<Integer> getQuarks(String ... pattern) {
        List<Integer> directChildren;
        LinkedList<Integer> quarks = new LinkedList<Integer>();
        LinkedList<String> prefix = new LinkedList<String>();
        LinkedList<String> suffix = new LinkedList<String>();
        boolean split = false;
        String[] stringArray = pattern;
        int n = pattern.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            if (entry.equals("*")) {
                if (split) {
                    return quarks;
                }
                split = true;
            } else if (split) {
                suffix.add(entry);
            } else {
                prefix.add(entry);
            }
            ++n2;
        }
        String[] prefixStr = prefix.toArray(new String[prefix.size()]);
        String[] suffixStr = suffix.toArray(new String[suffix.size()]);
        if (!split) {
            int quark;
            try {
                quark = this.getQuarkAbsolute(prefixStr);
            }
            catch (AttributeNotFoundException e) {
                return quarks;
            }
            quarks.add(quark);
            return quarks;
        }
        try {
            int startingAttribute = prefix.size() == 0 ? -1 : this.getQuarkAbsolute(prefixStr);
            directChildren = this.getSubAttributes(startingAttribute, false);
        }
        catch (AttributeNotFoundException e) {
            return quarks;
        }
        for (int childQuark : directChildren) {
            int matchingQuark;
            try {
                matchingQuark = this.getQuarkRelative(childQuark, suffixStr);
            }
            catch (AttributeNotFoundException e) {
                continue;
            }
            quarks.add(matchingQuark);
        }
        return quarks;
    }

    @Override
    public void modifyAttribute(long t, ITmfStateValue value, int attributeQuark) throws TimeRangeException, AttributeNotFoundException, StateValueTypeException {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.transState.processStateChange(t, value, attributeQuark);
    }

    @Override
    public void incrementAttribute(long t, int attributeQuark) throws StateValueTypeException, TimeRangeException, AttributeNotFoundException {
        ITmfStateValue stateValue = this.queryOngoingState(attributeQuark);
        int prevValue = 0;
        if (!stateValue.isNull()) {
            prevValue = stateValue.unboxInt();
        }
        this.modifyAttribute(t, TmfStateValue.newValueInt(prevValue + 1), attributeQuark);
    }

    @Override
    public void pushAttribute(long t, ITmfStateValue value, int attributeQuark) throws TimeRangeException, AttributeNotFoundException, StateValueTypeException {
        int stackDepth;
        ITmfStateValue previousSV = this.transState.getOngoingStateValue(attributeQuark);
        if (previousSV.isNull()) {
            stackDepth = 0;
        } else if (previousSV.getType() == ITmfStateValue.Type.INTEGER) {
            stackDepth = previousSV.unboxInt();
        } else {
            throw new StateValueTypeException(String.valueOf(this.getSSID()) + " Quark:" + attributeQuark + ", Type:" + (Object)((Object)previousSV.getType()) + ", Expected:" + (Object)((Object)ITmfStateValue.Type.INTEGER));
        }
        if (stackDepth >= 100000) {
            String message = " Stack limit reached, not pushing";
            throw new AttributeNotFoundException(String.valueOf(this.getSSID()) + " Quark:" + attributeQuark + message);
        }
        int subAttributeQuark = this.getQuarkRelativeAndAdd(attributeQuark, String.valueOf(++stackDepth));
        this.modifyAttribute(t, TmfStateValue.newValueInt(stackDepth), attributeQuark);
        this.modifyAttribute(t, value, subAttributeQuark);
    }

    @Override
    public ITmfStateValue popAttribute(long t, int attributeQuark) throws AttributeNotFoundException, TimeRangeException, StateValueTypeException {
        ITmfStateValue previousSV = this.transState.getOngoingStateValue(attributeQuark);
        if (previousSV.isNull()) {
            return null;
        }
        if (previousSV.getType() != ITmfStateValue.Type.INTEGER) {
            throw new StateValueTypeException(String.valueOf(this.getSSID()) + " Quark:" + attributeQuark + ", Type:" + (Object)((Object)previousSV.getType()) + ", Expected:" + (Object)((Object)ITmfStateValue.Type.INTEGER));
        }
        int stackDepth = previousSV.unboxInt();
        if (stackDepth <= 0) {
            throw new StateValueTypeException(String.valueOf(this.getSSID()) + " Quark:" + attributeQuark + ", Stack depth:" + stackDepth);
        }
        int subAttributeQuark = this.getQuarkRelative(attributeQuark, String.valueOf(stackDepth));
        ITmfStateValue poppedValue = this.queryOngoingState(subAttributeQuark);
        TmfStateValue nextSV = --stackDepth == 0 ? TmfStateValue.nullValue() : TmfStateValue.newValueInt(stackDepth);
        this.modifyAttribute(t, nextSV, attributeQuark);
        this.removeAttribute(t, subAttributeQuark);
        return poppedValue;
    }

    @Override
    public void removeAttribute(long t, int attributeQuark) throws TimeRangeException, AttributeNotFoundException {
        if (attributeQuark < 0) {
            throw new IllegalArgumentException();
        }
        List<Integer> childAttributes = this.getSubAttributes(attributeQuark, false);
        for (int childNodeQuark : childAttributes) {
            if (attributeQuark == childNodeQuark) {
                throw new IllegalStateException();
            }
            this.removeAttribute(t, childNodeQuark);
        }
        try {
            this.transState.processStateChange(t, TmfStateValue.nullValue(), attributeQuark);
        }
        catch (StateValueTypeException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public ITmfStateValue queryOngoingState(int attributeQuark) throws AttributeNotFoundException {
        return this.transState.getOngoingStateValue(attributeQuark);
    }

    @Override
    public long getOngoingStartTime(int attribute) throws AttributeNotFoundException {
        return this.transState.getOngoingStartTime(attribute);
    }

    @Override
    public void updateOngoingState(ITmfStateValue newValue, int attributeQuark) throws AttributeNotFoundException {
        this.transState.changeOngoingStateValue(attributeQuark, newValue);
    }

    protected void replaceOngoingState(@NonNull List<ITmfStateInterval> newStateIntervals) {
        this.transState.replaceOngoingState(newStateIntervals);
    }

    @Override
    public synchronized List<ITmfStateInterval> queryFullState(long t) throws TimeRangeException, StateSystemDisposedException {
        if (this.isDisposed) {
            throw new StateSystemDisposedException();
        }
        int nbAttr = this.getNbAttributes();
        ArrayList<ITmfStateInterval> stateInfo = new ArrayList<ITmfStateInterval>(nbAttr);
        int i = 0;
        while (i < nbAttr) {
            stateInfo.add(null);
            ++i;
        }
        if (this.transState.isActive()) {
            this.transState.doQuery(stateInfo, t);
        }
        this.backend.doQuery(stateInfo, t);
        for (ITmfStateInterval interval : stateInfo) {
            if (interval != null) continue;
            throw new IllegalStateException("Incoherent interval storage");
        }
        return stateInfo;
    }

    @Override
    public ITmfStateInterval querySingleState(long t, int attributeQuark) throws AttributeNotFoundException, TimeRangeException, StateSystemDisposedException {
        if (this.isDisposed) {
            throw new StateSystemDisposedException();
        }
        ITmfStateInterval ret = this.transState.getIntervalAt(t, attributeQuark);
        if (ret == null) {
            ret = this.backend.doSingularQuery(t, attributeQuark);
        }
        if (ret == null) {
            throw new IllegalStateException("Incoherent interval storage");
        }
        return ret;
    }

    static void logMissingInterval(int attribute, long timestamp) {
        Activator.getDefault().logInfo("No data found in history for attribute " + attribute + " at time " + timestamp + ", returning dummy interval");
    }

    public void debugPrint(@NonNull PrintWriter writer) {
        this.getAttributeTree().debugPrint(writer);
        this.transState.debugPrint(writer);
        this.backend.debugPrint(writer);
    }
}

