/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownTypeScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.core.runtime.PlatformObject;

public abstract class CPPUnknownBinding
extends PlatformObject
implements ICPPUnknownBinding,
ICPPInternalBinding,
Cloneable {
    private ICPPScope unknownScope;
    protected char[] name;

    public CPPUnknownBinding(char[] name) {
        this.name = name;
    }

    @Override
    public IASTNode[] getDeclarations() {
        return null;
    }

    @Override
    public IASTNode getDefinition() {
        return null;
    }

    @Override
    public void addDefinition(IASTNode node) {
    }

    @Override
    public void addDeclaration(IASTNode node) {
    }

    @Override
    public String[] getQualifiedName() {
        return CPPVisitor.getQualifiedName(this);
    }

    @Override
    public char[][] getQualifiedNameCharArray() {
        return CPPVisitor.getQualifiedNameCharArray(this);
    }

    @Override
    public boolean isGloballyQualified() {
        return false;
    }

    @Override
    public String getName() {
        return new String(this.name);
    }

    @Override
    public char[] getNameCharArray() {
        return this.name;
    }

    @Override
    public IScope getScope() throws DOMException {
        IBinding owner = this.getOwner();
        if (owner instanceof ICPPUnknownBinding) {
            return ((ICPPUnknownBinding)owner).asScope();
        }
        if (owner instanceof ICPPClassType) {
            return ((ICPPClassType)owner).getCompositeScope();
        }
        if (owner instanceof ICPPNamespace) {
            return ((ICPPNamespace)owner).getNamespaceScope();
        }
        if (owner instanceof ICPPFunction) {
            return ((ICPPFunction)owner).getFunctionScope();
        }
        return null;
    }

    @Override
    public ICPPScope asScope() {
        if (this.unknownScope == null && this instanceof ICPPUnknownType) {
            this.unknownScope = this.createScope();
        }
        return this.unknownScope;
    }

    protected CPPUnknownTypeScope createScope() {
        return new CPPUnknownTypeScope((ICPPUnknownType)((Object)this), new CPPASTName(this.name));
    }

    @Override
    public ILinkage getLinkage() {
        return Linkage.CPP_LINKAGE;
    }

    public CPPUnknownBinding clone() {
        try {
            return (CPPUnknownBinding)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String toString() {
        return this.getName();
    }
}

