/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.rewrite.astwriter;

import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTASMDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVisibilityLabel;
import org.eclipse.cdt.internal.core.dom.rewrite.ASTModificationStore;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.ContainerNode;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.ProblemRuntimeException;
import org.eclipse.cdt.internal.core.dom.rewrite.changegenerator.ChangeGeneratorWriterVisitor;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.NodeCommentMap;

public class ASTWriter {
    private final ASTModificationStore modificationStore = new ASTModificationStore();

    public String write(IASTNode rootNode) throws ProblemRuntimeException {
        return this.write(rootNode, new NodeCommentMap());
    }

    public String write(IASTNode rootNode, NodeCommentMap commentMap) throws ProblemRuntimeException {
        ChangeGeneratorWriterVisitor writer = new ChangeGeneratorWriterVisitor(this.modificationStore, null, commentMap);
        if (rootNode != null) {
            rootNode.accept(writer);
        }
        return writer.toString();
    }

    public static boolean requiresLeadingBlankLine(IASTNode node) {
        if (node instanceof ICPPASTTemplateDeclaration) {
            node = ((ICPPASTTemplateDeclaration)node).getDeclaration();
        }
        return node instanceof IASTASMDeclaration || node instanceof IASTFunctionDefinition || node instanceof ICPPASTVisibilityLabel;
    }

    public static boolean requiresTrailingBlankLine(IASTNode node) {
        if (node instanceof ICPPASTNamespaceDefinition) {
            return true;
        }
        if (node instanceof IASTFunctionDefinition) {
            return true;
        }
        if (node instanceof IASTIfStatement) {
            IASTIfStatement statement = (IASTIfStatement)node;
            IASTStatement lastClause = statement.getElseClause();
            if (lastClause == null) {
                lastClause = statement.getThenClause();
            }
            if (!(lastClause instanceof IASTCompoundStatement) && !ASTWriter.doNodesHaveSameOffset(lastClause, statement)) {
                return true;
            }
        }
        return false;
    }

    public static boolean suppressesTrailingBlankLine(IASTNode node) {
        return node instanceof ICPPASTVisibilityLabel;
    }

    public static boolean requireBlankLineInBetween(IASTNode node1, IASTNode node2) {
        List<IASTNode> nodes;
        if (node1 instanceof ContainerNode && !(nodes = ((ContainerNode)node1).getNodes()).isEmpty()) {
            node1 = nodes.get(nodes.size() - 1);
        }
        if (node2 instanceof ContainerNode && !(nodes = ((ContainerNode)node2).getNodes()).isEmpty()) {
            node2 = nodes.get(0);
        }
        while (node1 instanceof ICPPASTTemplateDeclaration) {
            node1 = ((ICPPASTTemplateDeclaration)node1).getDeclaration();
        }
        while (node2 instanceof ICPPASTTemplateDeclaration) {
            node2 = ((ICPPASTTemplateDeclaration)node2).getDeclaration();
        }
        if (node1 instanceof ICPPASTVisibilityLabel && node2 instanceof ICPPASTVisibilityLabel) {
            return true;
        }
        if (ASTWriter.suppressesTrailingBlankLine(node1)) {
            return false;
        }
        if (node1 instanceof IASTPreprocessorIncludeStatement != node2 instanceof IASTPreprocessorIncludeStatement) {
            return true;
        }
        if (ASTWriter.isFunctionDeclaration(node1) != ASTWriter.isFunctionDeclaration(node2)) {
            return true;
        }
        if (node2 != null && ASTWriter.requiresTrailingBlankLine(node1)) {
            return true;
        }
        return ASTWriter.requiresLeadingBlankLine(node2);
    }

    private static boolean isFunctionDeclaration(IASTNode node) {
        if (!(node instanceof IASTSimpleDeclaration)) {
            return false;
        }
        IASTDeclarator[] iASTDeclaratorArray = ((IASTSimpleDeclaration)node).getDeclarators();
        int n = iASTDeclaratorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclarator declarator = iASTDeclaratorArray[n2];
            if (declarator instanceof IASTFunctionDeclarator) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean doNodesHaveSameOffset(IASTNode node1, IASTNode node2) {
        IASTFileLocation fileLocation1 = node1.getFileLocation();
        IASTFileLocation fileLocation2 = node2.getFileLocation();
        return fileLocation1 != null && fileLocation2 != null && fileLocation1.getNodeOffset() == fileLocation2.getNodeOffset();
    }
}

