import os
import shutil

def removeRedundantFiles():
	commonPath = 'configuration/'
	# remove files
	filesToRemove = \
	commonPath + 'org.eclipse.oomph.setup/setup.log',\
	commonPath + 'org.eclipse.osgi/.manager/.fileTableLock',\
	commonPath + '.settings/ilg.gnuarmeclipse.managedbuild.cross.prefs',\

	notFoundList = []
	for file in filesToRemove:
		if os.path.isfile(file):
			print('remove ' + str(file))
			os.remove(file)
		else:
			notFoundList.append(str(file) + ' not found')

	# remove folders
	foldersToRemove = \
	'configuration/.eclipseextension',\
	'plugins/org.eclipse.justj.openjdk.hotspot.jre.full.win32.x86_64_14.0.2.v20200815-0932/META-INF/maven',\

	for folder in foldersToRemove:
		if os.path.isdir(folder):
			print('removed the folder of ' + str(folder))
			shutil.rmtree(folder, ignore_errors=True)
		else:
			notFoundList.append('the folder ' + str(folder) + ' not found')

	# print those not found
	for notFound in notFoundList:
		print(notFound)

def checkRedundantFiles():
	checkResult = True
	commonPath = 'configuration/'
	# remove files
	filesToRemove = \
	commonPath + 'org.eclipse.oomph.setup/setup.log',\
	commonPath + 'org.eclipse.osgi/.manager/.fileTableLock',\
	commonPath + '.settings/ilg.gnuarmeclipse.managedbuild.cross.prefs',\

	for file in filesToRemove:
		if os.path.isfile(file):
			print(str(file) + ' is still there. Please remove it manually.')
			checkResult = False

	# remove folders
	foldersToRemove = \
	'configuration/.eclipseextension',\
	'plugins/org.eclipse.justj.openjdk.hotspot.jre.full.win32.x86_64_14.0.2.v20200815-0932/META-INF/maven',\

	for folder in foldersToRemove:
		if os.path.isdir(folder):
			print(str(folder) + ' is still there. Please remove it manually.')
			checkResult = False

	if not checkResult:
		os.system("pause")

def openFiles():
	commonPath = 'configuration/'
	# open files
	filesToOpen = \
	commonPath + '.settings/org.eclipse.ui.ide.prefs',\

	notFoundList = []
	for file in filesToOpen:
		if os.path.isfile(file):
			print('open ' + str(file))
			if os.name == 'nt':
				osCommandString = 'notepad.exe ' + str(file)
			else:			
				osCommandString = 'gedit ' + str(file)
			os.system(osCommandString)
		else:
			notFoundList.append(str(file) + ' not found')

	# print those not found
	for notFound in notFoundList:
		print(notFound)

answer = input("Do you want to remove redundant files for the release purpose?\n\
(If you are developing the tool, please do not enter yes. Many files will be gone.)\n\
Enter yes or no:")
if answer == "yes":
	removeRedundantFiles()
	checkRedundantFiles()
	openFiles()
elif answer == "no":
	print ('OK. Keep everything')
else:
	print("Please enter yes or no.")
