// chip content
NUTOOL_PIN.g_cfg_chips = [
	//M251
	{ name: "M251FB2AE", pkg: "TSSOP20" },
	{ name: "M251FC2AE", pkg: "TSSOP20" },
	{ name: "M251EB2AE", pkg: "TSSOP28" },
	{ name: "M251EC2AE", pkg: "TSSOP28" },
	{ name: "M251ZB2AE", pkg: "QFN33" },
	{ name: "M251ZC2AE", pkg: "QFN33" },
	{ name: "M251ZD2AE", pkg: "QFN33" },
	{ name: "M251LC2AE", pkg: "LQFP48" },
	{ name: "M251LD2AE", pkg: "LQFP48" },
	{ name: "M251LE3AE", pkg: "LQFP48" },
	{ name: "M251LG6AE", pkg: "LQFP48" },
	{ name: "M251SC2AE", pkg: "LQFP64" },
	{ name: "M251SD2AE", pkg: "LQFP64" },
	{ name: "M251SE3AE", pkg: "LQFP64" },
	{ name: "M251SG6AE", pkg: "LQFP64" },
	{ name: "M251KE3AE", pkg: "LQFP128" },
	{ name: "M251KG6AE", pkg: "LQFP128" },
	//M252
	{ name: "M252FC2AE", pkg: "TSSOP20" },
	{ name: "M252EC2AE", pkg: "TSSOP28" },
	{ name: "M252ZC2AE", pkg: "QFN33" },
	{ name: "M252ZD2AE", pkg: "QFN33" },
	{ name: "M252LC2AE", pkg: "LQFP48" },
	{ name: "M252LD2AE", pkg: "LQFP48" },
	{ name: "M252LE3AE", pkg: "LQFP48" },
	{ name: "M252LG6AE", pkg: "LQFP48" },
	{ name: "M252SC2AE", pkg: "LQFP64" },
	{ name: "M252SD2AE", pkg: "LQFP64" },
	{ name: "M252SE3AE", pkg: "LQFP64" },
	{ name: "M252SG6AE", pkg: "LQFP64" },
	{ name: "M252KE3AE", pkg: "LQFP128" },
	{ name: "M252KG6AE", pkg: "LQFP128" },
	//M253
	{ name: "M253ZE3AE", pkg: "QFN33" },
	{ name: "M253LD3AE", pkg: "LQFP48" },
	{ name: "M253LE3AE", pkg: "LQFP48" },
	//M256D
	{ name: "M256MD2AE", pkg: "LQFP44" },
	{ name: "M254SD2AE", pkg: "LQFP64" },
	{ name: "M256SD2AE", pkg: "LQFP64" },
	//M258
	{ name: "M254SD3AE", pkg: "LQFP64" },
	{ name: "M254SE3AE", pkg: "LQFP64" },
	{ name: "M254QD3AE", pkg: "LQFP80" },
	{ name: "M254QE3AE", pkg: "LQFP80" },
	{ name: "M254KD3AE", pkg: "LQFP128" },
	{ name: "M254KE3AE", pkg: "LQFP128" },
	//{ name: "M254ME3AE", pkg: "LQFP44" },
	{ name: "M256SD3AE", pkg: "LQFP64" },
	{ name: "M256SE3AE", pkg: "LQFP64" },
	{ name: "M256QD3AE", pkg: "LQFP80" },
	{ name: "M256QE3AE", pkg: "LQFP80" },
	{ name: "M256KD3AE", pkg: "LQFP128" },
	{ name: "M256KE3AE", pkg: "LQFP128" },
	{ name: "M258SD3AE", pkg: "LQFP64" },
	{ name: "M258SE3AE", pkg: "LQFP64" },
	{ name: "M258QD3AE", pkg: "LQFP80" },
	{ name: "M258QE3AE", pkg: "LQFP80" },
	{ name: "M258KD3AE", pkg: "LQFP128" },
	{ name: "M258KE3AE", pkg: "LQFP128" },
	//M258G
	{ name: "M258SG6AE", pkg: "LQFP64" },
	{ name: "M256QG6AE", pkg: "LQFP80" },
	{ name: "M254KG6AE", pkg: "LQFP128" },
	{ name: "M258KG6AE", pkg: "LQFP128" }
];

NUTOOL_PIN.g_cfg_pkgs = {
	"LQFP44": [
		'PB.5', 'PB.4', 'PB.3', 'PB.2', 'PB.1', 'PB.0', 'PA.11', 'PA.10', 'PA.9', 'VLCD',
		'PF.5',
		'PF.4', 'PF.3', 'PF.2', 'PA.7', 'PA.6', 'PA.3', 'PA.2', 'PA.1', 'PA.0', 'nRESET',
		'PF.0',
		'PF.1', 'PC.5', 'PC.4', 'PC.3', 'PC.2', 'PC.1', 'PC.0', 'PA.12', 'PA.13', 'PA.14',
		'PA.15',
		'VSS', 'LDO_CAP', 'VDD', 'PB.15', 'PB.14', 'PB.13', 'PB.12', 'AVDD', 'AVSS', 'PB.7',
		'PB.6'
	],
	"LQFP64": [
		'PB.6', 'PB.5', 'PB.4', 'PB.3', 'PB.2', 'PB.1', 'PB.0', 'PA.11', 'PA.10', 'PA.9',
		'PA.8', 'VLCD', 'PF.14', 'PF.5', 'PF.4', 'PF.3',
		'PF.2', 'PC.7', 'PC.6', 'PA.7', 'PA.6', 'VSS', 'VDD', 'PD.15', 'PA.5', 'PA.4',
		'PA.3', 'PA.2', 'PA.1', 'PA.0', 'PF.15', 'nRESET',
		'PF.0', 'PF.1', 'PC.5', 'PC.4', 'PC.3', 'PC.2', 'PC.1', 'PC.0', 'PD.3', 'PD.2',
		'PD.1', 'PD.0', 'PA.12', 'PA.13', 'PA.14', 'PA.15',
		'VSS', 'LDO_CAP', 'VDD', 'PC.14', 'PB.15', 'PB.14', 'PB.13', 'PB.12', 'AVDD', 'VREF',
		'AVSS', 'PB.11', 'PB.10', 'PB.9', 'PB.8', 'PB.7'
	]
};

NUTOOL_PIN.g_cfg_gpios = [
	{ f: ['PA.0:0', 'SPI0_MOSI:4', 'TK_TK6:5', 'SC0_CLK:6', 'UART0_RXD:7', 'UART1_nRTS:8', 'BPWM0_CH0:12'] },
	{ f: ['PA.1:0', 'SPI0_MISO:4', 'TK_TK5:5', 'SC0_DAT:6', 'UART0_TXD:7', 'UART1_nCTS:8', 'BPWM0_CH1:12'] },
	{ f: ['PA.2:0', 'SPI0_CLK:4', 'TK_TK4:5', 'SC0_RST:6', 'I2C0_SMBSUS:7', 'UART1_RXD:8', 'BPWM0_CH2:12'] },
	{ f: ['PA.3:0', 'SPI0_SS:4', 'TK_TK3:5', 'SC0_PWR:6', 'I2C0_SMBAL:7', 'UART1_TXD:8', 'BPWM0_CH3:12', 'CLKO:14'] },
	{ f: ['PA.4:0', 'SPI0_I2SMCLK:4', 'TK_TK2:5', 'SC0_nCD:6', 'UART0_nRTS:7', 'UART0_RXD:8', 'I2C0_SDA:9', 'BPWM0_CH4:12'] },
	{ f: ['PA.5:0', 'TK_TK1:5', 'UART0_nCTS:7', 'UART0_TXD:8', 'I2C0_SCL:9', 'BPWM0_CH5:12'] },
	{ f: ['PA.6:0', 'LCD_SEG36:5', 'UART0_RXD:7', 'ACMP1_WLAT:13', 'TM3:14', 'INT0:15'] },
	{ f: ['PA.7:0', 'LCD_SEG37:5', 'UART0_TXD:7', 'ACMP0_WLAT:13', 'TM2:14', 'INT1:15'] },
	{ f: ['PA.8:0', 'USCI0_CTL1:6', 'UART1_RXD:7', 'BPWM0_CH3:9', 'TM3_EXT:13', 'INT4:15'] },
	{ f: ['PA.9:0', 'USCI0_DAT1:6', 'UART1_TXD:7', 'BPWM0_CH2:9', 'TM2_EXT:13'] },
	{ f: ['PA.10:0', 'ACMP1_P0:1', 'USCI0_DAT0:6', 'BPWM0_CH1:9', 'TM1_EXT:13'] },
	{ f: ['PA.11:0', 'ACMP0_P0:1', 'USCI0_CLK:6', 'BPWM0_CH0:9', 'TM0_EXT:13'] },
	{ f: ['PA.12:0', 'LCD_SEG20:5', 'LCD_SEG47:5'] },
	{ f: ['PA.13:0', 'LCD_SEG19:5', 'LCD_SEG46:5'] },
	{ f: ['PA.14:0', 'UART0_TXD:3', 'LCD_SEG18:5', 'LCD_SEG45:5'] },
	{ f: ['PA.15:0', 'UART0_RXD:3', 'LCD_SEG17:5', 'LCD_SEG44:5'] },

	{ f: ['PB.0:0', 'EADC0_CH0:1', 'LCD_SEG0:5', 'UART2_RXD:7', 'SPI0_I2SMCLK:8'] },
	{ f: ['PB.1:0', 'EADC0_CH1:1', 'LCD_SEG1:5', 'UART2_TXD:7'] },
	{ f: ['PB.2:0', 'EADC0_CH2:1', 'ACMP0_P1:1', 'LCD_COM3:5', 'UART1_RXD:6', 'SC0_PWR:9', 'TM3:14', 'INT3:15'] },
	{ f: ['PB.3:0', 'EADC0_CH3:1', 'ACMP0_N:1', 'LCD_COM2:5', 'UART1_TXD:6', 'SC0_RST:9', 'TM2:14', 'INT2:15'] },
	{ f: ['PB.4:0', 'EADC0_CH4:1', 'ACMP1_P1:1', 'LCD_COM1:5', 'I2C0_SDA:6', 'SC0_DAT:9', 'UART2_RXD:13', 'TM1:14', 'INT1:15'] },
	{ f: ['PB.5:0', 'EADC0_CH5:1', 'ACMP1_N:1', 'LCD_COM0:5', 'I2C0_SCL:6', 'SC0_CLK:9', 'UART2_TXD:13', 'TM0:14', 'INT0:15'] },
	{ f: ['PB.6:0', 'EADC0_CH6:1', 'UART1_RXD:6', 'LCD_SEG4:9', 'INT4:13', 'ACMP1_O:15'] },
	{ f: ['PB.7:0', 'EADC0_CH7:1', 'UART1_TXD:6', 'LCD_SEG5:9', 'INT5:13', 'ACMP0_O:15'] },
	{ f: ['PB.8:0', 'EADC0_CH8:1', 'UART0_RXD:5', 'UART1_nRTS:6', 'LCD_SEG6:8', 'LCD_V3:8'] },
	{ f: ['PB.9:0', 'EADC0_CH9:1', 'UART0_TXD:5', 'UART1_nCTS:6', 'LCD_SEG7:8', 'LCD_V2:8'] },
	{ f: ['PB.10:0', 'EADC0_CH10:1', 'UART0_nRTS:5', 'LCD_SEG8:8', 'LCD_V1:8'] },
	{ f: ['PB.11:0', 'EADC0_CH11:1', 'UART0_nCTS:5', 'LCD_SEG9:8', 'SPI0_I2SMCLK:9'] },
	{ f: ['PB.12:0', 'EADC0_CH12:1', 'ACMP0_P2:1', 'ACMP1_P2:1', 'SPI0_MOSI:4', 'USCI0_CLK:5', 'UART0_RXD:6', 'LCD_SEG10:8', 'TM3_EXT:13'] },
	{ f: ['PB.13:0', 'EADC0_CH13:1', 'ACMP0_P3:1', 'ACMP1_P3:1', 'SPI0_MISO:4', 'USCI0_DAT0:5', 'UART0_TXD:6', 'LCD_SEG11:8', 'TM2_EXT:13'] },
	{ f: ['PB.14:0', 'EADC0_CH14:1', 'SPI0_CLK:4', 'USCI0_DAT1:5', 'UART0_nRTS:6', 'LCD_SEG12:8', 'TM1_EXT:13', 'CLKO:14', 'TK_SE:15'] },
	{ f: ['PB.15:0', 'EADC0_CH15:1', 'SPI0_SS:4', 'USCI0_CTL1:5', 'UART0_nCTS:6', 'LCD_SEG13:8', 'LCD_COM1:8', 'TM0_EXT:13'] },

	{ f: ['PC.0:0', 'LCD_SEG26:5', 'LCD_COM3:5', 'UART2_RXD:8', 'I2C0_SDA:9', 'ACMP1_O:14'] },
	{ f: ['PC.1:0', 'LCD_SEG27:5', 'LCD_COM2:5', 'UART2_TXD:8', 'I2C0_SCL:9', 'ACMP0_O:14'] },
	{ f: ['PC.2:0', 'LCD_SEG28:5', 'LCD_COM7:5', 'TK_TK12:6', 'UART2_nCTS:8', 'I2C0_SMBSUS:9'] },
	{ f: ['PC.3:0', 'LCD_SEG29:5', 'LCD_COM6:5', 'TK_TK11:6', 'UART2_nRTS:8', 'I2C0_SMBAL:9'] },
	{ f: ['PC.4:0', 'LCD_SEG30:5', 'LCD_COM5:5', 'TK_TK10:6', 'UART2_RXD:8'] },
	{ f: ['PC.5:0', 'LCD_SEG31:5', 'LCD_COM4:5', 'TK_TK9:6', 'UART2_TXD:8'] },
	{ f: ['PC.6:0', 'LCD_SEG38:5', 'UART0_nRTS:7', 'TM1:14', 'INT2:15'] },
	{ f: ['PC.7:0', 'LCD_SEG39:5', 'UART0_nCTS:7', 'TM0:14', 'INT3:15'] },
	{ f: ['PC.8:0'] },
	{ f: ['PC.9:0'] },
	{ f: ['PC.10:0'] },
	{ f: ['PC.11:0'] },
	{ f: ['PC.12:0'] },
	{ f: ['PC.13:0'] },
	{ f: ['PC.14:0', 'SPI0_I2SMCLK:4', 'USCI0_CTL0:5', 'LCD_SEG14:8', 'LCD_COM0:8', 'TM1:13'] },
	{ f: ['PC.15:0'] },

	{ f: ['PD.0:0', 'USCI0_CLK:3', 'SPI0_MOSI:4', 'LCD_SEG22:5', 'TK_TK16:7', 'TM2:14'] },
	{ f: ['PD.1:0', 'USCI0_DAT0:3', 'SPI0_MISO:4', 'LCD_SEG23:5', 'TK_TK15:7'] },
	{ f: ['PD.2:0', 'USCI0_DAT1:3', 'SPI0_CLK:4', 'LCD_SEG24:5', 'TK_TK14:7', 'UART0_RXD:9'] },
	{ f: ['PD.3:0', 'USCI0_CTL1:3', 'SPI0_SS:4', 'LCD_SEG25:5', 'TK_TK13:7', 'UART0_TXD:9'] },
	{ f: ['PD.4:0'] },
	{ f: ['PD.5:0'] },
	{ f: ['PD.6:0'] },
	{ f: ['PD.7:0'] },
	{ f: ['PD.8:0'] },
	{ f: ['PD.9:0'] },
	{ f: ['PD.10:0'] },
	{ f: ['PD.11:0'] },
	{ f: ['PD.12:0'] },
	{ f: ['PD.13:0'] },
	{ f: ['PD.14:0'] },
	{ f: ['PD.15:0', 'TK_TK0:5', 'TM3:14', 'INT1:15'] },

	{ f: ['PE.0:0']},
	{ f: ['PE.1:0']},
	{ f: ['PE.2:0']},
	{ f: ['PE.3:0']},
	{ f: ['PE.4:0']},
	{ f: ['PE.5:0']},
	{ f: ['PE.6:0']},
	{ f: ['PE.7:0']},
	{ f: ['PE.8:0']},
	{ f: ['PE.9:0']},
	{ f: ['PE.10:0']},
	{ f: ['PE.11:0']},
	{ f: ['PE.12:0']},
	{ f: ['PE.13:0']},
	{ f: ['PE.14:0']},
	{ f: ['PE.15:0']},

	{ f: ['PF.0:0', 'UART1_TXD:2', 'UART0_TXD:4', 'ICE_DAT:14'] },
	{ f: ['PF.1:0', 'UART1_RXD:2', 'UART0_RXD:4', 'ICE_CLK:14'] },
	{ f: ['PF.2:0', 'UART0_RXD:3', 'I2C0_SDA:4', 'XT1_OUT:10'] },
	{ f: ['PF.3:0', 'UART0_TXD:3', 'I2C0_SCL:4', 'XT1_IN:10'] },
	{ f: ['PF.4:0', 'UART2_TXD:2', 'UART2_nRTS:4', 'BPWM0_CH5:8', 'X32_OUT:10'] },
	{ f: ['PF.5:0', 'UART2_RXD:2', 'UART2_nCTS:4', 'BPWM0_CH4:8', 'X32_IN:10', 'EADC0_ST:11'] },
	{ f: ['PF.6:0'] },
	{ f: ['PF.7:0'] },
	{ f: ['PF.8:0'] },
	{ f: ['PF.9:0'] },
	{ f: ['PF.10:0'] },
	{ f: ['PF.11:0'] },
	{ f: ['PF.12:0'] },
	{ f: ['PF.13:0'] },
	{ f: ['PF.14:0', 'CLKO:13', 'TM3:14', 'INT5:15'] },
	{ f: ['PF.15:0', 'LCD_SEG35:5', 'TK_TK7:6', 'TM2:13', 'CLKO:14', 'INT4:15'] }
];

NUTOOL_PIN.g_cfg_gpiosDefines = [
	{ f: ['PA.0', 'GPIO:SYS_GPA_MFPL_PA0MFP_GPIO@GPA_MFPL', 'QSPI0_MOSI0:SYS_GPA_MFPL_PA0MFP_QSPI0_MOSI0@GPA_MFPL', 'SPI0_MOSI:SYS_GPA_MFPL_PA0MFP_SPI0_MOSI@GPA_MFPL', 'TK_TK6:SYS_GPA_MFPL_PA0MFP_TK_TK6@GPA_MFPL', 'SC0_CLK:SYS_GPA_MFPL_PA0MFP_SC0_CLK@GPA_MFPL', 'UART0_RXD:SYS_GPA_MFPL_PA0MFP_UART0_RXD@GPA_MFPL', 'UART1_nRTS:SYS_GPA_MFPL_PA0MFP_UART1_nRTS@GPA_MFPL', 'PSIO0_CH7:SYS_GPA_MFPL_PA0MFP_PSIO0_CH7@GPA_MFPL', 'USCI2_DAT1:SYS_GPA_MFPL_PA0MFP_USCI2_DAT1@GPA_MFPL', 'BPWM0_CH0:SYS_GPA_MFPL_PA0MFP_BPWM0_CH0@GPA_MFPL', 'PWM0_CH5:SYS_GPA_MFPL_PA0MFP_PWM0_CH5@GPA_MFPL', 'DAC0_ST:SYS_GPA_MFPL_PA0MFP_DAC0_ST@GPA_MFPL'] },
	{ f: ['PA.1', 'GPIO:SYS_GPA_MFPL_PA1MFP_GPIO@GPA_MFPL', 'QSPI0_MISO0:SYS_GPA_MFPL_PA1MFP_QSPI0_MISO0@GPA_MFPL', 'SPI0_MISO:SYS_GPA_MFPL_PA1MFP_SPI0_MISO@GPA_MFPL', 'TK_TK5:SYS_GPA_MFPL_PA1MFP_TK_TK5@GPA_MFPL', 'SC0_DAT:SYS_GPA_MFPL_PA1MFP_SC0_DAT@GPA_MFPL', 'UART0_TXD:SYS_GPA_MFPL_PA1MFP_UART0_TXD@GPA_MFPL', 'UART1_nCTS:SYS_GPA_MFPL_PA1MFP_UART1_nCTS@GPA_MFPL', 'PSIO0_CH6:SYS_GPA_MFPL_PA1MFP_PSIO0_CH6@GPA_MFPL', 'USCI2_DAT0:SYS_GPA_MFPL_PA1MFP_USCI2_DAT0@GPA_MFPL', 'BPWM0_CH1:SYS_GPA_MFPL_PA1MFP_BPWM0_CH1@GPA_MFPL', 'PWM0_CH4:SYS_GPA_MFPL_PA1MFP_PWM0_CH4@GPA_MFPL', 'DAC1_ST:SYS_GPA_MFPL_PA1MFP_DAC1_ST@GPA_MFPL'] },
	{ f: ['PA.2', 'GPIO:SYS_GPA_MFPL_PA2MFP_GPIO@GPA_MFPL', 'QSPI0_CLK:SYS_GPA_MFPL_PA2MFP_QSPI0_CLK@GPA_MFPL', 'SPI0_CLK:SYS_GPA_MFPL_PA2MFP_SPI0_CLK@GPA_MFPL', 'TK_TK4:SYS_GPA_MFPL_PA2MFP_TK_TK4@GPA_MFPL', 'SC0_RST:SYS_GPA_MFPL_PA2MFP_SC0_RST@GPA_MFPL', 'I2C0_SMBSUS:SYS_GPA_MFPL_PA2MFP_I2C0_SMBSUS@GPA_MFPL', 'UART1_RXD:SYS_GPA_MFPL_PA2MFP_UART1_RXD@GPA_MFPL', 'I2C1_SDA:SYS_GPA_MFPL_PA2MFP_I2C1_SDA@GPA_MFPL', 'PSIO0_CH5:SYS_GPA_MFPL_PA2MFP_PSIO0_CH5@GPA_MFPL', 'USCI2_CLK:SYS_GPA_MFPL_PA2MFP_USCI2_CLK@GPA_MFPL', 'BPWM0_CH2:SYS_GPA_MFPL_PA2MFP_BPWM0_CH2@GPA_MFPL', 'PWM0_CH3:SYS_GPA_MFPL_PA2MFP_PWM0_CH3@GPA_MFPL'] },
	{ f: ['PA.3', 'GPIO:SYS_GPA_MFPL_PA3MFP_GPIO@GPA_MFPL', 'QSPI0_SS:SYS_GPA_MFPL_PA3MFP_QSPI0_SS@GPA_MFPL', 'SPI0_SS:SYS_GPA_MFPL_PA3MFP_SPI0_SS@GPA_MFPL', 'TK_TK3:SYS_GPA_MFPL_PA3MFP_TK_TK3@GPA_MFPL', 'SC0_PWR:SYS_GPA_MFPL_PA3MFP_SC0_PWR@GPA_MFPL', 'I2C0_SMBAL:SYS_GPA_MFPL_PA3MFP_I2C0_SMBAL@GPA_MFPL', 'UART1_TXD:SYS_GPA_MFPL_PA3MFP_UART1_TXD@GPA_MFPL', 'I2C1_SCL:SYS_GPA_MFPL_PA3MFP_I2C1_SCL@GPA_MFPL', 'PSIO0_CH4:SYS_GPA_MFPL_PA3MFP_PSIO0_CH4@GPA_MFPL', 'USCI2_CTL0:SYS_GPA_MFPL_PA3MFP_USCI2_CTL0@GPA_MFPL', 'BPWM0_CH3:SYS_GPA_MFPL_PA3MFP_BPWM0_CH3@GPA_MFPL', 'PWM0_CH2:SYS_GPA_MFPL_PA3MFP_PWM0_CH2@GPA_MFPL', 'CLKO:SYS_GPA_MFPL_PA3MFP_CLKO@GPA_MFPL', 'PWM1_BRAKE1:SYS_GPA_MFPL_PA3MFP_PWM1_BRAKE1@GPA_MFPL'] },
	{ f: ['PA.4', 'GPIO:SYS_GPA_MFPL_PA4MFP_GPIO@GPA_MFPL', 'QSPI0_MOSI1:SYS_GPA_MFPL_PA4MFP_QSPI0_MOSI1@GPA_MFPL', 'SPI0_I2SMCLK:SYS_GPA_MFPL_PA4MFP_SPI0_I2SMCLK@GPA_MFPL', 'TK_TK2:SYS_GPA_MFPL_PA4MFP_TK_TK2@GPA_MFPL', 'SC0_nCD:SYS_GPA_MFPL_PA4MFP_SC0_nCD@GPA_MFPL', 'UART0_nRTS:SYS_GPA_MFPL_PA4MFP_UART0_nRTS@GPA_MFPL', 'UART0_RXD:SYS_GPA_MFPL_PA4MFP_UART0_RXD@GPA_MFPL', 'I2C0_SDA:SYS_GPA_MFPL_PA4MFP_I2C0_SDA@GPA_MFPL', 'USCI2_CTL1:SYS_GPA_MFPL_PA4MFP_USCI2_CTL1@GPA_MFPL', 'BPWM0_CH4:SYS_GPA_MFPL_PA4MFP_BPWM0_CH4@GPA_MFPL', 'PWM0_CH1:SYS_GPA_MFPL_PA4MFP_PWM0_CH1@GPA_MFPL'] },
	{ f: ['PA.5', 'GPIO:SYS_GPA_MFPL_PA5MFP_GPIO@GPA_MFPL', 'QSPI0_MISO1:SYS_GPA_MFPL_PA5MFP_QSPI0_MISO1@GPA_MFPL', 'SPI1_I2SMCLK:SYS_GPA_MFPL_PA5MFP_SPI1_I2SMCLK@GPA_MFPL', 'TK_TK1:SYS_GPA_MFPL_PA5MFP_TK_TK1@GPA_MFPL', 'UART0_nCTS:SYS_GPA_MFPL_PA5MFP_UART0_nCTS@GPA_MFPL', 'UART0_TXD:SYS_GPA_MFPL_PA5MFP_UART0_TXD@GPA_MFPL', 'I2C0_SCL:SYS_GPA_MFPL_PA5MFP_I2C0_SCL@GPA_MFPL', 'BPWM0_CH5:SYS_GPA_MFPL_PA5MFP_BPWM0_CH5@GPA_MFPL', 'PWM0_CH0:SYS_GPA_MFPL_PA5MFP_PWM0_CH0@GPA_MFPL'] },
	{ f: ['PA.6', 'GPIO:SYS_GPA_MFPL_PA6MFP_GPIO@GPA_MFPL', 'EBI_AD6:SYS_GPA_MFPL_PA6MFP_EBI_AD6@GPA_MFPL', 'SPI1_SS:SYS_GPA_MFPL_PA6MFP_SPI1_SS@GPA_MFPL', 'LCD_SEG36:SYS_GPA_MFPL_PA6MFP_LCD_SEG36@GPA_MFPL', 'TK_TK20:SYS_GPA_MFPL_PA6MFP_TK_TK20@GPA_MFPL', 'UART0_RXD:SYS_GPA_MFPL_PA6MFP_UART0_RXD@GPA_MFPL', 'I2C1_SDA:SYS_GPA_MFPL_PA6MFP_I2C1_SDA@GPA_MFPL', 'PWM1_CH5:SYS_GPA_MFPL_PA6MFP_PWM1_CH5@GPA_MFPL', 'BPWM1_CH3:SYS_GPA_MFPL_PA6MFP_BPWM1_CH3@GPA_MFPL', 'ACMP1_WLAT:SYS_GPA_MFPL_PA6MFP_ACMP1_WLAT@GPA_MFPL', 'TM3:SYS_GPA_MFPL_PA6MFP_TM3@GPA_MFPL', 'INT0:SYS_GPA_MFPL_PA6MFP_INT0@GPA_MFPL'] },
	{ f: ['PA.7', 'GPIO:SYS_GPA_MFPL_PA7MFP_GPIO@GPA_MFPL', 'EBI_AD7:SYS_GPA_MFPL_PA7MFP_EBI_AD7@GPA_MFPL', 'SPI1_CLK:SYS_GPA_MFPL_PA7MFP_SPI1_CLK@GPA_MFPL', 'LCD_SEG37:SYS_GPA_MFPL_PA7MFP_LCD_SEG37@GPA_MFPL', 'TK_TK19:SYS_GPA_MFPL_PA7MFP_TK_TK19@GPA_MFPL', 'UART0_TXD:SYS_GPA_MFPL_PA7MFP_UART0_TXD@GPA_MFPL', 'I2C1_SCL:SYS_GPA_MFPL_PA7MFP_I2C1_SCL@GPA_MFPL', 'PWM1_CH4:SYS_GPA_MFPL_PA7MFP_PWM1_CH4@GPA_MFPL', 'BPWM1_CH2:SYS_GPA_MFPL_PA7MFP_BPWM1_CH2@GPA_MFPL', 'ACMP0_WLAT:SYS_GPA_MFPL_PA7MFP_ACMP0_WLAT@GPA_MFPL', 'TM2:SYS_GPA_MFPL_PA7MFP_TM2@GPA_MFPL', 'INT1:SYS_GPA_MFPL_PA7MFP_INT1@GPA_MFPL'] },
	{ f: ['PA.8', 'GPIO:SYS_GPA_MFPH_PA8MFP_GPIO@GPA_MFPH', 'EBI_ALE:SYS_GPA_MFPH_PA8MFP_EBI_ALE@GPA_MFPH', 'USCI0_CTL1:SYS_GPA_MFPH_PA8MFP_USCI0_CTL1@GPA_MFPH', 'UART1_RXD:SYS_GPA_MFPH_PA8MFP_UART1_RXD@GPA_MFPH', 'BPWM0_CH3:SYS_GPA_MFPH_PA8MFP_BPWM0_CH3@GPA_MFPH', 'TM3_EXT:SYS_GPA_MFPH_PA8MFP_TM3_EXT@GPA_MFPH', 'INT4:SYS_GPA_MFPH_PA8MFP_INT4@GPA_MFPH'] },
	{ f: ['PA.9', 'GPIO:SYS_GPA_MFPH_PA9MFP_GPIO@GPA_MFPH', 'EBI_MCLK:SYS_GPA_MFPH_PA9MFP_EBI_MCLK@GPA_MFPH', 'USCI0_DAT1:SYS_GPA_MFPH_PA9MFP_USCI0_DAT1@GPA_MFPH', 'UART1_TXD:SYS_GPA_MFPH_PA9MFP_UART1_TXD@GPA_MFPH', 'BPWM0_CH2:SYS_GPA_MFPH_PA9MFP_BPWM0_CH2@GPA_MFPH', 'TM2_EXT:SYS_GPA_MFPH_PA9MFP_TM2_EXT@GPA_MFPH', 'SWDH_DAT:SYS_GPA_MFPH_PA9MFP_SWDH_DAT@GPA_MFPH'] },
	{ f: ['PA.10', 'GPIO:SYS_GPA_MFPH_PA10MFP_GPIO@GPA_MFPH', 'ACMP1_P0:SYS_GPA_MFPH_PA10MFP_ACMP1_P0@GPA_MFPH', 'EBI_nWR:SYS_GPA_MFPH_PA10MFP_EBI_nWR@GPA_MFPH', 'USCI0_DAT0:SYS_GPA_MFPH_PA10MFP_USCI0_DAT0@GPA_MFPH', 'BPWM0_CH1:SYS_GPA_MFPH_PA10MFP_BPWM0_CH1@GPA_MFPH', 'TM1_EXT:SYS_GPA_MFPH_PA10MFP_TM1_EXT@GPA_MFPH', 'DAC0_ST:SYS_GPA_MFPH_PA10MFP_DAC0_ST@GPA_MFPH', 'SWDH_CLK:SYS_GPA_MFPH_PA10MFP_SWDH_CLK@GPA_MFPH'] },
	{ f: ['PA.11', 'GPIO:SYS_GPA_MFPH_PA11MFP_GPIO@GPA_MFPH', 'ACMP0_P0:SYS_GPA_MFPH_PA11MFP_ACMP0_P0@GPA_MFPH', 'EBI_nRD:SYS_GPA_MFPH_PA11MFP_EBI_nRD@GPA_MFPH', 'USCI0_CLK:SYS_GPA_MFPH_PA11MFP_USCI0_CLK@GPA_MFPH', 'BPWM0_CH0:SYS_GPA_MFPH_PA11MFP_BPWM0_CH0@GPA_MFPH', 'TM0_EXT:SYS_GPA_MFPH_PA11MFP_TM0_EXT@GPA_MFPH', 'DAC1_ST:SYS_GPA_MFPH_PA11MFP_DAC1_ST@GPA_MFPH'] },
	{ f: ['PA.12', 'GPIO:SYS_GPA_MFPH_PA12MFP_GPIO@GPA_MFPH', 'I2C1_SCL:SYS_GPA_MFPH_PA12MFP_I2C1_SCL@GPA_MFPH', 'LCD_COM4:SYS_GPA_MFPH_PA12MFP_LCD_COM4@GPA_MFPH', 'LCD_SEG20:SYS_GPA_MFPH_PA12MFP_LCD_SEG20@GPA_MFPH', 'LCD_SEG47:SYS_GPA_MFPH_PA12MFP_LCD_SEG47@GPA_MFPH', 'USCI2_DAT1:SYS_GPA_MFPH_PA12MFP_USCI2_DAT1@GPA_MFPH', 'PSIO0_CH4:SYS_GPA_MFPH_PA12MFP_PSIO0_CH4@GPA_MFPH', 'BPWM1_CH2:SYS_GPA_MFPH_PA12MFP_BPWM1_CH2@GPA_MFPH'] },
	{ f: ['PA.13', 'GPIO:SYS_GPA_MFPH_PA13MFP_GPIO@GPA_MFPH', 'I2C1_SDA:SYS_GPA_MFPH_PA13MFP_I2C1_SDA@GPA_MFPH', 'LCD_COM5:SYS_GPA_MFPH_PA13MFP_LCD_COM5@GPA_MFPH', 'LCD_SEG19:SYS_GPA_MFPH_PA13MFP_LCD_SEG19@GPA_MFPH', 'LCD_SEG46:SYS_GPA_MFPH_PA13MFP_LCD_SEG46@GPA_MFPH', 'USCI2_DAT0:SYS_GPA_MFPH_PA13MFP_USCI2_DAT0@GPA_MFPH', 'PSIO0_CH5:SYS_GPA_MFPH_PA13MFP_PSIO0_CH5@GPA_MFPH', 'BPWM1_CH3:SYS_GPA_MFPH_PA13MFP_BPWM1_CH3@GPA_MFPH'] },
	{ f: ['PA.14', 'GPIO:SYS_GPA_MFPH_PA14MFP_GPIO@GPA_MFPH', 'UART0_TXD:SYS_GPA_MFPH_PA14MFP_UART0_TXD@GPA_MFPH', 'LCD_COM6:SYS_GPA_MFPH_PA14MFP_LCD_COM6@GPA_MFPH', 'LCD_SEG18:SYS_GPA_MFPH_PA14MFP_LCD_SEG18@GPA_MFPH', 'LCD_SEG45:SYS_GPA_MFPH_PA14MFP_LCD_SEG45@GPA_MFPH', 'USCI2_CLK:SYS_GPA_MFPH_PA14MFP_USCI2_CLK@GPA_MFPH', 'PSIO0_CH6:SYS_GPA_MFPH_PA14MFP_PSIO0_CH6@GPA_MFPH', 'BPWM1_CH4:SYS_GPA_MFPH_PA14MFP_BPWM1_CH4@GPA_MFPH'] },
	{ f: ['PA.15', 'GPIO:SYS_GPA_MFPH_PA15MFP_GPIO@GPA_MFPH', 'UART0_RXD:SYS_GPA_MFPH_PA15MFP_UART0_RXD@GPA_MFPH', 'LCD_COM7:SYS_GPA_MFPH_PA15MFP_LCD_COM7@GPA_MFPH', 'LCD_SEG17:SYS_GPA_MFPH_PA15MFP_LCD_SEG17@GPA_MFPH', 'LCD_SEG44:SYS_GPA_MFPH_PA15MFP_LCD_SEG44@GPA_MFPH', 'USCI2_CTL1:SYS_GPA_MFPH_PA15MFP_USCI2_CTL1@GPA_MFPH', 'PSIO0_CH7:SYS_GPA_MFPH_PA15MFP_PSIO0_CH7@GPA_MFPH', 'BPWM1_CH5:SYS_GPA_MFPH_PA15MFP_BPWM1_CH5@GPA_MFPH'] },

	{ f: ['PB.0', 'GPIO:SYS_GPB_MFPL_PB0MFP_GPIO@GPB_MFPL', 'EADC0_CH0:SYS_GPB_MFPL_PB0MFP_EADC0_CH0@GPB_MFPL', 'OPA0_P:SYS_GPB_MFPL_PB0MFP_OPA0_P@GPB_MFPL', 'EBI_ADR9:SYS_GPB_MFPL_PB0MFP_EBI_ADR9@GPB_MFPL', 'LCD_SEG0:SYS_GPB_MFPL_PB0MFP_LCD_SEG0@GPB_MFPL', 'UART2_RXD:SYS_GPB_MFPL_PB0MFP_UART2_RXD@GPB_MFPL', 'SPI0_I2SMCLK:SYS_GPB_MFPL_PB0MFP_SPI0_I2SMCLK@GPB_MFPL', 'I2C1_SDA:SYS_GPB_MFPL_PB0MFP_I2C1_SDA@GPB_MFPL', 'QSPI0_MOSI1:SYS_GPB_MFPL_PB0MFP_QSPI0_MOSI1@GPB_MFPL', 'PWM0_CH5:SYS_GPB_MFPL_PB0MFP_PWM0_CH5@GPB_MFPL', 'PWM1_CH5:SYS_GPB_MFPL_PB0MFP_PWM1_CH5@GPB_MFPL', 'PWM0_BRAKE1:SYS_GPB_MFPL_PB0MFP_PWM0_BRAKE1@GPB_MFPL'] },
	{ f: ['PB.1', 'GPIO:SYS_GPB_MFPL_PB1MFP_GPIO@GPB_MFPL', 'EADC0_CH1:SYS_GPB_MFPL_PB1MFP_EADC0_CH1@GPB_MFPL', 'OPA0_N:SYS_GPB_MFPL_PB1MFP_OPA0_N@GPB_MFPL', 'EBI_ADR8:SYS_GPB_MFPL_PB1MFP_EBI_ADR8@GPB_MFPL', 'LCD_SEG1:SYS_GPB_MFPL_PB1MFP_LCD_SEG1@GPB_MFPL', 'SPI1_I2SMCLK:SYS_GPB_MFPL_PB1MFP_SPI1_I2SMCLK@GPB_MFPL', 'UART2_TXD:SYS_GPB_MFPL_PB1MFP_UART2_TXD@GPB_MFPL', 'USCI1_CLK:SYS_GPB_MFPL_PB1MFP_USCI1_CLK@GPB_MFPL', 'I2C1_SCL:SYS_GPB_MFPL_PB1MFP_I2C1_SCL@GPB_MFPL', 'QSPI0_MISO1:SYS_GPB_MFPL_PB1MFP_QSPI0_MISO1@GPB_MFPL', 'PWM0_CH4:SYS_GPB_MFPL_PB1MFP_PWM0_CH4@GPB_MFPL', 'PWM1_CH4:SYS_GPB_MFPL_PB1MFP_PWM1_CH4@GPB_MFPL', 'PWM0_BRAKE0:SYS_GPB_MFPL_PB1MFP_PWM0_BRAKE0@GPB_MFPL'] },
	{ f: ['PB.2', 'GPIO:SYS_GPB_MFPL_PB2MFP_GPIO@GPB_MFPL', 'EADC0_CH2:SYS_GPB_MFPL_PB2MFP_EADC0_CH2@GPB_MFPL', 'ACMP0_P1:SYS_GPB_MFPL_PB2MFP_ACMP0_P1@GPB_MFPL', 'OPA0_O:SYS_GPB_MFPL_PB2MFP_OPA0_O@GPB_MFPL', 'EBI_ADR3:SYS_GPB_MFPL_PB2MFP_EBI_ADR3@GPB_MFPL', 'I2C1_SDA:SYS_GPB_MFPL_PB2MFP_I2C1_SDA@GPB_MFPL', 'LCD_COM3:SYS_GPB_MFPL_PB2MFP_LCD_COM3@GPB_MFPL', 'UART1_RXD:SYS_GPB_MFPL_PB2MFP_UART1_RXD@GPB_MFPL', 'SPI1_SS:SYS_GPB_MFPL_PB2MFP_SPI1_SS@GPB_MFPL', 'USCI1_DAT0:SYS_GPB_MFPL_PB2MFP_USCI1_DAT0@GPB_MFPL', 'SC0_PWR:SYS_GPB_MFPL_PB2MFP_SC0_PWR@GPB_MFPL', 'PWM0_CH3:SYS_GPB_MFPL_PB2MFP_PWM0_CH3@GPB_MFPL', 'PSIO0_CH7:SYS_GPB_MFPL_PB2MFP_PSIO0_CH7@GPB_MFPL', 'TM3:SYS_GPB_MFPL_PB2MFP_TM3@GPB_MFPL', 'INT3:SYS_GPB_MFPL_PB2MFP_INT3@GPB_MFPL'] },
	{ f: ['PB.3', 'GPIO:SYS_GPB_MFPL_PB3MFP_GPIO@GPB_MFPL', 'EADC0_CH3:SYS_GPB_MFPL_PB3MFP_EADC0_CH3@GPB_MFPL', 'ACMP0_N:SYS_GPB_MFPL_PB3MFP_ACMP0_N@GPB_MFPL', 'EBI_ADR2:SYS_GPB_MFPL_PB3MFP_EBI_ADR2@GPB_MFPL', 'I2C1_SCL:SYS_GPB_MFPL_PB3MFP_I2C1_SCL@GPB_MFPL', 'LCD_COM2:SYS_GPB_MFPL_PB3MFP_LCD_COM2@GPB_MFPL', 'UART1_TXD:SYS_GPB_MFPL_PB3MFP_UART1_TXD@GPB_MFPL', 'SPI1_CLK:SYS_GPB_MFPL_PB3MFP_SPI1_CLK@GPB_MFPL', 'USCI1_DAT1:SYS_GPB_MFPL_PB3MFP_USCI1_DAT1@GPB_MFPL', 'SC0_RST:SYS_GPB_MFPL_PB3MFP_SC0_RST@GPB_MFPL', 'PWM0_CH2:SYS_GPB_MFPL_PB3MFP_PWM0_CH2@GPB_MFPL', 'PSIO0_CH6:SYS_GPB_MFPL_PB3MFP_PSIO0_CH6@GPB_MFPL', 'PWM0_BRAKE0:SYS_GPB_MFPL_PB3MFP_PWM0_BRAKE0@GPB_MFPL', 'TM2:SYS_GPB_MFPL_PB3MFP_TM2@GPB_MFPL', 'INT2:SYS_GPB_MFPL_PB3MFP_INT2@GPB_MFPL'] },
	{ f: ['PB.4', 'GPIO:SYS_GPB_MFPL_PB4MFP_GPIO@GPB_MFPL', 'EADC0_CH4:SYS_GPB_MFPL_PB4MFP_EADC0_CH4@GPB_MFPL', 'ACMP1_P1:SYS_GPB_MFPL_PB4MFP_ACMP1_P1@GPB_MFPL', 'EBI_ADR1:SYS_GPB_MFPL_PB4MFP_EBI_ADR1@GPB_MFPL', 'LCD_COM1:SYS_GPB_MFPL_PB4MFP_LCD_COM1@GPB_MFPL', 'I2C0_SDA:SYS_GPB_MFPL_PB4MFP_I2C0_SDA@GPB_MFPL', 'SPI1_MOSI:SYS_GPB_MFPL_PB4MFP_SPI1_MOSI@GPB_MFPL', 'USCI1_CTL1:SYS_GPB_MFPL_PB4MFP_USCI1_CTL1@GPB_MFPL', 'SC0_DAT:SYS_GPB_MFPL_PB4MFP_SC0_DAT@GPB_MFPL', 'PWM0_CH1:SYS_GPB_MFPL_PB4MFP_PWM0_CH1@GPB_MFPL', 'PSIO0_CH5:SYS_GPB_MFPL_PB4MFP_PSIO0_CH5@GPB_MFPL', 'UART2_RXD:SYS_GPB_MFPL_PB4MFP_UART2_RXD@GPB_MFPL', 'TM1:SYS_GPB_MFPL_PB4MFP_TM1@GPB_MFPL', 'INT1:SYS_GPB_MFPL_PB4MFP_INT1@GPB_MFPL'] },
	{ f: ['PB.5', 'GPIO:SYS_GPB_MFPL_PB5MFP_GPIO@GPB_MFPL', 'EADC0_CH5:SYS_GPB_MFPL_PB5MFP_EADC0_CH5@GPB_MFPL', 'ACMP1_N:SYS_GPB_MFPL_PB5MFP_ACMP1_N@GPB_MFPL', 'EBI_ADR0:SYS_GPB_MFPL_PB5MFP_EBI_ADR0@GPB_MFPL', 'LCD_COM0:SYS_GPB_MFPL_PB5MFP_LCD_COM0@GPB_MFPL', 'I2C0_SCL:SYS_GPB_MFPL_PB5MFP_I2C0_SCL@GPB_MFPL', 'SPI1_MISO:SYS_GPB_MFPL_PB5MFP_SPI1_MISO@GPB_MFPL', 'USCI1_CTL0:SYS_GPB_MFPL_PB5MFP_USCI1_CTL0@GPB_MFPL', 'SC0_CLK:SYS_GPB_MFPL_PB5MFP_SC0_CLK@GPB_MFPL', 'PWM0_CH0:SYS_GPB_MFPL_PB5MFP_PWM0_CH0@GPB_MFPL', 'PSIO0_CH4:SYS_GPB_MFPL_PB5MFP_PSIO0_CH4@GPB_MFPL', 'UART2_TXD:SYS_GPB_MFPL_PB5MFP_UART2_TXD@GPB_MFPL', 'TM0:SYS_GPB_MFPL_PB5MFP_TM0@GPB_MFPL', 'INT0:SYS_GPB_MFPL_PB5MFP_INT0@GPB_MFPL'] },
	{ f: ['PB.6', 'GPIO:SYS_GPB_MFPL_PB6MFP_GPIO@GPB_MFPL', 'EADC0_CH6:SYS_GPB_MFPL_PB6MFP_EADC0_CH6@GPB_MFPL', 'EBI_nWRH:SYS_GPB_MFPL_PB6MFP_EBI_nWRH@GPB_MFPL', 'USCI1_DAT1:SYS_GPB_MFPL_PB6MFP_USCI1_DAT1@GPB_MFPL', 'UART1_RXD:SYS_GPB_MFPL_PB6MFP_UART1_RXD@GPB_MFPL', 'EBI_nCS1:SYS_GPB_MFPL_PB6MFP_EBI_nCS1@GPB_MFPL', 'LCD_SEG4:SYS_GPB_MFPL_PB6MFP_LCD_SEG4@GPB_MFPL', 'BPWM1_CH5:SYS_GPB_MFPL_PB6MFP_BPWM1_CH5@GPB_MFPL', 'PWM1_BRAKE1:SYS_GPB_MFPL_PB6MFP_PWM1_BRAKE1@GPB_MFPL', 'PWM1_CH5:SYS_GPB_MFPL_PB6MFP_PWM1_CH5@GPB_MFPL', 'INT4:SYS_GPB_MFPL_PB6MFP_INT4@GPB_MFPL', 'ACMP1_O:SYS_GPB_MFPL_PB6MFP_ACMP1_O@GPB_MFPL'] },
	{ f: ['PB.7', 'GPIO:SYS_GPB_MFPL_PB7MFP_GPIO@GPB_MFPL', 'EADC0_CH7:SYS_GPB_MFPL_PB7MFP_EADC0_CH7@GPB_MFPL', 'EBI_nWRL:SYS_GPB_MFPL_PB7MFP_EBI_nWRL@GPB_MFPL', 'USCI1_DAT0:SYS_GPB_MFPL_PB7MFP_USCI1_DAT0@GPB_MFPL', 'UART1_TXD:SYS_GPB_MFPL_PB7MFP_UART1_TXD@GPB_MFPL', 'EBI_nCS0:SYS_GPB_MFPL_PB7MFP_EBI_nCS0@GPB_MFPL', 'LCD_SEG5:SYS_GPB_MFPL_PB7MFP_LCD_SEG5@GPB_MFPL', 'BPWM1_CH4:SYS_GPB_MFPL_PB7MFP_BPWM1_CH4@GPB_MFPL', 'PWM1_BRAKE0:SYS_GPB_MFPL_PB7MFP_PWM1_BRAKE0@GPB_MFPL', 'PWM1_CH4:SYS_GPB_MFPL_PB7MFP_PWM1_CH4@GPB_MFPL', 'INT5:SYS_GPB_MFPL_PB7MFP_INT5@GPB_MFPL', 'ACMP0_O:SYS_GPB_MFPL_PB7MFP_ACMP0_O@GPB_MFPL'] },
	{ f: ['PB.8', 'GPIO:SYS_GPB_MFPH_PB8MFP_GPIO@GPB_MFPH', 'EADC0_CH8:SYS_GPB_MFPH_PB8MFP_EADC0_CH8@GPB_MFPH', 'EBI_ADR19:SYS_GPB_MFPH_PB8MFP_EBI_ADR19@GPB_MFPH', 'USCI1_CLK:SYS_GPB_MFPH_PB8MFP_USCI1_CLK@GPB_MFPH', 'UART0_RXD:SYS_GPB_MFPH_PB8MFP_UART0_RXD@GPB_MFPH', 'UART1_nRTS:SYS_GPB_MFPH_PB8MFP_UART1_nRTS@GPB_MFPH', 'I2C1_SMBSUS:SYS_GPB_MFPH_PB8MFP_I2C1_SMBSUS@GPB_MFPH', 'LCD_SEG6:SYS_GPB_MFPH_PB8MFP_LCD_SEG6@GPB_MFPH', 'LCD_V3:SYS_GPB_MFPH_PB8MFP_LCD_V3@GPB_MFPH', 'BPWM1_CH3:SYS_GPB_MFPH_PB8MFP_BPWM1_CH3@GPB_MFPH'] },
	{ f: ['PB.9', 'GPIO:SYS_GPB_MFPH_PB9MFP_GPIO@GPB_MFPH', 'EADC0_CH9:SYS_GPB_MFPH_PB9MFP_EADC0_CH9@GPB_MFPH', 'EBI_ADR18:SYS_GPB_MFPH_PB9MFP_EBI_ADR18@GPB_MFPH', 'USCI1_CTL1:SYS_GPB_MFPH_PB9MFP_USCI1_CTL1@GPB_MFPH', 'UART0_TXD:SYS_GPB_MFPH_PB9MFP_UART0_TXD@GPB_MFPH', 'UART1_nCTS:SYS_GPB_MFPH_PB9MFP_UART1_nCTS@GPB_MFPH', 'I2C1_SMBAL:SYS_GPB_MFPH_PB9MFP_I2C1_SMBAL@GPB_MFPH', 'LCD_SEG7:SYS_GPB_MFPH_PB9MFP_LCD_SEG7@GPB_MFPH', 'LCD_V2:SYS_GPB_MFPH_PB9MFP_LCD_V2@GPB_MFPH', 'BPWM1_CH2:SYS_GPB_MFPH_PB9MFP_BPWM1_CH2@GPB_MFPH'] },
	{ f: ['PB.10', 'GPIO:SYS_GPB_MFPH_PB10MFP_GPIO@GPB_MFPH', 'EADC0_CH10:SYS_GPB_MFPH_PB10MFP_EADC0_CH10@GPB_MFPH', 'EBI_ADR17:SYS_GPB_MFPH_PB10MFP_EBI_ADR17@GPB_MFPH', 'USCI1_CTL0:SYS_GPB_MFPH_PB10MFP_USCI1_CTL0@GPB_MFPH', 'UART0_nRTS:SYS_GPB_MFPH_PB10MFP_UART0_nRTS@GPB_MFPH', 'I2C1_SDA:SYS_GPB_MFPH_PB10MFP_I2C1_SDA@GPB_MFPH', 'LCD_SEG8:SYS_GPB_MFPH_PB10MFP_LCD_SEG8@GPB_MFPH', 'LCD_V1:SYS_GPB_MFPH_PB10MFP_LCD_V1@GPB_MFPH', 'BPWM1_CH1:SYS_GPB_MFPH_PB10MFP_BPWM1_CH1@GPB_MFPH'] },
	{ f: ['PB.11', 'GPIO:SYS_GPB_MFPH_PB11MFP_GPIO@GPB_MFPH', 'EADC0_CH11:SYS_GPB_MFPH_PB11MFP_EADC0_CH11@GPB_MFPH', 'EBI_ADR16:SYS_GPB_MFPH_PB11MFP_EBI_ADR16@GPB_MFPH', 'UART0_nCTS:SYS_GPB_MFPH_PB11MFP_UART0_nCTS@GPB_MFPH', 'I2C1_SCL:SYS_GPB_MFPH_PB11MFP_I2C1_SCL@GPB_MFPH', 'LCD_SEG9:SYS_GPB_MFPH_PB11MFP_LCD_SEG9@GPB_MFPH', 'SPI0_I2SMCLK:SYS_GPB_MFPH_PB11MFP_SPI0_I2SMCLK@GPB_MFPH', 'BPWM1_CH0:SYS_GPB_MFPH_PB11MFP_BPWM1_CH0@GPB_MFPH'] },
	{ f: ['PB.12', 'GPIO:SYS_GPB_MFPH_PB12MFP_GPIO@GPB_MFPH', 'EADC0_CH12:SYS_GPB_MFPH_PB12MFP_EADC0_CH12@GPB_MFPH', 'DAC0_OUT:SYS_GPB_MFPH_PB12MFP_DAC0_OUT@GPB_MFPH', 'ACMP0_P2:SYS_GPB_MFPH_PB12MFP_ACMP0_P2@GPB_MFPH', 'ACMP1_P2:SYS_GPB_MFPH_PB12MFP_ACMP1_P2@GPB_MFPH', 'EBI_AD15:SYS_GPB_MFPH_PB12MFP_EBI_AD15@GPB_MFPH', 'SPI0_MOSI:SYS_GPB_MFPH_PB12MFP_SPI0_MOSI@GPB_MFPH', 'USCI0_CLK:SYS_GPB_MFPH_PB12MFP_USCI0_CLK@GPB_MFPH', 'UART0_RXD:SYS_GPB_MFPH_PB12MFP_UART0_RXD@GPB_MFPH', 'UART3_nCTS:SYS_GPB_MFPH_PB12MFP_UART3_nCTS@GPB_MFPH', 'LCD_SEG10:SYS_GPB_MFPH_PB12MFP_LCD_SEG10@GPB_MFPH', 'PSIO0_CH3:SYS_GPB_MFPH_PB12MFP_PSIO0_CH3@GPB_MFPH', 'PWM1_CH3:SYS_GPB_MFPH_PB12MFP_PWM1_CH3@GPB_MFPH', 'TM3_EXT:SYS_GPB_MFPH_PB12MFP_TM3_EXT@GPB_MFPH'] },
	{ f: ['PB.13', 'GPIO:SYS_GPB_MFPH_PB13MFP_GPIO@GPB_MFPH', 'EADC0_CH13:SYS_GPB_MFPH_PB13MFP_EADC0_CH13@GPB_MFPH', 'ACMP0_P3:SYS_GPB_MFPH_PB13MFP_ACMP0_P3@GPB_MFPH', 'ACMP1_P3:SYS_GPB_MFPH_PB13MFP_ACMP1_P3@GPB_MFPH', 'DAC1_OUT:SYS_GPB_MFPH_PB13MFP_DAC1_OUT@GPB_MFPH', 'EBI_AD14:SYS_GPB_MFPH_PB13MFP_EBI_AD14@GPB_MFPH', 'SPI0_MISO:SYS_GPB_MFPH_PB13MFP_SPI0_MISO@GPB_MFPH', 'USCI0_DAT0:SYS_GPB_MFPH_PB13MFP_USCI0_DAT0@GPB_MFPH', 'UART0_TXD:SYS_GPB_MFPH_PB13MFP_UART0_TXD@GPB_MFPH', 'UART3_nRTS:SYS_GPB_MFPH_PB13MFP_UART3_nRTS@GPB_MFPH', 'LCD_SEG11:SYS_GPB_MFPH_PB13MFP_LCD_SEG11@GPB_MFPH', 'PSIO0_CH2:SYS_GPB_MFPH_PB13MFP_PSIO0_CH2@GPB_MFPH', 'PWM1_CH2:SYS_GPB_MFPH_PB13MFP_PWM1_CH2@GPB_MFPH', 'TM2_EXT:SYS_GPB_MFPH_PB13MFP_TM2_EXT@GPB_MFPH'] },
	{ f: ['PB.14', 'GPIO:SYS_GPB_MFPH_PB14MFP_GPIO@GPB_MFPH', 'EADC0_CH14:SYS_GPB_MFPH_PB14MFP_EADC0_CH14@GPB_MFPH', 'EBI_AD13:SYS_GPB_MFPH_PB14MFP_EBI_AD13@GPB_MFPH', 'SPI0_CLK:SYS_GPB_MFPH_PB14MFP_SPI0_CLK@GPB_MFPH', 'USCI0_DAT1:SYS_GPB_MFPH_PB14MFP_USCI0_DAT1@GPB_MFPH', 'UART0_nRTS:SYS_GPB_MFPH_PB14MFP_UART0_nRTS@GPB_MFPH', 'UART3_RXD:SYS_GPB_MFPH_PB14MFP_UART3_RXD@GPB_MFPH', 'LCD_SEG12:SYS_GPB_MFPH_PB14MFP_LCD_SEG12@GPB_MFPH', 'PSIO0_CH1:SYS_GPB_MFPH_PB14MFP_PSIO0_CH1@GPB_MFPH', 'PWM1_CH1:SYS_GPB_MFPH_PB14MFP_PWM1_CH1@GPB_MFPH', 'TM1_EXT:SYS_GPB_MFPH_PB14MFP_TM1_EXT@GPB_MFPH', 'CLKO:SYS_GPB_MFPH_PB14MFP_CLKO@GPB_MFPH', 'TK_SE:SYS_GPB_MFPH_PB14MFP_TK_SE@GPB_MFPH'] },
	{ f: ['PB.15', 'GPIO:SYS_GPB_MFPH_PB15MFP_GPIO@GPB_MFPH', 'EADC0_CH15:SYS_GPB_MFPH_PB15MFP_EADC0_CH15@GPB_MFPH', 'EBI_AD12:SYS_GPB_MFPH_PB15MFP_EBI_AD12@GPB_MFPH', 'SPI0_SS:SYS_GPB_MFPH_PB15MFP_SPI0_SS@GPB_MFPH', 'USCI0_CTL1:SYS_GPB_MFPH_PB15MFP_USCI0_CTL1@GPB_MFPH', 'UART0_nCTS:SYS_GPB_MFPH_PB15MFP_UART0_nCTS@GPB_MFPH', 'UART3_TXD:SYS_GPB_MFPH_PB15MFP_UART3_TXD@GPB_MFPH', 'LCD_SEG13:SYS_GPB_MFPH_PB15MFP_LCD_SEG13@GPB_MFPH', 'LCD_COM1:SYS_GPB_MFPH_PB15MFP_LCD_COM1@GPB_MFPH', 'PSIO0_CH0:SYS_GPB_MFPH_PB15MFP_PSIO0_CH0@GPB_MFPH', 'PWM1_CH0:SYS_GPB_MFPH_PB15MFP_PWM1_CH0@GPB_MFPH', 'TM0_EXT:SYS_GPB_MFPH_PB15MFP_TM0_EXT@GPB_MFPH', 'PWM0_BRAKE1:SYS_GPB_MFPH_PB15MFP_PWM0_BRAKE1@GPB_MFPH'] },

	{ f: ['PC.0', 'GPIO:SYS_GPC_MFPL_PC0MFP_GPIO@GPC_MFPL', 'EBI_AD0:SYS_GPC_MFPL_PC0MFP_EBI_AD0@GPC_MFPL', 'QSPI0_MOSI0:SYS_GPC_MFPL_PC0MFP_QSPI0_MOSI0@GPC_MFPL', 'LCD_SEG26:SYS_GPC_MFPL_PC0MFP_LCD_SEG26@GPC_MFPL', 'LCD_COM3:SYS_GPC_MFPL_PC0MFP_LCD_COM3@GPC_MFPL', 'TK_TK25:SYS_GPC_MFPL_PC0MFP_TK_TK25@GPC_MFPL', 'SPI1_SS:SYS_GPC_MFPL_PC0MFP_SPI1_SS@GPC_MFPL', 'UART2_RXD:SYS_GPC_MFPL_PC0MFP_UART2_RXD@GPC_MFPL', 'I2C0_SDA:SYS_GPC_MFPL_PC0MFP_I2C0_SDA@GPC_MFPL', 'PWM1_CH5:SYS_GPC_MFPL_PC0MFP_PWM1_CH5@GPC_MFPL', 'USCI2_DAT1:SYS_GPC_MFPL_PC0MFP_USCI2_DAT1@GPC_MFPL', 'ACMP1_O:SYS_GPC_MFPL_PC0MFP_ACMP1_O@GPC_MFPL'] },
	{ f: ['PC.1', 'GPIO:SYS_GPC_MFPL_PC1MFP_GPIO@GPC_MFPL', 'EBI_AD1:SYS_GPC_MFPL_PC1MFP_EBI_AD1@GPC_MFPL', 'QSPI0_MISO0:SYS_GPC_MFPL_PC1MFP_QSPI0_MISO0@GPC_MFPL', 'LCD_SEG27:SYS_GPC_MFPL_PC1MFP_LCD_SEG27@GPC_MFPL', 'LCD_COM2:SYS_GPC_MFPL_PC1MFP_LCD_COM2@GPC_MFPL', 'TK_TK24:SYS_GPC_MFPL_PC1MFP_TK_TK24@GPC_MFPL', 'SPI1_CLK:SYS_GPC_MFPL_PC1MFP_SPI1_CLK@GPC_MFPL', 'UART2_TXD:SYS_GPC_MFPL_PC1MFP_UART2_TXD@GPC_MFPL', 'I2C0_SCL:SYS_GPC_MFPL_PC1MFP_I2C0_SCL@GPC_MFPL', 'PWM1_CH4:SYS_GPC_MFPL_PC1MFP_PWM1_CH4@GPC_MFPL', 'USCI2_DAT0:SYS_GPC_MFPL_PC1MFP_USCI2_DAT0@GPC_MFPL', 'ACMP0_O:SYS_GPC_MFPL_PC1MFP_ACMP0_O@GPC_MFPL'] },
	{ f: ['PC.2', 'GPIO:SYS_GPC_MFPL_PC2MFP_GPIO@GPC_MFPL', 'EBI_AD2:SYS_GPC_MFPL_PC2MFP_EBI_AD2@GPC_MFPL', 'QSPI0_CLK:SYS_GPC_MFPL_PC2MFP_QSPI0_CLK@GPC_MFPL', 'LCD_SEG28:SYS_GPC_MFPL_PC2MFP_LCD_SEG28@GPC_MFPL', 'LCD_COM7:SYS_GPC_MFPL_PC2MFP_LCD_COM7@GPC_MFPL', 'TK_TK12:SYS_GPC_MFPL_PC2MFP_TK_TK12@GPC_MFPL', 'SPI1_MOSI:SYS_GPC_MFPL_PC2MFP_SPI1_MOSI@GPC_MFPL', 'UART2_nCTS:SYS_GPC_MFPL_PC2MFP_UART2_nCTS@GPC_MFPL', 'I2C0_SMBSUS:SYS_GPC_MFPL_PC2MFP_I2C0_SMBSUS@GPC_MFPL', 'UART3_RXD:SYS_GPC_MFPL_PC2MFP_UART3_RXD@GPC_MFPL', 'PWM1_CH3:SYS_GPC_MFPL_PC2MFP_PWM1_CH3@GPC_MFPL', 'USCI2_CLK:SYS_GPC_MFPL_PC2MFP_USCI2_CLK@GPC_MFPL', 'PSIO0_CH3:SYS_GPC_MFPL_PC2MFP_PSIO0_CH3@GPC_MFPL'] },
	{ f: ['PC.3', 'GPIO:SYS_GPC_MFPL_PC3MFP_GPIO@GPC_MFPL', 'EBI_AD3:SYS_GPC_MFPL_PC3MFP_EBI_AD3@GPC_MFPL', 'QSPI0_SS:SYS_GPC_MFPL_PC3MFP_QSPI0_SS@GPC_MFPL', 'LCD_SEG29:SYS_GPC_MFPL_PC3MFP_LCD_SEG29@GPC_MFPL', 'LCD_COM6:SYS_GPC_MFPL_PC3MFP_LCD_COM6@GPC_MFPL', 'TK_TK11:SYS_GPC_MFPL_PC3MFP_TK_TK11@GPC_MFPL', 'SPI1_MISO:SYS_GPC_MFPL_PC3MFP_SPI1_MISO@GPC_MFPL', 'UART2_nRTS:SYS_GPC_MFPL_PC3MFP_UART2_nRTS@GPC_MFPL', 'I2C0_SMBAL:SYS_GPC_MFPL_PC3MFP_I2C0_SMBAL@GPC_MFPL', 'UART3_TXD:SYS_GPC_MFPL_PC3MFP_UART3_TXD@GPC_MFPL', 'PWM1_CH2:SYS_GPC_MFPL_PC3MFP_PWM1_CH2@GPC_MFPL', 'USCI2_CTL0:SYS_GPC_MFPL_PC3MFP_USCI2_CTL0@GPC_MFPL', 'PSIO0_CH2:SYS_GPC_MFPL_PC3MFP_PSIO0_CH2@GPC_MFPL'] },
	{ f: ['PC.4', 'GPIO:SYS_GPC_MFPL_PC4MFP_GPIO@GPC_MFPL', 'EBI_AD4:SYS_GPC_MFPL_PC4MFP_EBI_AD4@GPC_MFPL', 'QSPI0_MOSI1:SYS_GPC_MFPL_PC4MFP_QSPI0_MOSI1@GPC_MFPL', 'LCD_SEG30:SYS_GPC_MFPL_PC4MFP_LCD_SEG30@GPC_MFPL', 'LCD_COM5:SYS_GPC_MFPL_PC4MFP_LCD_COM5@GPC_MFPL', 'TK_TK10:SYS_GPC_MFPL_PC4MFP_TK_TK10@GPC_MFPL', 'SPI1_I2SMCLK:SYS_GPC_MFPL_PC4MFP_SPI1_I2SMCLK@GPC_MFPL', 'UART2_RXD:SYS_GPC_MFPL_PC4MFP_UART2_RXD@GPC_MFPL', 'I2C1_SDA:SYS_GPC_MFPL_PC4MFP_I2C1_SDA@GPC_MFPL', 'PWM1_CH1:SYS_GPC_MFPL_PC4MFP_PWM1_CH1@GPC_MFPL', 'USCI2_CTL1:SYS_GPC_MFPL_PC4MFP_USCI2_CTL1@GPC_MFPL', 'PSIO0_CH1:SYS_GPC_MFPL_PC4MFP_PSIO0_CH1@GPC_MFPL'] },
	{ f: ['PC.5', 'GPIO:SYS_GPC_MFPL_PC5MFP_GPIO@GPC_MFPL', 'EBI_AD5:SYS_GPC_MFPL_PC5MFP_EBI_AD5@GPC_MFPL', 'QSPI0_MISO1:SYS_GPC_MFPL_PC5MFP_QSPI0_MISO1@GPC_MFPL', 'LCD_SEG31:SYS_GPC_MFPL_PC5MFP_LCD_SEG31@GPC_MFPL', 'LCD_COM4:SYS_GPC_MFPL_PC5MFP_LCD_COM4@GPC_MFPL', 'TK_TK9:SYS_GPC_MFPL_PC5MFP_TK_TK9@GPC_MFPL', 'UART2_TXD:SYS_GPC_MFPL_PC5MFP_UART2_TXD@GPC_MFPL', 'I2C1_SCL:SYS_GPC_MFPL_PC5MFP_I2C1_SCL@GPC_MFPL', 'PWM1_CH0:SYS_GPC_MFPL_PC5MFP_PWM1_CH0@GPC_MFPL', 'PSIO0_CH0:SYS_GPC_MFPL_PC5MFP_PSIO0_CH0@GPC_MFPL'] },
	{ f: ['PC.6', 'GPIO:SYS_GPC_MFPL_PC6MFP_GPIO@GPC_MFPL', 'EBI_AD8:SYS_GPC_MFPL_PC6MFP_EBI_AD8@GPC_MFPL', 'SPI1_MOSI:SYS_GPC_MFPL_PC6MFP_SPI1_MOSI@GPC_MFPL', 'LCD_SEG38:SYS_GPC_MFPL_PC6MFP_LCD_SEG38@GPC_MFPL', 'TK_TK18:SYS_GPC_MFPL_PC6MFP_TK_TK18@GPC_MFPL', 'UART0_nRTS:SYS_GPC_MFPL_PC6MFP_UART0_nRTS@GPC_MFPL', 'I2C1_SMBSUS:SYS_GPC_MFPL_PC6MFP_I2C1_SMBSUS@GPC_MFPL', 'PWM1_CH3:SYS_GPC_MFPL_PC6MFP_PWM1_CH3@GPC_MFPL', 'BPWM1_CH1:SYS_GPC_MFPL_PC6MFP_BPWM1_CH1@GPC_MFPL', 'TM1:SYS_GPC_MFPL_PC6MFP_TM1@GPC_MFPL', 'INT2:SYS_GPC_MFPL_PC6MFP_INT2@GPC_MFPL'] },
	{ f: ['PC.7', 'GPIO:SYS_GPC_MFPL_PC7MFP_GPIO@GPC_MFPL', 'EBI_AD9:SYS_GPC_MFPL_PC7MFP_EBI_AD9@GPC_MFPL', 'SPI1_MISO:SYS_GPC_MFPL_PC7MFP_SPI1_MISO@GPC_MFPL', 'LCD_SEG39:SYS_GPC_MFPL_PC7MFP_LCD_SEG39@GPC_MFPL', 'TK_TK17:SYS_GPC_MFPL_PC7MFP_TK_TK17@GPC_MFPL', 'UART0_nCTS:SYS_GPC_MFPL_PC7MFP_UART0_nCTS@GPC_MFPL', 'I2C1_SMBAL:SYS_GPC_MFPL_PC7MFP_I2C1_SMBAL@GPC_MFPL', 'PWM1_CH2:SYS_GPC_MFPL_PC7MFP_PWM1_CH2@GPC_MFPL', 'BPWM1_CH0:SYS_GPC_MFPL_PC7MFP_BPWM1_CH0@GPC_MFPL', 'TM0:SYS_GPC_MFPL_PC7MFP_TM0@GPC_MFPL', 'INT3:SYS_GPC_MFPL_PC7MFP_INT3@GPC_MFPL'] },
	{ f: ['PC.8', 'GPIO:SYS_GPC_MFPH_PC8MFP_GPIO@GPC_MFPH', 'EBI_ADR16:SYS_GPC_MFPH_PC8MFP_EBI_ADR16@GPC_MFPH', 'I2C0_SDA:SYS_GPC_MFPH_PC8MFP_I2C0_SDA@GPC_MFPH', 'LCD_SEG40:SYS_GPC_MFPH_PC8MFP_LCD_SEG40@GPC_MFPH', 'LCD_COM7:SYS_GPC_MFPH_PC8MFP_LCD_COM7@GPC_MFPH', 'UART1_RXD:SYS_GPC_MFPH_PC8MFP_UART1_RXD@GPC_MFPH', 'PWM1_CH1:SYS_GPC_MFPH_PC8MFP_PWM1_CH1@GPC_MFPH', 'BPWM1_CH4:SYS_GPC_MFPH_PC8MFP_BPWM1_CH4@GPC_MFPH'] },
	{ f: ['PC.9', 'GPIO:SYS_GPC_MFPH_PC9MFP_GPIO@GPC_MFPH', 'EBI_ADR7:SYS_GPC_MFPH_PC9MFP_EBI_ADR7@GPC_MFPH', 'LCD_SEG2:SYS_GPC_MFPH_PC9MFP_LCD_SEG2@GPC_MFPH', 'UART3_RXD:SYS_GPC_MFPH_PC9MFP_UART3_RXD@GPC_MFPH', 'PWM1_CH3:SYS_GPC_MFPH_PC9MFP_PWM1_CH3@GPC_MFPH'] },
	{ f: ['PC.10', 'GPIO:SYS_GPC_MFPH_PC10MFP_GPIO@GPC_MFPH', 'EBI_ADR6:SYS_GPC_MFPH_PC10MFP_EBI_ADR6@GPC_MFPH', 'LCD_SEG3:SYS_GPC_MFPH_PC10MFP_LCD_SEG3@GPC_MFPH', 'UART3_TXD:SYS_GPC_MFPH_PC10MFP_UART3_TXD@GPC_MFPH', 'PWM1_CH2:SYS_GPC_MFPH_PC10MFP_PWM1_CH2@GPC_MFPH'] },
	{ f: ['PC.11', 'GPIO:SYS_GPC_MFPH_PC11MFP_GPIO@GPC_MFPH', 'EBI_ADR5:SYS_GPC_MFPH_PC11MFP_EBI_ADR5@GPC_MFPH', 'UART0_RXD:SYS_GPC_MFPH_PC11MFP_UART0_RXD@GPC_MFPH', 'I2C0_SDA:SYS_GPC_MFPH_PC11MFP_I2C0_SDA@GPC_MFPH', 'PWM1_CH1:SYS_GPC_MFPH_PC11MFP_PWM1_CH1@GPC_MFPH', 'ACMP1_O:SYS_GPC_MFPH_PC11MFP_ACMP1_O@GPC_MFPH'] },
	{ f: ['PC.12', 'GPIO:SYS_GPC_MFPH_PC12MFP_GPIO@GPC_MFPH', 'EBI_ADR4:SYS_GPC_MFPH_PC12MFP_EBI_ADR4@GPC_MFPH', 'UART0_TXD:SYS_GPC_MFPH_PC12MFP_UART0_TXD@GPC_MFPH', 'I2C0_SCL:SYS_GPC_MFPH_PC12MFP_I2C0_SCL@GPC_MFPH', 'SC0_nCD:SYS_GPC_MFPH_PC12MFP_SC0_nCD@GPC_MFPH', 'PWM1_CH0:SYS_GPC_MFPH_PC12MFP_PWM1_CH0@GPC_MFPH', 'ACMP0_O:SYS_GPC_MFPH_PC12MFP_ACMP0_O@GPC_MFPH'] },
	{ f: ['PC.13', 'GPIO:SYS_GPC_MFPH_PC13MFP_GPIO@GPC_MFPH'] },
	{ f: ['PC.14', 'GPIO:SYS_GPC_MFPH_PC14MFP_GPIO@GPC_MFPH', 'EBI_AD11:SYS_GPC_MFPH_PC14MFP_EBI_AD11@GPC_MFPH', 'SPI0_I2SMCLK:SYS_GPC_MFPH_PC14MFP_SPI0_I2SMCLK@GPC_MFPH', 'USCI0_CTL0:SYS_GPC_MFPH_PC14MFP_USCI0_CTL0@GPC_MFPH', 'QSPI0_CLK:SYS_GPC_MFPH_PC14MFP_QSPI0_CLK@GPC_MFPH', 'USCI2_CLK:SYS_GPC_MFPH_PC14MFP_USCI2_CLK@GPC_MFPH', 'LCD_SEG14:SYS_GPC_MFPH_PC14MFP_LCD_SEG14@GPC_MFPH', 'LCD_COM0:SYS_GPC_MFPH_PC14MFP_LCD_COM0@GPC_MFPH', 'TM1:SYS_GPC_MFPH_PC14MFP_TM1@GPC_MFPH'] },
		{ f: ['PC.15', 'GPIO:SYS_GPC_MFPH_PC15MFP_GPIO@GPC_MFPH'] },

	{ f: ['PD.0', 'GPIO:SYS_GPD_MFPL_PD0MFP_GPIO@GPD_MFPL', 'EBI_AD13:SYS_GPD_MFPL_PD0MFP_EBI_AD13@GPD_MFPL', 'USCI0_CLK:SYS_GPD_MFPL_PD0MFP_USCI0_CLK@GPD_MFPL', 'SPI0_MOSI:SYS_GPD_MFPL_PD0MFP_SPI0_MOSI@GPD_MFPL', 'LCD_SEG22:SYS_GPD_MFPL_PD0MFP_LCD_SEG22@GPD_MFPL', 'TK_TK16:SYS_GPD_MFPL_PD0MFP_TK_TK16@GPD_MFPL', 'UART3_RXD:SYS_GPD_MFPL_PD0MFP_UART3_RXD@GPD_MFPL', 'TM2:SYS_GPD_MFPL_PD0MFP_TM2@GPD_MFPL'] },
	{ f: ['PD.1', 'GPIO:SYS_GPD_MFPL_PD1MFP_GPIO@GPD_MFPL', 'EBI_AD12:SYS_GPD_MFPL_PD1MFP_EBI_AD12@GPD_MFPL', 'USCI0_DAT0:SYS_GPD_MFPL_PD1MFP_USCI0_DAT0@GPD_MFPL', 'SPI0_MISO:SYS_GPD_MFPL_PD1MFP_SPI0_MISO@GPD_MFPL', 'LCD_SEG23:SYS_GPD_MFPL_PD1MFP_LCD_SEG23@GPD_MFPL', 'TK_TK15:SYS_GPD_MFPL_PD1MFP_TK_TK15@GPD_MFPL', 'UART3_TXD:SYS_GPD_MFPL_PD1MFP_UART3_TXD@GPD_MFPL'] },
	{ f: ['PD.2', 'GPIO:SYS_GPD_MFPL_PD2MFP_GPIO@GPD_MFPL', 'EBI_AD11:SYS_GPD_MFPL_PD2MFP_EBI_AD11@GPD_MFPL', 'USCI0_DAT1:SYS_GPD_MFPL_PD2MFP_USCI0_DAT1@GPD_MFPL', 'SPI0_CLK:SYS_GPD_MFPL_PD2MFP_SPI0_CLK@GPD_MFPL', 'LCD_SEG24:SYS_GPD_MFPL_PD2MFP_LCD_SEG24@GPD_MFPL', 'TK_TK14:SYS_GPD_MFPL_PD2MFP_TK_TK14@GPD_MFPL', 'UART0_RXD:SYS_GPD_MFPL_PD2MFP_UART0_RXD@GPD_MFPL', 'UART3_nCTS:SYS_GPD_MFPL_PD2MFP_UART3_nCTS@GPD_MFPL'] },
	{ f: ['PD.3', 'GPIO:SYS_GPD_MFPL_PD3MFP_GPIO@GPD_MFPL', 'EBI_AD10:SYS_GPD_MFPL_PD3MFP_EBI_AD10@GPD_MFPL', 'USCI0_CTL1:SYS_GPD_MFPL_PD3MFP_USCI0_CTL1@GPD_MFPL', 'SPI0_SS:SYS_GPD_MFPL_PD3MFP_SPI0_SS@GPD_MFPL', 'LCD_SEG25:SYS_GPD_MFPL_PD3MFP_LCD_SEG25@GPD_MFPL', 'USCI1_CTL0:SYS_GPD_MFPL_PD3MFP_USCI1_CTL0@GPD_MFPL', 'TK_TK13:SYS_GPD_MFPL_PD3MFP_TK_TK13@GPD_MFPL', 'UART0_TXD:SYS_GPD_MFPL_PD3MFP_UART0_TXD@GPD_MFPL', 'UART3_nRTS:SYS_GPD_MFPL_PD3MFP_UART3_nRTS@GPD_MFPL'] },
	{ f: ['PD.4', 'GPIO:SYS_GPD_MFPL_PD4MFP_GPIO@GPD_MFPL', 'USCI0_CTL0:SYS_GPD_MFPL_PD4MFP_USCI0_CTL0@GPD_MFPL', 'I2C1_SDA:SYS_GPD_MFPL_PD4MFP_I2C1_SDA@GPD_MFPL', 'USCI1_CTL1:SYS_GPD_MFPL_PD4MFP_USCI1_CTL1@GPD_MFPL', 'TK_TK16:SYS_GPD_MFPL_PD4MFP_TK_TK16@GPD_MFPL', 'SPI1_SS:SYS_GPD_MFPL_PD4MFP_SPI1_SS@GPD_MFPL', 'PSIO0_CH7:SYS_GPD_MFPL_PD4MFP_PSIO0_CH7@GPD_MFPL'] },
	{ f: ['PD.5', 'GPIO:SYS_GPD_MFPL_PD5MFP_GPIO@GPD_MFPL', 'I2C1_SCL:SYS_GPD_MFPL_PD5MFP_I2C1_SCL@GPD_MFPL', 'USCI1_DAT0:SYS_GPD_MFPL_PD5MFP_USCI1_DAT0@GPD_MFPL', 'TK_TK15:SYS_GPD_MFPL_PD5MFP_TK_TK15@GPD_MFPL', 'SPI1_CLK:SYS_GPD_MFPL_PD5MFP_SPI1_CLK@GPD_MFPL', 'PSIO0_CH6:SYS_GPD_MFPL_PD5MFP_PSIO0_CH6@GPD_MFPL'] },
	{ f: ['PD.6', 'GPIO:SYS_GPD_MFPL_PD6MFP_GPIO@GPD_MFPL', 'UART1_RXD:SYS_GPD_MFPL_PD6MFP_UART1_RXD@GPD_MFPL', 'I2C0_SDA:SYS_GPD_MFPL_PD6MFP_I2C0_SDA@GPD_MFPL', 'USCI1_DAT1:SYS_GPD_MFPL_PD6MFP_USCI1_DAT1@GPD_MFPL', 'TK_TK14:SYS_GPD_MFPL_PD6MFP_TK_TK14@GPD_MFPL', 'SPI1_MOSI:SYS_GPD_MFPL_PD6MFP_SPI1_MOSI@GPD_MFPL', 'PSIO0_CH5:SYS_GPD_MFPL_PD6MFP_PSIO0_CH5@GPD_MFPL'] },
	{ f: ['PD.7', 'GPIO:SYS_GPD_MFPL_PD7MFP_GPIO@GPD_MFPL', 'UART1_TXD:SYS_GPD_MFPL_PD7MFP_UART1_TXD@GPD_MFPL', 'I2C0_SCL:SYS_GPD_MFPL_PD7MFP_I2C0_SCL@GPD_MFPL', 'USCI1_CLK:SYS_GPD_MFPL_PD7MFP_USCI1_CLK@GPD_MFPL', 'TK_TK13:SYS_GPD_MFPL_PD7MFP_TK_TK13@GPD_MFPL', 'SPI1_MISO:SYS_GPD_MFPL_PD7MFP_SPI1_MISO@GPD_MFPL', 'PSIO0_CH4:SYS_GPD_MFPL_PD7MFP_PSIO0_CH4@GPD_MFPL'] },
	{ f: ['PD.8', 'GPIO:SYS_GPD_MFPH_PD8MFP_GPIO@GPD_MFPH', 'EBI_AD6:SYS_GPD_MFPH_PD8MFP_EBI_AD6@GPD_MFPH', 'UART2_nRTS:SYS_GPD_MFPH_PD8MFP_UART2_nRTS@GPD_MFPH', 'LCD_SEG32:SYS_GPD_MFPH_PD8MFP_LCD_SEG32@GPD_MFPH', 'TK_TK23:SYS_GPD_MFPH_PD8MFP_TK_TK23@GPD_MFPH', 'PSIO0_CH3:SYS_GPD_MFPH_PD8MFP_PSIO0_CH3@GPD_MFPH'] },
	{ f: ['PD.9', 'GPIO:SYS_GPD_MFPH_PD9MFP_GPIO@GPD_MFPH', 'EBI_AD7:SYS_GPD_MFPH_PD9MFP_EBI_AD7@GPD_MFPH', 'UART2_nCTS:SYS_GPD_MFPH_PD9MFP_UART2_nCTS@GPD_MFPH', 'LCD_SEG33:SYS_GPD_MFPH_PD9MFP_LCD_SEG33@GPD_MFPH', 'TK_TK22:SYS_GPD_MFPH_PD9MFP_TK_TK22@GPD_MFPH', 'PSIO0_CH2:SYS_GPD_MFPH_PD9MFP_PSIO0_CH2@GPD_MFPH'] },
	{ f: ['PD.10', 'GPIO:SYS_GPD_MFPH_PD10MFP_GPIO@GPD_MFPH', 'EBI_nCS2:SYS_GPD_MFPH_PD10MFP_EBI_nCS2@GPD_MFPH', 'UART1_RXD:SYS_GPD_MFPH_PD10MFP_UART1_RXD@GPD_MFPH', 'LCD_SEG42:SYS_GPD_MFPH_PD10MFP_LCD_SEG42@GPD_MFPH', 'LCD_COM5:SYS_GPD_MFPH_PD10MFP_LCD_COM5@GPD_MFPH'] },
	{ f: ['PD.11', 'GPIO:SYS_GPD_MFPH_PD11MFP_GPIO@GPD_MFPH', 'EBI_nCS1:SYS_GPD_MFPH_PD11MFP_EBI_nCS1@GPD_MFPH', 'UART1_TXD:SYS_GPD_MFPH_PD11MFP_UART1_TXD@GPD_MFPH', 'LCD_SEG43:SYS_GPD_MFPH_PD11MFP_LCD_SEG43@GPD_MFPH', 'LCD_COM4:SYS_GPD_MFPH_PD11MFP_LCD_COM4@GPD_MFPH'] },
	{ f: ['PD.12', 'GPIO:SYS_GPD_MFPH_PD12MFP_GPIO@GPD_MFPH', 'EBI_nCS0:SYS_GPD_MFPH_PD12MFP_EBI_nCS0@GPD_MFPH', 'UART2_RXD:SYS_GPD_MFPH_PD12MFP_UART2_RXD@GPD_MFPH', 'BPWM0_CH5:SYS_GPD_MFPH_PD12MFP_BPWM0_CH5@GPD_MFPH', 'TK_SE:SYS_GPD_MFPH_PD12MFP_TK_SE@GPD_MFPH', 'CLKO:SYS_GPD_MFPH_PD12MFP_CLKO@GPD_MFPH', 'EADC0_ST:SYS_GPD_MFPH_PD12MFP_EADC0_ST@GPD_MFPH', 'INT5:SYS_GPD_MFPH_PD12MFP_INT5@GPD_MFPH'] },
	{ f: ['PD.13', 'GPIO:SYS_GPD_MFPH_PD13MFP_GPIO@GPD_MFPH', 'EBI_AD10:SYS_GPD_MFPH_PD13MFP_EBI_AD10@GPD_MFPH', 'SPI1_I2SMCLK:SYS_GPD_MFPH_PD13MFP_SPI1_I2SMCLK@GPD_MFPH', 'SPI0_I2SMCLK:SYS_GPD_MFPH_PD13MFP_SPI0_I2SMCLK@GPD_MFPH', 'LCD_SEG21:SYS_GPD_MFPH_PD13MFP_LCD_SEG21@GPD_MFPH', 'USCI2_CTL0:SYS_GPD_MFPH_PD13MFP_USCI2_CTL0@GPD_MFPH'] },
	{ f: ['PD.14', 'GPIO:SYS_GPD_MFPH_PD14MFP_GPIO@GPD_MFPH'] },
	{ f: ['PD.15', 'GPIO:SYS_GPD_MFPH_PD15MFP_GPIO@GPD_MFPH', 'TK_TK0:SYS_GPD_MFPH_PD15MFP_TK_TK0@GPD_MFPH', 'PSIO0_CH7:SYS_GPD_MFPH_PD15MFP_PSIO0_CH7@GPD_MFPH', 'PWM0_CH5:SYS_GPD_MFPH_PD15MFP_PWM0_CH5@GPD_MFPH', 'TM3:SYS_GPD_MFPH_PD15MFP_TM3@GPD_MFPH', 'INT1:SYS_GPD_MFPH_PD15MFP_INT1@GPD_MFPH'] },

	{ f: ['PE.0', 'GPIO:SYS_GPE_MFPL_PE0MFP_GPIO@GPE_MFPL', 'EBI_AD11:SYS_GPE_MFPL_PE0MFP_EBI_AD11@GPE_MFPL', 'QSPI0_MOSI0:SYS_GPE_MFPL_PE0MFP_QSPI0_MOSI0@GPE_MFPL', 'SPI1_MOSI:SYS_GPE_MFPL_PE0MFP_SPI1_MOSI@GPE_MFPL', 'UART3_RXD:SYS_GPE_MFPL_PE0MFP_UART3_RXD@GPE_MFPL', 'I2C1_SDA:SYS_GPE_MFPL_PE0MFP_I2C1_SDA@GPE_MFPL', 'USCI2_DAT0:SYS_GPE_MFPL_PE0MFP_USCI2_DAT0@GPE_MFPL'] },
	{ f: ['PE.1', 'GPIO:SYS_GPE_MFPL_PE1MFP_GPIO@GPE_MFPL', 'EBI_AD10:SYS_GPE_MFPL_PE1MFP_EBI_AD10@GPE_MFPL', 'QSPI0_MISO0:SYS_GPE_MFPL_PE1MFP_QSPI0_MISO0@GPE_MFPL', 'SPI1_MISO:SYS_GPE_MFPL_PE1MFP_SPI1_MISO@GPE_MFPL', 'UART3_TXD:SYS_GPE_MFPL_PE1MFP_UART3_TXD@GPE_MFPL', 'I2C1_SCL:SYS_GPE_MFPL_PE1MFP_I2C1_SCL@GPE_MFPL', 'USCI2_DAT1:SYS_GPE_MFPL_PE1MFP_USCI2_DAT1@GPE_MFPL'] },
	{ f: ['PE.2', 'GPIO:SYS_GPE_MFPL_PE2MFP_GPIO@GPE_MFPL', 'EBI_ALE:SYS_GPE_MFPL_PE2MFP_EBI_ALE@GPE_MFPL', 'SC0_CLK:SYS_GPE_MFPL_PE2MFP_SC0_CLK@GPE_MFPL', 'USCI0_CLK:SYS_GPE_MFPL_PE2MFP_USCI0_CLK@GPE_MFPL', 'USCI2_CTL0:SYS_GPE_MFPL_PE2MFP_USCI2_CTL0@GPE_MFPL', 'PWM0_CH5:SYS_GPE_MFPL_PE2MFP_PWM0_CH5@GPE_MFPL', 'BPWM0_CH0:SYS_GPE_MFPL_PE2MFP_BPWM0_CH0@GPE_MFPL'] },
	{ f: ['PE.3', 'GPIO:SYS_GPE_MFPL_PE3MFP_GPIO@GPE_MFPL', 'EBI_MCLK:SYS_GPE_MFPL_PE3MFP_EBI_MCLK@GPE_MFPL', 'SC0_DAT:SYS_GPE_MFPL_PE3MFP_SC0_DAT@GPE_MFPL', 'USCI0_DAT0:SYS_GPE_MFPL_PE3MFP_USCI0_DAT0@GPE_MFPL', 'PWM0_CH4:SYS_GPE_MFPL_PE3MFP_PWM0_CH4@GPE_MFPL', 'BPWM0_CH1:SYS_GPE_MFPL_PE3MFP_BPWM0_CH1@GPE_MFPL'] },
	{ f: ['PE.4', 'GPIO:SYS_GPE_MFPL_PE4MFP_GPIO@GPE_MFPL', 'EBI_nWR:SYS_GPE_MFPL_PE4MFP_EBI_nWR@GPE_MFPL', 'SC0_RST:SYS_GPE_MFPL_PE4MFP_SC0_RST@GPE_MFPL', 'USCI0_DAT1:SYS_GPE_MFPL_PE4MFP_USCI0_DAT1@GPE_MFPL', 'PSIO0_CH3:SYS_GPE_MFPL_PE4MFP_PSIO0_CH3@GPE_MFPL', 'PWM0_CH3:SYS_GPE_MFPL_PE4MFP_PWM0_CH3@GPE_MFPL', 'BPWM0_CH2:SYS_GPE_MFPL_PE4MFP_BPWM0_CH2@GPE_MFPL'] },
	{ f: ['PE.5', 'GPIO:SYS_GPE_MFPL_PE5MFP_GPIO@GPE_MFPL', 'EBI_nRD:SYS_GPE_MFPL_PE5MFP_EBI_nRD@GPE_MFPL', 'SC0_PWR:SYS_GPE_MFPL_PE5MFP_SC0_PWR@GPE_MFPL', 'USCI0_CTL1:SYS_GPE_MFPL_PE5MFP_USCI0_CTL1@GPE_MFPL', 'PSIO0_CH2:SYS_GPE_MFPL_PE5MFP_PSIO0_CH2@GPE_MFPL', 'PWM0_CH2:SYS_GPE_MFPL_PE5MFP_PWM0_CH2@GPE_MFPL', 'BPWM0_CH3:SYS_GPE_MFPL_PE5MFP_BPWM0_CH3@GPE_MFPL'] },
	{ f: ['PE.6', 'GPIO:SYS_GPE_MFPL_PE6MFP_GPIO@GPE_MFPL', 'LCD_SEG15:SYS_GPE_MFPL_PE6MFP_LCD_SEG15@GPE_MFPL', 'SC0_nCD:SYS_GPE_MFPL_PE6MFP_SC0_nCD@GPE_MFPL', 'USCI0_CTL0:SYS_GPE_MFPL_PE6MFP_USCI0_CTL0@GPE_MFPL', 'PSIO0_CH1:SYS_GPE_MFPL_PE6MFP_PSIO0_CH1@GPE_MFPL', 'PWM0_CH1:SYS_GPE_MFPL_PE6MFP_PWM0_CH1@GPE_MFPL', 'BPWM0_CH4:SYS_GPE_MFPL_PE6MFP_BPWM0_CH4@GPE_MFPL'] },
	{ f: ['PE.7', 'GPIO:SYS_GPE_MFPL_PE7MFP_GPIO@GPE_MFPL', 'LCD_SEG16:SYS_GPE_MFPL_PE7MFP_LCD_SEG16@GPE_MFPL', 'PSIO0_CH0:SYS_GPE_MFPL_PE7MFP_PSIO0_CH0@GPE_MFPL', 'PWM0_CH0:SYS_GPE_MFPL_PE7MFP_PWM0_CH0@GPE_MFPL', 'BPWM0_CH5:SYS_GPE_MFPL_PE7MFP_BPWM0_CH5@GPE_MFPL'] },
	{ f: ['PE.8', 'GPIO:SYS_GPE_MFPH_PE8MFP_GPIO@GPE_MFPH', 'EBI_ADR10:SYS_GPE_MFPH_PE8MFP_EBI_ADR10@GPE_MFPH', 'LCD_SEG20:SYS_GPE_MFPH_PE8MFP_LCD_SEG20@GPE_MFPH', 'LCD_COM0:SYS_GPE_MFPH_PE8MFP_LCD_COM0@GPE_MFPH', 'USCI1_CTL1:SYS_GPE_MFPH_PE8MFP_USCI1_CTL1@GPE_MFPH', 'UART2_TXD:SYS_GPE_MFPH_PE8MFP_UART2_TXD@GPE_MFPH', 'PWM0_CH0:SYS_GPE_MFPH_PE8MFP_PWM0_CH0@GPE_MFPH', 'PWM0_BRAKE0:SYS_GPE_MFPH_PE8MFP_PWM0_BRAKE0@GPE_MFPH'] },
	{ f: ['PE.9', 'GPIO:SYS_GPE_MFPH_PE9MFP_GPIO@GPE_MFPH', 'EBI_ADR11:SYS_GPE_MFPH_PE9MFP_EBI_ADR11@GPE_MFPH', 'LCD_SEG19:SYS_GPE_MFPH_PE9MFP_LCD_SEG19@GPE_MFPH', 'LCD_COM1:SYS_GPE_MFPH_PE9MFP_LCD_COM1@GPE_MFPH', 'USCI1_CTL0:SYS_GPE_MFPH_PE9MFP_USCI1_CTL0@GPE_MFPH', 'UART2_RXD:SYS_GPE_MFPH_PE9MFP_UART2_RXD@GPE_MFPH', 'PWM0_CH1:SYS_GPE_MFPH_PE9MFP_PWM0_CH1@GPE_MFPH', 'PWM0_BRAKE1:SYS_GPE_MFPH_PE9MFP_PWM0_BRAKE1@GPE_MFPH'] },
	{ f: ['PE.10', 'GPIO:SYS_GPE_MFPH_PE10MFP_GPIO@GPE_MFPH', 'EBI_ADR12:SYS_GPE_MFPH_PE10MFP_EBI_ADR12@GPE_MFPH', 'LCD_SEG18:SYS_GPE_MFPH_PE10MFP_LCD_SEG18@GPE_MFPH', 'LCD_COM2:SYS_GPE_MFPH_PE10MFP_LCD_COM2@GPE_MFPH', 'USCI1_DAT0:SYS_GPE_MFPH_PE10MFP_USCI1_DAT0@GPE_MFPH', 'UART3_TXD:SYS_GPE_MFPH_PE10MFP_UART3_TXD@GPE_MFPH', 'PWM0_CH2:SYS_GPE_MFPH_PE10MFP_PWM0_CH2@GPE_MFPH', 'PWM1_BRAKE0:SYS_GPE_MFPH_PE10MFP_PWM1_BRAKE0@GPE_MFPH'] },
	{ f: ['PE.11', 'GPIO:SYS_GPE_MFPH_PE11MFP_GPIO@GPE_MFPH', 'EBI_ADR13:SYS_GPE_MFPH_PE11MFP_EBI_ADR13@GPE_MFPH', 'LCD_SEG17:SYS_GPE_MFPH_PE11MFP_LCD_SEG17@GPE_MFPH', 'LCD_COM3:SYS_GPE_MFPH_PE11MFP_LCD_COM3@GPE_MFPH', 'USCI1_DAT1:SYS_GPE_MFPH_PE11MFP_USCI1_DAT1@GPE_MFPH', 'UART3_RXD:SYS_GPE_MFPH_PE11MFP_UART3_RXD@GPE_MFPH', 'UART1_nCTS:SYS_GPE_MFPH_PE11MFP_UART1_nCTS@GPE_MFPH', 'PWM0_CH3:SYS_GPE_MFPH_PE11MFP_PWM0_CH3@GPE_MFPH', 'PWM1_BRAKE1:SYS_GPE_MFPH_PE11MFP_PWM1_BRAKE1@GPE_MFPH'] },
	{ f: ['PE.12', 'GPIO:SYS_GPE_MFPH_PE12MFP_GPIO@GPE_MFPH', 'EBI_ADR14:SYS_GPE_MFPH_PE12MFP_EBI_ADR14@GPE_MFPH', 'USCI1_CLK:SYS_GPE_MFPH_PE12MFP_USCI1_CLK@GPE_MFPH', 'UART1_nRTS:SYS_GPE_MFPH_PE12MFP_UART1_nRTS@GPE_MFPH', 'PWM0_CH4:SYS_GPE_MFPH_PE12MFP_PWM0_CH4@GPE_MFPH'] },
	{ f: ['PE.13', 'GPIO:SYS_GPE_MFPH_PE13MFP_GPIO@GPE_MFPH', 'EBI_ADR15:SYS_GPE_MFPH_PE13MFP_EBI_ADR15@GPE_MFPH', 'I2C0_SCL:SYS_GPE_MFPH_PE13MFP_I2C0_SCL@GPE_MFPH', 'LCD_SEG41:SYS_GPE_MFPH_PE13MFP_LCD_SEG41@GPE_MFPH', 'LCD_COM6:SYS_GPE_MFPH_PE13MFP_LCD_COM6@GPE_MFPH', 'UART1_TXD:SYS_GPE_MFPH_PE13MFP_UART1_TXD@GPE_MFPH', 'PWM0_CH5:SYS_GPE_MFPH_PE13MFP_PWM0_CH5@GPE_MFPH', 'PWM1_CH0:SYS_GPE_MFPH_PE13MFP_PWM1_CH0@GPE_MFPH', 'BPWM1_CH5:SYS_GPE_MFPH_PE13MFP_BPWM1_CH5@GPE_MFPH'] },
	{ f: ['PE.14', 'GPIO:SYS_GPE_MFPH_PE14MFP_GPIO@GPE_MFPH', 'EBI_AD8:SYS_GPE_MFPH_PE14MFP_EBI_AD8@GPE_MFPH', 'UART2_TXD:SYS_GPE_MFPH_PE14MFP_UART2_TXD@GPE_MFPH', 'LCD_SEG34:SYS_GPE_MFPH_PE14MFP_LCD_SEG34@GPE_MFPH', 'TK_TK8:SYS_GPE_MFPH_PE14MFP_TK_TK8@GPE_MFPH', 'PSIO0_CH0:SYS_GPE_MFPH_PE14MFP_PSIO0_CH0@GPE_MFPH'] },
	{ f: ['PE.15', 'GPIO:SYS_GPE_MFPH_PE15MFP_GPIO@GPE_MFPH', 'EBI_AD9:SYS_GPE_MFPH_PE15MFP_EBI_AD9@GPE_MFPH', 'UART2_RXD:SYS_GPE_MFPH_PE15MFP_UART2_RXD@GPE_MFPH', 'TK_TK21:SYS_GPE_MFPH_PE15MFP_TK_TK21@GPE_MFPH', 'PSIO0_CH1:SYS_GPE_MFPH_PE15MFP_PSIO0_CH1@GPE_MFPH'] },

	{ f: ['PF.0', 'GPIO:SYS_GPF_MFPL_PF0MFP_GPIO@GPF_MFPL', 'UART1_TXD:SYS_GPF_MFPL_PF0MFP_UART1_TXD@GPF_MFPL', 'I2C1_SCL:SYS_GPF_MFPL_PF0MFP_I2C1_SCL@GPF_MFPL', 'UART0_TXD:SYS_GPF_MFPL_PF0MFP_UART0_TXD@GPF_MFPL', 'BPWM1_CH0:SYS_GPF_MFPL_PF0MFP_BPWM1_CH0@GPF_MFPL', 'ICE_DAT:SYS_GPF_MFPL_PF0MFP_ICE_DAT@GPF_MFPL'] },
	{ f: ['PF.1', 'GPIO:SYS_GPF_MFPL_PF1MFP_GPIO@GPF_MFPL', 'UART1_RXD:SYS_GPF_MFPL_PF1MFP_UART1_RXD@GPF_MFPL', 'I2C1_SDA:SYS_GPF_MFPL_PF1MFP_I2C1_SDA@GPF_MFPL', 'UART0_RXD:SYS_GPF_MFPL_PF1MFP_UART0_RXD@GPF_MFPL', 'BPWM1_CH1:SYS_GPF_MFPL_PF1MFP_BPWM1_CH1@GPF_MFPL', 'ICE_CLK:SYS_GPF_MFPL_PF1MFP_ICE_CLK@GPF_MFPL'] },
	{ f: ['PF.2', 'GPIO:SYS_GPF_MFPL_PF2MFP_GPIO@GPF_MFPL', 'EBI_nCS1:SYS_GPF_MFPL_PF2MFP_EBI_nCS1@GPF_MFPL', 'UART0_RXD:SYS_GPF_MFPL_PF2MFP_UART0_RXD@GPF_MFPL', 'I2C0_SDA:SYS_GPF_MFPL_PF2MFP_I2C0_SDA@GPF_MFPL', 'QSPI0_CLK:SYS_GPF_MFPL_PF2MFP_QSPI0_CLK@GPF_MFPL', 'XT1_OUT:SYS_GPF_MFPL_PF2MFP_XT1_OUT@GPF_MFPL', 'BPWM1_CH1:SYS_GPF_MFPL_PF2MFP_BPWM1_CH1@GPF_MFPL'] },
	{ f: ['PF.3', 'GPIO:SYS_GPF_MFPL_PF3MFP_GPIO@GPF_MFPL', 'EBI_nCS0:SYS_GPF_MFPL_PF3MFP_EBI_nCS0@GPF_MFPL', 'UART0_TXD:SYS_GPF_MFPL_PF3MFP_UART0_TXD@GPF_MFPL', 'I2C0_SCL:SYS_GPF_MFPL_PF3MFP_I2C0_SCL@GPF_MFPL', 'XT1_IN:SYS_GPF_MFPL_PF3MFP_XT1_IN@GPF_MFPL', 'BPWM1_CH0:SYS_GPF_MFPL_PF3MFP_BPWM1_CH0@GPF_MFPL'] },
	{ f: ['PF.4', 'GPIO:SYS_GPF_MFPL_PF4MFP_GPIO@GPF_MFPL', 'UART2_TXD:SYS_GPF_MFPL_PF4MFP_UART2_TXD@GPF_MFPL', 'UART2_nRTS:SYS_GPF_MFPL_PF4MFP_UART2_nRTS@GPF_MFPL', 'BPWM0_CH5:SYS_GPF_MFPL_PF4MFP_BPWM0_CH5@GPF_MFPL', 'X32_OUT:SYS_GPF_MFPL_PF4MFP_X32_OUT@GPF_MFPL', 'PWM0_CH1:SYS_GPF_MFPL_PF4MFP_PWM0_CH1@GPF_MFPL'] },
	{ f: ['PF.5', 'GPIO:SYS_GPF_MFPL_PF5MFP_GPIO@GPF_MFPL', 'UART2_RXD:SYS_GPF_MFPL_PF5MFP_UART2_RXD@GPF_MFPL', 'UART2_nCTS:SYS_GPF_MFPL_PF5MFP_UART2_nCTS@GPF_MFPL', 'BPWM0_CH4:SYS_GPF_MFPL_PF5MFP_BPWM0_CH4@GPF_MFPL', 'X32_IN:SYS_GPF_MFPL_PF5MFP_X32_IN@GPF_MFPL', 'EADC0_ST:SYS_GPF_MFPL_PF5MFP_EADC0_ST@GPF_MFPL', 'PWM0_CH0:SYS_GPF_MFPL_PF5MFP_PWM0_CH0@GPF_MFPL'] },
	{ f: ['PF.6', 'GPIO:SYS_GPF_MFPL_PF6MFP_GPIO@GPF_MFPL', 'EBI_ADR19:SYS_GPF_MFPL_PF6MFP_EBI_ADR19@GPF_MFPL', 'SC0_CLK:SYS_GPF_MFPL_PF6MFP_SC0_CLK@GPF_MFPL', 'SPI0_MOSI:SYS_GPF_MFPL_PF6MFP_SPI0_MOSI@GPF_MFPL', 'EBI_nCS0:SYS_GPF_MFPL_PF6MFP_EBI_nCS0@GPF_MFPL', 'TAMPER0:SYS_GPF_MFPL_PF6MFP_TAMPER0@GPF_MFPL'] },
	{ f: ['PF.7', 'GPIO:SYS_GPF_MFPL_PF7MFP_GPIO@GPF_MFPL', 'EBI_ADR18:SYS_GPF_MFPL_PF7MFP_EBI_ADR18@GPF_MFPL', 'SC0_DAT:SYS_GPF_MFPL_PF7MFP_SC0_DAT@GPF_MFPL', 'SPI0_MISO:SYS_GPF_MFPL_PF7MFP_SPI0_MISO@GPF_MFPL'] },
	{ f: ['PF.8', 'GPIO:SYS_GPF_MFPH_PF8MFP_GPIO@GPF_MFPH'] },
	{ f: ['PF.9', 'GPIO:SYS_GPF_MFPH_PF9MFP_GPIO@GPF_MFPH'] },
	{ f: ['PF.10', 'GPIO:SYS_GPF_MFPH_PF10MFP_GPIO@GPF_MFPH'] },
	{ f: ['PF.11', 'GPIO:SYS_GPF_MFPH_PF11MFP_GPIO@GPF_MFPH'] },
	{ f: ['PF.12', 'GPIO:SYS_GPF_MFPH_PF12MFP_GPIO@GPF_MFPH'] },
	{ f: ['PF.13', 'GPIO:SYS_GPF_MFPH_PF13MFP_GPIO@GPF_MFPH'] },
	{ f: ['PF.14', 'GPIO:SYS_GPF_MFPH_PF14MFP_GPIO@GPF_MFPH', 'PWM1_BRAKE0:SYS_GPF_MFPH_PF14MFP_PWM1_BRAKE0@GPF_MFPH', 'PWM0_BRAKE0:SYS_GPF_MFPH_PF14MFP_PWM0_BRAKE0@GPF_MFPH', 'PSIO0_CH3:SYS_GPF_MFPH_PF14MFP_PSIO0_CH3@GPF_MFPH', 'PWM0_CH4:SYS_GPF_MFPH_PF14MFP_PWM0_CH4@GPF_MFPH', 'CLKO:SYS_GPF_MFPH_PF14MFP_CLKO@GPF_MFPH', 'TM3:SYS_GPF_MFPH_PF14MFP_TM3@GPF_MFPH', 'INT5:SYS_GPF_MFPH_PF14MFP_INT5@GPF_MFPH'] },
	{ f: ['PF.15', 'GPIO:SYS_GPF_MFPH_PF15MFP_GPIO@GPF_MFPH', 'LCD_SEG35:SYS_GPF_MFPH_PF15MFP_LCD_SEG35@GPF_MFPH', 'TK_TK7:SYS_GPF_MFPH_PF15MFP_TK_TK7@GPF_MFPH', 'TM2:SYS_GPF_MFPH_PF15MFP_TM2@GPF_MFPH', 'CLKO:SYS_GPF_MFPH_PF15MFP_CLKO@GPF_MFPH', 'INT4:SYS_GPF_MFPH_PF15MFP_INT4@GPF_MFPH'] }
];

NUTOOL_PIN.g_cfg_gpiosDescriptions = [
	'ACMP0_N:Analog comparator 0 negative input pin',
	'ACMP0_O:Analog comparator 0 output pin',
	'ACMP0_P0:Analog comparator 0 positive input 0 pin',
	'ACMP0_P1:Analog comparator 0 positive input 1 pin',
	'ACMP0_P2:Analog comparator 0 positive input 2 pin',
	'ACMP0_P3:Analog comparator 0 positive input 3 pin',
	'ACMP0_WLAT:Analog comparator 0 window latch input pin',
	'ACMP1_N:Analog comparator 1 negative input pin',
	'ACMP1_O:Analog comparator 1 output pin',
	'ACMP1_P0:Analog comparator 1 positive input 0 pin',
	'ACMP1_P1:Analog comparator 1 positive input 1 pin',
	'ACMP1_P2:Analog comparator 1 positive input 2 pin',
	'ACMP1_P3:Analog comparator 1 positive input 3 pin',
	'ACMP1_WLAT:Analog comparator 1 window latch input pin',
	'BPWM0_CH0:BPWM0 channel 0 output/capture input',
	'BPWM0_CH1:BPWM0 channel 1 output/capture input',
	'BPWM0_CH2:BPWM0 channel 2 output/capture input',
	'BPWM0_CH3:BPWM0 channel 3 output/capture input',
	'BPWM0_CH4:BPWM0 channel 4 output/capture input',
	'BPWM0_CH5:BPWM0 channel 5 output/capture input',
	'BPWM1_CH0:BPWM1 channel 0 output/capture input',
	'BPWM1_CH1:BPWM1 channel 1 output/capture input',
	'BPWM1_CH2:BPWM1 channel 2 output/capture input',
	'BPWM1_CH3:BPWM1 channel 3 output/capture input',
	'BPWM1_CH4:BPWM1 channel 4 output/capture input',
	'BPWM1_CH5:BPWM1 channel 5 output/capture input',
	'CLKO:Clock Out',
	'DAC0_OUT:DAC0 channel analog output',
	'DAC0_ST:DAC0 external trigger input',
	'DAC1_OUT:DAC1 channel analog output',
	'DAC1_ST:DAC1 external trigger input',
	'EADC0_CH0:EADC0 channel 0 analog input',
	'EADC0_CH1:EADC0 channel 1 analog input',
	'EADC0_CH2:EADC0 channel 2 analog input',
	'EADC0_CH3:EADC0 channel 3 analog input',
	'EADC0_CH4:EADC0 channel 4 analog input',
	'EADC0_CH5:EADC0 channel 5 analog input',
	'EADC0_CH6:EADC0 channel 6 analog input',
	'EADC0_CH7:EADC0 channel 7 analog input',
	'EADC0_CH8:EADC0 channel 8 analog input',
	'EADC0_CH9:EADC0 channel 9 analog input',
	'EADC0_CH10:EADC0 channel 10 analog input',
	'EADC0_CH11:EADC0 channel 11 analog input',
	'EADC0_CH12:EADC0 channel 12 analog input',
	'EADC0_CH13:EADC0 channel 13 analog input',
	'EADC0_CH14:EADC0 channel 14 analog input',
	'EADC0_CH15:EADC0 channel 15 analog input',
	'EADC0_ST:EADC0 external trigger input',
	'I2C0_SCL:I2C0 clock pin',
	'I2C0_SDA:I2C0 data input/output pin',
	'I2C0_SMBAL:I2C0 SMBus SMBALTER pin ',
	'I2C0_SMBSUS:I2C0 SMBus SMBSUS pin (PMBus CONTROL pin)',
	'I2C1_SCL:I2C1 clock pin',
	'I2C1_SDA:I2C1 data input/output pin',
	'I2C1_SMBAL:I2C1 SMBus SMBALTER pin ',
	'I2C1_SMBSUS:I2C1 SMBus SMBSUS pin (PMBus CONTROL pin)',
	'ICE_CLK:Serial wired debugger clock pin',
	'ICE_DAT:Serial wired debugger data pin',
	'INT0:External interrupt 0 input pin',
	'INT1:External interrupt 1 input pin',
	'INT2:External interrupt 2 input pin',
	'INT3:External interrupt 3 input pin',
	'INT4:External interrupt 4 input pin',
	'INT5:External interrupt 5 input pin',
	'LCD_COM0:LCD common 0 output pin',
	'LCD_COM1:LCD common 1 output pin',
	'LCD_COM2:LCD common 2 output pin',
	'LCD_COM3:LCD common 3 output pin',
	'LCD_COM4:LCD common 4 output pin',
	'LCD_COM5:LCD common 5 output pin',
	'LCD_COM6:LCD common 6 output pin',
	'LCD_COM7:LCD common 7 output pin',
	'LCD_SEG0:LCD segment 0 output pin',
	'LCD_SEG1:LCD segment 1 output pin',
	'LCD_SEG2:LCD segment 2 output pin',
	'LCD_SEG3:LCD segment 3 output pin',
	'LCD_SEG4:LCD segment 4 output pin',
	'LCD_SEG5:LCD segment 5 output pin',
	'LCD_SEG6:LCD segment 6 output pin',
	'LCD_SEG7:LCD segment 7 output pin',
	'LCD_SEG8:LCD segment 8 output pin',
	'LCD_SEG9:LCD segment 9 output pin',
	'LCD_SEG10:LCD segment 10 output pin',
	'LCD_SEG11:LCD segment 11 output pin',
	'LCD_SEG12:LCD segment 12 output pin',
	'LCD_SEG13:LCD segment 13 output pin',
	'LCD_SEG14:LCD segment 14 output pin',
	'LCD_SEG15:LCD segment 15 output pin',
	'LCD_SEG16:LCD segment 16 output pin',
	'LCD_SEG17:LCD segment 17 output pin',
	'LCD_SEG18:LCD segment 18 output pin',
	'LCD_SEG19:LCD segment 19 output pin',
	'LCD_SEG20:LCD segment 20 output pin',
	'LCD_SEG21:LCD segment 21 output pin',
	'LCD_SEG22:LCD segment 22 output pin',
	'LCD_SEG23:LCD segment 23 output pin',
	'LCD_SEG24:LCD segment 24 output pin',
	'LCD_SEG25:LCD segment 25 output pin',
	'LCD_SEG26:LCD segment 26 output pin',
	'LCD_SEG27:LCD segment 27 output pin',
	'LCD_SEG28:LCD segment 28 output pin',
	'LCD_SEG29:LCD segment 29 output pin',
	'LCD_SEG30:LCD segment 30 output pin',
	'LCD_SEG31:LCD segment 31 output pin',
	'LCD_SEG32:LCD segment 32 output pin',
	'LCD_SEG33:LCD segment 33 output pin',
	'LCD_SEG34:LCD segment 34 output pin',
	'LCD_SEG35:LCD segment 35 output pin',
	'LCD_SEG36:LCD segment 36 output pin',
	'LCD_SEG37:LCD segment 37 output pin',
	'LCD_SEG38:LCD segment 38 output pin',
	'LCD_SEG39:LCD segment 39 output pin',
	'LCD_SEG40:LCD segment 40 output pin',
	'LCD_SEG41:LCD segment 41 output pin',
	'LCD_SEG42:LCD segment 42 output pin',
	'LCD_SEG43:LCD segment 43 output pin',
	'LCD_SEG44:LCD segment 44 output pin',
	'LCD_SEG45:LCD segment 45 output pin',
	'LCD_SEG46:LCD segment 46 output pin',
	'LCD_SEG47:LCD segment 47 output pin',
	'LCD_V1:LCD Unit voltage for charge pump circuit',
	'LCD_V2:LCD driver biasing voltage',
	'LCD_V3:LCD driver biasing voltage',
	'SC0_CLK:Smart Card 0 clock pin',
	'SC0_DAT:Smart Card 0 data pin',
	'SC0_nCD:Smart Card 0 card detect pin',
	'SC0_PWR:Smart Card 0 power pin',
	'SC0_RST:Smart Card 0 reset pin',
	'SPI0_CLK:SPI0 serial clock pin',
	'SPI0_I2SMCLK:SPI0 I2S master clock output pin',
	'SPI0_MISO:SPI0 MISO (Master In, Slave Out) pin',
	'SPI0_MOSI:SPI0 MOSI (Master Out, Slave In) pin',
	'SPI0_SS:SPI0 slave select pin',
	'SPI1_CLK:SPI1 serial clock pin',
	'SPI1_I2SMCLK:SPI1 I2S master clock output pin',
	'SPI1_MISO:SPI1 MISO (Master In, Slave Out) pin',
	'SPI1_MOSI:SPI1 MOSI (Master Out, Slave In) pin',
	'SPI1_SS:SPI1 slave select pin',
	'TK_SE:Touch Key (shielding electrode)',
	'TK_TK0:Touch key 0',
	'TK_TK1:Touch key 1',
	'TK_TK2:Touch key 2',
	'TK_TK3:Touch key 3',
	'TK_TK4:Touch key 4',
	'TK_TK5:Touch key 5',
	'TK_TK6:Touch key 6',
	'TK_TK7:Touch key 7',
	'TK_TK8:Touch key 8',
	'TK_TK9:Touch key 9',
	'TK_TK10:Touch key 10',
	'TK_TK11:Touch key 11',
	'TK_TK12:Touch key 12',
	'TK_TK13:Touch key 13',
	'TK_TK14:Touch key 14',
	'TK_TK15:Touch key 15',
	'TK_TK16:Touch key 16',
	'TK_TK17:Touch key 17',
	'TK_TK18:Touch key 18',
	'TK_TK19:Touch key 19',
	'TK_TK20:Touch key 20',
	'TK_TK21:Touch key 21',
	'TK_TK22:Touch key 22',
	'TK_TK23:Touch key 23',
	'TK_TK24:Touch key 24',
	'TK_TK25:Touch key 25',
	'TM0:Timer0 event counter input/toggle output pin',
	'TM0_EXT:Timer0 external capture input/toggle output pin',
	'TM1:Timer1 event counter input/toggle output pin',
	'TM1_EXT:Timer1 external capture input/toggle output pin',
	'TM2:Timer2 event counter input/toggle output pin',
	'TM2_EXT:Timer2 external capture input/toggle output pin',
	'TM3:Timer3 event counter input/toggle output pin',
	'TM3_EXT:Timer3 external capture input/toggle output pin',
	'UART0_nCTS:UART0 clear to Send input pin',
	'UART0_nRTS:UART0 request to Send output pin',
	'UART0_RXD:UART0 data receiver input pin',
	'UART0_TXD:UART0 data transmitter output pin',
	'UART1_nCTS:UART1 clear to Send input pin',
	'UART1_nRTS:UART1 request to Send output pin',
	'UART1_RXD:UART1 data receiver input pin',
	'UART1_TXD:UART1 data transmitter output pin',
	'UART2_nCTS:UART2 clear to Send input pin',
	'UART2_nRTS:UART2 request to Send output pin',
	'UART2_RXD:UART2 data receiver input pin',
	'UART2_TXD:UART2 data transmitter output pin',
	'UART3_nCTS:UART3 clear to Send input pin',
	'UART3_nRTS:UART3 request to Send output pin',
	'UART3_RXD:UART3 data receiver input pin',
	'UART3_TXD:UART3 data transmitter output pin',
	'USCI0_CLK:USCI0 clock pin',
	'USCI0_CTL0:USCI0 control 0 pin',
	'USCI0_CTL1:USCI0 control 1 pin',
	'USCI0_DAT0:USCI0 data 0 pin',
	'USCI0_DAT1:USCI0 data 1 pin',
	'USCI1_CLK:USCI1 clock pin',
	'USCI1_CTL0:USCI1 control 0 pin',
	'USCI1_CTL1:USCI1 control 1 pin',
	'USCI1_DAT0:USCI1 data 0 pin',
	'USCI1_DAT1:USCI1 data 1 pin',
	'X32_IN:External 32.768 kHz crystal input pin',
	'X32_OUT:External 32.768 kHz crystal output pin',
	'XT1_IN:External 4~24 MHz (high speed) crystal input pin',
	'XT1_OUT:External 4~24 MHz (high speed) crystal output pin'
];

NUTOOL_PIN.g_cfg_regDescriptions = {};
NUTOOL_PIN.g_cfg_regDescriptions.GPA_MFPL = '0x40000030';
NUTOOL_PIN.g_cfg_regDescriptions.GPA_MFPH = '0x40000034';
NUTOOL_PIN.g_cfg_regDescriptions.GPB_MFPL = '0x40000038';
NUTOOL_PIN.g_cfg_regDescriptions.GPB_MFPH = '0x4000003C';
NUTOOL_PIN.g_cfg_regDescriptions.GPC_MFPL = '0x40000040';
NUTOOL_PIN.g_cfg_regDescriptions.GPC_MFPH = '0x40000044';
NUTOOL_PIN.g_cfg_regDescriptions.GPD_MFPL = '0x40000048';
NUTOOL_PIN.g_cfg_regDescriptions.GPD_MFPH = '0x4000004C';
NUTOOL_PIN.g_cfg_regDescriptions.GPE_MFPL = '0x40000050';
NUTOOL_PIN.g_cfg_regDescriptions.GPE_MFPH = '0x40000054';
NUTOOL_PIN.g_cfg_regDescriptions.GPF_MFPL = '0x40000058';
NUTOOL_PIN.g_cfg_regDescriptions.GPF_MFPH = '0x4000005C';

NUTOOL_PIN.g_cfg_gpioMatrix = [];
NUTOOL_PIN.g_cfg_shareBits = [];
NUTOOL_PIN.g_cfg_addGPIO = {};
NUTOOL_PIN.g_cfg_unusedGPIO = {
	"M254SD2AE(LQFP64)": {
		"ALL": ["USB", "TK"]
	},
	"M256SD2AE(LQFP64)": {
		"ALL": ["USB"]
	},
	"M256MD2AE(LQFP44)": {
		"ALL": ["USB"]
	}
};

NUTOOL_PIN.decidepackageNumber = function (given_partNumber_package) {
	var partNumber_package;

	if (typeof given_partNumber_package === 'undefined') {
		partNumber_package = NUTOOL_PIN.getg_partNumber_package();
	}
	else {
		partNumber_package = given_partNumber_package;
	}

	NUTOOL_PIN.g_packageNumber = partNumber_package.substring(partNumber_package.indexOf('(') + 1);
	NUTOOL_PIN.g_packageNumber = NUTOOL_PIN.g_packageNumber.substring(0, NUTOOL_PIN.g_packageNumber.indexOf(')'));
	NUTOOL_PIN.g_packageNumberIndex = NUTOOL_PIN.g_packageNumber;

	partNumber_package = null;
};
