// chip content
NUTOOL_PIN.g_cfg_chips = [
	//NANO100AN
	{ name: "NANO100ZC2AN", pkg: "QFN33" },
	{ name: "NANO100ZD2AN", pkg: "QFN33" },
	{ name: "NANO100ZD3AN", pkg: "QFN33" },
	{ name: "NANO100LC2AN", pkg: "LQFP48" },
	{ name: "NANO100LD2AN", pkg: "LQFP48" },
	{ name: "NANO100LD3AN", pkg: "LQFP48" },
	{ name: "NANO100SC2AN", pkg: "LQFP64" },
	{ name: "NANO100SD2AN", pkg: "LQFP64" },
	{ name: "NANO100SD3AN", pkg: "LQFP64" },
	{ name: "NANO100VD2AN", pkg: "LQFP100" },
	{ name: "NANO100VD3AN", pkg: "LQFP100" },

	{ name: "NANO120ZC2AN", pkg: "QFN33" },
	{ name: "NANO120ZD2AN", pkg: "QFN33" },
	{ name: "NANO120ZD3AN", pkg: "QFN33" },
	{ name: "NANO120LC2AN", pkg: "LQFP48" },
	{ name: "NANO120LD2AN", pkg: "LQFP48" },
	{ name: "NANO120LD3AN", pkg: "LQFP48" },
	{ name: "NANO120SC2AN", pkg: "LQFP64" },
	{ name: "NANO120SD2AN", pkg: "LQFP64" },
	{ name: "NANO120SD3AN", pkg: "LQFP64" },
	{ name: "NANO120VD2AN", pkg: "LQFP100" },
	{ name: "NANO120VD3AN", pkg: "LQFP100" },
	//NANO100BN
	{ name: "NANO100NC2BN", pkg: "QFN48" },
	{ name: "NANO100ND2BN", pkg: "QFN48" },
	{ name: "NANO100ND3BN", pkg: "QFN48" },
	{ name: "NANO100NE3BN", pkg: "QFN48" },
	{ name: "NANO100LC2BN", pkg: "LQFP48" },
	{ name: "NANO100LD2BN", pkg: "LQFP48" },
	{ name: "NANO100LD3BN", pkg: "LQFP48" },
	{ name: "NANO100LE3BN", pkg: "LQFP48" },
	{ name: "NANO100SC2BN", pkg: "LQFP64" },
	{ name: "NANO100SD2BN", pkg: "LQFP64" },
	{ name: "NANO100SD3BN", pkg: "LQFP64" },
	{ name: "NANO100SE3BN", pkg: "LQFP64" },
	{ name: "NANO100KD3BN", pkg: "LQFP128" },
	//{ name: "NANO100KC2BN", pkg: "LQFP128" },
	//{ name: "NANO100KD2BN", pkg: "LQFP128" },
	//{ name: "NANO100KC3BN", pkg: "LQFP128" },
	{ name: "NANO100KE3BN", pkg: "LQFP128" },

	{ name: "NANO110SC2BN", pkg: "LQFP64" },
	{ name: "NANO110SD2BN", pkg: "LQFP64" },
	{ name: "NANO110SD3BN", pkg: "LQFP64" },
	{ name: "NANO110SE3BN", pkg: "LQFP64" },
	{ name: "NANO110RC2BN", pkg: "LQFP64" },
	{ name: "NANO110RD2BN", pkg: "LQFP64" },
	{ name: "NANO110RD3BN", pkg: "LQFP64" },
	{ name: "NANO110RE3BN", pkg: "LQFP64" },
	{ name: "NANO110KC2BN", pkg: "LQFP128" },
	{ name: "NANO110KD2BN", pkg: "LQFP128" },
	{ name: "NANO110KD3BN", pkg: "LQFP128" },
	{ name: "NANO110KE3BN", pkg: "LQFP128" },

	{ name: "NANO120LC2BN", pkg: "LQFP48" },
	{ name: "NANO120LD2BN", pkg: "LQFP48" },
	{ name: "NANO120LD3BN", pkg: "LQFP48" },
	{ name: "NANO120LE3BN", pkg: "LQFP48" },
	{ name: "NANO120SC2BN", pkg: "LQFP64" },
	{ name: "NANO120SD2BN", pkg: "LQFP64" },
	{ name: "NANO120SD3BN", pkg: "LQFP64" },
	{ name: "NANO120SE3BN", pkg: "LQFP64" },
	//{ name: "NANO120KC2BN", pkg: "LQFP128" },
	//{ name: "NANO120KD2BN", pkg: "LQFP128" },
	{ name: "NANO120KD3BN", pkg: "LQFP128" },
	{ name: "NANO120KE3BN", pkg: "LQFP128" },

	{ name: "NANO130SC2BN", pkg: "LQFP64" },
	{ name: "NANO130SD2BN", pkg: "LQFP64" },
	{ name: "NANO130SD3BN", pkg: "LQFP64" },
	{ name: "NANO130SE3BN", pkg: "LQFP64" },
	{ name: "NANO130KC2BN", pkg: "LQFP128" },
	{ name: "NANO130KD2BN", pkg: "LQFP128" },
	{ name: "NANO130KD3BN", pkg: "LQFP128" },
	{ name: "NANO130KE3BN", pkg: "LQFP128" },
	//NANO103
	{ name: "NANO103SD3AE", pkg: "LQFP64" },
	{ name: "NANO103LD3AE", pkg: "LQFP48" },
	{ name: "NANO103ZD3AE", pkg: "QFN33" },
	//NANO112
	{ name: "NANO112VC2AN", pkg: "LQFP100" },
	{ name: "NANO112RC2AN", pkg: "LQFP64" },
	{ name: "NANO112RB1AN", pkg: "LQFP64" },
	{ name: "NANO112SC2AN", pkg: "LQFP64" },
	{ name: "NANO112SB1AN", pkg: "LQFP64" },
	{ name: "NANO102SC2AN", pkg: "LQFP64" },
	{ name: "NANO112LC2AN", pkg: "LQFP48" },
	{ name: "NANO112LB1AN", pkg: "LQFP48" },
	{ name: "NANO102LC2AN", pkg: "LQFP48" },
	{ name: "NANO102LB1AN", pkg: "LQFP48" },
	{ name: "NANO102ZB1AN", pkg: "QFN33" },
	{ name: "NANO102ZC2AN", pkg: "QFN33" }
];

NUTOOL_PIN.g_cfg_pkgs = {
	"LQFP64": [
		'PB.14', 'PB.13', 'VBAT', 'PF.6', 'PF.7', 'PA.11', 'PA.10', 'PA.9', 'PA.8', 'PB.4',
		'PB.5', 'PB.6', 'PB.7', 'LDO_CAP', 'VDD', 'VSS',
		'PB.0', 'PB.1', 'PB.2', 'PB.3', 'PD.6', 'PD.7', 'PD.14', 'PD.15', 'PC.3', 'PC.2',
		'PC.1', 'PC.0', 'PE.5', 'PB.11', 'PB.10', 'PB.9',
		'PC.11', 'PC.10', 'PC.9', 'PC.8', 'PA.15', 'PA.14', 'PA.13', 'PA.12', 'PF.0', 'PF.1',
		'AVSS', 'PA.0', 'PA.1', 'PA.2', 'PA.3', 'PA.4',
		'PA.5', 'PA.6', 'VREF', 'AVDD', 'PC.7', 'PC.6', 'PC.15', 'PC.14', 'PB.15', 'PF.3',
		'PF.2', 'nRESET', 'VSS', 'VDD', 'PVSS', 'PB.8'
	],
	"LQFP48": [
		'VBAT', 'PF.6', 'PF.7', 'PA.11', 'PA.10', 'PA.9', 'PA.8', 'PB.4', 'PB.5', 'LDO_CAP',
		'VDD', 'VSS',
		'PB.0', 'PB.1', 'PB.2', 'PB.3', 'PC.3', 'PC.2', 'PC.1', 'PC.0', 'PE.5', 'PB.11',
		'PB.10', 'PB.9',
		'PA.15', 'PA.14', 'PA.13', 'PA.12', 'PF.0', 'PF.1', 'AVSS', 'PA.0', 'PA.1', 'PA.2',
		'PA.3', 'PA.4',
		'PA.5', 'PA.6', 'VREF', 'AVDD', 'PC.7', 'PC.6', 'PB.15', 'PF.3', 'PF.2', 'nRESET',
		'PVSS', 'PB.8'
	],
	"QFN33": [
		'PF.7', 'PA.9', 'PA.8', 'PB.4', 'PB.5', 'LDO_CAP', 'VDD', 'VSS',
		'PB.0', 'PB.1', 'PB.2', 'PB.3', 'PC.3', 'PC.2', 'PC.1', 'PC.0',
		'PA.15', 'PA.14', 'PF.0', 'PF.1', 'PA.0', 'PA.2', 'PA.3', 'PA.4',
		'PA.5', 'PA.6', 'AVDD', 'PF.3', 'PF.2', 'nRESET', 'VBAT', 'PF.6'
	]
};

NUTOOL_PIN.g_cfg_gpios = [
	{ f: ['PA.0:0', 'ADC_CH0:1', 'ACMP0_P:2', 'TM2_EXT:3', 'PWM0_CH2:5', 'SPI3_MOSI1:6'] },
	{ f: ['PA.1:0', 'ADC_CH1:1', 'ACMP0_N:2', 'SPI3_MISO1:6'] },
	{ f: ['PA.2:0', 'ADC_CH2:1', 'UART1_RXD:5'] },
	{ f: ['PA.3:0', 'ADC_CH3:1', 'UART1_TXD:5', 'SPI3_MOSI0:6'] },
	{ f: ['PA.4:0', 'ADC_CH4:1', 'I2C0_SDA:5', 'SPI3_MISO0:6'] },
	{ f: ['PA.5:0', 'ADC_CH5:1', 'I2C0_SCL:5', 'SPI3_CLK:6'] },
	{ f: ['PA.6:0', 'ADC_CH6:1', 'ACMP0_O:2', 'TM3_EXT:3', 'TM3_CNT:4', 'PWM0_CH3:5', 'SPI3_SS0:6', 'TM3_OUT:7'] },
	{ f: ['PA.7:0'] },
	{ f: ['PA.8:0', 'I2C0_SDA:1', 'TM0_CNT:2', 'SC0_CLK:3', 'SPI2_SS0:4', 'TM0_OUT:5', 'UART1_nCTS:6'] },
	{ f: ['PA.9:0', 'I2C0_SCL:1', 'TM1_CNT:2', 'SC0_DAT:3', 'SPI2_CLK:4', 'TM1_OUT:5', 'UART1_nRTS:6', 'SNOOPER:7'] },
	{ f: ['PA.10:0', 'I2C1_SDA:1', 'TM2_CNT:2', 'SC0_PWR:3', 'SPI2_MISO0:4', 'TM2_OUT:5'] },
	{ f: ['PA.11:0', 'I2C1_SCL:1', 'TM3_CNT:2', 'SC0_RST:3', 'SPI2_MOSI0:4', 'TM3_OUT:5'] },
	{ f: ['PA.12:0', 'PWM0_CH0:1', 'TM0_EXT:3', 'I2C0_SDA:5'] },
	{ f: ['PA.13:0', 'PWM0_CH1:1', 'TM1_EXT:3', 'I2C0_SCL:5'] },
	{ f: ['PA.14:0', 'PWM0_CH2:1', 'I2C1_SDA:2', 'TM2_EXT:3', 'TM2_CNT:5', 'UART0_RXD:6', 'TM2_OUT:7'] },
	{ f: ['PA.15:0', 'PWM0_CH3:1', 'I2C1_SCL:2', 'TM3_EXT:3', 'SC0_PWR:4', 'TM3_CNT:5', 'UART0_TXD:6', 'TM3_OUT:7'] },

	{ f: ['PB.0:0', 'UART0_RXD:1', 'SPI1_MOSI0:3'] },
	{ f: ['PB.1:0', 'UART0_TXD:1', 'SPI1_MISO0:3'] },
	{ f: ['PB.2:0', 'UART0_nRTS:1', 'SPI1_CLK:3', 'CLKO:4'] },
	{ f: ['PB.3:0', 'UART0_nCTS:1', 'SPI1_SS0:3', 'SC1_CD:4'] },
	{ f: ['PB.4:0', 'UART1_RXD:1', 'SC0_CD:3', 'SPI2_SS0:4', 'RTC_HZ:6'] },
	{ f: ['PB.5:0', 'UART1_TXD:1', 'SC0_RST:3', 'SPI2_CLK:4'] },
	{ f: ['PB.6:0', 'UART1_nRTS:1', 'SPI2_MISO0:4'] },
	{ f: ['PB.7:0', 'UART1_nCTS:1', 'SPI2_MOSI0:4'] },
	{ f: ['PB.8:0', 'STADC:1', 'TM0_CNT:2', 'INT0:3', 'TM0_OUT:4', 'SNOOPER:7'] },
	{ f: ['PB.9:0', 'SPI1_SS1:1', 'TM1_CNT:2', 'TM1_OUT:4', 'INT0:5'] },
	{ f: ['PB.10:0', 'SPI0_MOSI0:1', 'TM2_CNT:2', 'TM2_OUT:4', 'SPI0_SS1:5'] },
	{ f: ['PB.11:0', 'PWM0_CH4:1', 'TM3_CNT:2', 'TM3_OUT:4', 'SPI0_MISO0:5'] },
	{ f: ['PB.12:0'] },
	{ f: ['PB.13:0', 'SPI2_MISO1:3', 'SNOOPER:7'] },
	{ f: ['PB.14:0', 'INT0:1', 'SPI2_MOSI1:3', 'SPI2_SS1:4'] },
	{ f: ['PB.15:0', 'INT1:1', 'SNOOPER:3', 'SC1_CD:4'] },

	{ f: ['PC.0:0', 'SPI0_SS0:1', 'SC1_CLK:4', 'PWM0_BRAKE1:5'] },
	{ f: ['PC.1:0', 'SPI0_CLK:1', 'SC1_DAT:4', 'PWM0_BRAKE0:5'] },
	{ f: ['PC.2:0', 'SPI0_MISO0:1', 'SC1_PWR:4', 'PWM0_BRAKE1:5'] },
	{ f: ['PC.3:0', 'SPI0_MOSI0:1', 'SC1_RST:4', 'PWM0_BRAKE0:5'] },
	{ f: ['PC.4:0'] },
	{ f: ['PC.5:0'] },
	{ f: ['PC.6:0', 'UART1_RXD:1', 'TM0_EXT:3', 'SC1_CD:4', 'PWM0_CH0:5'] },
	{ f: ['PC.7:0', 'UART1_TXD:1', 'ADC_CH7:2', 'TM1_EXT:3', 'PWM0_CH1:5'] },
	{ f: ['PC.8:0', 'SPI1_SS0:1', 'I2C1_SDA:5'] },
	{ f: ['PC.9:0', 'SPI1_CLK:1', 'I2C1_SCL:5'] },
	{ f: ['PC.10:0', 'SPI1_MISO0:1', 'UART1_RXD:5'] },
	{ f: ['PC.11:0', 'SPI1_MOSI0:1', 'UART1_TXD:5'] },
	{ f: ['PC.12:0'] },
	{ f: ['PC.13:0'] },
	{ f: ['PC.14:0', 'UART1_nCTS:1'] },
	{ f: ['PC.15:0', 'UART1_nRTS:1', 'TM0_EXT:3'] },

	{ f: ['PD.0:0'] },
	{ f: ['PD.1:0'] },
	{ f: ['PD.2:0'] },
	{ f: ['PD.3:0'] },
	{ f: ['PD.4:0'] },
	{ f: ['PD.5:0'] },
	{ f: ['PD.6:0', 'SPI1_MOSI1:3', 'SC1_RST:4'] },
	{ f: ['PD.7:0', 'SPI1_MISO1:3', 'SC1_PWR:4'] },
	{ f: ['PD.8:0'] },
	{ f: ['PD.9:0'] },
	{ f: ['PD.10:0'] },
	{ f: ['PD.11:0'] },
	{ f: ['PD.12:0'] },
	{ f: ['PD.13:0'] },
	{ f: ['PD.14:0', 'SPI0_MOSI1:1', 'SC1_DAT:4'] },
	{ f: ['PD.15:0', 'SPI0_MISO1:1', 'SC1_CLK:4'] },

	{ f: ['PE.0:0'] },
	{ f: ['PE.1:0'] },
	{ f: ['PE.2:0'] },
	{ f: ['PE.3:0'] },
	{ f: ['PE.4:0'] },
	{ f: ['PE.5:0', 'PWM0_CH5:1', 'RTC_HZ:6'] },
	{ f: ['PE.6:0'] },
	{ f: ['PE.7:0'] },
	{ f: ['PE.8:0'] },
	{ f: ['PE.9:0'] },
	{ f: ['PE.10:0'] },
	{ f: ['PE.11:0'] },
	{ f: ['PE.12:0'] },
	{ f: ['PE.13:0'] },
	{ f: ['PE.14:0'] },
	{ f: ['PE.15:0'] },

	{ f: ['PF.0:0', 'INT0:5', 'ICE_DAT:7'] },
	{ f: ['PF.1:0', 'CLKO:4', 'INT1:5', 'ICE_CLK:7'] },
	{ f: ['PF.2:0', 'XT1_OUT:7'] },
	{ f: ['PF.3:0', 'XT1_IN:7'] },
	{ f: ['PF.4:0'] },
	{ f: ['PF.5:0'] },
	{ f: ['PF.6:0', 'I2C1_SDA:1', 'X32_OUT:7'] },
	{ f: ['PF.7:0', 'I2C1_SCL:1', 'SC0_CD:3', 'X32_IN:7'] }
];

NUTOOL_PIN.g_cfg_gpiosDefines = [
	{ f: ['PA.0', 'GPIO:SYS_GPA_MFPL_PA0MFP_GPIO@GPA_MFPL', 'ADC_CH0:SYS_GPA_MFPL_PA0MFP_ADC_CH0@GPA_MFPL', 'ACMP0_P:SYS_GPA_MFPL_PA0MFP_ACMP0_P@GPA_MFPL', 'TM2_EXT:SYS_GPA_MFPL_PA0MFP_TM2_EXT@GPA_MFPL', 'PWM0_CH2:SYS_GPA_MFPL_PA0MFP_PWM0_CH2@GPA_MFPL', 'SPI3_MOSI1:SYS_GPA_MFPL_PA0MFP_SPI3_MOSI1@GPA_MFPL'] },
	{ f: ['PA.1', 'GPIO:SYS_GPA_MFPL_PA1MFP_GPIO@GPA_MFPL', 'ADC_CH1:SYS_GPA_MFPL_PA1MFP_ADC_CH1@GPA_MFPL', 'ACMP0_N:SYS_GPA_MFPL_PA1MFP_ACMP0_N@GPA_MFPL', 'SPI3_MISO1:SYS_GPA_MFPL_PA1MFP_SPI3_MISO1@GPA_MFPL'] },
	{ f: ['PA.2', 'GPIO:SYS_GPA_MFPL_PA2MFP_GPIO@GPA_MFPL', 'ADC_CH2:SYS_GPA_MFPL_PA2MFP_ADC_CH2@GPA_MFPL', 'UART1_RXD:SYS_GPA_MFPL_PA2MFP_UART1_RXD@GPA_MFPL'] },
	{ f: ['PA.3', 'GPIO:SYS_GPA_MFPL_PA3MFP_GPIO@GPA_MFPL', 'ADC_CH3:SYS_GPA_MFPL_PA3MFP_ADC_CH3@GPA_MFPL', 'UART1_TXD:SYS_GPA_MFPL_PA3MFP_UART1_TXD@GPA_MFPL', 'SPI3_MOSI0:SYS_GPA_MFPL_PA3MFP_SPI3_MOSI0@GPA_MFPL'] },
	{ f: ['PA.4', 'GPIO:SYS_GPA_MFPL_PA4MFP_GPIO@GPA_MFPL', 'ADC_CH4:SYS_GPA_MFPL_PA4MFP_ADC_CH4@GPA_MFPL', 'I2C0_SDA:SYS_GPA_MFPL_PA4MFP_I2C0_SDA@GPA_MFPL', 'SPI3_MISO0:SYS_GPA_MFPL_PA4MFP_SPI3_MISO0@GPA_MFPL'] },
	{ f: ['PA.5', 'GPIO:SYS_GPA_MFPL_PA5MFP_GPIO@GPA_MFPL', 'ADC_CH5:SYS_GPA_MFPL_PA5MFP_ADC_CH5@GPA_MFPL', 'I2C0_SCL:SYS_GPA_MFPL_PA5MFP_I2C0_SCL@GPA_MFPL', 'SPI3_CLK:SYS_GPA_MFPL_PA5MFP_SPI3_CLK@GPA_MFPL'] },
	{ f: ['PA.6', 'GPIO:SYS_GPA_MFPL_PA6MFP_GPIO@GPA_MFPL', 'ADC_CH6:SYS_GPA_MFPL_PA6MFP_ADC_CH6@GPA_MFPL', 'ACMP0_O:SYS_GPA_MFPL_PA6MFP_ACMP0_O@GPA_MFPL', 'TM3_EXT:SYS_GPA_MFPL_PA6MFP_TM3_EXT@GPA_MFPL', 'TM3_CNT:SYS_GPA_MFPL_PA6MFP_TM3_CNT@GPA_MFPL', 'PWM0_CH3:SYS_GPA_MFPL_PA6MFP_PWM0_CH3@GPA_MFPL', 'SPI3_SS0:SYS_GPA_MFPL_PA6MFP_SPI3_SS0@GPA_MFPL', 'TM3_OUT:SYS_GPA_MFPL_PA6MFP_TM3_OUT@GPA_MFPL'] },
	{ f: ['PA.7', 'GPIO:SYS_GPA_MFPL_PA7MFP_GPIO@GPA_MFPL'] },
	{ f: ['PA.8', 'GPIO:SYS_GPA_MFPH_PA8MFP_GPIO@GPA_MFPH', 'I2C0_SDA:SYS_GPA_MFPH_PA8MFP_I2C0_SDA@GPA_MFPH', 'TM0_CNT:SYS_GPA_MFPH_PA8MFP_TM0_CNT@GPA_MFPH', 'SC0_CLK:SYS_GPA_MFPH_PA8MFP_SC0_CLK@GPA_MFPH', 'SPI2_SS0:SYS_GPA_MFPH_PA8MFP_SPI2_SS0@GPA_MFPH', 'TM0_OUT:SYS_GPA_MFPH_PA8MFP_TM0_OUT@GPA_MFPH', 'UART1_nCTS:SYS_GPA_MFPH_PA8MFP_UART1_nCTS@GPA_MFPH'] },
	{ f: ['PA.9', 'GPIO:SYS_GPA_MFPH_PA9MFP_GPIO@GPA_MFPH', 'I2C0_SCL:SYS_GPA_MFPH_PA9MFP_I2C0_SCL@GPA_MFPH', 'TM1_CNT:SYS_GPA_MFPH_PA9MFP_TM1_CNT@GPA_MFPH', 'SC0_DAT:SYS_GPA_MFPH_PA9MFP_SC0_DAT@GPA_MFPH', 'SPI2_CLK:SYS_GPA_MFPH_PA9MFP_SPI2_CLK@GPA_MFPH', 'TM1_OUT:SYS_GPA_MFPH_PA9MFP_TM1_OUT@GPA_MFPH', 'UART1_nRTS:SYS_GPA_MFPH_PA9MFP_UART1_nRTS@GPA_MFPH', 'SNOOPER:SYS_GPA_MFPH_PA9MFP_SNOOPER@GPA_MFPH'] },
	{ f: ['PA.10', 'GPIO:SYS_GPA_MFPH_PA10MFP_GPIO@GPA_MFPH', 'I2C1_SDA:SYS_GPA_MFPH_PA10MFP_I2C1_SDA@GPA_MFPH', 'TM2_CNT:SYS_GPA_MFPH_PA10MFP_TM2_CNT@GPA_MFPH', 'SC0_PWR:SYS_GPA_MFPH_PA10MFP_SC0_PWR@GPA_MFPH', 'SPI2_MISO0:SYS_GPA_MFPH_PA10MFP_SPI2_MISO0@GPA_MFPH', 'TM2_OUT:SYS_GPA_MFPH_PA10MFP_TM2_OUT@GPA_MFPH'] },
	{ f: ['PA.11', 'GPIO:SYS_GPA_MFPH_PA11MFP_GPIO@GPA_MFPH', 'I2C1_SCL:SYS_GPA_MFPH_PA11MFP_I2C1_SCL@GPA_MFPH', 'TM3_CNT:SYS_GPA_MFPH_PA11MFP_TM3_CNT@GPA_MFPH', 'SC0_RST:SYS_GPA_MFPH_PA11MFP_SC0_RST@GPA_MFPH', 'SPI2_MOSI0:SYS_GPA_MFPH_PA11MFP_SPI2_MOSI0@GPA_MFPH', 'TM3_OUT:SYS_GPA_MFPH_PA11MFP_TM3_OUT@GPA_MFPH'] },
	{ f: ['PA.12', 'GPIO:SYS_GPA_MFPH_PA12MFP_GPIO@GPA_MFPH', 'PWM0_CH0:SYS_GPA_MFPH_PA12MFP_PWM0_CH0@GPA_MFPH', 'TM0_EXT:SYS_GPA_MFPH_PA12MFP_TM0_EXT@GPA_MFPH', 'I2C0_SDA:SYS_GPA_MFPH_PA12MFP_I2C0_SDA@GPA_MFPH'] },
	{ f: ['PA.13', 'GPIO:SYS_GPA_MFPH_PA13MFP_GPIO@GPA_MFPH', 'PWM0_CH1:SYS_GPA_MFPH_PA13MFP_PWM0_CH1@GPA_MFPH', 'TM1_EXT:SYS_GPA_MFPH_PA13MFP_TM1_EXT@GPA_MFPH', 'I2C0_SCL:SYS_GPA_MFPH_PA13MFP_I2C0_SCL@GPA_MFPH'] },
	{ f: ['PA.14', 'GPIO:SYS_GPA_MFPH_PA14MFP_GPIO@GPA_MFPH', 'PWM0_CH2:SYS_GPA_MFPH_PA14MFP_PWM0_CH2@GPA_MFPH', 'I2C1_SDA:SYS_GPA_MFPH_PA14MFP_I2C1_SDA@GPA_MFPH', 'TM2_EXT:SYS_GPA_MFPH_PA14MFP_TM2_EXT@GPA_MFPH', 'TM2_CNT:SYS_GPA_MFPH_PA14MFP_TM2_CNT@GPA_MFPH', 'UART0_RXD:SYS_GPA_MFPH_PA14MFP_UART0_RXD@GPA_MFPH', 'TM2_OUT:SYS_GPA_MFPH_PA14MFP_TM2_OUT@GPA_MFPH'] },
	{ f: ['PA.15', 'GPIO:SYS_GPA_MFPH_PA15MFP_GPIO@GPA_MFPH', 'PWM0_CH3:SYS_GPA_MFPH_PA15MFP_PWM0_CH3@GPA_MFPH', 'I2C1_SCL:SYS_GPA_MFPH_PA15MFP_I2C1_SCL@GPA_MFPH', 'TM3_EXT:SYS_GPA_MFPH_PA15MFP_TM3_EXT@GPA_MFPH', 'SC0_PWR:SYS_GPA_MFPH_PA15MFP_SC0_PWR@GPA_MFPH', 'TM3_CNT:SYS_GPA_MFPH_PA15MFP_TM3_CNT@GPA_MFPH', 'UART0_TXD:SYS_GPA_MFPH_PA15MFP_UART0_TXD@GPA_MFPH', 'TM3_OUT:SYS_GPA_MFPH_PA15MFP_TM3_OUT@GPA_MFPH'] },

	{ f: ['PB.0', 'GPIO:SYS_GPB_MFPL_PB0MFP_GPIO@GPB_MFPL', 'UART0_RXD:SYS_GPB_MFPL_PB0MFP_UART0_RXD@GPB_MFPL', 'SPI1_MOSI0:SYS_GPB_MFPL_PB0MFP_SPI1_MOSI0@GPB_MFPL'] },
	{ f: ['PB.1', 'GPIO:SYS_GPB_MFPL_PB1MFP_GPIO@GPB_MFPL', 'UART0_TXD:SYS_GPB_MFPL_PB1MFP_UART0_TXD@GPB_MFPL', 'SPI1_MISO0:SYS_GPB_MFPL_PB1MFP_SPI1_MISO0@GPB_MFPL'] },
	{ f: ['PB.2', 'GPIO:SYS_GPB_MFPL_PB2MFP_GPIO@GPB_MFPL', 'UART0_nRTS:SYS_GPB_MFPL_PB2MFP_UART0_nRTS@GPB_MFPL', 'SPI1_CLK:SYS_GPB_MFPL_PB2MFP_SPI1_CLK@GPB_MFPL', 'CLKO:SYS_GPB_MFPL_PB2MFP_CLKO@GPB_MFPL'] },
	{ f: ['PB.3', 'GPIO:SYS_GPB_MFPL_PB3MFP_GPIO@GPB_MFPL', 'UART0_nCTS:SYS_GPB_MFPL_PB3MFP_UART0_nCTS@GPB_MFPL', 'SPI1_SS0:SYS_GPB_MFPL_PB3MFP_SPI1_SS0@GPB_MFPL', 'SC1_CD:SYS_GPB_MFPL_PB3MFP_SC1_CD@GPB_MFPL'] },
	{ f: ['PB.4', 'GPIO:SYS_GPB_MFPL_PB4MFP_GPIO@GPB_MFPL', 'UART1_RXD:SYS_GPB_MFPL_PB4MFP_UART1_RXD@GPB_MFPL', 'SC0_CD:SYS_GPB_MFPL_PB4MFP_SC0_CD@GPB_MFPL', 'SPI2_SS0:SYS_GPB_MFPL_PB4MFP_SPI2_SS0@GPB_MFPL', 'RTC_HZ:SYS_GPB_MFPL_PB4MFP_RTC_HZ@GPB_MFPL'] },
	{ f: ['PB.5', 'GPIO:SYS_GPB_MFPL_PB5MFP_GPIO@GPB_MFPL', 'UART1_TXD:SYS_GPB_MFPL_PB5MFP_UART1_TXD@GPB_MFPL', 'SC0_RST:SYS_GPB_MFPL_PB5MFP_SC0_RST@GPB_MFPL', 'SPI2_CLK:SYS_GPB_MFPL_PB5MFP_SPI2_CLK@GPB_MFPL'] },
	{ f: ['PB.6', 'GPIO:SYS_GPB_MFPL_PB6MFP_GPIO@GPB_MFPL', 'UART1_nRTS:SYS_GPB_MFPL_PB6MFP_UART1_nRTS@GPB_MFPL', 'SPI2_MISO0:SYS_GPB_MFPL_PB6MFP_SPI2_MISO0@GPB_MFPL'] },
	{ f: ['PB.7', 'GPIO:SYS_GPB_MFPL_PB7MFP_GPIO@GPB_MFPL', 'UART1_nCTS:SYS_GPB_MFPL_PB7MFP_UART1_nCTS@GPB_MFPL', 'SPI2_MOSI0:SYS_GPB_MFPL_PB7MFP_SPI2_MOSI0@GPB_MFPL'] },
	{ f: ['PB.8', 'GPIO:SYS_GPB_MFPH_PB8MFP_GPIO@GPB_MFPH', 'STADC:SYS_GPB_MFPH_PB8MFP_STADC@GPB_MFPH', 'TM0_CNT:SYS_GPB_MFPH_PB8MFP_TM0_CNT@GPB_MFPH', 'INT0:SYS_GPB_MFPH_PB8MFP_INT0@GPB_MFPH', 'TM0_OUT:SYS_GPB_MFPH_PB8MFP_TM0_OUT@GPB_MFPH', 'SNOOPER:SYS_GPB_MFPH_PB8MFP_SNOOPER@GPB_MFPH'] },
	{ f: ['PB.9', 'GPIO:SYS_GPB_MFPH_PB9MFP_GPIO@GPB_MFPH', 'SPI1_SS1:SYS_GPB_MFPH_PB9MFP_SPI1_SS1@GPB_MFPH', 'TM1_CNT:SYS_GPB_MFPH_PB9MFP_TM1_CNT@GPB_MFPH', 'TM1_OUT:SYS_GPB_MFPH_PB9MFP_TM1_OUT@GPB_MFPH', 'INT0:SYS_GPB_MFPH_PB9MFP_INT0@GPB_MFPH'] },
	{ f: ['PB.10', 'GPIO:SYS_GPB_MFPH_PB10MFP_GPIO@GPB_MFPH', 'SPI0_MOSI0:SYS_GPB_MFPH_PB10MFP_SPI0_MOSI0@GPB_MFPH', 'TM2_CNT:SYS_GPB_MFPH_PB10MFP_TM2_CNT@GPB_MFPH', 'TM2_OUT:SYS_GPB_MFPH_PB10MFP_TM2_OUT@GPB_MFPH', 'SPI0_SS1:SYS_GPB_MFPH_PB10MFP_SPI0_SS1@GPB_MFPH'] },
	{ f: ['PB.11', 'GPIO:SYS_GPB_MFPH_PB11MFP_GPIO@GPB_MFPH', 'PWM0_CH4:SYS_GPB_MFPH_PB11MFP_PWM0_CH4@GPB_MFPH', 'TM3_CNT:SYS_GPB_MFPH_PB11MFP_TM3_CNT@GPB_MFPH', 'TM3_OUT:SYS_GPB_MFPH_PB11MFP_TM3_OUT@GPB_MFPH', 'SPI0_MISO0:SYS_GPB_MFPH_PB11MFP_SPI0_MISO0@GPB_MFPH'] },
	{ f: ['PB.12', 'GPIO:SYS_GPB_MFPH_PB12MFP_GPIO@GPB_MFPH'] },
	{ f: ['PB.13', 'GPIO:SYS_GPB_MFPH_PB13MFP_GPIO@GPB_MFPH', 'SPI2_MISO1:SYS_GPB_MFPH_PB13MFP_SPI2_MISO1@GPB_MFPH', 'SNOOPER:SYS_GPB_MFPH_PB13MFP_SNOOPER@GPB_MFPH'] },
	{ f: ['PB.14', 'GPIO:SYS_GPB_MFPH_PB14MFP_GPIO@GPB_MFPH', 'INT0:SYS_GPB_MFPH_PB14MFP_INT0@GPB_MFPH', 'SPI2_MOSI1:SYS_GPB_MFPH_PB14MFP_SPI2_MOSI1@GPB_MFPH', 'SPI2_SS1:SYS_GPB_MFPH_PB14MFP_SPI2_SS1@GPB_MFPH'] },
	{ f: ['PB.15', 'GPIO:SYS_GPB_MFPH_PB15MFP_GPIO@GPB_MFPH', 'INT1:SYS_GPB_MFPH_PB15MFP_INT1@GPB_MFPH', 'SNOOPER:SYS_GPB_MFPH_PB15MFP_SNOOPER@GPB_MFPH', 'SC1_CD:SYS_GPB_MFPH_PB15MFP_SC1_CD@GPB_MFPH'] },

	{ f: ['PC.0', 'GPIO:SYS_GPC_MFPL_PC0MFP_GPIO@GPC_MFPL', 'SPI0_SS0:SYS_GPC_MFPL_PC0MFP_SPI0_SS0@GPC_MFPL', 'SC1_CLK:SYS_GPC_MFPL_PC0MFP_SC1_CLK@GPC_MFPL', 'PWM0_BRAKE1:SYS_GPC_MFPL_PC0MFP_PWM0_BRAKE1@GPC_MFPL'] },
	{ f: ['PC.1', 'GPIO:SYS_GPC_MFPL_PC1MFP_GPIO@GPC_MFPL', 'SPI0_CLK:SYS_GPC_MFPL_PC1MFP_SPI0_CLK@GPC_MFPL', 'SC1_DAT:SYS_GPC_MFPL_PC1MFP_SC1_DAT@GPC_MFPL', 'PWM0_BRAKE0:SYS_GPC_MFPL_PC1MFP_PWM0_BRAKE0@GPC_MFPL'] },
	{ f: ['PC.2', 'GPIO:SYS_GPC_MFPL_PC2MFP_GPIO@GPC_MFPL', 'SPI0_MISO0:SYS_GPC_MFPL_PC2MFP_SPI0_MISO0@GPC_MFPL', 'SC1_PWR:SYS_GPC_MFPL_PC2MFP_SC1_PWR@GPC_MFPL', 'PWM0_BRAKE1:SYS_GPC_MFPL_PC2MFP_PWM0_BRAKE1@GPC_MFPL'] },
	{ f: ['PC.3', 'GPIO:SYS_GPC_MFPL_PC3MFP_GPIO@GPC_MFPL', 'SPI0_MOSI0:SYS_GPC_MFPL_PC3MFP_SPI0_MOSI0@GPC_MFPL', 'SC1_RST:SYS_GPC_MFPL_PC3MFP_SC1_RST@GPC_MFPL', 'PWM0_BRAKE0:SYS_GPC_MFPL_PC3MFP_PWM0_BRAKE0@GPC_MFPL'] },
	{ f: ['PC.4', 'GPIO:SYS_GPC_MFPL_PC4MFP_GPIO@GPC_MFPL'] },
	{ f: ['PC.5', 'GPIO:SYS_GPC_MFPL_PC5MFP_GPIO@GPC_MFPL'] },
	{ f: ['PC.6', 'GPIO:SYS_GPC_MFPL_PC6MFP_GPIO@GPC_MFPL', 'UART1_RXD:SYS_GPC_MFPL_PC6MFP_UART1_RXD@GPC_MFPL', 'TM0_EXT:SYS_GPC_MFPL_PC6MFP_TM0_EXT@GPC_MFPL', 'SC1_CD:SYS_GPC_MFPL_PC6MFP_SC1_CD@GPC_MFPL', 'PWM0_CH0:SYS_GPC_MFPL_PC6MFP_PWM0_CH0@GPC_MFPL'] },
	{ f: ['PC.7', 'GPIO:SYS_GPC_MFPL_PC7MFP_GPIO@GPC_MFPL', 'UART1_TXD:SYS_GPC_MFPL_PC7MFP_UART1_TXD@GPC_MFPL', 'ADC_CH7:SYS_GPC_MFPL_PC7MFP_ADC_CH7@GPC_MFPL', 'TM1_EXT:SYS_GPC_MFPL_PC7MFP_TM1_EXT@GPC_MFPL', 'PWM0_CH1:SYS_GPC_MFPL_PC7MFP_PWM0_CH1@GPC_MFPL'] },
	{ f: ['PC.8', 'GPIO:SYS_GPC_MFPH_PC8MFP_GPIO@GPC_MFPH', 'SPI1_SS0:SYS_GPC_MFPH_PC8MFP_SPI1_SS0@GPC_MFPH', 'I2C1_SDA:SYS_GPC_MFPH_PC8MFP_I2C1_SDA@GPC_MFPH'] },
	{ f: ['PC.9', 'GPIO:SYS_GPC_MFPH_PC9MFP_GPIO@GPC_MFPH', 'SPI1_CLK:SYS_GPC_MFPH_PC9MFP_SPI1_CLK@GPC_MFPH', 'I2C1_SCL:SYS_GPC_MFPH_PC9MFP_I2C1_SCL@GPC_MFPH'] },
	{ f: ['PC.10', 'GPIO:SYS_GPC_MFPH_PC10MFP_GPIO@GPC_MFPH', 'SPI1_MISO0:SYS_GPC_MFPH_PC10MFP_SPI1_MISO0@GPC_MFPH', 'UART1_RXD:SYS_GPC_MFPH_PC10MFP_UART1_RXD@GPC_MFPH'] },
	{ f: ['PC.11', 'GPIO:SYS_GPC_MFPH_PC11MFP_GPIO@GPC_MFPH', 'SPI1_MOSI0:SYS_GPC_MFPH_PC11MFP_SPI1_MOSI0@GPC_MFPH', 'UART1_TXD:SYS_GPC_MFPH_PC11MFP_UART1_TXD@GPC_MFPH'] },
	{ f: ['PC.12', 'GPIO:SYS_GPC_MFPH_PC12MFP_GPIO@GPC_MFPH'] },
	{ f: ['PC.13', 'GPIO:SYS_GPC_MFPH_PC13MFP_GPIO@GPC_MFPH'] },
	{ f: ['PC.14', 'GPIO:SYS_GPC_MFPH_PC14MFP_GPIO@GPC_MFPH', 'UART1_nCTS:SYS_GPC_MFPH_PC14MFP_UART1_nCTS@GPC_MFPH'] },
	{ f: ['PC.15', 'GPIO:SYS_GPC_MFPH_PC15MFP_GPIO@GPC_MFPH', 'UART1_nRTS:SYS_GPC_MFPH_PC15MFP_UART1_nRTS@GPC_MFPH', 'TM0_EXT:SYS_GPC_MFPH_PC15MFP_TM0_EXT@GPC_MFPH'] },

	{ f: ['PD.0', 'GPIO:SYS_GPD_MFPL_PD0MFP_GPIO@GPD_MFPL'] },
	{ f: ['PD.1', 'GPIO:SYS_GPD_MFPL_PD1MFP_GPIO@GPD_MFPL'] },
	{ f: ['PD.2', 'GPIO:SYS_GPD_MFPL_PD2MFP_GPIO@GPD_MFPL'] },
	{ f: ['PD.3', 'GPIO:SYS_GPD_MFPL_PD3MFP_GPIO@GPD_MFPL'] },
	{ f: ['PD.4', 'GPIO:SYS_GPD_MFPL_PD4MFP_GPIO@GPD_MFPL'] },
	{ f: ['PD.5', 'GPIO:SYS_GPD_MFPL_PD5MFP_GPIO@GPD_MFPL'] },
	{ f: ['PD.6', 'GPIO:SYS_GPD_MFPL_PD6MFP_GPIO@GPD_MFPL', 'SPI1_MOSI1:SYS_GPD_MFPL_PD6MFP_SPI1_MOSI1@GPD_MFPL', 'SC1_RST:SYS_GPD_MFPL_PD6MFP_SC1_RST@GPD_MFPL'] },
	{ f: ['PD.7', 'GPIO:SYS_GPD_MFPL_PD7MFP_GPIO@GPD_MFPL', 'SPI1_MISO1:SYS_GPD_MFPL_PD7MFP_SPI1_MISO1@GPD_MFPL', 'SC1_PWR:SYS_GPD_MFPL_PD7MFP_SC1_PWR@GPD_MFPL'] },
	{ f: ['PD.8', 'GPIO:SYS_GPD_MFPH_PD8MFP_GPIO@GPD_MFPH'] },
	{ f: ['PD.9', 'GPIO:SYS_GPD_MFPH_PD9MFP_GPIO@GPD_MFPH'] },
	{ f: ['PD.10', 'GPIO:SYS_GPD_MFPH_PD10MFP_GPIO@GPD_MFPH'] },
	{ f: ['PD.11', 'GPIO:SYS_GPD_MFPH_PD11MFP_GPIO@GPD_MFPH'] },
	{ f: ['PD.12', 'GPIO:SYS_GPD_MFPH_PD12MFP_GPIO@GPD_MFPH'] },
	{ f: ['PD.13', 'GPIO:SYS_GPD_MFPH_PD13MFP_GPIO@GPD_MFPH'] },
	{ f: ['PD.14', 'GPIO:SYS_GPD_MFPH_PD14MFP_GPIO@GPD_MFPH', 'SPI0_MOSI1:SYS_GPD_MFPH_PD14MFP_SPI0_MOSI1@GPD_MFPH', 'SC1_DAT:SYS_GPD_MFPH_PD14MFP_SC1_DAT@GPD_MFPH'] },
	{ f: ['PD.15', 'GPIO:SYS_GPD_MFPH_PD15MFP_GPIO@GPD_MFPH', 'SPI0_MISO1:SYS_GPD_MFPH_PD15MFP_SPI0_MISO1@GPD_MFPH', 'SC1_CLK:SYS_GPD_MFPH_PD15MFP_SC1_CLK@GPD_MFPH'] },

	{ f: ['PE.0', 'GPIO:SYS_GPE_MFPL_PE0MFP_GPIO@GPE_MFPL'] },
	{ f: ['PE.1', 'GPIO:SYS_GPE_MFPL_PE1MFP_GPIO@GPE_MFPL'] },
	{ f: ['PE.2', 'GPIO:SYS_GPE_MFPL_PE2MFP_GPIO@GPE_MFPL'] },
	{ f: ['PE.3', 'GPIO:SYS_GPE_MFPL_PE3MFP_GPIO@GPE_MFPL'] },
	{ f: ['PE.4', 'GPIO:SYS_GPE_MFPL_PE4MFP_GPIO@GPE_MFPL'] },
	{ f: ['PE.5', 'GPIO:SYS_GPE_MFPL_PE5MFP_GPIO@GPE_MFPL', 'PWM0_CH5:SYS_GPE_MFPL_PE5MFP_PWM0_CH5@GPE_MFPL', 'RTC_HZ:SYS_GPE_MFPL_PE5MFP_RTC_HZ@GPE_MFPL'] },
	{ f: ['PE.6', 'GPIO:SYS_GPE_MFPL_PE6MFP_GPIO@GPE_MFPL'] },
	{ f: ['PE.7', 'GPIO:SYS_GPE_MFPL_PE7MFP_GPIO@GPE_MFPL'] },
	{ f: ['PE.8', 'GPIO:SYS_GPE_MFPH_PE8MFP_GPIO@GPE_MFPH'] },
	{ f: ['PE.9', 'GPIO:SYS_GPE_MFPH_PE9MFP_GPIO@GPE_MFPH'] },
	{ f: ['PE.10', 'GPIO:SYS_GPE_MFPH_PE10MFP_GPIO@GPE_MFPH'] },
	{ f: ['PE.11', 'GPIO:SYS_GPE_MFPH_PE11MFP_GPIO@GPE_MFPH'] },
	{ f: ['PE.12', 'GPIO:SYS_GPE_MFPH_PE12MFP_GPIO@GPE_MFPH'] },
	{ f: ['PE.13', 'GPIO:SYS_GPE_MFPH_PE13MFP_GPIO@GPE_MFPH'] },
	{ f: ['PE.14', 'GPIO:SYS_GPE_MFPH_PE14MFP_GPIO@GPE_MFPH'] },
	{ f: ['PE.15', 'GPIO:SYS_GPE_MFPH_PE15MFP_GPIO@GPE_MFPH'] },

	{ f: ['PF.0', 'GPIO:SYS_GPF_MFPL_PF0MFP_GPIO@GPF_MFPL', 'INT0:SYS_GPF_MFPL_PF0MFP_INT0@GPF_MFPL', 'ICE_DAT:SYS_GPF_MFPL_PF0MFP_ICE_DAT@GPF_MFPL'] },
	{ f: ['PF.1', 'GPIO:SYS_GPF_MFPL_PF1MFP_GPIO@GPF_MFPL', 'CLKO:SYS_GPF_MFPL_PF1MFP_CLKO@GPF_MFPL', 'INT1:SYS_GPF_MFPL_PF1MFP_INT1@GPF_MFPL', 'ICE_CLK:SYS_GPF_MFPL_PF1MFP_ICE_CLK@GPF_MFPL'] },
	{ f: ['PF.2', 'GPIO:SYS_GPF_MFPL_PF2MFP_GPIO@GPF_MFPL', 'XT1_OUT:SYS_GPF_MFPL_PF2MFP_XT1_OUT@GPF_MFPL'] },
	{ f: ['PF.3', 'GPIO:SYS_GPF_MFPL_PF3MFP_GPIO@GPF_MFPL', 'XT1_IN:SYS_GPF_MFPL_PF3MFP_XT1_IN@GPF_MFPL'] },
	{ f: ['PF.4', 'GPIO:SYS_GPF_MFPL_PF4MFP_GPIO@GPF_MFPL'] },
	{ f: ['PF.5', 'GPIO:SYS_GPF_MFPL_PF5MFP_GPIO@GPF_MFPL'] },
	{ f: ['PF.6', 'GPIO:SYS_GPF_MFPL_PF6MFP_GPIO@GPF_MFPL', 'I2C1_SDA:SYS_GPF_MFPL_PF6MFP_I2C1_SDA@GPF_MFPL', 'X32_OUT:SYS_GPF_MFPL_PF6MFP_X32_OUT@GPF_MFPL'] },
	{ f: ['PF.7', 'GPIO:SYS_GPF_MFPL_PF7MFP_GPIO@GPF_MFPL', 'I2C1_SCL:SYS_GPF_MFPL_PF7MFP_I2C1_SCL@GPF_MFPL', 'SC0_CD:SYS_GPF_MFPL_PF7MFP_SC0_CD@GPF_MFPL', 'X32_IN:SYS_GPF_MFPL_PF7MFP_X32_IN@GPF_MFPL'] }
];

NUTOOL_PIN.g_cfg_gpiosDescriptions = [
	'ACMP0_N:Comparator0 N-end input',
	'ACMP0_O:Comparator0 output',
	'ACMP0_P:Comparator0 P-end input',
	'ADC_CH0:ADC analog input0',
	'ADC_CH1:ADC analog input1',
	'ADC_CH2:ADC analog input2',
	'ADC_CH3:ADC analog input3',
	'ADC_CH4:ADC analog input4',
	'ADC_CH5:ADC analog input5',
	'ADC_CH6:ADC analog input6',
	'ADC_CH7:ADC analog input7',
	'AVDD:Power supply for internal analog circuit',
	'AVSS:Ground pin for analog circuit',
	'CLKO:Frequency Divider output pin',
	'I2C0_SCL:I2C0 clock pin',
	'I2C0_SDA:I2C0 data input/output pin',
	'I2C1_SCL:I2C1 clock pin',
	'I2C1_SDA:I2C1 data input/output pin',
	'ICE_CLK:Serial wired debugger clock pin',
	'ICE_DAT:Serial wired debugger data pin',
	'INT0:External interrupt0 input pin',
	'INT1:External interrupt1 input pin',
	'LDO_CAP:LDO output pin',
	'nRESET:External reset input: active LOW, with an internal pull-up. Set this pin low reset to initial state',
	'PWM0_BRAKE0:PWM0 Brake0 input pin',
	'PWM0_BRAKE1:PWM0 Brake1 input pin',
	'PWM0_CH0:PWM0 channel0 output/capture input',
	'PWM0_CH1:PWM0 channel1 output/capture input',
	'PWM0_CH2:PWM0 channel2 output/capture input',
	'PWM0_CH3:PWM0 channel3 output/capture input',
	'PWM0_CH4:PWM0 channel4 output/capture input',
	'PWM0_CH5:PWM0 channel5 output/capture input',
	'RTC_HZ:RTC 1Hz output',
	'SC0_CD:SmartCard0 card detect pin',
	'SC0_CLK:SmartCard0 clock pin',
	'SC0_DAT:SmartCard0 data pin',
	'SC0_PWR:SmartCard0 power pin',
	'SC0_RST:SmartCard0 reset pin',
	'SC1_CD:SmartCard1 card detect pin',
	'SC1_CLK:SmartCard1 clock pin',
	'SC1_DAT:SmartCard1 data pin',
	'SC1_PWR:SmartCard1 power pin',
	'SC1_RST:SmartCard1 reset pin',
	'SNOOPER:Snooper pin',
	'SPI0_CLK:SPI0 serial clock pin',
	'SPI0_MISO0:SPI0 1st MISO (Master In, Slave Out) pin',
	'SPI0_MISO1:SPI0 2nd MISO (Master In, Slave Out) pin',
	'SPI0_MOSI0:SPI0 1st MOSI (Master Out, Slave In) pin',
	'SPI0_MOSI1:SPI0 2nd MOSI (Master Out, Slave In) pin',
	'SPI0_SS0:SPI0 1st slave select pin',
	'SPI0_SS1:SPI0 2nd slave select pin',
	'SPI1_CLK:SPI1 serial clock pin',
	'SPI1_MISO0:SPI1 1st MISO (Master In, Slave Out) pin',
	'SPI1_MISO1:SPI1 2nd MISO (Master In, Slave Out) pin',
	'SPI1_MOSI0:SPI1 1st MOSI (Master Out, Slave In) pin',
	'SPI1_MOSI1:SPI1 2nd MOSI (Master Out, Slave In) pin',
	'SPI1_SS0:SPI1 1st slave select pin',
	'SPI1_SS1:SPI1 1st slave select pin',
	'SPI2_CLK:SPI2 serial clock pin',
	'SPI2_MISO0:SPI2 1st MISO (Master In, Slave Out) pin',
	'SPI2_MISO1:SPI2 2nd MISO (Master In, Slave Out) pin',
	'SPI2_MOSI0:SPI2 1st MOSI (Master Out, Slave In) pin',
	'SPI2_MOSI1:SPI2 2nd MOSI (Master Out, Slave In) pin',
	'SPI2_SS0:SPI2 1st slave select pin',
	'SPI2_SS1:SPI2 2nd slave select pin',
	'SPI3_CLK:SPI3 serial clock pin',
	'SPI3_MISO0:SPI3 1st MISO (Master In, Slave Out) pin',
	'SPI3_MISO1:SPI3 2nd MISO (Master In, Slave Out) pin',
	'SPI3_MOSI0:SPI3 1st MOSI (Master Out, Slave In) pin',
	'SPI3_MOSI1:SPI3 2nd MOSI (Master Out, Slave In) pin',
	'SPI3_SCLK:SPI3 serial clock pin', 
	'SPI3_SS0:SPI3 1st slave select pin',
	'STADC:ADC external trigger input',
	'TM0_CNT:Timer0 event counter input',
	'TM0_EXT:Timer0 external capture input',
	'TM0_OUT:Timer0 toggle output',
	'TM1_CNT:Timer1 event counter input',
	'TM1_EXT:Timer1 external capture input',
	'TM1_OUT:Timer1 toggle output',
	'TM2_CNT:Timer2 event counter input',
	'TM2_EXT:Timer2 external capture input',
	'TM2_OUT:Timer2 toggle output',
	'TM3_CNT:Timer3 event counter input',
	'TM3_EXT:Timer3 external capture input',
	'TM3_OUT:Timer3 toggle output',
	'UART0_nCTS:UART0 Clear to Send input pin',
	'UART0_nRTS:UART0 Request to Send output pin',
	'UART0_RXD:Data receiver input pin for UART0',
	'UART0_TXD:Data transmitter output pin for UART0',
	'UART1_nCTS:UART1 Clear to Send input pin',
	'UART1_nRTS:UART1 Request to Send output pin',
	'UART1_RXD:Data receiver input pin for UART1',
	'UART1_TXD:Data transmitter output pin for UART1',
	'VBAT:Power supply for tamper pin (LQFP64: PB.13/LQFP48: PA.9/QFN32: PB.8) and RTC',
	'VDD:Power supply for I/O ports and LDO source for internal PLL and digital function',
	'VREF:Voltage reference input for ADC',
	'VSS:Ground pin for digital circuit',
	'X32_IN:External 32.768 kHz crystal input pin(default)',
	'X32_OUT:External 32.768 kHz crystal output pin(default)',
	'XT1_IN:External 4~24 MHz (high speed) crystal input pin',
	'XT1_OUT:External 4~24 MHz (high speed) crystal output pin'
];

NUTOOL_PIN.g_cfg_regDescriptions = {};
NUTOOL_PIN.g_cfg_regDescriptions.GPA_MFPL = '0x50000030';
NUTOOL_PIN.g_cfg_regDescriptions.GPA_MFPH = '0x50000034';
NUTOOL_PIN.g_cfg_regDescriptions.GPB_MFPL = '0x50000038';
NUTOOL_PIN.g_cfg_regDescriptions.GPB_MFPH = '0x5000003C';
NUTOOL_PIN.g_cfg_regDescriptions.GPC_MFPL = '0x50000040';
NUTOOL_PIN.g_cfg_regDescriptions.GPC_MFPH = '0x50000044';
NUTOOL_PIN.g_cfg_regDescriptions.GPD_MFPL = '0x50000048';
NUTOOL_PIN.g_cfg_regDescriptions.GPD_MFPH = '0x5000004C';
NUTOOL_PIN.g_cfg_regDescriptions.GPE_MFPL = '0x50000050';
NUTOOL_PIN.g_cfg_regDescriptions.GPF_MFPL = '0x50000058';

NUTOOL_PIN.g_cfg_gpioMatrix = [];
NUTOOL_PIN.g_cfg_shareBits = [];
NUTOOL_PIN.g_cfg_addGPIO = {};
NUTOOL_PIN.g_cfg_unusedGPIO = {};

NUTOOL_PIN.decidepackageNumber = function (given_partNumber_package) {
	var partNumber_package;

	if (typeof given_partNumber_package === 'undefined') {
		partNumber_package = NUTOOL_PIN.getg_partNumber_package();
	}
	else {
		partNumber_package = given_partNumber_package;
	}

	NUTOOL_PIN.g_packageNumber = partNumber_package.substring(partNumber_package.indexOf('(') + 1);
	NUTOOL_PIN.g_packageNumber = NUTOOL_PIN.g_packageNumber.substring(0, NUTOOL_PIN.g_packageNumber.indexOf(')'));
	NUTOOL_PIN.g_packageNumberIndex = NUTOOL_PIN.g_packageNumber;

	partNumber_package = null;
};
