NUTOOL_PIN.g_cfg_chips = [
	//NUC100CN
	{ name: "NUC130VE3CN", pkg: "LQFP100" },
	{ name: "NUC140VE3CN", pkg: "LQFP100" },
	{ name: "NUC130RC1CN", pkg: "LQFP64" },
	{ name: "NUC130RD2CN", pkg: "LQFP64" },
	{ name: "NUC130RE3CN", pkg: "LQFP64" },
	{ name: "NUC140RC1CN", pkg: "LQFP64" },
	{ name: "NUC140RD2CN", pkg: "LQFP64" },
	{ name: "NUC140RE3CN", pkg: "LQFP64" },
	{ name: "NUC130LC1CN", pkg: "LQFP48" },
	{ name: "NUC130LD2CN", pkg: "LQFP48" },
	{ name: "NUC130LE3CN", pkg: "LQFP48" },
	{ name: "NUC140LC1CN", pkg: "LQFP48" },
	{ name: "NUC140LD2CN", pkg: "LQFP48" },
	{ name: "NUC140LE3CN", pkg: "LQFP48" },
	//NUC100DN
	{ name: "NUC100VE3DN", pkg: "LQFP100" },
	{ name: "NUC100RC1DN", pkg: "LQFP64" },
	{ name: "NUC100RD1DN", pkg: "LQFP64" },
	{ name: "NUC100RD2DN", pkg: "LQFP64" },
	{ name: "NUC100RE3DN", pkg: "LQFP64" },
	{ name: "NUC100LC1DN", pkg: "LQFP48" },
	{ name: "NUC100LD2DN", pkg: "LQFP48" },
	{ name: "NUC100LE3DN", pkg: "LQFP48" },
	{ name: "NUC120VE3DN", pkg: "LQFP100" },
	{ name: "NUC120RC1DN", pkg: "LQFP64" },
	{ name: "NUC120RD2DN", pkg: "LQFP64" },
	{ name: "NUC120RE3DN", pkg: "LQFP64" },
	{ name: "NUC120LC1DN", pkg: "LQFP48" },
	{ name: "NUC120LD2DN", pkg: "LQFP48" },
	{ name: "NUC120LE3DN", pkg: "LQFP48" },
	//NUC121AE
	{ name: "NUC121SC2AE", pkg: "LQFP64" },
	{ name: "NUC121LC2AE", pkg: "LQFP48" },
	{ name: "NUC121ZC2AE", pkg: "QFN33" },
	{ name: "NUC125SC2AE", pkg: "LQFP64" },
	{ name: "NUC125LC2AE", pkg: "LQFP48" },
	{ name: "NUC125ZC2AE", pkg: "QFN33" },
	//NUC123AE
	{ name: "NUC123ZD4AE0", pkg: "QFN33" },
	{ name: "NUC123ZC2AE1", pkg: "QFN33" },
	{ name: "NUC123SD4AE0", pkg: "LQFP64" },
	{ name: "NUC123SC2AE1", pkg: "LQFP64" },
	{ name: "NUC123LD4AE0", pkg: "LQFP48" },
	{ name: "NUC123LC2AE1", pkg: "LQFP48" },
	//NUC123AN
	{ name: "NUC123ZD4AN0", pkg: "QFN33" },
	{ name: "NUC123ZC2AN1", pkg: "QFN33" },
	{ name: "NUC123LD4AN0", pkg: "LQFP48" },
	{ name: "NUC123LC2AN1", pkg: "LQFP48" },
	{ name: "NUC123SD4AN0", pkg: "LQFP64" },
	{ name: "NUC123SC2AN1", pkg: "LQFP64" },
	// NUC126
	{ name: "NUC126LE4AE", pkg: "LQFP48" },
	{ name: "NUC126LG4AE", pkg: "LQFP48" },
	{ name: "NUC126SE4AE", pkg: "LQFP64" },
	{ name: "NUC126SG4AE", pkg: "LQFP64" },
	{ name: "NUC126VG4AE", pkg: "LQFP100" },
	{ name: "NUC126NE4AE", pkg: "QFN48" },
	// NUC1261
	{ name: "NUC1261LG4AE", pkg: "LQFP48" },
	{ name: "NUC1261LE4AE", pkg: "LQFP48" },
	{ name: "NUC1261NE4AE", pkg: "LQFP48" },
	{ name: "NUC1261SG4AE", pkg: "LQFP64" },
	{ name: "NUC1261SE4AE", pkg: "LQFP64" },
	// NUC1262
	{ name: "NUC1262NE4AE", pkg: "QFN48" },
	{ name: "NUC1262LE4AE", pkg: "LQFP48" },
	{ name: "NUC1262SE4AE", pkg: "LQFP64" },
	//NUC131
	{ name: "NUC131SC2AE", pkg: "LQFP64" },
	{ name: "NUC131SD2AE", pkg: "LQFP64" },
	{ name: "NUC131LC2AE", pkg: "LQFP48" },
	{ name: "NUC131LD2AE", pkg: "LQFP48" },
	{ name: "NUC131SC2AEU", pkg: "LQFP64" },
	{ name: "NUC131SD2AEU", pkg: "LQFP64" },
	{ name: "NUC131LC2AEU", pkg: "LQFP48" },
	{ name: "NUC131LD2AEU", pkg: "LQFP48" },
	//NUC1311
	{ name: "NUC1311LD2AE", pkg: "LQFP48" }
];

NUTOOL_PIN.g_cfg_pkgs = {
	"LQFP64": [
		'PB.14', 'PB.13', 'PB.12', 'PA.11', 'PA.10', 'PD.8', 'PD.9', 'PD.10', 'PD.11', 'PB.4',
		'PB.5', 'PB.6', 'PB.7', 'LDO_CAP', 'VDD', 'VSS',
		'USB_VBUS', 'USB_VDD33_CAP', 'USB_D-', 'USB_D+', 'PB.0', 'PB.1', 'PB.2', 'PB.3', 'PC.5', 'PC.4',
		'PC.3', 'PC.2', 'PC.1', 'PC.0', 'PB.10', 'PB.9',
		'PE.2', 'PC.13', 'PC.12', 'PC.11', 'PC.10', 'PE.1', 'PC.9', 'PC.8', 'PA.15', 'PE.0',
		'PA.14', 'PA.13', 'PA.12', 'PF.4', 'PF.5', 'AVDD',
		'PD.0', 'PD.1', 'PD.2', 'PD.3', 'PD.4', 'PD.5', 'PB.15', 'PF.0', 'PF.1', 'nRESET',
		'VSS', 'VDD', 'PF.2', 'PF.3', 'VSS', 'PB.8'
	],
	"LQFP48": [
		'VSS', 'PB.8', 'PB.14', 'PA.11', 'PA.10', 'PB.4', 'PB.5', 'PB.6', 'PB.7', 'LDO_CAP',
		'VDD', 'VSS',
		'USB_VBUS', 'USB_VDD33_CAP', 'USB_D-', 'USB_D+', 'PC.5', 'PC.4', 'PC.3', 'PC.2', 'PC.1', 'PC.0',
		'PB.10', 'PB.9',
		'PC.13', 'PC.12', 'PC.11', 'PC.10', 'PC.9', 'PC.8', 'PA.15', 'PA.14', 'PA.13', 'PA.12',
		'PF.4', 'PF.5',
		'AVDD', 'PD.0', 'PD.1', 'PD.2', 'PD.3', 'PD.4', 'PD.5', 'PF.0', 'PF.1', 'nRESET',
		'PF.2', 'PF.3'
	],
	"QFN33": [
		'PB.14', 'PA.11', 'PA.10', 'PB.4', 'PB.5', 'LDO_CAP', 'VDD', 'VSS',
		'USB_VBUS', 'USB_VDD33_CAP', 'USB_D-', 'USB_D+', 'PC.3', 'PC.2', 'PC.1', 'PC.0',
		'PC.13', 'PC.12', 'PC.11', 'PC.10', 'PC.9', 'PC.8', 'PF.4', 'PF.5',
		'AVDD', 'PD.1', 'PD.2', 'PD.3', 'PF.0', 'PF.1', 'nRESET', 'VSS'
	],
	"LQFP64(1.8 I/O)": [
		'PB.14', 'PB.13', 'PB.12', 'PA.11', 'PA.10', 'PD.8', 'PD.9', 'PD.10', 'PD.11', 'PB.4',
		'PB.5', 'PB.6', 'PB.7', 'LDO_CAP', 'VDD', 'VSS',
		'USB_VBUS', 'USB_VDD33_CAP', 'USB_D-', 'USB_D+', 'PB.0', 'PB.1', 'PB.2', 'PB.3', 'PC.5', 'PC.4',
		'PC.3', 'PC.2', 'PC.1', 'PC.0', 'PB.10', 'PB.9',
		'PE.2', 'PC.13', 'PC.12', 'PC.11', 'PC.10', 'PE.1', 'PC.9', 'PC.8', 'PA.15', 'PE.0',
		'PA.14', 'PA.13', 'PA.12', 'PF.4', 'PF.5', 'AVDD',
		'PD.0', 'PD.1', 'PD.2', 'PD.3', 'PD.4', 'PD.5', 'PB.15', 'PF.0', 'PF.1', 'nRESET',
		'VSS', 'VDD', 'PF.2', 'PF.3', 'VSS', 'VDDIO'
	],
	"ILQFP48(1.8 I/O)": [
		'VSS', 'VDDIO', 'PB.14', 'PA.11', 'PA.10', 'PB.4', 'PB.5', 'PB.6', 'PB.7', 'LDO_CAP',
		'VDD', 'VSS',
		'USB_VBUS', 'USB_VDD33_CAP', 'USB_D-', 'USB_D+', 'PC.5', 'PC.4', 'PC.3', 'PC.2', 'PC.1', 'PC.0',
		'PB.10', 'PB.9',
		'PC.13', 'PC.12', 'PC.11', 'PC.10', 'PC.9', 'PC.8', 'PA.15', 'PA.14', 'PA.13', 'PA.12',
		'PF.4', 'PF.5',
		'AVDD', 'PD.0', 'PD.1', 'PD.2', 'PD.3', 'PD.4', 'PD.5', 'PF.0', 'PF.1', 'nRESET',
		'PF.2', 'PF.3'
	],
	"IQFN33(1.8 I/O)": [
		'PB.14', 'PA.11', 'PA.10', 'PB.4', 'PB.5', 'LDO_CAP', 'VDD', 'VSS',
		'USB_VBUS', 'USB_VDD33_CAP', 'USB_D-', 'USB_D+', 'PC.3', 'PC.2', 'PC.1', 'PC.0',
		'PC.13', 'PC.12', 'PC.11', 'PC.10', 'PC.9', 'PC.8', 'PF.4', 'PF.5',
		'AVDD', 'PD.1', 'PD.2', 'PD.3', 'PF.0', 'PF.1', 'nRESET', 'VDDIO'
	]
};

NUTOOL_PIN.g_cfg_gpios = [
	{ f: ['PA.0:0'] },
	{ f: ['PA.1:0'] },
	{ f: ['PA.2:0'] },
	{ f: ['PA.3:0'] },
	{ f: ['PA.4:0'] },
	{ f: ['PA.5:0'] },
	{ f: ['PA.6:0'] },
	{ f: ['PA.7:0'] },
	{ f: ['PA.8:0'] },
	{ f: ['PA.9:0'] },
	{ f: ['PA.10:0', 'I2C1_SDA:1', 'BPWM0_CH4:4', 'PWM0_BRAKE0:5', 'USCI0_DAT1:6'] },
	{ f: ['PA.11:0', 'I2C1_SCL:1', 'BPWM0_CH5:4', 'TM0:5', 'USCI0_CLK:6', 'USCI0_DAT0:7'] },
	{ f: ['PA.12:0', 'PWM0_CH0:1', 'I2C1_SCL:2', 'UART0_RXD:3'] },
	{ f: ['PA.13:0', 'PWM0_CH1:1', 'I2C1_SDA:2', 'UART0_TXD:3'] },
	{ f: ['PA.14:0', 'PWM0_CH2:1', 'UART0_nCTS:3', 'PWM0_BRAKE0:4'] },
	{ f: ['PA.15:0', 'PWM0_CH3:1', 'SPI_I2SMCLK:2', 'CLKO:3', 'PWM1_BRAKE1:4', 'UART0_nRTS:5'] },

	{ f: ['PB.0:0', 'UART0_RXD:1', 'PWM1_CH0:4'] },
	{ f: ['PB.1:0', 'UART0_TXD:1', 'PWM1_CH1:4'] },
	{ f: ['PB.2:0', 'UART0_nRTS:1', 'TM2_EXT:2', 'PWM1_CH2:4'] },
	{ f: ['PB.3:0', 'UART0_nCTS:1', 'TM3_EXT:2', 'PWM1_CH3:4'] },
	{ f: ['PB.4:0', 'BPWM0_CH3:4', 'TM2_EXT:5', 'USCI0_CTL0:6', 'USCI0_DAT0:7'] },
	{ f: ['PB.5:0', 'BPWM0_CH2:4', 'TM3:5', 'USCI0_CLK:6', 'USCI0_DAT1:7'] },
	{ f: ['PB.6:0', 'BPWM0_CH1:4', 'USCI0_DAT0:6', 'USCI0_CTL1:7'] },
	{ f: ['PB.7:0', 'BPWM0_CH0:4', 'USCI0_DAT1:6', 'USCI0_CTL0:7'] },
	{ f: ['PB.8:0', 'TM0:1', 'ADC_CH8:3', 'BPWM1_CH1:4'] },
	{ f: ['PB.9:0', 'TM1:1', 'SPI0_I2SMCLK:3', 'PWM0_CH4:4'] },
	{ f: ['PB.10:0', 'TM2:1', 'SPI0_I2SMCLK:3', 'PWM0_CH5:4'] },
	{ f: ['PB.11:0'] },
	{ f: ['PB.12:0', 'CLKO:2', 'ADC_CH11:3', 'USCI0_CTL0:6'] },
	{ f: ['PB.13:0', 'ADC_CH10:3', 'USCI0_CTL1:6'] },
	{ f: ['PB.14:0', 'INT0:1', 'UART0_nRTS:2', 'ADC_CH9:3', 'BPWM1_CH0:4', 'SPI0_SS:7'] },
	{ f: ['PB.15:0', 'INT1:1', 'TM0_EXT:2', 'BPWM1_CH5:4'] },

	{ f: ['PC.0:0', 'SPI0_SS:1', 'PWM1_CH0:4', 'TM2:5', 'UART0_RXD:6', 'USCI0_CLK:7'] },
	{ f: ['PC.1:0', 'SPI0_CLK:1', 'PWM1_CH1:4', 'UART0_TXD:6', 'USCI0_CTL0:7'] },
	{ f: ['PC.2:0', 'SPI0_MISO:1', 'I2C1_SCL:3', 'PWM1_CH2:4', 'UART0_nCTS:6', 'USCI0_DAT1:7'] },
	{ f: ['PC.3:0', 'SPI0_MOSI:1', 'I2C1_SDA:3', 'PWM1_CH3:4', 'UART0_nRTS:6', 'USCI0_DAT0:7'] },
	{ f: ['PC.4:0', 'UART0_RXD:2', 'SPI0_I2SMCLK:3', 'PWM1_CH4:4', 'USCI0_DAT1:7'] },
	{ f: ['PC.5:0', 'UART0_TXD:2', 'PWM1_CH5:4', 'USCI0_DAT0:7'] },
	{ f: ['PC.6:0'] },
	{ f: ['PC.7:0'] },
	{ f: ['PC.8:0', 'STADC:2', 'SPI0_SS:3', 'PWM0_CH4:4', 'PWM1_BRAKE0:5', 'USCI0_CTL0:7'] },
	{ f: ['PC.9:0', 'SPI0_CLK:3', 'PWM0_CH5:4', 'PWM0_BRAKE1:5', 'USCI0_CLK:7'] },
	{ f: ['PC.10:0', 'SPI0_MISO:3', 'PWM0_CH0:4', 'USCI0_DAT1:7'] },
	{ f: ['PC.11:0', 'SPI0_MOSI:3', 'PWM0_CH1:4', 'TM1:5', 'I2C0_SDA:6', 'USCI0_DAT0:7'] },
	{ f: ['PC.12:0', 'PWM0_CH2:2', 'SPI0_I2SMCLK:3', 'CLKO:4', 'INT0:5', 'I2C0_SCL:6', 'USCI0_CTL1:7'] },
	{ f: ['PC.13:0', 'PWM0_CH3:2', 'CLKO:3', 'INT0:5', 'I2C0_SDA:6'] },
	{ f: ['PC.14:0'] },
	{ f: ['PC.15:0'] },

	{ f: ['PD.0:0', 'ADC_CH0:3', 'UART0_nRTS:5', 'USCI0_CTL0:6', 'SPI0_SS:7'] },
	{ f: ['PD.1:0', 'ADC_CH1:3', 'TM0_EXT:4', 'UART0_RXD:5', 'USCI0_CLK:6', 'SPI0_CLK:7'] },
	{ f: ['PD.2:0', 'ADC_CH2:3', 'TM3:4', 'UART0_TXD:5', 'USCI0_DAT1:6', 'SPI0_MISO:7'] },
	{ f: ['PD.3:0', 'ADC_CH3:3', 'TM1_EXT:4', 'UART0_nCTS:5', 'USCI0_DAT0:6', 'SPI0_MOSI:7'] },
	{ f: ['PD.4:0', 'ADC_CH4:2', 'BPWM1_CH5:4', 'UART0_nRTS:5', 'USCI0_CTL0:6', 'SPI0_SS:7'] },
	{ f: ['PD.5:0', 'ADC_CH5:2', 'BPWM1_CH4:4'] },
	{ f: ['PD.6:0'] },
	{ f: ['PD.7:0'] },
	{ f: ['PD.8:0', 'USCI0_DAT0:6'] },
	{ f: ['PD.9:0', 'PWM0_BRAKE1:5'] },
	{ f: ['PD.10:0', 'CLKO:1', 'BPWM0_CH5:4'] },
	{ f: ['PD.11:0', 'INT1:1', 'BPWM0_CH4:4'] },
	{ f: ['PD.12:0'] },
	{ f: ['PD.13:0'] },
	{ f: ['PD.14:0'] },
	{ f: ['PD.15:0'] },

	{ f: ['PE.0:0', 'INT0:1', 'CLKO:3', 'PWM0_CH3:4', 'TM1_EXT:5', 'USCI0_DAT0:7'] },
	{ f: ['PE.1:0', 'STADC:2', 'CLKO:3', 'TM3:5', 'USCI0_DAT1:7'] },
	{ f: ['PE.2:0', 'INT1:1', 'TM0_EXT:5', 'I2C0_SCL:6', 'USCI0_CTL1:7'] },
	{ f: ['PE.3:0'] },
	{ f: ['PE.4:0'] },
	{ f: ['PE.5:0'] },
	{ f: ['PE.6:0'] },
	{ f: ['PE.7:0'] },
	{ f: ['PE.8:0'] },
	{ f: ['PE.9:0'] },
	{ f: ['PE.10:0'] },
	{ f: ['PE.11:0'] },
	{ f: ['PE.12:0'] },
	{ f: ['PE.13:0'] },
	{ f: ['PE.14:0'] },
	{ f: ['PE.15:0'] },

	{ f: ['PF.0:0', 'XT_OUT:1', 'BPWM1_CH3:4', 'TM3:5'] },
	{ f: ['PF.1:0', 'XT_IN:1', 'BPWM1_CH2:4', 'TM1_EXT:5'] },
	{ f: ['PF.2:0', /*'ICE_DAT:1',*/ 'I2C0_SDA:2', 'ADC_CH6:3', 'BPWM1_CH3:4'] },
	{ f: ['PF.3:0', /*'ICE_CLK:1',*/ 'I2C0_SCL:2', 'ADC_CH7:3', 'BPWM1_CH2:4'] },
	{ f: ['PF.4:0', 'ICE_DAT:1', 'I2C0_SDA:2', 'UART0_TXD:3', 'PWM0_CH3:4'] },
	{ f: ['PF.5:0', 'ICE_CLK:1', 'I2C0_SCL:2', 'UART0_RXD:3'] }
];

NUTOOL_PIN.g_cfg_gpiosDefines = [
	{ f: ['PA.0', 'GPIO:SYS_GPA_MFPL_PA0MFP_GPIO@GPA_MFPL'] },
	{ f: ['PA.1', 'GPIO:SYS_GPA_MFPL_PA1MFP_GPIO@GPA_MFPL'] },
	{ f: ['PA.2', 'GPIO:SYS_GPA_MFPL_PA2MFP_GPIO@GPA_MFPL'] },
	{ f: ['PA.3', 'GPIO:SYS_GPA_MFPL_PA3MFP_GPIO@GPA_MFPL'] },
	{ f: ['PA.4', 'GPIO:SYS_GPA_MFPL_PA4MFP_GPIO@GPA_MFPL'] },
	{ f: ['PA.5', 'GPIO:SYS_GPA_MFPL_PA5MFP_GPIO@GPA_MFPL'] },
	{ f: ['PA.6', 'GPIO:SYS_GPA_MFPL_PA6MFP_GPIO@GPA_MFPL'] },
	{ f: ['PA.7', 'GPIO:SYS_GPA_MFPL_PA7MFP_GPIO@GPA_MFPL'] },
	{ f: ['PA.8', 'GPIO:SYS_GPA_MFPH_PA8MFP_GPIO@GPA_MFPH'] },
	{ f: ['PA.9', 'GPIO:SYS_GPA_MFPH_PA9MFP_GPIO@GPA_MFPH'] },
	{ f: ['PA.10', 'GPIO:SYS_GPA_MFPH_PA10MFP_GPIO@GPA_MFPH', 'I2C1_SDA:GPA_MFPH_PA10MFP_I2C1_SDA@GPA_MFPH', 'BPWM0_CH4:GPA_MFPH_PA10MFP_BPWM0_CH4@GPA_MFPH', 'PWM0_BRAKE0:GPA_MFPH_PA10MFP_PWM0_BRAKE0@GPA_MFPH', 'USCI0_DAT1:GPA_MFPH_PA10MFP_USCI0_DAT1@GPA_MFPH'] },
	{ f: ['PA.11', 'GPIO:SYS_GPA_MFPH_PA11MFP_GPIO@GPA_MFPH', 'I2C1_SCL:GPA_MFPH_PA11MFP_I2C1_SCL@GPA_MFPH', 'BPWM0_CH5:GPA_MFPH_PA11MFP_BPWM0_CH5@GPA_MFPH', 'TM0:GPA_MFPH_PA11MFP_TM0@GPA_MFPH', 'USCI0_CLK:GPA_MFPH_PA11MFP_USCI0_CLK@GPA_MFPH', 'USCI0_DAT0:GPA_MFPH_PA11MFP_USCI0_DAT0@GPA_MFPH'] },
	{ f: ['PA.12', 'GPIO:SYS_GPA_MFPH_PA12MFP_GPIO@GPA_MFPH', 'PWM0_CH0:GPA_MFPH_PA12MFP_PWM0_CH0@GPA_MFPH', 'I2C1_SCL:GPA_MFPH_PA12MFP_I2C1_SCL@GPA_MFPH', 'UART0_RXD:GPA_MFPH_PA12MFP_UART0_RXD@GPA_MFPH'] },
	{ f: ['PA.13', 'GPIO:SYS_GPA_MFPH_PA13MFP_GPIO@GPA_MFPH', 'PWM0_CH1:GPA_MFPH_PA13MFP_PWM0_CH1@GPA_MFPH', 'I2C1_SDA:GPA_MFPH_PA13MFP_I2C1_SDA@GPA_MFPH', 'UART0_TXD:GPA_MFPH_PA13MFP_UART0_TXD@GPA_MFPH'] },
	{ f: ['PA.14', 'GPIO:SYS_GPA_MFPH_PA14MFP_GPIO@GPA_MFPH', 'PWM0_CH2:GPA_MFPH_PA14MFP_PWM0_CH2@GPA_MFPH', 'UART0_nCTS:GPA_MFPH_PA14MFP_UART0_nCTS@GPA_MFPH', 'PWM0_BRAKE0:GPA_MFPH_PA14MFP_PWM0_BRAKE0@GPA_MFPH'] },
	{ f: ['PA.15', 'GPIO:SYS_GPA_MFPH_PA15MFP_GPIO@GPA_MFPH', 'PWM0_CH3:GPA_MFPH_PA15MFP_PWM0_CH3@GPA_MFPH', 'SPI_I2SMCLK:GPA_MFPH_PA15MFP_SPI_I2SMCLK@GPA_MFPH', 'CLKO:GPA_MFPH_PA15MFP_CLKO@GPA_MFPH', 'PWM1_BRAKE1:GPA_MFPH_PA15MFP_PWM1_BRAKE1@GPA_MFPH', 'UART0_nRTS:GPA_MFPH_PA15MFP_UART0_nRTS@GPA_MFPH'] },

	{ f: ['PB.0', 'GPIO:SYS_GPB_MFPL_PB0MFP_GPIO@GPB_MFPL', 'UART0_RXD:GPB_MFPL_PB0MFP_UART0_RXD@GPB_MFPL', 'PWM1_CH0:GPB_MFPL_PB0MFP_PWM1_CH0@GPB_MFPL'] },
	{ f: ['PB.1', 'GPIO:SYS_GPB_MFPL_PB1MFP_GPIO@GPB_MFPL', 'UART0_TXD:GPB_MFPL_PB1MFP_UART0_TXD@GPB_MFPL', 'PWM1_CH1:GPB_MFPL_PB1MFP_PWM1_CH1@GPB_MFPL'] },
	{ f: ['PB.2', 'GPIO:SYS_GPB_MFPL_PB2MFP_GPIO@GPB_MFPL', 'UART0_nRTS:GPB_MFPL_PB2MFP_UART0_nRTS@GPB_MFPL', 'TM2_EXT:GPB_MFPL_PB2MFP_TM2_EXT@GPB_MFPL', 'PWM1_CH2:GPB_MFPL_PB2MFP_PWM1_CH2@GPB_MFPL'] },
	{ f: ['PB.3', 'GPIO:SYS_GPB_MFPL_PB3MFP_GPIO@GPB_MFPL', 'UART0_nCTS:GPB_MFPL_PB3MFP_UART0_nCTS@GPB_MFPL', 'TM3_EXT:GPB_MFPL_PB3MFP_TM3_EXT@GPB_MFPL', 'PWM1_CH3:GPB_MFPL_PB3MFP_PWM1_CH3@GPB_MFPL'] },
	{ f: ['PB.4', 'GPIO:SYS_GPB_MFPL_PB4MFP_GPIO@GPB_MFPL', 'BPWM0_CH3:GPB_MFPL_PB4MFP_BPWM0_CH3@GPB_MFPL', 'TM2_EXT:GPB_MFPL_PB4MFP_TM2_EXT@GPB_MFPL', 'USCI0_CTL0:GPB_MFPL_PB4MFP_USCI0_CTL0@GPB_MFPL', 'USCI0_DAT0:GPB_MFPL_PB4MFP_USCI0_DAT0@GPB_MFPL'] },
	{ f: ['PB.5', 'GPIO:SYS_GPB_MFPL_PB5MFP_GPIO@GPB_MFPL', 'BPWM0_CH2:GPB_MFPL_PB5MFP_BPWM0_CH2@GPB_MFPL', 'TM3:GPB_MFPL_PB5MFP_TM3@GPB_MFPL', 'USCI0_CLK:GPB_MFPL_PB5MFP_USCI0_CLK@GPB_MFPL', 'USCI0_DAT1:GPB_MFPL_PB5MFP_USCI0_DAT1@GPB_MFPL'] },
	{ f: ['PB.6', 'GPIO:SYS_GPB_MFPL_PB6MFP_GPIO@GPB_MFPL', 'BPWM0_CH1:GPB_MFPL_PB6MFP_BPWM0_CH1@GPB_MFPL', 'USCI0_DAT0:GPB_MFPL_PB6MFP_USCI0_DAT0@GPB_MFPL', 'USCI0_CTL1:GPB_MFPL_PB6MFP_USCI0_CTL1@GPB_MFPL'] },
	{ f: ['PB.7', 'GPIO:SYS_GPB_MFPL_PB7MFP_GPIO@GPB_MFPL', 'BPWM0_CH0:GPB_MFPL_PB7MFP_BPWM0_CH0@GPB_MFPL', 'USCI0_DAT1:GPB_MFPL_PB7MFP_USCI0_DAT1@GPB_MFPL', 'USCI0_CTL0:GPB_MFPL_PB7MFP_USCI0_CTL0@GPB_MFPL'] },
	{ f: ['PB.8', 'GPIO:SYS_GPB_MFPH_PB8MFP_GPIO@GPB_MFPH', 'TM0:GPB_MFPH_PB8MFP_TM0@GPB_MFPH', 'ADC_CH8:GPB_MFPH_PB8MFP_ADC_CH8@GPB_MFPH', 'BPWM1_CH1:GPB_MFPH_PB8MFP_BPWM1_CH1@GPB_MFPH'] },
	{ f: ['PB.9', 'GPIO:SYS_GPB_MFPH_PB9MFP_GPIO@GPB_MFPH', 'TM1:GPB_MFPH_PB9MFP_TM1@GPB_MFPH', 'SPI0_I2SMCLK:GPB_MFPH_PB9MFP_SPI0_I2SMCLK@GPB_MFPH', 'PWM0_CH4:GPB_MFPH_PB9MFP_PWM0_CH4@GPB_MFPH'] },
	{ f: ['PB.10', 'GPIO:SYS_GPB_MFPH_PB10MFP_GPIO@GPB_MFPH', 'TM2:GPB_MFPH_PB10MFP_TM2@GPB_MFPH', 'SPI0_I2SMCLK:GPB_MFPH_PB10MFP_SPI0_I2SMCLK@GPB_MFPH', 'PWM0_CH5:GPB_MFPH_PB10MFP_PWM0_CH5@GPB_MFPH'] },
	{ f: ['PB.11', 'GPIO:SYS_GPB_MFPH_PB11MFP_GPIO@GPB_MFPH'] },
	{ f: ['PB.12', 'GPIO:SYS_GPB_MFPH_PB12MFP_GPIO@GPB_MFPH', 'CLKO:GPB_MFPH_PB12MFP_CLKO@GPB_MFPH', 'ADC_CH11:GPB_MFPH_PB12MFP_ADC_CH11@GPB_MFPH', 'USCI0_CTL0:GPB_MFPH_PB12MFP_USCI0_CTL0@GPB_MFPH'] },
	{ f: ['PB.13', 'GPIO:SYS_GPB_MFPH_PB13MFP_GPIO@GPB_MFPH', 'ADC_CH10:GPB_MFPH_PB13MFP_ADC_CH10@GPB_MFPH', 'USCI0_CTL1:GPB_MFPH_PB13MFP_USCI0_CTL1@GPB_MFPH'] },
	{ f: ['PB.14', 'GPIO:SYS_GPB_MFPH_PB14MFP_GPIO@GPB_MFPH', 'INT0:GPB_MFPH_PB14MFP_INT0@GPB_MFPH', 'UART0_nRTS:GPB_MFPH_PB14MFP_UART0_nRTS@GPB_MFPH', 'ADC_CH9:GPB_MFPH_PB14MFP_ADC_CH9@GPB_MFPH', 'BPWM1_CH0:GPB_MFPH_PB14MFP_BPWM1_CH0@GPB_MFPH', 'SPI0_SS:GPB_MFPH_PB14MFP_SPI0_SS@GPB_MFPH'] },
	{ f: ['PB.15', 'GPIO:SYS_GPB_MFPH_PB15MFP_GPIO@GPB_MFPH', 'INT1:GPB_MFPH_PB15MFP_INT1@GPB_MFPH', 'TM0_EXT:GPB_MFPH_PB15MFP_TM0_EXT@GPB_MFPH', 'BPWM1_CH5:GPB_MFPH_PB15MFP_BPWM1_CH5@GPB_MFPH'] },

	{ f: ['PC.0', 'GPIO:SYS_GPC_MFPL_PC0MFP_GPIO@GPC_MFPL', 'SPI0_SS:GPC_MFPL_PC0MFP_SPI0_SS@GPC_MFPL', 'PWM1_CH0:GPC_MFPL_PC0MFP_PWM1_CH0@GPC_MFPL', 'TM2:GPC_MFPL_PC0MFP_TM2@GPC_MFPL', 'UART0_RXD:GPC_MFPL_PC0MFP_UART0_RXD@GPC_MFPL', 'USCI0_CLK:GPC_MFPL_PC0MFP_USCI0_CLK@GPC_MFPL'] },
	{ f: ['PC.1', 'GPIO:SYS_GPC_MFPL_PC1MFP_GPIO@GPC_MFPL', 'SPI0_CLK:GPC_MFPL_PC1MFP_SPI0_CLK@GPC_MFPL', 'PWM1_CH1:GPC_MFPL_PC1MFP_PWM1_CH1@GPC_MFPL', 'UART0_TXD:GPC_MFPL_PC1MFP_UART0_TXD@GPC_MFPL', 'USCI0_CTL0:GPC_MFPL_PC1MFP_USCI0_CTL0@GPC_MFPL'] },
	{ f: ['PC.2', 'GPIO:SYS_GPC_MFPL_PC2MFP_GPIO@GPC_MFPL', 'SPI0_MISO:GPC_MFPL_PC2MFP_SPI0_MISO@GPC_MFPL', 'I2C1_SCL:GPC_MFPL_PC2MFP_I2C1_SCL@GPC_MFPL', 'PWM1_CH2:GPC_MFPL_PC2MFP_PWM1_CH2@GPC_MFPL', 'UART0_nCTS:GPC_MFPL_PC2MFP_UART0_nCTS@GPC_MFPL', 'USCI0_DAT1:GPC_MFPL_PC2MFP_USCI0_DAT1@GPC_MFPL'] },
	{ f: ['PC.3', 'GPIO:SYS_GPC_MFPL_PC3MFP_GPIO@GPC_MFPL', 'SPI0_MOSI:GPC_MFPL_PC3MFP_SPI0_MOSI@GPC_MFPL', 'I2C1_SDA:GPC_MFPL_PC3MFP_I2C1_SDA@GPC_MFPL', 'PWM1_CH3:GPC_MFPL_PC3MFP_PWM1_CH3@GPC_MFPL', 'UART0_nRTS:GPC_MFPL_PC3MFP_UART0_nRTS@GPC_MFPL', 'USCI0_DAT0:GPC_MFPL_PC3MFP_USCI0_DAT0@GPC_MFPL'] },
	{ f: ['PC.4', 'GPIO:SYS_GPC_MFPL_PC4MFP_GPIO@GPC_MFPL', 'UART0_RXD:GPC_MFPL_PC4MFP_UART0_RXD@GPC_MFPL', 'SPI0_I2SMCLK:GPC_MFPL_PC4MFP_SPI0_I2SMCLK@GPC_MFPL', 'PWM1_CH4:GPC_MFPL_PC4MFP_PWM1_CH4@GPC_MFPL', 'USCI0_DAT1:GPC_MFPL_PC4MFP_USCI0_DAT1@GPC_MFPL'] },
	{ f: ['PC.5', 'GPIO:SYS_GPC_MFPL_PC5MFP_GPIO@GPC_MFPL', 'UART0_TXD:GPC_MFPL_PC5MFP_UART0_TXD@GPC_MFPL', 'PWM1_CH5:GPC_MFPL_PC5MFP_PWM1_CH5@GPC_MFPL', 'USCI0_DAT0:GPC_MFPL_PC5MFP_USCI0_DAT0@GPC_MFPL'] },
	{ f: ['PC.6', 'GPIO:SYS_GPC_MFPL_PC6MFP_GPIO@GPC_MFPL'] },
	{ f: ['PC.7', 'GPIO:SYS_GPC_MFPL_PC7MFP_GPIO@GPC_MFPL'] },
	{ f: ['PC.8', 'GPIO:SYS_GPC_MFPH_PC8MFP_GPIO@GPC_MFPH', 'STADC:GPC_MFPH_PC8MFP_STADC@GPC_MFPH', 'SPI0_SS:GPC_MFPH_PC8MFP_SPI0_SS@GPC_MFPH', 'PWM0_CH4:GPC_MFPH_PC8MFP_PWM0_CH4@GPC_MFPH', 'PWM1_BRAKE0:GPC_MFPH_PC8MFP_PWM1_BRAKE0@GPC_MFPH', 'USCI0_CTL0:GPC_MFPH_PC8MFP_USCI0_CTL0@GPC_MFPH'] },
	{ f: ['PC.9', 'GPIO:SYS_GPC_MFPH_PC9MFP_GPIO@GPC_MFPH', 'SPI0_CLK:GPC_MFPH_PC9MFP_SPI0_CLK@GPC_MFPH', 'PWM0_CH5:GPC_MFPH_PC9MFP_PWM0_CH5@GPC_MFPH', 'PWM0_BRAKE1:GPC_MFPH_PC9MFP_PWM0_BRAKE1@GPC_MFPH', 'USCI0_CLK:GPC_MFPH_PC9MFP_USCI0_CLK@GPC_MFPH'] },
	{ f: ['PC.10', 'GPIO:SYS_GPC_MFPH_PC10MFP_GPIO@GPC_MFPH', 'SPI0_MISO:GPC_MFPH_PC10MFP_SPI0_MISO@GPC_MFPH', 'PWM0_CH0:GPC_MFPH_PC10MFP_PWM0_CH0@GPC_MFPH', 'USCI0_DAT1:GPC_MFPH_PC10MFP_USCI0_DAT1@GPC_MFPH'] },
	{ f: ['PC.11', 'GPIO:SYS_GPC_MFPH_PC11MFP_GPIO@GPC_MFPH', 'SPI0_MOSI:GPC_MFPH_PC11MFP_SPI0_MOSI@GPC_MFPH', 'PWM0_CH1:GPC_MFPH_PC11MFP_PWM0_CH1@GPC_MFPH', 'TM1:GPC_MFPH_PC11MFP_TM1@GPC_MFPH', 'I2C0_SDA:GPC_MFPH_PC11MFP_I2C0_SDA@GPC_MFPH', 'USCI0_DAT0:GPC_MFPH_PC11MFP_USCI0_DAT0@GPC_MFPH'] },
	{ f: ['PC.12', 'GPIO:SYS_GPC_MFPH_PC12MFP_GPIO@GPC_MFPH', 'PWM0_CH2:GPC_MFPH_PC12MFP_PWM0_CH2@GPC_MFPH', 'SPI0_I2SMCLK:GPC_MFPH_PC12MFP_SPI0_I2SMCLK@GPC_MFPH', 'CLKO:GPC_MFPH_PC12MFP_CLKO@GPC_MFPH', 'INT0:GPC_MFPH_PC12MFP_INT0@GPC_MFPH', 'I2C0_SCL:GPC_MFPH_PC12MFP_I2C0_SCL@GPC_MFPH', 'USCI0_CTL1:GPC_MFPH_PC12MFP_USCI0_CTL1@GPC_MFPH'] },
	{ f: ['PC.13', 'GPIO:SYS_GPC_MFPH_PC13MFP_GPIO@GPC_MFPH', 'PWM0_CH3:GPC_MFPH_PC13MFP_PWM0_CH3@GPC_MFPH', 'CLKO:GPC_MFPH_PC13MFP_CLKO@GPC_MFPH', 'INT0:GPC_MFPH_PC13MFP_INT0@GPC_MFPH', 'I2C0_SDA:GPC_MFPH_PC13MFP_I2C0_SDA@GPC_MFPH'] },
	{ f: ['PC.14', 'GPIO:SYS_GPC_MFPH_PC14MFP_GPIO@GPC_MFPH'] },
	{ f: ['PC.15', 'GPIO:SYS_GPC_MFPH_PC15MFP_GPIO@GPC_MFPH'] },

	{ f: ['PD.0', 'GPIO:SYS_GPD_MFPL_PD0MFP_GPIO@GPD_MFPL', 'ADC_CH0:GPD_MFPL_PD0MFP_ADC_CH0@GPD_MFPL', 'UART0_nRTS:GPD_MFPL_PD0MFP_UART0_nRTS@GPD_MFPL', 'USCI0_CTL0:GPD_MFPL_PD0MFP_USCI0_CTL0@GPD_MFPL', 'SPI0_SS:GPD_MFPL_PD0MFP_SPI0_SS@GPD_MFPL'] },
	{ f: ['PD.1', 'GPIO:SYS_GPD_MFPL_PD1MFP_GPIO@GPD_MFPL', 'ADC_CH1:GPD_MFPL_PD1MFP_ADC_CH1@GPD_MFPL', 'TM0_EXT:GPD_MFPL_PD1MFP_TM0_EXT@GPD_MFPL', 'UART0_RXD:GPD_MFPL_PD1MFP_UART0_RXD@GPD_MFPL', 'USCI0_CLK:GPD_MFPL_PD1MFP_USCI0_CLK@GPD_MFPL', 'SPI0_CLK:GPD_MFPL_PD1MFP_SPI0_CLK@GPD_MFPL'] },
	{ f: ['PD.2', 'GPIO:SYS_GPD_MFPL_PD2MFP_GPIO@GPD_MFPL', 'ADC_CH2:GPD_MFPL_PD2MFP_ADC_CH2@GPD_MFPL', 'TM3:GPD_MFPL_PD2MFP_TM3@GPD_MFPL', 'UART0_TXD:GPD_MFPL_PD2MFP_UART0_TXD@GPD_MFPL', 'USCI0_DAT1:GPD_MFPL_PD2MFP_USCI0_DAT1@GPD_MFPL', 'SPI0_MISO:GPD_MFPL_PD2MFP_SPI0_MISO@GPD_MFPL'] },
	{ f: ['PD.3', 'GPIO:SYS_GPD_MFPL_PD3MFP_GPIO@GPD_MFPL', 'ADC_CH3:GPD_MFPL_PD3MFP_ADC_CH3@GPD_MFPL', 'TM1_EXT:GPD_MFPL_PD3MFP_TM1_EXT@GPD_MFPL', 'UART0_nCTS:GPD_MFPL_PD3MFP_UART0_nCTS@GPD_MFPL', 'USCI0_DAT0:GPD_MFPL_PD3MFP_USCI0_DAT0@GPD_MFPL', 'SPI0_MOSI:GPD_MFPL_PD3MFP_SPI0_MOSI@GPD_MFPL'] },
	{ f: ['PD.4', 'GPIO:SYS_GPD_MFPL_PD4MFP_GPIO@GPD_MFPL', 'ADC_CH4:GPD_MFPL_PD4MFP_ADC_CH4@GPD_MFPL', 'BPWM1_CH5:GPD_MFPL_PD4MFP_BPWM1_CH5@GPD_MFPL', 'UART0_nRTS:GPD_MFPL_PD4MFP_UART0_nRTS@GPD_MFPL', 'USCI0_CTL0:GPD_MFPL_PD4MFP_USCI0_CTL0@GPD_MFPL', 'SPI0_SS:GPD_MFPL_PD4MFP_SPI0_SS@GPD_MFPL'] },
	{ f: ['PD.5', 'GPIO:SYS_GPD_MFPL_PD5MFP_GPIO@GPD_MFPL', 'ADC_CH5:GPD_MFPL_PD5MFP_ADC_CH5@GPD_MFPL', 'BPWM1_CH4:GPD_MFPL_PD5MFP_BPWM1_CH4@GPD_MFPL'] },
	{ f: ['PD.6', 'GPIO:SYS_GPD_MFPL_PD6MFP_GPIO@GPD_MFPL'] },
	{ f: ['PD.7', 'GPIO:SYS_GPD_MFPL_PD7MFP_GPIO@GPD_MFPL'] },
	{ f: ['PD.8', 'GPIO:SYS_GPD_MFPH_PD8MFP_GPIO@GPD_MFPH', 'USCI0_DAT0:GPD_MFPH_PD8MFP_USCI0_DAT0@GPD_MFPH'] },
	{ f: ['PD.9', 'GPIO:SYS_GPD_MFPH_PD9MFP_GPIO@GPD_MFPH', 'PWM0_BRAKE1:GPD_MFPH_PD9MFP_PWM0_BRAKE1@GPD_MFPH'] },
	{ f: ['PD.10', 'GPIO:SYS_GPD_MFPH_PD10MFP_GPIO@GPD_MFPH', 'CLKO:GPD_MFPH_PD10MFP_CLKO@GPD_MFPH', 'BPWM0_CH5:GPD_MFPH_PD10MFP_BPWM0_CH5@GPD_MFPH'] },
	{ f: ['PD.11', 'GPIO:SYS_GPD_MFPH_PD11MFP_GPIO@GPD_MFPH', 'INT1:GPD_MFPH_PD11MFP_INT1@GPD_MFPH', 'BPWM0_CH4:GPD_MFPH_PD11MFP_BPWM0_CH4@GPD_MFPH'] },
	{ f: ['PD.12', 'GPIO:SYS_GPD_MFPH_PD12MFP_GPIO@GPD_MFPH'] },
	{ f: ['PD.13', 'GPIO:SYS_GPD_MFPH_PD13MFP_GPIO@GPD_MFPH'] },
	{ f: ['PD.14', 'GPIO:SYS_GPD_MFPH_PD14MFP_GPIO@GPD_MFPH'] },
	{ f: ['PD.15', 'GPIO:SYS_GPD_MFPH_PD15MFP_GPIO@GPD_MFPH'] },

	{ f: ['PE.0', 'GPIO:SYS_GPE_MFPL_PE0MFP_GPIO@GPE_MFPL', 'INT0:GPE_MFPL_PE0MFP_INT0@GPE_MFPL', 'CLKO:GPE_MFPL_PE0MFP_CLKO@GPE_MFPL', 'PWM0_CH3:GPE_MFPL_PE0MFP_PWM0_CH3@GPE_MFPL', 'TM1_EXT:GPE_MFPL_PE0MFP_TM1_EXT@GPE_MFPL', 'USCI0_DAT0:GPE_MFPL_PE0MFP_USCI0_DAT0@GPE_MFPL'] },
	{ f: ['PE.1', 'GPIO:SYS_GPE_MFPL_PE1MFP_GPIO@GPE_MFPL', 'STADC:GPE_MFPL_PE1MFP_STADC@GPE_MFPL', 'CLKO:GPE_MFPL_PE1MFP_CLKO@GPE_MFPL', 'TM3:GPE_MFPL_PE1MFP_TM3@GPE_MFPL', 'USCI0_DAT1:GPE_MFPL_PE1MFP_USCI0_DAT1@GPE_MFPL'] },
	{ f: ['PE.2', 'GPIO:SYS_GPE_MFPL_PE2MFP_GPIO@GPE_MFPL', 'INT1:GPE_MFPL_PE2MFP_INT1@GPE_MFPL', 'TM0_EXT:GPE_MFPL_PE2MFP_TM0_EXT@GPE_MFPL', 'I2C0_SCL:GPE_MFPL_PE2MFP_I2C0_SCL@GPE_MFPL', 'USCI0_CTL1:GPE_MFPL_PE2MFP_USCI0_CTL1@GPE_MFPL'] },
	{ f: ['PE.3', 'GPIO:SYS_GPE_MFPL_PE3MFP_GPIO@GPE_MFPL'] },
	{ f: ['PE.4', 'GPIO:SYS_GPE_MFPL_PE4MFP_GPIO@GPE_MFPL'] },
	{ f: ['PE.5', 'GPIO:SYS_GPE_MFPL_PE5MFP_GPIO@GPE_MFPL'] },
	{ f: ['PE.6', 'GPIO:SYS_GPE_MFPL_PE6MFP_GPIO@GPE_MFPL'] },
	{ f: ['PE.7', 'GPIO:SYS_GPE_MFPL_PE7MFP_GPIO@GPE_MFPL'] },
	{ f: ['PE.8', 'GPIO:SYS_GPE_MFPH_PE8MFP_GPIO@GPE_MFPH'] },
	{ f: ['PE.9', 'GPIO:SYS_GPE_MFPH_PE9MFP_GPIO@GPE_MFPH'] },
	{ f: ['PE.10', 'GPIO:SYS_GPE_MFPH_PE10MFP_GPIO@GPE_MFPH'] },
	{ f: ['PE.11', 'GPIO:SYS_GPE_MFPH_PE11MFP_GPIO@GPE_MFPH'] },
	{ f: ['PE.12', 'GPIO:SYS_GPE_MFPH_PE12MFP_GPIO@GPE_MFPH'] },
	{ f: ['PE.13', 'GPIO:SYS_GPE_MFPH_PE13MFP_GPIO@GPE_MFPH'] },
	{ f: ['PE.14', 'GPIO:SYS_GPE_MFPH_PE14MFP_GPIO@GPE_MFPH'] },
	{ f: ['PE.15', 'GPIO:SYS_GPE_MFPH_PE15MFP_GPIO@GPE_MFPH'] },

	{ f: ['PF.0', 'GPIO:SYS_GPF_MFPL_PF0MFP_GPIO@GPF_MFPL', 'XT_OUT:GPF_MFPL_PF0MFP_XT_OUT@GPF_MFPL', 'BPWM1_CH3:GPF_MFPL_PF0MFP_BPWM1_CH3@GPF_MFPL', 'TM3:GPF_MFPL_PF0MFP_TM3@GPF_MFPL'] },
	{ f: ['PF.1', 'GPIO:SYS_GPF_MFPL_PF1MFP_GPIO@GPF_MFPL', 'XT_IN:GPF_MFPL_PF1MFP_XT_IN@GPF_MFPL', 'BPWM1_CH2:GPF_MFPL_PF1MFP_BPWM1_CH2@GPF_MFPL', 'TM1_EXT:GPF_MFPL_PF1MFP_TM1_EXT@GPF_MFPL'] },
	{ f: ['PF.2', 'GPIO:SYS_GPF_MFPL_PF2MFP_GPIO@GPF_MFPL', 'ICE_DAT:GPF_MFPL_PF2MFP_ICE_DAT@GPF_MFPL', 'I2C0_SDA:GPF_MFPL_PF2MFP_I2C0_SDA@GPF_MFPL', 'ADC_CH6:GPF_MFPL_PF2MFP_ADC_CH6@GPF_MFPL', 'BPWM1_CH3:GPF_MFPL_PF2MFP_BPWM1_CH3@GPF_MFPL'] },
	{ f: ['PF.3', 'GPIO:SYS_GPF_MFPL_PF3MFP_GPIO@GPF_MFPL', 'ICE_CLK:GPF_MFPL_PF3MFP_ICE_CLK@GPF_MFPL', 'I2C0_SCL:GPF_MFPL_PF3MFP_I2C0_SCL@GPF_MFPL', 'ADC_CH7:GPF_MFPL_PF3MFP_ADC_CH7@GPF_MFPL', 'BPWM1_CH2:GPF_MFPL_PF3MFP_BPWM1_CH2@GPF_MFPL'] },
	{ f: ['PF.4', 'GPIO:SYS_GPF_MFPL_PF4MFP_GPIO@GPF_MFPL', 'ICE_DAT:GPF_MFPL_PF4MFP_ICE_DAT@GPF_MFPL', 'I2C0_SDA:GPF_MFPL_PF4MFP_I2C0_SDA@GPF_MFPL', 'UART0_TXD:GPF_MFPL_PF4MFP_UART0_TXD@GPF_MFPL', 'PWM0_CH3:GPF_MFPL_PF4MFP_PWM0_CH3@GPF_MFPL'] },
	{ f: ['PF.5', 'GPIO:SYS_GPF_MFPL_PF5MFP_GPIO@GPF_MFPL', 'ICE_CLK:GPF_MFPL_PF5MFP_ICE_CLK@GPF_MFPL', 'I2C0_SCL:GPF_MFPL_PF5MFP_I2C0_SCL@GPF_MFPL', 'UART0_RXD:GPF_MFPL_PF5MFP_UART0_RXD@GPF_MFPL'] }
];

NUTOOL_PIN.g_cfg_gpiosDescriptions = [
	'ADC_CH0:ADC channel 0 analog input',
	'ADC_CH1:ADC channel 1 analog input',
	'ADC_CH2:ADC channel 2 analog input',
	'ADC_CH3:ADC channel 3 analog input',
	'ADC_CH4:ADC channel 4 analog input',
	'ADC_CH5:ADC channel 5 analog input',
	'ADC_CH6:ADC channel 6 analog input',
	'ADC_CH7:ADC channel 7 analog input',
	'ADC_CH8:ADC channel 8 analog input',
	'ADC_CH9:ADC channel 9 analog input',
	'ADC_CH10:ADC channel 10 analog input',
	'ADC_CH11:ADC channel 11 analog input',

	'AVDD:Power supply for internal analog circuit',

	'BPWM0_CH0:BPWM0 channel 0 output/capture input',
	'BPWM0_CH1:BPWM0 channel 1 output/capture input',
	'BPWM0_CH2:BPWM0 channel 2 output/capture input',
	'BPWM0_CH3:BPWM0 channel 3 output/capture input',
	'BPWM0_CH4:BPWM0 channel 4 output/capture input',
	'BPWM0_CH5:BPWM0 channel 5 output/capture input',
	'BPWM1_CH0:BPWM1 channel 0 output/capture input',
	'BPWM1_CH1:BPWM1 channel 1 output/capture input',
	'BPWM1_CH2:BPWM1 channel 2 output/capture input',
	'BPWM1_CH3:BPWM1 channel 3 output/capture input',
	'BPWM1_CH4:BPWM1 channel 4 output/capture input',
	'BPWM1_CH5:BPWM1 channel 5 output/capture input',

	'CLKO:Clock Out',

	'I2C0_SCL:I2C0 clock pin',
	'I2C0_SDA:I2C0 data input/output pin',
	'I2C1_SCL:I2C1 clock pin',
	'I2C1_SDA:I2C1 data input/output pin',

	'ICE_CLK:Serial wired debugger clock pin',
	'ICE_DAT:Serial wired debugger data pin',

	'INT0:External interrupt0 input pin',
	'INT1:External interrupt1 input pin',

	'LDO_CAP:LDO output pin',

	'nRESET:External reset input: active LOW, with an internal pull-up. Set this pin low reset to initial state',

	'PWM0_BRAKE0:Brake input pin 0 of PWM0',
	'PWM0_BRAKE1:Brake input pin 1 of PWM0',
	'PWM0_CH0:PWM0 channel0 output/capture input',
	'PWM0_CH1:PWM0 channel1 output/capture input',
	'PWM0_CH2:PWM0 channel2 output/capture input',
	'PWM0_CH3:PWM0 channel3 output/capture input',
	'PWM0_CH4:PWM0 channel4 output/capture input',
	'PWM0_CH5:PWM0 channel5 output/capture input',
	'PWM1_BRAKE0:Brake input pin 0 of PWM1',
	'PWM1_BRAKE1:Brake input pin 1 of PWM1',
	'PWM1_CH0:PWM1 channel0 output/capture input',
	'PWM1_CH1:PWM1 channel1 output/capture input',
	'PWM1_CH2:PWM1 channel2 output/capture input',
	'PWM1_CH3:PWM1 channel3 output/capture input',
	'PWM1_CH4:PWM1 channel4 output/capture input',
	'PWM1_CH5:PWM1 channel5 output/capture input',

	'SPI_I2SMCLK:I2S0 master clock output pin',

	'SPI0_CLK:SPI0 serial clock pin',
	'SPI0_I2SMCLK:I2S0 master clock output pin',
	'SPI0_MISO:SPI0 MISO (Master In, Slave Out) pin',
	'SPI0_MOSI:SPI0 MOSI (Master Out, Slave In) pin',
	'SPI0_SS:SPI0 slave select pin',

	'STADC:ADC external trigger input',

	'TM0:Timer0event counter input / toggle output',
	'TM0_EXT:Timer0 external counter input',
	'TM1:Timer1 event counter input / toggle output',
	'TM1_EXT:Timer1 external counter input',
	'TM2:Timer2 event counter input / toggle output',
	'TM2_EXT:Timer2 external counter input',
	'TM3:Timer3 event counter input / toggle output',
	'TM3_EXT:Timer3 external counter input',

	'UART0_nCTS:Clear to Send input pin for UART0',
	'UART0_nRTS:Request to Send output pin for UART0',
	'UART0_RXD:Data receiver input pin for UART0',
	'UART0_TXD:Data transmitter output pin for UART0',

	'USB_D-:USB differential signal D-',
	'USB_D+:USB differential signal D+',
	'USB_VBUS:Power supply from USB host or HUB',
	'USB_VDD33_CAP:Internal power regulator output 3.3V decoupling pin',

	'USCI0_CLK:USCI clock pin',
	'USCI0_CTL0:USCI CTL0 pin',
	'USCI0_CTL1:USCI CTL1 pin',
	'USCI0_DAT0:USCI DAT0 pin',
	'USCI0_DAT1:USCI DAT1 pin',

	'VDD:Power supply for I/O ports and LDO source for internal PLL and digital function',
	'VSS:Ground pin for digital circuit',

	'XT_IN:External 4~24 MHz (high speed) crystal input pin or external 32.768 kHz (low speed) crystal input pin',
	'XT_OUT:External 4~24 MHz (high speed) crystal output pin or external 32.768 kHz (low speed) crystal output pin'
];

NUTOOL_PIN.g_cfg_regDescriptions = {};
NUTOOL_PIN.g_cfg_regDescriptions.GPA_MFPL = '0x50000030';
NUTOOL_PIN.g_cfg_regDescriptions.GPA_MFPH = '0x50000034';
NUTOOL_PIN.g_cfg_regDescriptions.GPB_MFPL = '0x50000038';
NUTOOL_PIN.g_cfg_regDescriptions.GPB_MFPH = '0x5000003C';
NUTOOL_PIN.g_cfg_regDescriptions.GPC_MFPL = '0x50000040';
NUTOOL_PIN.g_cfg_regDescriptions.GPC_MFPH = '0x50000044';
NUTOOL_PIN.g_cfg_regDescriptions.GPD_MFPL = '0x50000048';
NUTOOL_PIN.g_cfg_regDescriptions.GPD_MFPH = '0x5000004C';
NUTOOL_PIN.g_cfg_regDescriptions.GPE_MFPL = '0x50000050';
NUTOOL_PIN.g_cfg_regDescriptions.GPE_MFPH = '0x50000054';
NUTOOL_PIN.g_cfg_regDescriptions.GPF_MFPL = '0x50000058';

NUTOOL_PIN.g_cfg_gpioMatrix = [];
NUTOOL_PIN.g_cfg_shareBits = [];
NUTOOL_PIN.g_cfg_addGPIO = {};
NUTOOL_PIN.g_cfg_unusedGPIO = {};

NUTOOL_PIN.decidepackageNumber = function (given_partNumber_package) {
	var partNumber_package,
		partNumber;

	if (typeof given_partNumber_package === 'undefined') {
		partNumber_package = NUTOOL_PIN.getg_partNumber_package();
	}
	else {
		partNumber_package = given_partNumber_package;
	}

	NUTOOL_PIN.g_packageNumber = partNumber_package.substring(partNumber_package.indexOf('(') + 1);
	NUTOOL_PIN.g_packageNumber = NUTOOL_PIN.g_packageNumber.substring(0, NUTOOL_PIN.g_packageNumber.indexOf(')'));

	partNumber = partNumber_package.substring(0, partNumber_package.indexOf('('));
	switch (NUTOOL_PIN.g_packageNumber) {
	case 'LQFP64':
		switch (partNumber) {
		case "NUC121SC2AE":
			NUTOOL_PIN.g_packageNumberIndex = "LQFP64";
			break;
		case "NUC125SC2AE":
			NUTOOL_PIN.g_packageNumberIndex = "LQFP64(1.8 I/O)";
			break;
		}
		break;
	case 'LQFP48':
		switch (partNumber) {
		case "NUC121LC2AE":
			NUTOOL_PIN.g_packageNumberIndex = "LQFP48";
			break;
		case "NUC125LC2AE":
			NUTOOL_PIN.g_packageNumberIndex = "ILQFP48(1.8 I/O)";
			break;
		}
		break;
	case 'QFN33':
		switch (partNumber) {
		case "NUC121ZC2AE":
			NUTOOL_PIN.g_packageNumberIndex = "QFN33";
			break;
		case "NUC125ZC2AE":
			NUTOOL_PIN.g_packageNumberIndex = "IQFN33(1.8 I/O)";
			break;
		}
		break;
	}
	partNumber_package = null;
	partNumber = null;
};
