NUTOOL_PIN.g_cfg_chips = [
	//NUC100CN
	{ name: "NUC130VE3CN", pkg: "LQFP100" },
	{ name: "NUC140VE3CN", pkg: "LQFP100" },
	{ name: "NUC130RC1CN", pkg: "LQFP64" },
	{ name: "NUC130RD2CN", pkg: "LQFP64" },
	{ name: "NUC130RE3CN", pkg: "LQFP64" },
	{ name: "NUC140RC1CN", pkg: "LQFP64" },
	{ name: "NUC140RD2CN", pkg: "LQFP64" },
	{ name: "NUC140RE3CN", pkg: "LQFP64" },
	{ name: "NUC130LC1CN", pkg: "LQFP48" },
	{ name: "NUC130LD2CN", pkg: "LQFP48" },
	{ name: "NUC130LE3CN", pkg: "LQFP48" },
	{ name: "NUC140LC1CN", pkg: "LQFP48" },
	{ name: "NUC140LD2CN", pkg: "LQFP48" },
	{ name: "NUC140LE3CN", pkg: "LQFP48" },
	//NUC100DN
	{ name: "NUC100VE3DN", pkg: "LQFP100" },
	{ name: "NUC100RC1DN", pkg: "LQFP64" },
	{ name: "NUC100RD1DN", pkg: "LQFP64" },
	{ name: "NUC100RD2DN", pkg: "LQFP64" },
	{ name: "NUC100RE3DN", pkg: "LQFP64" },
	{ name: "NUC100LC1DN", pkg: "LQFP48" },
	{ name: "NUC100LD2DN", pkg: "LQFP48" },
	{ name: "NUC100LE3DN", pkg: "LQFP48" },
	{ name: "NUC120VE3DN", pkg: "LQFP100" },
	{ name: "NUC120RC1DN", pkg: "LQFP64" },
	{ name: "NUC120RD2DN", pkg: "LQFP64" },
	{ name: "NUC120RE3DN", pkg: "LQFP64" },
	{ name: "NUC120LC1DN", pkg: "LQFP48" },
	{ name: "NUC120LD2DN", pkg: "LQFP48" },
	{ name: "NUC120LE3DN", pkg: "LQFP48" },
	//NUC121AE
	{ name: "NUC121SC2AE", pkg: "LQFP64" },
	{ name: "NUC121LC2AE", pkg: "LQFP48" },
	{ name: "NUC121ZC2AE", pkg: "QFN33" },
	{ name: "NUC125SC2AE", pkg: "LQFP64" },
	{ name: "NUC125LC2AE", pkg: "LQFP48" },
	{ name: "NUC125ZC2AE", pkg: "QFN33" },
	//NUC123AE
	{ name: "NUC123ZD4AE0", pkg: "QFN33" },
	{ name: "NUC123ZC2AE1", pkg: "QFN33" },
	{ name: "NUC123SD4AE0", pkg: "LQFP64" },
	{ name: "NUC123SC2AE1", pkg: "LQFP64" },
	{ name: "NUC123LD4AE0", pkg: "LQFP48" },
	{ name: "NUC123LC2AE1", pkg: "LQFP48" },
	//NUC123AN
	{ name: "NUC123ZD4AN0", pkg: "QFN33" },
	{ name: "NUC123ZC2AN1", pkg: "QFN33" },
	{ name: "NUC123LD4AN0", pkg: "LQFP48" },
	{ name: "NUC123LC2AN1", pkg: "LQFP48" },
	{ name: "NUC123SD4AN0", pkg: "LQFP64" },
	{ name: "NUC123SC2AN1", pkg: "LQFP64" },
	// NUC126
	{ name: "NUC126LE4AE", pkg: "LQFP48" },
	{ name: "NUC126LG4AE", pkg: "LQFP48" },
	{ name: "NUC126SE4AE", pkg: "LQFP64" },
	{ name: "NUC126SG4AE", pkg: "LQFP64" },
	{ name: "NUC126VG4AE", pkg: "LQFP100" },
	{ name: "NUC126NE4AE", pkg: "QFN48" },
	// NUC1261
	{ name: "NUC1261LG4AE", pkg: "LQFP48" },
	{ name: "NUC1261LE4AE", pkg: "LQFP48" },
	{ name: "NUC1261NE4AE", pkg: "LQFP48" },
	{ name: "NUC1261SG4AE", pkg: "LQFP64" },
	{ name: "NUC1261SE4AE", pkg: "LQFP64" },
	// NUC1262
	{ name: "NUC1262NE4AE", pkg: "QFN48" },
	{ name: "NUC1262LE4AE", pkg: "LQFP48" },
	{ name: "NUC1262SE4AE", pkg: "LQFP64" },
	//NUC131
	{ name: "NUC131SC2AE", pkg: "LQFP64" },
	{ name: "NUC131SD2AE", pkg: "LQFP64" },
	{ name: "NUC131LC2AE", pkg: "LQFP48" },
	{ name: "NUC131LD2AE", pkg: "LQFP48" },
	{ name: "NUC131SC2AEU", pkg: "LQFP64" },
	{ name: "NUC131SD2AEU", pkg: "LQFP64" },
	{ name: "NUC131LC2AEU", pkg: "LQFP48" },
	{ name: "NUC131LD2AEU", pkg: "LQFP48" },
	//NUC1311
	{ name: "NUC1311LD2AE", pkg: "LQFP48" }
];

NUTOOL_PIN.g_cfg_pkgs = {
	"LQFP64": [
		'PB.14', 'PB.13', 'PB.12', 'PA.11', 'PA.10', 'PD.8', 'PD.9', 'PD.10', 'PD.11', 'PB.4',
		'PB.5', 'PB.6', 'PB.7', 'LDO', 'VDD', 'VSS',
		'VBUS', 'VDD33', 'D-', 'D+', 'PB.0', 'PB.1', 'PB.2', 'PB.3', 'PC.5', 'PC.4',
		'PC.3', 'PC.2', 'PC.1', 'PC.0', 'PB.10', 'PB.9',
		'VSS', 'PC.13', 'PC.12', 'PC.11', 'PC.10', 'VDD', 'PC.9', 'PC.8', 'PA.15', 'VSS',
		'PA.14', 'PA.13', 'PA.12', 'ICE_DAT', 'ICE_CLK', 'AVDD',
		'PD.0', 'PD.1', 'PD.2', 'PD.3', 'PD.4', 'PD.5', 'PB.15', 'PF.0', 'PF.1', '/RESET',
		'VSS', 'VDD', 'PF.2', 'PF.3', 'PVSS', 'PB.8'
	],
	"LQFP48": [
		'PVSS', 'PB.8', 'PB.14', 'PA.11', 'PA.10', 'PB.4', 'PB.5', 'PB.6', 'PB.7', 'LDO',
		'VDD', 'VSS',
		'VBUS', 'VDD33', 'D-', 'D+', 'PC.5', 'PC.4', 'PC.3', 'PC.2', 'PC.1', 'PC.0',
		'PB.10', 'PB.9',
		'PC.13', 'PC.12', 'PC.11', 'PC.10', 'PC.9', 'PC.8', 'PA.15', 'PA.14', 'PA.13', 'PA.12',
		'ICE_DAT', 'ICE_CLK',
		'AVDD', 'PD.0', 'PD.1', 'PD.2', 'PD.3', 'PD.4', 'PD.5', 'PF.0', 'PF.1', '/RESET',
		'PF.2', 'PF.3'
	],
	"QFN33": [
		'PB.14', 'PA.11', 'PA.10', 'PB.4', 'PB.5', 'LDO', 'VDD', 'VSS',
		'VBUS', 'VDD33', 'D-', 'D+', 'PC.3', 'PC.2', 'PC.1', 'PC.0',
		'PC.13', 'PC.12', 'PC.11', 'PC.10', 'PC.9', 'PC.8', 'ICE_DAT', 'ICE_CLK',
		'AVDD', 'PD.1', 'PD.2', 'PD.3', 'PF.0', 'PF.1', '/RESET', 'PVSS'
	]
};

NUTOOL_PIN.g_cfg_gpios = [
	{ f: ['PA.0:0'] },
	{ f: ['PA.1:0'] },
	{ f: ['PA.2:0'] },
	{ f: ['PA.3:0'] },
	{ f: ['PA.4:0'] },
	{ f: ['PA.5:0'] },
	{ f: ['PA.6:0'] },
	{ f: ['PA.7:0'] },
	{ f: ['PA.8:0'] },
	{ f: ['PA.9:0'] },
	{ f: ['PA.10:0', 'I2C1SDA:1', 'MISO10:2', 'MISO20:3'] },
	{ f: ['PA.11:0', 'I2C1SCL:1', 'SPICLK1:2', 'MOSI20:3'] },
	{ f: ['PA.12:0', 'PWM0:1'] },
	{ f: ['PA.13:0', 'PWM1:1'] },
	{ f: ['PA.14:0', 'PWM2:1'] },
	{ f: ['PA.15:0', 'PWM3:1', 'CLKO:2', 'I2SMCLK:3'] },

	{ f: ['PB.0:0', 'RXD0:1'] },
	{ f: ['PB.1:0', 'TXD0:1'] },
	{ f: ['PB.2:0', 'RTS0:1', 'T2EX:3'] },
	{ f: ['PB.3:0', 'CTS0:1', 'T3EX:3'] },
	{ f: ['PB.4:0', 'RXD1:1', 'SPISS20:2', 'SPISS11:3'] },
	{ f: ['PB.5:0', 'TXD1:1', 'SPICLK2:3'] },
	{ f: ['PB.6:0', 'RTS1:1', 'MOSI20:3'] },
	{ f: ['PB.7:0', 'CTS1:1', 'MISO20:3'] },
	{ f: ['PB.8:0', 'TM0:1'] },
	{ f: ['PB.9:0', 'TM1:1', 'SPISS11:3'] },
	{ f: ['PB.10:0', 'TM2:1', 'SPISS01:3'] },
	{ f: ['PB.11:0'] },
	{ f: ['PB.12:0', 'SPISS10:1', 'CLKO:3'] },
	{ f: ['PB.13:0'] },
	{ f: ['PB.14:0', 'INT0:1'] },
	{ f: ['PB.15:0', 'INT1:1', 'T0EX:3'] },

	{ f: ['PC.0:0', 'SPISS00:1', 'I2SLRCLK:3'] },
	{ f: ['PC.1:0', 'SPICLK0:1', 'I2SBCLK:3'] },
	{ f: ['PC.2:0', 'MISO00:1', 'I2SDI:3'] },
	{ f: ['PC.3:0', 'MOSI00:1', 'I2SDO:3'] },
	{ f: ['PC.4:0', 'MISO01:1', 'RXD0:3'] },
	{ f: ['PC.5:0', 'MOSI01:1', 'TXD0:3'] },
	{ f: ['PC.6:0'] },
	{ f: ['PC.7:0'] },
	{ f: ['PC.8:0', 'SPISS10:1'] },
	{ f: ['PC.9:0', 'SPICLK1:1'] },
	{ f: ['PC.10:0', 'MISO10:1'] },
	{ f: ['PC.11:0', 'MOSI10:1'] },
	{ f: ['PC.12:0', 'MISO11:1', 'I2SMCLK:2', 'PWM2:3'] },
	{ f: ['PC.13:0', 'MOSI11:1', 'CLKO:2', 'PWM3:3'] },
	{ f: ['PC.14:0'] },
	{ f: ['PC.15:0'] },

	{ f: ['PD.0:0', 'SPISS20:2', 'ADC0:3'] },
	{ f: ['PD.1:0', 'SPISS01:1', 'SPICLK2:2', 'ADC1:3'] },
	{ f: ['PD.2:0', 'MISO01:1', 'MISO20:2', 'ADC2:3'] },
	{ f: ['PD.3:0', 'MOSI01:1', 'MOSI20:2', 'ADC3:3'] },
	{ f: ['PD.4:0', 'MISO21:2', 'ADC4:3'] },
	{ f: ['PD.5:0', 'MOSI21:2', 'ADC5:3'] },
	{ f: ['PD.6:0'] },
	{ f: ['PD.7:0'] },
	{ f: ['PD.8:0', 'MOSI10:1'] },
	{ f: ['PD.9:0'] },
	{ f: ['PD.10:0', 'CLKO:1'] },
	{ f: ['PD.11:0', 'INT1:1'] },
	{ f: ['PD.12:0'] },
	{ f: ['PD.13:0'] },
	{ f: ['PD.14:0'] },
	{ f: ['PD.15:0'] },

	{ f: ['PE.0:0'] },
	{ f: ['PE.1:0'] },
	{ f: ['PE.2:0'] },
	{ f: ['PE.3:0'] },
	{ f: ['PE.4:0'] },
	{ f: ['PE.5:0'] },
	{ f: ['PE.6:0'] },
	{ f: ['PE.7:0'] },
	{ f: ['PE.8:0'] },
	{ f: ['PE.9:0'] },
	{ f: ['PE.10:0'] },
	{ f: ['PE.11:0'] },
	{ f: ['PE.12:0'] },
	{ f: ['PE.13:0'] },
	{ f: ['PE.14:0'] },
	{ f: ['PE.15:0'] },

	{ f: ['PF.0:0', 'XT1_OUT:1'] },
	{ f: ['PF.1:0', 'XT1_IN:1'] },
	{ f: ['PF.2:0', 'PS2DAT:1', 'I2C0SDA:5', 'ADC6:7'] },
	{ f: ['PF.3:0', 'PS2CLK:1', 'I2C0SCL:5', 'ADC7:7'] }
];

NUTOOL_PIN.g_cfg_gpiosDefines = [
	{ f: ['PA.0'] },
	{ f: ['PA.1'] },
	{ f: ['PA.2'] },
	{ f: ['PA.3'] },
	{ f: ['PA.4'] },
	{ f: ['PA.5'] },
	{ f: ['PA.6'] },
	{ f: ['PA.7'] },
	{ f: ['PA.8'] },
	{ f: ['PA.9'] },
	{ f: ['PA.10', 'I2C1SDA:SYS_GPA_MFP_PA10_I2C1_SDA@GPA_MFP', 'MISO10:SYS_ALT_MFP_PA10_SPI1_MISO0@ALT_MFP', 'MISO20:SYS_GPA_MFP_PA10_SPI2_MISO0@GPA_MFP/SYS_ALT_MFP_PA10_SPI2_MISO0@ALT_MFP'] },
	{ f: ['PA.11', 'I2C1SCL:SYS_GPA_MFP_PA11_I2C1_SCL@GPA_MFP', 'SPICLK1:SYS_ALT_MFP_PA11_SPI1_CLK@ALT_MFP', 'MOSI20:SYS_GPA_MFP_PA11_SPI2_MOSI0@GPA_MFP/SYS_ALT_MFP_PA11_SPI2_MOSI0@ALT_MFP'] },
	{ f: ['PA.12', 'PWM0:SYS_GPA_MFP_PA12_PWM0@GPA_MFP'] },
	{ f: ['PA.13', 'PWM1:SYS_GPA_MFP_PA13_PWM1@GPA_MFP'] },
	{ f: ['PA.14', 'PWM2:SYS_GPA_MFP_PA14_PWM2@GPA_MFP'] },
	{ f: ['PA.15', 'PWM3:SYS_GPA_MFP_PA15_PWM3@GPA_MFP', 'CLKO:SYS_ALT_MFP_PA15_CLKO@ALT_MFP', 'I2SMCLK:SYS_GPA_MFP_PA15_I2S_MCLK@GPA_MFP/SYS_ALT_MFP_PA15_I2S_MCLK@ALT_MFP'] },

	{ f: ['PB.0', 'RXD0:SYS_GPB_MFP_PB0_UART0_RXD@GPB_MFP'] },
	{ f: ['PB.1', 'TXD0:SYS_GPB_MFP_PB1_UART0_TXD@GPB_MFP'] },
	{ f: ['PB.2', 'RTS0:SYS_GPB_MFP_PB2_UART0_nRTS@GPB_MFP', 'T2EX:SYS_GPB_MFP_PB2_TM2_EXT@GPB_MFP/SYS_ALT_MFP_PB2_TM2_EXT@ALT_MFP'] },
	{ f: ['PB.3', 'CTS0:SYS_GPB_MFP_PB3_UART0_nCTS@GPB_MFP', 'T3EX:SYS_GPB_MFP_PB3_TM3_EXT@GPB_MFP/SYS_ALT_MFP_PB3_TM3_EXT@ALT_MFP'] },
	{ f: ['PB.4', 'RXD1:SYS_GPB_MFP_PB4_UART1_RXD@GPB_MFP', 'SPISS20:SYS_ALT_MFP_PB4_SPI2_SS0@ALT_MFP', 'SPISS11:SYS_GPB_MFP_PB4_SPI1_SS1@GPB_MFP/SYS_ALT_MFP_PB4_SPI1_SS1@ALT_MFP'] },
	{ f: ['PB.5', 'TXD1:SYS_GPB_MFP_PB5_UART1_TXD@GPB_MFP', 'SPICLK2:SYS_GPB_MFP_PB5_SPI2_CLK@GPB_MFP/SYS_ALT_MFP_PB5_SPI2_CLK@ALT_MFP'] },
	{ f: ['PB.6', 'RTS1:SYS_GPB_MFP_PB6_UART1_nRTS@GPB_MFP', 'MOSI20:SYS_GPB_MFP_PB6_SPI2_MOSI0@GPB_MFP/SYS_ALT_MFP_PB6_SPI2_MOSI0@ALT_MFP'] },
	{ f: ['PB.7', 'CTS1:SYS_GPB_MFP_PB7_UART1_nCTS@GPB_MFP', 'MISO20:SYS_GPB_MFP_PB7_SPI2_MISO0@GPB_MFP/SYS_ALT_MFP_PB7_SPI2_MISO0@ALT_MFP'] },
	{ f: ['PB.8', 'TM0:SYS_GPB_MFP_PB8_TM0@GPB_MFP'] },
	{ f: ['PB.9', 'TM1:SYS_GPB_MFP_PB9_TM1@GPB_MFP', 'SPISS11:SYS_GPB_MFP_PB9_SPI1_SS1@GPB_MFP/SYS_ALT_MFP_PB9_SPI1_SS1@ALT_MFP'] },
	{ f: ['PB.10', 'TM2:SYS_GPB_MFP_PB10_TM2@GPB_MFP', 'SPISS01:SYS_GPB_MFP_PB10_SPI0_SS1@GPB_MFP/SYS_ALT_MFP_PB10_SPI0_SS1@ALT_MFP'] },
	{ f: ['PB.11'] },
	{ f: ['PB.12', 'SPISS10:SYS_GPB_MFP_PB12_SPI1_SS0@GPB_MFP', 'CLKO:SYS_GPB_MFP_PB12_CLKO@GPB_MFP/SYS_ALT_MFP_PB12_CLKO@ALT_MFP'] },
	{ f: ['PB.13'] },
	{ f: ['PB.14', 'INT0:SYS_GPB_MFP_PB14_INT0@GPB_MFP'] },
	{ f: ['PB.15', 'INT1:SYS_GPB_MFP_PB15_INT1@GPB_MFP', 'T0EX:SYS_GPB_MFP_PB15_TM0_EXT@GPB_MFP/SYS_ALT_MFP_PB15_TM0_EXT@ALT_MFP'] },

	{ f: ['PC.0', 'SPISS00:SYS_GPC_MFP_PC0_SPI0_SS0@GPC_MFP', 'I2SLRCLK:SYS_GPC_MFP_PC0_I2S_LRCLK@GPC_MFP/SYS_ALT_MFP_PC0_I2S_LRCLK@ALT_MFP'] },
	{ f: ['PC.1', 'SPICLK0:SYS_GPC_MFP_PC1_SPI0_CLK@GPC_MFP', 'I2SBCLK:SYS_GPC_MFP_PC1_I2S_BCLK@GPC_MFP/SYS_ALT_MFP_PC1_I2S_BCLK@ALT_MFP'] },
	{ f: ['PC.2', 'MISO00:SYS_GPC_MFP_PC2_SPI0_MISO0@GPC_MFP', 'I2SDI:SYS_GPC_MFP_PC2_I2S_DI@GPC_MFP/SYS_ALT_MFP_PC2_I2S_DI@ALT_MFP'] },
	{ f: ['PC.3', 'MOSI00:SYS_GPC_MFP_PC3_SPI0_MOSI0@GPC_MFP', 'I2SDO:SYS_GPC_MFP_PC3_I2S_DO@GPC_MFP/SYS_ALT_MFP_PC3_I2S_DO@ALT_MFP'] },
	{ f: ['PC.4', 'MISO01:SYS_GPC_MFP_PC4_SPI0_MISO1@GPC_MFP', 'RXD0:SYS_GPC_MFP_PC4_UART0_RXD@GPC_MFP/SYS_ALT_MFP_PC4_UART0_RXD@ALT_MFP'] },
	{ f: ['PC.5', 'MOSI01:SYS_GPC_MFP_PC5_SPI0_MOSI1@GPC_MFP', 'TXD0:SYS_GPC_MFP_PC5_UART0_TXD@GPC_MFP/SYS_ALT_MFP_PC5_UART0_TXD@ALT_MFP'] },
	{ f: ['PC.6'] },
	{ f: ['PC.7'] },
	{ f: ['PC.8', 'SPISS10:SYS_GPC_MFP_PC8_SPI1_SS0@GPC_MFP'] },
	{ f: ['PC.9', 'SPICLK1:SYS_GPC_MFP_PC9_SPI1_CLK@GPC_MFP'] },
	{ f: ['PC.10', 'MISO10:SYS_GPC_MFP_PC10_SPI1_MISO0@GPC_MFP'] },
	{ f: ['PC.11', 'MOSI10:SYS_GPC_MFP_PC11_SPI1_MOSI0@GPC_MFP'] },
	{ f: ['PC.12', 'MISO11:SYS_GPC_MFP_PC12_SPI1_MISO1@GPC_MFP', 'I2SMCLK:SYS_ALT_MFP_PC12_I2S_MCLK@ALT_MFP', 'PWM2:SYS_GPC_MFP_PC12_PWM2@GPC_MFP/SYS_ALT_MFP_PC12_PWM2@ALT_MFP'] },
	{ f: ['PC.13', 'MOSI11:SYS_GPC_MFP_PC13_SPI1_MOSI1@GPC_MFP', 'CLKO:SYS_ALT_MFP_PC13_CLKO@ALT_MFP', 'PWM3:SYS_GPC_MFP_PC13_PWM3@GPC_MFP/SYS_ALT_MFP_PC13_PWM3@ALT_MFP'] },
	{ f: ['PC.14'] },
	{ f: ['PC.15'] },

	{ f: ['PD.0', 'SPISS20:SYS_ALT_MFP1_PD0_SPI2_SS0@ALT_MFP1', 'ADC0:SYS_GPD_MFP_PD0_ADC0@GPD_MFP/SYS_ALT_MFP1_PD0_ADC0@ALT_MFP1'] },
	{ f: ['PD.1', 'SPISS01:SYS_GPD_MFP_PD1_SPI0_SS1@GPD_MFP', 'SPICLK2:SYS_ALT_MFP1_PD1_SPI2_CLK@ALT_MFP1', 'ADC1:SYS_GPD_MFP_PD1_ADC1@GPD_MFP/SYS_ALT_MFP1_PD1_ADC1@ALT_MFP1'] },
	{ f: ['PD.2', 'MISO01:SYS_GPD_MFP_PD2_SPI0_MISO1@GPD_MFP', 'MISO20:SYS_ALT_MFP1_PD2_SPI2_MISO0@ALT_MFP1', 'ADC2:SYS_GPD_MFP_PD2_ADC2@GPD_MFP/SYS_ALT_MFP1_PD2_ADC2@ALT_MFP1'] },
	{ f: ['PD.3', 'MOSI01:SYS_GPD_MFP_PD3_SPI0_MOSI1@GPD_MFP', 'MOSI20:SYS_ALT_MFP1_PD3_SPI2_MOSI0@ALT_MFP1', 'ADC3:SYS_GPD_MFP_PD3_ADC3@GPD_MFP/SYS_ALT_MFP1_PD3_ADC3@ALT_MFP1'] },
	{ f: ['PD.4', 'MISO21:SYS_ALT_MFP1_PD4_SPI2_MISO1@ALT_MFP1', 'ADC4:SYS_GPD_MFP_PD4_ADC4@GPD_MFP/SYS_ALT_MFP1_PD4_ADC4@ALT_MFP1'] },
	{ f: ['PD.5', 'MOSI21:SYS_ALT_MFP1_PD5_SPI2_MOSI1@ALT_MFP1', 'ADC5:SYS_GPD_MFP_PD5_ADC5@GPD_MFP/SYS_ALT_MFP1_PD5_ADC5@ALT_MFP1'] },
	{ f: ['PD.6'] },
	{ f: ['PD.7'] },
	{ f: ['PD.8', 'MOSI10:SYS_GPD_MFP_PD8_SPI1_MOSI0@GPD_MFP'] },
	{ f: ['PD.9'] },
	{ f: ['PD.10', 'CLKO:SYS_GPD_MFP_PD10_CLKO@GPD_MFP'] },
	{ f: ['PD.11', 'INT1:SYS_GPD_MFP_PD11_INT1@GPD_MFP'] },
	{ f: ['PD.12'] },
	{ f: ['PD.13'] },
	{ f: ['PD.14'] },
	{ f: ['PD.15'] },

	{ f: ['PF.0', 'XT1_OUT:SYS_GPF_MFP_PF0_XT1_OUT@GPF_MFP'] },
	{ f: ['PF.1', 'XT1_IN:SYS_GPF_MFP_PF1_XT1_IN@GPF_MFP'] },
	{ f: ['PF.2', 'PS2DAT:SYS_GPF_MFP_PF2_PS2_DAT@GPF_MFP', 'I2C0SDA:SYS_GPF_MFP_PF2_I2C0_SDA@GPF_MFP/SYS_ALT_MFP1_PF2_I2C0_SDA@ALT_MFP1', 'ADC6:SYS_GPF_MFP_PF2_ADC6@GPF_MFP/SYS_ALT_MFP1_PF2_ADC6@ALT_MFP1'] },
	{ f: ['PF.3', 'PS2CLK:SYS_GPF_MFP_PF3_PS2_CLK@GPF_MFP', 'I2C0SCL:SYS_GPF_MFP_PF3_I2C0_SCL@GPF_MFP/SYS_ALT_MFP1_PF3_I2C0_SCL@ALT_MFP1', 'ADC7:SYS_GPF_MFP_PF3_ADC7@GPF_MFP/SYS_ALT_MFP1_PF3_ADC7@ALT_MFP1'] }
];

NUTOOL_PIN.g_cfg_gpiosDescriptions = [
	'/RESET:External reset input: Low active, set this pin low reset chip to initial state. With internal pull-up',
	'ADC0:ADC channel 0 analog input pin',
	'ADC1:ADC channel 1 analog input pin',
	'ADC2:ADC channel 2 analog input pin',
	'ADC3:ADC channel 3 analog input pin',
	'ADC4:ADC channel 4 analog input pin',
	'ADC5:ADC channel 5 analog input pin',
	'ADC6:ADC channel 6 analog input pin',
	'ADC7:ADC channel 7 analog input pin',

	'AVDD:Power supply for internal analog circuit',

	'CLKO:Frequency Divider output pin',
	'CTS0:UART0 clear to send input pin',
	'CTS1:UART1 clear to send input pin',

	'D-:USB differential signal D-',
	'D+:USB differential signal D+',

	'I2C0SCL:I2C0 clock pin',
	'I2C0SDA:I2C0 data input/output pin',
	'I2C1SCL:I2C1 clock pin',
	'I2C1SDA:I2C1 data input/output pin',

	'I2SBCLK:I2S bit clock pin',
	'I2SDI:I2S data input pin',
	'I2SDO:I2S data output pin',
	'I2SLRCLK:I2S left/right channel clock pin',
	'I2SMCLK:I2S master clock output pin',

	'ICE_CK:Serial wired debugger clock input pin',
	'ICE_DAT:Serial wired debugger data pin',

	'INT0:External interrupt 0 input pin',
	'INT1:External interrupt 1 input pin',

	'LDO:LDO output pin',

	'MISO00:SPI0 1st MISO (Master In, Slave Out) pin',
	'MISO01:SPI0 2nd MISO (Master In, Slave Out) pin',
	'MISO10:SPI1 1st MISO (Master In, Slave Out) pin',
	'MISO11:SPI1 2nd MISO (Master In, Slave Out) pin',
	'MISO20:SPI2 1st MISO (Master In, Slave Out) pin',
	'MISO21:SPI2 2nd MISO (Master In, Slave Out) pin',
	'MOSI00:SPI0 1st MOSI (Master Out, Slave In) pin',
	'MOSI01:SPI0 2nd MOSI (Master Out, Slave In) pin',
	'MOSI10:SPI1 1st MOSI (Master Out, Slave In) pin',
	'MOSI11:SPI1 2nd MOSI (Master Out, Slave In) pin',
	'MOSI20:SPI2 1st MOSI (Master Out, Slave In) pin',
	'MOSI21:SPI2 2nd MOSI (Master Out, Slave In) pin',

	'PS2CLK:PS/2 clock pin',
	'PS2DAT:PS/2 data pin',

	'PVSS:PLL ground',

	'PWM0:PWM0 PWM output / capture input pin',
	'PWM1:PWM1 PWM output / capture input pin',
	'PWM2:PWM2 PWM output / capture input pin',
	'PWM3:PWM3 PWM output / capture input pin',

	'RTS0:UART0 request to send output pin',
	'RTS1:UART1 request to send output pin',

	'RXD0:UART0 data receiver input pin',
	'RXD1:UART1 data receiver input pin',

	'SPICLK0:SPI0 serial clock pin',
	'SPICLK1:SPI1 serial clock pin',
	'SPICLK2:SPI2 serial clock pin',
	'SPISS00:SPI0 1st slave select pin',
	'SPISS01:SPI0 2nd slave select pin',
	'SPISS10:SPI1 1st slave select pin',
	'SPISS11:SPI1 2nd slave select pin',
	'SPISS20:SPI2 1st slave select pin',

	'T0EX:Timer0 external capture input pin',
	'T2EX:Timer2 external capture input pin',
	'T3EX:Timer3 external capture input pin',

	'TM0:Timer2 event counter input / toggle output pin',
	'TM1:Timer1 event counter input / toggle output pin',
	'TM2:Timer2 event counter input / toggle output pin',

	'TXD0:UART0 data transmitter output pin',
	'TXD1:UART1 data transmitter output pin',

	'VBUS:Power supply from USB host or hub',

	'VDD:Power supply for I/O ports and LDO source for internal PLL and digital circuit. Voltage range is 2.5 V ~ 5.5V',
	'VDD33:Internal power regulator output 3.3V decoupling pin',
	'VSS:Ground',

	'XT1_IN:External 4~24 MHz high speed crystal input pin',
	'XT1_OUT:External 4~24 MHz high speed crystal output pin'
];

NUTOOL_PIN.g_cfg_regDescriptions = {};
NUTOOL_PIN.g_cfg_regDescriptions.GPA_MFP = '0x50000030';
NUTOOL_PIN.g_cfg_regDescriptions.GPB_MFP = '0x50000034';
NUTOOL_PIN.g_cfg_regDescriptions.GPC_MFP = '0x50000038';
NUTOOL_PIN.g_cfg_regDescriptions.GPD_MFP = '0x5000003C';
NUTOOL_PIN.g_cfg_regDescriptions.GPF_MFP = '0x50000044';
NUTOOL_PIN.g_cfg_regDescriptions.ALT_MFP = '0x50000050';
NUTOOL_PIN.g_cfg_regDescriptions.ALT_MFP1 = '0x50000054';

NUTOOL_PIN.g_cfg_gpioMatrix = [
	{ f: ['PA.0'] },
	{ f: ['PA.1'] },
	{ f: ['PA.2'] },
	{ f: ['PA.3'] },
	{ f: ['PA.4'] },
	{ f: ['PA.5'] },
	{ f: ['PA.6'] },
	{ f: ['PA.7'] },
	{ f: ['PA.8'] },
	{ f: ['PA.9'] },
	{ f: ['PA.10', 'GPA_MFP[10]:0', 'ALT_MFP[12]:1'] },
	{ f: ['PA.11', 'GPA_MFP[11]:0', 'ALT_MFP[11]:1'] },
	{ f: ['PA.12', 'GPA_MFP[12]:0'] },
	{ f: ['PA.13', 'GPA_MFP[13]:0'] },
	{ f: ['PA.14', 'GPA_MFP[14]:0'] },
	{ f: ['PA.15', 'GPA_MFP[15]:0', 'ALT_MFP[9]:1'] },

	{ f: ['PB.0', 'GPB_MFP[0]:0'] },
	{ f: ['PB.1', 'GPB_MFP[1]:0'] },
	{ f: ['PB.2', 'GPB_MFP[2]:0', 'ALT_MFP[26]:1'] },
	{ f: ['PB.3', 'GPB_MFP[3]:0', 'ALT_MFP[27]:1'] },
	{ f: ['PB.4', 'GPB_MFP[4]:0', 'ALT_MFP[15]:1'] },
	{ f: ['PB.5', 'GPB_MFP[5]:0', 'ALT_MFP[18]:1'] },
	{ f: ['PB.6', 'GPB_MFP[6]:0', 'ALT_MFP[17]:1'] },
	{ f: ['PB.7', 'GPB_MFP[7]:0', 'ALT_MFP[16]:1'] },
	{ f: ['PB.8', 'GPB_MFP[8]:0'] },
	{ f: ['PB.9', 'GPB_MFP[9]:0', 'ALT_MFP[1]:1'] },
	{ f: ['PB.10', 'GPB_MFP[10]:0', 'ALT_MFP[0]:1'] },
	{ f: ['PB.11'] },
	{ f: ['PB.12', 'GPB_MFP[12]:0', 'ALT_MFP[10]:1'] },
	{ f: ['PB.13'] },
	{ f: ['PB.14', 'GPB_MFP[14]:0'] },
	{ f: ['PB.15', 'GPB_MFP[15]:0', 'ALT_MFP[24]:1'] },

	{ f: ['PC.0', 'GPC_MFP[0]:0', 'ALT_MFP[5]:1'] },
	{ f: ['PC.1', 'GPC_MFP[1]:0', 'ALT_MFP[6]:1'] },
	{ f: ['PC.2', 'GPC_MFP[2]:0', 'ALT_MFP[7]:1'] },
	{ f: ['PC.3', 'GPC_MFP[3]:0', 'ALT_MFP[8]:1'] },
	{ f: ['PC.4', 'GPC_MFP[4]:0', 'ALT_MFP[29]:1'] },
	{ f: ['PC.5', 'GPC_MFP[5]:0', 'ALT_MFP[30]:1'] },
	{ f: ['PC.6'] },
	{ f: ['PC.7'] },
	{ f: ['PC.8', 'GPC_MFP[8]:0'] },
	{ f: ['PC.9', 'GPC_MFP[9]:0'] },
	{ f: ['PC.10', 'GPC_MFP[10]:0'] },
	{ f: ['PC.11', 'GPC_MFP[11]:0'] },
	{ f: ['PC.12', 'GPC_MFP[12]:0', 'ALT_MFP[20]:1'] },
	{ f: ['PC.13', 'GPC_MFP[13]:0', 'ALT_MFP[21]:1'] },
	{ f: ['PC.14'] },
	{ f: ['PC.15'] },

	{ f: ['PD.0', 'GPD_MFP[0]:0', 'ALT_MFP1[16]:1'] },
	{ f: ['PD.1', 'GPD_MFP[1]:0', 'ALT_MFP1[17]:1'] },
	{ f: ['PD.2', 'GPD_MFP[2]:0', 'ALT_MFP1[18]:1'] },
	{ f: ['PD.3', 'GPD_MFP[3]:0', 'ALT_MFP1[19]:1'] },
	{ f: ['PD.4', 'GPD_MFP[4]:0', 'ALT_MFP1[20]:1'] },
	{ f: ['PD.5', 'GPD_MFP[5]:0', 'ALT_MFP1[21]:1'] },
	{ f: ['PD.6'] },
	{ f: ['PD.7'] },
	{ f: ['PD.8', 'GPD_MFP[8]:0'] },
	{ f: ['PD.9'] },
	{ f: ['PD.10', 'GPD_MFP[10]:0'] },
	{ f: ['PD.11', 'GPD_MFP[11]:0'] },
	{ f: ['PD.12'] },
	{ f: ['PD.13'] },
	{ f: ['PD.14'] },
	{ f: ['PD.15'] },

	{ f: ['PE.0'] },
	{ f: ['PE.1'] },
	{ f: ['PE.2'] },
	{ f: ['PE.3'] },
	{ f: ['PE.4'] },
	{ f: ['PE.5'] },
	{ f: ['PE.6'] },
	{ f: ['PE.7'] },
	{ f: ['PE.8'] },
	{ f: ['PE.9'] },
	{ f: ['PE.10'] },
	{ f: ['PE.11'] },
	{ f: ['PE.12'] },
	{ f: ['PE.13'] },
	{ f: ['PE.14'] },
	{ f: ['PE.15'] },

	{ f: ['PF.0', 'GPF_MFP[0]:0'] },
	{ f: ['PF.1', 'GPF_MFP[1]:0'] },
	{ f: ['PF.2', 'GPF_MFP[2]:0', 'ALT_MFP1[24]:1', 'ALT_MFP1[25]:2'] },
	{ f: ['PF.3', 'GPF_MFP[3]:0', 'ALT_MFP1[26]:1', 'ALT_MFP1[27]:2'] }
];

NUTOOL_PIN.g_cfg_shareBits = [];
NUTOOL_PIN.g_cfg_addGPIO = {};
NUTOOL_PIN.g_cfg_unusedGPIO = {
	"NUC123ZD4AN0(QFN33)": {
		"PD.1": ["ADC1"],
		"PD.2": ["ADC2"],
		"PD.3": ["ADC3"]
	},
	"NUC123ZC2AN1(QFN33)": function () {
		return this["NUC123ZD4AN0(QFN33)"];
	}
};

NUTOOL_PIN.decidepackageNumber = function (given_partNumber_package) {
	var partNumber_package;

	if (typeof given_partNumber_package === 'undefined') {
		partNumber_package = NUTOOL_PIN.getg_partNumber_package();
	}
	else {
		partNumber_package = given_partNumber_package;
	}

	NUTOOL_PIN.g_packageNumber = partNumber_package.substring(partNumber_package.indexOf('(') + 1);
	NUTOOL_PIN.g_packageNumber = NUTOOL_PIN.g_packageNumber.substring(0, NUTOOL_PIN.g_packageNumber.indexOf(')'));
	NUTOOL_PIN.g_packageNumberIndex = NUTOOL_PIN.g_packageNumber;

	partNumber_package = null;
};
