//chip content
NUTOOL_PIN.g_cfg_chips = [
	{ name: "M0A21OB1AC", pkg: "SSOP20" },
	{ name: "M0A21OC1AC", pkg: "SSOP20" },
	//{ name: "M0A23OB1AC", pkg: "SSOP20" },
	{ name: "M0A23OC1AC", pkg: "SSOP20" },
	{ name: "M0A21EB1AC", pkg: "TSSOP28" },
	//{ name: "M0A23EB1AC", pkg: "TSSOP28" },
	{ name: "M0A21EC1AC", pkg: "TSSOP28" },
	{ name: "M0A23EC1AC", pkg: "TSSOP28" }
];

NUTOOL_PIN.g_cfg_pkgs = {
	"SSOP20": [
		'VDD', 'PA.5', 'PA.4', 'PA.3', 'PC.5',
		'PC.4', 'PC.3', 'PC.6', 'PC.7', 'PB.7',
		'PB.6', 'PB.5', 'PB.4', 'PC.2', 'PC.1',
		'PC.0', 'PA.2', 'PA.1', 'PA.0', 'VSS'
	],
	"TSSOP28": [
		'VDD', 'PA.5', 'PA.4', 'PA.3', 'PC.5', 'PC.4', 'PC.3',
		'PD.0', 'PD.1', 'PD.2', 'PD.3', 'PC.6', 'PC.7', 'PB.7',
		'PB.6', 'PB.5', 'PD.4', 'PD.5', 'PD.6', 'PD.7', 'PB.4',
		'PC.2', 'PC.1', 'PC.0', 'PA.2', 'PA.1', 'PA.0', 'VSS'
	]
};

NUTOOL_PIN.g_cfg_gpios = [
	{ f: ['PA.0:0', 'ADC0_CH0:1', 'DAC0_OUT:1', 'ACMP0_P0:1', 'ICE_DAT:2', 'UART0_nCTS:3', 'CLKO:4', 'PWM0_CH1:5', 'PWM0_CH3:6', 'PWM0_CH5:7', 'UART0_TXD:8', 'UART0_RXD:9', 'USCI0_CLK:10', 'USCI0_DAT0:11', 'USCI0_DAT1:12', 'USCI0_CTL0:13', 'USCI0_CTL1:14', 'USCI1_CLK:15', 'USCI1_DAT0:16', 'USCI1_DAT1:17', 'USCI1_CTL0:18', 'CAN0_TXD:19', 'CAN0_RXD:20', 'ACMP0_O:21', 'ACMP1_O:22', 'ADC0_ST:23', 'TM1:24', 'TM3:25', 'TM1_EXT:26', 'TM3_EXT:27', 'UART1_TXD:28', 'UART1_RXD:29', 'PWM0_BRAKE1:30']},
	{ f: ['PA.1:0', 'ADC0_CH1:1', 'ACMP0_N0:1', 'ACMP1_N0:1', 'VREF:1', 'ICE_CLK:2', 'UART0_nCTS:3', 'CLKO:4', 'PWM0_CH0:5', 'PWM0_CH2:6', 'PWM0_CH4:7', 'UART0_TXD:8', 'UART0_RXD:9', 'USCI0_CLK:10', 'USCI0_DAT0:11', 'USCI0_DAT1:12', 'USCI0_CTL0:13', 'USCI1_CTL1:14', 'USCI1_CLK:15', 'USCI1_DAT0:16', 'USCI1_DAT1:17', 'USCI1_CTL0:18', 'CAN0_TXD:19', 'CAN0_RXD:20', 'ACMP0_O:21', 'ACMP1_O:22', 'ADC0_ST:23', 'TM0:24', 'TM2:25', 'TM0_EXT:26', 'TM2_EXT:27', 'UART1_TXD:28', 'UART1_RXD:29', 'PWM0_BRAKE0:30']},
	{ f: ['PA.2:0', 'ADC0_CH2:1', 'UART0_nRTS:2', 'UART0_nCTS:3', 'CLKO:4', 'PWM0_CH1:5', 'PWM0_CH3:6', 'PWM0_CH5:7', 'UART0_TXD:8', 'UART0_RXD:9', 'USCI0_CLK:10', 'USCI0_DAT0:11', 'USCI0_DAT1:12', 'USCI0_CTL0:13', 'USCI0_CTL1:14', 'USCI1_CLK:15', 'USCI1_DAT0:16', 'USCI1_DAT1:17', 'USCI1_CTL0:18', 'CAN0_TXD:19', 'CAN0_RXD:20', 'ACMP0_O:21', 'ACMP1_O:22', 'ADC0_ST:23', 'TM1:24', 'TM3:25', 'TM1_EXT:26', 'TM3_EXT:27', 'UART1_TXD:28', 'UART1_RXD:29', 'PWM0_BRAKE1:30']},
	{ f: ['PA.3:0', 'nRESET:2', 'UART0_nCTS:3', 'PWM0_CH0:5', 'PWM0_CH2:6', 'PWM0_CH4:7', 'UART0_RXD:9', 'USCI0_CLK:10', 'USCI0_DAT0:11', 'USCI0_DAT1:12', 'USCI0_CTL0:13', 'USCI0_CTL1:14', 'USCI1_CLK:15', 'USCI1_DAT0:16', 'USCI1_DAT1:17', 'USCI1_CTL0:18', 'CAN0_RXD:20', 'ADC0_ST:23', 'TM0:24', 'TM2:25', 'TM0_EXT:26', 'TM2_EXT:27', 'UART1_RXD:29', 'INT0:30']},
	{ f: ['PA.4:0', 'ADC0_CH15:1', 'UART0_nRTS:2', 'XT1_OUT:3', 'CLKO:4', 'PWM0_CH1:5', 'PWM0_CH3:6', 'PWM0_CH5:7', 'UART0_TXD:8', 'UART0_RXD:9', 'USCI0_CLK:10', 'USCI0_DAT0:11', 'USCI0_DAT1:12', 'USCI0_CTL0:13', 'USCI1_CTL1:14', 'USCI1_CLK:15', 'USCI1_DAT0:16', 'USCI1_DAT1:17', 'USCI1_CTL0:18', 'CAN0_TXD:19', 'CAN0_RXD:20', 'ACMP0_O:21', 'ACMP1_O:22', 'ADC0_ST:23', 'TM1:24', 'TM3:25', 'TM1_EXT:26', 'TM3_EXT:27', 'UART1_TXD:28', 'UART1_RXD:29', 'ACMP1_WLAT:30']},
	{ f: ['PA.5:0', 'ADC0_CH16:1', 'UART0_nRTS:2', 'XT1_IN:3', 'CLKO:4', 'PWM0_CH0:5', 'PWM0_CH2:6', 'PWM0_CH4:7', 'UART0_TXD:8', 'UART0_RXD:9', 'USCI0_CLK:10', 'USCI0_DAT0:11', 'USCI0_DAT1:12', 'USCI0_CTL0:13', 'USCI0_CTL1:14', 'USCI1_CLK:15', 'USCI1_DAT0:16', 'USCI1_DAT1:17', 'USCI1_CTL0:18', 'CAN0_TXD:19', 'CAN0_RXD:20', 'ACMP0_O:21', 'ACMP1_O:22', 'ADC0_ST:23', 'TM0:24', 'TM2:25', 'TM0_EXT:26', 'TM2_EXT:27', 'UART1_TXD:28', 'UART1_RXD:29', 'ACMP0_WLAT:30']},
	{ f: ['PA.6:0']},
	{ f: ['PA.7:0']},

	{ f: ['PB.0:0']},
	{ f: ['PB.1:0']},
	{ f: ['PB.2:0']},
	{ f: ['PB.3:0']},
	{ f: ['PB.4:0', 'ADC0_CH6:1', 'UART0_nRTS:2', 'UART0_nCTS:3', 'CLKO:4', 'PWM0_CH1:5', 'PWM0_CH3:6', 'PWM0_CH5:7', 'UART0_TXD:8', 'UART0_RXD:9', 'USCI0_CLK:10', 'USCI0_DAT0:11', 'USCI0_DAT1:12', 'USCI0_CTL0:13', 'USCI0_CTL1:14', 'USCI1_CLK:15', 'USCI1_DAT0:16', 'USCI1_DAT1:17', 'USCI1_CTL0:18', 'CAN0_TXD:19', 'CAN0_RXD:20', 'ACMP0_O:21', 'ACMP1_O:22', 'ADC0_ST:23', 'TM1:24', 'TM3:25', 'TM1_EXT:26', 'TM3_EXT:27', 'UART1_TXD:28', 'UART1_RXD:29', 'UART1_nCTS:30']},
	{ f: ['PB.5:0', 'ADC0_CH7:1', 'UART0_nRTS:2', 'UART0_nCTS:3', 'CLKO:4', 'PWM0_CH0:5', 'PWM0_CH2:6', 'PWM0_CH4:7', 'UART0_TXD:8', 'UART0_RXD:9', 'USCI0_CLK:10', 'USCI0_DAT0:11', 'USCI0_DAT1:12', 'USCI0_CTL0:13', 'USCI1_CTL1:14', 'USCI1_CLK:15', 'USCI1_DAT0:16', 'USCI1_DAT1:17', 'USCI1_CTL0:18', 'CAN0_TXD:19', 'CAN0_RXD:20', 'ACMP0_O:21', 'ACMP1_O:22', 'ADC0_ST:23', 'TM0:24', 'TM2:25', 'TM0_EXT:26', 'TM2_EXT:27', 'UART1_TXD:28', 'UART1_RXD:29', 'INT0:30']},
	{ f: ['PB.6:0', 'ADC0_CH8:1', 'UART0_nRTS:2', 'UART0_nCTS:3', 'CLKO:4', 'PWM0_CH1:5', 'PWM0_CH3:6', 'PWM0_CH5:7', 'UART0_TXD:8', 'UART0_RXD:9', 'USCI0_CLK:10', 'USCI0_DAT0:11', 'USCI0_DAT1:12', 'USCI0_CTL0:13', 'USCI0_CTL1:14', 'USCI1_CLK:15', 'USCI1_DAT0:16', 'USCI1_DAT1:17', 'USCI1_CTL0:18', 'CAN0_TXD:19', 'CAN0_RXD:20', 'ACMP0_O:21', 'ACMP1_O:22', 'ADC0_ST:23', 'TM1:24', 'TM3:25', 'TM1_EXT:26', 'TM3_EXT:27', 'UART1_TXD:28', 'UART1_RXD:29', 'ACMP1_WLAT:30']},
	{ f: ['PB.7:0', 'ADC0_CH9:1', 'UART0_nRTS:2', 'UART0_nCTS:3', 'CLKO:4', 'PWM0_CH0:5', 'PWM0_CH2:6', 'PWM0_CH4:7', 'UART0_TXD:8', 'UART0_RXD:9', 'USCI0_CLK:10', 'USCI0_DAT0:11', 'USCI0_DAT1:12', 'USCI0_CTL0:13', 'USCI1_CTL1:14', 'USCI1_CLK:15', 'USCI1_DAT0:16', 'USCI1_DAT1:17', 'USCI1_CTL0:18', 'CAN0_TXD:19', 'CAN0_RXD:20', 'ACMP0_O:21', 'ACMP1_O:22', 'ADC0_ST:23', 'TM0:24', 'TM2:25', 'TM0_EXT:26', 'TM2_EXT:27', 'UART1_TXD:28', 'UART1_RXD:29', 'ACMP0_WLAT:30']},

	{ f: ['PC.0:0', 'ADC0_CH3:1', 'ACMP1_P0:1', 'UART0_nRTS:2', 'UART0_nCTS:3', 'CLKO:4', 'PWM0_CH0:5', 'PWM0_CH2:6', 'PWM0_CH4:7', 'UART0_TXD:8', 'UART0_RXD:9', 'USCI0_CLK:10', 'USCI0_DAT0:11', 'USCI0_DAT1:12', 'USCI0_CTL0:13', 'USCI1_CTL1:14', 'USCI1_CLK:15', 'USCI1_DAT0:16', 'USCI1_DAT1:17', 'USCI1_CTL0:18', 'CAN0_TXD:19', 'CAN0_RXD:20', 'ACMP0_O:21', 'ACMP1_O:22', 'ADC0_ST:23', 'TM0:24', 'TM2:25', 'TM0_EXT:26', 'TM2_EXT:27', 'UART1_TXD:28', 'UART1_RXD:29', 'PWM0_BRAKE0:30']},
	{ f: ['PC.1:0', 'ADC0_CH4:1', 'ACMP0_N1:1', 'ACMP1_N1:1', 'UART0_nRTS:2', 'UART0_nCTS:3', 'CLKO:4', 'PWM0_CH1:5', 'PWM0_CH3:6', 'PWM0_CH5:7', 'UART0_TXD:8', 'UART0_RXD:9', 'USCI0_CLK:10', 'USCI0_DAT0:11', 'USCI0_DAT1:12', 'USCI0_CTL0:13', 'USCI0_CTL1:14', 'USCI1_CLK:15', 'USCI1_DAT0:16', 'USCI1_DAT1:17', 'USCI1_CTL0:18', 'CAN0_TXD:19', 'CAN0_RXD:20', 'ACMP0_O:21', 'ACMP1_O:22', 'ADC0_ST:23', 'TM1:24', 'TM3:25', 'TM1_EXT:26', 'TM3_EXT:27', 'UART1_TXD:28', 'UART1_RXD:29']},
	{ f: ['PC.2:0', 'ADC0_CH5:1', 'ACMP0_N2:1', 'ACMP1_N2:1', 'UART0_nRTS:2', 'UART0_nCTS:3', 'CLKO:4', 'PWM0_CH0:5', 'PWM0_CH2:6', 'PWM0_CH4:7', 'UART0_TXD:8', 'UART0_RXD:9', 'USCI0_CLK:10', 'USCI0_DAT0:11', 'USCI0_DAT1:12', 'USCI0_CTL0:13', 'USCI1_CTL1:14', 'USCI1_CLK:15', 'USCI1_DAT0:16', 'USCI1_DAT1:17', 'USCI1_CTL0:18', 'CAN0_TXD:19', 'CAN0_RXD:20', 'ACMP0_O:21', 'ACMP1_O:22', 'ADC0_ST:23', 'TM0:24', 'TM2:25', 'TM0_EXT:26', 'TM2_EXT:27', 'UART1_TXD:28', 'UART1_RXD:29', 'UART1_nRTS:30']},
	{ f: ['PC.3:0', 'ADC0_CH12:1', 'ACMP0_N3:1', 'ACMP1_N3:1', 'UART0_nRTS:2', 'UART0_nCTS:3', 'CLKO:4', 'PWM0_CH1:5', 'PWM0_CH3:6', 'PWM0_CH5:7', 'UART0_TXD:8', 'UART0_RXD:9', 'USCI0_CLK:10', 'USCI0_DAT0:11', 'USCI0_DAT1:12', 'USCI0_CTL0:13', 'USCI0_CTL1:14', 'USCI1_CLK:15', 'USCI1_DAT0:16', 'USCI1_DAT1:17', 'USCI1_CTL0:18', 'CAN0_TXD:19', 'CAN0_RXD:20', 'ACMP0_O:21', 'ACMP1_O:22', 'ADC0_ST:23', 'TM1:24', 'TM3:25', 'TM1_EXT:26', 'TM3_EXT:27', 'UART1_TXD:28', 'UART1_RXD:29', 'INT3:30']},
	{ f: ['PC.4:0', 'ADC0_CH13:1', 'X32_OUT:2', 'UART0_nCTS:3', 'CLKO:4', 'PWM0_CH0:5', 'PWM0_CH2:6', 'PWM0_CH4:7', 'UART0_TXD:8', 'UART0_RXD:9', 'USCI0_CLK:10', 'USCI0_DAT0:11', 'USCI0_DAT1:12', 'USCI0_CTL0:13', 'USCI1_CTL1:14', 'USCI1_CLK:15', 'USCI1_DAT0:16', 'USCI1_DAT1:17', 'USCI1_CTL0:18', 'CAN0_TXD:19', 'CAN0_RXD:20', 'ACMP0_O:21', 'ACMP1_O:22', 'ADC0_ST:23', 'TM0:24', 'TM2:25', 'TM0_EXT:26', 'TM2_EXT:27', 'UART1_TXD:28', 'UART1_RXD:29', 'INT2:30']},
	{ f: ['PC.5:0', 'ADC0_CH14:1', 'X32_IN:2', 'UART0_nCTS:3', 'CLKO:4', 'PWM0_CH1:5', 'PWM0_CH3:6', 'PWM0_CH5:7', 'UART0_TXD:8', 'UART0_RXD:9', 'USCI0_CLK:10', 'USCI0_DAT0:11', 'USCI0_DAT1:12', 'USCI0_CTL0:13', 'USCI0_CTL1:14', 'USCI1_CLK:15', 'USCI1_DAT0:16', 'USCI1_DAT1:17', 'USCI1_CTL0:18', 'CAN0_TXD:19', 'CAN0_RXD:20', 'ACMP0_O:21', 'ACMP1_O:22', 'ADC0_ST:23', 'TM1:24', 'TM3:25', 'TM1_EXT:26', 'TM3_EXT:27', 'UART1_TXD:28', 'UART1_RXD:29', 'INT1:30']},
	{ f: ['PC.6:0', 'ADC0_CH11:1', 'UART0_nRTS:2', 'UART0_nCTS:3', 'CLKO:4', 'PWM0_CH0:5', 'PWM0_CH2:6', 'PWM0_CH4:7', 'UART0_TXD:8', 'UART0_RXD:9', 'USCI0_CLK:10', 'USCI0_DAT0:11', 'USCI0_DAT1:12', 'USCI0_CTL0:13', 'USCI1_CTL1:14', 'USCI1_CLK:15', 'USCI1_DAT0:16', 'USCI1_DAT1:17', 'USCI1_CTL0:18', 'CAN0_TXD:19', 'CAN0_RXD:20', 'ACMP0_O:21', 'ACMP1_O:22', 'ADC0_ST:23', 'TM0:24', 'TM2:25', 'TM0_EXT:26', 'TM2_EXT:27', 'UART1_TXD:28', 'UART1_RXD:29', 'INT4:30']},
	{ f: ['PC.7:0', 'ADC0_CH10:1', 'UART0_nRTS:2', 'UART0_nCTS:3', 'CLKO:4', 'PWM0_CH1:5', 'PWM0_CH3:6', 'PWM0_CH5:7', 'UART0_TXD:8', 'UART0_RXD:9', 'USCI0_CLK:10', 'USCI0_DAT0:11', 'USCI0_DAT1:12', 'USCI0_CTL0:13', 'USCI0_CTL1:14', 'USCI1_CLK:15', 'USCI1_DAT0:16', 'USCI1_DAT1:17', 'USCI1_CTL0:18', 'CAN0_TXD:19', 'CAN0_RXD:20', 'ACMP0_O:21', 'ACMP1_O:22', 'ADC0_ST:23', 'TM1:24', 'TM3:25', 'TM1_EXT:26', 'TM3_EXT:27', 'UART1_TXD:28', 'UART1_RXD:29', 'INT5:30']},

	{ f: ['PD.0:0', 'PWM0_CH4:2', 'UART0_TXD:3', 'USCI1_CLK:4', 'TM0:5']},
	{ f: ['PD.1:0', 'PWM0_CH5:2', 'UART0_RXD:3', 'USCI1_DAT0:4', 'TM1:5']},
	{ f: ['PD.2:0', 'PWM0_CH0:2', 'CAN0_TXD:3', 'USCI1_DAT1:4', 'TM2:5', 'UART1_nCTS:6']},
	{ f: ['PD.3:0', 'PWM0_CH1:2', 'CAN0_RXD:3', 'USCI1_CTL0:4', 'TM3:5', 'UART1_nRTS:6']},
	{ f: ['PD.4:0', 'PWM0_CH0:2', 'UART0_TXD:3', 'USCI0_CLK:4', 'TM0:5']},
	{ f: ['PD.5:0', 'PWM0_CH1:2', 'UART0_RXD:3', 'USCI0_DAT0:4', 'TM1:5']},
	{ f: ['PD.6:0', 'PWM0_CH2:2', 'CAN0_TXD:3', 'USCI0_DAT1:4', 'TM2:5', 'UART1_nCTS:6']},
	{ f: ['PD.7:0', 'PWM0_CH3:2', 'CAN0_RXD:3', 'USCI0_CTL0:4', 'TM3:5', 'UART1_nRTS:6']}
];

NUTOOL_PIN.g_cfg_gpiosDefines = [
	{ f: ['PA.0', 'GPIO:SYS_GPA_MFP0_PA0MFP_GPIO@GPA_MFP0', 'ADC0_CH0:SYS_GPA_MFP0_PA0MFP_ADC0_CH0@GPA_MFP0', 'DAC0_OUT:SYS_GPA_MFP0_PA0MFP_DAC0_OUT@GPA_MFP0', 'ACMP0_P0:SYS_GPA_MFP0_PA0MFP_ACMP0_P0@GPA_MFP0', 'ICE_DAT:SYS_GPA_MFP0_PA0MFP_ICE_DAT@GPA_MFP0', 'UART0_nCTS:SYS_GPA_MFP0_PA0MFP_UART0_nCTS@GPA_MFP0', 'CLKO:SYS_GPA_MFP0_PA0MFP_CLKO@GPA_MFP0', 'PWM0_CH1:SYS_GPA_MFP0_PA0MFP_PWM0_CH1@GPA_MFP0', 'PWM0_CH3:SYS_GPA_MFP0_PA0MFP_PWM0_CH3@GPA_MFP0', 'PWM0_CH5:SYS_GPA_MFP0_PA0MFP_PWM0_CH5@GPA_MFP0', 'UART0_TXD:SYS_GPA_MFP0_PA0MFP_UART0_TXD@GPA_MFP0', 'UART0_RXD:SYS_GPA_MFP0_PA0MFP_UART0_RXD@GPA_MFP0', 'USCI0_CLK:SYS_GPA_MFP0_PA0MFP_USCI0_CLK@GPA_MFP0', 'USCI0_DAT0:SYS_GPA_MFP0_PA0MFP_USCI0_DAT0@GPA_MFP0', 'USCI0_DAT1:SYS_GPA_MFP0_PA0MFP_USCI0_DAT1@GPA_MFP0', 'USCI0_CTL0:SYS_GPA_MFP0_PA0MFP_USCI0_CTL0@GPA_MFP0', 'USCI0_CTL1:SYS_GPA_MFP0_PA0MFP_USCI0_CTL1@GPA_MFP0', 'USCI1_CLK:SYS_GPA_MFP0_PA0MFP_USCI1_CLK@GPA_MFP0', 'USCI1_DAT0:SYS_GPA_MFP0_PA0MFP_USCI1_DAT0@GPA_MFP0', 'USCI1_DAT1:SYS_GPA_MFP0_PA0MFP_USCI1_DAT1@GPA_MFP0', 'USCI1_CTL0:SYS_GPA_MFP0_PA0MFP_USCI1_CTL0@GPA_MFP0', 'CAN0_TXD:SYS_GPA_MFP0_PA0MFP_CAN0_TXD@GPA_MFP0', 'CAN0_RXD:SYS_GPA_MFP0_PA0MFP_CAN0_RXD@GPA_MFP0', 'ACMP0_O:SYS_GPA_MFP0_PA0MFP_ACMP0_O@GPA_MFP0', 'ACMP1_O:SYS_GPA_MFP0_PA0MFP_ACMP1_O@GPA_MFP0', 'ADC0_ST:SYS_GPA_MFP0_PA0MFP_ADC0_ST@GPA_MFP0', 'TM1:SYS_GPA_MFP0_PA0MFP_TM1@GPA_MFP0', 'TM3:SYS_GPA_MFP0_PA0MFP_TM3@GPA_MFP0', 'TM1_EXT:SYS_GPA_MFP0_PA0MFP_TM1_EXT@GPA_MFP0', 'TM3_EXT:SYS_GPA_MFP0_PA0MFP_TM3_EXT@GPA_MFP0', 'UART1_TXD:SYS_GPA_MFP0_PA0MFP_UART1_TXD@GPA_MFP0', 'UART1_RXD:SYS_GPA_MFP0_PA0MFP_UART1_RXD@GPA_MFP0', 'PWM0_BRAKE1:SYS_GPA_MFP0_PA0MFP_PWM0_BRAKE1@GPA_MFP0'] },
	{ f: ['PA.1', 'GPIO:SYS_GPA_MFP0_PA1MFP_GPIO@GPA_MFP0', 'ADC0_CH1:SYS_GPA_MFP0_PA1MFP_ADC0_CH1@GPA_MFP0', 'ACMP0_N0:SYS_GPA_MFP0_PA1MFP_ACMP0_N0@GPA_MFP0', 'ACMP1_N0:SYS_GPA_MFP0_PA1MFP_ACMP1_N0@GPA_MFP0', 'VREF:SYS_GPA_MFP0_PA1MFP_VREF@GPA_MFP0', 'ICE_CLK:SYS_GPA_MFP0_PA1MFP_ICE_CLK@GPA_MFP0', 'UART0_nCTS:SYS_GPA_MFP0_PA1MFP_UART0_nCTS@GPA_MFP0', 'CLKO:SYS_GPA_MFP0_PA1MFP_CLKO@GPA_MFP0', 'PWM0_CH0:SYS_GPA_MFP0_PA1MFP_PWM0_CH0@GPA_MFP0', 'PWM0_CH2:SYS_GPA_MFP0_PA1MFP_PWM0_CH2@GPA_MFP0', 'PWM0_CH4:SYS_GPA_MFP0_PA1MFP_PWM0_CH4@GPA_MFP0', 'UART0_TXD:SYS_GPA_MFP0_PA1MFP_UART0_TXD@GPA_MFP0', 'UART0_RXD:SYS_GPA_MFP0_PA1MFP_UART0_RXD@GPA_MFP0', 'USCI0_CLK:SYS_GPA_MFP0_PA1MFP_USCI0_CLK@GPA_MFP0', 'USCI0_DAT0:SYS_GPA_MFP0_PA1MFP_USCI0_DAT0@GPA_MFP0', 'USCI0_DAT1:SYS_GPA_MFP0_PA1MFP_USCI0_DAT1@GPA_MFP0', 'USCI0_CTL0:SYS_GPA_MFP0_PA1MFP_USCI0_CTL0@GPA_MFP0', 'USCI1_CTL1:SYS_GPA_MFP0_PA1MFP_USCI1_CTL1@GPA_MFP0', 'USCI1_CLK:SYS_GPA_MFP0_PA1MFP_USCI1_CLK@GPA_MFP0', 'USCI1_DAT0:SYS_GPA_MFP0_PA1MFP_USCI1_DAT0@GPA_MFP0', 'USCI1_DAT1:SYS_GPA_MFP0_PA1MFP_USCI1_DAT1@GPA_MFP0', 'USCI1_CTL0:SYS_GPA_MFP0_PA1MFP_USCI1_CTL0@GPA_MFP0', 'CAN0_TXD:SYS_GPA_MFP0_PA1MFP_CAN0_TXD@GPA_MFP0', 'CAN0_RXD:SYS_GPA_MFP0_PA1MFP_CAN0_RXD@GPA_MFP0', 'ACMP0_O:SYS_GPA_MFP0_PA1MFP_ACMP0_O@GPA_MFP0', 'ACMP1_O:SYS_GPA_MFP0_PA1MFP_ACMP1_O@GPA_MFP0', 'ADC0_ST:SYS_GPA_MFP0_PA1MFP_ADC0_ST@GPA_MFP0', 'TM0:SYS_GPA_MFP0_PA1MFP_TM0@GPA_MFP0', 'TM2:SYS_GPA_MFP0_PA1MFP_TM2@GPA_MFP0', 'TM0_EXT:SYS_GPA_MFP0_PA1MFP_TM0_EXT@GPA_MFP0', 'TM2_EXT:SYS_GPA_MFP0_PA1MFP_TM2_EXT@GPA_MFP0', 'UART1_TXD:SYS_GPA_MFP0_PA1MFP_UART1_TXD@GPA_MFP0', 'UART1_RXD:SYS_GPA_MFP0_PA1MFP_UART1_RXD@GPA_MFP0', 'PWM0_BRAKE0:SYS_GPA_MFP0_PA1MFP_PWM0_BRAKE0@GPA_MFP0'] },
	{ f: ['PA.2', 'GPIO:SYS_GPA_MFP0_PA2MFP_GPIO@GPA_MFP0', 'ADC0_CH2:SYS_GPA_MFP0_PA2MFP_ADC0_CH2@GPA_MFP0', 'UART0_nRTS:SYS_GPA_MFP0_PA2MFP_UART0_nRTS@GPA_MFP0', 'UART0_nCTS:SYS_GPA_MFP0_PA2MFP_UART0_nCTS@GPA_MFP0', 'CLKO:SYS_GPA_MFP0_PA2MFP_CLKO@GPA_MFP0', 'PWM0_CH1:SYS_GPA_MFP0_PA2MFP_PWM0_CH1@GPA_MFP0', 'PWM0_CH3:SYS_GPA_MFP0_PA2MFP_PWM0_CH3@GPA_MFP0', 'PWM0_CH5:SYS_GPA_MFP0_PA2MFP_PWM0_CH5@GPA_MFP0', 'UART0_TXD:SYS_GPA_MFP0_PA2MFP_UART0_TXD@GPA_MFP0', 'UART0_RXD:SYS_GPA_MFP0_PA2MFP_UART0_RXD@GPA_MFP0', 'USCI0_CLK:SYS_GPA_MFP0_PA2MFP_USCI0_CLK@GPA_MFP0', 'USCI0_DAT0:SYS_GPA_MFP0_PA2MFP_USCI0_DAT0@GPA_MFP0', 'USCI0_DAT1:SYS_GPA_MFP0_PA2MFP_USCI0_DAT1@GPA_MFP0', 'USCI0_CTL0:SYS_GPA_MFP0_PA2MFP_USCI0_CTL0@GPA_MFP0', 'USCI0_CTL1:SYS_GPA_MFP0_PA2MFP_USCI0_CTL1@GPA_MFP0', 'USCI1_CLK:SYS_GPA_MFP0_PA2MFP_USCI1_CLK@GPA_MFP0', 'USCI1_DAT0:SYS_GPA_MFP0_PA2MFP_USCI1_DAT0@GPA_MFP0', 'USCI1_DAT1:SYS_GPA_MFP0_PA2MFP_USCI1_DAT1@GPA_MFP0', 'USCI1_CTL0:SYS_GPA_MFP0_PA2MFP_USCI1_CTL0@GPA_MFP0', 'CAN0_TXD:SYS_GPA_MFP0_PA2MFP_CAN0_TXD@GPA_MFP0', 'CAN0_RXD:SYS_GPA_MFP0_PA2MFP_CAN0_RXD@GPA_MFP0', 'ACMP0_O:SYS_GPA_MFP0_PA2MFP_ACMP0_O@GPA_MFP0', 'ACMP1_O:SYS_GPA_MFP0_PA2MFP_ACMP1_O@GPA_MFP0', 'ADC0_ST:SYS_GPA_MFP0_PA2MFP_ADC0_ST@GPA_MFP0', 'TM1:SYS_GPA_MFP0_PA2MFP_TM1@GPA_MFP0', 'TM3:SYS_GPA_MFP0_PA2MFP_TM3@GPA_MFP0', 'TM1_EXT:SYS_GPA_MFP0_PA2MFP_TM1_EXT@GPA_MFP0', 'TM3_EXT:SYS_GPA_MFP0_PA2MFP_TM3_EXT@GPA_MFP0', 'UART1_TXD:SYS_GPA_MFP0_PA2MFP_UART1_TXD@GPA_MFP0', 'UART1_RXD:SYS_GPA_MFP0_PA2MFP_UART1_RXD@GPA_MFP0', 'PWM0_BRAKE1:SYS_GPA_MFP0_PA2MFP_PWM0_BRAKE1@GPA_MFP0'] },
	{ f: ['PA.3', 'GPIO:SYS_GPA_MFP0_PA3MFP_GPIO@GPA_MFP0', 'nRESET:SYS_GPA_MFP0_PA3MFP_nRESET@GPA_MFP0', 'UART0_nCTS:SYS_GPA_MFP0_PA3MFP_UART0_nCTS@GPA_MFP0', 'PWM0_CH0:SYS_GPA_MFP0_PA3MFP_PWM0_CH0@GPA_MFP0', 'PWM0_CH2:SYS_GPA_MFP0_PA3MFP_PWM0_CH2@GPA_MFP0', 'PWM0_CH4:SYS_GPA_MFP0_PA3MFP_PWM0_CH4@GPA_MFP0', 'UART0_RXD:SYS_GPA_MFP0_PA3MFP_UART0_RXD@GPA_MFP0', 'USCI0_CLK:SYS_GPA_MFP0_PA3MFP_USCI0_CLK@GPA_MFP0', 'USCI0_DAT0:SYS_GPA_MFP0_PA3MFP_USCI0_DAT0@GPA_MFP0', 'USCI0_DAT1:SYS_GPA_MFP0_PA3MFP_USCI0_DAT1@GPA_MFP0', 'USCI0_CTL0:SYS_GPA_MFP0_PA3MFP_USCI0_CTL0@GPA_MFP0', 'USCI0_CTL1:SYS_GPA_MFP0_PA3MFP_USCI0_CTL1@GPA_MFP0', 'USCI1_CLK:SYS_GPA_MFP0_PA3MFP_USCI1_CLK@GPA_MFP0', 'USCI1_DAT0:SYS_GPA_MFP0_PA3MFP_USCI1_DAT0@GPA_MFP0', 'USCI1_DAT1:SYS_GPA_MFP0_PA3MFP_USCI1_DAT1@GPA_MFP0', 'USCI1_CTL0:SYS_GPA_MFP0_PA3MFP_USCI1_CTL0@GPA_MFP0', 'CAN0_RXD:SYS_GPA_MFP0_PA3MFP_CAN0_RXD@GPA_MFP0', 'ADC0_ST:SYS_GPA_MFP0_PA3MFP_ADC0_ST@GPA_MFP0', 'TM0:SYS_GPA_MFP0_PA3MFP_TM0@GPA_MFP0', 'TM2:SYS_GPA_MFP0_PA3MFP_TM2@GPA_MFP0', 'TM0_EXT:SYS_GPA_MFP0_PA3MFP_TM0_EXT@GPA_MFP0', 'TM2_EXT:SYS_GPA_MFP0_PA3MFP_TM2_EXT@GPA_MFP0', 'UART1_RXD:SYS_GPA_MFP0_PA3MFP_UART1_RXD@GPA_MFP0', 'INT0:SYS_GPA_MFP0_PA3MFP_INT0@GPA_MFP0'] },
	{ f: ['PA.4', 'GPIO:SYS_GPA_MFP1_PA4MFP_GPIO@GPA_MFP1', 'ADC0_CH15:SYS_GPA_MFP1_PA4MFP_ADC0_CH15@GPA_MFP1', 'UART0_nRTS:SYS_GPA_MFP1_PA4MFP_UART0_nRTS@GPA_MFP1', 'XT1_OUT:SYS_GPA_MFP1_PA4MFP_XT1_OUT@GPA_MFP1', 'CLKO:SYS_GPA_MFP1_PA4MFP_CLKO@GPA_MFP1', 'PWM0_CH1:SYS_GPA_MFP1_PA4MFP_PWM0_CH1@GPA_MFP1', 'PWM0_CH3:SYS_GPA_MFP1_PA4MFP_PWM0_CH3@GPA_MFP1', 'PWM0_CH5:SYS_GPA_MFP1_PA4MFP_PWM0_CH5@GPA_MFP1', 'UART0_TXD:SYS_GPA_MFP1_PA4MFP_UART0_TXD@GPA_MFP1', 'UART0_RXD:SYS_GPA_MFP1_PA4MFP_UART0_RXD@GPA_MFP1', 'USCI0_CLK:SYS_GPA_MFP1_PA4MFP_USCI0_CLK@GPA_MFP1', 'USCI0_DAT0:SYS_GPA_MFP1_PA4MFP_USCI0_DAT0@GPA_MFP1', 'USCI0_DAT1:SYS_GPA_MFP1_PA4MFP_USCI0_DAT1@GPA_MFP1', 'USCI0_CTL0:SYS_GPA_MFP1_PA4MFP_USCI0_CTL0@GPA_MFP1', 'USCI1_CTL1:SYS_GPA_MFP1_PA4MFP_USCI1_CTL1@GPA_MFP1', 'USCI1_CLK:SYS_GPA_MFP1_PA4MFP_USCI1_CLK@GPA_MFP1', 'USCI1_DAT0:SYS_GPA_MFP1_PA4MFP_USCI1_DAT0@GPA_MFP1', 'USCI1_DAT1:SYS_GPA_MFP1_PA4MFP_USCI1_DAT1@GPA_MFP1', 'USCI1_CTL0:SYS_GPA_MFP1_PA4MFP_USCI1_CTL0@GPA_MFP1', 'CAN0_TXD:SYS_GPA_MFP1_PA4MFP_CAN0_TXD@GPA_MFP1', 'CAN0_RXD:SYS_GPA_MFP1_PA4MFP_CAN0_RXD@GPA_MFP1', 'ACMP0_O:SYS_GPA_MFP1_PA4MFP_ACMP0_O@GPA_MFP1', 'ACMP1_O:SYS_GPA_MFP1_PA4MFP_ACMP1_O@GPA_MFP1', 'ADC0_ST:SYS_GPA_MFP1_PA4MFP_ADC0_ST@GPA_MFP1', 'TM1:SYS_GPA_MFP1_PA4MFP_TM1@GPA_MFP1', 'TM3:SYS_GPA_MFP1_PA4MFP_TM3@GPA_MFP1', 'TM1_EXT:SYS_GPA_MFP1_PA4MFP_TM1_EXT@GPA_MFP1', 'TM3_EXT:SYS_GPA_MFP1_PA4MFP_TM3_EXT@GPA_MFP1', 'UART1_TXD:SYS_GPA_MFP1_PA4MFP_UART1_TXD@GPA_MFP1', 'UART1_RXD:SYS_GPA_MFP1_PA4MFP_UART1_RXD@GPA_MFP1', 'ACMP1_WLAT:SYS_GPA_MFP1_PA4MFP_ACMP1_WLAT@GPA_MFP1'] },
	{ f: ['PA.5', 'GPIO:SYS_GPA_MFP1_PA5MFP_GPIO@GPA_MFP1', 'ADC0_CH16:SYS_GPA_MFP1_PA5MFP_ADC0_CH16@GPA_MFP1', 'UART0_nRTS:SYS_GPA_MFP1_PA5MFP_UART0_nRTS@GPA_MFP1', 'XT1_IN:SYS_GPA_MFP1_PA5MFP_XT1_IN@GPA_MFP1', 'CLKO:SYS_GPA_MFP1_PA5MFP_CLKO@GPA_MFP1', 'PWM0_CH0:SYS_GPA_MFP1_PA5MFP_PWM0_CH0@GPA_MFP1', 'PWM0_CH2:SYS_GPA_MFP1_PA5MFP_PWM0_CH2@GPA_MFP1', 'PWM0_CH4:SYS_GPA_MFP1_PA5MFP_PWM0_CH4@GPA_MFP1', 'UART0_TXD:SYS_GPA_MFP1_PA5MFP_UART0_TXD@GPA_MFP1', 'UART0_RXD:SYS_GPA_MFP1_PA5MFP_UART0_RXD@GPA_MFP1', 'USCI0_CLK:SYS_GPA_MFP1_PA5MFP_USCI0_CLK@GPA_MFP1', 'USCI0_DAT0:SYS_GPA_MFP1_PA5MFP_USCI0_DAT0@GPA_MFP1', 'USCI0_DAT1:SYS_GPA_MFP1_PA5MFP_USCI0_DAT1@GPA_MFP1', 'USCI0_CTL0:SYS_GPA_MFP1_PA5MFP_USCI0_CTL0@GPA_MFP1', 'USCI0_CTL1:SYS_GPA_MFP1_PA5MFP_USCI0_CTL1@GPA_MFP1', 'USCI1_CLK:SYS_GPA_MFP1_PA5MFP_USCI1_CLK@GPA_MFP1', 'USCI1_DAT0:SYS_GPA_MFP1_PA5MFP_USCI1_DAT0@GPA_MFP1', 'USCI1_DAT1:SYS_GPA_MFP1_PA5MFP_USCI1_DAT1@GPA_MFP1', 'USCI1_CTL0:SYS_GPA_MFP1_PA5MFP_USCI1_CTL0@GPA_MFP1', 'CAN0_TXD:SYS_GPA_MFP1_PA5MFP_CAN0_TXD@GPA_MFP1', 'CAN0_RXD:SYS_GPA_MFP1_PA5MFP_CAN0_RXD@GPA_MFP1', 'ACMP0_O:SYS_GPA_MFP1_PA5MFP_ACMP0_O@GPA_MFP1', 'ACMP1_O:SYS_GPA_MFP1_PA5MFP_ACMP1_O@GPA_MFP1', 'ADC0_ST:SYS_GPA_MFP1_PA5MFP_ADC0_ST@GPA_MFP1', 'TM0:SYS_GPA_MFP1_PA5MFP_TM0@GPA_MFP1', 'TM2:SYS_GPA_MFP1_PA5MFP_TM2@GPA_MFP1', 'TM0_EXT:SYS_GPA_MFP1_PA5MFP_TM0_EXT@GPA_MFP1', 'TM2_EXT:SYS_GPA_MFP1_PA5MFP_TM2_EXT@GPA_MFP1', 'UART1_TXD:SYS_GPA_MFP1_PA5MFP_UART1_TXD@GPA_MFP1', 'UART1_RXD:SYS_GPA_MFP1_PA5MFP_UART1_RXD@GPA_MFP1', 'ACMP0_WLAT:SYS_GPA_MFP1_PA5MFP_ACMP0_WLAT@GPA_MFP1'] },

	{ f: ['PB.4', 'GPIO:SYS_GPB_MFP1_PB4MFP_GPIO@GPB_MFP1', 'ADC0_CH6:SYS_GPB_MFP1_PB4MFP_ADC0_CH6@GPB_MFP1', 'UART0_nRTS:SYS_GPB_MFP1_PB4MFP_UART0_nRTS@GPB_MFP1', 'UART0_nCTS:SYS_GPB_MFP1_PB4MFP_UART0_nCTS@GPB_MFP1', 'CLKO:SYS_GPB_MFP1_PB4MFP_CLKO@GPB_MFP1', 'PWM0_CH1:SYS_GPB_MFP1_PB4MFP_PWM0_CH1@GPB_MFP1', 'PWM0_CH3:SYS_GPB_MFP1_PB4MFP_PWM0_CH3@GPB_MFP1', 'PWM0_CH5:SYS_GPB_MFP1_PB4MFP_PWM0_CH5@GPB_MFP1', 'UART0_TXD:SYS_GPB_MFP1_PB4MFP_UART0_TXD@GPB_MFP1', 'UART0_RXD:SYS_GPB_MFP1_PB4MFP_UART0_RXD@GPB_MFP1', 'USCI0_CLK:SYS_GPB_MFP1_PB4MFP_USCI0_CLK@GPB_MFP1', 'USCI0_DAT0:SYS_GPB_MFP1_PB4MFP_USCI0_DAT0@GPB_MFP1', 'USCI0_DAT1:SYS_GPB_MFP1_PB4MFP_USCI0_DAT1@GPB_MFP1', 'USCI0_CTL0:SYS_GPB_MFP1_PB4MFP_USCI0_CTL0@GPB_MFP1', 'USCI0_CTL1:SYS_GPB_MFP1_PB4MFP_USCI0_CTL1@GPB_MFP1', 'USCI1_CLK:SYS_GPB_MFP1_PB4MFP_USCI1_CLK@GPB_MFP1', 'USCI1_DAT0:SYS_GPB_MFP1_PB4MFP_USCI1_DAT0@GPB_MFP1', 'USCI1_DAT1:SYS_GPB_MFP1_PB4MFP_USCI1_DAT1@GPB_MFP1', 'USCI1_CTL0:SYS_GPB_MFP1_PB4MFP_USCI1_CTL0@GPB_MFP1', 'CAN0_TXD:SYS_GPB_MFP1_PB4MFP_CAN0_TXD@GPB_MFP1', 'CAN0_RXD:SYS_GPB_MFP1_PB4MFP_CAN0_RXD@GPB_MFP1', 'ACMP0_O:SYS_GPB_MFP1_PB4MFP_ACMP0_O@GPB_MFP1', 'ACMP1_O:SYS_GPB_MFP1_PB4MFP_ACMP1_O@GPB_MFP1', 'ADC0_ST:SYS_GPB_MFP1_PB4MFP_ADC0_ST@GPB_MFP1', 'TM1:SYS_GPB_MFP1_PB4MFP_TM1@GPB_MFP1', 'TM3:SYS_GPB_MFP1_PB4MFP_TM3@GPB_MFP1', 'TM1_EXT:SYS_GPB_MFP1_PB4MFP_TM1_EXT@GPB_MFP1', 'TM3_EXT:SYS_GPB_MFP1_PB4MFP_TM3_EXT@GPB_MFP1', 'UART1_TXD:SYS_GPB_MFP1_PB4MFP_UART1_TXD@GPB_MFP1', 'UART1_RXD:SYS_GPB_MFP1_PB4MFP_UART1_RXD@GPB_MFP1', 'UART1_nCTS:SYS_GPB_MFP1_PB4MFP_UART1_nCTS@GPB_MFP1'] },
	{ f: ['PB.5', 'GPIO:SYS_GPB_MFP1_PB5MFP_GPIO@GPB_MFP1', 'ADC0_CH7:SYS_GPB_MFP1_PB5MFP_ADC0_CH7@GPB_MFP1', 'UART0_nRTS:SYS_GPB_MFP1_PB5MFP_UART0_nRTS@GPB_MFP1', 'UART0_nCTS:SYS_GPB_MFP1_PB5MFP_UART0_nCTS@GPB_MFP1', 'CLKO:SYS_GPB_MFP1_PB5MFP_CLKO@GPB_MFP1', 'PWM0_CH0:SYS_GPB_MFP1_PB5MFP_PWM0_CH0@GPB_MFP1', 'PWM0_CH2:SYS_GPB_MFP1_PB5MFP_PWM0_CH2@GPB_MFP1', 'PWM0_CH4:SYS_GPB_MFP1_PB5MFP_PWM0_CH4@GPB_MFP1', 'UART0_TXD:SYS_GPB_MFP1_PB5MFP_UART0_TXD@GPB_MFP1', 'UART0_RXD:SYS_GPB_MFP1_PB5MFP_UART0_RXD@GPB_MFP1', 'USCI0_CLK:SYS_GPB_MFP1_PB5MFP_USCI0_CLK@GPB_MFP1', 'USCI0_DAT0:SYS_GPB_MFP1_PB5MFP_USCI0_DAT0@GPB_MFP1', 'USCI0_DAT1:SYS_GPB_MFP1_PB5MFP_USCI0_DAT1@GPB_MFP1', 'USCI0_CTL0:SYS_GPB_MFP1_PB5MFP_USCI0_CTL0@GPB_MFP1', 'USCI1_CTL1:SYS_GPB_MFP1_PB5MFP_USCI1_CTL1@GPB_MFP1', 'USCI1_CLK:SYS_GPB_MFP1_PB5MFP_USCI1_CLK@GPB_MFP1', 'USCI1_DAT0:SYS_GPB_MFP1_PB5MFP_USCI1_DAT0@GPB_MFP1', 'USCI1_DAT1:SYS_GPB_MFP1_PB5MFP_USCI1_DAT1@GPB_MFP1', 'USCI1_CTL0:SYS_GPB_MFP1_PB5MFP_USCI1_CTL0@GPB_MFP1', 'CAN0_TXD:SYS_GPB_MFP1_PB5MFP_CAN0_TXD@GPB_MFP1', 'CAN0_RXD:SYS_GPB_MFP1_PB5MFP_CAN0_RXD@GPB_MFP1', 'ACMP0_O:SYS_GPB_MFP1_PB5MFP_ACMP0_O@GPB_MFP1', 'ACMP1_O:SYS_GPB_MFP1_PB5MFP_ACMP1_O@GPB_MFP1', 'ADC0_ST:SYS_GPB_MFP1_PB5MFP_ADC0_ST@GPB_MFP1', 'TM0:SYS_GPB_MFP1_PB5MFP_TM0@GPB_MFP1', 'TM2:SYS_GPB_MFP1_PB5MFP_TM2@GPB_MFP1', 'TM0_EXT:SYS_GPB_MFP1_PB5MFP_TM0_EXT@GPB_MFP1', 'TM2_EXT:SYS_GPB_MFP1_PB5MFP_TM2_EXT@GPB_MFP1', 'UART1_TXD:SYS_GPB_MFP1_PB5MFP_UART1_TXD@GPB_MFP1', 'UART1_RXD:SYS_GPB_MFP1_PB5MFP_UART1_RXD@GPB_MFP1', 'INT0:SYS_GPB_MFP1_PB5MFP_INT0@GPB_MFP1'] },
	{ f: ['PB.6', 'GPIO:SYS_GPB_MFP1_PB6MFP_GPIO@GPB_MFP1', 'ADC0_CH8:SYS_GPB_MFP1_PB6MFP_ADC0_CH8@GPB_MFP1', 'UART0_nRTS:SYS_GPB_MFP1_PB6MFP_UART0_nRTS@GPB_MFP1', 'UART0_nCTS:SYS_GPB_MFP1_PB6MFP_UART0_nCTS@GPB_MFP1', 'CLKO:SYS_GPB_MFP1_PB6MFP_CLKO@GPB_MFP1', 'PWM0_CH1:SYS_GPB_MFP1_PB6MFP_PWM0_CH1@GPB_MFP1', 'PWM0_CH3:SYS_GPB_MFP1_PB6MFP_PWM0_CH3@GPB_MFP1', 'PWM0_CH5:SYS_GPB_MFP1_PB6MFP_PWM0_CH5@GPB_MFP1', 'UART0_TXD:SYS_GPB_MFP1_PB6MFP_UART0_TXD@GPB_MFP1', 'UART0_RXD:SYS_GPB_MFP1_PB6MFP_UART0_RXD@GPB_MFP1', 'USCI0_CLK:SYS_GPB_MFP1_PB6MFP_USCI0_CLK@GPB_MFP1', 'USCI0_DAT0:SYS_GPB_MFP1_PB6MFP_USCI0_DAT0@GPB_MFP1', 'USCI0_DAT1:SYS_GPB_MFP1_PB6MFP_USCI0_DAT1@GPB_MFP1', 'USCI0_CTL0:SYS_GPB_MFP1_PB6MFP_USCI0_CTL0@GPB_MFP1', 'USCI0_CTL1:SYS_GPB_MFP1_PB6MFP_USCI0_CTL1@GPB_MFP1', 'USCI1_CLK:SYS_GPB_MFP1_PB6MFP_USCI1_CLK@GPB_MFP1', 'USCI1_DAT0:SYS_GPB_MFP1_PB6MFP_USCI1_DAT0@GPB_MFP1', 'USCI1_DAT1:SYS_GPB_MFP1_PB6MFP_USCI1_DAT1@GPB_MFP1', 'USCI1_CTL0:SYS_GPB_MFP1_PB6MFP_USCI1_CTL0@GPB_MFP1', 'CAN0_TXD:SYS_GPB_MFP1_PB6MFP_CAN0_TXD@GPB_MFP1', 'CAN0_RXD:SYS_GPB_MFP1_PB6MFP_CAN0_RXD@GPB_MFP1', 'ACMP0_O:SYS_GPB_MFP1_PB6MFP_ACMP0_O@GPB_MFP1', 'ACMP1_O:SYS_GPB_MFP1_PB6MFP_ACMP1_O@GPB_MFP1', 'ADC0_ST:SYS_GPB_MFP1_PB6MFP_ADC0_ST@GPB_MFP1', 'TM1:SYS_GPB_MFP1_PB6MFP_TM1@GPB_MFP1', 'TM3:SYS_GPB_MFP1_PB6MFP_TM3@GPB_MFP1', 'TM1_EXT:SYS_GPB_MFP1_PB6MFP_TM1_EXT@GPB_MFP1', 'TM3_EXT:SYS_GPB_MFP1_PB6MFP_TM3_EXT@GPB_MFP1', 'UART1_TXD:SYS_GPB_MFP1_PB6MFP_UART1_TXD@GPB_MFP1', 'UART1_RXD:SYS_GPB_MFP1_PB6MFP_UART1_RXD@GPB_MFP1', 'ACMP1_WLAT:SYS_GPB_MFP1_PB6MFP_ACMP1_WLAT@GPB_MFP1'] },
	{ f: ['PB.7', 'GPIO:SYS_GPB_MFP1_PB7MFP_GPIO@GPB_MFP1', 'ADC0_CH9:SYS_GPB_MFP1_PB7MFP_ADC0_CH9@GPB_MFP1', 'UART0_nRTS:SYS_GPB_MFP1_PB7MFP_UART0_nRTS@GPB_MFP1', 'UART0_nCTS:SYS_GPB_MFP1_PB7MFP_UART0_nCTS@GPB_MFP1', 'CLKO:SYS_GPB_MFP1_PB7MFP_CLKO@GPB_MFP1', 'PWM0_CH0:SYS_GPB_MFP1_PB7MFP_PWM0_CH0@GPB_MFP1', 'PWM0_CH2:SYS_GPB_MFP1_PB7MFP_PWM0_CH2@GPB_MFP1', 'PWM0_CH4:SYS_GPB_MFP1_PB7MFP_PWM0_CH4@GPB_MFP1', 'UART0_TXD:SYS_GPB_MFP1_PB7MFP_UART0_TXD@GPB_MFP1', 'UART0_RXD:SYS_GPB_MFP1_PB7MFP_UART0_RXD@GPB_MFP1', 'USCI0_CLK:SYS_GPB_MFP1_PB7MFP_USCI0_CLK@GPB_MFP1', 'USCI0_DAT0:SYS_GPB_MFP1_PB7MFP_USCI0_DAT0@GPB_MFP1', 'USCI0_DAT1:SYS_GPB_MFP1_PB7MFP_USCI0_DAT1@GPB_MFP1', 'USCI0_CTL0:SYS_GPB_MFP1_PB7MFP_USCI0_CTL0@GPB_MFP1', 'USCI1_CTL1:SYS_GPB_MFP1_PB7MFP_USCI1_CTL1@GPB_MFP1', 'USCI1_CLK:SYS_GPB_MFP1_PB7MFP_USCI1_CLK@GPB_MFP1', 'USCI1_DAT0:SYS_GPB_MFP1_PB7MFP_USCI1_DAT0@GPB_MFP1', 'USCI1_DAT1:SYS_GPB_MFP1_PB7MFP_USCI1_DAT1@GPB_MFP1', 'USCI1_CTL0:SYS_GPB_MFP1_PB7MFP_USCI1_CTL0@GPB_MFP1', 'CAN0_TXD:SYS_GPB_MFP1_PB7MFP_CAN0_TXD@GPB_MFP1', 'CAN0_RXD:SYS_GPB_MFP1_PB7MFP_CAN0_RXD@GPB_MFP1', 'ACMP0_O:SYS_GPB_MFP1_PB7MFP_ACMP0_O@GPB_MFP1', 'ACMP1_O:SYS_GPB_MFP1_PB7MFP_ACMP1_O@GPB_MFP1', 'ADC0_ST:SYS_GPB_MFP1_PB7MFP_ADC0_ST@GPB_MFP1', 'TM0:SYS_GPB_MFP1_PB7MFP_TM0@GPB_MFP1', 'TM2:SYS_GPB_MFP1_PB7MFP_TM2@GPB_MFP1', 'TM0_EXT:SYS_GPB_MFP1_PB7MFP_TM0_EXT@GPB_MFP1', 'TM2_EXT:SYS_GPB_MFP1_PB7MFP_TM2_EXT@GPB_MFP1', 'UART1_TXD:SYS_GPB_MFP1_PB7MFP_UART1_TXD@GPB_MFP1', 'UART1_RXD:SYS_GPB_MFP1_PB7MFP_UART1_RXD@GPB_MFP1', 'ACMP0_WLAT:SYS_GPB_MFP1_PB7MFP_ACMP0_WLAT@GPB_MFP1'] },

	{ f: ['PC.0', 'GPIO:SYS_GPC_MFP0_PC0MFP_GPIO@GPC_MFP0', 'ADC0_CH3:SYS_GPC_MFP0_PC0MFP_ADC0_CH3@GPC_MFP0', 'ACMP1_P0:SYS_GPC_MFP0_PC0MFP_ACMP1_P0@GPC_MFP0', 'UART0_nRTS:SYS_GPC_MFP0_PC0MFP_UART0_nRTS@GPC_MFP0', 'UART0_nCTS:SYS_GPC_MFP0_PC0MFP_UART0_nCTS@GPC_MFP0', 'CLKO:SYS_GPC_MFP0_PC0MFP_CLKO@GPC_MFP0', 'PWM0_CH0:SYS_GPC_MFP0_PC0MFP_PWM0_CH0@GPC_MFP0', 'PWM0_CH2:SYS_GPC_MFP0_PC0MFP_PWM0_CH2@GPC_MFP0', 'PWM0_CH4:SYS_GPC_MFP0_PC0MFP_PWM0_CH4@GPC_MFP0', 'UART0_TXD:SYS_GPC_MFP0_PC0MFP_UART0_TXD@GPC_MFP0', 'UART0_RXD:SYS_GPC_MFP0_PC0MFP_UART0_RXD@GPC_MFP0', 'USCI0_CLK:SYS_GPC_MFP0_PC0MFP_USCI0_CLK@GPC_MFP0', 'USCI0_DAT0:SYS_GPC_MFP0_PC0MFP_USCI0_DAT0@GPC_MFP0', 'USCI0_DAT1:SYS_GPC_MFP0_PC0MFP_USCI0_DAT1@GPC_MFP0', 'USCI0_CTL0:SYS_GPC_MFP0_PC0MFP_USCI0_CTL0@GPC_MFP0', 'USCI1_CTL1:SYS_GPC_MFP0_PC0MFP_USCI1_CTL1@GPC_MFP0', 'USCI1_CLK:SYS_GPC_MFP0_PC0MFP_USCI1_CLK@GPC_MFP0', 'USCI1_DAT0:SYS_GPC_MFP0_PC0MFP_USCI1_DAT0@GPC_MFP0', 'USCI1_DAT1:SYS_GPC_MFP0_PC0MFP_USCI1_DAT1@GPC_MFP0', 'USCI1_CTL0:SYS_GPC_MFP0_PC0MFP_USCI1_CTL0@GPC_MFP0', 'CAN0_TXD:SYS_GPC_MFP0_PC0MFP_CAN0_TXD@GPC_MFP0', 'CAN0_RXD:SYS_GPC_MFP0_PC0MFP_CAN0_RXD@GPC_MFP0', 'ACMP0_O:SYS_GPC_MFP0_PC0MFP_ACMP0_O@GPC_MFP0', 'ACMP1_O:SYS_GPC_MFP0_PC0MFP_ACMP1_O@GPC_MFP0', 'ADC0_ST:SYS_GPC_MFP0_PC0MFP_ADC0_ST@GPC_MFP0', 'TM0:SYS_GPC_MFP0_PC0MFP_TM0@GPC_MFP0', 'TM2:SYS_GPC_MFP0_PC0MFP_TM2@GPC_MFP0', 'TM0_EXT:SYS_GPC_MFP0_PC0MFP_TM0_EXT@GPC_MFP0', 'TM2_EXT:SYS_GPC_MFP0_PC0MFP_TM2_EXT@GPC_MFP0', 'UART1_TXD:SYS_GPC_MFP0_PC0MFP_UART1_TXD@GPC_MFP0', 'UART1_RXD:SYS_GPC_MFP0_PC0MFP_UART1_RXD@GPC_MFP0', 'PWM0_BRAKE0:SYS_GPC_MFP0_PC0MFP_PWM0_BRAKE0@GPC_MFP0'] },
	{ f: ['PC.1', 'GPIO:SYS_GPC_MFP0_PC1MFP_GPIO@GPC_MFP0', 'ADC0_CH4:SYS_GPC_MFP0_PC1MFP_ADC0_CH4@GPC_MFP0', 'ACMP0_N1:SYS_GPC_MFP0_PC1MFP_ACMP0_N1@GPC_MFP0', 'ACMP1_N1:SYS_GPC_MFP0_PC1MFP_ACMP1_N1@GPC_MFP0', 'UART0_nRTS:SYS_GPC_MFP0_PC1MFP_UART0_nRTS@GPC_MFP0', 'UART0_nCTS:SYS_GPC_MFP0_PC1MFP_UART0_nCTS@GPC_MFP0', 'CLKO:SYS_GPC_MFP0_PC1MFP_CLKO@GPC_MFP0', 'PWM0_CH1:SYS_GPC_MFP0_PC1MFP_PWM0_CH1@GPC_MFP0', 'PWM0_CH3:SYS_GPC_MFP0_PC1MFP_PWM0_CH3@GPC_MFP0', 'PWM0_CH5:SYS_GPC_MFP0_PC1MFP_PWM0_CH5@GPC_MFP0', 'UART0_TXD:SYS_GPC_MFP0_PC1MFP_UART0_TXD@GPC_MFP0', 'UART0_RXD:SYS_GPC_MFP0_PC1MFP_UART0_RXD@GPC_MFP0', 'USCI0_CLK:SYS_GPC_MFP0_PC1MFP_USCI0_CLK@GPC_MFP0', 'USCI0_DAT0:SYS_GPC_MFP0_PC1MFP_USCI0_DAT0@GPC_MFP0', 'USCI0_DAT1:SYS_GPC_MFP0_PC1MFP_USCI0_DAT1@GPC_MFP0', 'USCI0_CTL0:SYS_GPC_MFP0_PC1MFP_USCI0_CTL0@GPC_MFP0', 'USCI0_CTL1:SYS_GPC_MFP0_PC1MFP_USCI0_CTL1@GPC_MFP0', 'USCI1_CLK:SYS_GPC_MFP0_PC1MFP_USCI1_CLK@GPC_MFP0', 'USCI1_DAT0:SYS_GPC_MFP0_PC1MFP_USCI1_DAT0@GPC_MFP0', 'USCI1_DAT1:SYS_GPC_MFP0_PC1MFP_USCI1_DAT1@GPC_MFP0', 'USCI1_CTL0:SYS_GPC_MFP0_PC1MFP_USCI1_CTL0@GPC_MFP0', 'CAN0_TXD:SYS_GPC_MFP0_PC1MFP_CAN0_TXD@GPC_MFP0', 'CAN0_RXD:SYS_GPC_MFP0_PC1MFP_CAN0_RXD@GPC_MFP0', 'ACMP0_O:SYS_GPC_MFP0_PC1MFP_ACMP0_O@GPC_MFP0', 'ACMP1_O:SYS_GPC_MFP0_PC1MFP_ACMP1_O@GPC_MFP0', 'ADC0_ST:SYS_GPC_MFP0_PC1MFP_ADC0_ST@GPC_MFP0', 'TM1:SYS_GPC_MFP0_PC1MFP_TM1@GPC_MFP0', 'TM3:SYS_GPC_MFP0_PC1MFP_TM3@GPC_MFP0', 'TM1_EXT:SYS_GPC_MFP0_PC1MFP_TM1_EXT@GPC_MFP0', 'TM3_EXT:SYS_GPC_MFP0_PC1MFP_TM3_EXT@GPC_MFP0', 'UART1_TXD:SYS_GPC_MFP0_PC1MFP_UART1_TXD@GPC_MFP0', 'UART1_RXD:SYS_GPC_MFP0_PC1MFP_UART1_RXD@GPC_MFP0'] },
	{ f: ['PC.2', 'GPIO:SYS_GPC_MFP0_PC2MFP_GPIO@GPC_MFP0', 'ADC0_CH5:SYS_GPC_MFP0_PC2MFP_ADC0_CH5@GPC_MFP0', 'ACMP0_N2:SYS_GPC_MFP0_PC2MFP_ACMP0_N2@GPC_MFP0', 'ACMP1_N2:SYS_GPC_MFP0_PC2MFP_ACMP1_N2@GPC_MFP0', 'UART0_nRTS:SYS_GPC_MFP0_PC2MFP_UART0_nRTS@GPC_MFP0', 'UART0_nCTS:SYS_GPC_MFP0_PC2MFP_UART0_nCTS@GPC_MFP0', 'CLKO:SYS_GPC_MFP0_PC2MFP_CLKO@GPC_MFP0', 'PWM0_CH0:SYS_GPC_MFP0_PC2MFP_PWM0_CH0@GPC_MFP0', 'PWM0_CH2:SYS_GPC_MFP0_PC2MFP_PWM0_CH2@GPC_MFP0', 'PWM0_CH4:SYS_GPC_MFP0_PC2MFP_PWM0_CH4@GPC_MFP0', 'UART0_TXD:SYS_GPC_MFP0_PC2MFP_UART0_TXD@GPC_MFP0', 'UART0_RXD:SYS_GPC_MFP0_PC2MFP_UART0_RXD@GPC_MFP0', 'USCI0_CLK:SYS_GPC_MFP0_PC2MFP_USCI0_CLK@GPC_MFP0', 'USCI0_DAT0:SYS_GPC_MFP0_PC2MFP_USCI0_DAT0@GPC_MFP0', 'USCI0_DAT1:SYS_GPC_MFP0_PC2MFP_USCI0_DAT1@GPC_MFP0', 'USCI0_CTL0:SYS_GPC_MFP0_PC2MFP_USCI0_CTL0@GPC_MFP0', 'USCI1_CTL1:SYS_GPC_MFP0_PC2MFP_USCI1_CTL1@GPC_MFP0', 'USCI1_CLK:SYS_GPC_MFP0_PC2MFP_USCI1_CLK@GPC_MFP0', 'USCI1_DAT0:SYS_GPC_MFP0_PC2MFP_USCI1_DAT0@GPC_MFP0', 'USCI1_DAT1:SYS_GPC_MFP0_PC2MFP_USCI1_DAT1@GPC_MFP0', 'USCI1_CTL0:SYS_GPC_MFP0_PC2MFP_USCI1_CTL0@GPC_MFP0', 'CAN0_TXD:SYS_GPC_MFP0_PC2MFP_CAN0_TXD@GPC_MFP0', 'CAN0_RXD:SYS_GPC_MFP0_PC2MFP_CAN0_RXD@GPC_MFP0', 'ACMP0_O:SYS_GPC_MFP0_PC2MFP_ACMP0_O@GPC_MFP0', 'ACMP1_O:SYS_GPC_MFP0_PC2MFP_ACMP1_O@GPC_MFP0', 'ADC0_ST:SYS_GPC_MFP0_PC2MFP_ADC0_ST@GPC_MFP0', 'TM0:SYS_GPC_MFP0_PC2MFP_TM0@GPC_MFP0', 'TM2:SYS_GPC_MFP0_PC2MFP_TM2@GPC_MFP0', 'TM0_EXT:SYS_GPC_MFP0_PC2MFP_TM0_EXT@GPC_MFP0', 'TM2_EXT:SYS_GPC_MFP0_PC2MFP_TM2_EXT@GPC_MFP0', 'UART1_TXD:SYS_GPC_MFP0_PC2MFP_UART1_TXD@GPC_MFP0', 'UART1_RXD:SYS_GPC_MFP0_PC2MFP_UART1_RXD@GPC_MFP0', 'UART1_nRTS:SYS_GPC_MFP0_PC2MFP_UART1_nRTS@GPC_MFP0'] },
	{ f: ['PC.3', 'GPIO:SYS_GPC_MFP0_PC3MFP_GPIO@GPC_MFP0', 'ADC0_CH12:SYS_GPC_MFP0_PC3MFP_ADC0_CH12@GPC_MFP0', 'ACMP0_N3:SYS_GPC_MFP0_PC3MFP_ACMP0_N3@GPC_MFP0', 'ACMP1_N3:SYS_GPC_MFP0_PC3MFP_ACMP1_N3@GPC_MFP0', 'UART0_nRTS:SYS_GPC_MFP0_PC3MFP_UART0_nRTS@GPC_MFP0', 'UART0_nCTS:SYS_GPC_MFP0_PC3MFP_UART0_nCTS@GPC_MFP0', 'CLKO:SYS_GPC_MFP0_PC3MFP_CLKO@GPC_MFP0', 'PWM0_CH1:SYS_GPC_MFP0_PC3MFP_PWM0_CH1@GPC_MFP0', 'PWM0_CH3:SYS_GPC_MFP0_PC3MFP_PWM0_CH3@GPC_MFP0', 'PWM0_CH5:SYS_GPC_MFP0_PC3MFP_PWM0_CH5@GPC_MFP0', 'UART0_TXD:SYS_GPC_MFP0_PC3MFP_UART0_TXD@GPC_MFP0', 'UART0_RXD:SYS_GPC_MFP0_PC3MFP_UART0_RXD@GPC_MFP0', 'USCI0_CLK:SYS_GPC_MFP0_PC3MFP_USCI0_CLK@GPC_MFP0', 'USCI0_DAT0:SYS_GPC_MFP0_PC3MFP_USCI0_DAT0@GPC_MFP0', 'USCI0_DAT1:SYS_GPC_MFP0_PC3MFP_USCI0_DAT1@GPC_MFP0', 'USCI0_CTL0:SYS_GPC_MFP0_PC3MFP_USCI0_CTL0@GPC_MFP0', 'USCI0_CTL1:SYS_GPC_MFP0_PC3MFP_USCI0_CTL1@GPC_MFP0', 'USCI1_CLK:SYS_GPC_MFP0_PC3MFP_USCI1_CLK@GPC_MFP0', 'USCI1_DAT0:SYS_GPC_MFP0_PC3MFP_USCI1_DAT0@GPC_MFP0', 'USCI1_DAT1:SYS_GPC_MFP0_PC3MFP_USCI1_DAT1@GPC_MFP0', 'USCI1_CTL0:SYS_GPC_MFP0_PC3MFP_USCI1_CTL0@GPC_MFP0', 'CAN0_TXD:SYS_GPC_MFP0_PC3MFP_CAN0_TXD@GPC_MFP0', 'CAN0_RXD:SYS_GPC_MFP0_PC3MFP_CAN0_RXD@GPC_MFP0', 'ACMP0_O:SYS_GPC_MFP0_PC3MFP_ACMP0_O@GPC_MFP0', 'ACMP1_O:SYS_GPC_MFP0_PC3MFP_ACMP1_O@GPC_MFP0', 'ADC0_ST:SYS_GPC_MFP0_PC3MFP_ADC0_ST@GPC_MFP0', 'TM1:SYS_GPC_MFP0_PC3MFP_TM1@GPC_MFP0', 'TM3:SYS_GPC_MFP0_PC3MFP_TM3@GPC_MFP0', 'TM1_EXT:SYS_GPC_MFP0_PC3MFP_TM1_EXT@GPC_MFP0', 'TM3_EXT:SYS_GPC_MFP0_PC3MFP_TM3_EXT@GPC_MFP0', 'UART1_TXD:SYS_GPC_MFP0_PC3MFP_UART1_TXD@GPC_MFP0', 'UART1_RXD:SYS_GPC_MFP0_PC3MFP_UART1_RXD@GPC_MFP0', 'INT3:SYS_GPC_MFP0_PC3MFP_INT3@GPC_MFP0'] },
	{ f: ['PC.4', 'GPIO:SYS_GPC_MFP1_PC4MFP_GPIO@GPC_MFP1', 'ADC0_CH13:SYS_GPC_MFP1_PC4MFP_ADC0_CH13@GPC_MFP1', 'X32_OUT:SYS_GPC_MFP1_PC4MFP_X32_OUT@GPC_MFP1', 'UART0_nCTS:SYS_GPC_MFP1_PC4MFP_UART0_nCTS@GPC_MFP1', 'CLKO:SYS_GPC_MFP1_PC4MFP_CLKO@GPC_MFP1', 'PWM0_CH0:SYS_GPC_MFP1_PC4MFP_PWM0_CH0@GPC_MFP1', 'PWM0_CH2:SYS_GPC_MFP1_PC4MFP_PWM0_CH2@GPC_MFP1', 'PWM0_CH4:SYS_GPC_MFP1_PC4MFP_PWM0_CH4@GPC_MFP1', 'UART0_TXD:SYS_GPC_MFP1_PC4MFP_UART0_TXD@GPC_MFP1', 'UART0_RXD:SYS_GPC_MFP1_PC4MFP_UART0_RXD@GPC_MFP1', 'USCI0_CLK:SYS_GPC_MFP1_PC4MFP_USCI0_CLK@GPC_MFP1', 'USCI0_DAT0:SYS_GPC_MFP1_PC4MFP_USCI0_DAT0@GPC_MFP1', 'USCI0_DAT1:SYS_GPC_MFP1_PC4MFP_USCI0_DAT1@GPC_MFP1', 'USCI0_CTL0:SYS_GPC_MFP1_PC4MFP_USCI0_CTL0@GPC_MFP1', 'USCI1_CTL1:SYS_GPC_MFP1_PC4MFP_USCI1_CTL1@GPC_MFP1', 'USCI1_CLK:SYS_GPC_MFP1_PC4MFP_USCI1_CLK@GPC_MFP1', 'USCI1_DAT0:SYS_GPC_MFP1_PC4MFP_USCI1_DAT0@GPC_MFP1', 'USCI1_DAT1:SYS_GPC_MFP1_PC4MFP_USCI1_DAT1@GPC_MFP1', 'USCI1_CTL0:SYS_GPC_MFP1_PC4MFP_USCI1_CTL0@GPC_MFP1', 'CAN0_TXD:SYS_GPC_MFP1_PC4MFP_CAN0_TXD@GPC_MFP1', 'CAN0_RXD:SYS_GPC_MFP1_PC4MFP_CAN0_RXD@GPC_MFP1', 'ACMP0_O:SYS_GPC_MFP1_PC4MFP_ACMP0_O@GPC_MFP1', 'ACMP1_O:SYS_GPC_MFP1_PC4MFP_ACMP1_O@GPC_MFP1', 'ADC0_ST:SYS_GPC_MFP1_PC4MFP_ADC0_ST@GPC_MFP1', 'TM0:SYS_GPC_MFP1_PC4MFP_TM0@GPC_MFP1', 'TM2:SYS_GPC_MFP1_PC4MFP_TM2@GPC_MFP1', 'TM0_EXT:SYS_GPC_MFP1_PC4MFP_TM0_EXT@GPC_MFP1', 'TM2_EXT:SYS_GPC_MFP1_PC4MFP_TM2_EXT@GPC_MFP1', 'UART1_TXD:SYS_GPC_MFP1_PC4MFP_UART1_TXD@GPC_MFP1', 'UART1_RXD:SYS_GPC_MFP1_PC4MFP_UART1_RXD@GPC_MFP1', 'INT2:SYS_GPC_MFP1_PC4MFP_INT2@GPC_MFP1'] },
	{ f: ['PC.5', 'GPIO:SYS_GPC_MFP1_PC5MFP_GPIO@GPC_MFP1', 'ADC0_CH14:SYS_GPC_MFP1_PC5MFP_ADC0_CH14@GPC_MFP1', 'X32_IN:SYS_GPC_MFP1_PC5MFP_X32_IN@GPC_MFP1', 'UART0_nCTS:SYS_GPC_MFP1_PC5MFP_UART0_nCTS@GPC_MFP1', 'CLKO:SYS_GPC_MFP1_PC5MFP_CLKO@GPC_MFP1', 'PWM0_CH1:SYS_GPC_MFP1_PC5MFP_PWM0_CH1@GPC_MFP1', 'PWM0_CH3:SYS_GPC_MFP1_PC5MFP_PWM0_CH3@GPC_MFP1', 'PWM0_CH5:SYS_GPC_MFP1_PC5MFP_PWM0_CH5@GPC_MFP1', 'UART0_TXD:SYS_GPC_MFP1_PC5MFP_UART0_TXD@GPC_MFP1', 'UART0_RXD:SYS_GPC_MFP1_PC5MFP_UART0_RXD@GPC_MFP1', 'USCI0_CLK:SYS_GPC_MFP1_PC5MFP_USCI0_CLK@GPC_MFP1', 'USCI0_DAT0:SYS_GPC_MFP1_PC5MFP_USCI0_DAT0@GPC_MFP1', 'USCI0_DAT1:SYS_GPC_MFP1_PC5MFP_USCI0_DAT1@GPC_MFP1', 'USCI0_CTL0:SYS_GPC_MFP1_PC5MFP_USCI0_CTL0@GPC_MFP1', 'USCI0_CTL1:SYS_GPC_MFP1_PC5MFP_USCI0_CTL1@GPC_MFP1', 'USCI1_CLK:SYS_GPC_MFP1_PC5MFP_USCI1_CLK@GPC_MFP1', 'USCI1_DAT0:SYS_GPC_MFP1_PC5MFP_USCI1_DAT0@GPC_MFP1', 'USCI1_DAT1:SYS_GPC_MFP1_PC5MFP_USCI1_DAT1@GPC_MFP1', 'USCI1_CTL0:SYS_GPC_MFP1_PC5MFP_USCI1_CTL0@GPC_MFP1', 'CAN0_TXD:SYS_GPC_MFP1_PC5MFP_CAN0_TXD@GPC_MFP1', 'CAN0_RXD:SYS_GPC_MFP1_PC5MFP_CAN0_RXD@GPC_MFP1', 'ACMP0_O:SYS_GPC_MFP1_PC5MFP_ACMP0_O@GPC_MFP1', 'ACMP1_O:SYS_GPC_MFP1_PC5MFP_ACMP1_O@GPC_MFP1', 'ADC0_ST:SYS_GPC_MFP1_PC5MFP_ADC0_ST@GPC_MFP1', 'TM1:SYS_GPC_MFP1_PC5MFP_TM1@GPC_MFP1', 'TM3:SYS_GPC_MFP1_PC5MFP_TM3@GPC_MFP1', 'TM1_EXT:SYS_GPC_MFP1_PC5MFP_TM1_EXT@GPC_MFP1', 'TM3_EXT:SYS_GPC_MFP1_PC5MFP_TM3_EXT@GPC_MFP1', 'UART1_TXD:SYS_GPC_MFP1_PC5MFP_UART1_TXD@GPC_MFP1', 'UART1_RXD:SYS_GPC_MFP1_PC5MFP_UART1_RXD@GPC_MFP1', 'INT1:SYS_GPC_MFP1_PC5MFP_INT1@GPC_MFP1'] },
	{ f: ['PC.6', 'GPIO:SYS_GPC_MFP1_PC6MFP_GPIO@GPC_MFP1', 'ADC0_CH11:SYS_GPC_MFP1_PC6MFP_ADC0_CH11@GPC_MFP1', 'UART0_nRTS:SYS_GPC_MFP1_PC6MFP_UART0_nRTS@GPC_MFP1', 'UART0_nCTS:SYS_GPC_MFP1_PC6MFP_UART0_nCTS@GPC_MFP1', 'CLKO:SYS_GPC_MFP1_PC6MFP_CLKO@GPC_MFP1', 'PWM0_CH0:SYS_GPC_MFP1_PC6MFP_PWM0_CH0@GPC_MFP1', 'PWM0_CH2:SYS_GPC_MFP1_PC6MFP_PWM0_CH2@GPC_MFP1', 'PWM0_CH4:SYS_GPC_MFP1_PC6MFP_PWM0_CH4@GPC_MFP1', 'UART0_TXD:SYS_GPC_MFP1_PC6MFP_UART0_TXD@GPC_MFP1', 'UART0_RXD:SYS_GPC_MFP1_PC6MFP_UART0_RXD@GPC_MFP1', 'USCI0_CLK:SYS_GPC_MFP1_PC6MFP_USCI0_CLK@GPC_MFP1', 'USCI0_DAT0:SYS_GPC_MFP1_PC6MFP_USCI0_DAT0@GPC_MFP1', 'USCI0_DAT1:SYS_GPC_MFP1_PC6MFP_USCI0_DAT1@GPC_MFP1', 'USCI0_CTL0:SYS_GPC_MFP1_PC6MFP_USCI0_CTL0@GPC_MFP1', 'USCI1_CTL1:SYS_GPC_MFP1_PC6MFP_USCI1_CTL1@GPC_MFP1', 'USCI1_CLK:SYS_GPC_MFP1_PC6MFP_USCI1_CLK@GPC_MFP1', 'USCI1_DAT0:SYS_GPC_MFP1_PC6MFP_USCI1_DAT0@GPC_MFP1', 'USCI1_DAT1:SYS_GPC_MFP1_PC6MFP_USCI1_DAT1@GPC_MFP1', 'USCI1_CTL0:SYS_GPC_MFP1_PC6MFP_USCI1_CTL0@GPC_MFP1', 'CAN0_TXD:SYS_GPC_MFP1_PC6MFP_CAN0_TXD@GPC_MFP1', 'CAN0_RXD:SYS_GPC_MFP1_PC6MFP_CAN0_RXD@GPC_MFP1', 'ACMP0_O:SYS_GPC_MFP1_PC6MFP_ACMP0_O@GPC_MFP1', 'ACMP1_O:SYS_GPC_MFP1_PC6MFP_ACMP1_O@GPC_MFP1', 'ADC0_ST:SYS_GPC_MFP1_PC6MFP_ADC0_ST@GPC_MFP1', 'TM0:SYS_GPC_MFP1_PC6MFP_TM0@GPC_MFP1', 'TM2:SYS_GPC_MFP1_PC6MFP_TM2@GPC_MFP1', 'TM0_EXT:SYS_GPC_MFP1_PC6MFP_TM0_EXT@GPC_MFP1', 'TM2_EXT:SYS_GPC_MFP1_PC6MFP_TM2_EXT@GPC_MFP1', 'UART1_TXD:SYS_GPC_MFP1_PC6MFP_UART1_TXD@GPC_MFP1', 'UART1_RXD:SYS_GPC_MFP1_PC6MFP_UART1_RXD@GPC_MFP1', 'INT4:SYS_GPC_MFP1_PC6MFP_INT4@GPC_MFP1'] },
	{ f: ['PC.7', 'GPIO:SYS_GPC_MFP1_PC7MFP_GPIO@GPC_MFP1', 'ADC0_CH10:SYS_GPC_MFP1_PC7MFP_ADC0_CH10@GPC_MFP1', 'UART0_nRTS:SYS_GPC_MFP1_PC7MFP_UART0_nRTS@GPC_MFP1', 'UART0_nCTS:SYS_GPC_MFP1_PC7MFP_UART0_nCTS@GPC_MFP1', 'CLKO:SYS_GPC_MFP1_PC7MFP_CLKO@GPC_MFP1', 'PWM0_CH1:SYS_GPC_MFP1_PC7MFP_PWM0_CH1@GPC_MFP1', 'PWM0_CH3:SYS_GPC_MFP1_PC7MFP_PWM0_CH3@GPC_MFP1', 'PWM0_CH5:SYS_GPC_MFP1_PC7MFP_PWM0_CH5@GPC_MFP1', 'UART0_TXD:SYS_GPC_MFP1_PC7MFP_UART0_TXD@GPC_MFP1', 'UART0_RXD:SYS_GPC_MFP1_PC7MFP_UART0_RXD@GPC_MFP1', 'USCI0_CLK:SYS_GPC_MFP1_PC7MFP_USCI0_CLK@GPC_MFP1', 'USCI0_DAT0:SYS_GPC_MFP1_PC7MFP_USCI0_DAT0@GPC_MFP1', 'USCI0_DAT1:SYS_GPC_MFP1_PC7MFP_USCI0_DAT1@GPC_MFP1', 'USCI0_CTL0:SYS_GPC_MFP1_PC7MFP_USCI0_CTL0@GPC_MFP1', 'USCI0_CTL1:SYS_GPC_MFP1_PC7MFP_USCI0_CTL1@GPC_MFP1', 'USCI1_CLK:SYS_GPC_MFP1_PC7MFP_USCI1_CLK@GPC_MFP1', 'USCI1_DAT0:SYS_GPC_MFP1_PC7MFP_USCI1_DAT0@GPC_MFP1', 'USCI1_DAT1:SYS_GPC_MFP1_PC7MFP_USCI1_DAT1@GPC_MFP1', 'USCI1_CTL0:SYS_GPC_MFP1_PC7MFP_USCI1_CTL0@GPC_MFP1', 'CAN0_TXD:SYS_GPC_MFP1_PC7MFP_CAN0_TXD@GPC_MFP1', 'CAN0_RXD:SYS_GPC_MFP1_PC7MFP_CAN0_RXD@GPC_MFP1', 'ACMP0_O:SYS_GPC_MFP1_PC7MFP_ACMP0_O@GPC_MFP1', 'ACMP1_O:SYS_GPC_MFP1_PC7MFP_ACMP1_O@GPC_MFP1', 'ADC0_ST:SYS_GPC_MFP1_PC7MFP_ADC0_ST@GPC_MFP1', 'TM1:SYS_GPC_MFP1_PC7MFP_TM1@GPC_MFP1', 'TM3:SYS_GPC_MFP1_PC7MFP_TM3@GPC_MFP1', 'TM1_EXT:SYS_GPC_MFP1_PC7MFP_TM1_EXT@GPC_MFP1', 'TM3_EXT:SYS_GPC_MFP1_PC7MFP_TM3_EXT@GPC_MFP1', 'UART1_TXD:SYS_GPC_MFP1_PC7MFP_UART1_TXD@GPC_MFP1', 'UART1_RXD:SYS_GPC_MFP1_PC7MFP_UART1_RXD@GPC_MFP1', 'INT5:SYS_GPC_MFP1_PC7MFP_INT5@GPC_MFP1'] },

	{ f: ['PD.0', 'GPIO:SYS_GPD_MFP0_PD0MFP_GPIO@GPD_MFP0', 'PWM0_CH4:SYS_GPD_MFP0_PD0MFP_PWM0_CH4@GPD_MFP0', 'UART0_TXD:SYS_GPD_MFP0_PD0MFP_UART0_TXD@GPD_MFP0', 'USCI1_CLK:SYS_GPD_MFP0_PD0MFP_USCI1_CLK@GPD_MFP0', 'TM0:SYS_GPD_MFP0_PD0MFP_TM0@GPD_MFP0'] },
	{ f: ['PD.1', 'GPIO:SYS_GPD_MFP0_PD1MFP_GPIO@GPD_MFP0', 'PWM0_CH5:SYS_GPD_MFP0_PD1MFP_PWM0_CH5@GPD_MFP0', 'UART0_RXD:SYS_GPD_MFP0_PD1MFP_UART0_RXD@GPD_MFP0', 'USCI1_DAT0:SYS_GPD_MFP0_PD1MFP_USCI1_DAT0@GPD_MFP0', 'TM1:SYS_GPD_MFP0_PD1MFP_TM1@GPD_MFP0'] },
	{ f: ['PD.2', 'GPIO:SYS_GPD_MFP0_PD2MFP_GPIO@GPD_MFP0', 'PWM0_CH0:SYS_GPD_MFP0_PD2MFP_PWM0_CH0@GPD_MFP0', 'CAN0_TXD:SYS_GPD_MFP0_PD2MFP_CAN0_TXD@GPD_MFP0', 'USCI1_DAT1:SYS_GPD_MFP0_PD2MFP_USCI1_DAT1@GPD_MFP0', 'TM2:SYS_GPD_MFP0_PD2MFP_TM2@GPD_MFP0', 'UART1_nCTS:SYS_GPD_MFP0_PD2MFP_UART1_nCTS@GPD_MFP0'] },
	{ f: ['PD.3', 'GPIO:SYS_GPD_MFP0_PD3MFP_GPIO@GPD_MFP0', 'PWM0_CH1:SYS_GPD_MFP0_PD3MFP_PWM0_CH1@GPD_MFP0', 'CAN0_RXD:SYS_GPD_MFP0_PD3MFP_CAN0_RXD@GPD_MFP0', 'USCI1_CTL0:SYS_GPD_MFP0_PD3MFP_USCI1_CTL0@GPD_MFP0', 'TM3:SYS_GPD_MFP0_PD3MFP_TM3@GPD_MFP0', 'UART1_nRTS:SYS_GPD_MFP0_PD3MFP_UART1_nRTS@GPD_MFP0'] },
	{ f: ['PD.4', 'GPIO:SYS_GPD_MFP1_PD4MFP_GPIO@GPD_MFP1', 'PWM0_CH0:SYS_GPD_MFP1_PD4MFP_PWM0_CH0@GPD_MFP1', 'UART0_TXD:SYS_GPD_MFP1_PD4MFP_UART0_TXD@GPD_MFP1', 'USCI0_CLK:SYS_GPD_MFP1_PD4MFP_USCI0_CLK@GPD_MFP1', 'TM0:SYS_GPD_MFP1_PD4MFP_TM0@GPD_MFP1'] },
	{ f: ['PD.5', 'GPIO:SYS_GPD_MFP1_PD5MFP_GPIO@GPD_MFP1', 'PWM0_CH1:SYS_GPD_MFP1_PD5MFP_PWM0_CH1@GPD_MFP1', 'UART0_RXD:SYS_GPD_MFP1_PD5MFP_UART0_RXD@GPD_MFP1', 'USCI0_DAT0:SYS_GPD_MFP1_PD5MFP_USCI0_DAT0@GPD_MFP1', 'TM1:SYS_GPD_MFP1_PD5MFP_TM1@GPD_MFP1'] },
	{ f: ['PD.6', 'GPIO:SYS_GPD_MFP1_PD6MFP_GPIO@GPD_MFP1', 'PWM0_CH2:SYS_GPD_MFP1_PD6MFP_PWM0_CH2@GPD_MFP1', 'CAN0_TXD:SYS_GPD_MFP1_PD6MFP_CAN0_TXD@GPD_MFP1', 'USCI0_DAT1:SYS_GPD_MFP1_PD6MFP_USCI0_DAT1@GPD_MFP1', 'TM2:SYS_GPD_MFP1_PD6MFP_TM2@GPD_MFP1', 'UART1_nCTS:SYS_GPD_MFP1_PD6MFP_UART1_nCTS@GPD_MFP1'] },
	{ f: ['PD.7', 'GPIO:SYS_GPD_MFP1_PD7MFP_GPIO@GPD_MFP1', 'PWM0_CH3:SYS_GPD_MFP1_PD7MFP_PWM0_CH3@GPD_MFP1', 'CAN0_RXD:SYS_GPD_MFP1_PD7MFP_CAN0_RXD@GPD_MFP1', 'USCI0_CTL0:SYS_GPD_MFP1_PD7MFP_USCI0_CTL0@GPD_MFP1', 'TM3:SYS_GPD_MFP1_PD7MFP_TM3@GPD_MFP1', 'UART1_nRTS:SYS_GPD_MFP1_PD7MFP_UART1_nRTS@GPD_MFP1'] }
];

NUTOOL_PIN.g_cfg_gpiosDescriptions = [
	'ACMP0_N0:Analog comparator 0 negative input 0 pin',
	'ACMP0_N1:Analog comparator 0 negative input 1 pin',
	'ACMP0_N2:Analog comparator 0 negative input 2 pin',
	'ACMP0_N3:Analog comparator 0 negative input 3 pin',
	'ACMP0_O:Analog comparator 0 output pin',
	'ACMP0_P0:Analog comparator 0 positive input 0 pin',
	'ACMP0_P1:Analog comparator 0 positive input 1 pin',
	'ACMP0_P2:Analog comparator 0 positive input 2 pin',
	'ACMP0_P3:Analog comparator 0 positive input 3 pin',
	'ACMP0_WLAT:Analog comparator 0 window latch input pin',
	'ACMP1_N0:Analog comparator 1 negative input 0 pin',
	'ACMP1_N1:Analog comparator 1 negative input 1 pin',
	'ACMP1_N2:Analog comparator 1 negative input 2 pin',
	'ACMP1_N3:Analog comparator 1 negative input 3 pin',
	'ACMP1_O:Analog comparator 1 output pin',
	'ACMP1_P0:Analog comparator 1 positive input 0 pin',
	'ACMP1_P1:Analog comparator 1 positive input 1 pin',
	'ACMP1_P2:Analog comparator 1 positive input 2 pin',
	'ACMP1_P3:Analog comparator 1 positive input 3 pin',
	'ACMP1_WLAT:Analog comparator 1 window latch input pin',
	'ADC0_CH0:ADC0 channel 0 analog input',
	'ADC0_CH1:ADC0 channel 1 analog input',
	'ADC0_CH2:ADC0 channel 2 analog input',
	'ADC0_CH3:ADC0 channel 3 analog input',
	'ADC0_CH4:ADC0 channel 4 analog input',
	'ADC0_CH5:ADC0 channel 5 analog input',
	'ADC0_CH6:ADC0 channel 6 analog input',
	'ADC0_CH7:ADC0 channel 7 analog input',
	'ADC0_CH8:ADC0 channel 8 analog input',
	'ADC0_CH9:ADC0 channel 9 analog input',
	'ADC0_CH10:ADC0 channel 10 analog input',
	'ADC0_CH11:ADC0 channel 11 analog input',
	'ADC0_CH12:ADC0 channel 12 analog input',
	'ADC0_CH13:ADC0 channel 13 analog input',
	'ADC0_CH14:ADC0 channel 14 analog input',
	'ADC0_CH15:ADC0 channel 15 analog input',
	'ADC0_CH16:ADC0 channel 16 analog input',
	'ADC0_ST:ADC0 external trigger input pin',
	'AVDD:Power supply for internal analog circuit',
	'AVSS:Ground pin for analog circuit',
	'BPWM0_CH0:BPWM0 channel 0 output/capture input',
	'BPWM0_CH1:BPWM0 channel 1 output/capture input',
	'BPWM0_CH2:BPWM0 channel 2 output/capture input',
	'BPWM0_CH3:BPWM0 channel 3 output/capture input',
	'BPWM0_CH4:BPWM0 channel 4 output/capture input',
	'BPWM0_CH5:BPWM0 channel 5 output/capture input',
	'BPWM1_CH0:BPWM1 channel 0 output/capture input',
	'BPWM1_CH1:BPWM1 channel 1 output/capture input',
	'BPWM1_CH2:BPWM1 channel 2 output/capture input',
	'BPWM1_CH3:BPWM1 channel 3 output/capture input',
	'BPWM1_CH4:BPWM1 channel 4 output/capture input',
	'BPWM1_CH5:BPWM1 channel 5 output/capture input',
	'CAN0_RXD:CAN0 bus receiver input',
	'CAN0_TXD:CAN0 bus transmitter output',
	'CLKO:Clock Out',
	'DAC0_OUT:DAC0 channel analog output',
	'EBI_AD0:EBI address/data bus bit 0',
	'EBI_AD1:EBI address/data bus bit 1',
	'EBI_AD2:EBI address/data bus bit 2',
	'EBI_AD3:EBI address/data bus bit 3',
	'EBI_AD4:EBI address/data bus bit 4',
	'EBI_AD5:EBI address/data bus bit 5',
	'EBI_AD6:EBI address/data bus bit 6',
	'EBI_AD7:EBI address/data bus bit 7',
	'EBI_AD8:EBI address/data bus bit 8',
	'EBI_AD9:EBI address/data bus bit 9',
	'EBI_AD10:EBI address/data bus bit 10',
	'EBI_AD11:EBI address/data bus bit 11',
	'EBI_AD12:EBI address/data bus bit 12',
	'EBI_AD13:EBI address/data bus bit 13',
	'EBI_AD14:EBI address/data bus bit 14',
	'EBI_AD15:EBI address/data bus bit 15',
	'EBI_ADR0:EBI address bus bit 0',
	'EBI_ADR1:EBI address bus bit 1',
	'EBI_ADR2:EBI address bus bit 2',
	'EBI_ADR3:EBI address bus bit 3',
	'EBI_ADR4:EBI address bus bit 4',
	'EBI_ADR5:EBI address bus bit 5',
	'EBI_ADR6:EBI address bus bit 6',
	'EBI_ADR7:EBI address bus bit 7',
	'EBI_ADR8:EBI address bus bit 8',
	'EBI_ADR9:EBI address bus bit 9',
	'EBI_ADR10:EBI address bus bit 10',
	'EBI_ADR11:EBI address bus bit 11',
	'EBI_ADR12:EBI address bus bit 12',
	'EBI_ADR13:EBI address bus bit 13',
	'EBI_ADR14:EBI address bus bit 14',
	'EBI_ADR15:EBI address bus bit 15',
	'EBI_ADR16:EBI address bus bit 16',
	'EBI_ADR17:EBI address bus bit 17',
	'EBI_ADR18:EBI address bus bit 18',
	'EBI_ADR19:EBI address bus bit 19',
	'EBI_ALE:EBI address latch enable output pin',
	'EBI_MCLK:EBI external clock output pin',
	'EBI_nCS0:EBI chip select 0 output pin',
	'EBI_nCS1:EBI chip select 1 output pin',
	'EBI_nRD:EBI read enable output pin',
	'EBI_nWR:EBI write enable output pin',
	'EBI_nWRH:EBI high byte write enable output pin',
	'EBI_nWRL:EBI low byte write enable output pin',
	'I2C0_SCL:I2C0 clock pin',
	'I2C0_SDA:I2C0 data input/output pin',
	'I2C0_SMBAL:I2C0 SMBus SMBALTER pin ',
	'I2C0_SMBSUS:I2C0 SMBus SMBSUS pin (PMBus CONTROL pin)',
	'I2C1_SCL:I2C1 clock pin',
	'I2C1_SDA:I2C1 data input/output pin',
	'ICE_CLK:ADC external trigger input',
	'ICE_DAT:ADC external trigger input',
	'INT0:External interrupt 0 input pin',
	'INT1:External interrupt 1 input pin',
	'INT2:External interrupt 2 input pin',
	'INT3:External interrupt 3 input pin',
	'INT4:External interrupt 4 input pin',
	'INT5:External interrupt 5 input pin',
	'LDO_CAP:LDO output pin',
	'nRESET:External reset input: active LOW, with an internal pull-up. Set this pin low reset to initial state',
	'PWM0_BRAKE0:PWM0 Brake 0 input pin',
	'PWM0_BRAKE1:PWM0 Brake 1 input pin',
	'PWM0_CH0:PWM0 channel 0 output/capture input',
	'PWM0_CH1:PWM0 channel 1 output/capture input',
	'PWM0_CH2:PWM0 channel 2 output/capture input',
	'PWM0_CH3:PWM0 channel 3 output/capture input',
	'PWM0_CH4:PWM0 channel 4 output/capture input',
	'PWM0_CH5:PWM0 channel 5 output/capture input',
	'PWM1_BRAKE0:PWM1 Brake 0 input pin',
	'PWM1_BRAKE1:PWM1 Brake 1 input pin',
	'PWM1_CH0:PWM1 channel 0 output/capture input',
	'PWM1_CH1:PWM1 channel 1 output/capture input',
	'PWM1_CH2:PWM1 channel 2 output/capture input',
	'PWM1_CH3:PWM1 channel 3 output/capture input',
	'PWM1_CH4:PWM1 channel 4 output/capture input',
	'PWM1_CH5:PWM1 channel 5 output/capture input',
	'QSPI0_CLK:Quad SPI0 serial clock pin',
	'QSPI0_MISO0:Quad SPI0 MISO0 (Master In, Slave Out) pin',
	'QSPI0_MISO1:Quad SPI0 MISO1 (Master In, Slave Out) pin',
	'QSPI0_MOSI0:Quad SPI0 MOSI0 (Master Out, Slave In) pin',
	'QSPI0_MOSI1:Quad SPI0 MOSI1 (Master Out, Slave In) pin',
	'QSPI0_SS:Quad SPI0 slave select  pin',
	'SPI0_CLK:SPI0 serial clock pin',
	'SPI0_I2SMCLK:SPI0 I2S master clock output pin',
	'SPI0_MISO:SPI0 MISO (Master In, Slave Out) pin',
	'SPI0_MOSI:SPI0 MOSI (Master Out, Slave In) pin',
	'SPI0_SS:SPI0 slave select  pin',
	'TM0:Timer0 event counter input/toggle output pin',
	'TM0_EXT:Timer0 external capture input/toggle output pin',
	'TM1:Timer1 event counter input/toggle output pin',
	'TM1_EXT:Timer1 external capture input/toggle output pin',
	'TM2:Timer2 event counter input/toggle output pin',
	'TM2_EXT:Timer2 external capture input/toggle output pin',
	'TM3:Timer3 event counter input/toggle output pin',
	'TM3_EXT:Timer3 external capture input/toggle output pin',
	'UART0_nCTS:UART0 clear to Send input pin',
	'UART0_nRTS:UART0 request to Send output pin',
	'UART0_RXD:UART0 data receiver input pin',
	'UART0_TXD:UART0 data transmitter output pin',
	'UART1_nCTS:UART1 clear to Send input pin',
	'UART1_nRTS:UART1 request to Send output pin',
	'UART1_RXD:UART1 data receiver input pin',
	'UART1_TXD:UART1 data transmitter output pin',
	'UART2_nCTS:UART2 clear to Send input pin',
	'UART2_nRTS:UART2 request to Send output pin',
	'UART2_RXD:UART2 data receiver input pin',
	'UART2_TXD:UART2 data transmitter output pin',
	'UART3_nCTS:UART3 clear to Send input pin',
	'UART3_nRTS:UART3 request to Send output pin',
	'UART3_RXD:UART3 data receiver input pin',
	'UART3_TXD:UART3 data transmitter output pin',
	'UART4_nCTS:UART4 clear to Send input pin',
	'UART4_nRTS:UART4 request to Send output pin',
	'UART4_RXD:UART4 data receiver input pin',
	'UART4_TXD:UART4 data transmitter output pin',
	'UART5_nCTS:UART5 clear to Send input pin',
	'UART5_nRTS:UART5 request to Send output pin',
	'UART5_RXD:UART5 data receiver input pin',
	'UART5_TXD:UART5 data transmitter output pin',
	'UART6_nCTS:UART6 clear to Send input pin',
	'UART6_nRTS:UART6 request to Send output pin',
	'UART6_RXD:UART6 data receiver input pin',
	'UART6_TXD:UART6 data transmitter output pin',
	'UART7_nCTS:UART7 clear to Send input pin',
	'UART7_nRTS:UART7 request to Send output pin',
	'UART7_RXD:UART7 data receiver input pin',
	'UART7_TXD:UART7 data transmitter output pin',
	'USB_D-:USB differential signal D-',
	'USB_D+:USB differential signal D+',
	'USB_VBUS:Power supply from USB host or HUB',
	'USB_VDD33_CAP:Internal power regulator output 3.3V decoupling pin',
	'USCI0_CLK:USCI0 clock pin',
	'USCI0_CTL0:USCI0 control 0 pin',
	'USCI0_CTL1:USCI0 control 1 pin',
	'USCI0_DAT0:USCI0 data 0 pin',
	'USCI0_DAT1:USCI0 data 1 pin',
	'USCI1_CLK:USCI1 clock pin',
	'USCI1_CTL0:USCI1 control 0 pin',
	'USCI1_CTL1:USCI1 control 1 pin',
	'USCI1_DAT0:USCI1 data 0 pin',
	'USCI1_DAT1:USCI1 data 1 pin',
	'VDD:Power supply for I/O ports and LDO source for internal PLL and digital circuit',
	'VREF:ADC reference voltage input',
	'VSS:Ground pin for digital circuit',
	'X32_IN:External 32.768 kHz crystal input pin',
	'X32_OUT:External 32.768 kHz crystal output pin',
	'XT1_IN:External 4~24 MHz (high speed) crystal input pin',
	'XT1_OUT:External 4~24 MHz (high speed) crystal output pin'
];

NUTOOL_PIN.g_cfg_regDescriptions = {};
NUTOOL_PIN.g_cfg_regDescriptions.GPA_MFP0 = '0x40000030';
NUTOOL_PIN.g_cfg_regDescriptions.GPA_MFP1 = '0x40000034';
NUTOOL_PIN.g_cfg_regDescriptions.GPB_MFP1 = '0x40000044';
NUTOOL_PIN.g_cfg_regDescriptions.GPC_MFP0 = '0x40000050';
NUTOOL_PIN.g_cfg_regDescriptions.GPC_MFP1 = '0x40000054';
NUTOOL_PIN.g_cfg_regDescriptions.GPD_MFP0 = '0x40000060';
NUTOOL_PIN.g_cfg_regDescriptions.GPD_MFP1 = '0x40000064';

NUTOOL_PIN.g_cfg_gpioMatrix = [];
NUTOOL_PIN.g_cfg_shareBits = [];
NUTOOL_PIN.g_cfg_addGPIO = {};
NUTOOL_PIN.g_cfg_unusedGPIO = {};

NUTOOL_PIN.decidepackageNumber = function (given_partNumber_package) {
	var partNumber_package;

	if (typeof given_partNumber_package === 'undefined') {
		partNumber_package = NUTOOL_PIN.getg_partNumber_package();
	}
	else {
		partNumber_package = given_partNumber_package;
	}

	NUTOOL_PIN.g_packageNumber = partNumber_package.substring(partNumber_package.indexOf('(') + 1);
	NUTOOL_PIN.g_packageNumber = NUTOOL_PIN.g_packageNumber.substring(0, NUTOOL_PIN.g_packageNumber.indexOf(')'));
	NUTOOL_PIN.g_packageNumberIndex = NUTOOL_PIN.g_packageNumber;

	partNumber_package = null;
};
