// chip content
NUTOOL_PIN.g_cfg_chips = [
	//M251
	{ name: "M251FB2AE", pkg: "TSSOP20" },
	{ name: "M251FC2AE", pkg: "TSSOP20" },
	{ name: "M251EB2AE", pkg: "TSSOP28" },
	{ name: "M251EC2AE", pkg: "TSSOP28" },
	{ name: "M251ZB2AE", pkg: "QFN33" },
	{ name: "M251ZC2AE", pkg: "QFN33" },
	{ name: "M251ZD2AE", pkg: "QFN33" },
	{ name: "M251LC2AE", pkg: "LQFP48" },
	{ name: "M251LD2AE", pkg: "LQFP48" },
	{ name: "M251LE3AE", pkg: "LQFP48" },
	{ name: "M251LG6AE", pkg: "LQFP48" },
	{ name: "M251SC2AE", pkg: "LQFP64" },
	{ name: "M251SD2AE", pkg: "LQFP64" },
	{ name: "M251SE3AE", pkg: "LQFP64" },
	{ name: "M251SG6AE", pkg: "LQFP64" },
	{ name: "M251KE3AE", pkg: "LQFP128" },
	{ name: "M251KG6AE", pkg: "LQFP128" },
	//M252
	{ name: "M252FC2AE", pkg: "TSSOP20" },
	{ name: "M252EC2AE", pkg: "TSSOP28" },
	{ name: "M252ZC2AE", pkg: "QFN33" },
	{ name: "M252ZD2AE", pkg: "QFN33" },
	{ name: "M252LC2AE", pkg: "LQFP48" },
	{ name: "M252LD2AE", pkg: "LQFP48" },
	{ name: "M252LE3AE", pkg: "LQFP48" },
	{ name: "M252LG6AE", pkg: "LQFP48" },
	{ name: "M252SC2AE", pkg: "LQFP64" },
	{ name: "M252SD2AE", pkg: "LQFP64" },
	{ name: "M252SE3AE", pkg: "LQFP64" },
	{ name: "M252SG6AE", pkg: "LQFP64" },
	{ name: "M252KE3AE", pkg: "LQFP128" },
	{ name: "M252KG6AE", pkg: "LQFP128" },
	//M253
	{ name: "M253ZE3AE", pkg: "QFN33" },
	{ name: "M253LD3AE", pkg: "LQFP48" },
	{ name: "M253LE3AE", pkg: "LQFP48" },
	//M256D
	{ name: "M256MD2AE", pkg: "LQFP44" },
	{ name: "M254SD2AE", pkg: "LQFP64" },
	{ name: "M256SD2AE", pkg: "LQFP64" },
	//M258
	{ name: "M254SD3AE", pkg: "LQFP64" },
	{ name: "M254SE3AE", pkg: "LQFP64" },
	{ name: "M254QD3AE", pkg: "LQFP80" },
	{ name: "M254QE3AE", pkg: "LQFP80" },
	{ name: "M254KD3AE", pkg: "LQFP128" },
	{ name: "M254KE3AE", pkg: "LQFP128" },
	//{ name: "M254ME3AE", pkg: "LQFP44" },
	{ name: "M256SD3AE", pkg: "LQFP64" },
	{ name: "M256SE3AE", pkg: "LQFP64" },
	{ name: "M256QD3AE", pkg: "LQFP80" },
	{ name: "M256QE3AE", pkg: "LQFP80" },
	{ name: "M256KD3AE", pkg: "LQFP128" },
	{ name: "M256KE3AE", pkg: "LQFP128" },
	{ name: "M258SD3AE", pkg: "LQFP64" },
	{ name: "M258SE3AE", pkg: "LQFP64" },
	{ name: "M258QD3AE", pkg: "LQFP80" },
	{ name: "M258QE3AE", pkg: "LQFP80" },
	{ name: "M258KD3AE", pkg: "LQFP128" },
	{ name: "M258KE3AE", pkg: "LQFP128" },
	//M258G
	{ name: "M258SG6AE", pkg: "LQFP64" },
	{ name: "M256QG6AE", pkg: "LQFP80" },
	{ name: "M254KG6AE", pkg: "LQFP128" },
	{ name: "M258KG6AE", pkg: "LQFP128" }
];

NUTOOL_PIN.g_cfg_pkgs = {
	"UQFN33": [
		'PB.5', 'PB.4', 'PB.3', 'PB.2', 'PB.1', 'PB.0', 'PF.5', 'PF.4',
		'PF.3', 'PF.2', 'PA.3', 'PA.2', 'PA.1', 'PA.0', 'PF.15', 'nRESET',
		'PF.0', 'PF.1', 'PC.1', 'PC.0', 'USB_VBUS', 'USB_D-', 'USB_D+', 'USB_VDD33_CAP',
		'VSS', 'LDO_CAP', 'VDD', 'PB.15', 'PB.14', 'PB.13', 'PB.12', 'AVDD'
	],
	"ULQFP48": [
		'PB.5', 'PB.4', 'PB.3', 'PB.2', 'PB.1', 'PB.0', 'PA.11', 'PA.10', 'PA.9', 'PA.8',
		'PF.5', 'PF.4',
		'PF.3', 'PF.2', 'PA.7', 'PA.6', 'PA.5', 'PA.4', 'PA.3', 'PA.2', 'PA.1', 'PA.0',
		'PF.15', 'nRESET',
		'PF.0', 'PF.1', 'PC.5', 'PC.4', 'PC.3', 'PC.2', 'PC.1', 'PC.0', 'USB_VBUS', 'USB_D-',
		'USB_D+', 'USB_VDD33_CAP',
		'VSS', 'LDO_CAP', 'VDD', 'PC.14', 'PB.15', 'PB.14', 'PB.13', 'PB.12', 'AVDD', 'AVSS',
		'PB.7', 'PB.6'
	]
};

NUTOOL_PIN.g_cfg_gpios = [
	{ f: ['PA.0:0', 'SPI0_MOSI:4', 'UART0_RXD:7', 'UART1_nRTS:8', 'BPWM0_CH0:12']},
	{ f: ['PA.1:0', 'SPI0_MISO:4', 'UART0_TXD:7', 'UART1_nCTS:8', 'BPWM0_CH1:12']},
	{ f: ['PA.2:0', 'UART4_RXD:2', 'SPI0_CLK:4', 'UART1_RXD:8', 'I2C1_SDA:9', 'BPWM0_CH2:12']},
	{ f: ['PA.3:0', 'UART4_TXD:2', 'SPI0_SS:4', 'UART1_TXD:8', 'I2C1_SCL:9', 'BPWM0_CH3:12', 'CLKO:14']},
	{ f: ['PA.4:0', 'CAN0_RXD:2', 'SPI0_I2SMCLK:4', 'UART0_nRTS:7', 'UART0_RXD:8', 'I2C0_SDA:9', 'BPWM0_CH4:12']},
	{ f: ['PA.5:0', 'CAN0_TXD:2', 'UART0_nCTS:7', 'UART0_TXD:8', 'I2C0_SCL:9', 'BPWM0_CH5:12']},
	{ f: ['PA.6:0', 'UART0_RXD:7', 'I2C1_SDA:8', 'TM3:14', 'INT0:15']},
	{ f: ['PA.7:0', 'UART0_TXD:7', 'I2C1_SCL:8', 'TM2:14', 'INT1:15']},
	{ f: ['PA.8:0', 'USCI0_CTL1:6', 'UART1_RXD:7', 'BPWM0_CH3:9', 'TM3_EXT:13', 'INT4:15']},
	{ f: ['PA.9:0', 'USCI0_DAT1:6', 'UART1_TXD:7', 'BPWM0_CH2:9', 'TM2_EXT:13']},
	{ f: ['PA.10:0', 'USCI0_DAT0:6', 'BPWM0_CH1:9', 'TM1_EXT:13']},
	{ f: ['PA.11:0', 'USCI0_CLK:6', 'BPWM0_CH0:9', 'TM0_EXT:13']},
	{ f: ['PA.12:0']},
	{ f: ['PA.13:0']},
	{ f: ['PA.14:0']},
	{ f: ['PA.15:0']},

	{ f: ['PB.0:0', 'EADC0_CH0:1', 'UART2_RXD:7', 'SPI0_I2SMCLK:8', 'I2C1_SDA:9']},
	{ f: ['PB.1:0', 'EADC0_CH1:1', 'UART2_TXD:7', 'I2C1_SCL:9']},
	{ f: ['PB.2:0', 'EADC0_CH2:1', 'I2C1_SDA:4', 'UART1_RXD:6', 'TM3:14', 'INT3:15']},
	{ f: ['PB.3:0', 'EADC0_CH3:1', 'I2C1_SCL:4', 'UART1_TXD:6', 'TM2:14', 'INT2:15']},
	{ f: ['PB.4:0', 'EADC0_CH4:1', 'I2C0_SDA:6', 'UART2_RXD:13', 'TM1:14', 'INT1:15']},
	{ f: ['PB.5:0', 'EADC0_CH5:1', 'I2C0_SCL:6', 'UART2_TXD:13', 'TM0:14', 'INT0:15']},
	{ f: ['PB.6:0', 'EADC0_CH6:1', 'UART1_RXD:6', 'INT4:13']},
	{ f: ['PB.7:0', 'EADC0_CH7:1', 'UART1_TXD:6', 'INT5:13']},
	{ f: ['PB.8:0']},
	{ f: ['PB.9:0']},
	{ f: ['PB.10:0']},
	{ f: ['PB.11:0']},
	{ f: ['PB.12:0', 'EADC0_CH12:1', 'SPI0_MOSI:4', 'USCI0_CLK:5', 'UART0_RXD:6', 'UART3_nCTS:7', 'CAN0_RXD:9', 'TM3_EXT:13']},
	{ f: ['PB.13:0', 'EADC0_CH13:1', 'SPI0_MISO:4', 'USCI0_DAT0:5', 'UART0_TXD:6', 'UART3_nRTS:7', 'CAN0_TXD:9', 'TM2_EXT:13']},
	{ f: ['PB.14:0', 'EADC0_CH14:1', 'SPI0_CLK:4', 'USCI0_DAT1:5', 'UART0_nRTS:6', 'UART3_RXD:7', 'TM1_EXT:13', 'CLKO:14']},
	{ f: ['PB.15:0', 'EADC0_CH15:1', 'SPI0_SS:4', 'USCI0_CTL1:5', 'UART0_nCTS:6', 'UART3_TXD:7', 'TM0_EXT:13']},

	{ f: ['PC.0:0', 'UART2_RXD:8', 'I2C0_SDA:9']},
	{ f: ['PC.1:0', 'UART2_TXD:8', 'I2C0_SCL:9']},
	{ f: ['PC.2:0', 'UART2_nCTS:8', 'UART3_RXD:11']},
	{ f: ['PC.3:0', 'UART2_nRTS:8', 'UART3_TXD:11']},
	{ f: ['PC.4:0', 'UART2_RXD:8', 'I2C1_SDA:9', 'CAN0_RXD:10', 'UART4_RXD:11']},
	{ f: ['PC.5:0', 'UART2_TXD:8', 'I2C1_SCL:9', 'CAN0_TXD:10', 'UART4_TXD:11']},
	{ f: ['PC.6:0']},
	{ f: ['PC.7:0']},
	{ f: ['PC.8:0']},
	{ f: ['PC.9:0']},
	{ f: ['PC.10:0']},
	{ f: ['PC.11:0']},
	{ f: ['PC.12:0']},
	{ f: ['PC.13:0']},
	{ f: ['PC.14:0', 'SPI0_I2SMCLK:4', 'USCI0_CTL0:5', 'TM1:13']},
	{ f: ['PC.15:0']},

	{ f: ['PD.0:0']},
	{ f: ['PD.1:0']},
	{ f: ['PD.2:0']},
	{ f: ['PD.3:0']},
	{ f: ['PD.4:0']},
	{ f: ['PD.5:0']},
	{ f: ['PD.6:0']},
	{ f: ['PD.7:0']},
	{ f: ['PD.8:0']},
	{ f: ['PD.9:0']},
	{ f: ['PD.10:0']},
	{ f: ['PD.11:0']},
	{ f: ['PD.12:0']},
	{ f: ['PD.13:0']},
	{ f: ['PD.14:0']},
	{ f: ['PD.15:0']},

	{ f: ['PE.0:0']},
	{ f: ['PE.1:0']},
	{ f: ['PE.2:0']},
	{ f: ['PE.3:0']},
	{ f: ['PE.4:0']},
	{ f: ['PE.5:0']},
	{ f: ['PE.6:0']},
	{ f: ['PE.7:0']},
	{ f: ['PE.8:0']},
	{ f: ['PE.9:0']},
	{ f: ['PE.10:0']},
	{ f: ['PE.11:0']},
	{ f: ['PE.12:0']},
	{ f: ['PE.13:0']},
	{ f: ['PE.14:0']},
	{ f: ['PE.15:0']},

	{ f: ['PF.0:0', 'UART1_TXD:2', 'I2C1_SCL:3', 'UART0_TXD:4', 'ICE_DAT:14']},
	{ f: ['PF.1:0', 'UART1_RXD:2', 'I2C1_SDA:3', 'UART0_RXD:4', 'ICE_CLK:14']},
	{ f: ['PF.2:0', 'UART0_RXD:3', 'I2C0_SDA:4', 'XT1_OUT:10']},
	{ f: ['PF.3:0', 'UART0_TXD:3', 'I2C0_SCL:4', 'XT1_IN:10']},
	{ f: ['PF.4:0', 'UART2_TXD:2', 'UART2_nRTS:4', 'BPWM0_CH5:8', 'X32_OUT:10']},
	{ f: ['PF.5:0', 'UART2_RXD:2', 'UART2_nCTS:4', 'BPWM0_CH4:8', 'X32_IN:10', 'EADC0_ST:11']},
	{ f: ['PF.6:0']},
	{ f: ['PF.7:0']},
	{ f: ['PF.8:0']},
	{ f: ['PF.9:0']},
	{ f: ['PF.10:0']},
	{ f: ['PF.11:0']},
	{ f: ['PF.12:0']},
	{ f: ['PF.13:0']},
	{ f: ['PF.14:0']},
	{ f: ['PF.15:0', 'TM2:13', 'CLKO:14', 'INT4:15']}
];

NUTOOL_PIN.g_cfg_gpiosDefines = [
	{ f: ['PA.0', 'GPIO:SYS_GPA_MFPL_PA0MFP_GPIO@GPA_MFPL', 'SPI0_MOSI:SYS_GPA_MFPL_PA0MFP_SPI0_MOSI@GPA_MFPL', 'UART0_RXD:SYS_GPA_MFPL_PA0MFP_UART0_RXD@GPA_MFPL', 'UART1_nRTS:SYS_GPA_MFPL_PA0MFP_UART1_nRTS@GPA_MFPL', 'BPWM0_CH0:SYS_GPA_MFPL_PA0MFP_BPWM0_CH0@GPA_MFPL'] },
	{ f: ['PA.1', 'GPIO:SYS_GPA_MFPL_PA1MFP_GPIO@GPA_MFPL', 'SPI0_MISO:SYS_GPA_MFPL_PA1MFP_SPI0_MISO@GPA_MFPL', 'UART0_TXD:SYS_GPA_MFPL_PA1MFP_UART0_TXD@GPA_MFPL', 'UART1_nCTS:SYS_GPA_MFPL_PA1MFP_UART1_nCTS@GPA_MFPL', 'BPWM0_CH1:SYS_GPA_MFPL_PA1MFP_BPWM0_CH1@GPA_MFPL'] },
	{ f: ['PA.2', 'GPIO:SYS_GPA_MFPL_PA2MFP_GPIO@GPA_MFPL', 'UART4_RXD:SYS_GPA_MFPL_PA2MFP_UART4_RXD@GPA_MFPL', 'SPI0_CLK:SYS_GPA_MFPL_PA2MFP_SPI0_CLK@GPA_MFPL', 'UART1_RXD:SYS_GPA_MFPL_PA2MFP_UART1_RXD@GPA_MFPL', 'I2C1_SDA:SYS_GPA_MFPL_PA2MFP_I2C1_SDA@GPA_MFPL', 'BPWM0_CH2:SYS_GPA_MFPL_PA2MFP_BPWM0_CH2@GPA_MFPL'] },
	{ f: ['PA.3', 'GPIO:SYS_GPA_MFPL_PA3MFP_GPIO@GPA_MFPL', 'UART4_TXD:SYS_GPA_MFPL_PA3MFP_UART4_TXD@GPA_MFPL', 'SPI0_SS:SYS_GPA_MFPL_PA3MFP_SPI0_SS@GPA_MFPL', 'UART1_TXD:SYS_GPA_MFPL_PA3MFP_UART1_TXD@GPA_MFPL', 'I2C1_SCL:SYS_GPA_MFPL_PA3MFP_I2C1_SCL@GPA_MFPL', 'BPWM0_CH3:SYS_GPA_MFPL_PA3MFP_BPWM0_CH3@GPA_MFPL', 'CLKO:SYS_GPA_MFPL_PA3MFP_CLKO@GPA_MFPL'] },
	{ f: ['PA.4', 'GPIO:SYS_GPA_MFPL_PA4MFP_GPIO@GPA_MFPL', 'CAN0_RXD:SYS_GPA_MFPL_PA4MFP_CAN0_RXD@GPA_MFPL', 'SPI0_I2SMCLK:SYS_GPA_MFPL_PA4MFP_SPI0_I2SMCLK@GPA_MFPL', 'UART0_nRTS:SYS_GPA_MFPL_PA4MFP_UART0_nRTS@GPA_MFPL', 'UART0_RXD:SYS_GPA_MFPL_PA4MFP_UART0_RXD@GPA_MFPL', 'I2C0_SDA:SYS_GPA_MFPL_PA4MFP_I2C0_SDA@GPA_MFPL', 'BPWM0_CH4:SYS_GPA_MFPL_PA4MFP_BPWM0_CH4@GPA_MFPL'] },
	{ f: ['PA.5', 'GPIO:SYS_GPA_MFPL_PA5MFP_GPIO@GPA_MFPL', 'CAN0_TXD:SYS_GPA_MFPL_PA5MFP_CAN0_TXD@GPA_MFPL', 'UART0_nCTS:SYS_GPA_MFPL_PA5MFP_UART0_nCTS@GPA_MFPL', 'UART0_TXD:SYS_GPA_MFPL_PA5MFP_UART0_TXD@GPA_MFPL', 'I2C0_SCL:SYS_GPA_MFPL_PA5MFP_I2C0_SCL@GPA_MFPL', 'BPWM0_CH5:SYS_GPA_MFPL_PA5MFP_BPWM0_CH5@GPA_MFPL'] },
	{ f: ['PA.6', 'GPIO:SYS_GPA_MFPL_PA6MFP_GPIO@GPA_MFPL', 'UART0_RXD:SYS_GPA_MFPL_PA6MFP_UART0_RXD@GPA_MFPL', 'I2C1_SDA:SYS_GPA_MFPL_PA6MFP_I2C1_SDA@GPA_MFPL', 'TM3:SYS_GPA_MFPL_PA6MFP_TM3@GPA_MFPL', 'INT0:SYS_GPA_MFPL_PA6MFP_INT0@GPA_MFPL'] },
	{ f: ['PA.7', 'GPIO:SYS_GPA_MFPL_PA7MFP_GPIO@GPA_MFPL', 'UART0_TXD:SYS_GPA_MFPL_PA7MFP_UART0_TXD@GPA_MFPL', 'I2C1_SCL:SYS_GPA_MFPL_PA7MFP_I2C1_SCL@GPA_MFPL', 'TM2:SYS_GPA_MFPL_PA7MFP_TM2@GPA_MFPL', 'INT1:SYS_GPA_MFPL_PA7MFP_INT1@GPA_MFPL'] },
	{ f: ['PA.8', 'GPIO:SYS_GPA_MFPH_PA8MFP_GPIO@GPA_MFPH', 'USCI0_CTL1:SYS_GPA_MFPH_PA8MFP_USCI0_CTL1@GPA_MFPH', 'UART1_RXD:SYS_GPA_MFPH_PA8MFP_UART1_RXD@GPA_MFPH', 'BPWM0_CH3:SYS_GPA_MFPH_PA8MFP_BPWM0_CH3@GPA_MFPH', 'TM3_EXT:SYS_GPA_MFPH_PA8MFP_TM3_EXT@GPA_MFPH', 'INT4:SYS_GPA_MFPH_PA8MFP_INT4@GPA_MFPH'] },
	{ f: ['PA.9', 'GPIO:SYS_GPA_MFPH_PA9MFP_GPIO@GPA_MFPH', 'USCI0_DAT1:SYS_GPA_MFPH_PA9MFP_USCI0_DAT1@GPA_MFPH', 'UART1_TXD:SYS_GPA_MFPH_PA9MFP_UART1_TXD@GPA_MFPH', 'BPWM0_CH2:SYS_GPA_MFPH_PA9MFP_BPWM0_CH2@GPA_MFPH', 'TM2_EXT:SYS_GPA_MFPH_PA9MFP_TM2_EXT@GPA_MFPH'] },
	{ f: ['PA.10', 'GPIO:SYS_GPA_MFPH_PA10MFP_GPIO@GPA_MFPH', 'USCI0_DAT0:SYS_GPA_MFPH_PA10MFP_USCI0_DAT0@GPA_MFPH', 'BPWM0_CH1:SYS_GPA_MFPH_PA10MFP_BPWM0_CH1@GPA_MFPH', 'TM1_EXT:SYS_GPA_MFPH_PA10MFP_TM1_EXT@GPA_MFPH'] },
	{ f: ['PA.11', 'GPIO:SYS_GPA_MFPH_PA11MFP_GPIO@GPA_MFPH', 'USCI0_CLK:SYS_GPA_MFPH_PA11MFP_USCI0_CLK@GPA_MFPH', 'BPWM0_CH0:SYS_GPA_MFPH_PA11MFP_BPWM0_CH0@GPA_MFPH', 'TM0_EXT:SYS_GPA_MFPH_PA11MFP_TM0_EXT@GPA_MFPH'] },

	{ f: ['PB.0', 'GPIO:SYS_GPB_MFPL_PB0MFP_GPIO@GPB_MFPL', 'EADC0_CH0:SYS_GPB_MFPL_PB0MFP_EADC0_CH0@GPB_MFPL', 'UART2_RXD:SYS_GPB_MFPL_PB0MFP_UART2_RXD@GPB_MFPL', 'SPI0_I2SMCLK:SYS_GPB_MFPL_PB0MFP_SPI0_I2SMCLK@GPB_MFPL', 'I2C1_SDA:SYS_GPB_MFPL_PB0MFP_I2C1_SDA@GPB_MFPL'] },
	{ f: ['PB.1', 'GPIO:SYS_GPB_MFPL_PB1MFP_GPIO@GPB_MFPL', 'EADC0_CH1:SYS_GPB_MFPL_PB1MFP_EADC0_CH1@GPB_MFPL', 'UART2_TXD:SYS_GPB_MFPL_PB1MFP_UART2_TXD@GPB_MFPL', 'I2C1_SCL:SYS_GPB_MFPL_PB1MFP_I2C1_SCL@GPB_MFPL'] },
	{ f: ['PB.2', 'GPIO:SYS_GPB_MFPL_PB2MFP_GPIO@GPB_MFPL', 'EADC0_CH2:SYS_GPB_MFPL_PB2MFP_EADC0_CH2@GPB_MFPL', 'I2C1_SDA:SYS_GPB_MFPL_PB2MFP_I2C1_SDA@GPB_MFPL', 'UART1_RXD:SYS_GPB_MFPL_PB2MFP_UART1_RXD@GPB_MFPL', 'TM3:SYS_GPB_MFPL_PB2MFP_TM3@GPB_MFPL', 'INT3:SYS_GPB_MFPL_PB2MFP_INT3@GPB_MFPL'] },
	{ f: ['PB.3', 'GPIO:SYS_GPB_MFPL_PB3MFP_GPIO@GPB_MFPL', 'EADC0_CH3:SYS_GPB_MFPL_PB3MFP_EADC0_CH3@GPB_MFPL', 'I2C1_SCL:SYS_GPB_MFPL_PB3MFP_I2C1_SCL@GPB_MFPL', 'UART1_TXD:SYS_GPB_MFPL_PB3MFP_UART1_TXD@GPB_MFPL', 'TM2:SYS_GPB_MFPL_PB3MFP_TM2@GPB_MFPL', 'INT2:SYS_GPB_MFPL_PB3MFP_INT2@GPB_MFPL'] },
	{ f: ['PB.4', 'GPIO:SYS_GPB_MFPL_PB4MFP_GPIO@GPB_MFPL', 'EADC0_CH4:SYS_GPB_MFPL_PB4MFP_EADC0_CH4@GPB_MFPL', 'I2C0_SDA:SYS_GPB_MFPL_PB4MFP_I2C0_SDA@GPB_MFPL', 'UART2_RXD:SYS_GPB_MFPL_PB4MFP_UART2_RXD@GPB_MFPL', 'TM1:SYS_GPB_MFPL_PB4MFP_TM1@GPB_MFPL', 'INT1:SYS_GPB_MFPL_PB4MFP_INT1@GPB_MFPL'] },
	{ f: ['PB.5', 'GPIO:SYS_GPB_MFPL_PB5MFP_GPIO@GPB_MFPL', 'EADC0_CH5:SYS_GPB_MFPL_PB5MFP_EADC0_CH5@GPB_MFPL', 'I2C0_SCL:SYS_GPB_MFPL_PB5MFP_I2C0_SCL@GPB_MFPL', 'UART2_TXD:SYS_GPB_MFPL_PB5MFP_UART2_TXD@GPB_MFPL', 'TM0:SYS_GPB_MFPL_PB5MFP_TM0@GPB_MFPL', 'INT0:SYS_GPB_MFPL_PB5MFP_INT0@GPB_MFPL'] },
	{ f: ['PB.6', 'GPIO:SYS_GPB_MFPL_PB6MFP_GPIO@GPB_MFPL', 'EADC0_CH6:SYS_GPB_MFPL_PB6MFP_EADC0_CH6@GPB_MFPL', 'UART1_RXD:SYS_GPB_MFPL_PB6MFP_UART1_RXD@GPB_MFPL', 'INT4:SYS_GPB_MFPL_PB6MFP_INT4@GPB_MFPL'] },
	{ f: ['PB.7', 'GPIO:SYS_GPB_MFPL_PB7MFP_GPIO@GPB_MFPL', 'EADC0_CH7:SYS_GPB_MFPL_PB7MFP_EADC0_CH7@GPB_MFPL', 'UART1_TXD:SYS_GPB_MFPL_PB7MFP_UART1_TXD@GPB_MFPL', 'INT5:SYS_GPB_MFPL_PB7MFP_INT5@GPB_MFPL'] },
	{ f: ['PB.12', 'GPIO:SYS_GPB_MFPH_PB12MFP_GPIO@GPB_MFPH', 'EADC0_CH12:SYS_GPB_MFPH_PB12MFP_EADC0_CH12@GPB_MFPH', 'SPI0_MOSI:SYS_GPB_MFPH_PB12MFP_SPI0_MOSI@GPB_MFPH', 'USCI0_CLK:SYS_GPB_MFPH_PB12MFP_USCI0_CLK@GPB_MFPH', 'UART0_RXD:SYS_GPB_MFPH_PB12MFP_UART0_RXD@GPB_MFPH', 'UART3_nCTS:SYS_GPB_MFPH_PB12MFP_UART3_nCTS@GPB_MFPH', 'CAN0_RXD:SYS_GPB_MFPH_PB12MFP_CAN0_RXD@GPB_MFPH', 'TM3_EXT:SYS_GPB_MFPH_PB12MFP_TM3_EXT@GPB_MFPH'] },
	{ f: ['PB.13', 'GPIO:SYS_GPB_MFPH_PB13MFP_GPIO@GPB_MFPH', 'EADC0_CH13:SYS_GPB_MFPH_PB13MFP_EADC0_CH13@GPB_MFPH', 'SPI0_MISO:SYS_GPB_MFPH_PB13MFP_SPI0_MISO@GPB_MFPH', 'USCI0_DAT0:SYS_GPB_MFPH_PB13MFP_USCI0_DAT0@GPB_MFPH', 'UART0_TXD:SYS_GPB_MFPH_PB13MFP_UART0_TXD@GPB_MFPH', 'UART3_nRTS:SYS_GPB_MFPH_PB13MFP_UART3_nRTS@GPB_MFPH', 'CAN0_TXD:SYS_GPB_MFPH_PB13MFP_CAN0_TXD@GPB_MFPH', 'TM2_EXT:SYS_GPB_MFPH_PB13MFP_TM2_EXT@GPB_MFPH'] },
	{ f: ['PB.14', 'GPIO:SYS_GPB_MFPH_PB14MFP_GPIO@GPB_MFPH', 'EADC0_CH14:SYS_GPB_MFPH_PB14MFP_EADC0_CH14@GPB_MFPH', 'SPI0_CLK:SYS_GPB_MFPH_PB14MFP_SPI0_CLK@GPB_MFPH', 'USCI0_DAT1:SYS_GPB_MFPH_PB14MFP_USCI0_DAT1@GPB_MFPH', 'UART0_nRTS:SYS_GPB_MFPH_PB14MFP_UART0_nRTS@GPB_MFPH', 'UART3_RXD:SYS_GPB_MFPH_PB14MFP_UART3_RXD@GPB_MFPH', 'TM1_EXT:SYS_GPB_MFPH_PB14MFP_TM1_EXT@GPB_MFPH', 'CLKO:SYS_GPB_MFPH_PB14MFP_CLKO@GPB_MFPH'] },
	{ f: ['PB.15', 'GPIO:SYS_GPB_MFPH_PB15MFP_GPIO@GPB_MFPH', 'EADC0_CH15:SYS_GPB_MFPH_PB15MFP_EADC0_CH15@GPB_MFPH', 'SPI0_SS:SYS_GPB_MFPH_PB15MFP_SPI0_SS@GPB_MFPH', 'USCI0_CTL1:SYS_GPB_MFPH_PB15MFP_USCI0_CTL1@GPB_MFPH', 'UART0_nCTS:SYS_GPB_MFPH_PB15MFP_UART0_nCTS@GPB_MFPH', 'UART3_TXD:SYS_GPB_MFPH_PB15MFP_UART3_TXD@GPB_MFPH', 'TM0_EXT:SYS_GPB_MFPH_PB15MFP_TM0_EXT@GPB_MFPH'] },

	{ f: ['PC.0', 'GPIO:SYS_GPC_MFPL_PC0MFP_GPIO@GPC_MFPL', 'UART2_RXD:SYS_GPC_MFPL_PC0MFP_UART2_RXD@GPC_MFPL', 'I2C0_SDA:SYS_GPC_MFPL_PC0MFP_I2C0_SDA@GPC_MFPL'] },
	{ f: ['PC.1', 'GPIO:SYS_GPC_MFPL_PC1MFP_GPIO@GPC_MFPL', 'UART2_TXD:SYS_GPC_MFPL_PC1MFP_UART2_TXD@GPC_MFPL', 'I2C0_SCL:SYS_GPC_MFPL_PC1MFP_I2C0_SCL@GPC_MFPL'] },
	{ f: ['PC.2', 'GPIO:SYS_GPC_MFPL_PC2MFP_GPIO@GPC_MFPL', 'UART2_nCTS:SYS_GPC_MFPL_PC2MFP_UART2_nCTS@GPC_MFPL', 'UART3_RXD:SYS_GPC_MFPL_PC2MFP_UART3_RXD@GPC_MFPL'] },
	{ f: ['PC.3', 'GPIO:SYS_GPC_MFPL_PC3MFP_GPIO@GPC_MFPL', 'UART2_nRTS:SYS_GPC_MFPL_PC3MFP_UART2_nRTS@GPC_MFPL', 'UART3_TXD:SYS_GPC_MFPL_PC3MFP_UART3_TXD@GPC_MFPL'] },
	{ f: ['PC.4', 'GPIO:SYS_GPC_MFPL_PC4MFP_GPIO@GPC_MFPL', 'UART2_RXD:SYS_GPC_MFPL_PC4MFP_UART2_RXD@GPC_MFPL', 'I2C1_SDA:SYS_GPC_MFPL_PC4MFP_I2C1_SDA@GPC_MFPL', 'CAN0_RXD:SYS_GPC_MFPL_PC4MFP_CAN0_RXD@GPC_MFPL', 'UART4_RXD:SYS_GPC_MFPL_PC4MFP_UART4_RXD@GPC_MFPL'] },
	{ f: ['PC.5', 'GPIO:SYS_GPC_MFPL_PC5MFP_GPIO@GPC_MFPL', 'UART2_TXD:SYS_GPC_MFPL_PC5MFP_UART2_TXD@GPC_MFPL', 'I2C1_SCL:SYS_GPC_MFPL_PC5MFP_I2C1_SCL@GPC_MFPL', 'CAN0_TXD:SYS_GPC_MFPL_PC5MFP_CAN0_TXD@GPC_MFPL', 'UART4_TXD:SYS_GPC_MFPL_PC5MFP_UART4_TXD@GPC_MFPL'] },
	{ f: ['PC.14', 'GPIO:SYS_GPC_MFPH_PC14MFP_GPIO@GPC_MFPH', 'SPI0_I2SMCLK:SYS_GPC_MFPH_PC14MFP_SPI0_I2SMCLK@GPC_MFPH', 'USCI0_CTL0:SYS_GPC_MFPH_PC14MFP_USCI0_CTL0@GPC_MFPH', 'TM1:SYS_GPC_MFPH_PC14MFP_TM1@GPC_MFPH'] },

	{ f: ['PF.0', 'GPIO:SYS_GPF_MFPL_PF0MFP_GPIO@GPF_MFPL', 'UART1_TXD:SYS_GPF_MFPL_PF0MFP_UART1_TXD@GPF_MFPL', 'I2C1_SCL:SYS_GPF_MFPL_PF0MFP_I2C1_SCL@GPF_MFPL', 'UART0_TXD:SYS_GPF_MFPL_PF0MFP_UART0_TXD@GPF_MFPL', 'ICE_DAT:SYS_GPF_MFPL_PF0MFP_ICE_DAT@GPF_MFPL'] },
	{ f: ['PF.1', 'GPIO:SYS_GPF_MFPL_PF1MFP_GPIO@GPF_MFPL', 'UART1_RXD:SYS_GPF_MFPL_PF1MFP_UART1_RXD@GPF_MFPL', 'I2C1_SDA:SYS_GPF_MFPL_PF1MFP_I2C1_SDA@GPF_MFPL', 'UART0_RXD:SYS_GPF_MFPL_PF1MFP_UART0_RXD@GPF_MFPL', 'ICE_CLK:SYS_GPF_MFPL_PF1MFP_ICE_CLK@GPF_MFPL'] },
	{ f: ['PF.2', 'GPIO:SYS_GPF_MFPL_PF2MFP_GPIO@GPF_MFPL', 'UART0_RXD:SYS_GPF_MFPL_PF2MFP_UART0_RXD@GPF_MFPL', 'I2C0_SDA:SYS_GPF_MFPL_PF2MFP_I2C0_SDA@GPF_MFPL', 'XT1_OUT:SYS_GPF_MFPL_PF2MFP_XT1_OUT@GPF_MFPL'] },
	{ f: ['PF.3', 'GPIO:SYS_GPF_MFPL_PF3MFP_GPIO@GPF_MFPL', 'UART0_TXD:SYS_GPF_MFPL_PF3MFP_UART0_TXD@GPF_MFPL', 'I2C0_SCL:SYS_GPF_MFPL_PF3MFP_I2C0_SCL@GPF_MFPL', 'XT1_IN:SYS_GPF_MFPL_PF3MFP_XT1_IN@GPF_MFPL'] },
	{ f: ['PF.4', 'GPIO:SYS_GPF_MFPL_PF4MFP_GPIO@GPF_MFPL', 'UART2_TXD:SYS_GPF_MFPL_PF4MFP_UART2_TXD@GPF_MFPL', 'UART2_nRTS:SYS_GPF_MFPL_PF4MFP_UART2_nRTS@GPF_MFPL', 'BPWM0_CH5:SYS_GPF_MFPL_PF4MFP_BPWM0_CH5@GPF_MFPL', 'X32_OUT:SYS_GPF_MFPL_PF4MFP_X32_OUT@GPF_MFPL'] },
	{ f: ['PF.5', 'GPIO:SYS_GPF_MFPL_PF5MFP_GPIO@GPF_MFPL', 'UART2_RXD:SYS_GPF_MFPL_PF5MFP_UART2_RXD@GPF_MFPL', 'UART2_nCTS:SYS_GPF_MFPL_PF5MFP_UART2_nCTS@GPF_MFPL', 'BPWM0_CH4:SYS_GPF_MFPL_PF5MFP_BPWM0_CH4@GPF_MFPL', 'X32_IN:SYS_GPF_MFPL_PF5MFP_X32_IN@GPF_MFPL', 'EADC0_ST:SYS_GPF_MFPL_PF5MFP_EADC0_ST@GPF_MFPL'] },
	{ f: ['PF.15', 'GPIO:SYS_GPF_MFPH_PF15MFP_GPIO@GPF_MFPH', 'TM2:SYS_GPF_MFPH_PF15MFP_TM2@GPF_MFPH', 'CLKO:SYS_GPF_MFPH_PF15MFP_CLKO@GPF_MFPH', 'INT4:SYS_GPF_MFPH_PF15MFP_INT4@GPF_MFPH'] }
];

NUTOOL_PIN.g_cfg_gpiosDescriptions = [
	'BPWM0_CH0:BPWM0 channel 0 output/capture input',
	'BPWM0_CH1:BPWM0 channel 1 output/capture input',
	'BPWM0_CH2:BPWM0 channel 2 output/capture input',
	'BPWM0_CH3:BPWM0 channel 3 output/capture input',
	'BPWM0_CH4:BPWM0 channel 4 output/capture input',
	'BPWM0_CH5:BPWM0 channel 5 output/capture input',
	'CAN0_RXD:CAN0 bus receiver input',
	'CAN0_TXD:CAN0 bus transmitter output',
	'CLKO:Clock Out',
	'EADC0_CH0:EADC0 channel 0 analog input',
	'EADC0_CH1:EADC0 channel 1 analog input',
	'EADC0_CH2:EADC0 channel 2 analog input',
	'EADC0_CH3:EADC0 channel 3 analog input',
	'EADC0_CH4:EADC0 channel 4 analog input',
	'EADC0_CH5:EADC0 channel 5 analog input',
	'EADC0_CH6:EADC0 channel 6 analog input',
	'EADC0_CH7:EADC0 channel 7 analog input',
	'EADC0_CH12:EADC0 channel 12 analog input',
	'EADC0_CH13:EADC0 channel 13 analog input',
	'EADC0_CH14:EADC0 channel 14 analog input',
	'EADC0_CH15:EADC0 channel 15 analog input',
	'EADC0_ST:EADC0 external trigger input',
	'I2C0_SCL:I2C0 clock pin',
	'I2C0_SDA:I2C0 data input/output pin',
	'I2C1_SCL:I2C1 clock pin',
	'I2C1_SDA:I2C1 data input/output pin',
	'ICE_CLK:Serial wired debugger clock pin',
	'ICE_DAT:Serial wired debugger data pin',
	'INT0:External interrupt 0 input pin',
	'INT1:External interrupt 1 input pin',
	'INT2:External interrupt 2 input pin',
	'INT3:External interrupt 3 input pin',
	'INT4:External interrupt 4 input pin',
	'INT5:External interrupt 5 input pin',
	'SPI0_CLK:SPI0 serial clock pin',
	'SPI0_I2SMCLK:SPI0 I2S master clock output pin',
	'SPI0_MISO:SPI0 MISO (Master In, Slave Out) pin',
	'SPI0_MOSI:SPI0 MOSI (Master Out, Slave In) pin',
	'SPI0_SS:SPI0 slave select  pin',
	'TM0:Timer0 event counter input/toggle output pin',
	'TM0_EXT:Timer0 external capture input/toggle output pin',
	'TM1:Timer1 event counter input/toggle output pin',
	'TM1_EXT:Timer1 external capture input/toggle output pin',
	'TM2:Timer2 event counter input/toggle output pin',
	'TM2_EXT:Timer2 external capture input/toggle output pin',
	'TM3:Timer3 event counter input/toggle output pin',
	'TM3_EXT:Timer3 external capture input/toggle output pin',
	'UART0_nCTS:UART0 clear to Send input pin',
	'UART0_nRTS:UART0 request to Send output pin',
	'UART0_RXD:UART0 data receiver input pin',
	'UART0_TXD:UART0 data transmitter output pin',
	'UART1_nCTS:UART1 clear to Send input pin',
	'UART1_nRTS:UART1 request to Send output pin',
	'UART1_RXD:UART1 data receiver input pin',
	'UART1_TXD:UART1 data transmitter output pin',
	'UART2_nCTS:UART2 clear to Send input pin',
	'UART2_nRTS:UART2 request to Send output pin',
	'UART2_RXD:UART2 data receiver input pin',
	'UART2_TXD:UART2 data transmitter output pin',
	'UART3_nCTS:UART3 clear to Send input pin',
	'UART3_nRTS:UART3 request to Send output pin',
	'UART3_RXD:UART3 data receiver input pin',
	'UART3_TXD:UART3 data transmitter output pin',
	'UART4_RXD:UART4 data receiver input pin',
	'UART4_TXD:UART4 data transmitter output pin',
	'USCI0_CLK:USCI0 clock pin',
	'USCI0_CTL0:USCI0 control 0 pin',
	'USCI0_CTL1:USCI0 control 1 pin',
	'USCI0_DAT0:USCI0 data 0 pin',
	'USCI0_DAT1:USCI0 data 1 pin',
	'X32_IN:External 32.768 kHz crystal input pin',
	'X32_OUT:External 32.768 kHz crystal output pin',
	'XT1_IN:External 4~24 MHz (high speed) crystal input pin',
	'XT1_OUT:External 4~24 MHz (high speed) crystal output pin.'
];

NUTOOL_PIN.g_cfg_regDescriptions = {};
NUTOOL_PIN.g_cfg_regDescriptions.GPA_MFPL = '0x40000030';
NUTOOL_PIN.g_cfg_regDescriptions.GPA_MFPH = '0x40000034';
NUTOOL_PIN.g_cfg_regDescriptions.GPB_MFPL = '0x40000038';
NUTOOL_PIN.g_cfg_regDescriptions.GPB_MFPH = '0x4000003C';
NUTOOL_PIN.g_cfg_regDescriptions.GPC_MFPL = '0x40000040';
NUTOOL_PIN.g_cfg_regDescriptions.GPC_MFPH = '0x40000044';
NUTOOL_PIN.g_cfg_regDescriptions.GPD_MFPL = '0x40000048';
NUTOOL_PIN.g_cfg_regDescriptions.GPD_MFPH = '0x4000004C';
NUTOOL_PIN.g_cfg_regDescriptions.GPE_MFPL = '0x40000050';
NUTOOL_PIN.g_cfg_regDescriptions.GPE_MFPH = '0x40000054';
NUTOOL_PIN.g_cfg_regDescriptions.GPF_MFPL = '0x40000058';
NUTOOL_PIN.g_cfg_regDescriptions.GPF_MFPH = '0x4000005C';

NUTOOL_PIN.g_cfg_gpioMatrix = [];
NUTOOL_PIN.g_cfg_shareBits = [];
NUTOOL_PIN.g_cfg_addGPIO = {};
NUTOOL_PIN.g_cfg_unusedGPIO = {};

NUTOOL_PIN.decidepackageNumber = function (given_partNumber_package) {
	var partNumber_package,
		partNumber;

	if (typeof given_partNumber_package === 'undefined') {
		partNumber_package = NUTOOL_PIN.getg_partNumber_package();
	}
	else {
		partNumber_package = given_partNumber_package;
	}

	NUTOOL_PIN.g_packageNumber = partNumber_package.substring(partNumber_package.indexOf('(') + 1);
	NUTOOL_PIN.g_packageNumber = NUTOOL_PIN.g_packageNumber.substring(0, NUTOOL_PIN.g_packageNumber.indexOf(')'));

	partNumber = partNumber_package.substring(0, partNumber_package.indexOf('('));
	switch (NUTOOL_PIN.g_packageNumber) {
	default:
		break;
	case 'QFN33':
		NUTOOL_PIN.g_packageNumberIndex = "UQFN33";
		break;
	case 'LQFP48':
		NUTOOL_PIN.g_packageNumberIndex = "ULQFP48";
		break;
	}
	partNumber_package = null;
	partNumber = null;
};
