// chip content
NUTOOL_PIN.g_cfg_chips = [
	// M471
	{ name: "M471LG7AE", pkg: "LQFP48" },
	{ name: "M471SG7AE", pkg: "LQFP64" },
	{ name: "M471SI8AE", pkg: "LQFP64" },
	{ name: "M471QG7AE", pkg: "LQFP80" },
	{ name: "M471QI8AE", pkg: "LQFP80" },
	{ name: "M471VG7AE", pkg: "LQFP100" },
	{ name: "M471VI8AE", pkg: "LQFP100" },
	{ name: "M471KI8AE", pkg: "LQFP128" }
];

NUTOOL_PIN.g_cfg_pkgs = {
	"LQFP48": [
		'PB.5', 'PB.4', 'PB.3', 'PB.2', 'PB.1', 'PB.0', 'PA.11', 'PA.10', 'PA.9', 'PA.8',
		'PF.5', 'PF.4',
		'PF.3', 'PF.2', 'PA.7', 'PA.6', 'PA.5', 'PA.4', 'PA.3', 'PA.2', 'PA.1', 'PA.0',
		'PF.15', 'nRESET',
		'PF.0', 'PF.1', 'PC.5', 'PC.4', 'PC.3', 'PC.2', 'PC.1', 'PC.0', 'PA.12', 'PA.13',
		'PA.14', 'PA.15',
		'VSS', 'LDO_CAP', 'VDD', 'PC.14', 'PB.15', 'PB.14', 'PB.13', 'PB.12', 'AVDD', 'AVSS',
		'PB.7', 'PB.6'
	],
	"LQFP64": [
		'PB.6', 'PB.5', 'PB.4', 'PB.3', 'PB.2', 'PB.1', 'PB.0', 'PA.11', 'PA.10', 'PA.9',
		'PA.8', 'PF.6', 'PF.14', 'PF.5', 'PF.4', 'PF.3',
		'PF.2', 'PC.7', 'PC.6', 'PA.7', 'PA.6', 'PF.12', 'PF.13', 'PD.15', 'PA.5', 'PA.4',
		'PA.3', 'PA.2', 'PA.1', 'PA.0', 'PF.15', 'nRESET',
		'PF.0', 'PF.1', 'PC.5', 'PC.4', 'PC.3', 'PC.2', 'PC.1', 'PC.0', 'PD.3', 'PD.2',
		'PD.1', 'PD.0', 'PA.12', 'PA.13', 'PA.14', 'PA.15',
		'VSS', 'LDO_CAP', 'VDD', 'PC.14', 'PB.15', 'PB.14', 'PB.13', 'PB.12', 'AVDD', 'VREF',
		'AVSS', 'PB.11', 'PB.10', 'PB.9', 'PB.8', 'PB.7'
	],
	"LQFP80": [
		'PB.5', 'PB.4', 'PB.3', 'PB.2', 'PB.1', 'PB.0', 'PA.11', 'PA.10', 'PA.9', 'PA.8',
		'PD.12', 'PD.11', 'PD.10', 'PF.8', 'PF.7', 'PF.6', 'PF.14', 'PF.5', 'PF.4', 'PF.3',
		'PF.2', 'VSS', 'VDD', 'PE.13', 'PC.8', 'PC.7', 'PC.6', 'PA.7', 'PA.6', 'PF.12',
		'PF.13', 'PD.15', 'PA.5', 'PA.4', 'PA.3', 'PA.2', 'PA.1', 'PA.0', 'PF.15', 'nRESET',
		'PF.0', 'PF.1', 'PC.5', 'PC.4', 'PC.3', 'PC.2', 'PC.1', 'PC.0', 'PD.7', 'PD.6',
		'PD.5', 'PD.4', 'PD.3', 'PD.2', 'PD.1', 'PD.0', 'PA.12', 'PA.13', 'PA.14', 'PA.15',
		'PE.7', 'PE.6', 'PE.4', 'VSS', 'LDO_CAP', 'VDD', 'PC.14', 'PB.15', 'PB.14', 'PB.13',
		'PB.12', 'AVDD', 'VREF', 'AVSS', 'PB.11', 'PB.10', 'PB.9', 'PB.8', 'PB.7', 'PB.6'
	],
	"LQFP100": [
		'PB.5', 'PB.4', 'PB.3', 'PB.2', 'PC.12', 'PC.11', 'PC.10', 'PB.1', 'PB.0', 'PI.0',
		'PI.1', 'PA.11', 'PA.10', 'PA.9', 'PA.8', 'PD.12', 'PD.11', 'PD.10', 'PF.8', 'PF.7',
		'PF.6', 'PF.14', 'PF.5', 'PF.4', 'PF.3',
		'PF.2', 'VSS', 'VDD', 'PE.8', 'PE.9', 'PE.12', 'PE.13', 'PC.8', 'PC.7', 'PC.6',
		'PA.7', 'PA.6', 'PF.12', 'PF.13', 'PD.15', 'PA.5', 'PA.4', 'PA.3', 'PA.2', 'PA.1',
		'PA.0', 'PF.15', 'PE.14', 'PE.15', 'nRESET',
		'PF.0', 'PF.1', 'PD.9', 'PD.8', 'PC.5', 'PC.4', 'PC.3', 'PC.2', 'PC.1', 'PC.0',
		'PI.2', 'PI.3', 'PD.7', 'PD.6', 'PD.5', 'PD.4', 'PD.3', 'PD.2', 'PD.1', 'PD.0',
		'PD.13', 'PA.12', 'PA.13', 'PA.14', 'PA.15',
		'PE.7', 'PE.6', 'PE.5', 'PE.4', 'PE.3', 'PE.2', 'PE.1', 'PE.0', 'VSS', 'LDO_CAP',
		'VDD', 'PC.14', 'PB.15', 'PB.14', 'PB.13', 'PB.12', 'AVDD', 'VREF', 'AVSS', 'PB.11',
		'PB.10', 'PB.9', 'PB.8', 'PB.7', 'PB.6'
	],
	"LQFP128": [
		'PB.5', 'PB.4', 'PB.3', 'PB.2', 'PC.12', 'PC.11', 'PC.10', 'PC.9', 'PB.1', 'PB.0',
		'PI.0', 'PI.1', 'PA.11', 'PA.10', 'PA.9', 'PA.8', 'PC.13', 'PD.12', 'PD.11', 'PD.10',
		'PG.2', 'PG.3', 'PG.4', 'PF.11', 'PF.10', 'PF.9', 'PF.8', 'PF.7', 'PF.6', 'PF.14',
		'PF.5', 'PF.4',
		'PH.4', 'PH.5', 'PH.6', 'PH.7', 'PF.3', 'PF.2', 'VSS', 'VDD', 'PE.8', 'PE.9',
		'PE.10', 'PE.11', 'PE.12', 'PE.13', 'PC.8', 'PC.7', 'PC.6', 'PA.7', 'PA.6', 'PF.12',
		'PF.13', 'PD.15', 'PA.5', 'PA.4', 'PA.3', 'PA.2', 'PA.1', 'PA.0', 'PF.15', 'PE.14',
		'PE.15', 'nRESET',
		'PF.0', 'PF.1', 'PD.9', 'PD.8', 'PC.5', 'PC.4', 'PC.3', 'PC.2', 'PC.1', 'PC.0',
		'PI.2', 'PI.3', 'PG.9', 'PG.10', 'PG.11', 'PG.12', 'PG.13', 'PG.14', 'PG.15', 'PD.7',
		'PD.6', 'PD.5', 'PD.4', 'PD.3', 'PD.2', 'PD.1', 'PD.0', 'PD.13', 'PA.12', 'PA.13',
		'PA.14', 'PA.15',
		'PE.7', 'PE.6', 'PE.5', 'PE.4', 'PE.3', 'PE.2', 'PI.4', 'PI.5', 'PE.1', 'PE.0',
		'PH.8', 'PH.9', 'PH.10', 'PH.11', 'PD.14', 'VSS', 'LDO_CAP', 'VDD', 'PC.14', 'PB.15',
		'PB.14', 'PB.13', 'PB.12', 'AVDD', 'VREF', 'AVSS', 'PB.11', 'PB.10', 'PB.9', 'PB.8',
		'PB.7', 'PB.6'
	]
};

NUTOOL_PIN.g_cfg_gpios = [
	{ f: ['PA.0:0', 'SPI0_MOSI:4', 'UART0_RXD:7', 'UART1_nRTS:8', 'BPWM0_CH0:12', 'EPWM0_CH5:13', 'DAC0_ST:15']},
	{ f: ['PA.1:0', 'SPI0_MISO:4', 'UART0_TXD:7', 'UART1_nCTS:8', 'BPWM0_CH1:12', 'EPWM0_CH4:13']},
	{ f: ['PA.2:0', 'SPI0_CLK:4', 'UART4_RXD:7', 'UART1_RXD:8', 'I2C1_SDA:9', 'I2C0_SMBSUS:10', 'BPWM0_CH2:12', 'EPWM0_CH3:13', 'CIR0_RXD:15']},
	{ f: ['PA.3:0', 'SPI0_SS:4', 'UART4_TXD:7', 'UART1_TXD:8', 'I2C1_SCL:9', 'I2C0_SMBAL:10', 'CLKO:11', 'BPWM0_CH3:12', 'EPWM0_CH2:13', 'EPWM1_BRAKE1:15']},
	{ f: ['PA.4:0', 'SPI0_I2SMCLK:4', 'UART0_nRTS:7', 'UART5_RXD:8', 'I2C0_SDA:9', 'UART0_RXD:11', 'BPWM0_CH4:12', 'EPWM0_CH1:13']},
	{ f: ['PA.5:0', 'SPI1_I2SMCLK:4', 'UART0_nCTS:7', 'UART5_TXD:8', 'I2C0_SCL:9', 'UART0_TXD:11', 'BPWM0_CH5:12', 'EPWM0_CH0:13']},
	{ f: ['PA.6:0', 'SPI1_SS:4', 'UART0_RXD:7', 'I2C1_SDA:8', 'EPWM1_CH5:11', 'BPWM1_CH3:12', 'ACMP1_WLAT:13', 'TM3:14', 'INT0:15']},
	{ f: ['PA.7:0', 'SPI1_CLK:4', 'UART0_TXD:7', 'I2C1_SCL:8', 'EPWM1_CH4:11', 'BPWM1_CH2:12', 'ACMP0_WLAT:13', 'TM2:14', 'INT1:15']},
	{ f: ['PA.8:0', 'EADC0_CH20:1', 'UART1_RXD:7', 'BPWM0_CH3:9', 'TM3_EXT:13', 'INT4:15']},
	{ f: ['PA.9:0', 'EADC0_CH21:1', 'UART1_TXD:7', 'BPWM0_CH2:9', 'TM2_EXT:13']},
	{ f: ['PA.10:0', 'EADC0_CH22:1', 'ACMP1_P0:1', 'BPWM0_CH1:9', 'TM1_EXT:13', 'DAC0_ST:14']},
	{ f: ['PA.11:0', 'EADC0_CH23:1', 'ACMP0_P0:1', 'BPWM0_CH0:9', 'EPWM0_SYNC_OUT:10', 'TM0_EXT:13']},
	{ f: ['PA.12:0', 'UART4_TXD:3', 'I2C1_SCL:4', 'BPWM1_CH2:11']},
	{ f: ['PA.13:0', 'UART4_RXD:3', 'I2C1_SDA:4', 'BPWM1_CH3:11']},
	{ f: ['PA.14:0', 'UART0_TXD:3', 'BPWM1_CH4:11']},
	{ f: ['PA.15:0', 'UART0_RXD:3', 'BPWM1_CH5:11', 'EPWM0_SYNC_IN:12']},

	{ f: ['PB.0:0', 'EADC0_CH0:1', 'UART2_RXD:7', 'SPI0_I2SMCLK:8', 'I2C1_SDA:9', 'EPWM0_CH5:11', 'EPWM1_CH5:12', 'EPWM0_BRAKE1:13']},
	{ f: ['PB.1:0', 'EADC0_CH1:1', 'SPI1_I2SMCLK:5', 'UART2_TXD:7', 'I2C1_SCL:9', 'EPWM0_CH4:11', 'EPWM1_CH4:12', 'EPWM0_BRAKE0:13']},
	{ f: ['PB.2:0', 'EADC0_CH2:1', 'ACMP0_P1:1', 'SPI1_SS:5', 'UART1_RXD:6', 'UART5_nCTS:7', 'EPWM0_CH3:11', 'I2C1_SDA:12', 'TM3:14', 'INT3:15']},
	{ f: ['PB.3:0', 'EADC0_CH3:1', 'ACMP0_N:1', 'SPI1_CLK:5', 'UART1_TXD:6', 'UART5_nRTS:7', 'EPWM0_CH2:11', 'I2C1_SCL:12', 'EPWM0_BRAKE0:13', 'TM2:14', 'INT2:15']},
	{ f: ['PB.4:0', 'EADC0_CH4:1', 'ACMP1_P1:1', 'SPI1_MOSI:5', 'I2C0_SDA:6', 'UART5_RXD:7', 'EPWM0_CH1:11', 'UART2_RXD:12', 'TM1:14', 'INT1:15']},
	{ f: ['PB.5:0', 'EADC0_CH5:1', 'ACMP1_N:1', 'SPI1_MISO:5', 'I2C0_SCL:6', 'UART5_TXD:7', 'EPWM0_CH0:11', 'UART2_TXD:12', 'TM0:14', 'INT0:15']},
	{ f: ['PB.6:0', 'EADC0_CH6:1', 'UART1_RXD:6', 'BPWM1_CH5:10', 'EPWM1_BRAKE1:11', 'EPWM1_CH5:12', 'INT4:13', 'ACMP1_O:15']},
	{ f: ['PB.7:0', 'EADC0_CH7:1', 'UART1_TXD:6', 'BPWM1_CH4:10', 'EPWM1_BRAKE0:11', 'EPWM1_CH4:12', 'INT5:13', 'ACMP0_O:15']},
	{ f: ['PB.8:0', 'EADC0_CH8:1', 'UART0_RXD:5', 'UART1_nRTS:6', 'I2C1_SMBSUS:7', 'I2C0_SDA:9', 'BPWM1_CH3:10', 'INT6:13']},
	{ f: ['PB.9:0', 'EADC0_CH9:1', 'UART0_TXD:5', 'UART1_nCTS:6', 'I2C1_SMBAL:7', 'I2C0_SCL:9', 'BPWM1_CH2:10', 'INT7:13']},
	{ f: ['PB.10:0', 'EADC0_CH10:1', 'UART0_nRTS:5', 'UART4_RXD:6', 'I2C1_SDA:7', 'BPWM1_CH1:10']},
	{ f: ['PB.11:0', 'EADC0_CH11:1', 'UART0_nCTS:5', 'UART4_TXD:6', 'I2C1_SCL:7', 'SPI0_I2SMCLK:9', 'BPWM1_CH0:10']},
	{ f: ['PB.12:0', 'EADC0_CH12:1', 'DAC0_OUT:1', 'ACMP0_P2:1', 'ACMP1_P2:1', 'SPI0_MOSI:4', 'UART0_RXD:6', 'UART3_nCTS:7', 'EPWM1_CH3:11', 'TM3_EXT:13']},
	{ f: ['PB.13:0', 'EADC0_CH13:1', 'ACMP0_P3:1', 'ACMP1_P3:1', 'SPI0_MISO:4', 'UART0_TXD:6', 'UART3_nRTS:7', 'EPWM1_CH2:11', 'TM2_EXT:13']},
	{ f: ['PB.14:0', 'EADC0_CH14:1', 'SPI0_CLK:4', 'UART0_nRTS:6', 'UART3_RXD:7', 'EPWM1_CH1:11', 'TM1_EXT:13', 'CLKO:14']},
	{ f: ['PB.15:0', 'EADC0_CH15:1', 'SPI0_SS:4', 'UART0_nCTS:6', 'UART3_TXD:7', 'EPWM0_BRAKE1:10', 'EPWM1_CH0:11', 'TM0_EXT:13']},

	{ f: ['PC.0:0', 'SPI1_SS:7', 'UART2_RXD:8', 'I2C0_SDA:9', 'EPWM1_CH5:12', 'ACMP1_O:14']},
	{ f: ['PC.1:0', 'SPI1_CLK:7', 'UART2_TXD:8', 'I2C0_SCL:9', 'EPWM1_CH4:12', 'ACMP0_O:14', 'EADC0_ST:15']},
	{ f: ['PC.2:0', 'SPI1_MOSI:7', 'UART2_nCTS:8', 'I2C0_SMBSUS:9', 'UART3_RXD:11', 'EPWM1_CH3:12']},
	{ f: ['PC.3:0', 'SPI1_MISO:7', 'UART2_nRTS:8', 'I2C0_SMBAL:9', 'UART3_TXD:11', 'EPWM1_CH2:12']},
	{ f: ['PC.4:0', 'SPI1_I2SMCLK:7', 'UART2_RXD:8', 'I2C1_SDA:9', 'UART4_RXD:11', 'EPWM1_CH1:12']},
	{ f: ['PC.5:0', 'UART2_TXD:8', 'I2C1_SCL:9', 'UART4_TXD:11', 'EPWM1_CH0:12']},
	{ f: ['PC.6:0', 'SPI1_MOSI:4', 'UART4_RXD:5', 'UART0_nRTS:7', 'I2C1_SMBSUS:8', 'EPWM1_CH3:11', 'BPWM1_CH1:12', 'TRACE_DATA2:13', 'TM1:14', 'INT2:15']},
	{ f: ['PC.7:0', 'SPI1_MISO:4', 'UART4_TXD:5', 'UART0_nCTS:7', 'I2C1_SMBAL:8', 'EPWM1_CH2:11', 'BPWM1_CH0:12', 'TRACE_DATA3:13', 'TM0:14', 'INT3:15']},
	{ f: ['PC.8:0', 'I2C0_SDA:4', 'UART4_nCTS:5', 'UART1_RXD:8', 'EPWM1_CH1:11', 'BPWM1_CH4:12']},
	{ f: ['PC.9:0', 'UART3_RXD:7', 'EPWM1_CH3:12']},
	{ f: ['PC.10:0', 'UART3_TXD:7', 'EPWM1_CH2:12']},
	{ f: ['PC.11:0', 'UART0_RXD:3', 'I2C0_SDA:4', 'EPWM1_CH1:12', 'ACMP1_O:14']},
	{ f: ['PC.12:0', 'UART0_TXD:3', 'I2C0_SCL:4', 'EPWM1_CH0:12', 'ACMP0_O:14']},
	{ f: ['PC.13:0', 'EADC0_CH19:1', 'UART2_TXD:7', 'BPWM0_CH4:9', 'CLKO:13', 'EADC0_ST:14']},
	{ f: ['PC.14:0', 'SPI0_I2SMCLK:4', 'CIR0_RXD:10', 'EPWM0_SYNC_IN:11', 'TM1:13']},
	{ f: ['PC.15:0']},

	{ f: ['PD.0:0', 'SPI0_MOSI:4', 'UART3_RXD:5', 'TM2:14']},
	{ f: ['PD.1:0', 'SPI0_MISO:4', 'UART3_TXD:5']},
	{ f: ['PD.2:0', 'SPI0_CLK:4', 'UART3_nCTS:5', 'UART0_RXD:9']},
	{ f: ['PD.3:0', 'SPI0_SS:4', 'UART3_nRTS:5', 'UART0_TXD:9']},
	{ f: ['PD.4:0', 'I2C1_SDA:4', 'SPI1_SS:5']},
	{ f: ['PD.5:0', 'I2C1_SCL:4', 'SPI1_CLK:5']},
	{ f: ['PD.6:0', 'UART1_RXD:3', 'I2C0_SDA:4', 'SPI1_MOSI:5']},
	{ f: ['PD.7:0', 'UART1_TXD:3', 'I2C0_SCL:4', 'SPI1_MISO:5']},
	{ f: ['PD.8:0', 'UART2_nRTS:4']},
	{ f: ['PD.9:0', 'UART2_nCTS:4']},
	{ f: ['PD.10:0', 'EADC0_CH16:1', 'UART1_RXD:3', 'INT7:15']},
	{ f: ['PD.11:0', 'EADC0_CH17:1', 'UART1_TXD:3', 'INT6:15']},
	{ f: ['PD.12:0', 'EADC0_CH18:1', 'UART2_RXD:7', 'BPWM0_CH5:9', 'CLKO:13', 'EADC0_ST:14', 'INT5:15']},
	{ f: ['PD.13:0', 'SPI0_I2SMCLK:4', 'SPI1_I2SMCLK:5']},
	{ f: ['PD.14:0', 'SPI0_I2SMCLK:5', 'EPWM0_CH4:11']},
	{ f: ['PD.15:0', 'EPWM0_CH5:12', 'TRACE_CLK:13', 'TM3:14', 'INT1:15']},

	{ f: ['PE.0:0', 'SPI1_MOSI:6', 'UART3_RXD:7', 'I2C1_SDA:8', 'UART4_nRTS:9']},
	{ f: ['PE.1:0', 'SPI1_MISO:6', 'UART3_TXD:7', 'I2C1_SCL:8', 'UART4_nCTS:9']},
	{ f: ['PE.2:0', 'EPWM0_CH5:12', 'BPWM0_CH0:13']},
	{ f: ['PE.3:0', 'EPWM0_CH4:12', 'BPWM0_CH1:13']},
	{ f: ['PE.4:0', 'EPWM0_CH3:12', 'BPWM0_CH2:13']},
	{ f: ['PE.5:0', 'EPWM0_CH2:12', 'BPWM0_CH3:13']},
	{ f: ['PE.6:0', 'UART5_RXD:8', 'EPWM0_CH1:12', 'BPWM0_CH4:13']},
	{ f: ['PE.7:0', 'UART5_TXD:8', 'EPWM0_CH0:12', 'BPWM0_CH5:13']},
	{ f: ['PE.8:0', 'UART2_TXD:7', 'EPWM0_CH0:10', 'EPWM0_BRAKE0:11', 'TRACE_DATA3:14']},
	{ f: ['PE.9:0', 'UART2_RXD:7', 'EPWM0_CH1:10', 'EPWM0_BRAKE1:11', 'TRACE_DATA2:14']},
	{ f: ['PE.10:0', 'UART3_TXD:7', 'EPWM0_CH2:10', 'EPWM1_BRAKE0:11', 'TRACE_DATA1:14']},
	{ f: ['PE.11:0', 'UART3_RXD:7', 'UART1_nCTS:8', 'EPWM0_CH3:10', 'EPWM1_BRAKE1:11', 'TRACE_DATA0:14']},
	{ f: ['PE.12:0', 'UART1_nRTS:8', 'EPWM0_CH4:10', 'TRACE_CLK:14']},
	{ f: ['PE.13:0', 'I2C0_SCL:4', 'UART4_nRTS:5', 'UART1_TXD:8', 'EPWM0_CH5:10', 'EPWM1_CH0:11', 'BPWM1_CH5:12']},
	{ f: ['PE.14:0', 'UART2_TXD:3']},
	{ f: ['PE.15:0', 'UART2_RXD:3']},

	{ f: ['PF.0:0', 'UART1_TXD:2', 'I2C1_SCL:3', 'UART0_TXD:4', 'BPWM1_CH0:12', 'ICE_DAT:14']},
	{ f: ['PF.1:0', 'UART1_RXD:2', 'I2C1_SDA:3', 'UART0_RXD:4', 'BPWM1_CH1:12', 'ICE_CLK:14']},
	{ f: ['PF.2:0', 'UART0_RXD:3', 'I2C0_SDA:4', 'XT1_OUT:10', 'BPWM1_CH1:11']},
	{ f: ['PF.3:0', 'UART0_TXD:3', 'I2C0_SCL:4', 'XT1_IN:10', 'BPWM1_CH0:11']},
	{ f: ['PF.4:0', 'UART2_TXD:2', 'UART2_nRTS:4', 'EPWM0_CH1:7', 'BPWM0_CH5:8', 'X32_OUT:10']},
	{ f: ['PF.5:0', 'UART2_RXD:2', 'UART2_nCTS:4', 'EPWM0_CH0:7', 'BPWM0_CH4:8', 'EPWM0_SYNC_OUT:9', 'X32_IN:10', 'EADC0_ST:11']},
	{ f: ['PF.6:0', 'SPI0_MOSI:5', 'UART4_RXD:6']},
	{ f: ['PF.7:0', 'SPI0_MISO:5', 'UART4_TXD:6']},
	{ f: ['PF.8:0', 'SPI0_CLK:5', 'UART5_nCTS:6']},
	{ f: ['PF.9:0', 'SPI0_SS:5', 'UART5_nRTS:6']},
	{ f: ['PF.10:0', 'SPI0_I2SMCLK:5', 'UART5_RXD:6']},
	{ f: ['PF.11:0', 'UART5_TXD:6', 'TM3:13']},
	{ f: ['PF.12:0', 'I2C0_SCL:4', 'UART5_TXD:6', 'UART3_TXD:7', 'UART1_TXD:8', 'I2C1_SCL:9', 'EPWM0_CH2:10', 'BPWM0_CH0:11', 'TRACE_DATA1:13', 'CIR0_RXD:15']},
	{ f: ['PF.13:0', 'I2C0_SDA:4', 'UART5_RXD:6', 'UART3_RXD:7', 'UART1_RXD:8', 'I2C1_SDA:9', 'EPWM0_CH3:10', 'BPWM0_CH1:11', 'TRACE_DATA0:13']},
	{ f: ['PF.14:0', 'EPWM1_BRAKE0:9', 'EPWM0_BRAKE0:10', 'EPWM0_CH4:12', 'CLKO:13', 'TM3:14', 'INT5:15']},
	{ f: ['PF.15:0', 'EPWM0_BRAKE0:11', 'EPWM0_CH1:12', 'TM2:13', 'CLKO:14', 'INT4:15']},

	{ f: ['PG.0:0']},
	{ f: ['PG.1:0']},
	{ f: ['PG.2:0', 'I2C0_SMBAL:4', 'I2C1_SCL:5', 'TM0:13']},
	{ f: ['PG.3:0', 'I2C0_SMBSUS:4', 'I2C1_SDA:5', 'TM1:13']},
	{ f: ['PG.4:0', 'TM2:13']},
	{ f: ['PG.5:0']},
	{ f: ['PG.6:0']},
	{ f: ['PG.7:0']},
	{ f: ['PG.8:0']},
	{ f: ['PG.9:0', 'BPWM0_CH5:12']},
	{ f: ['PG.10:0', 'BPWM0_CH4:12']},
	{ f: ['PG.11:0', 'BPWM0_CH3:12']},
	{ f: ['PG.12:0', 'BPWM0_CH2:12']},
	{ f: ['PG.13:0', 'BPWM0_CH1:12']},
	{ f: ['PG.14:0', 'BPWM0_CH0:12']},
	{ f: ['PG.15:0', 'CLKO:14', 'EADC0_ST:15']},

	{ f: ['PH.0:0']},
	{ f: ['PH.1:0']},
	{ f: ['PH.2:0']},
	{ f: ['PH.3:0']},
	{ f: ['PH.4:0', 'SPI1_MISO:3']},
	{ f: ['PH.5:0', 'SPI1_MOSI:3']},
	{ f: ['PH.6:0', 'SPI1_CLK:3']},
	{ f: ['PH.7:0', 'SPI1_SS:3']},
	{ f: ['PH.8:0', 'SPI1_CLK:6', 'UART3_nRTS:7', 'I2C1_SMBAL:8', 'UART1_TXD:10']},
	{ f: ['PH.9:0', 'SPI1_SS:6', 'UART3_nCTS:7', 'I2C1_SMBSUS:8', 'UART1_RXD:10']},
	{ f: ['PH.10:0', 'SPI1_I2SMCLK:6', 'UART4_TXD:7', 'UART0_TXD:8']},
	{ f: ['PH.11:0', 'UART4_RXD:7', 'UART0_RXD:8', 'EPWM0_CH5:11']},
	{ f: ['PH.12:0']},
	{ f: ['PH.13:0']},
	{ f: ['PH.14:0']},
	{ f: ['PH.15:0']},

	{ f: ['PI.0:0', 'UART0_TXD:3', 'I2C0_SCL:4', 'UART5_TXD:6', 'UART2_TXD:7', 'I2C1_SCL:9', 'EPWM0_CH4:11', 'EPWM1_CH0:12', 'ACMP0_O:14']},
	{ f: ['PI.1:0', 'UART0_RXD:3', 'I2C0_SDA:4', 'UART5_RXD:6', 'UART2_RXD:7', 'I2C1_SDA:9', 'EPWM0_CH5:11', 'EPWM1_CH1:12', 'ACMP1_O:14']},
	{ f: ['PI.2:0', 'UART1_TXD:3', 'I2C0_SCL:4', 'UART5_TXD:6', 'I2C1_SCL:9', 'UART4_TXD:11', 'BPWM0_CH5:12', 'EADC0_ST:15']},
	{ f: ['PI.3:0', 'UART1_RXD:3', 'I2C0_SDA:4', 'UART5_RXD:6', 'I2C1_SDA:9', 'UART4_RXD:11', 'BPWM0_CH4:12']},
	{ f: ['PI.4:0', 'UART4_TXD:7', 'UART0_TXD:8', 'UART1_TXD:10', 'EPWM0_CH5:11', 'CIR0_RXD:14', 'ACMP0_O:15']},
	{ f: ['PI.5:0', 'UART4_RXD:7', 'UART0_RXD:8', 'UART1_RXD:10', 'EPWM0_CH4:11', 'ACMP1_O:15']},
	{ f: ['PI.6:0']},
	{ f: ['PI.7:0']},
	{ f: ['PI.8:0']},
	{ f: ['PI.9:0']},
	{ f: ['PI.10:0']},
	{ f: ['PI.11:0']},
	{ f: ['PI.12:0']},
	{ f: ['PI.13:0']},
	{ f: ['PI.14:0']},
	{ f: ['PI.15:0']}
];

NUTOOL_PIN.g_cfg_gpiosDefines = [
	{ f: ['PA.0', 'GPIO:SYS_GPA_MFPL_PA0MFP_GPIO@GPA_MFPL', 'SPI0_MOSI:SYS_GPA_MFPL_PA0MFP_SPI0_MOSI@GPA_MFPL', 'UART0_RXD:SYS_GPA_MFPL_PA0MFP_UART0_RXD@GPA_MFPL', 'UART1_nRTS:SYS_GPA_MFPL_PA0MFP_UART1_nRTS@GPA_MFPL', 'BPWM0_CH0:SYS_GPA_MFPL_PA0MFP_BPWM0_CH0@GPA_MFPL', 'EPWM0_CH5:SYS_GPA_MFPL_PA0MFP_EPWM0_CH5@GPA_MFPL', 'DAC0_ST:SYS_GPA_MFPL_PA0MFP_DAC0_ST@GPA_MFPL'] },
	{ f: ['PA.1', 'GPIO:SYS_GPA_MFPL_PA1MFP_GPIO@GPA_MFPL', 'SPI0_MISO:SYS_GPA_MFPL_PA1MFP_SPI0_MISO@GPA_MFPL', 'UART0_TXD:SYS_GPA_MFPL_PA1MFP_UART0_TXD@GPA_MFPL', 'UART1_nCTS:SYS_GPA_MFPL_PA1MFP_UART1_nCTS@GPA_MFPL', 'BPWM0_CH1:SYS_GPA_MFPL_PA1MFP_BPWM0_CH1@GPA_MFPL', 'EPWM0_CH4:SYS_GPA_MFPL_PA1MFP_EPWM0_CH4@GPA_MFPL'] },
	{ f: ['PA.2', 'GPIO:SYS_GPA_MFPL_PA2MFP_GPIO@GPA_MFPL', 'SPI0_CLK:SYS_GPA_MFPL_PA2MFP_SPI0_CLK@GPA_MFPL', 'UART4_RXD:SYS_GPA_MFPL_PA2MFP_UART4_RXD@GPA_MFPL', 'UART1_RXD:SYS_GPA_MFPL_PA2MFP_UART1_RXD@GPA_MFPL', 'I2C1_SDA:SYS_GPA_MFPL_PA2MFP_I2C1_SDA@GPA_MFPL', 'I2C0_SMBSUS:SYS_GPA_MFPL_PA2MFP_I2C0_SMBSUS@GPA_MFPL', 'BPWM0_CH2:SYS_GPA_MFPL_PA2MFP_BPWM0_CH2@GPA_MFPL', 'EPWM0_CH3:SYS_GPA_MFPL_PA2MFP_EPWM0_CH3@GPA_MFPL', 'CIR0_RXD:SYS_GPA_MFPL_PA2MFP_CIR0_RXD@GPA_MFPL'] },
	{ f: ['PA.3', 'GPIO:SYS_GPA_MFPL_PA3MFP_GPIO@GPA_MFPL', 'SPI0_SS:SYS_GPA_MFPL_PA3MFP_SPI0_SS@GPA_MFPL', 'UART4_TXD:SYS_GPA_MFPL_PA3MFP_UART4_TXD@GPA_MFPL', 'UART1_TXD:SYS_GPA_MFPL_PA3MFP_UART1_TXD@GPA_MFPL', 'I2C1_SCL:SYS_GPA_MFPL_PA3MFP_I2C1_SCL@GPA_MFPL', 'I2C0_SMBAL:SYS_GPA_MFPL_PA3MFP_I2C0_SMBAL@GPA_MFPL', 'CLKO:SYS_GPA_MFPL_PA3MFP_CLKO@GPA_MFPL', 'BPWM0_CH3:SYS_GPA_MFPL_PA3MFP_BPWM0_CH3@GPA_MFPL', 'EPWM0_CH2:SYS_GPA_MFPL_PA3MFP_EPWM0_CH2@GPA_MFPL', 'EPWM1_BRAKE1:SYS_GPA_MFPL_PA3MFP_EPWM1_BRAKE1@GPA_MFPL'] },
	{ f: ['PA.4', 'GPIO:SYS_GPA_MFPL_PA4MFP_GPIO@GPA_MFPL', 'SPI0_I2SMCLK:SYS_GPA_MFPL_PA4MFP_SPI0_I2SMCLK@GPA_MFPL', 'UART0_nRTS:SYS_GPA_MFPL_PA4MFP_UART0_nRTS@GPA_MFPL', 'UART5_RXD:SYS_GPA_MFPL_PA4MFP_UART5_RXD@GPA_MFPL', 'I2C0_SDA:SYS_GPA_MFPL_PA4MFP_I2C0_SDA@GPA_MFPL', 'UART0_RXD:SYS_GPA_MFPL_PA4MFP_UART0_RXD@GPA_MFPL', 'BPWM0_CH4:SYS_GPA_MFPL_PA4MFP_BPWM0_CH4@GPA_MFPL', 'EPWM0_CH1:SYS_GPA_MFPL_PA4MFP_EPWM0_CH1@GPA_MFPL'] },
	{ f: ['PA.5', 'GPIO:SYS_GPA_MFPL_PA5MFP_GPIO@GPA_MFPL', 'SPI1_I2SMCLK:SYS_GPA_MFPL_PA5MFP_SPI1_I2SMCLK@GPA_MFPL', 'UART0_nCTS:SYS_GPA_MFPL_PA5MFP_UART0_nCTS@GPA_MFPL', 'UART5_TXD:SYS_GPA_MFPL_PA5MFP_UART5_TXD@GPA_MFPL', 'I2C0_SCL:SYS_GPA_MFPL_PA5MFP_I2C0_SCL@GPA_MFPL', 'UART0_TXD:SYS_GPA_MFPL_PA5MFP_UART0_TXD@GPA_MFPL', 'BPWM0_CH5:SYS_GPA_MFPL_PA5MFP_BPWM0_CH5@GPA_MFPL', 'EPWM0_CH0:SYS_GPA_MFPL_PA5MFP_EPWM0_CH0@GPA_MFPL'] },
	{ f: ['PA.6', 'GPIO:SYS_GPA_MFPL_PA6MFP_GPIO@GPA_MFPL', 'SPI1_SS:SYS_GPA_MFPL_PA6MFP_SPI1_SS@GPA_MFPL', 'UART0_RXD:SYS_GPA_MFPL_PA6MFP_UART0_RXD@GPA_MFPL', 'I2C1_SDA:SYS_GPA_MFPL_PA6MFP_I2C1_SDA@GPA_MFPL', 'EPWM1_CH5:SYS_GPA_MFPL_PA6MFP_EPWM1_CH5@GPA_MFPL', 'BPWM1_CH3:SYS_GPA_MFPL_PA6MFP_BPWM1_CH3@GPA_MFPL', 'ACMP1_WLAT:SYS_GPA_MFPL_PA6MFP_ACMP1_WLAT@GPA_MFPL', 'TM3:SYS_GPA_MFPL_PA6MFP_TM3@GPA_MFPL', 'INT0:SYS_GPA_MFPL_PA6MFP_INT0@GPA_MFPL'] },
	{ f: ['PA.7', 'GPIO:SYS_GPA_MFPL_PA7MFP_GPIO@GPA_MFPL', 'SPI1_CLK:SYS_GPA_MFPL_PA7MFP_SPI1_CLK@GPA_MFPL', 'UART0_TXD:SYS_GPA_MFPL_PA7MFP_UART0_TXD@GPA_MFPL', 'I2C1_SCL:SYS_GPA_MFPL_PA7MFP_I2C1_SCL@GPA_MFPL', 'EPWM1_CH4:SYS_GPA_MFPL_PA7MFP_EPWM1_CH4@GPA_MFPL', 'BPWM1_CH2:SYS_GPA_MFPL_PA7MFP_BPWM1_CH2@GPA_MFPL', 'ACMP0_WLAT:SYS_GPA_MFPL_PA7MFP_ACMP0_WLAT@GPA_MFPL', 'TM2:SYS_GPA_MFPL_PA7MFP_TM2@GPA_MFPL', 'INT1:SYS_GPA_MFPL_PA7MFP_INT1@GPA_MFPL'] },
	{ f: ['PA.8', 'GPIO:SYS_GPA_MFPH_PA8MFP_GPIO@GPA_MFPH', 'EADC0_CH20:SYS_GPA_MFPH_PA8MFP_EADC0_CH20@GPA_MFPH', 'UART1_RXD:SYS_GPA_MFPH_PA8MFP_UART1_RXD@GPA_MFPH', 'BPWM0_CH3:SYS_GPA_MFPH_PA8MFP_BPWM0_CH3@GPA_MFPH', 'TM3_EXT:SYS_GPA_MFPH_PA8MFP_TM3_EXT@GPA_MFPH', 'INT4:SYS_GPA_MFPH_PA8MFP_INT4@GPA_MFPH'] },
	{ f: ['PA.9', 'GPIO:SYS_GPA_MFPH_PA9MFP_GPIO@GPA_MFPH', 'EADC0_CH21:SYS_GPA_MFPH_PA9MFP_EADC0_CH21@GPA_MFPH', 'UART1_TXD:SYS_GPA_MFPH_PA9MFP_UART1_TXD@GPA_MFPH', 'BPWM0_CH2:SYS_GPA_MFPH_PA9MFP_BPWM0_CH2@GPA_MFPH', 'TM2_EXT:SYS_GPA_MFPH_PA9MFP_TM2_EXT@GPA_MFPH'] },
	{ f: ['PA.10', 'GPIO:SYS_GPA_MFPH_PA10MFP_GPIO@GPA_MFPH', 'ACMP1_P0:SYS_GPA_MFPH_PA10MFP_ACMP1_P0@GPA_MFPH', 'EADC0_CH22:SYS_GPA_MFPH_PA10MFP_EADC0_CH22@GPA_MFPH', 'BPWM0_CH1:SYS_GPA_MFPH_PA10MFP_BPWM0_CH1@GPA_MFPH', 'TM1_EXT:SYS_GPA_MFPH_PA10MFP_TM1_EXT@GPA_MFPH', 'DAC0_ST:SYS_GPA_MFPH_PA10MFP_DAC0_ST@GPA_MFPH'] },
	{ f: ['PA.11', 'GPIO:SYS_GPA_MFPH_PA11MFP_GPIO@GPA_MFPH', 'ACMP0_P0:SYS_GPA_MFPH_PA11MFP_ACMP0_P0@GPA_MFPH', 'EADC0_CH23:SYS_GPA_MFPH_PA11MFP_EADC0_CH23@GPA_MFPH', 'BPWM0_CH0:SYS_GPA_MFPH_PA11MFP_BPWM0_CH0@GPA_MFPH', 'EPWM0_SYNC_OUT:SYS_GPA_MFPH_PA11MFP_EPWM0_SYNC_OUT@GPA_MFPH', 'TM0_EXT:SYS_GPA_MFPH_PA11MFP_TM0_EXT@GPA_MFPH'] },
	{ f: ['PA.12', 'GPIO:SYS_GPA_MFPH_PA12MFP_GPIO@GPA_MFPH', 'UART4_TXD:SYS_GPA_MFPH_PA12MFP_UART4_TXD@GPA_MFPH', 'I2C1_SCL:SYS_GPA_MFPH_PA12MFP_I2C1_SCL@GPA_MFPH', 'BPWM1_CH2:SYS_GPA_MFPH_PA12MFP_BPWM1_CH2@GPA_MFPH'] },
	{ f: ['PA.13', 'GPIO:SYS_GPA_MFPH_PA13MFP_GPIO@GPA_MFPH', 'UART4_RXD:SYS_GPA_MFPH_PA13MFP_UART4_RXD@GPA_MFPH', 'I2C1_SDA:SYS_GPA_MFPH_PA13MFP_I2C1_SDA@GPA_MFPH', 'BPWM1_CH3:SYS_GPA_MFPH_PA13MFP_BPWM1_CH3@GPA_MFPH'] },
	{ f: ['PA.14', 'GPIO:SYS_GPA_MFPH_PA14MFP_GPIO@GPA_MFPH', 'UART0_TXD:SYS_GPA_MFPH_PA14MFP_UART0_TXD@GPA_MFPH', 'BPWM1_CH4:SYS_GPA_MFPH_PA14MFP_BPWM1_CH4@GPA_MFPH'] },
	{ f: ['PA.15', 'GPIO:SYS_GPA_MFPH_PA15MFP_GPIO@GPA_MFPH', 'UART0_RXD:SYS_GPA_MFPH_PA15MFP_UART0_RXD@GPA_MFPH', 'BPWM1_CH5:SYS_GPA_MFPH_PA15MFP_BPWM1_CH5@GPA_MFPH', 'EPWM0_SYNC_IN:SYS_GPA_MFPH_PA15MFP_EPWM0_SYNC_IN@GPA_MFPH'] },
	
	{ f: ['PB.0', 'GPIO:SYS_GPB_MFPL_PB0MFP_GPIO@GPB_MFPL', 'EADC0_CH0:SYS_GPB_MFPL_PB0MFP_EADC0_CH0@GPB_MFPL', 'UART2_RXD:SYS_GPB_MFPL_PB0MFP_UART2_RXD@GPB_MFPL', 'SPI0_I2SMCLK:SYS_GPB_MFPL_PB0MFP_SPI0_I2SMCLK@GPB_MFPL', 'I2C1_SDA:SYS_GPB_MFPL_PB0MFP_I2C1_SDA@GPB_MFPL', 'EPWM0_CH5:SYS_GPB_MFPL_PB0MFP_EPWM0_CH5@GPB_MFPL', 'EPWM1_CH5:SYS_GPB_MFPL_PB0MFP_EPWM1_CH5@GPB_MFPL', 'EPWM0_BRAKE1:SYS_GPB_MFPL_PB0MFP_EPWM0_BRAKE1@GPB_MFPL'] },
	{ f: ['PB.1', 'GPIO:SYS_GPB_MFPL_PB1MFP_GPIO@GPB_MFPL', 'EADC0_CH1:SYS_GPB_MFPL_PB1MFP_EADC0_CH1@GPB_MFPL', 'SPI1_I2SMCLK:SYS_GPB_MFPL_PB1MFP_SPI1_I2SMCLK@GPB_MFPL', 'UART2_TXD:SYS_GPB_MFPL_PB1MFP_UART2_TXD@GPB_MFPL', 'I2C1_SCL:SYS_GPB_MFPL_PB1MFP_I2C1_SCL@GPB_MFPL', 'EPWM0_CH4:SYS_GPB_MFPL_PB1MFP_EPWM0_CH4@GPB_MFPL', 'EPWM1_CH4:SYS_GPB_MFPL_PB1MFP_EPWM1_CH4@GPB_MFPL', 'EPWM0_BRAKE0:SYS_GPB_MFPL_PB1MFP_EPWM0_BRAKE0@GPB_MFPL'] },
	{ f: ['PB.2', 'GPIO:SYS_GPB_MFPL_PB2MFP_GPIO@GPB_MFPL', 'ACMP0_P1:SYS_GPB_MFPL_PB2MFP_ACMP0_P1@GPB_MFPL', 'EADC0_CH2:SYS_GPB_MFPL_PB2MFP_EADC0_CH2@GPB_MFPL', 'SPI1_SS:SYS_GPB_MFPL_PB2MFP_SPI1_SS@GPB_MFPL', 'UART1_RXD:SYS_GPB_MFPL_PB2MFP_UART1_RXD@GPB_MFPL', 'UART5_nCTS:SYS_GPB_MFPL_PB2MFP_UART5_nCTS@GPB_MFPL', 'EPWM0_CH3:SYS_GPB_MFPL_PB2MFP_EPWM0_CH3@GPB_MFPL', 'I2C1_SDA:SYS_GPB_MFPL_PB2MFP_I2C1_SDA@GPB_MFPL', 'TM3:SYS_GPB_MFPL_PB2MFP_TM3@GPB_MFPL', 'INT3:SYS_GPB_MFPL_PB2MFP_INT3@GPB_MFPL'] },
	{ f: ['PB.3', 'GPIO:SYS_GPB_MFPL_PB3MFP_GPIO@GPB_MFPL', 'ACMP0_N:SYS_GPB_MFPL_PB3MFP_ACMP0_N@GPB_MFPL', 'EADC0_CH3:SYS_GPB_MFPL_PB3MFP_EADC0_CH3@GPB_MFPL', 'SPI1_CLK:SYS_GPB_MFPL_PB3MFP_SPI1_CLK@GPB_MFPL', 'UART1_TXD:SYS_GPB_MFPL_PB3MFP_UART1_TXD@GPB_MFPL', 'UART5_nRTS:SYS_GPB_MFPL_PB3MFP_UART5_nRTS@GPB_MFPL', 'EPWM0_CH2:SYS_GPB_MFPL_PB3MFP_EPWM0_CH2@GPB_MFPL', 'I2C1_SCL:SYS_GPB_MFPL_PB3MFP_I2C1_SCL@GPB_MFPL', 'EPWM0_BRAKE0:SYS_GPB_MFPL_PB3MFP_EPWM0_BRAKE0@GPB_MFPL', 'TM2:SYS_GPB_MFPL_PB3MFP_TM2@GPB_MFPL', 'INT2:SYS_GPB_MFPL_PB3MFP_INT2@GPB_MFPL'] },
	{ f: ['PB.4', 'GPIO:SYS_GPB_MFPL_PB4MFP_GPIO@GPB_MFPL', 'ACMP1_P1:SYS_GPB_MFPL_PB4MFP_ACMP1_P1@GPB_MFPL', 'EADC0_CH4:SYS_GPB_MFPL_PB4MFP_EADC0_CH4@GPB_MFPL', 'SPI1_MOSI:SYS_GPB_MFPL_PB4MFP_SPI1_MOSI@GPB_MFPL', 'I2C0_SDA:SYS_GPB_MFPL_PB4MFP_I2C0_SDA@GPB_MFPL', 'UART5_RXD:SYS_GPB_MFPL_PB4MFP_UART5_RXD@GPB_MFPL', 'EPWM0_CH1:SYS_GPB_MFPL_PB4MFP_EPWM0_CH1@GPB_MFPL', 'UART2_RXD:SYS_GPB_MFPL_PB4MFP_UART2_RXD@GPB_MFPL', 'TM1:SYS_GPB_MFPL_PB4MFP_TM1@GPB_MFPL', 'INT1:SYS_GPB_MFPL_PB4MFP_INT1@GPB_MFPL'] },
	{ f: ['PB.5', 'GPIO:SYS_GPB_MFPL_PB5MFP_GPIO@GPB_MFPL', 'ACMP1_N:SYS_GPB_MFPL_PB5MFP_ACMP1_N@GPB_MFPL', 'EADC0_CH5:SYS_GPB_MFPL_PB5MFP_EADC0_CH5@GPB_MFPL', 'SPI1_MISO:SYS_GPB_MFPL_PB5MFP_SPI1_MISO@GPB_MFPL', 'I2C0_SCL:SYS_GPB_MFPL_PB5MFP_I2C0_SCL@GPB_MFPL', 'UART5_TXD:SYS_GPB_MFPL_PB5MFP_UART5_TXD@GPB_MFPL', 'EPWM0_CH0:SYS_GPB_MFPL_PB5MFP_EPWM0_CH0@GPB_MFPL', 'UART2_TXD:SYS_GPB_MFPL_PB5MFP_UART2_TXD@GPB_MFPL', 'TM0:SYS_GPB_MFPL_PB5MFP_TM0@GPB_MFPL', 'INT0:SYS_GPB_MFPL_PB5MFP_INT0@GPB_MFPL'] },
	{ f: ['PB.6', 'GPIO:SYS_GPB_MFPL_PB6MFP_GPIO@GPB_MFPL', 'EADC0_CH6:SYS_GPB_MFPL_PB6MFP_EADC0_CH6@GPB_MFPL', 'UART1_RXD:SYS_GPB_MFPL_PB6MFP_UART1_RXD@GPB_MFPL', 'BPWM1_CH5:SYS_GPB_MFPL_PB6MFP_BPWM1_CH5@GPB_MFPL', 'EPWM1_BRAKE1:SYS_GPB_MFPL_PB6MFP_EPWM1_BRAKE1@GPB_MFPL', 'EPWM1_CH5:SYS_GPB_MFPL_PB6MFP_EPWM1_CH5@GPB_MFPL', 'INT4:SYS_GPB_MFPL_PB6MFP_INT4@GPB_MFPL', 'ACMP1_O:SYS_GPB_MFPL_PB6MFP_ACMP1_O@GPB_MFPL'] },
	{ f: ['PB.7', 'GPIO:SYS_GPB_MFPL_PB7MFP_GPIO@GPB_MFPL', 'EADC0_CH7:SYS_GPB_MFPL_PB7MFP_EADC0_CH7@GPB_MFPL', 'UART1_TXD:SYS_GPB_MFPL_PB7MFP_UART1_TXD@GPB_MFPL', 'BPWM1_CH4:SYS_GPB_MFPL_PB7MFP_BPWM1_CH4@GPB_MFPL', 'EPWM1_BRAKE0:SYS_GPB_MFPL_PB7MFP_EPWM1_BRAKE0@GPB_MFPL', 'EPWM1_CH4:SYS_GPB_MFPL_PB7MFP_EPWM1_CH4@GPB_MFPL', 'INT5:SYS_GPB_MFPL_PB7MFP_INT5@GPB_MFPL', 'ACMP0_O:SYS_GPB_MFPL_PB7MFP_ACMP0_O@GPB_MFPL'] },
	{ f: ['PB.8', 'GPIO:SYS_GPB_MFPH_PB8MFP_GPIO@GPB_MFPH', 'EADC0_CH8:SYS_GPB_MFPH_PB8MFP_EADC0_CH8@GPB_MFPH', 'UART0_RXD:SYS_GPB_MFPH_PB8MFP_UART0_RXD@GPB_MFPH', 'UART1_nRTS:SYS_GPB_MFPH_PB8MFP_UART1_nRTS@GPB_MFPH', 'I2C1_SMBSUS:SYS_GPB_MFPH_PB8MFP_I2C1_SMBSUS@GPB_MFPH', 'I2C0_SDA:SYS_GPB_MFPH_PB8MFP_I2C0_SDA@GPB_MFPH', 'BPWM1_CH3:SYS_GPB_MFPH_PB8MFP_BPWM1_CH3@GPB_MFPH', 'INT6:SYS_GPB_MFPH_PB8MFP_INT6@GPB_MFPH'] },
	{ f: ['PB.9', 'GPIO:SYS_GPB_MFPH_PB9MFP_GPIO@GPB_MFPH', 'EADC0_CH9:SYS_GPB_MFPH_PB9MFP_EADC0_CH9@GPB_MFPH', 'UART0_TXD:SYS_GPB_MFPH_PB9MFP_UART0_TXD@GPB_MFPH', 'UART1_nCTS:SYS_GPB_MFPH_PB9MFP_UART1_nCTS@GPB_MFPH', 'I2C1_SMBAL:SYS_GPB_MFPH_PB9MFP_I2C1_SMBAL@GPB_MFPH', 'I2C0_SCL:SYS_GPB_MFPH_PB9MFP_I2C0_SCL@GPB_MFPH', 'BPWM1_CH2:SYS_GPB_MFPH_PB9MFP_BPWM1_CH2@GPB_MFPH', 'INT7:SYS_GPB_MFPH_PB9MFP_INT7@GPB_MFPH'] },
	{ f: ['PB.10', 'GPIO:SYS_GPB_MFPH_PB10MFP_GPIO@GPB_MFPH', 'EADC0_CH10:SYS_GPB_MFPH_PB10MFP_EADC0_CH10@GPB_MFPH', 'UART0_nRTS:SYS_GPB_MFPH_PB10MFP_UART0_nRTS@GPB_MFPH', 'UART4_RXD:SYS_GPB_MFPH_PB10MFP_UART4_RXD@GPB_MFPH', 'I2C1_SDA:SYS_GPB_MFPH_PB10MFP_I2C1_SDA@GPB_MFPH', 'BPWM1_CH1:SYS_GPB_MFPH_PB10MFP_BPWM1_CH1@GPB_MFPH'] },
	{ f: ['PB.11', 'GPIO:SYS_GPB_MFPH_PB11MFP_GPIO@GPB_MFPH', 'EADC0_CH11:SYS_GPB_MFPH_PB11MFP_EADC0_CH11@GPB_MFPH', 'UART0_nCTS:SYS_GPB_MFPH_PB11MFP_UART0_nCTS@GPB_MFPH', 'UART4_TXD:SYS_GPB_MFPH_PB11MFP_UART4_TXD@GPB_MFPH', 'I2C1_SCL:SYS_GPB_MFPH_PB11MFP_I2C1_SCL@GPB_MFPH', 'SPI0_I2SMCLK:SYS_GPB_MFPH_PB11MFP_SPI0_I2SMCLK@GPB_MFPH', 'BPWM1_CH0:SYS_GPB_MFPH_PB11MFP_BPWM1_CH0@GPB_MFPH'] },
	{ f: ['PB.12', 'GPIO:SYS_GPB_MFPH_PB12MFP_GPIO@GPB_MFPH', 'ACMP0_P2:SYS_GPB_MFPH_PB12MFP_ACMP0_P2@GPB_MFPH', 'ACMP1_P2:SYS_GPB_MFPH_PB12MFP_ACMP1_P2@GPB_MFPH', 'DAC0_OUT:SYS_GPB_MFPH_PB12MFP_DAC0_OUT@GPB_MFPH', 'EADC0_CH12:SYS_GPB_MFPH_PB12MFP_EADC0_CH12@GPB_MFPH', 'SPI0_MOSI:SYS_GPB_MFPH_PB12MFP_SPI0_MOSI@GPB_MFPH', 'UART0_RXD:SYS_GPB_MFPH_PB12MFP_UART0_RXD@GPB_MFPH', 'UART3_nCTS:SYS_GPB_MFPH_PB12MFP_UART3_nCTS@GPB_MFPH', 'EPWM1_CH3:SYS_GPB_MFPH_PB12MFP_EPWM1_CH3@GPB_MFPH', 'TM3_EXT:SYS_GPB_MFPH_PB12MFP_TM3_EXT@GPB_MFPH'] },
	{ f: ['PB.13', 'GPIO:SYS_GPB_MFPH_PB13MFP_GPIO@GPB_MFPH', 'ACMP0_P3:SYS_GPB_MFPH_PB13MFP_ACMP0_P3@GPB_MFPH', 'ACMP1_P3:SYS_GPB_MFPH_PB13MFP_ACMP1_P3@GPB_MFPH', 'EADC0_CH13:SYS_GPB_MFPH_PB13MFP_EADC0_CH13@GPB_MFPH', 'SPI0_MISO:SYS_GPB_MFPH_PB13MFP_SPI0_MISO@GPB_MFPH', 'UART0_TXD:SYS_GPB_MFPH_PB13MFP_UART0_TXD@GPB_MFPH', 'UART3_nRTS:SYS_GPB_MFPH_PB13MFP_UART3_nRTS@GPB_MFPH', 'EPWM1_CH2:SYS_GPB_MFPH_PB13MFP_EPWM1_CH2@GPB_MFPH', 'TM2_EXT:SYS_GPB_MFPH_PB13MFP_TM2_EXT@GPB_MFPH'] },
	{ f: ['PB.14', 'GPIO:SYS_GPB_MFPH_PB14MFP_GPIO@GPB_MFPH', 'EADC0_CH14:SYS_GPB_MFPH_PB14MFP_EADC0_CH14@GPB_MFPH', 'SPI0_CLK:SYS_GPB_MFPH_PB14MFP_SPI0_CLK@GPB_MFPH', 'UART0_nRTS:SYS_GPB_MFPH_PB14MFP_UART0_nRTS@GPB_MFPH', 'UART3_RXD:SYS_GPB_MFPH_PB14MFP_UART3_RXD@GPB_MFPH', 'EPWM1_CH1:SYS_GPB_MFPH_PB14MFP_EPWM1_CH1@GPB_MFPH', 'TM1_EXT:SYS_GPB_MFPH_PB14MFP_TM1_EXT@GPB_MFPH', 'CLKO:SYS_GPB_MFPH_PB14MFP_CLKO@GPB_MFPH'] },
	{ f: ['PB.15', 'GPIO:SYS_GPB_MFPH_PB15MFP_GPIO@GPB_MFPH', 'EADC0_CH15:SYS_GPB_MFPH_PB15MFP_EADC0_CH15@GPB_MFPH', 'SPI0_SS:SYS_GPB_MFPH_PB15MFP_SPI0_SS@GPB_MFPH', 'UART0_nCTS:SYS_GPB_MFPH_PB15MFP_UART0_nCTS@GPB_MFPH', 'UART3_TXD:SYS_GPB_MFPH_PB15MFP_UART3_TXD@GPB_MFPH', 'EPWM0_BRAKE1:SYS_GPB_MFPH_PB15MFP_EPWM0_BRAKE1@GPB_MFPH', 'EPWM1_CH0:SYS_GPB_MFPH_PB15MFP_EPWM1_CH0@GPB_MFPH', 'TM0_EXT:SYS_GPB_MFPH_PB15MFP_TM0_EXT@GPB_MFPH'] },
	
	{ f: ['PC.0', 'GPIO:SYS_GPC_MFPL_PC0MFP_GPIO@GPC_MFPL', 'SPI1_SS:SYS_GPC_MFPL_PC0MFP_SPI1_SS@GPC_MFPL', 'UART2_RXD:SYS_GPC_MFPL_PC0MFP_UART2_RXD@GPC_MFPL', 'I2C0_SDA:SYS_GPC_MFPL_PC0MFP_I2C0_SDA@GPC_MFPL', 'EPWM1_CH5:SYS_GPC_MFPL_PC0MFP_EPWM1_CH5@GPC_MFPL', 'ACMP1_O:SYS_GPC_MFPL_PC0MFP_ACMP1_O@GPC_MFPL'] },
	{ f: ['PC.1', 'GPIO:SYS_GPC_MFPL_PC1MFP_GPIO@GPC_MFPL', 'SPI1_CLK:SYS_GPC_MFPL_PC1MFP_SPI1_CLK@GPC_MFPL', 'UART2_TXD:SYS_GPC_MFPL_PC1MFP_UART2_TXD@GPC_MFPL', 'I2C0_SCL:SYS_GPC_MFPL_PC1MFP_I2C0_SCL@GPC_MFPL', 'EPWM1_CH4:SYS_GPC_MFPL_PC1MFP_EPWM1_CH4@GPC_MFPL', 'ACMP0_O:SYS_GPC_MFPL_PC1MFP_ACMP0_O@GPC_MFPL', 'EADC0_ST:SYS_GPC_MFPL_PC1MFP_EADC0_ST@GPC_MFPL'] },
	{ f: ['PC.2', 'GPIO:SYS_GPC_MFPL_PC2MFP_GPIO@GPC_MFPL', 'SPI1_MOSI:SYS_GPC_MFPL_PC2MFP_SPI1_MOSI@GPC_MFPL', 'UART2_nCTS:SYS_GPC_MFPL_PC2MFP_UART2_nCTS@GPC_MFPL', 'I2C0_SMBSUS:SYS_GPC_MFPL_PC2MFP_I2C0_SMBSUS@GPC_MFPL', 'UART3_RXD:SYS_GPC_MFPL_PC2MFP_UART3_RXD@GPC_MFPL', 'EPWM1_CH3:SYS_GPC_MFPL_PC2MFP_EPWM1_CH3@GPC_MFPL'] },
	{ f: ['PC.3', 'GPIO:SYS_GPC_MFPL_PC3MFP_GPIO@GPC_MFPL', 'SPI1_MISO:SYS_GPC_MFPL_PC3MFP_SPI1_MISO@GPC_MFPL', 'UART2_nRTS:SYS_GPC_MFPL_PC3MFP_UART2_nRTS@GPC_MFPL', 'I2C0_SMBAL:SYS_GPC_MFPL_PC3MFP_I2C0_SMBAL@GPC_MFPL', 'UART3_TXD:SYS_GPC_MFPL_PC3MFP_UART3_TXD@GPC_MFPL', 'EPWM1_CH2:SYS_GPC_MFPL_PC3MFP_EPWM1_CH2@GPC_MFPL'] },
	{ f: ['PC.4', 'GPIO:SYS_GPC_MFPL_PC4MFP_GPIO@GPC_MFPL', 'SPI1_I2SMCLK:SYS_GPC_MFPL_PC4MFP_SPI1_I2SMCLK@GPC_MFPL', 'UART2_RXD:SYS_GPC_MFPL_PC4MFP_UART2_RXD@GPC_MFPL', 'I2C1_SDA:SYS_GPC_MFPL_PC4MFP_I2C1_SDA@GPC_MFPL', 'UART4_RXD:SYS_GPC_MFPL_PC4MFP_UART4_RXD@GPC_MFPL', 'EPWM1_CH1:SYS_GPC_MFPL_PC4MFP_EPWM1_CH1@GPC_MFPL'] },
	{ f: ['PC.5', 'GPIO:SYS_GPC_MFPL_PC5MFP_GPIO@GPC_MFPL', 'UART2_TXD:SYS_GPC_MFPL_PC5MFP_UART2_TXD@GPC_MFPL', 'I2C1_SCL:SYS_GPC_MFPL_PC5MFP_I2C1_SCL@GPC_MFPL', 'UART4_TXD:SYS_GPC_MFPL_PC5MFP_UART4_TXD@GPC_MFPL', 'EPWM1_CH0:SYS_GPC_MFPL_PC5MFP_EPWM1_CH0@GPC_MFPL'] },
	{ f: ['PC.6', 'GPIO:SYS_GPC_MFPL_PC6MFP_GPIO@GPC_MFPL', 'SPI1_MOSI:SYS_GPC_MFPL_PC6MFP_SPI1_MOSI@GPC_MFPL', 'UART4_RXD:SYS_GPC_MFPL_PC6MFP_UART4_RXD@GPC_MFPL', 'UART0_nRTS:SYS_GPC_MFPL_PC6MFP_UART0_nRTS@GPC_MFPL', 'I2C1_SMBSUS:SYS_GPC_MFPL_PC6MFP_I2C1_SMBSUS@GPC_MFPL', 'EPWM1_CH3:SYS_GPC_MFPL_PC6MFP_EPWM1_CH3@GPC_MFPL', 'BPWM1_CH1:SYS_GPC_MFPL_PC6MFP_BPWM1_CH1@GPC_MFPL', 'TRACE_DATA2:SYS_GPC_MFPL_PC6MFP_TRACE_DATA2@GPC_MFPL', 'TM1:SYS_GPC_MFPL_PC6MFP_TM1@GPC_MFPL', 'INT2:SYS_GPC_MFPL_PC6MFP_INT2@GPC_MFPL'] },
	{ f: ['PC.7', 'GPIO:SYS_GPC_MFPL_PC7MFP_GPIO@GPC_MFPL', 'SPI1_MISO:SYS_GPC_MFPL_PC7MFP_SPI1_MISO@GPC_MFPL', 'UART4_TXD:SYS_GPC_MFPL_PC7MFP_UART4_TXD@GPC_MFPL', 'UART0_nCTS:SYS_GPC_MFPL_PC7MFP_UART0_nCTS@GPC_MFPL', 'I2C1_SMBAL:SYS_GPC_MFPL_PC7MFP_I2C1_SMBAL@GPC_MFPL', 'EPWM1_CH2:SYS_GPC_MFPL_PC7MFP_EPWM1_CH2@GPC_MFPL', 'BPWM1_CH0:SYS_GPC_MFPL_PC7MFP_BPWM1_CH0@GPC_MFPL', 'TRACE_DATA3:SYS_GPC_MFPL_PC7MFP_TRACE_DATA3@GPC_MFPL', 'TM0:SYS_GPC_MFPL_PC7MFP_TM0@GPC_MFPL', 'INT3:SYS_GPC_MFPL_PC7MFP_INT3@GPC_MFPL'] },
	{ f: ['PC.8', 'GPIO:SYS_GPC_MFPH_PC8MFP_GPIO@GPC_MFPH', 'I2C0_SDA:SYS_GPC_MFPH_PC8MFP_I2C0_SDA@GPC_MFPH', 'UART4_nCTS:SYS_GPC_MFPH_PC8MFP_UART4_nCTS@GPC_MFPH', 'UART1_RXD:SYS_GPC_MFPH_PC8MFP_UART1_RXD@GPC_MFPH', 'EPWM1_CH1:SYS_GPC_MFPH_PC8MFP_EPWM1_CH1@GPC_MFPH', 'BPWM1_CH4:SYS_GPC_MFPH_PC8MFP_BPWM1_CH4@GPC_MFPH'] },
	{ f: ['PC.9', 'GPIO:SYS_GPC_MFPH_PC9MFP_GPIO@GPC_MFPH', 'UART3_RXD:SYS_GPC_MFPH_PC9MFP_UART3_RXD@GPC_MFPH', 'EPWM1_CH3:SYS_GPC_MFPH_PC9MFP_EPWM1_CH3@GPC_MFPH'] },
	{ f: ['PC.10', 'GPIO:SYS_GPC_MFPH_PC10MFP_GPIO@GPC_MFPH', 'UART3_TXD:SYS_GPC_MFPH_PC10MFP_UART3_TXD@GPC_MFPH', 'EPWM1_CH2:SYS_GPC_MFPH_PC10MFP_EPWM1_CH2@GPC_MFPH'] },
	{ f: ['PC.11', 'GPIO:SYS_GPC_MFPH_PC11MFP_GPIO@GPC_MFPH', 'UART0_RXD:SYS_GPC_MFPH_PC11MFP_UART0_RXD@GPC_MFPH', 'I2C0_SDA:SYS_GPC_MFPH_PC11MFP_I2C0_SDA@GPC_MFPH', 'EPWM1_CH1:SYS_GPC_MFPH_PC11MFP_EPWM1_CH1@GPC_MFPH', 'ACMP1_O:SYS_GPC_MFPH_PC11MFP_ACMP1_O@GPC_MFPH'] },
	{ f: ['PC.12', 'GPIO:SYS_GPC_MFPH_PC12MFP_GPIO@GPC_MFPH', 'UART0_TXD:SYS_GPC_MFPH_PC12MFP_UART0_TXD@GPC_MFPH', 'I2C0_SCL:SYS_GPC_MFPH_PC12MFP_I2C0_SCL@GPC_MFPH', 'EPWM1_CH0:SYS_GPC_MFPH_PC12MFP_EPWM1_CH0@GPC_MFPH', 'ACMP0_O:SYS_GPC_MFPH_PC12MFP_ACMP0_O@GPC_MFPH'] },
	{ f: ['PC.13', 'GPIO:SYS_GPC_MFPH_PC13MFP_GPIO@GPC_MFPH', 'EADC0_CH19:SYS_GPC_MFPH_PC13MFP_EADC0_CH19@GPC_MFPH', 'UART2_TXD:SYS_GPC_MFPH_PC13MFP_UART2_TXD@GPC_MFPH', 'BPWM0_CH4:SYS_GPC_MFPH_PC13MFP_BPWM0_CH4@GPC_MFPH', 'CLKO:SYS_GPC_MFPH_PC13MFP_CLKO@GPC_MFPH', 'EADC0_ST:SYS_GPC_MFPH_PC13MFP_EADC0_ST@GPC_MFPH'] },
	{ f: ['PC.14', 'GPIO:SYS_GPC_MFPH_PC14MFP_GPIO@GPC_MFPH', 'SPI0_I2SMCLK:SYS_GPC_MFPH_PC14MFP_SPI0_I2SMCLK@GPC_MFPH', 'CIR0_RXD:SYS_GPC_MFPH_PC14MFP_CIR0_RXD@GPC_MFPH', 'EPWM0_SYNC_IN:SYS_GPC_MFPH_PC14MFP_EPWM0_SYNC_IN@GPC_MFPH', 'TM1:SYS_GPC_MFPH_PC14MFP_TM1@GPC_MFPH'] },
	
	{ f: ['PD.0', 'GPIO:SYS_GPD_MFPL_PD0MFP_GPIO@GPD_MFPL', 'SPI0_MOSI:SYS_GPD_MFPL_PD0MFP_SPI0_MOSI@GPD_MFPL', 'UART3_RXD:SYS_GPD_MFPL_PD0MFP_UART3_RXD@GPD_MFPL', 'TM2:SYS_GPD_MFPL_PD0MFP_TM2@GPD_MFPL'] },
	{ f: ['PD.1', 'GPIO:SYS_GPD_MFPL_PD1MFP_GPIO@GPD_MFPL', 'SPI0_MISO:SYS_GPD_MFPL_PD1MFP_SPI0_MISO@GPD_MFPL', 'UART3_TXD:SYS_GPD_MFPL_PD1MFP_UART3_TXD@GPD_MFPL'] },
	{ f: ['PD.2', 'GPIO:SYS_GPD_MFPL_PD2MFP_GPIO@GPD_MFPL', 'SPI0_CLK:SYS_GPD_MFPL_PD2MFP_SPI0_CLK@GPD_MFPL', 'UART3_nCTS:SYS_GPD_MFPL_PD2MFP_UART3_nCTS@GPD_MFPL', 'UART0_RXD:SYS_GPD_MFPL_PD2MFP_UART0_RXD@GPD_MFPL'] },
	{ f: ['PD.3', 'GPIO:SYS_GPD_MFPL_PD3MFP_GPIO@GPD_MFPL', 'SPI0_SS:SYS_GPD_MFPL_PD3MFP_SPI0_SS@GPD_MFPL', 'UART3_nRTS:SYS_GPD_MFPL_PD3MFP_UART3_nRTS@GPD_MFPL', 'UART0_TXD:SYS_GPD_MFPL_PD3MFP_UART0_TXD@GPD_MFPL'] },
	{ f: ['PD.4', 'GPIO:SYS_GPD_MFPL_PD4MFP_GPIO@GPD_MFPL', 'I2C1_SDA:SYS_GPD_MFPL_PD4MFP_I2C1_SDA@GPD_MFPL', 'SPI1_SS:SYS_GPD_MFPL_PD4MFP_SPI1_SS@GPD_MFPL'] },
	{ f: ['PD.5', 'GPIO:SYS_GPD_MFPL_PD5MFP_GPIO@GPD_MFPL', 'I2C1_SCL:SYS_GPD_MFPL_PD5MFP_I2C1_SCL@GPD_MFPL', 'SPI1_CLK:SYS_GPD_MFPL_PD5MFP_SPI1_CLK@GPD_MFPL'] },
	{ f: ['PD.6', 'GPIO:SYS_GPD_MFPL_PD6MFP_GPIO@GPD_MFPL', 'UART1_RXD:SYS_GPD_MFPL_PD6MFP_UART1_RXD@GPD_MFPL', 'I2C0_SDA:SYS_GPD_MFPL_PD6MFP_I2C0_SDA@GPD_MFPL', 'SPI1_MOSI:SYS_GPD_MFPL_PD6MFP_SPI1_MOSI@GPD_MFPL'] },
	{ f: ['PD.7', 'GPIO:SYS_GPD_MFPL_PD7MFP_GPIO@GPD_MFPL', 'UART1_TXD:SYS_GPD_MFPL_PD7MFP_UART1_TXD@GPD_MFPL', 'I2C0_SCL:SYS_GPD_MFPL_PD7MFP_I2C0_SCL@GPD_MFPL', 'SPI1_MISO:SYS_GPD_MFPL_PD7MFP_SPI1_MISO@GPD_MFPL'] },
	{ f: ['PD.8', 'GPIO:SYS_GPD_MFPH_PD8MFP_GPIO@GPD_MFPH', 'UART2_nRTS:SYS_GPD_MFPH_PD8MFP_UART2_nRTS@GPD_MFPH'] },
	{ f: ['PD.9', 'GPIO:SYS_GPD_MFPH_PD9MFP_GPIO@GPD_MFPH', 'UART2_nCTS:SYS_GPD_MFPH_PD9MFP_UART2_nCTS@GPD_MFPH'] },
	{ f: ['PD.10', 'GPIO:SYS_GPD_MFPH_PD10MFP_GPIO@GPD_MFPH', 'EADC0_CH16:SYS_GPD_MFPH_PD10MFP_EADC0_CH16@GPD_MFPH', 'UART1_RXD:SYS_GPD_MFPH_PD10MFP_UART1_RXD@GPD_MFPH', 'INT7:SYS_GPD_MFPH_PD10MFP_INT7@GPD_MFPH'] },
	{ f: ['PD.11', 'GPIO:SYS_GPD_MFPH_PD11MFP_GPIO@GPD_MFPH', 'EADC0_CH17:SYS_GPD_MFPH_PD11MFP_EADC0_CH17@GPD_MFPH', 'UART1_TXD:SYS_GPD_MFPH_PD11MFP_UART1_TXD@GPD_MFPH', 'INT6:SYS_GPD_MFPH_PD11MFP_INT6@GPD_MFPH'] },
	{ f: ['PD.12', 'GPIO:SYS_GPD_MFPH_PD12MFP_GPIO@GPD_MFPH', 'EADC0_CH18:SYS_GPD_MFPH_PD12MFP_EADC0_CH18@GPD_MFPH', 'UART2_RXD:SYS_GPD_MFPH_PD12MFP_UART2_RXD@GPD_MFPH', 'BPWM0_CH5:SYS_GPD_MFPH_PD12MFP_BPWM0_CH5@GPD_MFPH', 'CLKO:SYS_GPD_MFPH_PD12MFP_CLKO@GPD_MFPH', 'EADC0_ST:SYS_GPD_MFPH_PD12MFP_EADC0_ST@GPD_MFPH', 'INT5:SYS_GPD_MFPH_PD12MFP_INT5@GPD_MFPH'] },
	{ f: ['PD.13', 'GPIO:SYS_GPD_MFPH_PD13MFP_GPIO@GPD_MFPH', 'SPI0_I2SMCLK:SYS_GPD_MFPH_PD13MFP_SPI0_I2SMCLK@GPD_MFPH', 'SPI1_I2SMCLK:SYS_GPD_MFPH_PD13MFP_SPI1_I2SMCLK@GPD_MFPH'] },
	{ f: ['PD.14', 'GPIO:SYS_GPD_MFPH_PD14MFP_GPIO@GPD_MFPH', 'SPI0_I2SMCLK:SYS_GPD_MFPH_PD14MFP_SPI0_I2SMCLK@GPD_MFPH', 'EPWM0_CH4:SYS_GPD_MFPH_PD14MFP_EPWM0_CH4@GPD_MFPH'] },
	{ f: ['PD.15', 'GPIO:SYS_GPD_MFPH_PD15MFP_GPIO@GPD_MFPH', 'EPWM0_CH5:SYS_GPD_MFPH_PD15MFP_EPWM0_CH5@GPD_MFPH', 'TRACE_CLK:SYS_GPD_MFPH_PD15MFP_TRACE_CLK@GPD_MFPH', 'TM3:SYS_GPD_MFPH_PD15MFP_TM3@GPD_MFPH', 'INT1:SYS_GPD_MFPH_PD15MFP_INT1@GPD_MFPH'] },
	
	{ f: ['PE.0', 'GPIO:SYS_GPE_MFPL_PE0MFP_GPIO@GPE_MFPL', 'SPI1_MOSI:SYS_GPE_MFPL_PE0MFP_SPI1_MOSI@GPE_MFPL', 'UART3_RXD:SYS_GPE_MFPL_PE0MFP_UART3_RXD@GPE_MFPL', 'I2C1_SDA:SYS_GPE_MFPL_PE0MFP_I2C1_SDA@GPE_MFPL', 'UART4_nRTS:SYS_GPE_MFPL_PE0MFP_UART4_nRTS@GPE_MFPL'] },
	{ f: ['PE.1', 'GPIO:SYS_GPE_MFPL_PE1MFP_GPIO@GPE_MFPL', 'SPI1_MISO:SYS_GPE_MFPL_PE1MFP_SPI1_MISO@GPE_MFPL', 'UART3_TXD:SYS_GPE_MFPL_PE1MFP_UART3_TXD@GPE_MFPL', 'I2C1_SCL:SYS_GPE_MFPL_PE1MFP_I2C1_SCL@GPE_MFPL', 'UART4_nCTS:SYS_GPE_MFPL_PE1MFP_UART4_nCTS@GPE_MFPL'] },
	{ f: ['PE.2', 'GPIO:SYS_GPE_MFPL_PE2MFP_GPIO@GPE_MFPL', 'EPWM0_CH5:SYS_GPE_MFPL_PE2MFP_EPWM0_CH5@GPE_MFPL', 'BPWM0_CH0:SYS_GPE_MFPL_PE2MFP_BPWM0_CH0@GPE_MFPL'] },
	{ f: ['PE.3', 'GPIO:SYS_GPE_MFPL_PE3MFP_GPIO@GPE_MFPL', 'EPWM0_CH4:SYS_GPE_MFPL_PE3MFP_EPWM0_CH4@GPE_MFPL', 'BPWM0_CH1:SYS_GPE_MFPL_PE3MFP_BPWM0_CH1@GPE_MFPL'] },
	{ f: ['PE.4', 'GPIO:SYS_GPE_MFPL_PE4MFP_GPIO@GPE_MFPL', 'EPWM0_CH3:SYS_GPE_MFPL_PE4MFP_EPWM0_CH3@GPE_MFPL', 'BPWM0_CH2:SYS_GPE_MFPL_PE4MFP_BPWM0_CH2@GPE_MFPL'] },
	{ f: ['PE.5', 'GPIO:SYS_GPE_MFPL_PE5MFP_GPIO@GPE_MFPL', 'EPWM0_CH2:SYS_GPE_MFPL_PE5MFP_EPWM0_CH2@GPE_MFPL', 'BPWM0_CH3:SYS_GPE_MFPL_PE5MFP_BPWM0_CH3@GPE_MFPL'] },
	{ f: ['PE.6', 'GPIO:SYS_GPE_MFPL_PE6MFP_GPIO@GPE_MFPL', 'UART5_RXD:SYS_GPE_MFPL_PE6MFP_UART5_RXD@GPE_MFPL', 'EPWM0_CH1:SYS_GPE_MFPL_PE6MFP_EPWM0_CH1@GPE_MFPL', 'BPWM0_CH4:SYS_GPE_MFPL_PE6MFP_BPWM0_CH4@GPE_MFPL'] },
	{ f: ['PE.7', 'GPIO:SYS_GPE_MFPL_PE7MFP_GPIO@GPE_MFPL', 'UART5_TXD:SYS_GPE_MFPL_PE7MFP_UART5_TXD@GPE_MFPL', 'EPWM0_CH0:SYS_GPE_MFPL_PE7MFP_EPWM0_CH0@GPE_MFPL', 'BPWM0_CH5:SYS_GPE_MFPL_PE7MFP_BPWM0_CH5@GPE_MFPL'] },
	{ f: ['PE.8', 'GPIO:SYS_GPE_MFPH_PE8MFP_GPIO@GPE_MFPH', 'UART2_TXD:SYS_GPE_MFPH_PE8MFP_UART2_TXD@GPE_MFPH', 'EPWM0_CH0:SYS_GPE_MFPH_PE8MFP_EPWM0_CH0@GPE_MFPH', 'EPWM0_BRAKE0:SYS_GPE_MFPH_PE8MFP_EPWM0_BRAKE0@GPE_MFPH', 'TRACE_DATA3:SYS_GPE_MFPH_PE8MFP_TRACE_DATA3@GPE_MFPH'] },
	{ f: ['PE.9', 'GPIO:SYS_GPE_MFPH_PE9MFP_GPIO@GPE_MFPH', 'UART2_RXD:SYS_GPE_MFPH_PE9MFP_UART2_RXD@GPE_MFPH', 'EPWM0_CH1:SYS_GPE_MFPH_PE9MFP_EPWM0_CH1@GPE_MFPH', 'EPWM0_BRAKE1:SYS_GPE_MFPH_PE9MFP_EPWM0_BRAKE1@GPE_MFPH', 'TRACE_DATA2:SYS_GPE_MFPH_PE9MFP_TRACE_DATA2@GPE_MFPH'] },
	{ f: ['PE.10', 'GPIO:SYS_GPE_MFPH_PE10MFP_GPIO@GPE_MFPH', 'UART3_TXD:SYS_GPE_MFPH_PE10MFP_UART3_TXD@GPE_MFPH', 'EPWM0_CH2:SYS_GPE_MFPH_PE10MFP_EPWM0_CH2@GPE_MFPH', 'EPWM1_BRAKE0:SYS_GPE_MFPH_PE10MFP_EPWM1_BRAKE0@GPE_MFPH', 'TRACE_DATA1:SYS_GPE_MFPH_PE10MFP_TRACE_DATA1@GPE_MFPH'] },
	{ f: ['PE.11', 'GPIO:SYS_GPE_MFPH_PE11MFP_GPIO@GPE_MFPH', 'UART3_RXD:SYS_GPE_MFPH_PE11MFP_UART3_RXD@GPE_MFPH', 'UART1_nCTS:SYS_GPE_MFPH_PE11MFP_UART1_nCTS@GPE_MFPH', 'EPWM0_CH3:SYS_GPE_MFPH_PE11MFP_EPWM0_CH3@GPE_MFPH', 'EPWM1_BRAKE1:SYS_GPE_MFPH_PE11MFP_EPWM1_BRAKE1@GPE_MFPH', 'TRACE_DATA0:SYS_GPE_MFPH_PE11MFP_TRACE_DATA0@GPE_MFPH'] },
	{ f: ['PE.12', 'GPIO:SYS_GPE_MFPH_PE12MFP_GPIO@GPE_MFPH', 'UART1_nRTS:SYS_GPE_MFPH_PE12MFP_UART1_nRTS@GPE_MFPH', 'EPWM0_CH4:SYS_GPE_MFPH_PE12MFP_EPWM0_CH4@GPE_MFPH', 'TRACE_CLK:SYS_GPE_MFPH_PE12MFP_TRACE_CLK@GPE_MFPH'] },
	{ f: ['PE.13', 'GPIO:SYS_GPE_MFPH_PE13MFP_GPIO@GPE_MFPH', 'I2C0_SCL:SYS_GPE_MFPH_PE13MFP_I2C0_SCL@GPE_MFPH', 'UART4_nRTS:SYS_GPE_MFPH_PE13MFP_UART4_nRTS@GPE_MFPH', 'UART1_TXD:SYS_GPE_MFPH_PE13MFP_UART1_TXD@GPE_MFPH', 'EPWM0_CH5:SYS_GPE_MFPH_PE13MFP_EPWM0_CH5@GPE_MFPH', 'EPWM1_CH0:SYS_GPE_MFPH_PE13MFP_EPWM1_CH0@GPE_MFPH', 'BPWM1_CH5:SYS_GPE_MFPH_PE13MFP_BPWM1_CH5@GPE_MFPH'] },
	{ f: ['PE.14', 'GPIO:SYS_GPE_MFPH_PE14MFP_GPIO@GPE_MFPH', 'UART2_TXD:SYS_GPE_MFPH_PE14MFP_UART2_TXD@GPE_MFPH'] },
	{ f: ['PE.15', 'GPIO:SYS_GPE_MFPH_PE15MFP_GPIO@GPE_MFPH', 'UART2_RXD:SYS_GPE_MFPH_PE15MFP_UART2_RXD@GPE_MFPH'] },
	
	{ f: ['PF.0', 'GPIO:SYS_GPF_MFPL_PF0MFP_GPIO@GPF_MFPL', 'UART1_TXD:SYS_GPF_MFPL_PF0MFP_UART1_TXD@GPF_MFPL', 'I2C1_SCL:SYS_GPF_MFPL_PF0MFP_I2C1_SCL@GPF_MFPL', 'UART0_TXD:SYS_GPF_MFPL_PF0MFP_UART0_TXD@GPF_MFPL', 'BPWM1_CH0:SYS_GPF_MFPL_PF0MFP_BPWM1_CH0@GPF_MFPL', 'ICE_DAT:SYS_GPF_MFPL_PF0MFP_ICE_DAT@GPF_MFPL'] },
	{ f: ['PF.1', 'GPIO:SYS_GPF_MFPL_PF1MFP_GPIO@GPF_MFPL', 'UART1_RXD:SYS_GPF_MFPL_PF1MFP_UART1_RXD@GPF_MFPL', 'I2C1_SDA:SYS_GPF_MFPL_PF1MFP_I2C1_SDA@GPF_MFPL', 'UART0_RXD:SYS_GPF_MFPL_PF1MFP_UART0_RXD@GPF_MFPL', 'BPWM1_CH1:SYS_GPF_MFPL_PF1MFP_BPWM1_CH1@GPF_MFPL', 'ICE_CLK:SYS_GPF_MFPL_PF1MFP_ICE_CLK@GPF_MFPL'] },
	{ f: ['PF.2', 'GPIO:SYS_GPF_MFPL_PF2MFP_GPIO@GPF_MFPL', 'UART0_RXD:SYS_GPF_MFPL_PF2MFP_UART0_RXD@GPF_MFPL', 'I2C0_SDA:SYS_GPF_MFPL_PF2MFP_I2C0_SDA@GPF_MFPL', 'XT1_OUT:SYS_GPF_MFPL_PF2MFP_XT1_OUT@GPF_MFPL', 'BPWM1_CH1:SYS_GPF_MFPL_PF2MFP_BPWM1_CH1@GPF_MFPL'] },
	{ f: ['PF.3', 'GPIO:SYS_GPF_MFPL_PF3MFP_GPIO@GPF_MFPL', 'UART0_TXD:SYS_GPF_MFPL_PF3MFP_UART0_TXD@GPF_MFPL', 'I2C0_SCL:SYS_GPF_MFPL_PF3MFP_I2C0_SCL@GPF_MFPL', 'XT1_IN:SYS_GPF_MFPL_PF3MFP_XT1_IN@GPF_MFPL', 'BPWM1_CH0:SYS_GPF_MFPL_PF3MFP_BPWM1_CH0@GPF_MFPL'] },
	{ f: ['PF.4', 'GPIO:SYS_GPF_MFPL_PF4MFP_GPIO@GPF_MFPL', 'UART2_TXD:SYS_GPF_MFPL_PF4MFP_UART2_TXD@GPF_MFPL', 'UART2_nRTS:SYS_GPF_MFPL_PF4MFP_UART2_nRTS@GPF_MFPL', 'EPWM0_CH1:SYS_GPF_MFPL_PF4MFP_EPWM0_CH1@GPF_MFPL', 'BPWM0_CH5:SYS_GPF_MFPL_PF4MFP_BPWM0_CH5@GPF_MFPL', 'X32_OUT:SYS_GPF_MFPL_PF4MFP_X32_OUT@GPF_MFPL'] },
	{ f: ['PF.5', 'GPIO:SYS_GPF_MFPL_PF5MFP_GPIO@GPF_MFPL', 'UART2_RXD:SYS_GPF_MFPL_PF5MFP_UART2_RXD@GPF_MFPL', 'UART2_nCTS:SYS_GPF_MFPL_PF5MFP_UART2_nCTS@GPF_MFPL', 'EPWM0_CH0:SYS_GPF_MFPL_PF5MFP_EPWM0_CH0@GPF_MFPL', 'BPWM0_CH4:SYS_GPF_MFPL_PF5MFP_BPWM0_CH4@GPF_MFPL', 'EPWM0_SYNC_OUT:SYS_GPF_MFPL_PF5MFP_EPWM0_SYNC_OUT@GPF_MFPL', 'X32_IN:SYS_GPF_MFPL_PF5MFP_X32_IN@GPF_MFPL', 'EADC0_ST:SYS_GPF_MFPL_PF5MFP_EADC0_ST@GPF_MFPL'] },
	{ f: ['PF.6', 'GPIO:SYS_GPF_MFPL_PF6MFP_GPIO@GPF_MFPL', 'SPI0_MOSI:SYS_GPF_MFPL_PF6MFP_SPI0_MOSI@GPF_MFPL', 'UART4_RXD:SYS_GPF_MFPL_PF6MFP_UART4_RXD@GPF_MFPL'] },
	{ f: ['PF.7', 'GPIO:SYS_GPF_MFPL_PF7MFP_GPIO@GPF_MFPL', 'SPI0_MISO:SYS_GPF_MFPL_PF7MFP_SPI0_MISO@GPF_MFPL', 'UART4_TXD:SYS_GPF_MFPL_PF7MFP_UART4_TXD@GPF_MFPL'] },
	{ f: ['PF.8', 'GPIO:SYS_GPF_MFPH_PF8MFP_GPIO@GPF_MFPH', 'SPI0_CLK:SYS_GPF_MFPH_PF8MFP_SPI0_CLK@GPF_MFPH', 'UART5_nCTS:SYS_GPF_MFPH_PF8MFP_UART5_nCTS@GPF_MFPH'] },
	{ f: ['PF.9', 'GPIO:SYS_GPF_MFPH_PF9MFP_GPIO@GPF_MFPH', 'SPI0_SS:SYS_GPF_MFPH_PF9MFP_SPI0_SS@GPF_MFPH', 'UART5_nRTS:SYS_GPF_MFPH_PF9MFP_UART5_nRTS@GPF_MFPH'] },
	{ f: ['PF.10', 'GPIO:SYS_GPF_MFPH_PF10MFP_GPIO@GPF_MFPH', 'SPI0_I2SMCLK:SYS_GPF_MFPH_PF10MFP_SPI0_I2SMCLK@GPF_MFPH', 'UART5_RXD:SYS_GPF_MFPH_PF10MFP_UART5_RXD@GPF_MFPH'] },
	{ f: ['PF.11', 'GPIO:SYS_GPF_MFPH_PF11MFP_GPIO@GPF_MFPH', 'UART5_TXD:SYS_GPF_MFPH_PF11MFP_UART5_TXD@GPF_MFPH', 'TM3:SYS_GPF_MFPH_PF11MFP_TM3@GPF_MFPH'] },
	{ f: ['PF.12', 'GPIO:SYS_GPF_MFPH_PF12MFP_GPIO@GPF_MFPH', 'I2C0_SCL:SYS_GPF_MFPH_PF12MFP_I2C0_SCL@GPF_MFPH', 'UART5_TXD:SYS_GPF_MFPH_PF12MFP_UART5_TXD@GPF_MFPH', 'UART3_TXD:SYS_GPF_MFPH_PF12MFP_UART3_TXD@GPF_MFPH', 'UART1_TXD:SYS_GPF_MFPH_PF12MFP_UART1_TXD@GPF_MFPH', 'I2C1_SCL:SYS_GPF_MFPH_PF12MFP_I2C1_SCL@GPF_MFPH', 'EPWM0_CH2:SYS_GPF_MFPH_PF12MFP_EPWM0_CH2@GPF_MFPH', 'BPWM0_CH0:SYS_GPF_MFPH_PF12MFP_BPWM0_CH0@GPF_MFPH', 'TRACE_DATA1:SYS_GPF_MFPH_PF12MFP_TRACE_DATA1@GPF_MFPH', 'CIR0_RXD:SYS_GPF_MFPH_PF12MFP_CIR0_RXD@GPF_MFPH'] },
	{ f: ['PF.13', 'GPIO:SYS_GPF_MFPH_PF13MFP_GPIO@GPF_MFPH', 'I2C0_SDA:SYS_GPF_MFPH_PF13MFP_I2C0_SDA@GPF_MFPH', 'UART5_RXD:SYS_GPF_MFPH_PF13MFP_UART5_RXD@GPF_MFPH', 'UART3_RXD:SYS_GPF_MFPH_PF13MFP_UART3_RXD@GPF_MFPH', 'UART1_RXD:SYS_GPF_MFPH_PF13MFP_UART1_RXD@GPF_MFPH', 'I2C1_SDA:SYS_GPF_MFPH_PF13MFP_I2C1_SDA@GPF_MFPH', 'EPWM0_CH3:SYS_GPF_MFPH_PF13MFP_EPWM0_CH3@GPF_MFPH', 'BPWM0_CH1:SYS_GPF_MFPH_PF13MFP_BPWM0_CH1@GPF_MFPH', 'TRACE_DATA0:SYS_GPF_MFPH_PF13MFP_TRACE_DATA0@GPF_MFPH'] },
	{ f: ['PF.14', 'GPIO:SYS_GPF_MFPH_PF14MFP_GPIO@GPF_MFPH', 'EPWM1_BRAKE0:SYS_GPF_MFPH_PF14MFP_EPWM1_BRAKE0@GPF_MFPH', 'EPWM0_BRAKE0:SYS_GPF_MFPH_PF14MFP_EPWM0_BRAKE0@GPF_MFPH', 'EPWM0_CH4:SYS_GPF_MFPH_PF14MFP_EPWM0_CH4@GPF_MFPH', 'CLKO:SYS_GPF_MFPH_PF14MFP_CLKO@GPF_MFPH', 'TM3:SYS_GPF_MFPH_PF14MFP_TM3@GPF_MFPH', 'INT5:SYS_GPF_MFPH_PF14MFP_INT5@GPF_MFPH'] },
	{ f: ['PF.15', 'GPIO:SYS_GPF_MFPH_PF15MFP_GPIO@GPF_MFPH', 'EPWM0_BRAKE0:SYS_GPF_MFPH_PF15MFP_EPWM0_BRAKE0@GPF_MFPH', 'EPWM0_CH1:SYS_GPF_MFPH_PF15MFP_EPWM0_CH1@GPF_MFPH', 'TM2:SYS_GPF_MFPH_PF15MFP_TM2@GPF_MFPH', 'CLKO:SYS_GPF_MFPH_PF15MFP_CLKO@GPF_MFPH', 'INT4:SYS_GPF_MFPH_PF15MFP_INT4@GPF_MFPH'] },
	
	{ f: ['PG.2', 'GPIO:SYS_GPG_MFPL_PG2MFP_GPIO@GPG_MFPL', 'I2C0_SMBAL:SYS_GPG_MFPL_PG2MFP_I2C0_SMBAL@GPG_MFPL', 'I2C1_SCL:SYS_GPG_MFPL_PG2MFP_I2C1_SCL@GPG_MFPL', 'TM0:SYS_GPG_MFPL_PG2MFP_TM0@GPG_MFPL'] },
	{ f: ['PG.3', 'GPIO:SYS_GPG_MFPL_PG3MFP_GPIO@GPG_MFPL', 'I2C0_SMBSUS:SYS_GPG_MFPL_PG3MFP_I2C0_SMBSUS@GPG_MFPL', 'I2C1_SDA:SYS_GPG_MFPL_PG3MFP_I2C1_SDA@GPG_MFPL', 'TM1:SYS_GPG_MFPL_PG3MFP_TM1@GPG_MFPL'] },
	{ f: ['PG.4', 'GPIO:SYS_GPG_MFPL_PG4MFP_GPIO@GPG_MFPL', 'TM2:SYS_GPG_MFPL_PG4MFP_TM2@GPG_MFPL'] },
	{ f: ['PG.9', 'GPIO:SYS_GPG_MFPH_PG9MFP_GPIO@GPG_MFPH', 'BPWM0_CH5:SYS_GPG_MFPH_PG9MFP_BPWM0_CH5@GPG_MFPH'] },
	{ f: ['PG.10', 'GPIO:SYS_GPG_MFPH_PG10MFP_GPIO@GPG_MFPH', 'BPWM0_CH4:SYS_GPG_MFPH_PG10MFP_BPWM0_CH4@GPG_MFPH'] },
	{ f: ['PG.11', 'GPIO:SYS_GPG_MFPH_PG11MFP_GPIO@GPG_MFPH', 'BPWM0_CH3:SYS_GPG_MFPH_PG11MFP_BPWM0_CH3@GPG_MFPH'] },
	{ f: ['PG.12', 'GPIO:SYS_GPG_MFPH_PG12MFP_GPIO@GPG_MFPH', 'BPWM0_CH2:SYS_GPG_MFPH_PG12MFP_BPWM0_CH2@GPG_MFPH'] },
	{ f: ['PG.13', 'GPIO:SYS_GPG_MFPH_PG13MFP_GPIO@GPG_MFPH', 'BPWM0_CH1:SYS_GPG_MFPH_PG13MFP_BPWM0_CH1@GPG_MFPH'] },
	{ f: ['PG.14', 'GPIO:SYS_GPG_MFPH_PG14MFP_GPIO@GPG_MFPH', 'BPWM0_CH0:SYS_GPG_MFPH_PG14MFP_BPWM0_CH0@GPG_MFPH'] },
	{ f: ['PG.15', 'GPIO:SYS_GPG_MFPH_PG15MFP_GPIO@GPG_MFPH', 'CLKO:SYS_GPG_MFPH_PG15MFP_CLKO@GPG_MFPH', 'EADC0_ST:SYS_GPG_MFPH_PG15MFP_EADC0_ST@GPG_MFPH'] },
	
	{ f: ['PH.4', 'GPIO:SYS_GPH_MFPL_PH4MFP_GPIO@GPH_MFPL', 'SPI1_MISO:SYS_GPH_MFPL_PH4MFP_SPI1_MISO@GPH_MFPL'] },
	{ f: ['PH.5', 'GPIO:SYS_GPH_MFPL_PH5MFP_GPIO@GPH_MFPL', 'SPI1_MOSI:SYS_GPH_MFPL_PH5MFP_SPI1_MOSI@GPH_MFPL'] },
	{ f: ['PH.6', 'GPIO:SYS_GPH_MFPL_PH6MFP_GPIO@GPH_MFPL', 'SPI1_CLK:SYS_GPH_MFPL_PH6MFP_SPI1_CLK@GPH_MFPL'] },
	{ f: ['PH.7', 'GPIO:SYS_GPH_MFPL_PH7MFP_GPIO@GPH_MFPL', 'SPI1_SS:SYS_GPH_MFPL_PH7MFP_SPI1_SS@GPH_MFPL'] },
	{ f: ['PH.8', 'GPIO:SYS_GPH_MFPH_PH8MFP_GPIO@GPH_MFPH', 'SPI1_CLK:SYS_GPH_MFPH_PH8MFP_SPI1_CLK@GPH_MFPH', 'UART3_nRTS:SYS_GPH_MFPH_PH8MFP_UART3_nRTS@GPH_MFPH', 'I2C1_SMBAL:SYS_GPH_MFPH_PH8MFP_I2C1_SMBAL@GPH_MFPH', 'UART1_TXD:SYS_GPH_MFPH_PH8MFP_UART1_TXD@GPH_MFPH'] },
	{ f: ['PH.9', 'GPIO:SYS_GPH_MFPH_PH9MFP_GPIO@GPH_MFPH', 'SPI1_SS:SYS_GPH_MFPH_PH9MFP_SPI1_SS@GPH_MFPH', 'UART3_nCTS:SYS_GPH_MFPH_PH9MFP_UART3_nCTS@GPH_MFPH', 'I2C1_SMBSUS:SYS_GPH_MFPH_PH9MFP_I2C1_SMBSUS@GPH_MFPH', 'UART1_RXD:SYS_GPH_MFPH_PH9MFP_UART1_RXD@GPH_MFPH'] },
	{ f: ['PH.10', 'GPIO:SYS_GPH_MFPH_PH10MFP_GPIO@GPH_MFPH', 'SPI1_I2SMCLK:SYS_GPH_MFPH_PH10MFP_SPI1_I2SMCLK@GPH_MFPH', 'UART4_TXD:SYS_GPH_MFPH_PH10MFP_UART4_TXD@GPH_MFPH', 'UART0_TXD:SYS_GPH_MFPH_PH10MFP_UART0_TXD@GPH_MFPH'] },
	{ f: ['PH.11', 'GPIO:SYS_GPH_MFPH_PH11MFP_GPIO@GPH_MFPH', 'UART4_RXD:SYS_GPH_MFPH_PH11MFP_UART4_RXD@GPH_MFPH', 'UART0_RXD:SYS_GPH_MFPH_PH11MFP_UART0_RXD@GPH_MFPH', 'EPWM0_CH5:SYS_GPH_MFPH_PH11MFP_EPWM0_CH5@GPH_MFPH'] },
	
	{ f: ['PI.0', 'GPIO:SYS_GPI_MFPL_PI0MFP_GPIO@GPI_MFPL', 'UART0_TXD:SYS_GPI_MFPL_PI0MFP_UART0_TXD@GPI_MFPL', 'I2C0_SCL:SYS_GPI_MFPL_PI0MFP_I2C0_SCL@GPI_MFPL', 'UART5_TXD:SYS_GPI_MFPL_PI0MFP_UART5_TXD@GPI_MFPL', 'UART2_TXD:SYS_GPI_MFPL_PI0MFP_UART2_TXD@GPI_MFPL', 'I2C1_SCL:SYS_GPI_MFPL_PI0MFP_I2C1_SCL@GPI_MFPL', 'EPWM0_CH4:SYS_GPI_MFPL_PI0MFP_EPWM0_CH4@GPI_MFPL', 'EPWM1_CH0:SYS_GPI_MFPL_PI0MFP_EPWM1_CH0@GPI_MFPL', 'ACMP0_O:SYS_GPI_MFPL_PI0MFP_ACMP0_O@GPI_MFPL'] },
	{ f: ['PI.1', 'GPIO:SYS_GPI_MFPL_PI1MFP_GPIO@GPI_MFPL', 'UART0_RXD:SYS_GPI_MFPL_PI1MFP_UART0_RXD@GPI_MFPL', 'I2C0_SDA:SYS_GPI_MFPL_PI1MFP_I2C0_SDA@GPI_MFPL', 'UART5_RXD:SYS_GPI_MFPL_PI1MFP_UART5_RXD@GPI_MFPL', 'UART2_RXD:SYS_GPI_MFPL_PI1MFP_UART2_RXD@GPI_MFPL', 'I2C1_SDA:SYS_GPI_MFPL_PI1MFP_I2C1_SDA@GPI_MFPL', 'EPWM0_CH5:SYS_GPI_MFPL_PI1MFP_EPWM0_CH5@GPI_MFPL', 'EPWM1_CH1:SYS_GPI_MFPL_PI1MFP_EPWM1_CH1@GPI_MFPL', 'ACMP1_O:SYS_GPI_MFPL_PI1MFP_ACMP1_O@GPI_MFPL'] },
	{ f: ['PI.2', 'GPIO:SYS_GPI_MFPL_PI2MFP_GPIO@GPI_MFPL', 'UART1_TXD:SYS_GPI_MFPL_PI2MFP_UART1_TXD@GPI_MFPL', 'I2C0_SCL:SYS_GPI_MFPL_PI2MFP_I2C0_SCL@GPI_MFPL', 'UART5_TXD:SYS_GPI_MFPL_PI2MFP_UART5_TXD@GPI_MFPL', 'I2C1_SCL:SYS_GPI_MFPL_PI2MFP_I2C1_SCL@GPI_MFPL', 'UART4_TXD:SYS_GPI_MFPL_PI2MFP_UART4_TXD@GPI_MFPL', 'BPWM0_CH5:SYS_GPI_MFPL_PI2MFP_BPWM0_CH5@GPI_MFPL', 'EADC0_ST:SYS_GPI_MFPL_PI2MFP_EADC0_ST@GPI_MFPL'] },
	{ f: ['PI.3', 'GPIO:SYS_GPI_MFPL_PI3MFP_GPIO@GPI_MFPL', 'UART1_RXD:SYS_GPI_MFPL_PI3MFP_UART1_RXD@GPI_MFPL', 'I2C0_SDA:SYS_GPI_MFPL_PI3MFP_I2C0_SDA@GPI_MFPL', 'UART5_RXD:SYS_GPI_MFPL_PI3MFP_UART5_RXD@GPI_MFPL', 'I2C1_SDA:SYS_GPI_MFPL_PI3MFP_I2C1_SDA@GPI_MFPL', 'UART4_RXD:SYS_GPI_MFPL_PI3MFP_UART4_RXD@GPI_MFPL', 'BPWM0_CH4:SYS_GPI_MFPL_PI3MFP_BPWM0_CH4@GPI_MFPL'] },
	{ f: ['PI.4', 'GPIO:SYS_GPI_MFPL_PI4MFP_GPIO@GPI_MFPL', 'UART4_TXD:SYS_GPI_MFPL_PI4MFP_UART4_TXD@GPI_MFPL', 'UART0_TXD:SYS_GPI_MFPL_PI4MFP_UART0_TXD@GPI_MFPL', 'UART1_TXD:SYS_GPI_MFPL_PI4MFP_UART1_TXD@GPI_MFPL', 'EPWM0_CH5:SYS_GPI_MFPL_PI4MFP_EPWM0_CH5@GPI_MFPL', 'CIR0_RXD:SYS_GPI_MFPL_PI4MFP_CIR0_RXD@GPI_MFPL', 'ACMP0_O:SYS_GPI_MFPL_PI4MFP_ACMP0_O@GPI_MFPL'] },
	{ f: ['PI.5', 'GPIO:SYS_GPI_MFPL_PI5MFP_GPIO@GPI_MFPL', 'UART4_RXD:SYS_GPI_MFPL_PI5MFP_UART4_RXD@GPI_MFPL', 'UART0_RXD:SYS_GPI_MFPL_PI5MFP_UART0_RXD@GPI_MFPL', 'UART1_RXD:SYS_GPI_MFPL_PI5MFP_UART1_RXD@GPI_MFPL', 'EPWM0_CH4:SYS_GPI_MFPL_PI5MFP_EPWM0_CH4@GPI_MFPL', 'ACMP1_O:SYS_GPI_MFPL_PI5MFP_ACMP1_O@GPI_MFPL'] }
];

NUTOOL_PIN.g_cfg_gpiosDescriptions = [
	'ACMP0_N:Analog comparator 0 negative input  pin',
	'ACMP0_O:Analog comparator 0 output pin',
	'ACMP0_P0:Analog comparator 0 positive input 0 pin',
	'ACMP0_P1:Analog comparator 0 positive input 1 pin',
	'ACMP0_P2:Analog comparator 0 positive input 2 pin',
	'ACMP0_P3:Analog comparator 0 positive input 3 pin',
	'ACMP0_WLAT:Analog comparator 0 window latch input pin',
	'ACMP1_N:Analog comparator 1 negative input  pin',
	'ACMP1_O:Analog comparator 1 output pin',
	'ACMP1_P0:Analog comparator 1 positive input 0 pin',
	'ACMP1_P1:Analog comparator 1 positive input 1 pin',
	'ACMP1_P2:Analog comparator 1 positive input 2 pin',
	'ACMP1_P3:Analog comparator 1 positive input 3 pin',
	'ACMP1_WLAT:Analog comparator 1 window latch input pin',
	'BPWM0_CH0:BPWM0 channel 0 output/capture input',
	'BPWM0_CH1:BPWM0 channel 1 output/capture input',
	'BPWM0_CH2:BPWM0 channel 2 output/capture input',
	'BPWM0_CH3:BPWM0 channel 3 output/capture input',
	'BPWM0_CH4:BPWM0 channel 4 output/capture input',
	'BPWM0_CH5:BPWM0 channel 5 output/capture input',
	'BPWM1_CH0:BPWM1 channel 0 output/capture input',
	'BPWM1_CH1:BPWM1 channel 1 output/capture input',
	'BPWM1_CH2:BPWM1 channel 2 output/capture input',
	'BPWM1_CH3:BPWM1 channel 3 output/capture input',
	'BPWM1_CH4:BPWM1 channel 4 output/capture input',
	'BPWM1_CH5:BPWM1 channel 5 output/capture input',
	'CIR0_RXD:CIR0 data receiver input pin',
	'CLKO:Clock Out',
	'DAC0_OUT:DAC0 channel  analog output',
	'DAC0_ST:DAC0 external trigger input',
	'EADC0_CH0:EADC0 channel 0 analog input',
	'EADC0_CH1:EADC0 channel 1 analog input',
	'EADC0_CH2:EADC0 channel 2 analog input',
	'EADC0_CH3:EADC0 channel 3 analog input',
	'EADC0_CH4:EADC0 channel 4 analog input',
	'EADC0_CH5:EADC0 channel 5 analog input',
	'EADC0_CH6:EADC0 channel 6 analog input',
	'EADC0_CH7:EADC0 channel 7 analog input',
	'EADC0_CH8:EADC0 channel 8 analog input',
	'EADC0_CH9:EADC0 channel 9 analog input',
	'EADC0_CH10:EADC0 channel 10 analog input',
	'EADC0_CH11:EADC0 channel 11 analog input',
	'EADC0_CH12:EADC0 channel 12 analog input',
	'EADC0_CH13:EADC0 channel 13 analog input',
	'EADC0_CH14:EADC0 channel 14 analog input',
	'EADC0_CH15:EADC0 channel 15 analog input',
	'EADC0_CH16:EADC0 channel 16 analog input',
	'EADC0_CH17:EADC0 channel 17 analog input',
	'EADC0_CH18:EADC0 channel 18 analog input',
	'EADC0_CH19:EADC0 channel 19 analog input',
	'EADC0_CH20:EADC0 channel 20 analog input',
	'EADC0_CH21:EADC0 channel 21 analog input',
	'EADC0_CH22:EADC0 channel 22 analog input',
	'EADC0_CH23:EADC0 channel 23 analog input',
	'EADC0_ST:EADC0 external trigger input',
	'EPWM0_BRAKE0:EPWM0 Brake 0 input pin',
	'EPWM0_BRAKE1:EPWM0 Brake 1 input pin',
	'EPWM0_CH0:EPWM0 channel 0 output/capture input',
	'EPWM0_CH1:EPWM0 channel 1 output/capture input',
	'EPWM0_CH2:EPWM0 channel 2 output/capture input',
	'EPWM0_CH3:EPWM0 channel 3 output/capture input',
	'EPWM0_CH4:EPWM0 channel 4 output/capture input',
	'EPWM0_CH5:EPWM0 channel 5 output/capture input',
	'EPWM0_SYNC_IN:EPWM0 counter synchronous trigger input pin',
	'EPWM0_SYNC_OUT:EPWM0 counter synchronous trigger output pin',
	'EPWM1_BRAKE0:EPWM1 Brake 0 input pin',
	'EPWM1_BRAKE1:EPWM1 Brake 1 input pin',
	'EPWM1_CH0:EPWM1 channel 0 output/capture input',
	'EPWM1_CH1:EPWM1 channel 1 output/capture input',
	'EPWM1_CH2:EPWM1 channel 2 output/capture input',
	'EPWM1_CH3:EPWM1 channel 3 output/capture input',
	'EPWM1_CH4:EPWM1 channel 4 output/capture input',
	'EPWM1_CH5:EPWM1 channel 5 output/capture input',
	'I2C0_SCL:I2C0 clock pin',
	'I2C0_SDA:I2C0 data input/output pin',
	'I2C0_SMBAL:I2C0 SMBus SMBALTER pin ',
	'I2C0_SMBSUS:I2C0 SMBus SMBSUS pin (PMBus CONTROL pin)',
	'I2C1_SCL:I2C1 clock pin',
	'I2C1_SDA:I2C1 data input/output pin',
	'I2C1_SMBAL:I2C1 SMBus SMBALTER pin ',
	'I2C1_SMBSUS:I2C1 SMBus SMBSUS pin (PMBus CONTROL pin)',
	'ICE_CLK:Serial wired debugger clock pin',
	'ICE_DAT:Serial wired debugger data pin',
	'INT0:External interrupt 0 input pin',
	'INT1:External interrupt 1 input pin',
	'INT2:External interrupt 2 input pin',
	'INT3:External interrupt 3 input pin',
	'INT4:External interrupt 4 input pin',
	'INT5:External interrupt 5 input pin',
	'INT6:External interrupt 6 input pin',
	'INT7:External interrupt 7 input pin',
	'SPI0_CLK:SPI0 serial clock pin',
	'SPI0_I2SMCLK:SPI0 I2S master clock output pin',
	'SPI0_MISO:SPI0 MISO (Master In, Slave Out) pin',
	'SPI0_MOSI:SPI0 MOSI (Master Out, Slave In) pin',
	'SPI0_SS:SPI0 slave select  pin',
	'SPI1_CLK:SPI1 serial clock pin',
	'SPI1_I2SMCLK:SPI1 I2S master clock output pin',
	'SPI1_MISO:SPI1 MISO (Master In, Slave Out) pin',
	'SPI1_MOSI:SPI1 MOSI (Master Out, Slave In) pin',
	'SPI1_SS:SPI1 slave select  pin',
	'TM0:Timer0 event counter input/toggle output pin',
	'TM0_EXT:Timer0 external capture input/toggle output pin',
	'TM1:Timer1 event counter input/toggle output pin',
	'TM1_EXT:Timer1 external capture input/toggle output pin',
	'TM2:Timer2 event counter input/toggle output pin',
	'TM2_EXT:Timer2 external capture input/toggle output pin',
	'TM3:Timer3 event counter input/toggle output pin',
	'TM3_EXT:Timer3 external capture input/toggle output pin',
	'TRACE_CLK:ETM Trace Clock output pin',
	'TRACE_DATA0:ETM Trace Data 0 output pin',
	'TRACE_DATA1:ETM Trace Data 1 output pin',
	'TRACE_DATA2:ETM Trace Data 2 output pin',
	'TRACE_DATA3:ETM Trace Data 3 output pin',
	'UART0_nCTS:UART0 clear to Send input pin',
	'UART0_nRTS:UART0 request to Send output pin',
	'UART0_RXD:UART0 data receiver input pin',
	'UART0_TXD:UART0 data transmitter output pin',
	'UART1_nCTS:UART1 clear to Send input pin',
	'UART1_nRTS:UART1 request to Send output pin',
	'UART1_RXD:UART1 data receiver input pin',
	'UART1_TXD:UART1 data transmitter output pin',
	'UART2_nCTS:UART2 clear to Send input pin',
	'UART2_nRTS:UART2 request to Send output pin',
	'UART2_RXD:UART2 data receiver input pin',
	'UART2_TXD:UART2 data transmitter output pin',
	'UART3_nCTS:UART3 clear to Send input pin',
	'UART3_nRTS:UART3 request to Send output pin',
	'UART3_RXD:UART3 data receiver input pin',
	'UART3_TXD:UART3 data transmitter output pin',
	'UART4_nCTS:UART4 clear to Send input pin',
	'UART4_nRTS:UART4 request to Send output pin',
	'UART4_RXD:UART4 data receiver input pin',
	'UART4_TXD:UART4 data transmitter output pin',
	'UART5_nCTS:UART5 clear to Send input pin',
	'UART5_nRTS:UART5 request to Send output pin',
	'UART5_RXD:UART5 data receiver input pin',
	'UART5_TXD:UART5 data transmitter output pin',
	'X32_IN:External 32.768 kHz crystal input pin',
	'X32_OUT:External 32.768 kHz crystal output pin',
	'XT1_IN:External 4~24 MHz (high speed) crystal input pin',
	'XT1_OUT:External 4~24 MHz (high speed) crystal output pin'
];

NUTOOL_PIN.g_cfg_regDescriptions = {};
NUTOOL_PIN.g_cfg_regDescriptions.GPA_MFPL = '0x40000030';
NUTOOL_PIN.g_cfg_regDescriptions.GPA_MFPH = '0x40000034';
NUTOOL_PIN.g_cfg_regDescriptions.GPB_MFPL = '0x40000038';
NUTOOL_PIN.g_cfg_regDescriptions.GPB_MFPH = '0x4000003C';
NUTOOL_PIN.g_cfg_regDescriptions.GPC_MFPL = '0x40000040';
NUTOOL_PIN.g_cfg_regDescriptions.GPC_MFPH = '0x40000044';
NUTOOL_PIN.g_cfg_regDescriptions.GPD_MFPL = '0x40000048';
NUTOOL_PIN.g_cfg_regDescriptions.GPD_MFPH = '0x4000004C';
NUTOOL_PIN.g_cfg_regDescriptions.GPE_MFPL = '0x40000050';
NUTOOL_PIN.g_cfg_regDescriptions.GPE_MFPH = '0x40000054';
NUTOOL_PIN.g_cfg_regDescriptions.GPF_MFPL = '0x40000058';
NUTOOL_PIN.g_cfg_regDescriptions.GPF_MFPH = '0x4000005C';
NUTOOL_PIN.g_cfg_regDescriptions.GPG_MFPL = '0x40000060';
NUTOOL_PIN.g_cfg_regDescriptions.GPG_MFPH = '0x40000064';
NUTOOL_PIN.g_cfg_regDescriptions.GPH_MFPL = '0x40000068';
NUTOOL_PIN.g_cfg_regDescriptions.GPH_MFPH = '0x4000006C';
NUTOOL_PIN.g_cfg_regDescriptions.GPI_MFPL = '0x40000070';

NUTOOL_PIN.g_cfg_gpioMatrix = [];
NUTOOL_PIN.g_cfg_shareBits = [];
NUTOOL_PIN.g_cfg_addGPIO = {};
NUTOOL_PIN.g_cfg_unusedGPIO = {
	"LQFP48": {
		"ALL": ["ETM"]
	}
};

NUTOOL_PIN.decidepackageNumber = function (given_partNumber_package) {
	var partNumber_package;

	if (typeof given_partNumber_package === 'undefined') {
		partNumber_package = NUTOOL_PIN.getg_partNumber_package();
	}
	else {
		partNumber_package = given_partNumber_package;
	}

	NUTOOL_PIN.g_packageNumber = partNumber_package.substring(partNumber_package.indexOf('(') + 1);
	NUTOOL_PIN.g_packageNumber = NUTOOL_PIN.g_packageNumber.substring(0, NUTOOL_PIN.g_packageNumber.indexOf(')'));
	NUTOOL_PIN.g_packageNumberIndex = NUTOOL_PIN.g_packageNumber;

	partNumber_package = null;
};
