// chip content
NUTOOL_PIN.g_cfg_chips = [
	// M479
	{ name: "M479NG8AE", pkg: "QFN48" },
	{ name: "M479LG8AE", pkg: "LQFP48" },
	{ name: "M479SG8AE", pkg: "LQFP64" }
];

NUTOOL_PIN.g_cfg_pkgs = {
	"QFN48": [
		'PB.5', 'PB.4', 'PB.3', 'PB.2', 'PB.1', 'PB.0', 'PA.11', 'PA.10', 'PA.9', 'PA.8',
		'PF.5', 'PF.4',
		'PF.3', 'PF.2', 'PA.7', 'PA.6', 'PA.5', 'PA.4', 'PA.3', 'PA.2', 'PA.1', 'PA.0',
		'VDDIO', 'nRESET',
		'PF.0', 'PF.1', 'PC.5', 'PC.4', 'PC.3', 'PC.2', 'PC.1', 'PC.0', 'PA.12', 'PA.13',
		'PA.14', 'PA.15',
		'VSS', 'LDO_CAP', 'VDD', 'PC.14', 'PB.15', 'PB.14', 'PB.13', 'PB.12', 'AVDD', 'AVSS',
		'PB.7', 'PB.6'
	],
	"LQFP48": [
		'PB.5', 'PB.4', 'PB.3', 'PB.2', 'PB.1', 'PB.0', 'PA.11', 'PA.10', 'PA.9', 'PA.8',
		'PF.5', 'PF.4',
		'PF.3', 'PF.2', 'PA.7', 'PA.6', 'PA.5', 'PA.4', 'PA.3', 'PA.2', 'PA.1', 'PA.0',
		'VDDIO', 'nRESET',
		'PF.0', 'PF.1', 'PC.5', 'PC.4', 'PC.3', 'PC.2', 'PC.1', 'PC.0', 'PA.12', 'PA.13',
		'PA.14', 'PA.15',
		'VSS', 'LDO_CAP', 'VDD', 'PC.14', 'PB.15', 'PB.14', 'PB.13', 'PB.12', 'AVDD', 'AVSS',
		'PB.7', 'PB.6'
	],
	"LQFP64": [
		'PB.6', 'PB.5', 'PB.4', 'PB.3', 'PB.2', 'PB.1', 'PB.0', 'PA.11', 'PA.10', 'PA.9',
		'PA.8', 'PF.6', 'VBAT', 'PF.5', 'PF.4', 'PF.3',
		'PF.2', 'PC.7', 'PC.6', 'PA.7', 'PA.6', 'VSS', 'VDD', 'LDO_CAP', 'PA.5', 'PA.4',
		'PA.3', 'PA.2', 'PA.1', 'PA.0', 'VDDIO', 'nRESET',
		'PF.0', 'PF.1', 'PC.5', 'PC.4', 'PC.3', 'PC.2', 'PC.1', 'PC.0', 'PD.3', 'PD.2',
		'PD.1', 'PD.0', 'PA.12', 'PA.13', 'PA.14', 'PA.15',
		'VSS', 'LDO_CAP', 'VDD', 'PC.14', 'PB.15', 'PB.14', 'PB.13', 'PB.12', 'AVDD', 'VREF',
		'AVSS', 'PB.11', 'PB.10', 'PB.9', 'PB.8', 'PB.7'
	]
};

NUTOOL_PIN.g_cfg_gpios = [
	{ f: ['PA.0:0', 'QSPI0_MOSI0:3', 'SPI0_MOSI:4', 'UART0_RXD:7', 'UART1_nRTS:8', 'I2C2_SDA:9', 'EPWM0_CH5:13', 'DAC0_ST:15']},
	{ f: ['PA.1:0', 'QSPI0_MISO0:3', 'SPI0_MISO:4', 'UART0_TXD:7', 'UART1_nCTS:8', 'I2C2_SCL:9', 'EPWM0_CH4:13']},
	{ f: ['PA.2:0', 'QSPI0_CLK:3', 'SPI0_CLK:4', 'UART4_RXD:7', 'UART1_RXD:8', 'I2C1_SDA:9', 'I2C0_SMBSUS:10', 'EPWM0_CH3:13']},
	{ f: ['PA.3:0', 'QSPI0_SS:3', 'SPI0_SS:4', 'UART4_TXD:7', 'UART1_TXD:8', 'I2C1_SCL:9', 'I2C0_SMBAL:10', 'EPWM0_CH2:13', 'QEI0_B:14', 'EPWM1_BRAKE1:15']},
	{ f: ['PA.4:0', 'QSPI0_MOSI1:3', 'SPI0_I2SMCLK:4', 'UART0_nRTS:7', 'UART5_RXD:8', 'I2C0_SDA:9', 'UART0_RXD:11', 'EPWM0_CH1:13', 'QEI0_A:14']},
	{ f: ['PA.5:0', 'QSPI0_MISO1:3', 'SPI1_I2SMCLK:4', 'UART0_nCTS:7', 'UART5_TXD:8', 'I2C0_SCL:9', 'UART0_TXD:11', 'EPWM0_CH0:13', 'QEI0_INDEX:14']},
	{ f: ['PA.6:0', 'EBI_AD6:2', 'SPI1_SS:4', 'UART0_RXD:7', 'I2C1_SDA:8', 'EPWM1_CH5:11', 'ACMP1_WLAT:13', 'TM3:14', 'INT0:15']},
	{ f: ['PA.7:0', 'EBI_AD7:2', 'SPI1_CLK:4', 'UART0_TXD:7', 'I2C1_SCL:8', 'EPWM1_CH4:11', 'ACMP0_WLAT:13', 'TM2:14', 'INT1:15']},
	{ f: ['PA.8:0', 'EADC1_CH4:1', 'OPA2_P:1', 'EBI_ALE:2', 'UART1_RXD:7', 'QEI1_B:10', 'ECAP0_IC2:11', 'TM3_EXT:13', 'INT4:15']},
	{ f: ['PA.9:0', 'EADC1_CH5:1', 'OPA2_N:1', 'EBI_MCLK:2', 'UART1_TXD:7', 'QEI1_A:10', 'ECAP0_IC1:11', 'TM2_EXT:13']},
	{ f: ['PA.10:0', 'EADC1_CH6:1', 'ACMP1_P0:1', 'OPA2_O:1', 'EBI_nWR:2', 'I2C2_SDA:7', 'QEI1_INDEX:10', 'ECAP0_IC0:11', 'TM1_EXT:13', 'DAC0_ST:14']},
	{ f: ['PA.11:0', 'EADC1_CH7:1', 'ACMP0_P0:1', 'EBI_nRD:2', 'I2C2_SCL:7', 'EPWM0_SYNC_OUT:10', 'TM0_EXT:13']},
	{ f: ['PA.12:0', 'I2S0_BCLK:2', 'UART4_TXD:3', 'I2C1_SCL:4', 'QEI1_INDEX:12']},
	{ f: ['PA.13:0', 'I2S0_MCLK:2', 'UART4_RXD:3', 'I2C1_SDA:4', 'QEI1_A:12']},
	{ f: ['PA.14:0', 'I2S0_DI:2', 'UART0_TXD:3', 'I2C2_SCL:6', 'QEI1_B:12']},
	{ f: ['PA.15:0', 'I2S0_DO:2', 'UART0_RXD:3', 'I2C2_SDA:6', 'EPWM0_SYNC_IN:12']},

	{ f: ['PB.0:0', 'EADC0_CH0:1', 'EADC1_CH8:1', 'OPA1_P:1', 'EBI_ADR9:2', 'UART2_RXD:7', 'SPI0_I2SMCLK:8', 'I2C1_SDA:9', 'EPWM0_CH5:11', 'EPWM1_CH5:12', 'EPWM0_BRAKE1:13']},
	{ f: ['PB.1:0', 'EADC0_CH1:1', 'EADC1_CH9:1', 'OPA1_N:1', 'EBI_ADR8:2', 'SPI1_I2SMCLK:5', 'UART2_TXD:7', 'I2C1_SCL:9', 'I2S0_LRCK:10', 'EPWM0_CH4:11', 'EPWM1_CH4:12', 'EPWM0_BRAKE0:13']},
	{ f: ['PB.2:0', 'EADC0_CH2:1', 'EADC1_CH10:1', 'ACMP0_P1:1', 'OPA1_O:1', 'EBI_ADR3:2', 'SPI1_SS:5', 'UART1_RXD:6', 'UART5_nCTS:7', 'I2S0_DO:10', 'EPWM0_CH3:11', 'I2C1_SDA:12', 'TM3:14', 'INT3:15']},
	{ f: ['PB.3:0', 'EADC0_CH3:1', 'EADC1_CH11:1', 'ACMP0_N:1', 'EBI_ADR2:2', 'SPI1_CLK:5', 'UART1_TXD:6', 'UART5_nRTS:7', 'I2S0_DI:10', 'EPWM0_CH2:11', 'I2C1_SCL:12', 'TM2:14', 'INT2:15']},
	{ f: ['PB.4:0', 'EADC0_CH4:1', 'ACMP1_P1:1', 'OPA0_P:1', 'EBI_ADR1:2', 'SPI1_MOSI:5', 'I2C0_SDA:6', 'UART5_RXD:7', 'I2S0_MCLK:10', 'EPWM0_CH1:11', 'UART2_RXD:12', 'TM1:14', 'INT1:15']},
	{ f: ['PB.5:0', 'EADC0_CH5:1', 'ACMP1_N:1', 'OPA0_N:1', 'EBI_ADR0:2', 'SPI1_MISO:5', 'I2C0_SCL:6', 'UART5_TXD:7', 'I2S0_BCLK:10', 'EPWM0_CH0:11', 'UART2_TXD:12', 'TM0:14', 'INT0:15']},
	{ f: ['PB.6:0', 'EADC0_CH6:1', 'OPA0_O:1', 'EBI_nWRH:2', 'UART1_RXD:6', 'EBI_nCS1:8', 'EPWM1_BRAKE1:11', 'EPWM1_CH5:12', 'INT4:13', 'ACMP1_O:15']},
	{ f: ['PB.7:0', 'EADC0_CH7:1', 'EBI_nWRL:2', 'UART1_TXD:6', 'EBI_nCS0:8', 'EPWM1_BRAKE0:11', 'EPWM1_CH4:12', 'INT5:13', 'ACMP0_O:15']},
	{ f: ['PB.8:0', 'EADC0_CH8:1', 'EBI_ADR19:2', 'UART0_RXD:5', 'UART1_nRTS:6', 'I2C1_SMBSUS:7', 'I2C0_SDA:9', 'INT6:13']},
	{ f: ['PB.9:0', 'EADC0_CH9:1', 'EBI_ADR18:2', 'UART0_TXD:5', 'UART1_nCTS:6', 'I2C1_SMBAL:7', 'I2C0_SCL:9', 'INT7:13']},
	{ f: ['PB.10:0', 'EADC0_CH10:1', 'EBI_ADR17:2', 'UART0_nRTS:5', 'UART4_RXD:6', 'I2C1_SDA:7']},
	{ f: ['PB.11:0', 'EADC0_CH11:1', 'EBI_ADR16:2', 'UART0_nCTS:5', 'UART4_TXD:6', 'I2C1_SCL:7', 'SPI0_I2SMCLK:9']},
	{ f: ['PB.12:0', 'EADC0_CH12:1', 'EADC1_CH12:1', 'DAC0_OUT:1', 'ACMP0_P2:1', 'ACMP1_P2:1', 'EBI_AD15:2', 'SPI0_MOSI:4', 'UART0_RXD:6', 'UART3_nCTS:7', 'I2C2_SDA:8', 'EPWM1_CH3:11', 'TM3_EXT:13']},
	{ f: ['PB.13:0', 'EADC0_CH13:1', 'EADC1_CH13:1', 'ACMP0_P3:1', 'ACMP1_P3:1', 'EBI_AD14:2', 'SPI0_MISO:4', 'UART0_TXD:6', 'UART3_nRTS:7', 'I2C2_SCL:8', 'EPWM1_CH2:11', 'TM2_EXT:13']},
	{ f: ['PB.14:0', 'EADC0_CH14:1', 'EADC1_CH14:1', 'EBI_AD13:2', 'SPI0_CLK:4', 'UART0_nRTS:6', 'UART3_RXD:7', 'I2C2_SMBSUS:8', 'EPWM1_CH1:11', 'TM1_EXT:13', 'CLKO:14']},
	{ f: ['PB.15:0', 'EADC0_CH15:1', 'EADC1_CH15:1', 'EBI_AD12:2', 'SPI0_SS:4', 'UART0_nCTS:6', 'UART3_TXD:7', 'I2C2_SMBAL:8', 'EPWM0_BRAKE1:10', 'EPWM1_CH0:11', 'TM0_EXT:13']},

	{ f: ['PC.0:0', 'EBI_AD0:2', 'QSPI0_MOSI0:4', 'I2S0_LRCK:6', 'SPI1_SS:7', 'UART2_RXD:8', 'I2C0_SDA:9', 'EPWM1_CH5:12', 'ACMP1_O:14', 'EADC1_ST:15']},
	{ f: ['PC.1:0', 'EBI_AD1:2', 'QSPI0_MISO0:4', 'I2S0_DO:6', 'SPI1_CLK:7', 'UART2_TXD:8', 'I2C0_SCL:9', 'EPWM1_CH4:12', 'ACMP0_O:14', 'EADC0_ST:15']},
	{ f: ['PC.2:0', 'EBI_AD2:2', 'QSPI0_CLK:4', 'I2S0_DI:6', 'SPI1_MOSI:7', 'UART2_nCTS:8', 'I2C0_SMBSUS:9', 'UART3_RXD:11', 'EPWM1_CH3:12']},
	{ f: ['PC.3:0', 'EBI_AD3:2', 'QSPI0_SS:4', 'I2S0_MCLK:6', 'SPI1_MISO:7', 'UART2_nRTS:8', 'I2C0_SMBAL:9', 'UART3_TXD:11', 'EPWM1_CH2:12']},
	{ f: ['PC.4:0', 'EBI_AD4:2', 'QSPI0_MOSI1:4', 'I2S0_BCLK:6', 'SPI1_I2SMCLK:7', 'UART2_RXD:8', 'I2C1_SDA:9', 'UART4_RXD:11', 'EPWM1_CH1:12']},
	{ f: ['PC.5:0', 'EBI_AD5:2', 'QSPI0_MISO1:4', 'UART2_TXD:8', 'I2C1_SCL:9', 'UART4_TXD:11', 'EPWM1_CH0:12']},
	{ f: ['PC.6:0', 'EBI_AD8:2', 'SPI1_MOSI:4', 'UART4_RXD:5', 'UART0_nRTS:7', 'I2C1_SMBSUS:8', 'EPWM1_CH3:11', 'TM1:14', 'INT2:15']},
	{ f: ['PC.7:0', 'EBI_AD9:2', 'SPI1_MISO:4', 'UART4_TXD:5', 'UART0_nCTS:7', 'I2C1_SMBAL:8', 'EPWM1_CH2:11', 'TM0:14', 'INT3:15']},
	{ f: ['PC.8:0']},
	{ f: ['PC.9:0']},
	{ f: ['PC.10:0']},
	{ f: ['PC.11:0']},
	{ f: ['PC.12:0']},
	{ f: ['PC.13:0']},
	{ f: ['PC.14:0', 'EBI_AD11:2', 'SPI0_I2SMCLK:4', 'QSPI0_CLK:6', 'EPWM0_SYNC_IN:11', 'TM1:13']},
	{ f: ['PC.15:0']},

	{ f: ['PD.0:0', 'EBI_AD13:2', 'SPI0_MOSI:4', 'UART3_RXD:5', 'I2C2_SDA:6', 'TM2:14']},
	{ f: ['PD.1:0', 'EBI_AD12:2', 'SPI0_MISO:4', 'UART3_TXD:5', 'I2C2_SCL:6']},
	{ f: ['PD.2:0', 'EBI_AD11:2', 'SPI0_CLK:4', 'UART3_nCTS:5', 'UART0_RXD:9']},
	{ f: ['PD.3:0', 'EBI_AD10:2', 'SPI0_SS:4', 'UART3_nRTS:5', 'UART0_TXD:9']},
	{ f: ['PD.4:0']},
	{ f: ['PD.5:0']},
	{ f: ['PD.6:0']},
	{ f: ['PD.7:0']},
	{ f: ['PD.8:0']},
	{ f: ['PD.9:0']},
	{ f: ['PD.10:0']},
	{ f: ['PD.11:0']},
	{ f: ['PD.12:0']},
	{ f: ['PD.13:0']},
	{ f: ['PD.14:0']},
	{ f: ['PD.15:0']},

	{ f: ['PE.0:0']},
	{ f: ['PE.1:0']},
	{ f: ['PE.2:0']},
	{ f: ['PE.3:0']},
	{ f: ['PE.4:0']},
	{ f: ['PE.5:0']},
	{ f: ['PE.6:0']},
	{ f: ['PE.7:0']},
	{ f: ['PE.8:0']},
	{ f: ['PE.9:0']},
	{ f: ['PE.10:0']},
	{ f: ['PE.11:0']},
	{ f: ['PE.12:0']},
	{ f: ['PE.13:0']},
	{ f: ['PE.14:0']},
	{ f: ['PE.15:0']},

	{ f: ['PF.0:0', 'UART1_TXD:2', 'I2C1_SCL:3', 'UART0_TXD:4', 'ICE_DAT:14']},
	{ f: ['PF.1:0', 'UART1_RXD:2', 'I2C1_SDA:3', 'UART0_RXD:4', 'ICE_CLK:14']},
	{ f: ['PF.2:0', 'EBI_nCS1:2', 'UART0_RXD:3', 'I2C0_SDA:4', 'QSPI0_CLK:5', 'XT1_OUT:10']},
	{ f: ['PF.3:0', 'EBI_nCS0:2', 'UART0_TXD:3', 'I2C0_SCL:4', 'XT1_IN:10']},
	{ f: ['PF.4:0', 'UART2_TXD:2', 'UART2_nRTS:4', 'EPWM0_CH1:7', 'X32_OUT:10', 'EADC1_ST:11']},
	{ f: ['PF.5:0', 'UART2_RXD:2', 'UART2_nCTS:4', 'EPWM0_CH0:7', 'EPWM0_SYNC_OUT:9', 'X32_IN:10', 'EADC0_ST:11']},
	{ f: ['PF.6:0', 'EBI_ADR19:2', 'I2S0_LRCK:4', 'SPI0_MOSI:5', 'UART4_RXD:6', 'EBI_nCS0:7', 'TAMPER0:10']},
	{ f: ['PF.7:0']},
	{ f: ['PF.8:0']},
	{ f: ['PF.9:0']},
	{ f: ['PF.10:0']},
	{ f: ['PF.11:0']},
	{ f: ['PF.12:0']},
	{ f: ['PF.13:0']},
	{ f: ['PF.14:0']},
	{ f: ['PF.15:0']}
];

NUTOOL_PIN.g_cfg_gpiosDefines = [
	{ f: ['PA.0', 'GPIO:SYS_GPA_MFPL_PA0MFP_GPIO@GPA_MFPL', 'SPIM_MOSI:SYS_GPA_MFPL_PA0MFP_SPIM_MOSI@GPA_MFPL', 'QSPI0_MOSI0:SYS_GPA_MFPL_PA0MFP_QSPI0_MOSI0@GPA_MFPL', 'SPI0_MOSI:SYS_GPA_MFPL_PA0MFP_SPI0_MOSI@GPA_MFPL', 'SD1_DAT0:SYS_GPA_MFPL_PA0MFP_SD1_DAT0@GPA_MFPL', 'SC0_CLK:SYS_GPA_MFPL_PA0MFP_SC0_CLK@GPA_MFPL', 'UART0_RXD:SYS_GPA_MFPL_PA0MFP_UART0_RXD@GPA_MFPL', 'UART1_nRTS:SYS_GPA_MFPL_PA0MFP_UART1_nRTS@GPA_MFPL', 'I2C2_SDA:SYS_GPA_MFPL_PA0MFP_I2C2_SDA@GPA_MFPL', 'CCAP_DATA6:SYS_GPA_MFPL_PA0MFP_CCAP_DATA6@GPA_MFPL', 'BPWM0_CH0:SYS_GPA_MFPL_PA0MFP_BPWM0_CH0@GPA_MFPL', 'EPWM0_CH5:SYS_GPA_MFPL_PA0MFP_EPWM0_CH5@GPA_MFPL', 'DAC0_ST:SYS_GPA_MFPL_PA0MFP_DAC0_ST@GPA_MFPL'] },
	{ f: ['PA.1', 'GPIO:SYS_GPA_MFPL_PA1MFP_GPIO@GPA_MFPL', 'SPIM_MISO:SYS_GPA_MFPL_PA1MFP_SPIM_MISO@GPA_MFPL', 'QSPI0_MISO0:SYS_GPA_MFPL_PA1MFP_QSPI0_MISO0@GPA_MFPL', 'SPI0_MISO:SYS_GPA_MFPL_PA1MFP_SPI0_MISO@GPA_MFPL', 'SD1_DAT1:SYS_GPA_MFPL_PA1MFP_SD1_DAT1@GPA_MFPL', 'SC0_DAT:SYS_GPA_MFPL_PA1MFP_SC0_DAT@GPA_MFPL', 'UART0_TXD:SYS_GPA_MFPL_PA1MFP_UART0_TXD@GPA_MFPL', 'UART1_nCTS:SYS_GPA_MFPL_PA1MFP_UART1_nCTS@GPA_MFPL', 'I2C2_SCL:SYS_GPA_MFPL_PA1MFP_I2C2_SCL@GPA_MFPL', 'CCAP_DATA7:SYS_GPA_MFPL_PA1MFP_CCAP_DATA7@GPA_MFPL', 'BPWM0_CH1:SYS_GPA_MFPL_PA1MFP_BPWM0_CH1@GPA_MFPL', 'EPWM0_CH4:SYS_GPA_MFPL_PA1MFP_EPWM0_CH4@GPA_MFPL', 'DAC1_ST:SYS_GPA_MFPL_PA1MFP_DAC1_ST@GPA_MFPL'] },
	{ f: ['PA.2', 'GPIO:SYS_GPA_MFPL_PA2MFP_GPIO@GPA_MFPL', 'SPIM_CLK:SYS_GPA_MFPL_PA2MFP_SPIM_CLK@GPA_MFPL', 'QSPI0_CLK:SYS_GPA_MFPL_PA2MFP_QSPI0_CLK@GPA_MFPL', 'SPI0_CLK:SYS_GPA_MFPL_PA2MFP_SPI0_CLK@GPA_MFPL', 'SD1_DAT2:SYS_GPA_MFPL_PA2MFP_SD1_DAT2@GPA_MFPL', 'SC0_RST:SYS_GPA_MFPL_PA2MFP_SC0_RST@GPA_MFPL', 'UART4_RXD:SYS_GPA_MFPL_PA2MFP_UART4_RXD@GPA_MFPL', 'UART1_RXD:SYS_GPA_MFPL_PA2MFP_UART1_RXD@GPA_MFPL', 'I2C1_SDA:SYS_GPA_MFPL_PA2MFP_I2C1_SDA@GPA_MFPL', 'I2C0_SMBSUS:SYS_GPA_MFPL_PA2MFP_I2C0_SMBSUS@GPA_MFPL', 'BPWM0_CH2:SYS_GPA_MFPL_PA2MFP_BPWM0_CH2@GPA_MFPL', 'EPWM0_CH3:SYS_GPA_MFPL_PA2MFP_EPWM0_CH3@GPA_MFPL'] },
	{ f: ['PA.3', 'GPIO:SYS_GPA_MFPL_PA3MFP_GPIO@GPA_MFPL', 'SPIM_SS:SYS_GPA_MFPL_PA3MFP_SPIM_SS@GPA_MFPL', 'QSPI0_SS:SYS_GPA_MFPL_PA3MFP_QSPI0_SS@GPA_MFPL', 'SPI0_SS:SYS_GPA_MFPL_PA3MFP_SPI0_SS@GPA_MFPL', 'SD1_DAT3:SYS_GPA_MFPL_PA3MFP_SD1_DAT3@GPA_MFPL', 'SC0_PWR:SYS_GPA_MFPL_PA3MFP_SC0_PWR@GPA_MFPL', 'UART4_TXD:SYS_GPA_MFPL_PA3MFP_UART4_TXD@GPA_MFPL', 'UART1_TXD:SYS_GPA_MFPL_PA3MFP_UART1_TXD@GPA_MFPL', 'I2C1_SCL:SYS_GPA_MFPL_PA3MFP_I2C1_SCL@GPA_MFPL', 'I2C0_SMBAL:SYS_GPA_MFPL_PA3MFP_I2C0_SMBAL@GPA_MFPL', 'BPWM0_CH3:SYS_GPA_MFPL_PA3MFP_BPWM0_CH3@GPA_MFPL', 'EPWM0_CH2:SYS_GPA_MFPL_PA3MFP_EPWM0_CH2@GPA_MFPL', 'QEI0_B:SYS_GPA_MFPL_PA3MFP_QEI0_B@GPA_MFPL', 'EPWM1_BRAKE1:SYS_GPA_MFPL_PA3MFP_EPWM1_BRAKE1@GPA_MFPL'] },
	{ f: ['PA.4', 'GPIO:SYS_GPA_MFPL_PA4MFP_GPIO@GPA_MFPL', 'SPIM_D3:SYS_GPA_MFPL_PA4MFP_SPIM_D3@GPA_MFPL', 'QSPI0_MOSI1:SYS_GPA_MFPL_PA4MFP_QSPI0_MOSI1@GPA_MFPL', 'SPI0_I2SMCLK:SYS_GPA_MFPL_PA4MFP_SPI0_I2SMCLK@GPA_MFPL', 'SD1_CLK:SYS_GPA_MFPL_PA4MFP_SD1_CLK@GPA_MFPL', 'SC0_nCD:SYS_GPA_MFPL_PA4MFP_SC0_nCD@GPA_MFPL', 'UART0_nRTS:SYS_GPA_MFPL_PA4MFP_UART0_nRTS@GPA_MFPL', 'UART5_RXD:SYS_GPA_MFPL_PA4MFP_UART5_RXD@GPA_MFPL', 'I2C0_SDA:SYS_GPA_MFPL_PA4MFP_I2C0_SDA@GPA_MFPL', 'CAN0_RXD:SYS_GPA_MFPL_PA4MFP_CAN0_RXD@GPA_MFPL', 'UART0_RXD:SYS_GPA_MFPL_PA4MFP_UART0_RXD@GPA_MFPL', 'BPWM0_CH4:SYS_GPA_MFPL_PA4MFP_BPWM0_CH4@GPA_MFPL', 'EPWM0_CH1:SYS_GPA_MFPL_PA4MFP_EPWM0_CH1@GPA_MFPL', 'QEI0_A:SYS_GPA_MFPL_PA4MFP_QEI0_A@GPA_MFPL'] },
	{ f: ['PA.5', 'GPIO:SYS_GPA_MFPL_PA5MFP_GPIO@GPA_MFPL', 'SPIM_D2:SYS_GPA_MFPL_PA5MFP_SPIM_D2@GPA_MFPL', 'QSPI0_MISO1:SYS_GPA_MFPL_PA5MFP_QSPI0_MISO1@GPA_MFPL', 'SPI1_I2SMCLK:SYS_GPA_MFPL_PA5MFP_SPI1_I2SMCLK@GPA_MFPL', 'SD1_CMD:SYS_GPA_MFPL_PA5MFP_SD1_CMD@GPA_MFPL', 'SC2_nCD:SYS_GPA_MFPL_PA5MFP_SC2_nCD@GPA_MFPL', 'UART0_nCTS:SYS_GPA_MFPL_PA5MFP_UART0_nCTS@GPA_MFPL', 'UART5_TXD:SYS_GPA_MFPL_PA5MFP_UART5_TXD@GPA_MFPL', 'I2C0_SCL:SYS_GPA_MFPL_PA5MFP_I2C0_SCL@GPA_MFPL', 'CAN0_TXD:SYS_GPA_MFPL_PA5MFP_CAN0_TXD@GPA_MFPL', 'UART0_TXD:SYS_GPA_MFPL_PA5MFP_UART0_TXD@GPA_MFPL', 'BPWM0_CH5:SYS_GPA_MFPL_PA5MFP_BPWM0_CH5@GPA_MFPL', 'EPWM0_CH0:SYS_GPA_MFPL_PA5MFP_EPWM0_CH0@GPA_MFPL', 'QEI0_INDEX:SYS_GPA_MFPL_PA5MFP_QEI0_INDEX@GPA_MFPL'] },
	{ f: ['PA.6', 'GPIO:SYS_GPA_MFPL_PA6MFP_GPIO@GPA_MFPL', 'EBI_AD6:SYS_GPA_MFPL_PA6MFP_EBI_AD6@GPA_MFPL', 'EMAC_RMII_RXERR:SYS_GPA_MFPL_PA6MFP_EMAC_RMII_RXERR@GPA_MFPL', 'SPI1_SS:SYS_GPA_MFPL_PA6MFP_SPI1_SS@GPA_MFPL', 'SD1_nCD:SYS_GPA_MFPL_PA6MFP_SD1_nCD@GPA_MFPL', 'SC2_CLK:SYS_GPA_MFPL_PA6MFP_SC2_CLK@GPA_MFPL', 'UART0_RXD:SYS_GPA_MFPL_PA6MFP_UART0_RXD@GPA_MFPL', 'I2C1_SDA:SYS_GPA_MFPL_PA6MFP_I2C1_SDA@GPA_MFPL', 'QSPI1_MOSI1:SYS_GPA_MFPL_PA6MFP_QSPI1_MOSI1@GPA_MFPL', 'EPWM1_CH5:SYS_GPA_MFPL_PA6MFP_EPWM1_CH5@GPA_MFPL', 'BPWM1_CH3:SYS_GPA_MFPL_PA6MFP_BPWM1_CH3@GPA_MFPL', 'ACMP1_WLAT:SYS_GPA_MFPL_PA6MFP_ACMP1_WLAT@GPA_MFPL', 'TM3:SYS_GPA_MFPL_PA6MFP_TM3@GPA_MFPL', 'INT0:SYS_GPA_MFPL_PA6MFP_INT0@GPA_MFPL'] },
	{ f: ['PA.7', 'GPIO:SYS_GPA_MFPL_PA7MFP_GPIO@GPA_MFPL', 'EBI_AD7:SYS_GPA_MFPL_PA7MFP_EBI_AD7@GPA_MFPL', 'EMAC_RMII_CRSDV:SYS_GPA_MFPL_PA7MFP_EMAC_RMII_CRSDV@GPA_MFPL', 'SPI1_CLK:SYS_GPA_MFPL_PA7MFP_SPI1_CLK@GPA_MFPL', 'SC2_DAT:SYS_GPA_MFPL_PA7MFP_SC2_DAT@GPA_MFPL', 'UART0_TXD:SYS_GPA_MFPL_PA7MFP_UART0_TXD@GPA_MFPL', 'I2C1_SCL:SYS_GPA_MFPL_PA7MFP_I2C1_SCL@GPA_MFPL', 'QSPI1_MISO1:SYS_GPA_MFPL_PA7MFP_QSPI1_MISO1@GPA_MFPL', 'EPWM1_CH4:SYS_GPA_MFPL_PA7MFP_EPWM1_CH4@GPA_MFPL', 'BPWM1_CH2:SYS_GPA_MFPL_PA7MFP_BPWM1_CH2@GPA_MFPL', 'ACMP0_WLAT:SYS_GPA_MFPL_PA7MFP_ACMP0_WLAT@GPA_MFPL', 'TM2:SYS_GPA_MFPL_PA7MFP_TM2@GPA_MFPL', 'INT1:SYS_GPA_MFPL_PA7MFP_INT1@GPA_MFPL'] },
	{ f: ['PA.8', 'GPIO:SYS_GPA_MFPH_PA8MFP_GPIO@GPA_MFPH', 'OPA2_P:SYS_GPA_MFPH_PA8MFP_OPA2_P@GPA_MFPH', 'EADC1_CH4:SYS_GPA_MFPH_PA8MFP_EADC1_CH4@GPA_MFPH', 'EBI_ALE:SYS_GPA_MFPH_PA8MFP_EBI_ALE@GPA_MFPH', 'SC2_CLK:SYS_GPA_MFPH_PA8MFP_SC2_CLK@GPA_MFPH', 'SPI2_MOSI:SYS_GPA_MFPH_PA8MFP_SPI2_MOSI@GPA_MFPH', 'SD1_DAT0:SYS_GPA_MFPH_PA8MFP_SD1_DAT0@GPA_MFPH', 'USCI0_CTL1:SYS_GPA_MFPH_PA8MFP_USCI0_CTL1@GPA_MFPH', 'UART1_RXD:SYS_GPA_MFPH_PA8MFP_UART1_RXD@GPA_MFPH', 'UART7_RXD:SYS_GPA_MFPH_PA8MFP_UART7_RXD@GPA_MFPH', 'BPWM0_CH3:SYS_GPA_MFPH_PA8MFP_BPWM0_CH3@GPA_MFPH', 'QEI1_B:SYS_GPA_MFPH_PA8MFP_QEI1_B@GPA_MFPH', 'ECAP0_IC2:SYS_GPA_MFPH_PA8MFP_ECAP0_IC2@GPA_MFPH', 'TM3_EXT:SYS_GPA_MFPH_PA8MFP_TM3_EXT@GPA_MFPH', 'INT4:SYS_GPA_MFPH_PA8MFP_INT4@GPA_MFPH'] },
	{ f: ['PA.9', 'GPIO:SYS_GPA_MFPH_PA9MFP_GPIO@GPA_MFPH', 'OPA2_N:SYS_GPA_MFPH_PA9MFP_OPA2_N@GPA_MFPH', 'EADC1_CH5:SYS_GPA_MFPH_PA9MFP_EADC1_CH5@GPA_MFPH', 'EBI_MCLK:SYS_GPA_MFPH_PA9MFP_EBI_MCLK@GPA_MFPH', 'SC2_DAT:SYS_GPA_MFPH_PA9MFP_SC2_DAT@GPA_MFPH', 'SPI2_MISO:SYS_GPA_MFPH_PA9MFP_SPI2_MISO@GPA_MFPH', 'SD1_DAT1:SYS_GPA_MFPH_PA9MFP_SD1_DAT1@GPA_MFPH', 'USCI0_DAT1:SYS_GPA_MFPH_PA9MFP_USCI0_DAT1@GPA_MFPH', 'UART1_TXD:SYS_GPA_MFPH_PA9MFP_UART1_TXD@GPA_MFPH', 'UART7_TXD:SYS_GPA_MFPH_PA9MFP_UART7_TXD@GPA_MFPH', 'BPWM0_CH2:SYS_GPA_MFPH_PA9MFP_BPWM0_CH2@GPA_MFPH', 'QEI1_A:SYS_GPA_MFPH_PA9MFP_QEI1_A@GPA_MFPH', 'ECAP0_IC1:SYS_GPA_MFPH_PA9MFP_ECAP0_IC1@GPA_MFPH', 'TM2_EXT:SYS_GPA_MFPH_PA9MFP_TM2_EXT@GPA_MFPH', 'SWDH_DAT:SYS_GPA_MFPH_PA9MFP_SWDH_DAT@GPA_MFPH'] },
	{ f: ['PA.10', 'GPIO:SYS_GPA_MFPH_PA10MFP_GPIO@GPA_MFPH', 'ACMP1_P0:SYS_GPA_MFPH_PA10MFP_ACMP1_P0@GPA_MFPH', 'OPA2_O:SYS_GPA_MFPH_PA10MFP_OPA2_O@GPA_MFPH', 'EADC1_CH6:SYS_GPA_MFPH_PA10MFP_EADC1_CH6@GPA_MFPH', 'EBI_nWR:SYS_GPA_MFPH_PA10MFP_EBI_nWR@GPA_MFPH', 'SC2_RST:SYS_GPA_MFPH_PA10MFP_SC2_RST@GPA_MFPH', 'SPI2_CLK:SYS_GPA_MFPH_PA10MFP_SPI2_CLK@GPA_MFPH', 'SD1_DAT2:SYS_GPA_MFPH_PA10MFP_SD1_DAT2@GPA_MFPH', 'USCI0_DAT0:SYS_GPA_MFPH_PA10MFP_USCI0_DAT0@GPA_MFPH', 'I2C2_SDA:SYS_GPA_MFPH_PA10MFP_I2C2_SDA@GPA_MFPH', 'UART6_RXD:SYS_GPA_MFPH_PA10MFP_UART6_RXD@GPA_MFPH', 'BPWM0_CH1:SYS_GPA_MFPH_PA10MFP_BPWM0_CH1@GPA_MFPH', 'QEI1_INDEX:SYS_GPA_MFPH_PA10MFP_QEI1_INDEX@GPA_MFPH', 'ECAP0_IC0:SYS_GPA_MFPH_PA10MFP_ECAP0_IC0@GPA_MFPH', 'TM1_EXT:SYS_GPA_MFPH_PA10MFP_TM1_EXT@GPA_MFPH', 'DAC0_ST:SYS_GPA_MFPH_PA10MFP_DAC0_ST@GPA_MFPH', 'SWDH_CLK:SYS_GPA_MFPH_PA10MFP_SWDH_CLK@GPA_MFPH'] },
	{ f: ['PA.11', 'GPIO:SYS_GPA_MFPH_PA11MFP_GPIO@GPA_MFPH', 'ACMP0_P0:SYS_GPA_MFPH_PA11MFP_ACMP0_P0@GPA_MFPH', 'EADC1_CH7:SYS_GPA_MFPH_PA11MFP_EADC1_CH7@GPA_MFPH', 'EBI_nRD:SYS_GPA_MFPH_PA11MFP_EBI_nRD@GPA_MFPH', 'SC2_PWR:SYS_GPA_MFPH_PA11MFP_SC2_PWR@GPA_MFPH', 'SPI2_SS:SYS_GPA_MFPH_PA11MFP_SPI2_SS@GPA_MFPH', 'SD1_DAT3:SYS_GPA_MFPH_PA11MFP_SD1_DAT3@GPA_MFPH', 'USCI0_CLK:SYS_GPA_MFPH_PA11MFP_USCI0_CLK@GPA_MFPH', 'I2C2_SCL:SYS_GPA_MFPH_PA11MFP_I2C2_SCL@GPA_MFPH', 'UART6_TXD:SYS_GPA_MFPH_PA11MFP_UART6_TXD@GPA_MFPH', 'BPWM0_CH0:SYS_GPA_MFPH_PA11MFP_BPWM0_CH0@GPA_MFPH', 'EPWM0_SYNC_OUT:SYS_GPA_MFPH_PA11MFP_EPWM0_SYNC_OUT@GPA_MFPH', 'TM0_EXT:SYS_GPA_MFPH_PA11MFP_TM0_EXT@GPA_MFPH', 'DAC1_ST:SYS_GPA_MFPH_PA11MFP_DAC1_ST@GPA_MFPH'] },
	{ f: ['PA.12', 'GPIO:SYS_GPA_MFPH_PA12MFP_GPIO@GPA_MFPH', 'I2S0_BCLK:SYS_GPA_MFPH_PA12MFP_I2S0_BCLK@GPA_MFPH', 'UART4_TXD:SYS_GPA_MFPH_PA12MFP_UART4_TXD@GPA_MFPH', 'I2C1_SCL:SYS_GPA_MFPH_PA12MFP_I2C1_SCL@GPA_MFPH', 'SPI2_SS:SYS_GPA_MFPH_PA12MFP_SPI2_SS@GPA_MFPH', 'CAN0_TXD:SYS_GPA_MFPH_PA12MFP_CAN0_TXD@GPA_MFPH', 'SC2_PWR:SYS_GPA_MFPH_PA12MFP_SC2_PWR@GPA_MFPH', 'BPWM1_CH2:SYS_GPA_MFPH_PA12MFP_BPWM1_CH2@GPA_MFPH', 'QEI1_INDEX:SYS_GPA_MFPH_PA12MFP_QEI1_INDEX@GPA_MFPH', 'USB_VBUS:SYS_GPA_MFPH_PA12MFP_USB_VBUS@GPA_MFPH'] },
	{ f: ['PA.13', 'GPIO:SYS_GPA_MFPH_PA13MFP_GPIO@GPA_MFPH', 'I2S0_MCLK:SYS_GPA_MFPH_PA13MFP_I2S0_MCLK@GPA_MFPH', 'UART4_RXD:SYS_GPA_MFPH_PA13MFP_UART4_RXD@GPA_MFPH', 'I2C1_SDA:SYS_GPA_MFPH_PA13MFP_I2C1_SDA@GPA_MFPH', 'SPI2_CLK:SYS_GPA_MFPH_PA13MFP_SPI2_CLK@GPA_MFPH', 'CAN0_RXD:SYS_GPA_MFPH_PA13MFP_CAN0_RXD@GPA_MFPH', 'SC2_RST:SYS_GPA_MFPH_PA13MFP_SC2_RST@GPA_MFPH', 'BPWM1_CH3:SYS_GPA_MFPH_PA13MFP_BPWM1_CH3@GPA_MFPH', 'QEI1_A:SYS_GPA_MFPH_PA13MFP_QEI1_A@GPA_MFPH', 'USB_D-:SYS_GPA_MFPH_PA13MFP_USB_D_N@GPA_MFPH'] },
	{ f: ['PA.14', 'GPIO:SYS_GPA_MFPH_PA14MFP_GPIO@GPA_MFPH', 'I2S0_DI:SYS_GPA_MFPH_PA14MFP_I2S0_DI@GPA_MFPH', 'UART0_TXD:SYS_GPA_MFPH_PA14MFP_UART0_TXD@GPA_MFPH', 'SPI2_MISO:SYS_GPA_MFPH_PA14MFP_SPI2_MISO@GPA_MFPH', 'I2C2_SCL:SYS_GPA_MFPH_PA14MFP_I2C2_SCL@GPA_MFPH', 'SC2_DAT:SYS_GPA_MFPH_PA14MFP_SC2_DAT@GPA_MFPH', 'BPWM1_CH4:SYS_GPA_MFPH_PA14MFP_BPWM1_CH4@GPA_MFPH', 'QEI1_B:SYS_GPA_MFPH_PA14MFP_QEI1_B@GPA_MFPH', 'USB_D+:SYS_GPA_MFPH_PA14MFP_USB_D_P@GPA_MFPH'] },
	{ f: ['PA.15', 'GPIO:SYS_GPA_MFPH_PA15MFP_GPIO@GPA_MFPH', 'I2S0_DO:SYS_GPA_MFPH_PA15MFP_I2S0_DO@GPA_MFPH', 'UART0_RXD:SYS_GPA_MFPH_PA15MFP_UART0_RXD@GPA_MFPH', 'SPI2_MOSI:SYS_GPA_MFPH_PA15MFP_SPI2_MOSI@GPA_MFPH', 'I2C2_SDA:SYS_GPA_MFPH_PA15MFP_I2C2_SDA@GPA_MFPH', 'SC2_CLK:SYS_GPA_MFPH_PA15MFP_SC2_CLK@GPA_MFPH', 'BPWM1_CH5:SYS_GPA_MFPH_PA15MFP_BPWM1_CH5@GPA_MFPH', 'EPWM0_SYNC_IN:SYS_GPA_MFPH_PA15MFP_EPWM0_SYNC_IN@GPA_MFPH', 'USB_OTG_ID:SYS_GPA_MFPH_PA15MFP_USB_OTG_ID@GPA_MFPH'] },

	{ f: ['PB.0', 'GPIO:SYS_GPB_MFPL_PB0MFP_GPIO@GPB_MFPL', 'EADC0_CH0:SYS_GPB_MFPL_PB0MFP_EADC0_CH0@GPB_MFPL', 'EADC1_CH8:SYS_GPB_MFPL_PB0MFP_EADC1_CH8@GPB_MFPL', 'OPA1_P:SYS_GPB_MFPL_PB0MFP_OPA1_P@GPB_MFPL', 'EBI_ADR9:SYS_GPB_MFPL_PB0MFP_EBI_ADR9@GPB_MFPL', 'SD0_CMD:SYS_GPB_MFPL_PB0MFP_SD0_CMD@GPB_MFPL', 'SPI2_I2SMCLK:SYS_GPB_MFPL_PB0MFP_SPI2_I2SMCLK@GPB_MFPL', 'UART2_RXD:SYS_GPB_MFPL_PB0MFP_UART2_RXD@GPB_MFPL', 'SPI0_I2SMCLK:SYS_GPB_MFPL_PB0MFP_SPI0_I2SMCLK@GPB_MFPL', 'I2C1_SDA:SYS_GPB_MFPL_PB0MFP_I2C1_SDA@GPB_MFPL', 'EPWM0_CH5:SYS_GPB_MFPL_PB0MFP_EPWM0_CH5@GPB_MFPL', 'EPWM1_CH5:SYS_GPB_MFPL_PB0MFP_EPWM1_CH5@GPB_MFPL', 'EPWM0_BRAKE1:SYS_GPB_MFPL_PB0MFP_EPWM0_BRAKE1@GPB_MFPL'] },
	{ f: ['PB.1', 'GPIO:SYS_GPB_MFPL_PB1MFP_GPIO@GPB_MFPL', 'EADC0_CH1:SYS_GPB_MFPL_PB1MFP_EADC0_CH1@GPB_MFPL', 'OPA1_N:SYS_GPB_MFPL_PB1MFP_OPA1_N@GPB_MFPL', 'EADC1_CH9:SYS_GPB_MFPL_PB1MFP_EADC1_CH9@GPB_MFPL', 'EBI_ADR8:SYS_GPB_MFPL_PB1MFP_EBI_ADR8@GPB_MFPL', 'SD0_CLK:SYS_GPB_MFPL_PB1MFP_SD0_CLK@GPB_MFPL', 'EMAC_RMII_RXERR:SYS_GPB_MFPL_PB1MFP_EMAC_RMII_RXERR@GPB_MFPL', 'SPI1_I2SMCLK:SYS_GPB_MFPL_PB1MFP_SPI1_I2SMCLK@GPB_MFPL', 'SPI3_I2SMCLK:SYS_GPB_MFPL_PB1MFP_SPI3_I2SMCLK@GPB_MFPL', 'UART2_TXD:SYS_GPB_MFPL_PB1MFP_UART2_TXD@GPB_MFPL', 'USCI1_CLK:SYS_GPB_MFPL_PB1MFP_USCI1_CLK@GPB_MFPL', 'I2C1_SCL:SYS_GPB_MFPL_PB1MFP_I2C1_SCL@GPB_MFPL', 'I2S0_LRCK:SYS_GPB_MFPL_PB1MFP_I2S0_LRCK@GPB_MFPL', 'EPWM0_CH4:SYS_GPB_MFPL_PB1MFP_EPWM0_CH4@GPB_MFPL', 'EPWM1_CH4:SYS_GPB_MFPL_PB1MFP_EPWM1_CH4@GPB_MFPL', 'EPWM0_BRAKE0:SYS_GPB_MFPL_PB1MFP_EPWM0_BRAKE0@GPB_MFPL'] },
	{ f: ['PB.2', 'GPIO:SYS_GPB_MFPL_PB2MFP_GPIO@GPB_MFPL', 'ACMP0_P1:SYS_GPB_MFPL_PB2MFP_ACMP0_P1@GPB_MFPL', 'EADC0_CH2:SYS_GPB_MFPL_PB2MFP_EADC0_CH2@GPB_MFPL', 'OPA1_O:SYS_GPB_MFPL_PB2MFP_OPA1_O@GPB_MFPL', 'EADC1_CH10:SYS_GPB_MFPL_PB2MFP_EADC1_CH10@GPB_MFPL', 'EBI_ADR3:SYS_GPB_MFPL_PB2MFP_EBI_ADR3@GPB_MFPL', 'SD0_DAT0:SYS_GPB_MFPL_PB2MFP_SD0_DAT0@GPB_MFPL', 'EMAC_RMII_CRSDV:SYS_GPB_MFPL_PB2MFP_EMAC_RMII_CRSDV@GPB_MFPL', 'SPI1_SS:SYS_GPB_MFPL_PB2MFP_SPI1_SS@GPB_MFPL', 'UART1_RXD:SYS_GPB_MFPL_PB2MFP_UART1_RXD@GPB_MFPL', 'UART5_nCTS:SYS_GPB_MFPL_PB2MFP_UART5_nCTS@GPB_MFPL', 'USCI1_DAT0:SYS_GPB_MFPL_PB2MFP_USCI1_DAT0@GPB_MFPL', 'SC0_PWR:SYS_GPB_MFPL_PB2MFP_SC0_PWR@GPB_MFPL', 'I2S0_DO:SYS_GPB_MFPL_PB2MFP_I2S0_DO@GPB_MFPL', 'EPWM0_CH3:SYS_GPB_MFPL_PB2MFP_EPWM0_CH3@GPB_MFPL', 'I2C1_SDA:SYS_GPB_MFPL_PB2MFP_I2C1_SDA@GPB_MFPL', 'TM3:SYS_GPB_MFPL_PB2MFP_TM3@GPB_MFPL', 'INT3:SYS_GPB_MFPL_PB2MFP_INT3@GPB_MFPL'] },
	{ f: ['PB.3', 'GPIO:SYS_GPB_MFPL_PB3MFP_GPIO@GPB_MFPL', 'ACMP0_N:SYS_GPB_MFPL_PB3MFP_ACMP0_N@GPB_MFPL', 'EADC0_CH3:SYS_GPB_MFPL_PB3MFP_EADC0_CH3@GPB_MFPL', 'EADC1_CH11:SYS_GPB_MFPL_PB3MFP_EADC1_CH11@GPB_MFPL', 'EBI_ADR2:SYS_GPB_MFPL_PB3MFP_EBI_ADR2@GPB_MFPL', 'SD0_DAT1:SYS_GPB_MFPL_PB3MFP_SD0_DAT1@GPB_MFPL', 'EMAC_RMII_RXD1:SYS_GPB_MFPL_PB3MFP_EMAC_RMII_RXD1@GPB_MFPL', 'SPI1_CLK:SYS_GPB_MFPL_PB3MFP_SPI1_CLK@GPB_MFPL', 'UART1_TXD:SYS_GPB_MFPL_PB3MFP_UART1_TXD@GPB_MFPL', 'UART5_nRTS:SYS_GPB_MFPL_PB3MFP_UART5_nRTS@GPB_MFPL', 'USCI1_DAT1:SYS_GPB_MFPL_PB3MFP_USCI1_DAT1@GPB_MFPL', 'SC0_RST:SYS_GPB_MFPL_PB3MFP_SC0_RST@GPB_MFPL', 'I2S0_DI:SYS_GPB_MFPL_PB3MFP_I2S0_DI@GPB_MFPL', 'EPWM0_CH2:SYS_GPB_MFPL_PB3MFP_EPWM0_CH2@GPB_MFPL', 'I2C1_SCL:SYS_GPB_MFPL_PB3MFP_I2C1_SCL@GPB_MFPL', 'TM2:SYS_GPB_MFPL_PB3MFP_TM2@GPB_MFPL', 'INT2:SYS_GPB_MFPL_PB3MFP_INT2@GPB_MFPL'] },
	{ f: ['PB.4', 'GPIO:SYS_GPB_MFPL_PB4MFP_GPIO@GPB_MFPL', 'ACMP1_P1:SYS_GPB_MFPL_PB4MFP_ACMP1_P1@GPB_MFPL', 'EADC0_CH4:SYS_GPB_MFPL_PB4MFP_EADC0_CH4@GPB_MFPL', 'OPA0_P:SYS_GPB_MFPL_PB4MFP_OPA0_P@GPB_MFPL', 'EBI_ADR1:SYS_GPB_MFPL_PB4MFP_EBI_ADR1@GPB_MFPL', 'SD0_DAT2:SYS_GPB_MFPL_PB4MFP_SD0_DAT2@GPB_MFPL', 'EMAC_RMII_RXD0:SYS_GPB_MFPL_PB4MFP_EMAC_RMII_RXD0@GPB_MFPL', 'SPI1_MOSI:SYS_GPB_MFPL_PB4MFP_SPI1_MOSI@GPB_MFPL', 'I2C0_SDA:SYS_GPB_MFPL_PB4MFP_I2C0_SDA@GPB_MFPL', 'UART5_RXD:SYS_GPB_MFPL_PB4MFP_UART5_RXD@GPB_MFPL', 'USCI1_CTL1:SYS_GPB_MFPL_PB4MFP_USCI1_CTL1@GPB_MFPL', 'SC0_DAT:SYS_GPB_MFPL_PB4MFP_SC0_DAT@GPB_MFPL', 'I2S0_MCLK:SYS_GPB_MFPL_PB4MFP_I2S0_MCLK@GPB_MFPL', 'EPWM0_CH1:SYS_GPB_MFPL_PB4MFP_EPWM0_CH1@GPB_MFPL', 'UART2_RXD:SYS_GPB_MFPL_PB4MFP_UART2_RXD@GPB_MFPL', 'TM1:SYS_GPB_MFPL_PB4MFP_TM1@GPB_MFPL', 'INT1:SYS_GPB_MFPL_PB4MFP_INT1@GPB_MFPL'] },
	{ f: ['PB.5', 'GPIO:SYS_GPB_MFPL_PB5MFP_GPIO@GPB_MFPL', 'ACMP1_N:SYS_GPB_MFPL_PB5MFP_ACMP1_N@GPB_MFPL', 'EADC0_CH5:SYS_GPB_MFPL_PB5MFP_EADC0_CH5@GPB_MFPL', 'OPA0_N:SYS_GPB_MFPL_PB5MFP_OPA0_N@GPB_MFPL', 'EBI_ADR0:SYS_GPB_MFPL_PB5MFP_EBI_ADR0@GPB_MFPL', 'SD0_DAT3:SYS_GPB_MFPL_PB5MFP_SD0_DAT3@GPB_MFPL', 'EMAC_RMII_REFCLK:SYS_GPB_MFPL_PB5MFP_EMAC_RMII_REFCLK@GPB_MFPL', 'SPI1_MISO:SYS_GPB_MFPL_PB5MFP_SPI1_MISO@GPB_MFPL', 'I2C0_SCL:SYS_GPB_MFPL_PB5MFP_I2C0_SCL@GPB_MFPL', 'UART5_TXD:SYS_GPB_MFPL_PB5MFP_UART5_TXD@GPB_MFPL', 'USCI1_CTL0:SYS_GPB_MFPL_PB5MFP_USCI1_CTL0@GPB_MFPL', 'SC0_CLK:SYS_GPB_MFPL_PB5MFP_SC0_CLK@GPB_MFPL', 'I2S0_BCLK:SYS_GPB_MFPL_PB5MFP_I2S0_BCLK@GPB_MFPL', 'EPWM0_CH0:SYS_GPB_MFPL_PB5MFP_EPWM0_CH0@GPB_MFPL', 'UART2_TXD:SYS_GPB_MFPL_PB5MFP_UART2_TXD@GPB_MFPL', 'TM0:SYS_GPB_MFPL_PB5MFP_TM0@GPB_MFPL', 'INT0:SYS_GPB_MFPL_PB5MFP_INT0@GPB_MFPL'] },
	{ f: ['PB.6', 'GPIO:SYS_GPB_MFPL_PB6MFP_GPIO@GPB_MFPL', 'EADC0_CH6:SYS_GPB_MFPL_PB6MFP_EADC0_CH6@GPB_MFPL', 'EBI_nWRH:SYS_GPB_MFPL_PB6MFP_EBI_nWRH@GPB_MFPL', 'OPA0_O:SYS_GPB_MFPL_PB6MFP_OPA0_O@GPB_MFPL', 'EMAC_PPS:SYS_GPB_MFPL_PB6MFP_EMAC_PPS@GPB_MFPL', 'USCI1_DAT1:SYS_GPB_MFPL_PB6MFP_USCI1_DAT1@GPB_MFPL', 'CAN1_RXD:SYS_GPB_MFPL_PB6MFP_CAN1_RXD@GPB_MFPL', 'UART1_RXD:SYS_GPB_MFPL_PB6MFP_UART1_RXD@GPB_MFPL', 'SD1_CLK:SYS_GPB_MFPL_PB6MFP_SD1_CLK@GPB_MFPL', 'EBI_nCS1:SYS_GPB_MFPL_PB6MFP_EBI_nCS1@GPB_MFPL', 'BPWM1_CH5:SYS_GPB_MFPL_PB6MFP_BPWM1_CH5@GPB_MFPL', 'EPWM1_BRAKE1:SYS_GPB_MFPL_PB6MFP_EPWM1_BRAKE1@GPB_MFPL', 'EPWM1_CH5:SYS_GPB_MFPL_PB6MFP_EPWM1_CH5@GPB_MFPL', 'INT4:SYS_GPB_MFPL_PB6MFP_INT4@GPB_MFPL', 'USB_VBUS_EN:SYS_GPB_MFPL_PB6MFP_USB_VBUS_EN@GPB_MFPL', 'ACMP1_O:SYS_GPB_MFPL_PB6MFP_ACMP1_O@GPB_MFPL'] },
	{ f: ['PB.7', 'GPIO:SYS_GPB_MFPL_PB7MFP_GPIO@GPB_MFPL', 'EADC0_CH7:SYS_GPB_MFPL_PB7MFP_EADC0_CH7@GPB_MFPL', 'EBI_nWRL:SYS_GPB_MFPL_PB7MFP_EBI_nWRL@GPB_MFPL', 'EMAC_RMII_TXEN:SYS_GPB_MFPL_PB7MFP_EMAC_RMII_TXEN@GPB_MFPL', 'USCI1_DAT0:SYS_GPB_MFPL_PB7MFP_USCI1_DAT0@GPB_MFPL', 'CAN1_TXD:SYS_GPB_MFPL_PB7MFP_CAN1_TXD@GPB_MFPL', 'UART1_TXD:SYS_GPB_MFPL_PB7MFP_UART1_TXD@GPB_MFPL', 'SD1_CMD:SYS_GPB_MFPL_PB7MFP_SD1_CMD@GPB_MFPL', 'EBI_nCS0:SYS_GPB_MFPL_PB7MFP_EBI_nCS0@GPB_MFPL', 'BPWM1_CH4:SYS_GPB_MFPL_PB7MFP_BPWM1_CH4@GPB_MFPL', 'EPWM1_BRAKE0:SYS_GPB_MFPL_PB7MFP_EPWM1_BRAKE0@GPB_MFPL', 'EPWM1_CH4:SYS_GPB_MFPL_PB7MFP_EPWM1_CH4@GPB_MFPL', 'INT5:SYS_GPB_MFPL_PB7MFP_INT5@GPB_MFPL', 'USB_VBUS_ST:SYS_GPB_MFPL_PB7MFP_USB_VBUS_ST@GPB_MFPL', 'ACMP0_O:SYS_GPB_MFPL_PB7MFP_ACMP0_O@GPB_MFPL'] },
	{ f: ['PB.8', 'GPIO:SYS_GPB_MFPH_PB8MFP_GPIO@GPB_MFPH', 'EADC0_CH8:SYS_GPB_MFPH_PB8MFP_EADC0_CH8@GPB_MFPH', 'EBI_ADR19:SYS_GPB_MFPH_PB8MFP_EBI_ADR19@GPB_MFPH', 'EMAC_RMII_TXD1:SYS_GPB_MFPH_PB8MFP_EMAC_RMII_TXD1@GPB_MFPH', 'USCI1_CLK:SYS_GPB_MFPH_PB8MFP_USCI1_CLK@GPB_MFPH', 'UART0_RXD:SYS_GPB_MFPH_PB8MFP_UART0_RXD@GPB_MFPH', 'UART1_nRTS:SYS_GPB_MFPH_PB8MFP_UART1_nRTS@GPB_MFPH', 'I2C1_SMBSUS:SYS_GPB_MFPH_PB8MFP_I2C1_SMBSUS@GPB_MFPH', 'UART7_RXD:SYS_GPB_MFPH_PB8MFP_UART7_RXD@GPB_MFPH', 'I2C0_SDA:SYS_GPB_MFPH_PB8MFP_I2C0_SDA@GPB_MFPH', 'BPWM1_CH3:SYS_GPB_MFPH_PB8MFP_BPWM1_CH3@GPB_MFPH', 'SPI3_MOSI:SYS_GPB_MFPH_PB8MFP_SPI3_MOSI@GPB_MFPH', 'CAN2_RXD:SYS_GPB_MFPH_PB8MFP_CAN2_RXD@GPB_MFPH', 'INT6:SYS_GPB_MFPH_PB8MFP_INT6@GPB_MFPH'] },
	{ f: ['PB.9', 'GPIO:SYS_GPB_MFPH_PB9MFP_GPIO@GPB_MFPH', 'EADC0_CH9:SYS_GPB_MFPH_PB9MFP_EADC0_CH9@GPB_MFPH', 'EBI_ADR18:SYS_GPB_MFPH_PB9MFP_EBI_ADR18@GPB_MFPH', 'EMAC_RMII_TXD0:SYS_GPB_MFPH_PB9MFP_EMAC_RMII_TXD0@GPB_MFPH', 'USCI1_CTL1:SYS_GPB_MFPH_PB9MFP_USCI1_CTL1@GPB_MFPH', 'UART0_TXD:SYS_GPB_MFPH_PB9MFP_UART0_TXD@GPB_MFPH', 'UART1_nCTS:SYS_GPB_MFPH_PB9MFP_UART1_nCTS@GPB_MFPH', 'I2C1_SMBAL:SYS_GPB_MFPH_PB9MFP_I2C1_SMBAL@GPB_MFPH', 'UART7_TXD:SYS_GPB_MFPH_PB9MFP_UART7_TXD@GPB_MFPH', 'I2C0_SCL:SYS_GPB_MFPH_PB9MFP_I2C0_SCL@GPB_MFPH', 'BPWM1_CH2:SYS_GPB_MFPH_PB9MFP_BPWM1_CH2@GPB_MFPH', 'SPI3_MISO:SYS_GPB_MFPH_PB9MFP_SPI3_MISO@GPB_MFPH', 'CAN2_TXD:SYS_GPB_MFPH_PB9MFP_CAN2_TXD@GPB_MFPH', 'INT7:SYS_GPB_MFPH_PB9MFP_INT7@GPB_MFPH', 'CCAP_HSYNC:SYS_GPB_MFPH_PB9MFP_CCAP_HSYNC@GPB_MFPH'] },
	{ f: ['PB.10', 'GPIO:SYS_GPB_MFPH_PB10MFP_GPIO@GPB_MFPH', 'EADC0_CH10:SYS_GPB_MFPH_PB10MFP_EADC0_CH10@GPB_MFPH', 'EBI_ADR17:SYS_GPB_MFPH_PB10MFP_EBI_ADR17@GPB_MFPH', 'EMAC_RMII_MDIO:SYS_GPB_MFPH_PB10MFP_EMAC_RMII_MDIO@GPB_MFPH', 'USCI1_CTL0:SYS_GPB_MFPH_PB10MFP_USCI1_CTL0@GPB_MFPH', 'UART0_nRTS:SYS_GPB_MFPH_PB10MFP_UART0_nRTS@GPB_MFPH', 'UART4_RXD:SYS_GPB_MFPH_PB10MFP_UART4_RXD@GPB_MFPH', 'I2C1_SDA:SYS_GPB_MFPH_PB10MFP_I2C1_SDA@GPB_MFPH', 'CAN0_RXD:SYS_GPB_MFPH_PB10MFP_CAN0_RXD@GPB_MFPH', 'BPWM1_CH1:SYS_GPB_MFPH_PB10MFP_BPWM1_CH1@GPB_MFPH', 'SPI3_SS:SYS_GPB_MFPH_PB10MFP_SPI3_SS@GPB_MFPH', 'CCAP_VSYNC:SYS_GPB_MFPH_PB10MFP_CCAP_VSYNC@GPB_MFPH', 'HSUSB_VBUS_EN:SYS_GPB_MFPH_PB10MFP_HSUSB_VBUS_EN@GPB_MFPH'] },
	{ f: ['PB.11', 'GPIO:SYS_GPB_MFPH_PB11MFP_GPIO@GPB_MFPH', 'EADC0_CH11:SYS_GPB_MFPH_PB11MFP_EADC0_CH11@GPB_MFPH', 'EBI_ADR16:SYS_GPB_MFPH_PB11MFP_EBI_ADR16@GPB_MFPH', 'EMAC_RMII_MDC:SYS_GPB_MFPH_PB11MFP_EMAC_RMII_MDC@GPB_MFPH', 'UART0_nCTS:SYS_GPB_MFPH_PB11MFP_UART0_nCTS@GPB_MFPH', 'UART4_TXD:SYS_GPB_MFPH_PB11MFP_UART4_TXD@GPB_MFPH', 'I2C1_SCL:SYS_GPB_MFPH_PB11MFP_I2C1_SCL@GPB_MFPH', 'CAN0_TXD:SYS_GPB_MFPH_PB11MFP_CAN0_TXD@GPB_MFPH', 'SPI0_I2SMCLK:SYS_GPB_MFPH_PB11MFP_SPI0_I2SMCLK@GPB_MFPH', 'BPWM1_CH0:SYS_GPB_MFPH_PB11MFP_BPWM1_CH0@GPB_MFPH', 'SPI3_CLK:SYS_GPB_MFPH_PB11MFP_SPI3_CLK@GPB_MFPH', 'CCAP_SFIELD:SYS_GPB_MFPH_PB11MFP_CCAP_SFIELD@GPB_MFPH', 'HSUSB_VBUS_ST:SYS_GPB_MFPH_PB11MFP_HSUSB_VBUS_ST@GPB_MFPH'] },
	{ f: ['PB.12', 'GPIO:SYS_GPB_MFPH_PB12MFP_GPIO@GPB_MFPH', 'ACMP0_P2:SYS_GPB_MFPH_PB12MFP_ACMP0_P2@GPB_MFPH', 'ACMP1_P2:SYS_GPB_MFPH_PB12MFP_ACMP1_P2@GPB_MFPH', 'DAC0_OUT:SYS_GPB_MFPH_PB12MFP_DAC0_OUT@GPB_MFPH', 'EADC0_CH12:SYS_GPB_MFPH_PB12MFP_EADC0_CH12@GPB_MFPH', 'EADC1_CH12:SYS_GPB_MFPH_PB12MFP_EADC1_CH12@GPB_MFPH', 'EBI_AD15:SYS_GPB_MFPH_PB12MFP_EBI_AD15@GPB_MFPH', 'SC1_CLK:SYS_GPB_MFPH_PB12MFP_SC1_CLK@GPB_MFPH', 'SPI0_MOSI:SYS_GPB_MFPH_PB12MFP_SPI0_MOSI@GPB_MFPH', 'USCI0_CLK:SYS_GPB_MFPH_PB12MFP_USCI0_CLK@GPB_MFPH', 'UART0_RXD:SYS_GPB_MFPH_PB12MFP_UART0_RXD@GPB_MFPH', 'UART3_nCTS:SYS_GPB_MFPH_PB12MFP_UART3_nCTS@GPB_MFPH', 'I2C2_SDA:SYS_GPB_MFPH_PB12MFP_I2C2_SDA@GPB_MFPH', 'SD0_nCD:SYS_GPB_MFPH_PB12MFP_SD0_nCD@GPB_MFPH', 'CCAP_SCLK:SYS_GPB_MFPH_PB12MFP_CCAP_SCLK@GPB_MFPH', 'EPWM1_CH3:SYS_GPB_MFPH_PB12MFP_EPWM1_CH3@GPB_MFPH', 'ETM_TRACE_DATA3:SYS_GPB_MFPH_PB12MFP_ETM_TRACE_DATA3@GPB_MFPH', 'TM3_EXT:SYS_GPB_MFPH_PB12MFP_TM3_EXT@GPB_MFPH'] },
	{ f: ['PB.13', 'GPIO:SYS_GPB_MFPH_PB13MFP_GPIO@GPB_MFPH', 'ACMP0_P3:SYS_GPB_MFPH_PB13MFP_ACMP0_P3@GPB_MFPH', 'ACMP1_P3:SYS_GPB_MFPH_PB13MFP_ACMP1_P3@GPB_MFPH', 'DAC1_OUT:SYS_GPB_MFPH_PB13MFP_DAC1_OUT@GPB_MFPH', 'EADC0_CH13:SYS_GPB_MFPH_PB13MFP_EADC0_CH13@GPB_MFPH', 'EADC1_CH13:SYS_GPB_MFPH_PB13MFP_EADC1_CH13@GPB_MFPH', 'EBI_AD14:SYS_GPB_MFPH_PB13MFP_EBI_AD14@GPB_MFPH', 'SC1_DAT:SYS_GPB_MFPH_PB13MFP_SC1_DAT@GPB_MFPH', 'SPI0_MISO:SYS_GPB_MFPH_PB13MFP_SPI0_MISO@GPB_MFPH', 'USCI0_DAT0:SYS_GPB_MFPH_PB13MFP_USCI0_DAT0@GPB_MFPH', 'UART0_TXD:SYS_GPB_MFPH_PB13MFP_UART0_TXD@GPB_MFPH', 'UART3_nRTS:SYS_GPB_MFPH_PB13MFP_UART3_nRTS@GPB_MFPH', 'I2C2_SCL:SYS_GPB_MFPH_PB13MFP_I2C2_SCL@GPB_MFPH', 'CCAP_PIXCLK:SYS_GPB_MFPH_PB13MFP_CCAP_PIXCLK@GPB_MFPH', 'EPWM1_CH2:SYS_GPB_MFPH_PB13MFP_EPWM1_CH2@GPB_MFPH', 'ETM_TRACE_DATA2:SYS_GPB_MFPH_PB13MFP_ETM_TRACE_DATA2@GPB_MFPH', 'TM2_EXT:SYS_GPB_MFPH_PB13MFP_TM2_EXT@GPB_MFPH'] },
	{ f: ['PB.14', 'GPIO:SYS_GPB_MFPH_PB14MFP_GPIO@GPB_MFPH', 'EADC0_CH14:SYS_GPB_MFPH_PB14MFP_EADC0_CH14@GPB_MFPH', 'EADC1_CH14:SYS_GPB_MFPH_PB14MFP_EADC1_CH14@GPB_MFPH', 'EBI_AD13:SYS_GPB_MFPH_PB14MFP_EBI_AD13@GPB_MFPH', 'SC1_RST:SYS_GPB_MFPH_PB14MFP_SC1_RST@GPB_MFPH', 'SPI0_CLK:SYS_GPB_MFPH_PB14MFP_SPI0_CLK@GPB_MFPH', 'USCI0_DAT1:SYS_GPB_MFPH_PB14MFP_USCI0_DAT1@GPB_MFPH', 'UART0_nRTS:SYS_GPB_MFPH_PB14MFP_UART0_nRTS@GPB_MFPH', 'UART3_RXD:SYS_GPB_MFPH_PB14MFP_UART3_RXD@GPB_MFPH', 'I2C2_SMBSUS:SYS_GPB_MFPH_PB14MFP_I2C2_SMBSUS@GPB_MFPH', 'EPWM1_CH1:SYS_GPB_MFPH_PB14MFP_EPWM1_CH1@GPB_MFPH', 'ETM_TRACE_DATA1:SYS_GPB_MFPH_PB14MFP_ETM_TRACE_DATA1@GPB_MFPH', 'TM1_EXT:SYS_GPB_MFPH_PB14MFP_TM1_EXT@GPB_MFPH', 'CLKO:SYS_GPB_MFPH_PB14MFP_CLKO@GPB_MFPH', 'USB_VBUS_ST:SYS_GPB_MFPH_PB14MFP_USB_VBUS_ST@GPB_MFPH'] },
	{ f: ['PB.15', 'GPIO:SYS_GPB_MFPH_PB15MFP_GPIO@GPB_MFPH', 'EADC0_CH15:SYS_GPB_MFPH_PB15MFP_EADC0_CH15@GPB_MFPH', 'EADC1_CH15:SYS_GPB_MFPH_PB15MFP_EADC1_CH15@GPB_MFPH', 'EBI_AD12:SYS_GPB_MFPH_PB15MFP_EBI_AD12@GPB_MFPH', 'SC1_PWR:SYS_GPB_MFPH_PB15MFP_SC1_PWR@GPB_MFPH', 'SPI0_SS:SYS_GPB_MFPH_PB15MFP_SPI0_SS@GPB_MFPH', 'USCI0_CTL1:SYS_GPB_MFPH_PB15MFP_USCI0_CTL1@GPB_MFPH', 'UART0_nCTS:SYS_GPB_MFPH_PB15MFP_UART0_nCTS@GPB_MFPH', 'UART3_TXD:SYS_GPB_MFPH_PB15MFP_UART3_TXD@GPB_MFPH', 'I2C2_SMBAL:SYS_GPB_MFPH_PB15MFP_I2C2_SMBAL@GPB_MFPH', 'EPWM0_BRAKE1:SYS_GPB_MFPH_PB15MFP_EPWM0_BRAKE1@GPB_MFPH', 'EPWM1_CH0:SYS_GPB_MFPH_PB15MFP_EPWM1_CH0@GPB_MFPH', 'ETM_TRACE_DATA0:SYS_GPB_MFPH_PB15MFP_ETM_TRACE_DATA0@GPB_MFPH', 'TM0_EXT:SYS_GPB_MFPH_PB15MFP_TM0_EXT@GPB_MFPH', 'USB_VBUS_EN:SYS_GPB_MFPH_PB15MFP_USB_VBUS_EN@GPB_MFPH', 'HSUSB_VBUS_EN:SYS_GPB_MFPH_PB15MFP_HSUSB_VBUS_EN@GPB_MFPH'] },

	{ f: ['PC.0', 'GPIO:SYS_GPC_MFPL_PC0MFP_GPIO@GPC_MFPL', 'EBI_AD0:SYS_GPC_MFPL_PC0MFP_EBI_AD0@GPC_MFPL', 'SPIM_MOSI:SYS_GPC_MFPL_PC0MFP_SPIM_MOSI@GPC_MFPL', 'QSPI0_MOSI0:SYS_GPC_MFPL_PC0MFP_QSPI0_MOSI0@GPC_MFPL', 'SC1_CLK:SYS_GPC_MFPL_PC0MFP_SC1_CLK@GPC_MFPL', 'I2S0_LRCK:SYS_GPC_MFPL_PC0MFP_I2S0_LRCK@GPC_MFPL', 'SPI1_SS:SYS_GPC_MFPL_PC0MFP_SPI1_SS@GPC_MFPL', 'UART2_RXD:SYS_GPC_MFPL_PC0MFP_UART2_RXD@GPC_MFPL', 'I2C0_SDA:SYS_GPC_MFPL_PC0MFP_I2C0_SDA@GPC_MFPL', 'CAN2_RXD:SYS_GPC_MFPL_PC0MFP_CAN2_RXD@GPC_MFPL', 'EPWM1_CH5:SYS_GPC_MFPL_PC0MFP_EPWM1_CH5@GPC_MFPL', 'CCAP_DATA0:SYS_GPC_MFPL_PC0MFP_CCAP_DATA0@GPC_MFPL', 'ACMP1_O:SYS_GPC_MFPL_PC0MFP_ACMP1_O@GPC_MFPL', 'EADC1_ST:SYS_GPC_MFPL_PC0MFP_EADC1_ST@GPC_MFPL'] },
	{ f: ['PC.1', 'GPIO:SYS_GPC_MFPL_PC1MFP_GPIO@GPC_MFPL', 'EBI_AD1:SYS_GPC_MFPL_PC1MFP_EBI_AD1@GPC_MFPL', 'SPIM_MISO:SYS_GPC_MFPL_PC1MFP_SPIM_MISO@GPC_MFPL', 'QSPI0_MISO0:SYS_GPC_MFPL_PC1MFP_QSPI0_MISO0@GPC_MFPL', 'SC1_DAT:SYS_GPC_MFPL_PC1MFP_SC1_DAT@GPC_MFPL', 'I2S0_DO:SYS_GPC_MFPL_PC1MFP_I2S0_DO@GPC_MFPL', 'SPI1_CLK:SYS_GPC_MFPL_PC1MFP_SPI1_CLK@GPC_MFPL', 'UART2_TXD:SYS_GPC_MFPL_PC1MFP_UART2_TXD@GPC_MFPL', 'I2C0_SCL:SYS_GPC_MFPL_PC1MFP_I2C0_SCL@GPC_MFPL', 'CAN2_TXD:SYS_GPC_MFPL_PC1MFP_CAN2_TXD@GPC_MFPL', 'EPWM1_CH4:SYS_GPC_MFPL_PC1MFP_EPWM1_CH4@GPC_MFPL', 'CCAP_DATA1:SYS_GPC_MFPL_PC1MFP_CCAP_DATA1@GPC_MFPL', 'ACMP0_O:SYS_GPC_MFPL_PC1MFP_ACMP0_O@GPC_MFPL', 'EADC0_ST:SYS_GPC_MFPL_PC1MFP_EADC0_ST@GPC_MFPL'] },
	{ f: ['PC.2', 'GPIO:SYS_GPC_MFPL_PC2MFP_GPIO@GPC_MFPL', 'EBI_AD2:SYS_GPC_MFPL_PC2MFP_EBI_AD2@GPC_MFPL', 'SPIM_CLK:SYS_GPC_MFPL_PC2MFP_SPIM_CLK@GPC_MFPL', 'QSPI0_CLK:SYS_GPC_MFPL_PC2MFP_QSPI0_CLK@GPC_MFPL', 'SC1_RST:SYS_GPC_MFPL_PC2MFP_SC1_RST@GPC_MFPL', 'I2S0_DI:SYS_GPC_MFPL_PC2MFP_I2S0_DI@GPC_MFPL', 'SPI1_MOSI:SYS_GPC_MFPL_PC2MFP_SPI1_MOSI@GPC_MFPL', 'UART2_nCTS:SYS_GPC_MFPL_PC2MFP_UART2_nCTS@GPC_MFPL', 'I2C0_SMBSUS:SYS_GPC_MFPL_PC2MFP_I2C0_SMBSUS@GPC_MFPL', 'CAN1_RXD:SYS_GPC_MFPL_PC2MFP_CAN1_RXD@GPC_MFPL', 'UART3_RXD:SYS_GPC_MFPL_PC2MFP_UART3_RXD@GPC_MFPL', 'EPWM1_CH3:SYS_GPC_MFPL_PC2MFP_EPWM1_CH3@GPC_MFPL', 'CCAP_DATA2:SYS_GPC_MFPL_PC2MFP_CCAP_DATA2@GPC_MFPL', 'QSPI1_MOSI0:SYS_GPC_MFPL_PC2MFP_QSPI1_MOSI0@GPC_MFPL'] },
	{ f: ['PC.3', 'GPIO:SYS_GPC_MFPL_PC3MFP_GPIO@GPC_MFPL', 'EBI_AD3:SYS_GPC_MFPL_PC3MFP_EBI_AD3@GPC_MFPL', 'SPIM_SS:SYS_GPC_MFPL_PC3MFP_SPIM_SS@GPC_MFPL', 'QSPI0_SS:SYS_GPC_MFPL_PC3MFP_QSPI0_SS@GPC_MFPL', 'SC1_PWR:SYS_GPC_MFPL_PC3MFP_SC1_PWR@GPC_MFPL', 'I2S0_MCLK:SYS_GPC_MFPL_PC3MFP_I2S0_MCLK@GPC_MFPL', 'SPI1_MISO:SYS_GPC_MFPL_PC3MFP_SPI1_MISO@GPC_MFPL', 'UART2_nRTS:SYS_GPC_MFPL_PC3MFP_UART2_nRTS@GPC_MFPL', 'I2C0_SMBAL:SYS_GPC_MFPL_PC3MFP_I2C0_SMBAL@GPC_MFPL', 'CAN1_TXD:SYS_GPC_MFPL_PC3MFP_CAN1_TXD@GPC_MFPL', 'UART3_TXD:SYS_GPC_MFPL_PC3MFP_UART3_TXD@GPC_MFPL', 'EPWM1_CH2:SYS_GPC_MFPL_PC3MFP_EPWM1_CH2@GPC_MFPL', 'CCAP_DATA3:SYS_GPC_MFPL_PC3MFP_CCAP_DATA3@GPC_MFPL', 'QSPI1_MISO0:SYS_GPC_MFPL_PC3MFP_QSPI1_MISO0@GPC_MFPL'] },
	{ f: ['PC.4', 'GPIO:SYS_GPC_MFPL_PC4MFP_GPIO@GPC_MFPL', 'EBI_AD4:SYS_GPC_MFPL_PC4MFP_EBI_AD4@GPC_MFPL', 'SPIM_D3:SYS_GPC_MFPL_PC4MFP_SPIM_D3@GPC_MFPL', 'QSPI0_MOSI1:SYS_GPC_MFPL_PC4MFP_QSPI0_MOSI1@GPC_MFPL', 'SC1_nCD:SYS_GPC_MFPL_PC4MFP_SC1_nCD@GPC_MFPL', 'I2S0_BCLK:SYS_GPC_MFPL_PC4MFP_I2S0_BCLK@GPC_MFPL', 'SPI1_I2SMCLK:SYS_GPC_MFPL_PC4MFP_SPI1_I2SMCLK@GPC_MFPL', 'UART2_RXD:SYS_GPC_MFPL_PC4MFP_UART2_RXD@GPC_MFPL', 'I2C1_SDA:SYS_GPC_MFPL_PC4MFP_I2C1_SDA@GPC_MFPL', 'CAN0_RXD:SYS_GPC_MFPL_PC4MFP_CAN0_RXD@GPC_MFPL', 'UART4_RXD:SYS_GPC_MFPL_PC4MFP_UART4_RXD@GPC_MFPL', 'EPWM1_CH1:SYS_GPC_MFPL_PC4MFP_EPWM1_CH1@GPC_MFPL', 'CCAP_DATA4:SYS_GPC_MFPL_PC4MFP_CCAP_DATA4@GPC_MFPL', 'QSPI1_CLK:SYS_GPC_MFPL_PC4MFP_QSPI1_CLK@GPC_MFPL'] },
	{ f: ['PC.5', 'GPIO:SYS_GPC_MFPL_PC5MFP_GPIO@GPC_MFPL', 'EBI_AD5:SYS_GPC_MFPL_PC5MFP_EBI_AD5@GPC_MFPL', 'SPIM_D2:SYS_GPC_MFPL_PC5MFP_SPIM_D2@GPC_MFPL', 'QSPI0_MISO1:SYS_GPC_MFPL_PC5MFP_QSPI0_MISO1@GPC_MFPL', 'UART2_TXD:SYS_GPC_MFPL_PC5MFP_UART2_TXD@GPC_MFPL', 'I2C1_SCL:SYS_GPC_MFPL_PC5MFP_I2C1_SCL@GPC_MFPL', 'CAN0_TXD:SYS_GPC_MFPL_PC5MFP_CAN0_TXD@GPC_MFPL', 'UART4_TXD:SYS_GPC_MFPL_PC5MFP_UART4_TXD@GPC_MFPL', 'EPWM1_CH0:SYS_GPC_MFPL_PC5MFP_EPWM1_CH0@GPC_MFPL', 'CCAP_DATA5:SYS_GPC_MFPL_PC5MFP_CCAP_DATA5@GPC_MFPL', 'QSPI1_SS:SYS_GPC_MFPL_PC5MFP_QSPI1_SS@GPC_MFPL'] },
	{ f: ['PC.6', 'GPIO:SYS_GPC_MFPL_PC6MFP_GPIO@GPC_MFPL', 'EBI_AD8:SYS_GPC_MFPL_PC6MFP_EBI_AD8@GPC_MFPL', 'EMAC_RMII_RXD1:SYS_GPC_MFPL_PC6MFP_EMAC_RMII_RXD1@GPC_MFPL', 'SPI1_MOSI:SYS_GPC_MFPL_PC6MFP_SPI1_MOSI@GPC_MFPL', 'UART4_RXD:SYS_GPC_MFPL_PC6MFP_UART4_RXD@GPC_MFPL', 'SC2_RST:SYS_GPC_MFPL_PC6MFP_SC2_RST@GPC_MFPL', 'UART0_nRTS:SYS_GPC_MFPL_PC6MFP_UART0_nRTS@GPC_MFPL', 'I2C1_SMBSUS:SYS_GPC_MFPL_PC6MFP_I2C1_SMBSUS@GPC_MFPL', 'UART6_RXD:SYS_GPC_MFPL_PC6MFP_UART6_RXD@GPC_MFPL', 'EPWM1_CH3:SYS_GPC_MFPL_PC6MFP_EPWM1_CH3@GPC_MFPL', 'BPWM1_CH1:SYS_GPC_MFPL_PC6MFP_BPWM1_CH1@GPC_MFPL', 'TM1:SYS_GPC_MFPL_PC6MFP_TM1@GPC_MFPL', 'INT2:SYS_GPC_MFPL_PC6MFP_INT2@GPC_MFPL'] },
	{ f: ['PC.7', 'GPIO:SYS_GPC_MFPL_PC7MFP_GPIO@GPC_MFPL', 'EBI_AD9:SYS_GPC_MFPL_PC7MFP_EBI_AD9@GPC_MFPL', 'EMAC_RMII_RXD0:SYS_GPC_MFPL_PC7MFP_EMAC_RMII_RXD0@GPC_MFPL', 'SPI1_MISO:SYS_GPC_MFPL_PC7MFP_SPI1_MISO@GPC_MFPL', 'UART4_TXD:SYS_GPC_MFPL_PC7MFP_UART4_TXD@GPC_MFPL', 'SC2_PWR:SYS_GPC_MFPL_PC7MFP_SC2_PWR@GPC_MFPL', 'UART0_nCTS:SYS_GPC_MFPL_PC7MFP_UART0_nCTS@GPC_MFPL', 'I2C1_SMBAL:SYS_GPC_MFPL_PC7MFP_I2C1_SMBAL@GPC_MFPL', 'UART6_TXD:SYS_GPC_MFPL_PC7MFP_UART6_TXD@GPC_MFPL', 'EPWM1_CH2:SYS_GPC_MFPL_PC7MFP_EPWM1_CH2@GPC_MFPL', 'BPWM1_CH0:SYS_GPC_MFPL_PC7MFP_BPWM1_CH0@GPC_MFPL', 'TM0:SYS_GPC_MFPL_PC7MFP_TM0@GPC_MFPL', 'INT3:SYS_GPC_MFPL_PC7MFP_INT3@GPC_MFPL'] },
	{ f: ['PC.8', 'GPIO:SYS_GPC_MFPH_PC8MFP_GPIO@GPC_MFPH', 'EBI_ADR16:SYS_GPC_MFPH_PC8MFP_EBI_ADR16@GPC_MFPH', 'EMAC_RMII_REFCLK:SYS_GPC_MFPH_PC8MFP_EMAC_RMII_REFCLK@GPC_MFPH', 'I2C0_SDA:SYS_GPC_MFPH_PC8MFP_I2C0_SDA@GPC_MFPH', 'UART4_nCTS:SYS_GPC_MFPH_PC8MFP_UART4_nCTS@GPC_MFPH', 'UART1_RXD:SYS_GPC_MFPH_PC8MFP_UART1_RXD@GPC_MFPH', 'EPWM1_CH1:SYS_GPC_MFPH_PC8MFP_EPWM1_CH1@GPC_MFPH', 'BPWM1_CH4:SYS_GPC_MFPH_PC8MFP_BPWM1_CH4@GPC_MFPH'] },
	{ f: ['PC.9', 'GPIO:SYS_GPC_MFPH_PC9MFP_GPIO@GPC_MFPH', 'EBI_ADR7:SYS_GPC_MFPH_PC9MFP_EBI_ADR7@GPC_MFPH', 'UART6_nCTS:SYS_GPC_MFPH_PC9MFP_UART6_nCTS@GPC_MFPH', 'SPI3_SS:SYS_GPC_MFPH_PC9MFP_SPI3_SS@GPC_MFPH', 'UART3_RXD:SYS_GPC_MFPH_PC9MFP_UART3_RXD@GPC_MFPH', 'CAN1_RXD:SYS_GPC_MFPH_PC9MFP_CAN1_RXD@GPC_MFPH', 'EPWM1_CH3:SYS_GPC_MFPH_PC9MFP_EPWM1_CH3@GPC_MFPH', 'EADC1_ST:SYS_GPC_MFPH_PC9MFP_EADC1_ST@GPC_MFPH'] },
	{ f: ['PC.10', 'GPIO:SYS_GPC_MFPH_PC10MFP_GPIO@GPC_MFPH', 'EBI_ADR6:SYS_GPC_MFPH_PC10MFP_EBI_ADR6@GPC_MFPH', 'UART6_nRTS:SYS_GPC_MFPH_PC10MFP_UART6_nRTS@GPC_MFPH', 'SPI3_CLK:SYS_GPC_MFPH_PC10MFP_SPI3_CLK@GPC_MFPH', 'UART3_TXD:SYS_GPC_MFPH_PC10MFP_UART3_TXD@GPC_MFPH', 'CAN1_TXD:SYS_GPC_MFPH_PC10MFP_CAN1_TXD@GPC_MFPH', 'ECAP1_IC0:SYS_GPC_MFPH_PC10MFP_ECAP1_IC0@GPC_MFPH', 'EPWM1_CH2:SYS_GPC_MFPH_PC10MFP_EPWM1_CH2@GPC_MFPH', 'EADC1_ST:SYS_GPC_MFPH_PC10MFP_EADC1_ST@GPC_MFPH'] },
	{ f: ['PC.11', 'GPIO:SYS_GPC_MFPH_PC11MFP_GPIO@GPC_MFPH', 'EBI_ADR5:SYS_GPC_MFPH_PC11MFP_EBI_ADR5@GPC_MFPH', 'UART0_RXD:SYS_GPC_MFPH_PC11MFP_UART0_RXD@GPC_MFPH', 'I2C0_SDA:SYS_GPC_MFPH_PC11MFP_I2C0_SDA@GPC_MFPH', 'UART6_RXD:SYS_GPC_MFPH_PC11MFP_UART6_RXD@GPC_MFPH', 'SPI3_MOSI:SYS_GPC_MFPH_PC11MFP_SPI3_MOSI@GPC_MFPH', 'ECAP1_IC1:SYS_GPC_MFPH_PC11MFP_ECAP1_IC1@GPC_MFPH', 'EPWM1_CH1:SYS_GPC_MFPH_PC11MFP_EPWM1_CH1@GPC_MFPH', 'ACMP1_O:SYS_GPC_MFPH_PC11MFP_ACMP1_O@GPC_MFPH'] },
	{ f: ['PC.12', 'GPIO:SYS_GPC_MFPH_PC12MFP_GPIO@GPC_MFPH', 'EBI_ADR4:SYS_GPC_MFPH_PC12MFP_EBI_ADR4@GPC_MFPH', 'UART0_TXD:SYS_GPC_MFPH_PC12MFP_UART0_TXD@GPC_MFPH', 'I2C0_SCL:SYS_GPC_MFPH_PC12MFP_I2C0_SCL@GPC_MFPH', 'UART6_TXD:SYS_GPC_MFPH_PC12MFP_UART6_TXD@GPC_MFPH', 'SPI3_MISO:SYS_GPC_MFPH_PC12MFP_SPI3_MISO@GPC_MFPH', 'SC0_nCD:SYS_GPC_MFPH_PC12MFP_SC0_nCD@GPC_MFPH', 'ECAP1_IC2:SYS_GPC_MFPH_PC12MFP_ECAP1_IC2@GPC_MFPH', 'EPWM1_CH0:SYS_GPC_MFPH_PC12MFP_EPWM1_CH0@GPC_MFPH', 'ACMP0_O:SYS_GPC_MFPH_PC12MFP_ACMP0_O@GPC_MFPH'] },
	{ f: ['PC.13', 'GPIO:SYS_GPC_MFPH_PC13MFP_GPIO@GPC_MFPH', 'EADC1_CH3:SYS_GPC_MFPH_PC13MFP_EADC1_CH3@GPC_MFPH', 'EBI_ADR10:SYS_GPC_MFPH_PC13MFP_EBI_ADR10@GPC_MFPH', 'SC2_nCD:SYS_GPC_MFPH_PC13MFP_SC2_nCD@GPC_MFPH', 'SPI2_I2SMCLK:SYS_GPC_MFPH_PC13MFP_SPI2_I2SMCLK@GPC_MFPH', 'CAN1_TXD:SYS_GPC_MFPH_PC13MFP_CAN1_TXD@GPC_MFPH', 'USCI0_CTL0:SYS_GPC_MFPH_PC13MFP_USCI0_CTL0@GPC_MFPH', 'UART2_TXD:SYS_GPC_MFPH_PC13MFP_UART2_TXD@GPC_MFPH', 'BPWM0_CH4:SYS_GPC_MFPH_PC13MFP_BPWM0_CH4@GPC_MFPH', 'CLKO:SYS_GPC_MFPH_PC13MFP_CLKO@GPC_MFPH', 'EADC0_ST:SYS_GPC_MFPH_PC13MFP_EADC0_ST@GPC_MFPH'] },
	{ f: ['PC.14', 'GPIO:SYS_GPC_MFPH_PC14MFP_GPIO@GPC_MFPH', 'EBI_AD11:SYS_GPC_MFPH_PC14MFP_EBI_AD11@GPC_MFPH', 'SC1_nCD:SYS_GPC_MFPH_PC14MFP_SC1_nCD@GPC_MFPH', 'SPI0_I2SMCLK:SYS_GPC_MFPH_PC14MFP_SPI0_I2SMCLK@GPC_MFPH', 'USCI0_CTL0:SYS_GPC_MFPH_PC14MFP_USCI0_CTL0@GPC_MFPH', 'QSPI0_CLK:SYS_GPC_MFPH_PC14MFP_QSPI0_CLK@GPC_MFPH', 'EPWM0_SYNC_IN:SYS_GPC_MFPH_PC14MFP_EPWM0_SYNC_IN@GPC_MFPH', 'ETM_TRACE_CLK:SYS_GPC_MFPH_PC14MFP_ETM_TRACE_CLK@GPC_MFPH', 'TM1:SYS_GPC_MFPH_PC14MFP_TM1@GPC_MFPH', 'USB_VBUS_ST:SYS_GPC_MFPH_PC14MFP_USB_VBUS_ST@GPC_MFPH', 'HSUSB_VBUS_ST:SYS_GPC_MFPH_PC14MFP_HSUSB_VBUS_ST@GPC_MFPH'] },
	{ f: ['PC.15', 'GPIO:SYS_GPC_MFPH_PC15MFP_GPIO@GPC_MFPH'] },

	{ f: ['PD.0', 'GPIO:SYS_GPD_MFPL_PD0MFP_GPIO@GPD_MFPL', 'EBI_AD13:SYS_GPD_MFPL_PD0MFP_EBI_AD13@GPD_MFPL', 'USCI0_CLK:SYS_GPD_MFPL_PD0MFP_USCI0_CLK@GPD_MFPL', 'SPI0_MOSI:SYS_GPD_MFPL_PD0MFP_SPI0_MOSI@GPD_MFPL', 'UART3_RXD:SYS_GPD_MFPL_PD0MFP_UART3_RXD@GPD_MFPL', 'I2C2_SDA:SYS_GPD_MFPL_PD0MFP_I2C2_SDA@GPD_MFPL', 'SC2_CLK:SYS_GPD_MFPL_PD0MFP_SC2_CLK@GPD_MFPL', 'TM2:SYS_GPD_MFPL_PD0MFP_TM2@GPD_MFPL'] },
	{ f: ['PD.1', 'GPIO:SYS_GPD_MFPL_PD1MFP_GPIO@GPD_MFPL', 'EBI_AD12:SYS_GPD_MFPL_PD1MFP_EBI_AD12@GPD_MFPL', 'USCI0_DAT0:SYS_GPD_MFPL_PD1MFP_USCI0_DAT0@GPD_MFPL', 'SPI0_MISO:SYS_GPD_MFPL_PD1MFP_SPI0_MISO@GPD_MFPL', 'UART3_TXD:SYS_GPD_MFPL_PD1MFP_UART3_TXD@GPD_MFPL', 'I2C2_SCL:SYS_GPD_MFPL_PD1MFP_I2C2_SCL@GPD_MFPL', 'SC2_DAT:SYS_GPD_MFPL_PD1MFP_SC2_DAT@GPD_MFPL'] },
	{ f: ['PD.2', 'GPIO:SYS_GPD_MFPL_PD2MFP_GPIO@GPD_MFPL', 'EBI_AD11:SYS_GPD_MFPL_PD2MFP_EBI_AD11@GPD_MFPL', 'USCI0_DAT1:SYS_GPD_MFPL_PD2MFP_USCI0_DAT1@GPD_MFPL', 'SPI0_CLK:SYS_GPD_MFPL_PD2MFP_SPI0_CLK@GPD_MFPL', 'UART3_nCTS:SYS_GPD_MFPL_PD2MFP_UART3_nCTS@GPD_MFPL', 'SC2_RST:SYS_GPD_MFPL_PD2MFP_SC2_RST@GPD_MFPL', 'UART0_RXD:SYS_GPD_MFPL_PD2MFP_UART0_RXD@GPD_MFPL'] },
	{ f: ['PD.3', 'GPIO:SYS_GPD_MFPL_PD3MFP_GPIO@GPD_MFPL', 'EBI_AD10:SYS_GPD_MFPL_PD3MFP_EBI_AD10@GPD_MFPL', 'USCI0_CTL1:SYS_GPD_MFPL_PD3MFP_USCI0_CTL1@GPD_MFPL', 'SPI0_SS:SYS_GPD_MFPL_PD3MFP_SPI0_SS@GPD_MFPL', 'UART3_nRTS:SYS_GPD_MFPL_PD3MFP_UART3_nRTS@GPD_MFPL', 'USCI1_CTL0:SYS_GPD_MFPL_PD3MFP_USCI1_CTL0@GPD_MFPL', 'SC2_PWR:SYS_GPD_MFPL_PD3MFP_SC2_PWR@GPD_MFPL', 'SC1_nCD:SYS_GPD_MFPL_PD3MFP_SC1_nCD@GPD_MFPL', 'UART0_TXD:SYS_GPD_MFPL_PD3MFP_UART0_TXD@GPD_MFPL'] },
	{ f: ['PD.4', 'GPIO:SYS_GPD_MFPL_PD4MFP_GPIO@GPD_MFPL', 'USCI0_CTL0:SYS_GPD_MFPL_PD4MFP_USCI0_CTL0@GPD_MFPL', 'I2C1_SDA:SYS_GPD_MFPL_PD4MFP_I2C1_SDA@GPD_MFPL', 'SPI1_SS:SYS_GPD_MFPL_PD4MFP_SPI1_SS@GPD_MFPL', 'USCI1_CTL1:SYS_GPD_MFPL_PD4MFP_USCI1_CTL1@GPD_MFPL', 'SC1_CLK:SYS_GPD_MFPL_PD4MFP_SC1_CLK@GPD_MFPL', 'USB_VBUS_ST:SYS_GPD_MFPL_PD4MFP_USB_VBUS_ST@GPD_MFPL'] },
	{ f: ['PD.5', 'GPIO:SYS_GPD_MFPL_PD5MFP_GPIO@GPD_MFPL', 'I2C1_SCL:SYS_GPD_MFPL_PD5MFP_I2C1_SCL@GPD_MFPL', 'SPI1_CLK:SYS_GPD_MFPL_PD5MFP_SPI1_CLK@GPD_MFPL', 'USCI1_DAT0:SYS_GPD_MFPL_PD5MFP_USCI1_DAT0@GPD_MFPL', 'SC1_DAT:SYS_GPD_MFPL_PD5MFP_SC1_DAT@GPD_MFPL'] },
	{ f: ['PD.6', 'GPIO:SYS_GPD_MFPL_PD6MFP_GPIO@GPD_MFPL', 'UART1_RXD:SYS_GPD_MFPL_PD6MFP_UART1_RXD@GPD_MFPL', 'I2C0_SDA:SYS_GPD_MFPL_PD6MFP_I2C0_SDA@GPD_MFPL', 'SPI1_MOSI:SYS_GPD_MFPL_PD6MFP_SPI1_MOSI@GPD_MFPL', 'USCI1_DAT1:SYS_GPD_MFPL_PD6MFP_USCI1_DAT1@GPD_MFPL', 'SC1_RST:SYS_GPD_MFPL_PD6MFP_SC1_RST@GPD_MFPL'] },
	{ f: ['PD.7', 'GPIO:SYS_GPD_MFPL_PD7MFP_GPIO@GPD_MFPL', 'UART1_TXD:SYS_GPD_MFPL_PD7MFP_UART1_TXD@GPD_MFPL', 'I2C0_SCL:SYS_GPD_MFPL_PD7MFP_I2C0_SCL@GPD_MFPL', 'SPI1_MISO:SYS_GPD_MFPL_PD7MFP_SPI1_MISO@GPD_MFPL', 'USCI1_CLK:SYS_GPD_MFPL_PD7MFP_USCI1_CLK@GPD_MFPL', 'SC1_PWR:SYS_GPD_MFPL_PD7MFP_SC1_PWR@GPD_MFPL'] },
	{ f: ['PD.8', 'GPIO:SYS_GPD_MFPH_PD8MFP_GPIO@GPD_MFPH', 'EBI_AD6:SYS_GPD_MFPH_PD8MFP_EBI_AD6@GPD_MFPH', 'I2C2_SDA:SYS_GPD_MFPH_PD8MFP_I2C2_SDA@GPD_MFPH', 'UART2_nRTS:SYS_GPD_MFPH_PD8MFP_UART2_nRTS@GPD_MFPH', 'UART7_RXD:SYS_GPD_MFPH_PD8MFP_UART7_RXD@GPD_MFPH', 'CAN2_RXD:SYS_GPD_MFPH_PD8MFP_CAN2_RXD@GPD_MFPH'] },
	{ f: ['PD.9', 'GPIO:SYS_GPD_MFPH_PD9MFP_GPIO@GPD_MFPH', 'EBI_AD7:SYS_GPD_MFPH_PD9MFP_EBI_AD7@GPD_MFPH', 'I2C2_SCL:SYS_GPD_MFPH_PD9MFP_I2C2_SCL@GPD_MFPH', 'UART2_nCTS:SYS_GPD_MFPH_PD9MFP_UART2_nCTS@GPD_MFPH', 'UART7_TXD:SYS_GPD_MFPH_PD9MFP_UART7_TXD@GPD_MFPH', 'CAN2_TXD:SYS_GPD_MFPH_PD9MFP_CAN2_TXD@GPD_MFPH'] },
	{ f: ['PD.10', 'GPIO:SYS_GPD_MFPH_PD10MFP_GPIO@GPD_MFPH', 'OPA2_P:SYS_GPD_MFPH_PD10MFP_OPA2_P@GPD_MFPH', 'EADC1_CH0:SYS_GPD_MFPH_PD10MFP_EADC1_CH0@GPD_MFPH', 'EBI_nCS2:SYS_GPD_MFPH_PD10MFP_EBI_nCS2@GPD_MFPH', 'UART1_RXD:SYS_GPD_MFPH_PD10MFP_UART1_RXD@GPD_MFPH', 'CAN0_RXD:SYS_GPD_MFPH_PD10MFP_CAN0_RXD@GPD_MFPH', 'QEI0_B:SYS_GPD_MFPH_PD10MFP_QEI0_B@GPD_MFPH', 'INT7:SYS_GPD_MFPH_PD10MFP_INT7@GPD_MFPH'] },
	{ f: ['PD.11', 'GPIO:SYS_GPD_MFPH_PD11MFP_GPIO@GPD_MFPH', 'EADC1_CH1:SYS_GPD_MFPH_PD11MFP_EADC1_CH1@GPD_MFPH', 'OPA2_N:SYS_GPD_MFPH_PD11MFP_OPA2_N@GPD_MFPH', 'EBI_nCS1:SYS_GPD_MFPH_PD11MFP_EBI_nCS1@GPD_MFPH', 'UART1_TXD:SYS_GPD_MFPH_PD11MFP_UART1_TXD@GPD_MFPH', 'CAN0_TXD:SYS_GPD_MFPH_PD11MFP_CAN0_TXD@GPD_MFPH', 'QEI0_A:SYS_GPD_MFPH_PD11MFP_QEI0_A@GPD_MFPH', 'INT6:SYS_GPD_MFPH_PD11MFP_INT6@GPD_MFPH'] },
	{ f: ['PD.12', 'GPIO:SYS_GPD_MFPH_PD12MFP_GPIO@GPD_MFPH', 'OPA2_O:SYS_GPD_MFPH_PD12MFP_OPA2_O@GPD_MFPH', 'EADC1_CH2:SYS_GPD_MFPH_PD12MFP_EADC1_CH2@GPD_MFPH', 'EBI_nCS0:SYS_GPD_MFPH_PD12MFP_EBI_nCS0@GPD_MFPH', 'CAN1_RXD:SYS_GPD_MFPH_PD12MFP_CAN1_RXD@GPD_MFPH', 'UART2_RXD:SYS_GPD_MFPH_PD12MFP_UART2_RXD@GPD_MFPH', 'BPWM0_CH5:SYS_GPD_MFPH_PD12MFP_BPWM0_CH5@GPD_MFPH', 'QEI0_INDEX:SYS_GPD_MFPH_PD12MFP_QEI0_INDEX@GPD_MFPH', 'CLKO:SYS_GPD_MFPH_PD12MFP_CLKO@GPD_MFPH', 'EADC0_ST:SYS_GPD_MFPH_PD12MFP_EADC0_ST@GPD_MFPH', 'INT5:SYS_GPD_MFPH_PD12MFP_INT5@GPD_MFPH'] },
	{ f: ['PD.13', 'GPIO:SYS_GPD_MFPH_PD13MFP_GPIO@GPD_MFPH', 'EBI_AD10:SYS_GPD_MFPH_PD13MFP_EBI_AD10@GPD_MFPH', 'SD0_nCD:SYS_GPD_MFPH_PD13MFP_SD0_nCD@GPD_MFPH', 'SPI0_I2SMCLK:SYS_GPD_MFPH_PD13MFP_SPI0_I2SMCLK@GPD_MFPH', 'SPI1_I2SMCLK:SYS_GPD_MFPH_PD13MFP_SPI1_I2SMCLK@GPD_MFPH', 'SC2_nCD:SYS_GPD_MFPH_PD13MFP_SC2_nCD@GPD_MFPH'] },
	{ f: ['PD.14', 'GPIO:SYS_GPD_MFPH_PD14MFP_GPIO@GPD_MFPH', 'EBI_nCS0:SYS_GPD_MFPH_PD14MFP_EBI_nCS0@GPD_MFPH', 'SPI3_I2SMCLK:SYS_GPD_MFPH_PD14MFP_SPI3_I2SMCLK@GPD_MFPH', 'SC1_nCD:SYS_GPD_MFPH_PD14MFP_SC1_nCD@GPD_MFPH', 'SPI0_I2SMCLK:SYS_GPD_MFPH_PD14MFP_SPI0_I2SMCLK@GPD_MFPH', 'EPWM0_CH4:SYS_GPD_MFPH_PD14MFP_EPWM0_CH4@GPD_MFPH'] },
	{ f: ['PD.15', 'GPIO:SYS_GPD_MFPH_PD15MFP_GPIO@GPD_MFPH'] },

	{ f: ['PE.0', 'GPIO:SYS_GPE_MFPL_PE0MFP_GPIO@GPE_MFPL', 'EBI_AD11:SYS_GPE_MFPL_PE0MFP_EBI_AD11@GPE_MFPL', 'QSPI0_MOSI0:SYS_GPE_MFPL_PE0MFP_QSPI0_MOSI0@GPE_MFPL', 'SC2_CLK:SYS_GPE_MFPL_PE0MFP_SC2_CLK@GPE_MFPL', 'I2S0_MCLK:SYS_GPE_MFPL_PE0MFP_I2S0_MCLK@GPE_MFPL', 'SPI1_MOSI:SYS_GPE_MFPL_PE0MFP_SPI1_MOSI@GPE_MFPL', 'UART3_RXD:SYS_GPE_MFPL_PE0MFP_UART3_RXD@GPE_MFPL', 'I2C1_SDA:SYS_GPE_MFPL_PE0MFP_I2C1_SDA@GPE_MFPL', 'UART4_nRTS:SYS_GPE_MFPL_PE0MFP_UART4_nRTS@GPE_MFPL'] },
	{ f: ['PE.1', 'GPIO:SYS_GPE_MFPL_PE1MFP_GPIO@GPE_MFPL', 'EBI_AD10:SYS_GPE_MFPL_PE1MFP_EBI_AD10@GPE_MFPL', 'QSPI0_MISO0:SYS_GPE_MFPL_PE1MFP_QSPI0_MISO0@GPE_MFPL', 'SC2_DAT:SYS_GPE_MFPL_PE1MFP_SC2_DAT@GPE_MFPL', 'I2S0_BCLK:SYS_GPE_MFPL_PE1MFP_I2S0_BCLK@GPE_MFPL', 'SPI1_MISO:SYS_GPE_MFPL_PE1MFP_SPI1_MISO@GPE_MFPL', 'UART3_TXD:SYS_GPE_MFPL_PE1MFP_UART3_TXD@GPE_MFPL', 'I2C1_SCL:SYS_GPE_MFPL_PE1MFP_I2C1_SCL@GPE_MFPL', 'UART4_nCTS:SYS_GPE_MFPL_PE1MFP_UART4_nCTS@GPE_MFPL'] },
	{ f: ['PE.2', 'GPIO:SYS_GPE_MFPL_PE2MFP_GPIO@GPE_MFPL', 'EBI_ALE:SYS_GPE_MFPL_PE2MFP_EBI_ALE@GPE_MFPL', 'SD0_DAT0:SYS_GPE_MFPL_PE2MFP_SD0_DAT0@GPE_MFPL', 'SPIM_MOSI:SYS_GPE_MFPL_PE2MFP_SPIM_MOSI@GPE_MFPL', 'SPI3_MOSI:SYS_GPE_MFPL_PE2MFP_SPI3_MOSI@GPE_MFPL', 'SC0_CLK:SYS_GPE_MFPL_PE2MFP_SC0_CLK@GPE_MFPL', 'USCI0_CLK:SYS_GPE_MFPL_PE2MFP_USCI0_CLK@GPE_MFPL', 'UART6_nCTS:SYS_GPE_MFPL_PE2MFP_UART6_nCTS@GPE_MFPL', 'UART7_RXD:SYS_GPE_MFPL_PE2MFP_UART7_RXD@GPE_MFPL', 'QEI0_B:SYS_GPE_MFPL_PE2MFP_QEI0_B@GPE_MFPL', 'EPWM0_CH5:SYS_GPE_MFPL_PE2MFP_EPWM0_CH5@GPE_MFPL', 'BPWM0_CH0:SYS_GPE_MFPL_PE2MFP_BPWM0_CH0@GPE_MFPL'] },
	{ f: ['PE.3', 'GPIO:SYS_GPE_MFPL_PE3MFP_GPIO@GPE_MFPL', 'EBI_MCLK:SYS_GPE_MFPL_PE3MFP_EBI_MCLK@GPE_MFPL', 'SD0_DAT1:SYS_GPE_MFPL_PE3MFP_SD0_DAT1@GPE_MFPL', 'SPIM_MISO:SYS_GPE_MFPL_PE3MFP_SPIM_MISO@GPE_MFPL', 'SPI3_MISO:SYS_GPE_MFPL_PE3MFP_SPI3_MISO@GPE_MFPL', 'SC0_DAT:SYS_GPE_MFPL_PE3MFP_SC0_DAT@GPE_MFPL', 'USCI0_DAT0:SYS_GPE_MFPL_PE3MFP_USCI0_DAT0@GPE_MFPL', 'UART6_nRTS:SYS_GPE_MFPL_PE3MFP_UART6_nRTS@GPE_MFPL', 'UART7_TXD:SYS_GPE_MFPL_PE3MFP_UART7_TXD@GPE_MFPL', 'QEI0_A:SYS_GPE_MFPL_PE3MFP_QEI0_A@GPE_MFPL', 'EPWM0_CH4:SYS_GPE_MFPL_PE3MFP_EPWM0_CH4@GPE_MFPL', 'BPWM0_CH1:SYS_GPE_MFPL_PE3MFP_BPWM0_CH1@GPE_MFPL'] },
	{ f: ['PE.4', 'GPIO:SYS_GPE_MFPL_PE4MFP_GPIO@GPE_MFPL', 'EBI_nWR:SYS_GPE_MFPL_PE4MFP_EBI_nWR@GPE_MFPL', 'SD0_DAT2:SYS_GPE_MFPL_PE4MFP_SD0_DAT2@GPE_MFPL', 'SPIM_CLK:SYS_GPE_MFPL_PE4MFP_SPIM_CLK@GPE_MFPL', 'SPI3_CLK:SYS_GPE_MFPL_PE4MFP_SPI3_CLK@GPE_MFPL', 'SC0_RST:SYS_GPE_MFPL_PE4MFP_SC0_RST@GPE_MFPL', 'USCI0_DAT1:SYS_GPE_MFPL_PE4MFP_USCI0_DAT1@GPE_MFPL', 'UART6_RXD:SYS_GPE_MFPL_PE4MFP_UART6_RXD@GPE_MFPL', 'UART7_nCTS:SYS_GPE_MFPL_PE4MFP_UART7_nCTS@GPE_MFPL', 'QEI0_INDEX:SYS_GPE_MFPL_PE4MFP_QEI0_INDEX@GPE_MFPL', 'EPWM0_CH3:SYS_GPE_MFPL_PE4MFP_EPWM0_CH3@GPE_MFPL', 'BPWM0_CH2:SYS_GPE_MFPL_PE4MFP_BPWM0_CH2@GPE_MFPL'] },
	{ f: ['PE.5', 'GPIO:SYS_GPE_MFPL_PE5MFP_GPIO@GPE_MFPL', 'EBI_nRD:SYS_GPE_MFPL_PE5MFP_EBI_nRD@GPE_MFPL', 'SD0_DAT3:SYS_GPE_MFPL_PE5MFP_SD0_DAT3@GPE_MFPL', 'SPIM_SS:SYS_GPE_MFPL_PE5MFP_SPIM_SS@GPE_MFPL', 'SPI3_SS:SYS_GPE_MFPL_PE5MFP_SPI3_SS@GPE_MFPL', 'SC0_PWR:SYS_GPE_MFPL_PE5MFP_SC0_PWR@GPE_MFPL', 'USCI0_CTL1:SYS_GPE_MFPL_PE5MFP_USCI0_CTL1@GPE_MFPL', 'UART6_TXD:SYS_GPE_MFPL_PE5MFP_UART6_TXD@GPE_MFPL', 'UART7_nRTS:SYS_GPE_MFPL_PE5MFP_UART7_nRTS@GPE_MFPL', 'QEI1_B:SYS_GPE_MFPL_PE5MFP_QEI1_B@GPE_MFPL', 'EPWM0_CH2:SYS_GPE_MFPL_PE5MFP_EPWM0_CH2@GPE_MFPL', 'BPWM0_CH3:SYS_GPE_MFPL_PE5MFP_BPWM0_CH3@GPE_MFPL'] },
	{ f: ['PE.6', 'GPIO:SYS_GPE_MFPL_PE6MFP_GPIO@GPE_MFPL', 'SD0_CLK:SYS_GPE_MFPL_PE6MFP_SD0_CLK@GPE_MFPL', 'SPIM_D3:SYS_GPE_MFPL_PE6MFP_SPIM_D3@GPE_MFPL', 'SPI3_I2SMCLK:SYS_GPE_MFPL_PE6MFP_SPI3_I2SMCLK@GPE_MFPL', 'SC0_nCD:SYS_GPE_MFPL_PE6MFP_SC0_nCD@GPE_MFPL', 'USCI0_CTL0:SYS_GPE_MFPL_PE6MFP_USCI0_CTL0@GPE_MFPL', 'UART5_RXD:SYS_GPE_MFPL_PE6MFP_UART5_RXD@GPE_MFPL', 'CAN1_RXD:SYS_GPE_MFPL_PE6MFP_CAN1_RXD@GPE_MFPL', 'QEI1_A:SYS_GPE_MFPL_PE6MFP_QEI1_A@GPE_MFPL', 'EPWM0_CH1:SYS_GPE_MFPL_PE6MFP_EPWM0_CH1@GPE_MFPL', 'BPWM0_CH4:SYS_GPE_MFPL_PE6MFP_BPWM0_CH4@GPE_MFPL'] },
	{ f: ['PE.7', 'GPIO:SYS_GPE_MFPL_PE7MFP_GPIO@GPE_MFPL', 'SD0_CMD:SYS_GPE_MFPL_PE7MFP_SD0_CMD@GPE_MFPL', 'SPIM_D2:SYS_GPE_MFPL_PE7MFP_SPIM_D2@GPE_MFPL', 'UART5_TXD:SYS_GPE_MFPL_PE7MFP_UART5_TXD@GPE_MFPL', 'CAN1_TXD:SYS_GPE_MFPL_PE7MFP_CAN1_TXD@GPE_MFPL', 'QEI1_INDEX:SYS_GPE_MFPL_PE7MFP_QEI1_INDEX@GPE_MFPL', 'EPWM0_CH0:SYS_GPE_MFPL_PE7MFP_EPWM0_CH0@GPE_MFPL', 'BPWM0_CH5:SYS_GPE_MFPL_PE7MFP_BPWM0_CH5@GPE_MFPL'] },
	{ f: ['PE.8', 'GPIO:SYS_GPE_MFPH_PE8MFP_GPIO@GPE_MFPH', 'EBI_ADR10:SYS_GPE_MFPH_PE8MFP_EBI_ADR10@GPE_MFPH', 'EMAC_RMII_MDC:SYS_GPE_MFPH_PE8MFP_EMAC_RMII_MDC@GPE_MFPH', 'I2S0_BCLK:SYS_GPE_MFPH_PE8MFP_I2S0_BCLK@GPE_MFPH', 'SPI2_CLK:SYS_GPE_MFPH_PE8MFP_SPI2_CLK@GPE_MFPH', 'USCI1_CTL1:SYS_GPE_MFPH_PE8MFP_USCI1_CTL1@GPE_MFPH', 'UART2_TXD:SYS_GPE_MFPH_PE8MFP_UART2_TXD@GPE_MFPH', 'EPWM0_CH0:SYS_GPE_MFPH_PE8MFP_EPWM0_CH0@GPE_MFPH', 'EPWM0_BRAKE0:SYS_GPE_MFPH_PE8MFP_EPWM0_BRAKE0@GPE_MFPH', 'ECAP0_IC0:SYS_GPE_MFPH_PE8MFP_ECAP0_IC0@GPE_MFPH', 'TRACE_DATA3:SYS_GPE_MFPH_PE8MFP_TRACE_DATA3@GPE_MFPH'] },
	{ f: ['PE.9', 'GPIO:SYS_GPE_MFPH_PE9MFP_GPIO@GPE_MFPH', 'EBI_ADR11:SYS_GPE_MFPH_PE9MFP_EBI_ADR11@GPE_MFPH', 'EMAC_RMII_MDIO:SYS_GPE_MFPH_PE9MFP_EMAC_RMII_MDIO@GPE_MFPH', 'I2S0_MCLK:SYS_GPE_MFPH_PE9MFP_I2S0_MCLK@GPE_MFPH', 'SPI2_MISO:SYS_GPE_MFPH_PE9MFP_SPI2_MISO@GPE_MFPH', 'USCI1_CTL0:SYS_GPE_MFPH_PE9MFP_USCI1_CTL0@GPE_MFPH', 'UART2_RXD:SYS_GPE_MFPH_PE9MFP_UART2_RXD@GPE_MFPH', 'EPWM0_CH1:SYS_GPE_MFPH_PE9MFP_EPWM0_CH1@GPE_MFPH', 'EPWM0_BRAKE1:SYS_GPE_MFPH_PE9MFP_EPWM0_BRAKE1@GPE_MFPH', 'ECAP0_IC1:SYS_GPE_MFPH_PE9MFP_ECAP0_IC1@GPE_MFPH', 'TRACE_DATA2:SYS_GPE_MFPH_PE9MFP_TRACE_DATA2@GPE_MFPH'] },
	{ f: ['PE.10', 'GPIO:SYS_GPE_MFPH_PE10MFP_GPIO@GPE_MFPH', 'EBI_ADR12:SYS_GPE_MFPH_PE10MFP_EBI_ADR12@GPE_MFPH', 'EMAC_RMII_TXD0:SYS_GPE_MFPH_PE10MFP_EMAC_RMII_TXD0@GPE_MFPH', 'I2S0_DI:SYS_GPE_MFPH_PE10MFP_I2S0_DI@GPE_MFPH', 'SPI2_MOSI:SYS_GPE_MFPH_PE10MFP_SPI2_MOSI@GPE_MFPH', 'USCI1_DAT0:SYS_GPE_MFPH_PE10MFP_USCI1_DAT0@GPE_MFPH', 'UART3_TXD:SYS_GPE_MFPH_PE10MFP_UART3_TXD@GPE_MFPH', 'EPWM0_CH2:SYS_GPE_MFPH_PE10MFP_EPWM0_CH2@GPE_MFPH', 'EPWM1_BRAKE0:SYS_GPE_MFPH_PE10MFP_EPWM1_BRAKE0@GPE_MFPH', 'ECAP0_IC2:SYS_GPE_MFPH_PE10MFP_ECAP0_IC2@GPE_MFPH', 'TRACE_DATA1:SYS_GPE_MFPH_PE10MFP_TRACE_DATA1@GPE_MFPH'] },
	{ f: ['PE.11', 'GPIO:SYS_GPE_MFPH_PE11MFP_GPIO@GPE_MFPH', 'EBI_ADR13:SYS_GPE_MFPH_PE11MFP_EBI_ADR13@GPE_MFPH', 'EMAC_RMII_TXD1:SYS_GPE_MFPH_PE11MFP_EMAC_RMII_TXD1@GPE_MFPH', 'I2S0_DO:SYS_GPE_MFPH_PE11MFP_I2S0_DO@GPE_MFPH', 'SPI2_SS:SYS_GPE_MFPH_PE11MFP_SPI2_SS@GPE_MFPH', 'USCI1_DAT1:SYS_GPE_MFPH_PE11MFP_USCI1_DAT1@GPE_MFPH', 'UART3_RXD:SYS_GPE_MFPH_PE11MFP_UART3_RXD@GPE_MFPH', 'UART1_nCTS:SYS_GPE_MFPH_PE11MFP_UART1_nCTS@GPE_MFPH', 'EPWM0_CH3:SYS_GPE_MFPH_PE11MFP_EPWM0_CH3@GPE_MFPH', 'EPWM1_BRAKE1:SYS_GPE_MFPH_PE11MFP_EPWM1_BRAKE1@GPE_MFPH', 'ECAP1_IC2:SYS_GPE_MFPH_PE11MFP_ECAP1_IC2@GPE_MFPH', 'TRACE_DATA0:SYS_GPE_MFPH_PE11MFP_TRACE_DATA0@GPE_MFPH'] },
	{ f: ['PE.12', 'GPIO:SYS_GPE_MFPH_PE12MFP_GPIO@GPE_MFPH', 'EBI_ADR14:SYS_GPE_MFPH_PE12MFP_EBI_ADR14@GPE_MFPH', 'EMAC_RMII_TXEN:SYS_GPE_MFPH_PE12MFP_EMAC_RMII_TXEN@GPE_MFPH', 'I2S0_LRCK:SYS_GPE_MFPH_PE12MFP_I2S0_LRCK@GPE_MFPH', 'SPI2_I2SMCLK:SYS_GPE_MFPH_PE12MFP_SPI2_I2SMCLK@GPE_MFPH', 'USCI1_CLK:SYS_GPE_MFPH_PE12MFP_USCI1_CLK@GPE_MFPH', 'UART1_nRTS:SYS_GPE_MFPH_PE12MFP_UART1_nRTS@GPE_MFPH', 'EPWM0_CH4:SYS_GPE_MFPH_PE12MFP_EPWM0_CH4@GPE_MFPH', 'ECAP1_IC1:SYS_GPE_MFPH_PE12MFP_ECAP1_IC1@GPE_MFPH', 'TRACE_CLK:SYS_GPE_MFPH_PE12MFP_TRACE_CLK@GPE_MFPH'] },
	{ f: ['PE.13', 'GPIO:SYS_GPE_MFPH_PE13MFP_GPIO@GPE_MFPH', 'EBI_ADR15:SYS_GPE_MFPH_PE13MFP_EBI_ADR15@GPE_MFPH', 'EMAC_PPS:SYS_GPE_MFPH_PE13MFP_EMAC_PPS@GPE_MFPH', 'I2C0_SCL:SYS_GPE_MFPH_PE13MFP_I2C0_SCL@GPE_MFPH', 'UART4_nRTS:SYS_GPE_MFPH_PE13MFP_UART4_nRTS@GPE_MFPH', 'UART1_TXD:SYS_GPE_MFPH_PE13MFP_UART1_TXD@GPE_MFPH', 'EPWM0_CH5:SYS_GPE_MFPH_PE13MFP_EPWM0_CH5@GPE_MFPH', 'EPWM1_CH0:SYS_GPE_MFPH_PE13MFP_EPWM1_CH0@GPE_MFPH', 'BPWM1_CH5:SYS_GPE_MFPH_PE13MFP_BPWM1_CH5@GPE_MFPH', 'ECAP1_IC0:SYS_GPE_MFPH_PE13MFP_ECAP1_IC0@GPE_MFPH'] },
	{ f: ['PE.14', 'GPIO:SYS_GPE_MFPH_PE14MFP_GPIO@GPE_MFPH', 'EBI_AD8:SYS_GPE_MFPH_PE14MFP_EBI_AD8@GPE_MFPH', 'UART2_TXD:SYS_GPE_MFPH_PE14MFP_UART2_TXD@GPE_MFPH', 'CAN0_TXD:SYS_GPE_MFPH_PE14MFP_CAN0_TXD@GPE_MFPH', 'SD1_nCD:SYS_GPE_MFPH_PE14MFP_SD1_nCD@GPE_MFPH', 'UART6_TXD:SYS_GPE_MFPH_PE14MFP_UART6_TXD@GPE_MFPH'] },
	{ f: ['PE.15', 'GPIO:SYS_GPE_MFPH_PE15MFP_GPIO@GPE_MFPH', 'EBI_AD9:SYS_GPE_MFPH_PE15MFP_EBI_AD9@GPE_MFPH', 'UART2_RXD:SYS_GPE_MFPH_PE15MFP_UART2_RXD@GPE_MFPH', 'CAN0_RXD:SYS_GPE_MFPH_PE15MFP_CAN0_RXD@GPE_MFPH', 'UART6_RXD:SYS_GPE_MFPH_PE15MFP_UART6_RXD@GPE_MFPH'] },

	{ f: ['PF.0', 'GPIO:SYS_GPF_MFPL_PF0MFP_GPIO@GPF_MFPL', 'UART1_TXD:SYS_GPF_MFPL_PF0MFP_UART1_TXD@GPF_MFPL', 'I2C1_SCL:SYS_GPF_MFPL_PF0MFP_I2C1_SCL@GPF_MFPL', 'UART0_TXD:SYS_GPF_MFPL_PF0MFP_UART0_TXD@GPF_MFPL', 'BPWM1_CH0:SYS_GPF_MFPL_PF0MFP_BPWM1_CH0@GPF_MFPL', 'ICE_DAT:SYS_GPF_MFPL_PF0MFP_ICE_DAT@GPF_MFPL'] },
	{ f: ['PF.1', 'GPIO:SYS_GPF_MFPL_PF1MFP_GPIO@GPF_MFPL', 'UART1_RXD:SYS_GPF_MFPL_PF1MFP_UART1_RXD@GPF_MFPL', 'I2C1_SDA:SYS_GPF_MFPL_PF1MFP_I2C1_SDA@GPF_MFPL', 'UART0_RXD:SYS_GPF_MFPL_PF1MFP_UART0_RXD@GPF_MFPL', 'BPWM1_CH1:SYS_GPF_MFPL_PF1MFP_BPWM1_CH1@GPF_MFPL', 'ICE_CLK:SYS_GPF_MFPL_PF1MFP_ICE_CLK@GPF_MFPL'] },
	{ f: ['PF.2', 'GPIO:SYS_GPF_MFPL_PF2MFP_GPIO@GPF_MFPL', 'EBI_nCS1:SYS_GPF_MFPL_PF2MFP_EBI_nCS1@GPF_MFPL', 'UART0_RXD:SYS_GPF_MFPL_PF2MFP_UART0_RXD@GPF_MFPL', 'I2C0_SDA:SYS_GPF_MFPL_PF2MFP_I2C0_SDA@GPF_MFPL', 'QSPI0_CLK:SYS_GPF_MFPL_PF2MFP_QSPI0_CLK@GPF_MFPL', 'XT1_OUT:SYS_GPF_MFPL_PF2MFP_XT1_OUT@GPF_MFPL', 'BPWM1_CH1:SYS_GPF_MFPL_PF2MFP_BPWM1_CH1@GPF_MFPL'] },
	{ f: ['PF.3', 'GPIO:SYS_GPF_MFPL_PF3MFP_GPIO@GPF_MFPL', 'EBI_nCS0:SYS_GPF_MFPL_PF3MFP_EBI_nCS0@GPF_MFPL', 'UART0_TXD:SYS_GPF_MFPL_PF3MFP_UART0_TXD@GPF_MFPL', 'I2C0_SCL:SYS_GPF_MFPL_PF3MFP_I2C0_SCL@GPF_MFPL', 'XT1_IN:SYS_GPF_MFPL_PF3MFP_XT1_IN@GPF_MFPL', 'BPWM1_CH0:SYS_GPF_MFPL_PF3MFP_BPWM1_CH0@GPF_MFPL'] },
	{ f: ['PF.4', 'GPIO:SYS_GPF_MFPL_PF4MFP_GPIO@GPF_MFPL', 'UART2_TXD:SYS_GPF_MFPL_PF4MFP_UART2_TXD@GPF_MFPL', 'UART2_nRTS:SYS_GPF_MFPL_PF4MFP_UART2_nRTS@GPF_MFPL', 'EPWM0_CH1:SYS_GPF_MFPL_PF4MFP_EPWM0_CH1@GPF_MFPL', 'BPWM0_CH5:SYS_GPF_MFPL_PF4MFP_BPWM0_CH5@GPF_MFPL', 'X32_OUT:SYS_GPF_MFPL_PF4MFP_X32_OUT@GPF_MFPL', 'EADC1_ST:SYS_GPF_MFPL_PF4MFP_EADC1_ST@GPF_MFPL'] },
	{ f: ['PF.5', 'GPIO:SYS_GPF_MFPL_PF5MFP_GPIO@GPF_MFPL', 'UART2_RXD:SYS_GPF_MFPL_PF5MFP_UART2_RXD@GPF_MFPL', 'UART2_nCTS:SYS_GPF_MFPL_PF5MFP_UART2_nCTS@GPF_MFPL', 'EPWM0_CH0:SYS_GPF_MFPL_PF5MFP_EPWM0_CH0@GPF_MFPL', 'BPWM0_CH4:SYS_GPF_MFPL_PF5MFP_BPWM0_CH4@GPF_MFPL', 'EPWM0_SYNC_OUT:SYS_GPF_MFPL_PF5MFP_EPWM0_SYNC_OUT@GPF_MFPL', 'X32_IN:SYS_GPF_MFPL_PF5MFP_X32_IN@GPF_MFPL', 'EADC0_ST:SYS_GPF_MFPL_PF5MFP_EADC0_ST@GPF_MFPL'] },
	{ f: ['PF.6', 'GPIO:SYS_GPF_MFPL_PF6MFP_GPIO@GPF_MFPL', 'EBI_ADR19:SYS_GPF_MFPL_PF6MFP_EBI_ADR19@GPF_MFPL', 'SC0_CLK:SYS_GPF_MFPL_PF6MFP_SC0_CLK@GPF_MFPL', 'I2S0_LRCK:SYS_GPF_MFPL_PF6MFP_I2S0_LRCK@GPF_MFPL', 'SPI0_MOSI:SYS_GPF_MFPL_PF6MFP_SPI0_MOSI@GPF_MFPL', 'UART4_RXD:SYS_GPF_MFPL_PF6MFP_UART4_RXD@GPF_MFPL', 'EBI_nCS0:SYS_GPF_MFPL_PF6MFP_EBI_nCS0@GPF_MFPL', 'CAN2_RXD:SYS_GPF_MFPL_PF6MFP_CAN2_RXD@GPF_MFPL', 'TAMPER0:SYS_GPF_MFPL_PF6MFP_TAMPER0@GPF_MFPL'] },
	{ f: ['PF.7', 'GPIO:SYS_GPF_MFPL_PF7MFP_GPIO@GPF_MFPL', 'EBI_ADR18:SYS_GPF_MFPL_PF7MFP_EBI_ADR18@GPF_MFPL', 'SC0_DAT:SYS_GPF_MFPL_PF7MFP_SC0_DAT@GPF_MFPL', 'I2S0_DO:SYS_GPF_MFPL_PF7MFP_I2S0_DO@GPF_MFPL', 'SPI0_MISO:SYS_GPF_MFPL_PF7MFP_SPI0_MISO@GPF_MFPL', 'UART4_TXD:SYS_GPF_MFPL_PF7MFP_UART4_TXD@GPF_MFPL', 'CCAP_DATA0:SYS_GPF_MFPL_PF7MFP_CCAP_DATA0@GPF_MFPL', 'CAN2_TXD:SYS_GPF_MFPL_PF7MFP_CAN2_TXD@GPF_MFPL', 'TAMPER1:SYS_GPF_MFPL_PF7MFP_TAMPER1@GPF_MFPL'] },
	{ f: ['PF.8', 'GPIO:SYS_GPF_MFPH_PF8MFP_GPIO@GPF_MFPH', 'EBI_ADR17:SYS_GPF_MFPH_PF8MFP_EBI_ADR17@GPF_MFPH', 'SC0_RST:SYS_GPF_MFPH_PF8MFP_SC0_RST@GPF_MFPH', 'I2S0_DI:SYS_GPF_MFPH_PF8MFP_I2S0_DI@GPF_MFPH', 'SPI0_CLK:SYS_GPF_MFPH_PF8MFP_SPI0_CLK@GPF_MFPH', 'UART5_nCTS:SYS_GPF_MFPH_PF8MFP_UART5_nCTS@GPF_MFPH', 'CCAP_DATA1:SYS_GPF_MFPH_PF8MFP_CCAP_DATA1@GPF_MFPH', 'CAN1_RXD:SYS_GPF_MFPH_PF8MFP_CAN1_RXD@GPF_MFPH', 'TAMPER2:SYS_GPF_MFPH_PF8MFP_TAMPER2@GPF_MFPH'] },
	{ f: ['PF.9', 'GPIO:SYS_GPF_MFPH_PF9MFP_GPIO@GPF_MFPH', 'EBI_ADR16:SYS_GPF_MFPH_PF9MFP_EBI_ADR16@GPF_MFPH', 'SC0_PWR:SYS_GPF_MFPH_PF9MFP_SC0_PWR@GPF_MFPH', 'I2S0_MCLK:SYS_GPF_MFPH_PF9MFP_I2S0_MCLK@GPF_MFPH', 'SPI0_SS:SYS_GPF_MFPH_PF9MFP_SPI0_SS@GPF_MFPH', 'UART5_nRTS:SYS_GPF_MFPH_PF9MFP_UART5_nRTS@GPF_MFPH', 'CCAP_DATA2:SYS_GPF_MFPH_PF9MFP_CCAP_DATA2@GPF_MFPH', 'CAN1_TXD:SYS_GPF_MFPH_PF9MFP_CAN1_TXD@GPF_MFPH', 'TAMPER3:SYS_GPF_MFPH_PF9MFP_TAMPER3@GPF_MFPH'] },
	{ f: ['PF.10', 'GPIO:SYS_GPF_MFPH_PF10MFP_GPIO@GPF_MFPH', 'EBI_ADR15:SYS_GPF_MFPH_PF10MFP_EBI_ADR15@GPF_MFPH', 'SC0_nCD:SYS_GPF_MFPH_PF10MFP_SC0_nCD@GPF_MFPH', 'I2S0_BCLK:SYS_GPF_MFPH_PF10MFP_I2S0_BCLK@GPF_MFPH', 'SPI0_I2SMCLK:SYS_GPF_MFPH_PF10MFP_SPI0_I2SMCLK@GPF_MFPH', 'UART5_RXD:SYS_GPF_MFPH_PF10MFP_UART5_RXD@GPF_MFPH', 'CCAP_DATA3:SYS_GPF_MFPH_PF10MFP_CCAP_DATA3@GPF_MFPH', 'TAMPER4:SYS_GPF_MFPH_PF10MFP_TAMPER4@GPF_MFPH'] },
	{ f: ['PF.11', 'GPIO:SYS_GPF_MFPH_PF11MFP_GPIO@GPF_MFPH', 'EBI_ADR14:SYS_GPF_MFPH_PF11MFP_EBI_ADR14@GPF_MFPH', 'SPI2_MOSI:SYS_GPF_MFPH_PF11MFP_SPI2_MOSI@GPF_MFPH', 'UART5_TXD:SYS_GPF_MFPH_PF11MFP_UART5_TXD@GPF_MFPH', 'CCAP_DATA4:SYS_GPF_MFPH_PF11MFP_CCAP_DATA4@GPF_MFPH', 'TAMPER5:SYS_GPF_MFPH_PF11MFP_TAMPER5@GPF_MFPH', 'TM3:SYS_GPF_MFPH_PF11MFP_TM3@GPF_MFPH'] },
	{ f: ['PF.12', 'GPIO:SYS_GPF_MFPH_PF12MFP_GPIO@GPF_MFPH'] },
	{ f: ['PF.13', 'GPIO:SYS_GPF_MFPH_PF13MFP_GPIO@GPF_MFPH'] },
	{ f: ['PF.14', 'GPIO:SYS_GPF_MFPH_PF14MFP_GPIO@GPF_MFPH'] },
	{ f: ['PF.15', 'GPIO:SYS_GPF_MFPH_PF15MFP_GPIO@GPF_MFPH'] },

	{ f: ['PG.0', 'GPIO:SYS_GPG_MFPL_PG0MFP_GPIO@GPG_MFPL', 'EBI_ADR8:SYS_GPG_MFPL_PG0MFP_EBI_ADR8@GPG_MFPL', 'I2C0_SCL:SYS_GPG_MFPL_PG0MFP_I2C0_SCL@GPG_MFPL', 'I2C1_SMBAL:SYS_GPG_MFPL_PG0MFP_I2C1_SMBAL@GPG_MFPL', 'UART2_RXD:SYS_GPG_MFPL_PG0MFP_UART2_RXD@GPG_MFPL', 'CAN1_TXD:SYS_GPG_MFPL_PG0MFP_CAN1_TXD@GPG_MFPL', 'UART1_TXD:SYS_GPG_MFPL_PG0MFP_UART1_TXD@GPG_MFPL'] },
	{ f: ['PG.1', 'GPIO:SYS_GPG_MFPL_PG1MFP_GPIO@GPG_MFPL', 'EBI_ADR9:SYS_GPG_MFPL_PG1MFP_EBI_ADR9@GPG_MFPL', 'SPI2_I2SMCLK:SYS_GPG_MFPL_PG1MFP_SPI2_I2SMCLK@GPG_MFPL', 'I2C0_SDA:SYS_GPG_MFPL_PG1MFP_I2C0_SDA@GPG_MFPL', 'I2C1_SMBSUS:SYS_GPG_MFPL_PG1MFP_I2C1_SMBSUS@GPG_MFPL', 'UART2_TXD:SYS_GPG_MFPL_PG1MFP_UART2_TXD@GPG_MFPL', 'CAN1_RXD:SYS_GPG_MFPL_PG1MFP_CAN1_RXD@GPG_MFPL', 'UART1_RXD:SYS_GPG_MFPL_PG1MFP_UART1_RXD@GPG_MFPL'] },
	{ f: ['PG.2', 'GPIO:SYS_GPG_MFPL_PG2MFP_GPIO@GPG_MFPL', 'EBI_ADR11:SYS_GPG_MFPL_PG2MFP_EBI_ADR11@GPG_MFPL', 'SPI2_SS:SYS_GPG_MFPL_PG2MFP_SPI2_SS@GPG_MFPL', 'I2C0_SMBAL:SYS_GPG_MFPL_PG2MFP_I2C0_SMBAL@GPG_MFPL', 'I2C1_SCL:SYS_GPG_MFPL_PG2MFP_I2C1_SCL@GPG_MFPL', 'CCAP_DATA7:SYS_GPG_MFPL_PG2MFP_CCAP_DATA7@GPG_MFPL', 'TM0:SYS_GPG_MFPL_PG2MFP_TM0@GPG_MFPL'] },
	{ f: ['PG.3', 'GPIO:SYS_GPG_MFPL_PG3MFP_GPIO@GPG_MFPL', 'EBI_ADR12:SYS_GPG_MFPL_PG3MFP_EBI_ADR12@GPG_MFPL', 'SPI2_CLK:SYS_GPG_MFPL_PG3MFP_SPI2_CLK@GPG_MFPL', 'I2C0_SMBSUS:SYS_GPG_MFPL_PG3MFP_I2C0_SMBSUS@GPG_MFPL', 'I2C1_SDA:SYS_GPG_MFPL_PG3MFP_I2C1_SDA@GPG_MFPL', 'CCAP_DATA6:SYS_GPG_MFPL_PG3MFP_CCAP_DATA6@GPG_MFPL', 'TM1:SYS_GPG_MFPL_PG3MFP_TM1@GPG_MFPL'] },
	{ f: ['PG.4', 'GPIO:SYS_GPG_MFPL_PG4MFP_GPIO@GPG_MFPL', 'EBI_ADR13:SYS_GPG_MFPL_PG4MFP_EBI_ADR13@GPG_MFPL', 'SPI2_MISO:SYS_GPG_MFPL_PG4MFP_SPI2_MISO@GPG_MFPL', 'CCAP_DATA5:SYS_GPG_MFPL_PG4MFP_CCAP_DATA5@GPG_MFPL', 'TM2:SYS_GPG_MFPL_PG4MFP_TM2@GPG_MFPL'] },
	{ f: ['PG.5', 'GPIO:SYS_GPG_MFPL_PG5MFP_GPIO@GPG_MFPL', 'EBI_nCS1:SYS_GPG_MFPL_PG5MFP_EBI_nCS1@GPG_MFPL', 'SPI3_SS:SYS_GPG_MFPL_PG5MFP_SPI3_SS@GPG_MFPL', 'SC1_PWR:SYS_GPG_MFPL_PG5MFP_SC1_PWR@GPG_MFPL', 'EPWM0_CH3:SYS_GPG_MFPL_PG5MFP_EPWM0_CH3@GPG_MFPL'] },
	{ f: ['PG.6', 'GPIO:SYS_GPG_MFPL_PG6MFP_GPIO@GPG_MFPL', 'EBI_nCS2:SYS_GPG_MFPL_PG6MFP_EBI_nCS2@GPG_MFPL', 'SPI3_CLK:SYS_GPG_MFPL_PG6MFP_SPI3_CLK@GPG_MFPL', 'SC1_RST:SYS_GPG_MFPL_PG6MFP_SC1_RST@GPG_MFPL', 'EPWM0_CH2:SYS_GPG_MFPL_PG6MFP_EPWM0_CH2@GPG_MFPL'] },
	{ f: ['PG.7', 'GPIO:SYS_GPG_MFPL_PG7MFP_GPIO@GPG_MFPL', 'EBI_nWRL:SYS_GPG_MFPL_PG7MFP_EBI_nWRL@GPG_MFPL', 'SPI3_MISO:SYS_GPG_MFPL_PG7MFP_SPI3_MISO@GPG_MFPL', 'SC1_DAT:SYS_GPG_MFPL_PG7MFP_SC1_DAT@GPG_MFPL', 'EPWM0_CH1:SYS_GPG_MFPL_PG7MFP_EPWM0_CH1@GPG_MFPL'] },
	{ f: ['PG.8', 'GPIO:SYS_GPG_MFPH_PG8MFP_GPIO@GPG_MFPH', 'EBI_nWRH:SYS_GPG_MFPH_PG8MFP_EBI_nWRH@GPG_MFPH', 'SPI3_MOSI:SYS_GPG_MFPH_PG8MFP_SPI3_MOSI@GPG_MFPH', 'SC1_CLK:SYS_GPG_MFPH_PG8MFP_SC1_CLK@GPG_MFPH', 'EPWM0_CH0:SYS_GPG_MFPH_PG8MFP_EPWM0_CH0@GPG_MFPH'] },
	{ f: ['PG.9', 'GPIO:SYS_GPG_MFPH_PG9MFP_GPIO@GPG_MFPH', 'EBI_AD0:SYS_GPG_MFPH_PG9MFP_EBI_AD0@GPG_MFPH', 'SD1_DAT3:SYS_GPG_MFPH_PG9MFP_SD1_DAT3@GPG_MFPH', 'SPIM_D2:SYS_GPG_MFPH_PG9MFP_SPIM_D2@GPG_MFPH', 'QSPI1_MISO1:SYS_GPG_MFPH_PG9MFP_QSPI1_MISO1@GPG_MFPH', 'CCAP_PIXCLK:SYS_GPG_MFPH_PG9MFP_CCAP_PIXCLK@GPG_MFPH', 'BPWM0_CH5:SYS_GPG_MFPH_PG9MFP_BPWM0_CH5@GPG_MFPH'] },
	{ f: ['PG.10', 'GPIO:SYS_GPG_MFPH_PG10MFP_GPIO@GPG_MFPH', 'EBI_AD1:SYS_GPG_MFPH_PG10MFP_EBI_AD1@GPG_MFPH', 'SD1_DAT2:SYS_GPG_MFPH_PG10MFP_SD1_DAT2@GPG_MFPH', 'SPIM_D3:SYS_GPG_MFPH_PG10MFP_SPIM_D3@GPG_MFPH', 'QSPI1_MOSI1:SYS_GPG_MFPH_PG10MFP_QSPI1_MOSI1@GPG_MFPH', 'CCAP_SCLK:SYS_GPG_MFPH_PG10MFP_CCAP_SCLK@GPG_MFPH', 'BPWM0_CH4:SYS_GPG_MFPH_PG10MFP_BPWM0_CH4@GPG_MFPH'] },
	{ f: ['PG.11', 'GPIO:SYS_GPG_MFPH_PG11MFP_GPIO@GPG_MFPH', 'EBI_AD2:SYS_GPG_MFPH_PG11MFP_EBI_AD2@GPG_MFPH', 'SD1_DAT1:SYS_GPG_MFPH_PG11MFP_SD1_DAT1@GPG_MFPH', 'SPIM_SS:SYS_GPG_MFPH_PG11MFP_SPIM_SS@GPG_MFPH', 'QSPI1_SS:SYS_GPG_MFPH_PG11MFP_QSPI1_SS@GPG_MFPH', 'UART7_TXD:SYS_GPG_MFPH_PG11MFP_UART7_TXD@GPG_MFPH', 'CCAP_SFIELD:SYS_GPG_MFPH_PG11MFP_CCAP_SFIELD@GPG_MFPH', 'BPWM0_CH3:SYS_GPG_MFPH_PG11MFP_BPWM0_CH3@GPG_MFPH'] },
	{ f: ['PG.12', 'GPIO:SYS_GPG_MFPH_PG12MFP_GPIO@GPG_MFPH', 'EBI_AD3:SYS_GPG_MFPH_PG12MFP_EBI_AD3@GPG_MFPH', 'SD1_DAT0:SYS_GPG_MFPH_PG12MFP_SD1_DAT0@GPG_MFPH', 'SPIM_CLK:SYS_GPG_MFPH_PG12MFP_SPIM_CLK@GPG_MFPH', 'QSPI1_CLK:SYS_GPG_MFPH_PG12MFP_QSPI1_CLK@GPG_MFPH', 'UART7_RXD:SYS_GPG_MFPH_PG12MFP_UART7_RXD@GPG_MFPH', 'CCAP_VSYNC:SYS_GPG_MFPH_PG12MFP_CCAP_VSYNC@GPG_MFPH', 'BPWM0_CH2:SYS_GPG_MFPH_PG12MFP_BPWM0_CH2@GPG_MFPH'] },
	{ f: ['PG.13', 'GPIO:SYS_GPG_MFPH_PG13MFP_GPIO@GPG_MFPH', 'EBI_AD4:SYS_GPG_MFPH_PG13MFP_EBI_AD4@GPG_MFPH', 'SD1_CMD:SYS_GPG_MFPH_PG13MFP_SD1_CMD@GPG_MFPH', 'SPIM_MISO:SYS_GPG_MFPH_PG13MFP_SPIM_MISO@GPG_MFPH', 'QSPI1_MISO0:SYS_GPG_MFPH_PG13MFP_QSPI1_MISO0@GPG_MFPH', 'UART6_TXD:SYS_GPG_MFPH_PG13MFP_UART6_TXD@GPG_MFPH', 'CCAP_HSYNC:SYS_GPG_MFPH_PG13MFP_CCAP_HSYNC@GPG_MFPH', 'BPWM0_CH1:SYS_GPG_MFPH_PG13MFP_BPWM0_CH1@GPG_MFPH'] },
	{ f: ['PG.14', 'GPIO:SYS_GPG_MFPH_PG14MFP_GPIO@GPG_MFPH', 'EBI_AD5:SYS_GPG_MFPH_PG14MFP_EBI_AD5@GPG_MFPH', 'SD1_CLK:SYS_GPG_MFPH_PG14MFP_SD1_CLK@GPG_MFPH', 'SPIM_MOSI:SYS_GPG_MFPH_PG14MFP_SPIM_MOSI@GPG_MFPH', 'QSPI1_MOSI0:SYS_GPG_MFPH_PG14MFP_QSPI1_MOSI0@GPG_MFPH', 'UART6_RXD:SYS_GPG_MFPH_PG14MFP_UART6_RXD@GPG_MFPH', 'BPWM0_CH0:SYS_GPG_MFPH_PG14MFP_BPWM0_CH0@GPG_MFPH'] },
	{ f: ['PG.15', 'GPIO:SYS_GPG_MFPH_PG15MFP_GPIO@GPG_MFPH', 'SD1_nCD:SYS_GPG_MFPH_PG15MFP_SD1_nCD@GPG_MFPH', 'CLKO:SYS_GPG_MFPH_PG15MFP_CLKO@GPG_MFPH', 'EADC0_ST:SYS_GPG_MFPH_PG15MFP_EADC0_ST@GPG_MFPH'] },

	{ f: ['PH.0', 'GPIO:SYS_GPH_MFPL_PH0MFP_GPIO@GPH_MFPL', 'EBI_ADR7:SYS_GPH_MFPL_PH0MFP_EBI_ADR7@GPH_MFPL', 'UART5_TXD:SYS_GPH_MFPL_PH0MFP_UART5_TXD@GPH_MFPL', 'TM0_EXT:SYS_GPH_MFPL_PH0MFP_TM0_EXT@GPH_MFPL'] },
	{ f: ['PH.1', 'GPIO:SYS_GPH_MFPL_PH1MFP_GPIO@GPH_MFPL', 'EBI_ADR6:SYS_GPH_MFPL_PH1MFP_EBI_ADR6@GPH_MFPL', 'UART5_RXD:SYS_GPH_MFPL_PH1MFP_UART5_RXD@GPH_MFPL', 'TM1_EXT:SYS_GPH_MFPL_PH1MFP_TM1_EXT@GPH_MFPL'] },
	{ f: ['PH.2', 'GPIO:SYS_GPH_MFPL_PH2MFP_GPIO@GPH_MFPL', 'EBI_ADR5:SYS_GPH_MFPL_PH2MFP_EBI_ADR5@GPH_MFPL', 'UART5_nRTS:SYS_GPH_MFPL_PH2MFP_UART5_nRTS@GPH_MFPL', 'UART4_TXD:SYS_GPH_MFPL_PH2MFP_UART4_TXD@GPH_MFPL', 'I2C0_SCL:SYS_GPH_MFPL_PH2MFP_I2C0_SCL@GPH_MFPL', 'TM2_EXT:SYS_GPH_MFPL_PH2MFP_TM2_EXT@GPH_MFPL'] },
	{ f: ['PH.3', 'GPIO:SYS_GPH_MFPL_PH3MFP_GPIO@GPH_MFPL', 'EBI_ADR4:SYS_GPH_MFPL_PH3MFP_EBI_ADR4@GPH_MFPL', 'SPI1_I2SMCLK:SYS_GPH_MFPL_PH3MFP_SPI1_I2SMCLK@GPH_MFPL', 'UART5_nCTS:SYS_GPH_MFPL_PH3MFP_UART5_nCTS@GPH_MFPL', 'UART4_RXD:SYS_GPH_MFPL_PH3MFP_UART4_RXD@GPH_MFPL', 'I2C0_SDA:SYS_GPH_MFPL_PH3MFP_I2C0_SDA@GPH_MFPL', 'TM3_EXT:SYS_GPH_MFPL_PH3MFP_TM3_EXT@GPH_MFPL'] },
	{ f: ['PH.4', 'GPIO:SYS_GPH_MFPL_PH4MFP_GPIO@GPH_MFPL', 'EBI_ADR3:SYS_GPH_MFPL_PH4MFP_EBI_ADR3@GPH_MFPL', 'SPI1_MISO:SYS_GPH_MFPL_PH4MFP_SPI1_MISO@GPH_MFPL', 'UART7_nRTS:SYS_GPH_MFPL_PH4MFP_UART7_nRTS@GPH_MFPL', 'UART6_TXD:SYS_GPH_MFPL_PH4MFP_UART6_TXD@GPH_MFPL'] },
	{ f: ['PH.5', 'GPIO:SYS_GPH_MFPL_PH5MFP_GPIO@GPH_MFPL', 'EBI_ADR2:SYS_GPH_MFPL_PH5MFP_EBI_ADR2@GPH_MFPL', 'SPI1_MOSI:SYS_GPH_MFPL_PH5MFP_SPI1_MOSI@GPH_MFPL', 'UART7_nCTS:SYS_GPH_MFPL_PH5MFP_UART7_nCTS@GPH_MFPL', 'UART6_RXD:SYS_GPH_MFPL_PH5MFP_UART6_RXD@GPH_MFPL'] },
	{ f: ['PH.6', 'GPIO:SYS_GPH_MFPL_PH6MFP_GPIO@GPH_MFPL', 'EBI_ADR1:SYS_GPH_MFPL_PH6MFP_EBI_ADR1@GPH_MFPL', 'SPI1_CLK:SYS_GPH_MFPL_PH6MFP_SPI1_CLK@GPH_MFPL', 'UART7_TXD:SYS_GPH_MFPL_PH6MFP_UART7_TXD@GPH_MFPL'] },
	{ f: ['PH.7', 'GPIO:SYS_GPH_MFPL_PH7MFP_GPIO@GPH_MFPL', 'EBI_ADR0:SYS_GPH_MFPL_PH7MFP_EBI_ADR0@GPH_MFPL', 'SPI1_SS:SYS_GPH_MFPL_PH7MFP_SPI1_SS@GPH_MFPL', 'UART7_RXD:SYS_GPH_MFPL_PH7MFP_UART7_RXD@GPH_MFPL'] },
	{ f: ['PH.8', 'GPIO:SYS_GPH_MFPH_PH8MFP_GPIO@GPH_MFPH', 'EBI_AD12:SYS_GPH_MFPH_PH8MFP_EBI_AD12@GPH_MFPH', 'QSPI0_CLK:SYS_GPH_MFPH_PH8MFP_QSPI0_CLK@GPH_MFPH', 'SC2_PWR:SYS_GPH_MFPH_PH8MFP_SC2_PWR@GPH_MFPH', 'I2S0_DI:SYS_GPH_MFPH_PH8MFP_I2S0_DI@GPH_MFPH', 'SPI1_CLK:SYS_GPH_MFPH_PH8MFP_SPI1_CLK@GPH_MFPH', 'UART3_nRTS:SYS_GPH_MFPH_PH8MFP_UART3_nRTS@GPH_MFPH', 'I2C1_SMBAL:SYS_GPH_MFPH_PH8MFP_I2C1_SMBAL@GPH_MFPH', 'I2C2_SCL:SYS_GPH_MFPH_PH8MFP_I2C2_SCL@GPH_MFPH', 'UART1_TXD:SYS_GPH_MFPH_PH8MFP_UART1_TXD@GPH_MFPH'] },
	{ f: ['PH.9', 'GPIO:SYS_GPH_MFPH_PH9MFP_GPIO@GPH_MFPH', 'EBI_AD13:SYS_GPH_MFPH_PH9MFP_EBI_AD13@GPH_MFPH', 'QSPI0_SS:SYS_GPH_MFPH_PH9MFP_QSPI0_SS@GPH_MFPH', 'SC2_RST:SYS_GPH_MFPH_PH9MFP_SC2_RST@GPH_MFPH', 'I2S0_DO:SYS_GPH_MFPH_PH9MFP_I2S0_DO@GPH_MFPH', 'SPI1_SS:SYS_GPH_MFPH_PH9MFP_SPI1_SS@GPH_MFPH', 'UART3_nCTS:SYS_GPH_MFPH_PH9MFP_UART3_nCTS@GPH_MFPH', 'I2C1_SMBSUS:SYS_GPH_MFPH_PH9MFP_I2C1_SMBSUS@GPH_MFPH', 'I2C2_SDA:SYS_GPH_MFPH_PH9MFP_I2C2_SDA@GPH_MFPH', 'UART1_RXD:SYS_GPH_MFPH_PH9MFP_UART1_RXD@GPH_MFPH'] },
	{ f: ['PH.10', 'GPIO:SYS_GPH_MFPH_PH10MFP_GPIO@GPH_MFPH', 'EBI_AD14:SYS_GPH_MFPH_PH10MFP_EBI_AD14@GPH_MFPH', 'QSPI0_MISO1:SYS_GPH_MFPH_PH10MFP_QSPI0_MISO1@GPH_MFPH', 'SC2_nCD:SYS_GPH_MFPH_PH10MFP_SC2_nCD@GPH_MFPH', 'I2S0_LRCK:SYS_GPH_MFPH_PH10MFP_I2S0_LRCK@GPH_MFPH', 'SPI1_I2SMCLK:SYS_GPH_MFPH_PH10MFP_SPI1_I2SMCLK@GPH_MFPH', 'UART4_TXD:SYS_GPH_MFPH_PH10MFP_UART4_TXD@GPH_MFPH', 'UART0_TXD:SYS_GPH_MFPH_PH10MFP_UART0_TXD@GPH_MFPH'] },
	{ f: ['PH.11', 'GPIO:SYS_GPH_MFPH_PH11MFP_GPIO@GPH_MFPH', 'EBI_AD15:SYS_GPH_MFPH_PH11MFP_EBI_AD15@GPH_MFPH', 'QSPI0_MOSI1:SYS_GPH_MFPH_PH11MFP_QSPI0_MOSI1@GPH_MFPH', 'UART4_RXD:SYS_GPH_MFPH_PH11MFP_UART4_RXD@GPH_MFPH', 'UART0_RXD:SYS_GPH_MFPH_PH11MFP_UART0_RXD@GPH_MFPH', 'EPWM0_CH5:SYS_GPH_MFPH_PH11MFP_EPWM0_CH5@GPH_MFPH'] }
];

NUTOOL_PIN.g_cfg_gpiosDescriptions = [
	'ACMP0_N:Analog comparator 0 negative input  pin',
	'ACMP0_O:Analog comparator 0 output pin',
	'ACMP0_P0:Analog comparator 0 positive input 0 pin',
	'ACMP0_P1:Analog comparator 0 positive input 1 pin',
	'ACMP0_P2:Analog comparator 0 positive input 2 pin',
	'ACMP0_P3:Analog comparator 0 positive input 3 pin',
	'ACMP0_WLAT:Analog comparator 0 window latch input pin',
	'ACMP1_N:Analog comparator 1 negative input  pin',
	'ACMP1_O:Analog comparator 1 output pin',
	'ACMP1_P0:Analog comparator 1 positive input 0 pin',
	'ACMP1_P1:Analog comparator 1 positive input 1 pin',
	'ACMP1_P2:Analog comparator 1 positive input 2 pin',
	'ACMP1_P3:Analog comparator 1 positive input 3 pin',
	'ACMP1_WLAT:Analog comparator 1 window latch input pin',
	'AVDD:Power supply for internal analog circuit',
	'AVSS:Ground pin for analog circuit',
	'BPWM0_CH0:BPWM0 channel 0 output/capture input',
	'BPWM0_CH1:BPWM0 channel 1 output/capture input',
	'BPWM0_CH2:BPWM0 channel 2 output/capture input',
	'BPWM0_CH3:BPWM0 channel 3 output/capture input',
	'BPWM0_CH4:BPWM0 channel 4 output/capture input',
	'BPWM0_CH5:BPWM0 channel 5 output/capture input',
	'BPWM1_CH0:BPWM1 channel 0 output/capture input',
	'BPWM1_CH1:BPWM1 channel 1 output/capture input',
	'BPWM1_CH2:BPWM1 channel 2 output/capture input',
	'BPWM1_CH3:BPWM1 channel 3 output/capture input',
	'BPWM1_CH4:BPWM1 channel 4 output/capture input',
	'BPWM1_CH5:BPWM1 channel 5 output/capture input',
	'CAN0_RXD:CAN0 bus receiver input',
	'CAN0_TXD:CAN0 bus transmitter output',
	'CAN1_RXD:CAN1 bus receiver input',
	'CAN1_TXD:CAN1 bus transmitter output',
	'CAN2_RXD:CAN2 bus receiver input',
	'CAN2_TXD:CAN2 bus transmitter output',
	'CCAP_DATA0:Camera capture data input bus bit 0',
	'CCAP_DATA1:Camera capture data input bus bit 1',
	'CCAP_DATA2:Camera capture data input bus bit 2',
	'CCAP_DATA3:Camera capture data input bus bit 3',
	'CCAP_DATA4:Camera capture data input bus bit 4',
	'CCAP_DATA5:Camera capture data input bus bit 5',
	'CCAP_DATA6:Camera capture data input bus bit 6',
	'CCAP_DATA7:Camera capture data input bus bit 7',
	'CCAP_HSYNC:Camera capture interface hsync input pin',
	'CCAP_PIXCLK:Camera capture interface pix clock input pin',
	'CCAP_SCLK:Camera capture interface sensor clock pin',
	'CCAP_SFIELD:Camera capture interface SFIELD input pin',
	'CCAP_VSYNC:Camera capture interface vsync input pin',
	'CLKO:Clock Out',
	'DAC0_OUT:DAC0 channel  analog output',
	'DAC0_ST:DAC0 external trigger input',
	'EADC0_CH0:EADC0 channel 0 analog input',
	'EADC0_CH1:EADC0 channel 1 analog input',
	'EADC0_CH2:EADC0 channel 2 analog input',
	'EADC0_CH3:EADC0 channel 3 analog input',
	'EADC0_CH4:EADC0 channel 4 analog input',
	'EADC0_CH5:EADC0 channel 5 analog input',
	'EADC0_CH6:EADC0 channel 6 analog input',
	'EADC0_CH7:EADC0 channel 7 analog input',
	'EADC0_CH8:EADC0 channel 8 analog input',
	'EADC0_CH9:EADC0 channel 9 analog input',
	'EADC0_CH10:EADC0 channel 10 analog input',
	'EADC0_CH11:EADC0 channel 11 analog input',
	'EADC0_CH12:EADC0 channel 12 analog input',
	'EADC0_CH13:EADC0 channel 13 analog input',
	'EADC0_CH14:EADC0 channel 14 analog input',
	'EADC0_CH15:EADC0 channel 15 analog input',
	'EADC0_ST:EADC0 external trigger input',
	'EADC1_CH0:EADC1 channel 0 analog input',
	'EADC1_CH1:EADC1 channel 1 analog input',
	'EADC1_CH2:EADC1 channel 2 analog input',
	'EADC1_CH3:EADC1 channel 3 analog input',
	'EADC1_CH4:EADC1 channel 4 analog input',
	'EADC1_CH5:EADC1 channel 5 analog input',
	'EADC1_CH6:EADC1 channel 6 analog input',
	'EADC1_CH7:EADC1 channel 7 analog input',
	'EADC1_CH8:EADC1 channel 8 analog input',
	'EADC1_CH9:EADC1 channel 9 analog input',
	'EADC1_CH10:EADC1 channel 10 analog input',
	'EADC1_CH11:EADC1 channel 11 analog input',
	'EADC1_CH12:EADC1 channel 12 analog input',
	'EADC1_CH13:EADC1 channel 13 analog input',
	'EADC1_CH14:EADC1 channel 14 analog input',
	'EADC1_CH15:EADC1 channel 15 analog input',
	'EADC1_ST:EADC1 external trigger input',
	'EBI_AD0:EBI address/data bus bit 0',
	'EBI_AD1:EBI address/data bus bit 1',
	'EBI_AD2:EBI address/data bus bit 2',
	'EBI_AD3:EBI address/data bus bit 3',
	'EBI_AD4:EBI address/data bus bit 4',
	'EBI_AD5:EBI address/data bus bit 5',
	'EBI_AD6:EBI address/data bus bit 6',
	'EBI_AD7:EBI address/data bus bit 7',
	'EBI_AD8:EBI address/data bus bit 8',
	'EBI_AD9:EBI address/data bus bit 9',
	'EBI_AD10:EBI address/data bus bit 10',
	'EBI_AD11:EBI address/data bus bit 11',
	'EBI_AD12:EBI address/data bus bit 12',
	'EBI_AD13:EBI address/data bus bit 13',
	'EBI_AD14:EBI address/data bus bit 14',
	'EBI_AD15:EBI address/data bus bit 15',
	'EBI_ADR0:EBI address bus bit 0',
	'EBI_ADR1:EBI address bus bit 1',
	'EBI_ADR2:EBI address bus bit 2',
	'EBI_ADR3:EBI address bus bit 3',
	'EBI_ADR4:EBI address bus bit 4',
	'EBI_ADR5:EBI address bus bit 5',
	'EBI_ADR6:EBI address bus bit 6',
	'EBI_ADR7:EBI address bus bit 7',
	'EBI_ADR8:EBI address bus bit 8',
	'EBI_ADR9:EBI address bus bit 9',
	'EBI_ADR10:EBI address bus bit 10',
	'EBI_ADR11:EBI address bus bit 11',
	'EBI_ADR12:EBI address bus bit 12',
	'EBI_ADR13:EBI address bus bit 13',
	'EBI_ADR14:EBI address bus bit 14',
	'EBI_ADR15:EBI address bus bit 15',
	'EBI_ADR16:EBI address bus bit 16',
	'EBI_ADR17:EBI address bus bit 17',
	'EBI_ADR18:EBI address bus bit 18',
	'EBI_ADR19:EBI address bus bit 19',
	'EBI_ALE:EBI address latch enable output pin',
	'EBI_MCLK:EBI external clock output pin',
	'EBI_nCS0:EBI chip select 0 output pin',
	'EBI_nCS1:EBI chip select 1 output pin',
	'EBI_nCS2:EBI chip select 2 output pin',
	'EBI_nRD:EBI read enable output pin',
	'EBI_nWR:EBI write enable output pin',
	'EBI_nWRH:EBI high byte write enable output pin',
	'EBI_nWRL:EBI low byte write enable output pin',
	'ECAP0_IC0:Enhanced capture unit 0 input 0 pin',
	'ECAP0_IC1:Enhanced capture unit 0 input 1 pin',
	'ECAP0_IC2:Enhanced capture unit 0 input 2 pin',
	'ECAP1_IC0:Enhanced capture unit 1 input 0 pin',
	'ECAP1_IC1:Enhanced capture unit 1 input 1 pin',
	'ECAP1_IC2:Enhanced capture unit 1 input 2 pin',
	'EPWM0_BRAKE0:EPWM0 Brake 0 input pin',
	'EPWM0_BRAKE1:EPWM0 Brake 1 input pin',
	'EPWM0_CH0:EPWM0 channel 0 output/capture input',
	'EPWM0_CH1:EPWM0 channel 1 output/capture input',
	'EPWM0_CH2:EPWM0 channel 2 output/capture input',
	'EPWM0_CH3:EPWM0 channel 3 output/capture input',
	'EPWM0_CH4:EPWM0 channel 4 output/capture input',
	'EPWM0_CH5:EPWM0 channel 5 output/capture input',
	'EPWM0_SYNC_IN:EPWM0 counter synchronous trigger input pin',
	'EPWM0_SYNC_OUT:EPWM0 counter synchronous trigger output pin',
	'EPWM1_BRAKE0:EPWM1 Brake 0 input pin',
	'EPWM1_BRAKE1:EPWM1 Brake 1 input pin',
	'EPWM1_CH0:EPWM1 channel 0 output/capture input',
	'EPWM1_CH1:EPWM1 channel 1 output/capture input',
	'EPWM1_CH2:EPWM1 channel 2 output/capture input',
	'EPWM1_CH3:EPWM1 channel 3 output/capture input',
	'EPWM1_CH4:EPWM1 channel 4 output/capture input',
	'EPWM1_CH5:EPWM1 channel 5 output/capture input',
	'ETM_TRACE_CLK:ETM receiver Trace Clock input pin',
	'ETM_TRACE_DATA0:ETM receiver Trace Data 0 input pin',
	'ETM_TRACE_DATA1:ETM receiver Trace Data 1 input pin',
	'ETM_TRACE_DATA2:ETM receiver Trace Data 2 input pin',
	'ETM_TRACE_DATA3:ETM receiver Trace Data 3 input pin',
	'I2C0_SCL:I2C0 clock pin',
	'I2C0_SDA:I2C0 data input/output pin',
	'I2C0_SMBAL:I2C0 SMBus SMBALTER pin ',
	'I2C0_SMBSUS:I2C0 SMBus SMBSUS pin (PMBus CONTROL pin)',
	'I2C1_SCL:I2C1 clock pin',
	'I2C1_SDA:I2C1 data input/output pin',
	'I2C1_SMBAL:I2C1 SMBus SMBALTER pin ',
	'I2C1_SMBSUS:I2C1 SMBus SMBSUS pin (PMBus CONTROL pin)',
	'I2C2_SCL:I2C2 clock pin',
	'I2C2_SDA:I2C2 data input/output pin',
	'I2C2_SMBAL:I2C2 SMBus SMBALTER pin ',
	'I2C2_SMBSUS:I2C2 SMBus SMBSUS pin (PMBus CONTROL pin)',
	'I2S0_BCLK:I2S0 bit clock output pin',
	'I2S0_DI:I2S0 data input pin',
	'I2S0_DO:I2S0 data output pin',
	'I2S0_LRCK:I2S0 left right channel clock output pin',
	'I2S0_MCLK:I2S0 master clock output pin',
	'ICE_CLK:ADC external trigger input',
	'ICE_DAT:ADC external trigger input',
	'INT0:External interrupt 0 input pin',
	'INT1:External interrupt 1 input pin',
	'INT2:External interrupt 2 input pin',
	'INT3:External interrupt 3 input pin',
	'INT4:External interrupt 4 input pin',
	'INT5:External interrupt 5 input pin',
	'INT6:External interrupt 6 input pin',
	'INT7:External interrupt 7 input pin',
	'LDO_CAP:LDO output pin',
	'NC:No connect pin, leave floating',
	'nRESET:External reset input: active LOW, with an internal pull-up. Set this pin low reset to initial state',
	'OPA0_N:Operational amplifier 0 negative input pin',
	'OPA0_O:Operational amplifier 0 output pin',
	'OPA0_P:Operational amplifier 0 positive input pin',
	'OPA1_N:Operational amplifier 1 negative input pin',
	'OPA1_O:Operational amplifier 1 output pin',
	'OPA1_P:Operational amplifier 1 positive input pin',
	'OPA2_N:Operational amplifier 2 negative input pin',
	'OPA2_O:Operational amplifier 2 output pin',
	'OPA2_P:Operational amplifier 2 positive input pin',
	'QEI0_A:Quadrature encoder 0 phase A input',
	'QEI0_B:Quadrature encoder 0 phase B input',
	'QEI0_INDEX:Quadrature encoder 0 index input',
	'QEI1_A:Quadrature encoder 1 phase A input',
	'QEI1_B:Quadrature encoder 1 phase B input',
	'QEI1_INDEX:Quadrature encoder 1 index input',
	'QSPI0_CLK:Quad SPI0 serial clock pin',
	'QSPI0_MISO0:Quad SPI0 MISO0 (Master In, Slave Out) pin',
	'QSPI0_MISO1:Quad SPI0 MISO1 (Master In, Slave Out) pin',
	'QSPI0_MOSI0:Quad SPI0 MOSI0 (Master Out, Slave In) pin',
	'QSPI0_MOSI1:Quad SPI0 MOSI1 (Master Out, Slave In) pin',
	'QSPI0_SS:Quad SPI0 slave select  pin',
	'QSPI1_CLK:Quad SPI1 serial clock pin',
	'QSPI1_MISO0:Quad SPI1 MISO0 (Master In, Slave Out) pin',
	'QSPI1_MISO1:Quad SPI1 MISO1 (Master In, Slave Out) pin',
	'QSPI1_MOSI0:Quad SPI1 MOSI0 (Master Out, Slave In) pin',
	'QSPI1_MOSI1:Quad SPI1 MOSI1 (Master Out, Slave In) pin',
	'QSPI1_SS:Quad SPI1 slave select  pin',
	'SC0_CLK:Smart Card 0 clock pin',
	'SC0_DAT:Smart Card 0 data pin',
	'SC0_nCD:Smart Card 0 card detect pin',
	'SC0_PWR:Smart Card 0 power pin',
	'SC0_RST:Smart Card 0 reset pin',
	'SD0_CLK:SD/SDIO0 clock output pin',
	'SD0_CMD:SD/SDIO0 command/response pin',
	'SD0_DAT0:SD/SDIO0 data line bit 0',
	'SD0_DAT1:SD/SDIO0 data line bit 1',
	'SD0_DAT2:SD/SDIO0 data line bit 2',
	'SD0_DAT3:SD/SDIO0 data line bit 3',
	'SD0_nCD:SD/SDIO0 card detect input pin',
	'SPI0_CLK:SPI0 serial clock pin',
	'SPI0_I2SMCLK:SPI0 I2S master clock output pin',
	'SPI0_MISO:SPI0 MISO (Master In, Slave Out) pin',
	'SPI0_MOSI:SPI0 MOSI (Master Out, Slave In) pin',
	'SPI0_SS:SPI0 slave select  pin',
	'SPI1_CLK:SPI1 serial clock pin',
	'SPI1_I2SMCLK:SPI1 I2S master clock output pin',
	'SPI1_MISO:SPI1 MISO (Master In, Slave Out) pin',
	'SPI1_MOSI:SPI1 MOSI (Master Out, Slave In) pin',
	'SPI1_SS:SPI1 slave select  pin',
	'SPI2_CLK:SPI2 serial clock pin',
	'SPI2_I2SMCLK:SPI2 I2S master clock output pin',
	'SPI2_MISO:SPI2 MISO (Master In, Slave Out) pin',
	'SPI2_MOSI:SPI2 MOSI (Master Out, Slave In) pin',
	'SPI2_SS:SPI2 slave select  pin',
	'SWDH_CLK:Serial Wire Debug Host Clock output',
	'SWDH_DAT:Serial Wire Debug Host Data input/output pin',
	'TAMPER0:TAMPER detector loop pin 0',
	'TAMPER1:TAMPER detector loop pin 1',
	'TAMPER2:TAMPER detector loop pin 2',
	'TM0:Timer0 event counter input/toggle output pin',
	'TM0_EXT:Timer0 external capture input/toggle output pin',
	'TM1:Timer1 event counter input/toggle output pin',
	'TM1_EXT:Timer1 external capture input/toggle output pin',
	'TM2:Timer2 event counter input/toggle output pin',
	'TM2_EXT:Timer2 external capture input/toggle output pin',
	'TM3:Timer3 event counter input/toggle output pin',
	'TM3_EXT:Timer3 external capture input/toggle output pin',
	'TRACE_CLK:ETM Trace Clock output pin',
	'TRACE_DATA0:ETM Trace Data 0 output pin',
	'TRACE_DATA1:ETM Trace Data 1 output pin',
	'TRACE_DATA2:ETM Trace Data 2 output pin',
	'TRACE_DATA3:ETM Trace Data 3 output pin',
	'UART0_nCTS:UART0 clear to Send input pin',
	'UART0_nRTS:UART0 request to Send output pin',
	'UART0_RXD:UART0 data receiver input pin',
	'UART0_TXD:UART0 data transmitter output pin',
	'UART1_nCTS:UART1 clear to Send input pin',
	'UART1_nRTS:UART1 request to Send output pin',
	'UART1_RXD:UART1 data receiver input pin',
	'UART1_TXD:UART1 data transmitter output pin',
	'UART2_nCTS:UART2 clear to Send input pin',
	'UART2_nRTS:UART2 request to Send output pin',
	'UART2_RXD:UART2 data receiver input pin',
	'UART2_TXD:UART2 data transmitter output pin',
	'UART3_nCTS:UART3 clear to Send input pin',
	'UART3_nRTS:UART3 request to Send output pin',
	'UART3_RXD:UART3 data receiver input pin',
	'UART3_TXD:UART3 data transmitter output pin',
	'UART4_nCTS:UART4 clear to Send input pin',
	'UART4_nRTS:UART4 request to Send output pin',
	'UART4_RXD:UART4 data receiver input pin',
	'UART4_TXD:UART4 data transmitter output pin',
	'UART5_nCTS:UART5 clear to Send input pin',
	'UART5_nRTS:UART5 request to Send output pin',
	'UART5_RXD:UART5 data receiver input pin',
	'UART5_TXD:UART5 data transmitter output pin',
	'UART6_nCTS:UART6 clear to Send input pin',
	'UART6_nRTS:UART6 request to Send output pin',
	'UART6_RXD:UART6 data receiver input pin',
	'UART6_TXD:UART6 data transmitter output pin',
	'UART7_nCTS:UART7 clear to Send input pin',
	'UART7_nRTS:UART7 request to Send output pin',
	'UART7_RXD:UART7 data receiver input pin',
	'UART7_TXD:UART7 data transmitter output pin',
	'USB_D-:USB differential signal D-',
	'USB_D+:USB differential signal D+',
	'USB_OTG_ID:USB_ identification',
	'USB_VBUS:Power supply from USB host or HUB',
	'USB_VBUS_EN:USB external VBUS regulator enable pin',
	'USB_VBUS_ST:USB external VBUS regulator status pin',
	'VBAT:Power supply by batteries for RTC',
	'VDD:Power supply for I/O ports and LDO source for internal PLL and digital circuit',
	'VDDIO:Power supply for PA.0~PA.5',
	'VREF:ADC reference voltage input',
	'VSS:Ground pin for digital circuit',
	'X32_IN:External 32.768 kHz crystal input pin',
	'X32_OUT:External 32.768 kHz crystal output pin',
	'XT1_IN:External 4~24 MHz (high speed) crystal input pin',
	'XT1_OUT:External 4~24 MHz (high speed) crystal output pin'
];

NUTOOL_PIN.g_cfg_regDescriptions = {};
NUTOOL_PIN.g_cfg_regDescriptions.GPA_MFPL = '0x40000030';
NUTOOL_PIN.g_cfg_regDescriptions.GPA_MFPH = '0x40000034';
NUTOOL_PIN.g_cfg_regDescriptions.GPB_MFPL = '0x40000038';
NUTOOL_PIN.g_cfg_regDescriptions.GPB_MFPH = '0x4000003C';
NUTOOL_PIN.g_cfg_regDescriptions.GPC_MFPL = '0x40000040';
NUTOOL_PIN.g_cfg_regDescriptions.GPC_MFPH = '0x40000044';
NUTOOL_PIN.g_cfg_regDescriptions.GPD_MFPL = '0x40000048';
NUTOOL_PIN.g_cfg_regDescriptions.GPD_MFPH = '0x4000004C';
NUTOOL_PIN.g_cfg_regDescriptions.GPE_MFPL = '0x40000050';
NUTOOL_PIN.g_cfg_regDescriptions.GPE_MFPH = '0x40000054';
NUTOOL_PIN.g_cfg_regDescriptions.GPF_MFPL = '0x40000058';
NUTOOL_PIN.g_cfg_regDescriptions.GPF_MFPH = '0x4000005C';
NUTOOL_PIN.g_cfg_regDescriptions.GPG_MFPL = '0x40000060';
NUTOOL_PIN.g_cfg_regDescriptions.GPG_MFPH = '0x40000064';
NUTOOL_PIN.g_cfg_regDescriptions.GPH_MFPL = '0x40000068';
NUTOOL_PIN.g_cfg_regDescriptions.GPH_MFPH = '0x4000006C';

NUTOOL_PIN.g_cfg_gpioMatrix = [];
NUTOOL_PIN.g_cfg_shareBits = [];
NUTOOL_PIN.g_cfg_addGPIO = {};
NUTOOL_PIN.g_cfg_unusedGPIO = {
	"QFN48": {
		"ALL": ["EADC1", "TAMPER"]
	},
	"LQFP48": {
		"ALL": ["EADC1", "TAMPER"]
	},
	"LQFP64": {
		"ALL": ["EADC1"]
	}
};

NUTOOL_PIN.decidepackageNumber = function (given_partNumber_package) {
	var partNumber_package;

	if (typeof given_partNumber_package === 'undefined') {
		partNumber_package = NUTOOL_PIN.getg_partNumber_package();
	}
	else {
		partNumber_package = given_partNumber_package;
	}

	NUTOOL_PIN.g_packageNumber = partNumber_package.substring(partNumber_package.indexOf('(') + 1);
	NUTOOL_PIN.g_packageNumber = NUTOOL_PIN.g_packageNumber.substring(0, NUTOOL_PIN.g_packageNumber.indexOf(')'));
	NUTOOL_PIN.g_packageNumberIndex = NUTOOL_PIN.g_packageNumber;

	partNumber_package = null;
};
