// chip content
NUTOOL_PIN.g_cfg_chips = [
	// 8K
	// { name: "MS51IA9AE", pkg: "SOP8" },
	{ name: "MS51BA9AE", pkg: "MSOP10" },
	{ name: "MS51DA9AE", pkg: "TSSOP14" },
	// 16K
	{ name: "MS51XB9AE", pkg: "QFN20" },
	{ name: "MS51XB9BE", pkg: "QFN20" },
	{ name: "MS51FB9AE", pkg: "TSSOP20" },
	// 32K
	{ name: "MS51FC0AE", pkg: "TSSOP20" },
	{ name: "MS51XC0BE", pkg: "QFN20" },
	{ name: "MS51EB0AE", pkg: "TSSOP28" },
	{ name: "MS51EC0AE", pkg: "TSSOP28" },
	{ name: "MS51PC0AE", pkg: "LQFP32" },
	{ name: "MS51TC0AE", pkg: "QFN33" }
];

NUTOOL_PIN.g_cfg_pkgs = {
	"QFN20": [
		'P2.0', 'P3.0', 'P1.7', 'VSS', 'P1.6',
		'VDD', 'P1.5', 'P1.4', 'P1.3', 'P1.2',
		'P1.1', 'P1.0', 'P0.0', 'P0.1', 'P0.2',
		'P0.3', 'P0.4', 'P0.5', 'P0.6', 'P0.7'
	],
	"TSSOP20": [
		'P0.5', 'P0.6', 'P0.7', 'P2.0', 'P3.0',
		'P1.7', 'VSS', 'P1.6', 'VDD', 'P1.5',
		'P1.4', 'P1.3', 'P1.2', 'P1.1', 'P1.0',
		'P0.0', 'P0.1', 'P0.2', 'P0.3', 'P0.4'
	],
	"TSSOP28": [
		'VSS', 'P1.6', 'VDD', 'P1.5', 'P2.5', 'P1.4', 'P1.3',
		'P2.4', 'P2.3', 'P2.2', 'P2.1', 'P3.5', 'P1.2', 'P1.1',
		'P1.0', 'P0.0', 'P0.1', 'P3.3', 'P0.2', 'P0.3', 'P0.4',
		'P0.5', 'P0.6', 'P0.7', 'P3.4', 'P2.0', 'P3.0', 'P1.7'
	],
	"LQFP32": [
		'P2.0', 'P3.0', 'P1.7', 'VSS', 'P1.6', 'VDD', 'P1.5', 'P2.5',
		'P3.6', 'P3.7', 'P1.4', 'P1.3', 'P2.4', 'P2.3', 'P2.2', 'P2.1',
		'P3.5', 'P3.1', 'P3.2', 'P1.2', 'P1.1', 'P1.0', 'P0.0', 'P0.1',
		'P3.3', 'P0.2', 'P0.3', 'P0.4', 'P0.5', 'P0.6', 'P0.7', 'P3.4'
	],
	"QFN33": [
		'P2.0', 'P3.0', 'P1.7', 'VSS', 'P1.6', 'VDD', 'P1.5', 'P2.5',
		'P3.6', 'P3.7', 'P1.4', 'P1.3', 'P2.4', 'P2.3', 'P2.2', 'P2.1',
		'P3.5', 'P3.1', 'P3.2', 'P1.2', 'P1.1', 'P1.0', 'P0.0', 'P0.1',
		'P3.3', 'P0.2', 'P0.3', 'P0.4', 'P0.5', 'P0.6', 'P0.7', 'P3.4'
	]
};

NUTOOL_PIN.g_cfg_gpios = [
	{ f: ['P0.0:0', 'PWM0_CH3:1', 'SPI0_MOSI:2', 'IC3:3', 'UART1_RXD:4', 'T1:5', 'HXTIN:6', 'PWM2_CH1:7']},
	{ f: ['P0.1:0', 'PWM0_CH4:1', 'SPI0_MISO:2', 'IC4:3', 'HXTOUT:6', 'PWM3_CH0:7']},
	{ f: ['P0.2:0', 'ICE_CLK:1', 'I2C0_SCL:3', 'UART1_RXD:4']},
	{ f: ['P0.3:0', 'ADC_CH6:1', 'IC5:3', 'PWM0_CH5:4', 'UART2_TXD:6', 'PWM3_CH1:7']},
	{ f: ['P0.4:0', 'ADC_CH5:1', 'IC3:3', 'PWM0_CH3:4', 'STADC:5', 'UART2_RXD:6', 'PWM2_CH1:7']},
	{ f: ['P0.5:0', 'ADC_CH4:1', 'IC6:3', 'PWM0_CH2:4', 'T0:5', 'UART3_TXD:6', 'PWM2_CH0:7']},
	{ f: ['P0.6:0', 'ADC_CH3:1', 'UART0_TXD:2']},
	{ f: ['P0.7:0', 'ADC_CH2:1', 'UART0_RXD:2']},

	{ f: ['P1.0:0', 'PWM0_CH2:1', 'SPI0_CLK:2', 'IC2:3', 'UART1_TXD:4', 'PWM2_CH0:6']},
	{ f: ['P1.1:0', 'ADC_CH7:1', 'CLKO:2', 'IC1:3', 'PWM0_CH1:4', 'UART3_RXD:5', 'PWM1_CH1:6']},
	{ f: ['P1.2:0', 'PWM0_CH0:1', 'IC0:3', 'UART3_TXD:5', 'PWM1_CH0:6']},
	{ f: ['P1.3:0', 'STADC:1', 'I2C0_SCL:2', 'ADC_CH13:4']},
	{ f: ['P1.4:0', 'PWM0_CH1:1', 'I2C0_SDA:2', 'PWM0_BRAKE:3', 'ADC_CH14:4', 'PWM1_CH1:6']},
	{ f: ['P1.5:0', 'PWM0_CH5:1', 'SPI0_SS:2', 'IC7:3', 'UART3_TXD:5', 'PWM3_CH1:6']},
	{ f: ['P1.6:0', 'ICE_DAT:1', 'I2C0_SDA:3', 'UART1_TXD:4']},
	{ f: ['P1.7:0', 'ADC_CH0:1', 'INT1:3', 'PWM3_CH0:4', 'UART2_RXD:5', 'SPI0_CLK:6']},

	{ f: ['P2.0:0', 'nRESET:1']},
	{ f: ['P2.1:0', 'ADC_CH9:1', 'PWM2_CH0:2']},
	{ f: ['P2.2:0', 'ADC_CH10:1', 'PWM1_CH1:2', 'UART4_RXD:5']},
	{ f: ['P2.3:0', 'ADC_CH11:1', 'PWM1_CH0:2', 'UART4_TXD:5']},
	{ f: ['P2.4:0', 'ADC_CH12:1', 'T0:5']},
	{ f: ['P2.5:0', 'ADC_CH15:1', 'UART3_RXD:5', 'SPI0_MISO:6']},
	{ f: ['P2.6:0']},
	{ f: ['P2.7:0']},

	{ f: ['P3.0:0', 'ADC_CH1:1', 'OSCIN:2', 'INT0:3', 'PWM2_CH1:4', 'UART2_TXD:5', 'SPI0_MOSI:6']},
	{ f: ['P3.1:0', 'PWM2_CH1:2']},
	{ f: ['P3.2:0', 'PWM3_CH0:2']},
	{ f: ['P3.3:0', 'PWM0_CH0:1', 'CLKO:2', 'PWM0_BRAKE:3']},
	{ f: ['P3.4:0', 'PWM3_CH1:1', 'UART3_RXD:6']},
	{ f: ['P3.5:0', 'SPI0_SS:2']},
	{ f: ['P3.6:0', 'UART1_TXD:5']},
	{ f: ['P3.7:0', 'UART1_RXD:5']}
];

NUTOOL_PIN.g_cfg_gpiosDefines = [
	{ f: ['P0.0', 'PWM0_CH3:P00_PUSHPULL_MODE;ENABLE_PWM0_CH3_P00_OUTPUT;@P0MF76543210', 'PWM2_CH1:P00_PUSHPULL_MODE;ENABLE_PWM2_CH1_P00_OUTPUT;@P0MF76543210', 'IC3:P00_INPUT_MODE;@P0MF76543210', 'SPI0_MOSI:P00_QUASI_MODE;ENABLE_SPI0_MOSI_P00;@P0MF76543210', 'UART1_RXD:P00_INPUT_MODE;ENABLE_UART1_RXD_P00;@P0MF76543210', 'HXTIN:P00_INPUT_MODE;@P0MF76543210', 'OSCIN:P00_INPUT_MODE;@P0MF76543210', 'T1:P00_QUASI_MODE;@P0MF76543210'] },
	{ f: ['P0.1', 'PWM0_CH4:P01_PUSHPULL_MODE;ENABLE_PWM0_CH4_P01_OUTPUT;@P0MF76543210', 'PWM3_CH0:P01_PUSHPULL_MODE;ENABLE_PWM3_CH0_P01_OUTPUT;@P0MF76543210', 'IC4:P01_INPUT_MODE;@P0MF76543210', 'SPI0_MISO:P01_QUASI_MODE;ENABLE_SPI0_MISO_P01;@P0MF76543210', 'HXTOUT:NULL@P0MF76543210'] },
	{ f: ['P0.2', 'I2C0_SCL:P02_QUASI_MODE;set_I2CON_I2CPX;@P0MF76543210', 'UART1_RXD:P02_INPUT_MODE;ENABLE_UART1_RXD_P02;@P0MF76543210', 'ICE_CLK:NULL@P0MF76543210'] },
	{ f: ['P0.3', 'ADC_CH6:ENABLE_ADC_CH6;@P0MF76543210', 'PWM0_CH5:P03_PUSHPULL_MODE;ENABLE_PWM0_CH5_P03_OUTPUT;@P0MF76543210', 'PWM3_CH1:P03_PUSHPULL_MODE;ENABLE_PWM3_CH1_P03_OUTPUT;@P0MF76543210', 'IC5:P03_INPUT_MODE;@P0MF76543210', 'UART2_TXD:P03_QUASI_MODE;ENABLE_UART2_TXD_P03;@P0MF76543210', 'SC0_CLK:P03_QUASI_MODE;@P0MF76543210'] },
	{ f: ['P0.4', 'ADC_CH5:ENABLE_ADC_CH5;@P0MF76543210', 'PWM0_CH3:P04_PUSHPULL_MODE;ENABLE_PWM0_CH3_P04_OUTPUT;@P0MF76543210', 'PWM2_CH1:P04_PUSHPULL_MODE;ENABLE_PWM2_CH1_P04_OUTPUT;@P0MF76543210', 'IC3:P04_INPUT_MODE;@P0MF76543210', 'UART2_RXD:P04_INPUT_MODE;ENABLE_UART2_RXD_P04;@P0MF76543210', 'SC0_DAT:P04_QUASI_MODE;@P0MF76543210', 'STADC:P04_INPUT_MODE;P04_FALLINGEDGE_TRIG_ADC;@P0MF76543210'] },
	{ f: ['P0.5', 'ADC_CH4:ENABLE_ADC_CH4;@P0MF76543210', 'PWM0_CH2:P05_PUSHPULL_MODE;ENABLE_PWM0_CH2_P05_OUTPUT;@P0MF76543210', 'PWM2_CH0:P05_PUSHPULL_MODE;ENABLE_PWM2_CH0_P05_OUTPUT;@P0MF76543210', 'IC6:P05_INPUT_MODE;@P0MF76543210', 'UART3_TXD:P05_QUASI_MODE;ENABLE_UART3_TXD_P05;@P0MF76543210', 'SC1_CLK:P05_QUASI_MODE;@P0MF76543210', 'T0:P05_QUASI_MODE;@P0MF76543210'] },
	{ f: ['P0.6', 'ADC_CH3:ENABLE_ADC_CH3;@P0MF76543210', 'UART0_TXD:P06_QUASI_MODE;@P0MF76543210'] },
	{ f: ['P0.7', 'ADC_CH2:ENABLE_ADC_CH2;@P0MF76543210', 'UART0_RXD:P07_INPUT_MODE;@P0MF76543210'] },
	{ f: ['P1.0', 'PWM0_CH2:P10_PUSHPULL_MODE;ENABLE_PWM0_CH2_P10_OUTPUT;@P1MF76543210', 'PWM2_CH0:P10_PUSHPULL_MODE;ENABLE_PWM2_CH0_P10_OUTPUT;@P1MF76543210', 'IC2:P10_INPUT_MODE;@P1MF76543210', 'SPI0_CLK:P10_QUASI_MODE;ENABLE_SPI0_CLK_P10;@P1MF76543210', 'UART1_TXD:P10_QUASI_MODE;ENABLE_UART1_TXD_P10;@P1MF76543210'] },
	{ f: ['P1.1', 'ADC_CH7:ENABLE_ADC_CH7;@P1MF76543210', 'PWM0_CH1:P11_PUSHPULL_MODE;ENABLE_PWM0_CH1_P11_OUTPUT;@P1MF76543210', 'PWM1_CH1:P11_PUSHPULL_MODE;ENABLE_PWM1_CH1_P11_OUTPUT;@P1MF76543210', 'IC1:P11_INPUT_MODE;@P1MF76543210', 'UART3_RXD:P11_INPUT_MODE;ENABLE_UART3_RXD_P11;@P1MF76543210', 'SC1_DAT:P11_QUASI_MODE;@P1MF76543210', 'CLKO:P11_PUSHPULL_MODE;@P1MF76543210'] },
	{ f: ['P1.2', 'PWM0_CH0:P12_PUSHPULL_MODE;ENABLE_PWM0_CH0_P12_OUTPUT;@P1MF76543210', 'PWM1_CH0:P12_PUSHPULL_MODE;ENABLE_PWM1_CH0_P12_OUTPUT;@P1MF76543210', 'IC0:P12_INPUT_MODE;@P1MF76543210', 'UART3_TXD:P12_QUASI_MODE;ENABLE_UART3_TXD_P12;@P1MF76543210', 'SC1_CLK:P12_QUASI_MODE;@P1MF76543210'] },
	{ f: ['P1.3', 'ADC_CH13:ENABLE_ADC_CH13;@P1MF76543210', 'I2C0_SCL:P13_QUASI_MODE;clr_I2CON_I2CPX;@P1MF76543210', 'STADC:P13_INPUT_MODE;P13_FALLINGEDGE_TRIG_ADC;@P1MF76543210'] },
	{ f: ['P1.4', 'ADC_CH14:ENABLE_ADC_CH14;@P1MF76543210', 'PWM0_CH1:P14_PUSHPULL_MODE;ENABLE_PWM0_CH1_P14_OUTPUT;@P1MF76543210', 'PWM1_CH1:P14_PUSHPULL_MODE;ENABLE_PWM1_CH1_P14_OUTPUT;@P1MF76543210', 'I2C0_SDA:P14_QUASI_MODE;clr_I2CON_I2CPX;@P1MF76543210', 'PWM0_BRAKE:P14_INPUT_MODE;@P1MF76543210'] },
	{ f: ['P1.5', 'PWM0_CH5:P15_PUSHPULL_MODE;ENABLE_PWM0_CH5_P15_OUTPUT;@P1MF76543210', 'PWM3_CH1:P15_PUSHPULL_MODE;ENABLE_PWM3_CH1_P15_OUTPUT;@P1MF76543210', 'IC7:P15_INPUT_MODE;@P1MF76543210', 'SPI0_SS:P15_QUASI_MODE;@P1MF76543210', 'UART3_TXD:P15_QUASI_MODE;ENABLE_UART3_TXD_P15;@P1MF76543210', 'SC1_CLK:P15_QUASI_MODE;@P1MF76543210'] },
	{ f: ['P1.6', 'I2C0_SDA:P16_QUASI_MODE;set_I2CON_I2CPX;@P1MF76543210', 'UART1_TXD:P16_QUASI_MODE;ENABLE_UART1_TXD_P16;@P1MF76543210', 'ICE_DAT:NULL@P1MF76543210'] },
	{ f: ['P1.7', 'ADC_CH0:ENABLE_ADC_CH0;@P1MF76543210', 'SPI0_CLK:P17_QUASI_MODE;ENABLE_SPI0_CLK_P17;@P1MF76543210', 'PWM3_CH0:P17_PUSHPULL_MODE;ENABLE_PWM3_CH0_P17_OUTPUT;@P1MF76543210', 'UART2_RXD:P17_INPUT_MODE;ENABLE_UART2_RXD_P17;@P1MF76543210', 'SC0_DAT:P17_QUASI_MODE;@P1MF76543210', 'INT1:P17_QUASI_MODE;@P1MF76543210'] },
	{ f: ['P2.0', 'nRESET:NULL@P2MF76543210'] },
	{ f: ['P2.1', 'ADC_CH9:ENABLE_ADC_CH9;@P2MF76543210', 'PWM2_CH0:P21_PUSHPULL_MODE;ENABLE_PWM2_CH0_P21_OUTPUT;@P2MF76543210'] },
	{ f: ['P2.2', 'ADC_CH10:ENABLE_ADC_CH10;@P2MF76543210', 'PWM1_CH1:P22_PUSHPULL_MODE;ENABLE_PWM1_CH1_P22_OUTPUT;@P2MF76543210', 'UART4_RXD:P22_INPUT_MODE;ENABLE_UART4_RXD_P22;@P2MF76543210', 'SC2_DAT:P22_QUASI_MODE;@P2MF76543210'] },
	{ f: ['P2.3', 'ADC_CH11:ENABLE_ADC_CH11;@P2MF76543210', 'PWM1_CH0:P23_PUSHPULL_MODE;ENABLE_PWM1_CH0_P23_OUTPUT;@P2MF76543210', 'UART4_TXD:P23_QUASI_MODE;ENABLE_UART4_TXD_P23;@P2MF76543210', 'SC2_CLK:P23_QUASI_MODE;@P2MF76543210'] },
	{ f: ['P2.4', 'ADC_CH12:ENABLE_ADC_CH12;@P2MF76543210', 'T0:P24_QUASI_MODE;@P2MF76543210'] },
	{ f: ['P2.5', 'ADC_CH15:ENABLE_ADC_CH15;@P2MF76543210', 'SPI0_MISO:P25_QUASI_MODE;ENABLE_SPI0_MISO_P25;@P2MF76543210', 'UART3_RXD:P25_INPUT_MODE;ENABLE_UART3_RXD_P25;@P2MF76543210', 'SC1_DAT:P25_QUASI_MODE;@P2MF76543210'] },
	{ f: ['P3.0', 'ADC_CH1:ENABLE_ADC_CH1;@P3MF76543210', 'SPI0_MOSI:P30_QUASI_MODE;ENABLE_SPI0_MOSI_P30;@P3MF76543210', 'UART2_TXD:P30_QUASI_MODE;ENABLE_UART2_TXD_P30;@P3MF76543210', 'SC0_CLK:P30_QUASI_MODE;@P3MF76543210', 'PWM2_CH1:P30_PUSHPULL_MODE;ENABLE_PWM2_CH1_P30_OUTPUT;@P3MF76543210', 'INT0:P30_QUASI_MODE;@P3MF76543210', 'OSCIN:P30_INPUT_MODE;@P3MF76543210'] },
	{ f: ['P3.1', 'PWM2_CH1:P31_PUSHPULL_MODE;ENABLE_PWM2_CH1_P31_OUTPUT;@P3MF76543210'] },
	{ f: ['P3.2', 'PWM3_CH0:P32_PUSHPULL_MODE;ENABLE_PWM3_CH0_P32_OUTPUT;@P3MF76543210'] },
	{ f: ['P3.3', 'PWM0_CH0:P33_PUSHPULL_MODE;ENABLE_PWM0_CH0_P33_OUTPUT;@P3MF76543210', 'CLKO:P33_PUSHPULL_MODE;@P3MF76543210', 'PWM0_BRAKE:P33_INPUT_MODE;@P3MF76543210'] },
	{ f: ['P3.4', 'PWM3_CH1:P34_PUSHPULL_MODE;ENABLE_PWM3_CH1_P34_OUTPUT;@P3MF76543210', 'UART3_RXD:P34_INPUT_MODE;ENABLE_UART3_RXD_P34;@P3MF76543210', 'SC1_DAT:P34_QUASI_MODE;@P3MF76543210'] },
	{ f: ['P3.5', 'SPI0_SS:P35_QUASI_MODE;@P3MF76543210'] },
	{ f: ['P3.6', 'UART1_TXD:P36_QUASI_MODE;ENABLE_UART1_TXD_P36;@P3MF76543210'] },
	{ f: ['P3.7', 'UART1_RXD:P37_INPUT_MODE;ENABLE_UART1_RXD_P37;@P3MF76543210'] }
];

NUTOOL_PIN.g_cfg_gpiosDescriptions = [
	'ADC_CH0:ADC input channel 0',
	'ADC_CH1:ADC input channel 1',
	'ADC_CH2:ADC input channel 2',
	'ADC_CH3:ADC input channel 3',
	'ADC_CH4:ADC input channel 4',
	'ADC_CH5:ADC input channel 5',
	'ADC_CH6:ADC input channel 6',
	'ADC_CH7:ADC input channel 7',
	'ADC_CH9:ADC input channel 9',
	'ADC_CH10:ADC input channel 10',
	'ADC_CH11:ADC input channel 11',
	'ADC_CH12:ADC input channel 12',
	'ADC_CH13:ADC input channel 13',
	'ADC_CH14:ADC input channel 14',
	'ADC_CH15:ADC input channel 15',
	'CLK_OUT:System clock output',
	'CLKO:System clock output',
	'I2C0_SCL:I2C0 clock',
	'I2C0_SDA:I2C0 data',
	'IC0:Input capture channel 0',
	'IC1:Input capture channel 1',
	'IC2:Input capture channel 2',
	'IC3:Input capture channel 3',
	'IC4:Input capture channel 4',
	'IC5:Input capture channel 5',
	'IC6:Input capture channel 6',
	'IC7:Input capture channel 7',
	'ICE_CLK:ICE / ICP clock input',
	'ICE_DAT:ICE data input or output',
	'INT0:External interrupt 0 input',
	'INT1:External interrupt 1 input',
	'nRESET: nRESET pin ',
	'OSCIN:External clock input pin',
	'PWM0_Brake:PWM0 Fault Brake input',
	'PWM0_CH0:PWM0 output channel 0',
	'PWM0_CH1:PWM0 output channel 1',
	'PWM0_CH2:PWM0 output channel 2',
	'PWM0_CH3:PWM0 output channel 3',
	'PWM0_CH4:PWM0 output channel 4',
	'PWM0_CH5:PWM0 output channel 5',
	'PWM1_CH0:PWM1 output channel 0',
	'PWM1_CH1:PWM1 output channel 1',
	'PWM2_CH0:PWM2 output channel 0',
	'PWM2_CH1:PWM2 output channel 1',
	'PWM3_CH0:PWM3 output channel 0',
	'PWM3_CH1:PWM3 output channel 1',
	'SC0_CLK:Smart card 0 clock pin',
	'SC0_DAT:Smart Card 0 data pin',
	'SC1_CLK:Smart card 1 clock pin',
	'SC1_DAT:Smart card 1 data pin',
	'SC2_CLK:Smart card 2 clock pin',
	'SC2_DAT:Smart card 2 data pin',
	'SPI0_CLK:SPI0 clock',
	'SPI0_MISO:SPI master input/slave output',
	'SPI0_MOSI:SPI master output/slave input',
	'SPI0_SS:SPI0 slave select input',
	'STADC:External start ADC trigger',
	'T0:External count input to Timer/Counter 0 or its toggle output',
	'T1:External count input to Timer/Counter 1 or its toggle output',
	'UART0_RXD:UART0 receive input',
	'UART0_TXD:UART0 transmit data output',
	'UART1_RXD:UART1 receive input',
	'UART1_TXD:UART1 transmit data output',
	'UART2_RXD:UART2 receive input',
	'UART2_TXD:UART2 transmit data output',
	'UART3_RXD:UART3 receive input',
	'UART3_TXD:UART3 transmit data output',
	'UART4_RXD:UART4 receive input',
	'UART4_TXD:UART4 transmit data output',
	'XT1_IN:External 4~24 MHz (high speed) crystal input pin',
	'XT1_OUT:External 4~24 MHz (high speed) crystal output pin'
];

NUTOOL_PIN.g_cfg_regDescriptions = {};
NUTOOL_PIN.g_cfg_regDescriptions.P0MF76543210 = 'This register is nonexistent';
NUTOOL_PIN.g_cfg_regDescriptions.P1MF76543210 = 'This register is nonexistent';
NUTOOL_PIN.g_cfg_regDescriptions.P2MF76543210 = 'This register is nonexistent';
NUTOOL_PIN.g_cfg_regDescriptions.P3MF76543210 = 'This register is nonexistent';

NUTOOL_PIN.g_cfg_gpioMatrix = [];
NUTOOL_PIN.g_cfg_shareBits = [];
NUTOOL_PIN.g_cfg_addGPIO = {};
NUTOOL_PIN.g_cfg_unusedGPIO = {};

NUTOOL_PIN.decidepackageNumber = function (given_partNumber_package) {
	var partNumber_package;

	if (typeof given_partNumber_package === 'undefined') {
		partNumber_package = NUTOOL_PIN.getg_partNumber_package();
	}
	else {
		partNumber_package = given_partNumber_package;
	}

	NUTOOL_PIN.g_packageNumber = partNumber_package.substring(partNumber_package.indexOf('(') + 1);
	NUTOOL_PIN.g_packageNumber = NUTOOL_PIN.g_packageNumber.substring(0, NUTOOL_PIN.g_packageNumber.indexOf(')'));
	NUTOOL_PIN.g_packageNumberIndex = NUTOOL_PIN.g_packageNumber;

	partNumber_package = null;
};
