// chip content
NUTOOL_PIN.g_cfg_chips = [
	{ name: "NUC472HI8AE", pkg: "LQFP176" },
	{ name: "NUC472HG8AE", pkg: "LQFP176" },

	{ name: "NUC472JI8AE", pkg: "LQFP144" },
	{ name: "NUC472JG8AE", pkg: "LQFP144" },

	{ name: "NUC472KI8AE", pkg: "LQFP128" },
	{ name: "NUC472KG8AE", pkg: "LQFP128" },

	{ name: "NUC472VI8AE", pkg: "LQFP100" },
	{ name: "NUC472VG8AE", pkg: "LQFP100" },

	{ name: "NUC442JI8AE", pkg: "LQFP144" },
	{ name: "NUC442JG8AE", pkg: "LQFP144" },

	{ name: "NUC442KI8AE", pkg: "LQFP128" },
	{ name: "NUC442KG8AE", pkg: "LQFP128" },

	{ name: "NUC442VI8AE", pkg: "LQFP100" },
	{ name: "NUC442VG8AE", pkg: "LQFP100" },

	{ name: "NUC442RI8AE", pkg: "LQFP64" },
	{ name: "NUC442RG8AE", pkg: "LQFP64" }
];

NUTOOL_PIN.g_cfg_pkgs = {
	"ULQFP176": [
		'PE.12', 'PE.13', 'PE.14', 'PE.15', 'PF.9', 'PF.10', 'PF.11', 'PF.12', 'PF.13', 'PF.14',
		'VSS', 'VDD', 'PF.15', 'PG.0', 'PG.1', 'PG.2', 'PC.12', 'PC.13', 'PC.14', 'PC.15',
		'PD.0', 'PD.1', 'PD.2', 'PH.11', 'PH.12', 'PH.13', 'PH.14', 'PD.3', 'PD.4', 'PD.5',
		'PD.6', 'PD.7', 'PH.15', 'PI.0', 'PI.1', 'PI.2', 'PG.13', 'PG.12', 'nRESET', 'LDO_CAP',
		'VSS', 'VDD', 'PG.10', 'PG.11',
		'PG.15', 'PG.14', 'VBAT', 'PA.0', 'PA.1', 'PI.3', 'PI.4', 'PI.5', 'PI.6', 'PD.8',
		'PD.9', 'PA.2', 'PA.3', 'PA.4', 'PA.5', 'PA.6', 'PI.7', 'PI.8', 'PG.3', 'PG.4',
		'PG.5', 'PG.6', 'VDD', 'VSS', 'PA.7', 'PA.8', 'PA.9', 'PA.10', 'PA.11', 'PA.12',
		'PA.13', 'PA.14', 'PI.9', 'PI.10', 'PD.10', 'PD.11', 'PD.12', 'PA.15', 'PC.9', 'PC.10',
		'PC.11', 'LDO_CAP', 'VSS', 'VDD',
		'PD.13', 'PD.14', 'PD.15', 'PF.0', 'VRES', 'VBUS', 'USB_VDD33_CAP', 'VSSA', 'USB0_D-', 'USB0_D+',
		'USB0_OTG_ID', 'PB.0', 'PB.1', 'PG.7', 'PG.8', 'PG.9', 'PI.11', 'PI.12', 'PI.13', 'PI.14',
		'PI.15', 'PF.1', 'VDD', 'VSS', 'PB.2', 'PB.3', 'PB.4', 'PB.5', 'PB.6', 'PB.7',
		'PB.8', 'PB.9', 'PB.10', 'PB.11', 'PH.0', 'PH.1', 'PB.12', 'PB.13', 'PB.14', 'PB.15',
		'VDD', 'VSS', 'LDO_CAP', 'PC.0',
		'PC.1', 'PC.2', 'PC.3', 'PC.4', 'PC.5', 'PC.6', 'PC.7', 'PC.8', 'PF.2', 'PF.3',
		'PF.4', 'PF.5', 'VSS', 'VDD', 'PF.6', 'PF.7', 'PF.8', 'PH.2', 'PH.3', 'PH.4',
		'PH.5', 'PH.6', 'PH.7', 'PH.8', 'PH.9', 'PH.10', 'LDO_CAP', 'VSS', 'VDD', 'PE.0',
		'PE.1', 'PE.2', 'PE.3', 'PE.4', 'PE.5', 'PE.6', 'PE.7', 'AVSS', 'Vref', 'AVDD',
		'PE.8', 'PE.9', 'PE.10', 'PE.11'
	],
	"ULQFP144": [
		'PE.12', 'PE.13', 'PE.14', 'PE.15', 'PF.9', 'PF.10', 'PF.11', 'PF.12', 'PF.13', 'PF.14',
		'VSS', 'VDD', 'PF.15', 'PG.0', 'PG.1', 'PG.2', 'PC.12', 'PC.13', 'PC.14', 'PC.15',
		'PD.0', 'PD.1', 'PD.2', 'PD.3', 'PD.4', 'PD.5', 'PD.6', 'PD.7', 'PG.13', 'PG.12',
		'nRESET', 'LDO_CAP', 'VSS', 'VDD', 'PG.10', 'PG.11',
		'PG.15', 'PG.14', 'VBAT', 'PA.0', 'PA.1', 'PD.8', 'PD.9', 'PA.2', 'PA.3', 'PA.4',
		'PA.5', 'PA.6', 'PG.3', 'PG.4', 'PG.5', 'PG.6', 'VDD', 'VSS', 'PA.7', 'PA.8',
		'PA.9', 'PA.10', 'PA.11', 'PA.12', 'PA.13', 'PA.14', 'PD.10', 'PD.11', 'PD.12', 'PA.15',
		'PC.9', 'PC.10', 'PC.11', 'LDO_CAP', 'VSS', 'VDD',
		'PD.13', 'PD.14', 'PD.15', 'PF.0', 'VRES', 'VBUS', 'USB_VDD33_CAP', 'VSSA', 'USB0_D-', 'USB0_D+',
		'USB0_OTG_ID', 'PB.0', 'PB.1', 'PG.7', 'PG.8', 'PG.9', 'PB.2', 'PB.3', 'PB.4', 'PB.5',
		'PB.6', 'PB.7', 'PB.8', 'PB.9', 'PB.10', 'PB.11', 'PH.0', 'PH.1', 'PB.12', 'PB.13',
		'PB.14', 'PB.15', 'VDD', 'VSS', 'LDO_CAP', 'PC.0',
		'PC.1', 'PC.2', 'PC.3', 'PC.4', 'PC.5', 'PC.6', 'PC.7', 'PC.8', 'PF.2', 'PF.3',
		'PF.4', 'PF.5', 'VSS', 'VDD', 'PF.6', 'PF.7', 'PF.8', 'PH.2', 'LDO_CAP', 'VSS',
		'VDD', 'PE.0', 'PE.1', 'PE.2', 'PE.3', 'PE.4', 'PE.5', 'PE.6', 'PE.7', 'AVSS',
		'Vref', 'AVDD', 'PE.8', 'PE.9', 'PE.10', 'PE.11'
	],
	"ULQFP128": [
		'PE.12', 'PE.13', 'PE.14', 'PE.15', 'PF.9', 'PF.10', 'PF.11', 'PF.12', 'PF.13', 'PF.14',
		'VSS', 'VDD', 'PC.12', 'PC.13', 'PC.14', 'PC.15', 'PD.0', 'PD.1', 'PD.2', 'PD.3',
		'PD.4', 'PD.5', 'PD.6', 'PD.7', 'PG.13', 'PG.12', 'nRESET', 'LDO_CAP', 'VSS', 'VDD',
		'PG.10', 'PG.11',
		'PG.15', 'PG.14', 'VBAT', 'PA.0', 'PA.1', 'PD.8', 'PD.9', 'PA.2', 'PA.3', 'PA.4',
		'PA.5', 'PA.6', 'VDD', 'VSS', 'PA.7', 'PA.8', 'PA.9', 'PA.10', 'PA.11', 'PA.12',
		'PA.13', 'PA.14', 'PD.10', 'PD.11', 'PD.12', 'PA.15', 'PC.9', 'PC.10', 'PC.11', 'LDO_CAP',
		'VSS', 'VDD',
		'PD.13', 'PD.14', 'PD.15', 'PF.0', 'VRES', 'VBUS', 'USB_VDD33_CAP', 'VSSA', 'USB0_D-', 'USB0_D+',
		'USB0_OTG_ID', 'PB.0', 'PB.1', 'PF.1', 'PB.2', 'PB.3', 'PB.4', 'PB.5', 'PB.6', 'PB.7',
		'PB.8', 'PB.9', 'PB.10', 'PB.11', 'PB.12', 'PB.13', 'PB.14', 'PB.15', 'VDD', 'VSS',
		'PC.0', 'PC.1',
		'PC.2', 'PC.3', 'PC.4', 'PC.5', 'PC.6', 'PC.7', 'PC.8', 'PF.2', 'PF.3', 'PF.4',
		'PF.5', 'PF.6', 'PF.7', 'PF.8', 'LDO_CAP', 'VSS', 'VDD', 'PE.0', 'PE.1', 'PE.2',
		'PE.3', 'PE.4', 'PE.5', 'PE.6', 'PE.7', 'AVSS', 'Vref', 'AVDD', 'PE.8', 'PE.9',
		'PE.10', 'PE.11'
	],
	"ULQFP100": [
		'PE.12', 'PE.13', 'PE.14', 'PE.15', 'VSS', 'VDD', 'PC.12', 'PC.13', 'PC.14', 'PC.15',
		'PD.0', 'PD.1', 'PD.3', 'PD.4', 'PD.5', 'PD.6', 'PD.7', 'PG.13', 'PG.12', 'nRESET',
		'LDO_CAP', 'VSS', 'VDD', 'PG.10', 'PG.11',
		'PG.15', 'PG.14', 'VBAT', 'PA.0', 'PA.1', 'PA.2', 'PA.3', 'PA.4', 'PA.5', 'PA.6',
		'PA.7', 'PA.8', 'PA.9', 'PA.10', 'PA.11', 'PA.12', 'PA.13', 'PA.14', 'PA.15', 'PC.9',
		'PC.10', 'PC.11', 'LDO_CAP', 'VSS', 'VDD',
		'VRES', 'VBUS', 'USB_VDD33_CAP', 'VSSA', 'USB0_D-', 'USB0_D+', 'USB0_OTG_ID', 'PB.0', 'PB.1', 'PB.2',
		'PB.3', 'PB.4', 'PB.5', 'PB.6', 'PB.7', 'PB.8', 'PB.9', 'PB.10', 'PB.11', 'PB.12',
		'PB.13', 'PB.14', 'PB.15', 'VDD', 'PC.0',
		'PC.1', 'PC.2', 'PC.3', 'PC.4', 'PC.5', 'PC.6', 'PC.7', 'PC.8', 'LDO_CAP', 'VSS',
		'PE.0', 'PE.1', 'PE.2', 'PE.3', 'PE.4', 'PE.5', 'PE.6', 'PE.7', 'AVSS', 'Vref',
		'AVDD', 'PE.8', 'PE.9', 'PE.10', 'PE.11'
	],
	"ULQFP64": [
		'PE.8', 'PE.9', 'PE.10', 'PE.11', 'VSS', 'VDD', 'PD.3', 'PD.4', 'PD.5', 'PD.6',
		'PD.7', 'PG.13', 'PG.12', 'nRESET', 'PG.10', 'PG.11',
		'PG.15', 'PG.14', 'VBAT', 'PA.0', 'PA.6', 'PA.7', 'PA.8', 'PA.9', 'PA.10', 'PA.11',
		'PA.12', 'PA.13', 'PA.14', 'LDO_CAP', 'VSS', 'VDD',
		'VRES', 'VBUS', 'USB_VDD33_CAP', 'VSSA', 'USB0_D-', 'USB0_D+', 'USB0_OTG_ID', 'PB.0', 'PB.1', 'PB.2',
		'PB.3', 'PB.4', 'PB.5', 'PB.12', 'PB.13', 'VDD',
		'PC.0', 'PC.1', 'PC.2', 'PC.3', 'PC.4', 'PC.6', 'PC.7', 'PC.8', 'LDO_CAP', 'PE.4',
		'PE.5', 'PE.6', 'PE.7', 'AVSS', 'Vref', 'AVDD'
	]
};

NUTOOL_PIN.g_cfg_gpios = [
	{ f: ['PA.0:0', 'TAMPER0:1', 'SC0_CD:2', 'CAN1_RXD:3', 'INT0:8'] },
	{ f: ['PA.1:0', 'TAMPER1:1', 'SC5_CD:2', 'CAN1_TXD:3', 'EBI_A22:7'] },
	{ f: ['PA.2:0', 'SC2_DAT:1', 'SPI3_MISO0:2', 'I2S0_MCLK:3', 'BRAKE11:4', 'CAP_SFIELD:5', 'EBI_A12:7'] },
	{ f: ['PA.3:0', 'SC2_CLK:1', 'SPI3_MOSI0:2', 'I2S0_DO:3', 'BRAKE10:4', 'EBI_A13:7'] },
	{ f: ['PA.4:0', 'SC2_PWR:1', 'SPI3_CLK:2', 'I2S0_DI:3', 'QEI1_Z:5', 'EBI_A14:7', 'ECAP1_IC2:8'] },
	{ f: ['PA.5:0', 'SC2_RST:1', 'SPI3_SS0:2', 'I2S0_BCLK:3', 'PWM0_0:4', 'QEI1_B:5', 'EBI_A15:7', 'ECAP1_IC1:8'] },
	{ f: ['PA.6:0', 'SC2_CD:1', 'I2S0_LRCK:3', 'PWM0_1:4', 'QEI1_A:5', 'CAN1_TXD:6', 'EBI_A16:7', 'ECAP1_IC0:8'] },
	{ f: ['PA.7:0', 'SC0_CLK:2', 'SPI3_SS0:3', 'PWM1_3:4', 'EPWM0_5:5', 'EBI_A17:7'] },
	{ f: ['PA.8:0', 'SC0_RST:2', 'SPI3_CLK:3', 'PWM1_2:4', 'EPWM0_4:5', 'EBI_A18:7'] },
	{ f: ['PA.9:0', 'SC0_PWR:2', 'SPI3_MISO0:3', 'PWM1_1:4', 'EPWM0_3:5', 'EBI_A19:7'] },
	{ f: ['PA.10:0', 'SC0_DAT:2', 'SPI3_MOSI0:3', 'PWM1_0:4', 'EPWM0_2:5', 'EBI_A20:7'] },
	{ f: ['PA.11:0', 'UART0_RTS:1', 'SPI3_MISO1:3', 'PWM0_5:4', 'EPWM0_1:5', 'EBI_AD0:7'] },
	{ f: ['PA.12:0', 'UART0_CTS:1', 'SPI3_MOSI1:3', 'PWM0_4:4', 'EPWM0_0:5', 'EBI_AD1:7'] },
	{ f: ['PA.13:0', 'UART0_RXD:1', 'SC3_DAT:3', 'PWM1_4:4', 'EBI_AD2:7'] },
	{ f: ['PA.14:0', 'UART0_TXD:1', 'SC3_CLK:3', 'PWM1_5:4', 'EBI_AD3:7'] },
	{ f: ['PA.15:0', 'SC3_PWR:1', 'UART2_RTS:2', 'I2C0_SCL:4', 'EBI_A21:7'] },

	{ f: ['PB.0:0', 'USB0_OTG5V_ST:1', 'I2C4_SCL:2', 'INT1:8'] },
	{ f: ['PB.1:0', 'USB0_OTG5V_EN:1', 'I2C4_SDA:2', 'TM1_CNT_OUT:3'] },
	{ f: ['PB.2:0', 'UART1_RXD:1', 'SPI2_SS0:2', 'USB1_D-:3', 'EBI_AD4:7'] },
	{ f: ['PB.3:0', 'UART1_TXD:1', 'SPI2_CLK:2', 'USB1_D+:3', 'EBI_AD5:7'] },
	{ f: ['PB.4:0', 'UART1_RTS:1', 'SPI2_MISO0:2', 'UART4_RXD:3', 'TM0_CNT_OUT:4', 'EBI_AD6:7'] },
	{ f: ['PB.5:0', 'UART1_CTS:1', 'SPI2_MOSI0:2', 'UART4_TXD:3', 'EBI_AD7:7'] },
	{ f: ['PB.6:0', 'I2C2_SCL:1', 'BRAKE01:2', 'UART4_RTS:3', 'PWM1_4:4', 'EPWM1_0:5', 'EBI_AD8:7'] },
	{ f: ['PB.7:0', 'I2C2_SDA:1', 'BRAKE00:2', 'UART4_CTS:3', 'PWM1_5:4', 'EPWM1_1:5', 'ETM_TRACE_DATA3:6', 'EBI_AD9:7'] },
	{ f: ['PB.8:0', 'UART5_CTS:1', 'EPWM1_2:5', 'ETM_TRACE_DATA2:6', 'EBI_AD10:7'] },
	{ f: ['PB.9:0', 'UART5_RTS:1', 'EPWM1_3:5', 'ETM_TRACE_DATA1:6', 'EBI_AD11:7'] },
	{ f: ['PB.10:0', 'UART5_TXD:1', 'EPWM1_4:5', 'ETM_TRACE_DATA0:6', 'EBI_AD12:7'] },
	{ f: ['PB.11:0', 'UART5_RXD:1', 'EPWM1_5:5', 'ETM_TRACE_CLK:6', 'EBI_AD13:7'] },
	{ f: ['PB.12:0', 'UART4_RTS:1', 'SPI2_MISO1:2', 'CAN0_RXD:3', 'EMAC_MII_MDC:6', 'EBI_AD14:7'] },
	{ f: ['PB.13:0', 'UART4_CTS:1', 'SPI2_MOSI1:2', 'CAN0_TXD:3', 'EMAC_MII_MDIO:6', 'EBI_AD15:7'] },
	{ f: ['PB.14:0', 'I2S1_MCLK:1', 'SC1_RST:2', 'BRAKE01:4', 'EMAC_MII_MDC:6'] },
	{ f: ['PB.15:0', 'I2S1_DO:1', 'SC1_DAT:2', 'BRAKE00:4', 'EMAC_MII_MDIO:6'] },

	{ f: ['PC.0:0', 'I2S1_DI:1', 'SC1_DAT:2', 'UART4_RXD:3', 'EMAC_REFCLK:6', 'EBI_MCLK:7', 'INT2:8'] },
	{ f: ['PC.1:0', 'I2S1_BCLK:1', 'SC1_CLK:2', 'UART4_TXD:3', 'TM3_CNT_OUT:5', 'EMAC_MII_RXERR:6', 'EBI_AD13:7'] },
	{ f: ['PC.2:0', 'I2S1_LRCK:1', 'SC1_PWR:2', 'UART4_RTS:3', 'SPI0_SS0:4', 'EMAC_MII_RXDV:6', 'EBI_AD12:7'] },
	{ f: ['PC.3:0', 'I2S1_MCLK:1', 'SC1_CD:2', 'UART4_CTS:3', 'SPI0_MISO1:4', 'QEI0_Z:5', 'EMAC_MII_RXD1:6', 'EBI_AD11:7', 'ECAP0_IC2:8'] },
	{ f: ['PC.4:0', 'I2S1_DO:1', 'SC1_RST:2', 'SPI0_MOSI1:4', 'QEI0_B:5', 'EMAC_MII_RXD0:6', 'EBI_AD10:7', 'ECAP0_IC1:8'] },
	{ f: ['PC.5:0', 'CLKO:1', 'QEI0_A:5', 'EMAC_MII_RXCLK:6', 'EBI_MCLK:7', 'ECAP0_IC0:8'] },
	{ f: ['PC.6:0', 'TM2_EXT:1', 'SPI0_MISO0:4', 'TM2_CNT_OUT:5', 'EMAC_MII_TXD0:6', 'EBI_AD9:7'] },
	{ f: ['PC.7:0', 'TM1_EXT:1', 'SPI0_MOSI0:4', 'EMAC_MII_TXD1:6', 'EBI_AD8:7'] },
	{ f: ['PC.8:0', 'TM0_EXT:1', 'SPI0_CLK:4', 'EMAC_MII_TXEN:6'] },
	{ f: ['PC.9:0', 'STADC:1', 'UART2_CTS:2', 'SC3_RST:3', 'I2C0_SDA:4', 'CAP_DATA1:5', 'I2C3_SCL:6', 'EBI_A22:7', 'SD1_DAT0:8', 'EBI_A6:9'] },
	{ f: ['PC.10:0', 'SC3_CD:1', 'UART2_RXD:2', 'PWM0_2:4', 'EBI_A23:6', 'EBI_AD2:7'] },
	{ f: ['PC.11:0', 'UART2_TXD:2', 'PWM0_3:4', 'EBI_A24:6', 'EBI_AD3:7'] },
	{ f: ['PC.12:0', 'SPI1_SS0:1', 'SC4_CD:2', 'SD1_CDn:4', 'CAP_DATA7:5', 'ETM_TRACE_DATA3:6', 'EBI_A0:7'] },
	{ f: ['PC.13:0', 'SPI1_MOSI1:1', 'SC4_RST:2', 'SD1_CMD:4', 'CAP_DATA6:5', 'ETM_TRACE_DATA2:6', 'EBI_A1:7'] },
	{ f: ['PC.14:0', 'SPI1_MISO1:1', 'SC4_PWR:2', 'TM3_EXT:3', 'SD1_CLK:4', 'CAP_DATA5:5', 'ETM_TRACE_DATA1:6', 'EBI_A2:7'] },
	{ f: ['PC.15:0', 'SPI1_MOSI0:1', 'SC4_DAT:2', 'SD1_DAT3:4', 'CAP_DATA4:5', 'ETM_TRACE_DATA0:6', 'EBI_A3:7'] },

	{ f: ['PD.0:0', 'SPI1_MISO0:1', 'SC4_CLK:2', 'SD1_DAT2:4', 'CAP_DATA3:5', 'ETM_TRACE_CLK:6', 'EBI_A4:7', 'INT3:8'] },
	{ f: ['PD.1:0', 'SPI1_CLK:1', 'TM0_CNT_OUT:3', 'SD1_DAT1:4', 'CAP_DATA2:5', 'EBI_A5:7'] },
	{ f: ['PD.2:0', 'STADC:1', 'I2C3_SCL:2', 'SD1_DAT0:4', 'CAP_DATA1:5', 'EBI_A6:7'] },
	{ f: ['PD.3:0', 'SC5_CLK:1', 'I2C3_SDA:2', 'ACMP2_O:3', 'SD0_CDn:4', 'CAP_DATA0:5', 'JTAG_TDO:6', 'EBI_A7:7'] },
	{ f: ['PD.4:0', 'SC5_CD:1', 'UART3_RXD:2', 'ACMP1_O:3', 'CAP_SCLK:5', 'JTAG_TDI:6', 'EBI_A8:7'] },
	{ f: ['PD.5:0', 'SC5_RST:1', 'UART3_TXD:2', 'CAP_VSYNC:5', 'JTAG_nTRST:6', 'EBI_A9:7'] },
	{ f: ['PD.6:0', 'SC5_PWR:1', 'UART3_RTS:2', 'SD0_CMD:4', 'CAP_HSYNC:5', 'EBI_A10:7'] },
	{ f: ['PD.7:0', 'SC5_DAT:1', 'UART3_CTS:2', 'SD0_CLK:4', 'CAP_PIXCLK:5', 'EBI_A11:7'] },
	{ f: ['PD.8:0', 'SPI3_MISO1:1', 'I2C0_SCL:2'] },
	{ f: ['PD.9:0', 'SPI3_MOSI1:1', 'I2C0_SDA:2'] },
	{ f: ['PD.10:0', 'SC3_DAT:1', 'I2C4_SCL:2'] },
	{ f: ['PD.11:0', 'SC3_RST:1', 'TM3_CNT_OUT:3'] },
	{ f: ['PD.12:0', 'SC3_CLK:1', 'I2C4_SDA:2'] },
	{ f: ['PD.13:0', 'SPI1_SS0:1', 'UART5_CTS:2', 'ECAP0_IC2:3'] },
	{ f: ['PD.14:0', 'SPI1_CLK:1', 'UART5_RTS:2', 'ECAP0_IC1:3'] },
	{ f: ['PD.15:0', 'SPI1_MISO0:1', 'UART5_TXD:2', 'ECAP0_IC0:3'] },

	{ f: ['PE.0:0', 'ADC0_0:1', 'INT4:8'] },
	{ f: ['PE.1:0', 'ADC0_1:1', 'TM2_CNT_OUT:3'] },
	{ f: ['PE.2:0', 'ADC0_2:1', 'ACMP0_O:2', 'SPI0_MISO0:3'] },
	{ f: ['PE.3:0', 'ADC0_3:1', 'ACMP0_P3:2', 'SPI0_MOSI0:3'] },
	{ f: ['PE.4:0', 'ADC0_4:1', 'ACMP0_P2:2', 'SPI0_SS0:3'] },
	{ f: ['PE.5:0', 'ADC0_5:1', 'ACMP0_P1:2', 'SPI0_CLK:3', 'SD0_CDn:4'] },
	{ f: ['PE.6:0', 'ADC0_6:1', 'ACMP0_P0:2', 'SPI0_MISO0:3', 'SD0_CMD:4', 'EBI_nWR:7'] },
	{ f: ['PE.7:0', 'ADC0_7:1', 'ACMP0_N:2', 'SPI0_MOSI0:3', 'SD0_CLK:4', 'EBI_nRD:7'] },
	{ f: ['PE.8:0', 'ADC0_8:1', 'ADC1_0:1', 'ACMP1_N:2', 'TM1_CNT_OUT:3', 'SD0_DAT3:4', 'EBI_ALE:7'] },
	{ f: ['PE.9:0', 'ADC0_9:1', 'ADC1_1:1', 'ACMP1_P0:2', 'SD0_DAT2:4', 'EBI_nWRH:7'] },
	{ f: ['PE.10:0', 'ADC0_10:1', 'ADC1_2:1', 'ACMP1_P1:2', 'SPI0_MISO1:3', 'SD0_DAT1:4', 'EBI_nWRL:7'] },
	{ f: ['PE.11:0', 'ADC0_11:1', 'ADC1_3:1', 'ACMP1_P2:2', 'SPI0_MOSI1:3', 'SD0_DAT0:4', 'ACMP2_P3:5', 'EBI_nCS0:7'] },
	{ f: ['PE.12:0', 'ADC1_4:1', 'ACMP1_P3:2', 'ACMP2_P2:3', 'EBI_nCS1:7'] },
	{ f: ['PE.13:0', 'ADC1_5:1', 'ACMP2_P1:3', 'EBI_nCS2:7'] },
	{ f: ['PE.14:0', 'ADC1_6:1', 'ACMP2_P0:3', 'EBI_nCS3:7'] },
	{ f: ['PE.15:0', 'ADC1_7:1', 'ACMP2_N:3'] },

	{ f: ['PF.0:0', 'SPI1_MOSI0:1', 'UART5_RXD:2', 'INT5:8'] },
	{ f: ['PF.1:0', 'SPI2_MOSI1:1'] },
	{ f: ['PF.2:0', 'SPI3_SS0:1', 'SD0_DAT3:4', 'EMAC_MII_RXD3:6'] },
	{ f: ['PF.3:0', 'SPI3_CLK:1', 'SD0_DAT2:4', 'EMAC_MII_RXD2:6'] },
	{ f: ['PF.4:0', 'SPI3_MISO0:1', 'SD0_DAT1:4', 'EMAC_MII_COL0:6'] },
	{ f: ['PF.5:0', 'SPI3_MOSI0:1', 'SD0_DAT0:4', 'EMAC_MII_CRS:6'] },
	{ f: ['PF.6:0', 'UART2_RXD:1', 'SD0_CDn:4', 'EMAC_MII_TXCLK:6'] },
	{ f: ['PF.7:0', 'UART2_TXD:1', 'SD0_CMD:4', 'EMAC_MII_TXD3:6'] },
	{ f: ['PF.8:0', 'UART2_RTS:1', 'SD0_CLK:4', 'EMAC_MII_TXD2:6'] },
	{ f: ['PF.9:0', 'OPA0_P:1', 'PWM0_0:4'] },
	{ f: ['PF.10:0', 'OPA0_N:1', 'PWM0_1:4'] },
	{ f: ['PF.11:0', 'OPA0_O:1', 'UART1_RTS:2'] },
	{ f: ['PF.12:0', 'OPA1_P:1', 'UART1_CTS:2'] },
	{ f: ['PF.13:0', 'OPA1_N:1', 'UART1_TXD:2'] },
	{ f: ['PF.14:0', 'OPA1_O:1', 'UART1_RXD:2'] },
	{ f: ['PF.15:0', 'UART0_RTS:1'] },

	{ f: ['PG.0:0', 'UART0_CTS:1', 'INT6:8'] },
	{ f: ['PG.1:0', 'UART0_RXD:1'] },
	{ f: ['PG.2:0', 'UART0_TXD:1'] },
	{ f: ['PG.3:0', 'PS2_CLK:1', 'I2S1_DO:2', 'SC1_RST:3'] },
	{ f: ['PG.4:0', 'PS2_DAT:1', 'I2S1_DI:2', 'SC1_PWR:3'] },
	{ f: ['PG.5:0', 'I2S1_BCLK:2', 'SC1_DAT:3'] },
	{ f: ['PG.6:0', 'I2S1_LRCK:2', 'SC1_CLK:3'] },
	{ f: ['PG.7:0', 'SPI2_MISO0:1', 'I2S1_MCLK:2', 'SC1_CD:3', 'SC3_RST:4'] },
	{ f: ['PG.8:0', 'SPI2_MOSI0:1', 'I2S1_DO:2', 'UART4_RTS:3', 'SC3_DAT:4'] },
	{ f: ['PG.9:0', 'SPI2_CLK:1', 'I2S1_DI:2', 'UART4_CTS:3', 'SC3_CLK:4'] },
	{ f: ['PG.10:0', 'ICE_CLK:1', 'JTAG_TCK:6'] },
	{ f: ['PG.11:0', 'ICE_DAT:1', 'JTAG_TMS:6'] },
	{ f: ['PG.12:0', 'XT1_OUT:1'] },
	{ f: ['PG.13:0', 'XT1_IN:1'] },
	{ f: ['PG.14:0', 'X32K_OUT:1', 'I2C1_SDA:3'] },
	{ f: ['PG.15:0', 'X32K_IN:1', 'I2C1_SCL:3'] },

	{ f: ['PH.0:0', 'I2C1_SCL:1', 'UART4_RXD:2', 'CAN1_RXD:3', 'INT7:8'] },
	{ f: ['PH.1:0', 'UART4_TXD:1', 'I2C1_SDA:2', 'CAN1_TXD:3'] },
	{ f: ['PH.2:0', 'UART2_CTS:1'] },
	{ f: ['PH.3:0', 'I2C3_SCL:1'] },
	{ f: ['PH.4:0', 'I2C3_SDA:1'] },
	{ f: ['PH.5:0', 'SPI2_SS0:1'] },
	{ f: ['PH.6:0', 'SPI2_CLK:1'] },
	{ f: ['PH.7:0', 'SPI2_MISO0:1'] },
	{ f: ['PH.8:0', 'SPI2_MOSI0:1'] },
	{ f: ['PH.9:0', 'SPI2_MISO1:1'] },
	{ f: ['PH.10:0', 'SPI2_MOSI1:1'] },
	{ f: ['PH.11:0', 'UART3_RXD:1'] },
	{ f: ['PH.12:0', 'UART3_TXD:1'] },
	{ f: ['PH.13:0', 'UART3_RTS:1'] },
	{ f: ['PH.14:0', 'UART3_CTS:1'] },
	{ f: ['PH.15:0', 'SC5_CLK:2'] },

	{ f: ['PI.0:0', 'SC5_RST:2'] },
	{ f: ['PI.1:0', 'SC5_PWR:2'] },
	{ f: ['PI.2:0', 'SC5_DAT:1'] },
	{ f: ['PI.3:0', 'SPI3_SS0:1'] },
	{ f: ['PI.4:0', 'SPI3_CLK:1'] },
	{ f: ['PI.5:0', 'SPI3_MISO0:1'] },
	{ f: ['PI.6:0', 'SPI3_MOSI0:1'] },
	{ f: ['PI.7:0', 'I2C2_SCL:1', 'SPI3_MISO1:2'] },
	{ f: ['PI.8:0', 'I2C2_SDA:1', 'SPI3_MOSI1:2'] },
	{ f: ['PI.9:0', 'I2C4_SCL:4'] },
	{ f: ['PI.10:0'] },
	{ f: ['PI.11:0', 'SPI2_SS0:1', 'I2S1_BCLK:2', 'I2C4_SCL:3', 'SC3_PWR:4'] },
	{ f: ['PI.12:0', 'SPI2_MISO1:1', 'I2S1_LRCK:2', 'I2C4_SDA:3', 'SC3_CD:4'] },
	{ f: ['PI.13:0'] },
	{ f: ['PI.14:0'] },
	{ f: ['PI.15:0'] }
];

NUTOOL_PIN.g_cfg_gpiosDefines = [
	{ f: ['PA.0', 'GPIO:SYS_GPA_MFPL_PA0MFP_GPIO@GPA_MFPL', 'TAMPER0:SYS_GPA_MFPL_PA0MFP_TAMPER0@GPA_MFPL', 'SC0_CD:SYS_GPA_MFPL_PA0MFP_SC0_CD@GPA_MFPL', 'CAN1_RXD:SYS_GPA_MFPL_PA0MFP_CAN1_RXD@GPA_MFPL', 'INT0:SYS_GPA_MFPL_PA0MFP_INT0@GPA_MFPL'] },
	{ f: ['PA.1', 'GPIO:SYS_GPA_MFPL_PA1MFP_GPIO@GPA_MFPL', 'TAMPER1:SYS_GPA_MFPL_PA1MFP_TAMPER1@GPA_MFPL', 'SC5_CD:SYS_GPA_MFPL_PA1MFP_SC5_CD@GPA_MFPL', 'CAN1_TXD:SYS_GPA_MFPL_PA1MFP_CAN1_TXD@GPA_MFPL', 'EBI_A22:SYS_GPA_MFPL_PA1MFP_EBI_A22@GPA_MFPL'] },
	{ f: ['PA.2', 'GPIO:SYS_GPA_MFPL_PA2MFP_GPIO@GPA_MFPL', 'SC2_DAT:SYS_GPA_MFPL_PA2MFP_SC2_DAT@GPA_MFPL', 'SPI3_MISO0:SYS_GPA_MFPL_PA2MFP_SPI3_MISO0@GPA_MFPL', 'I2S0_MCLK:SYS_GPA_MFPL_PA2MFP_I2S0_MCLK@GPA_MFPL', 'BRAKE11:SYS_GPA_MFPL_PA2MFP_BRAKE11@GPA_MFPL', 'CAP_SFIELD:SYS_GPA_MFPL_PA2MFP_CAP_SFIELD@GPA_MFPL', 'EBI_A12:SYS_GPA_MFPL_PA2MFP_EBI_A12@GPA_MFPL'] },
	{ f: ['PA.3', 'GPIO:SYS_GPA_MFPL_PA3MFP_GPIO@GPA_MFPL', 'SC2_CLK:SYS_GPA_MFPL_PA3MFP_SC2_CLK@GPA_MFPL', 'SPI3_MOSI0:SYS_GPA_MFPL_PA3MFP_SPI3_MOSI0@GPA_MFPL', 'I2S0_DO:SYS_GPA_MFPL_PA3MFP_I2S0_DO@GPA_MFPL', 'BRAKE10:SYS_GPA_MFPL_PA3MFP_BRAKE10@GPA_MFPL', 'EBI_A13:SYS_GPA_MFPL_PA3MFP_EBI_A13@GPA_MFPL'] },
	{ f: ['PA.4', 'GPIO:SYS_GPA_MFPL_PA4MFP_GPIO@GPA_MFPL', 'SC2_PWR:SYS_GPA_MFPL_PA4MFP_SC2_PWR@GPA_MFPL', 'SPI3_CLK:SYS_GPA_MFPL_PA4MFP_SPI3_CLK@GPA_MFPL', 'I2S0_DI:SYS_GPA_MFPL_PA4MFP_I2S0_DI@GPA_MFPL', 'QEI1_Z:SYS_GPA_MFPL_PA4MFP_QEI1_Z@GPA_MFPL', 'EBI_A14:SYS_GPA_MFPL_PA4MFP_EBI_A14@GPA_MFPL', 'ECAP1_IC2:SYS_GPA_MFPL_PA4MFP_ECAP1_IC2@GPA_MFPL'] },
	{ f: ['PA.5', 'GPIO:SYS_GPA_MFPL_PA5MFP_GPIO@GPA_MFPL', 'SC2_RST:SYS_GPA_MFPL_PA5MFP_SC2_RST@GPA_MFPL', 'SPI3_SS0:SYS_GPA_MFPL_PA5MFP_SPI3_SS0@GPA_MFPL', 'I2S0_BCLK:SYS_GPA_MFPL_PA5MFP_I2S0_BCLK@GPA_MFPL', 'PWM0_0:SYS_GPA_MFPL_PA5MFP_PWM0_CH0@GPA_MFPL', 'QEI1_B:SYS_GPA_MFPL_PA5MFP_QEI1_B@GPA_MFPL', 'EBI_A15:SYS_GPA_MFPL_PA5MFP_EBI_A15@GPA_MFPL', 'ECAP1_IC1:SYS_GPA_MFPL_PA5MFP_ECAP1_IC1@GPA_MFPL'] },
	{ f: ['PA.6', 'GPIO:SYS_GPA_MFPL_PA6MFP_GPIO@GPA_MFPL', 'SC2_CD:SYS_GPA_MFPL_PA6MFP_SC2_CD@GPA_MFPL', 'I2S0_LRCK:SYS_GPA_MFPL_PA6MFP_I2S0_LRCK@GPA_MFPL', 'PWM0_1:SYS_GPA_MFPL_PA6MFP_PWM0_CH1@GPA_MFPL', 'QEI1_A:SYS_GPA_MFPL_PA6MFP_QEI1_A@GPA_MFPL', 'CAN1_TXD:SYS_GPA_MFPL_PA6MFP_CAN1_TXD@GPA_MFPL', 'EBI_A16:SYS_GPA_MFPL_PA6MFP_EBI_A16@GPA_MFPL', 'ECAP1_IC0:SYS_GPA_MFPL_PA6MFP_ECAP1_IC0@GPA_MFPL'] },
	{ f: ['PA.7', 'GPIO:SYS_GPA_MFPL_PA7MFP_GPIO@GPA_MFPL', 'SC0_CLK:SYS_GPA_MFPL_PA7MFP_SC0_CLK@GPA_MFPL', 'SPI3_SS0:SYS_GPA_MFPL_PA7MFP_SPI3_SS0@GPA_MFPL', 'PWM1_3:SYS_GPA_MFPL_PA7MFP_PWM1_CH3@GPA_MFPL', 'EPWM0_5:SYS_GPA_MFPL_PA7MFP_EPWM0_CH5@GPA_MFPL', 'EBI_A17:SYS_GPA_MFPL_PA7MFP_EBI_A17@GPA_MFPL'] },
	{ f: ['PA.8', 'GPIO:SYS_GPA_MFPH_PA8MFP_GPIO@GPA_MFPH', 'SC0_RST:SYS_GPA_MFPH_PA8MFP_SC0_RST@GPA_MFPH', 'SPI3_CLK:SYS_GPA_MFPH_PA8MFP_SPI3_CLK@GPA_MFPH', 'PWM1_2:SYS_GPA_MFPH_PA8MFP_PWM1_CH2@GPA_MFPH', 'EPWM0_4:SYS_GPA_MFPH_PA8MFP_EPWM0_CH4@GPA_MFPH', 'EBI_A18:SYS_GPA_MFPH_PA8MFP_EBI_A18@GPA_MFPH'] },
	{ f: ['PA.9', 'GPIO:SYS_GPA_MFPH_PA9MFP_GPIO@GPA_MFPH', 'SC0_PWR:SYS_GPA_MFPH_PA9MFP_SC0_PWR@GPA_MFPH', 'SPI3_MISO0:SYS_GPA_MFPH_PA9MFP_SPI3_MISO0@GPA_MFPH', 'PWM1_1:SYS_GPA_MFPH_PA9MFP_PWM1_CH1@GPA_MFPH', 'EPWM0_3:SYS_GPA_MFPH_PA9MFP_EPWM0_CH3@GPA_MFPH', 'EBI_A19:SYS_GPA_MFPH_PA9MFP_EBI_A19@GPA_MFPH'] },
	{ f: ['PA.10', 'GPIO:SYS_GPA_MFPH_PA10MFP_GPIO@GPA_MFPH', 'SC0_DAT:SYS_GPA_MFPH_PA10MFP_SC0_DAT@GPA_MFPH', 'SPI3_MOSI0:SYS_GPA_MFPH_PA10MFP_SPI3_MOSI0@GPA_MFPH', 'PWM1_0:SYS_GPA_MFPH_PA10MFP_PWM1_CH0@GPA_MFPH', 'EPWM0_2:SYS_GPA_MFPH_PA10MFP_EPWM0_CH2@GPA_MFPH', 'EBI_A20:SYS_GPA_MFPH_PA10MFP_EBI_A20@GPA_MFPH'] },
	{ f: ['PA.11', 'GPIO:SYS_GPA_MFPH_PA11MFP_GPIO@GPA_MFPH', 'UART0_RTS:SYS_GPA_MFPH_PA11MFP_UART0_RTS@GPA_MFPH', 'SPI3_MISO1:SYS_GPA_MFPH_PA11MFP_SPI3_MISO1@GPA_MFPH', 'PWM0_5:SYS_GPA_MFPH_PA11MFP_PWM0_CH5@GPA_MFPH', 'EPWM0_1:SYS_GPA_MFPH_PA11MFP_EPWM0_CH1@GPA_MFPH', 'EBI_AD0:SYS_GPA_MFPH_PA11MFP_EBI_AD0@GPA_MFPH'] },
	{ f: ['PA.12', 'GPIO:SYS_GPA_MFPH_PA12MFP_GPIO@GPA_MFPH', 'UART0_CTS:SYS_GPA_MFPH_PA12MFP_UART0_CTS@GPA_MFPH', 'SPI3_MOSI1:SYS_GPA_MFPH_PA12MFP_SPI3_MOSI1@GPA_MFPH', 'PWM0_4:SYS_GPA_MFPH_PA12MFP_PWM0_CH4@GPA_MFPH', 'EPWM0_0:SYS_GPA_MFPH_PA12MFP_EPWM0_CH0@GPA_MFPH', 'EBI_AD1:SYS_GPA_MFPH_PA12MFP_EBI_AD1@GPA_MFPH'] },
	{ f: ['PA.13', 'GPIO:SYS_GPA_MFPH_PA13MFP_GPIO@GPA_MFPH', 'UART0_RXD:SYS_GPA_MFPH_PA13MFP_UART0_RXD@GPA_MFPH', 'SC3_DAT:SYS_GPA_MFPH_PA13MFP_SC3_DAT@GPA_MFPH', 'PWM1_4:SYS_GPA_MFPH_PA13MFP_PWM1_CH4@GPA_MFPH', 'EBI_AD2:SYS_GPA_MFPH_PA13MFP_EBI_AD2@GPA_MFPH'] },
	{ f: ['PA.14', 'GPIO:SYS_GPA_MFPH_PA14MFP_GPIO@GPA_MFPH', 'UART0_TXD:SYS_GPA_MFPH_PA14MFP_UART0_TXD@GPA_MFPH', 'SC3_CLK:SYS_GPA_MFPH_PA14MFP_SC3_CLK@GPA_MFPH', 'PWM1_5:SYS_GPA_MFPH_PA14MFP_PWM1_CH5@GPA_MFPH', 'EBI_AD3:SYS_GPA_MFPH_PA14MFP_EBI_AD3@GPA_MFPH'] },
	{ f: ['PA.15', 'GPIO:SYS_GPA_MFPH_PA15MFP_GPIO@GPA_MFPH', 'SC3_PWR:SYS_GPA_MFPH_PA15MFP_SC3_PWR@GPA_MFPH', 'UART2_RTS:SYS_GPA_MFPH_PA15MFP_UART2_RTS@GPA_MFPH', 'I2C0_SCL:SYS_GPA_MFPH_PA15MFP_I2C0_SCL@GPA_MFPH', 'EBI_A21:SYS_GPA_MFPH_PA15MFP_EBI_A21@GPA_MFPH'] },

	{ f: ['PB.0', 'GPIO:SYS_GPB_MFPL_PB0MFP_GPIO@GPB_MFPL', 'USB0_OTG5V_ST:SYS_GPB_MFPL_PB0MFP_USB0_OTG5V_ST@GPB_MFPL', 'I2C4_SCL:SYS_GPB_MFPL_PB0MFP_I2C4_SCL@GPB_MFPL', 'INT1:SYS_GPB_MFPL_PB0MFP_INT1@GPB_MFPL'] },
	{ f: ['PB.1', 'GPIO:SYS_GPB_MFPL_PB1MFP_GPIO@GPB_MFPL', 'USB0_OTG5V_EN:SYS_GPB_MFPL_PB1MFP_USB0_OTG5V_EN@GPB_MFPL', 'I2C4_SDA:SYS_GPB_MFPL_PB1MFP_I2C4_SDA@GPB_MFPL', 'TM1_CNT_OUT:SYS_GPB_MFPL_PB1MFP_TM1_CNT_OUT@GPB_MFPL'] },
	{ f: ['PB.2', 'GPIO:SYS_GPB_MFPL_PB2MFP_GPIO@GPB_MFPL', 'UART1_RXD:SYS_GPB_MFPL_PB2MFP_UART1_RXD@GPB_MFPL', 'SPI2_SS0:SYS_GPB_MFPL_PB2MFP_SPI2_SS0@GPB_MFPL', 'USB1_D-:SYS_GPB_MFPL_PB2MFP_USB1_D_N@GPB_MFPL', 'EBI_AD4:SYS_GPB_MFPL_PB2MFP_EBI_AD4@GPB_MFPL'] },
	{ f: ['PB.3', 'GPIO:SYS_GPB_MFPL_PB3MFP_GPIO@GPB_MFPL', 'UART1_TXD:SYS_GPB_MFPL_PB3MFP_UART1_TXD@GPB_MFPL', 'SPI2_CLK:SYS_GPB_MFPL_PB3MFP_SPI2_CLK@GPB_MFPL', 'USB1_D+:SYS_GPB_MFPL_PB3MFP_USB1_D_P@GPB_MFPL', 'EBI_AD5:SYS_GPB_MFPL_PB3MFP_EBI_AD5@GPB_MFPL'] },
	{ f: ['PB.4', 'GPIO:SYS_GPB_MFPL_PB4MFP_GPIO@GPB_MFPL', 'UART1_RTS:SYS_GPB_MFPL_PB4MFP_UART1_RTS@GPB_MFPL', 'SPI2_MISO0:SYS_GPB_MFPL_PB4MFP_SPI2_MISO0@GPB_MFPL', 'UART4_RXD:SYS_GPB_MFPL_PB4MFP_UART4_RXD@GPB_MFPL', 'TM0_CNT_OUT:SYS_GPB_MFPL_PB4MFP_TM0_CNT_OUT@GPB_MFPL', 'EBI_AD6:SYS_GPB_MFPL_PB4MFP_EBI_AD6@GPB_MFPL'] },
	{ f: ['PB.5', 'GPIO:SYS_GPB_MFPL_PB5MFP_GPIO@GPB_MFPL', 'UART1_CTS:SYS_GPB_MFPL_PB5MFP_UART1_CTS@GPB_MFPL', 'SPI2_MOSI0:SYS_GPB_MFPL_PB5MFP_SPI2_MOSI0@GPB_MFPL', 'UART4_TXD:SYS_GPB_MFPL_PB5MFP_UART4_TXD@GPB_MFPL', 'EBI_AD7:SYS_GPB_MFPL_PB5MFP_EBI_AD7@GPB_MFPL'] },
	{ f: ['PB.6', 'GPIO:SYS_GPB_MFPL_PB6MFP_GPIO@GPB_MFPL', 'I2C2_SCL:SYS_GPB_MFPL_PB6MFP_I2C2_SCL@GPB_MFPL', 'BRAKE01:SYS_GPB_MFPL_PB6MFP_BRAKE01@GPB_MFPL', 'UART4_RTS:SYS_GPB_MFPL_PB6MFP_UART4_RTS@GPB_MFPL', 'PWM1_4:SYS_GPB_MFPL_PB6MFP_PWM1_CH4@GPB_MFPL', 'EPWM1_0:SYS_GPB_MFPL_PB6MFP_EPWM1_CH0@GPB_MFPL', 'EBI_AD8:SYS_GPB_MFPL_PB6MFP_EBI_AD8@GPB_MFPL'] },
	{ f: ['PB.7', 'GPIO:SYS_GPB_MFPL_PB7MFP_GPIO@GPB_MFPL', 'I2C2_SDA:SYS_GPB_MFPL_PB7MFP_I2C2_SDA@GPB_MFPL', 'BRAKE00:SYS_GPB_MFPL_PB7MFP_BRAKE00@GPB_MFPL', 'UART4_CTS:SYS_GPB_MFPL_PB7MFP_UART4_CTS@GPB_MFPL', 'PWM1_5:SYS_GPB_MFPL_PB7MFP_PWM1_CH5@GPB_MFPL', 'EPWM1_1:SYS_GPB_MFPL_PB7MFP_EPWM1_CH1@GPB_MFPL', 'ETM_TRACE_DATA3:SYS_GPB_MFPL_PB7MFP_ETM_TRACE_DATA3@GPB_MFPL', 'EBI_AD9:SYS_GPB_MFPL_PB7MFP_EBI_AD9@GPB_MFPL'] },
	{ f: ['PB.8', 'GPIO:SYS_GPB_MFPH_PB8MFP_GPIO@GPB_MFPH', 'UART5_CTS:SYS_GPB_MFPH_PB8MFP_UART5_CTS@GPB_MFPH', 'EPWM1_2:SYS_GPB_MFPH_PB8MFP_EPWM1_CH2@GPB_MFPH', 'ETM_TRACE_DATA2:SYS_GPB_MFPH_PB8MFP_ETM_TRACE_DATA2@GPB_MFPH', 'EBI_AD10:SYS_GPB_MFPH_PB8MFP_EBI_AD10@GPB_MFPH'] },
	{ f: ['PB.9', 'GPIO:SYS_GPB_MFPH_PB9MFP_GPIO@GPB_MFPH', 'UART5_RTS:SYS_GPB_MFPH_PB9MFP_UART5_RTS@GPB_MFPH', 'EPWM1_3:SYS_GPB_MFPH_PB9MFP_EPWM1_CH3@GPB_MFPH', 'ETM_TRACE_DATA1:SYS_GPB_MFPH_PB9MFP_ETM_TRACE_DATA1@GPB_MFPH', 'EBI_AD11:SYS_GPB_MFPH_PB9MFP_EBI_AD11@GPB_MFPH'] },
	{ f: ['PB.10', 'GPIO:SYS_GPB_MFPH_PB10MFP_GPIO@GPB_MFPH', 'UART5_TXD:SYS_GPB_MFPH_PB10MFP_UART5_TXD@GPB_MFPH', 'EPWM1_4:SYS_GPB_MFPH_PB10MFP_EPWM1_CH4@GPB_MFPH', 'ETM_TRACE_DATA0:SYS_GPB_MFPH_PB10MFP_ETM_TRACE_DATA0@GPB_MFPH', 'EBI_AD12:SYS_GPB_MFPH_PB10MFP_EBI_AD12@GPB_MFPH'] },
	{ f: ['PB.11', 'GPIO:SYS_GPB_MFPH_PB11MFP_GPIO@GPB_MFPH', 'UART5_RXD:SYS_GPB_MFPH_PB11MFP_UART5_RXD@GPB_MFPH', 'EPWM1_5:SYS_GPB_MFPH_PB11MFP_EPWM1_CH5@GPB_MFPH', 'ETM_TRACE_CLK:SYS_GPB_MFPH_PB11MFP_ETM_TRACE_CLK@GPB_MFPH', 'EBI_AD13:SYS_GPB_MFPH_PB11MFP_EBI_AD13@GPB_MFPH'] },
	{ f: ['PB.12', 'GPIO:SYS_GPB_MFPH_PB12MFP_GPIO@GPB_MFPH', 'UART4_RTS:SYS_GPB_MFPH_PB12MFP_UART4_RTS@GPB_MFPH', 'SPI2_MISO1:SYS_GPB_MFPH_PB12MFP_SPI2_MISO1@GPB_MFPH', 'CAN0_RXD:SYS_GPB_MFPH_PB12MFP_CAN0_RXD@GPB_MFPH', 'EMAC_MII_MDC:SYS_GPB_MFPH_PB12MFP_EMAC_MII_MDC@GPB_MFPH', 'EBI_AD14:SYS_GPB_MFPH_PB12MFP_EBI_AD14@GPB_MFPH'] },
	{ f: ['PB.13', 'GPIO:SYS_GPB_MFPH_PB13MFP_GPIO@GPB_MFPH', 'UART4_CTS:SYS_GPB_MFPH_PB13MFP_UART4_CTS@GPB_MFPH', 'SPI2_MOSI1:SYS_GPB_MFPH_PB13MFP_SPI2_MOSI1@GPB_MFPH', 'CAN0_TXD:SYS_GPB_MFPH_PB13MFP_CAN0_TXD@GPB_MFPH', 'EMAC_MII_MDIO:SYS_GPB_MFPH_PB13MFP_EMAC_MII_MDIO@GPB_MFPH', 'EBI_AD15:SYS_GPB_MFPH_PB13MFP_EBI_AD15@GPB_MFPH'] },
	{ f: ['PB.14', 'GPIO:SYS_GPB_MFPH_PB14MFP_GPIO@GPB_MFPH', 'I2S1_MCLK:SYS_GPB_MFPH_PB14MFP_I2S1_MCLK@GPB_MFPH', 'SC1_RST:SYS_GPB_MFPH_PB14MFP_SC1_RST@GPB_MFPH', 'BRAKE01:SYS_GPB_MFPH_PB14MFP_BRAKE01@GPB_MFPH', 'EMAC_MII_MDC:SYS_GPB_MFPH_PB14MFP_EMAC_MII_MDC@GPB_MFPH'] },
	{ f: ['PB.15', 'GPIO:SYS_GPB_MFPH_PB15MFP_GPIO@GPB_MFPH', 'I2S1_DO:SYS_GPB_MFPH_PB15MFP_I2S1_DO@GPB_MFPH', 'SC1_DAT:SYS_GPB_MFPH_PB15MFP_SC1_DAT@GPB_MFPH', 'BRAKE00:SYS_GPB_MFPH_PB15MFP_BRAKE00@GPB_MFPH', 'EMAC_MII_MDIO:SYS_GPB_MFPH_PB15MFP_EMAC_MII_MDIO@GPB_MFPH'] },

	{ f: ['PC.0', 'GPIO:SYS_GPC_MFPL_PC0MFP_GPIO@GPC_MFPL', 'I2S1_DI:SYS_GPC_MFPL_PC0MFP_I2S1_DI@GPC_MFPL', 'SC1_DAT:SYS_GPC_MFPL_PC0MFP_SC1_DAT@GPC_MFPL', 'UART4_RXD:SYS_GPC_MFPL_PC0MFP_UART4_RXD@GPC_MFPL', 'EMAC_REFCLK:SYS_GPC_MFPL_PC0MFP_EMAC_REFCLK@GPC_MFPL', 'EBI_MCLK:SYS_GPC_MFPL_PC0MFP_EBI_MCLK@GPC_MFPL', 'INT2:SYS_GPC_MFPL_PC0MFP_INT2@GPC_MFPL'] },
	{ f: ['PC.1', 'GPIO:SYS_GPC_MFPL_PC1MFP_GPIO@GPC_MFPL', 'I2S1_BCLK:SYS_GPC_MFPL_PC1MFP_I2S1_BCLK@GPC_MFPL', 'SC1_CLK:SYS_GPC_MFPL_PC1MFP_SC1_CLK@GPC_MFPL', 'UART4_TXD:SYS_GPC_MFPL_PC1MFP_UART4_TXD@GPC_MFPL', 'TM3_CNT_OUT:SYS_GPC_MFPL_PC1MFP_TM3_CNT_OUT@GPC_MFPL', 'EMAC_MII_RXERR:SYS_GPC_MFPL_PC1MFP_EMAC_MII_RXERR@GPC_MFPL', 'EBI_AD13:SYS_GPC_MFPL_PC1MFP_EBI_AD13@GPC_MFPL'] },
	{ f: ['PC.2', 'GPIO:SYS_GPC_MFPL_PC2MFP_GPIO@GPC_MFPL', 'I2S1_LRCK:SYS_GPC_MFPL_PC2MFP_I2S1_LRCK@GPC_MFPL', 'SC1_PWR:SYS_GPC_MFPL_PC2MFP_SC1_PWR@GPC_MFPL', 'UART4_RTS:SYS_GPC_MFPL_PC2MFP_UART4_RTS@GPC_MFPL', 'SPI0_SS0:SYS_GPC_MFPL_PC2MFP_SPI0_SS0@GPC_MFPL', 'EMAC_MII_RXDV:SYS_GPC_MFPL_PC2MFP_EMAC_MII_RXDV@GPC_MFPL', 'EBI_AD12:SYS_GPC_MFPL_PC2MFP_EBI_AD12@GPC_MFPL'] },
	{ f: ['PC.3', 'GPIO:SYS_GPC_MFPL_PC3MFP_GPIO@GPC_MFPL', 'I2S1_MCLK:SYS_GPC_MFPL_PC3MFP_I2S1_MCLK@GPC_MFPL', 'SC1_CD:SYS_GPC_MFPL_PC3MFP_SC1_CD@GPC_MFPL', 'UART4_CTS:SYS_GPC_MFPL_PC3MFP_UART4_CTS@GPC_MFPL', 'SPI0_MISO1:SYS_GPC_MFPL_PC3MFP_SPI0_MISO1@GPC_MFPL', 'QEI0_Z:SYS_GPC_MFPL_PC3MFP_QEI0_Z@GPC_MFPL', 'EMAC_MII_RXD1:SYS_GPC_MFPL_PC3MFP_EMAC_MII_RXD1@GPC_MFPL', 'EBI_AD11:SYS_GPC_MFPL_PC3MFP_EBI_AD11@GPC_MFPL', 'ECAP0_IC2:SYS_GPC_MFPL_PC3MFP_ECAP0_IC2@GPC_MFPL'] },
	{ f: ['PC.4', 'GPIO:SYS_GPC_MFPL_PC4MFP_GPIO@GPC_MFPL', 'I2S1_DO:SYS_GPC_MFPL_PC4MFP_I2S1_DO@GPC_MFPL', 'SC1_RST:SYS_GPC_MFPL_PC4MFP_SC1_RST@GPC_MFPL', 'SPI0_MOSI1:SYS_GPC_MFPL_PC4MFP_SPI0_MOSI1@GPC_MFPL', 'QEI0_B:SYS_GPC_MFPL_PC4MFP_QEI0_B@GPC_MFPL', 'EMAC_MII_RXD0:SYS_GPC_MFPL_PC4MFP_EMAC_MII_RXD0@GPC_MFPL', 'EBI_AD10:SYS_GPC_MFPL_PC4MFP_EBI_AD10@GPC_MFPL', 'ECAP0_IC1:SYS_GPC_MFPL_PC4MFP_ECAP0_IC1@GPC_MFPL'] },
	{ f: ['PC.5', 'GPIO:SYS_GPC_MFPL_PC5MFP_GPIO@GPC_MFPL', 'CLKO:SYS_GPC_MFPL_PC5MFP_CLK_O@GPC_MFPL', 'QEI0_A:SYS_GPC_MFPL_PC5MFP_QEI0_A@GPC_MFPL', 'EMAC_MII_RXCLK:SYS_GPC_MFPL_PC5MFP_EMAC_MII_RXCLK@GPC_MFPL', 'EBI_MCLK:SYS_GPC_MFPL_PC5MFP_EBI_MCLK@GPC_MFPL', 'ECAP0_IC0:SYS_GPC_MFPL_PC5MFP_ECAP0_IC0@GPC_MFPL'] },
	{ f: ['PC.6', 'GPIO:SYS_GPC_MFPL_PC6MFP_GPIO@GPC_MFPL', 'TM2_EXT:SYS_GPC_MFPL_PC6MFP_TM2_EXT@GPC_MFPL', 'SPI0_MISO0:SYS_GPC_MFPL_PC6MFP_SPI0_MISO0@GPC_MFPL', 'TM2_CNT_OUT:SYS_GPC_MFPL_PC6MFP_TM2_CNT_OUT@GPC_MFPL', 'EMAC_MII_TXD0:SYS_GPC_MFPL_PC6MFP_EMAC_MII_TXD0@GPC_MFPL', 'EBI_AD9:SYS_GPC_MFPL_PC6MFP_EBI_AD9@GPC_MFPL'] },
	{ f: ['PC.7', 'GPIO:SYS_GPC_MFPL_PC7MFP_GPIO@GPC_MFPL', 'TM1_EXT:SYS_GPC_MFPL_PC7MFP_TM1_EXT@GPC_MFPL', 'SPI0_MOSI0:SYS_GPC_MFPL_PC7MFP_SPI0_MOSI0@GPC_MFPL', 'EMAC_MII_TXD1:SYS_GPC_MFPL_PC7MFP_EMAC_MII_TXD1@GPC_MFPL', 'EBI_AD8:SYS_GPC_MFPL_PC7MFP_EBI_AD8@GPC_MFPL'] },
	{ f: ['PC.8', 'GPIO:SYS_GPC_MFPH_PC8MFP_GPIO@GPC_MFPH', 'TM0_EXT:SYS_GPC_MFPH_PC8MFP_TM0_EXT@GPC_MFPH', 'SPI0_CLK:SYS_GPC_MFPH_PC8MFP_SPI0_CLK@GPC_MFPH', 'EMAC_MII_TXEN:SYS_GPC_MFPH_PC8MFP_EMAC_MII_TXEN@GPC_MFPH'] },
	{ f: ['PC.9', 'GPIO:SYS_GPC_MFPH_PC9MFP_GPIO@GPC_MFPH', 'STADC:SYS_GPC_MFPH_PC9MFP_STADC@GPC_MFPH', 'UART2_CTS:SYS_GPC_MFPH_PC9MFP_UART2_CTS@GPC_MFPH', 'SC3_RST:SYS_GPC_MFPH_PC9MFP_SC3_RST@GPC_MFPH', 'I2C0_SDA:SYS_GPC_MFPH_PC9MFP_I2C0_SDA@GPC_MFPH', 'CAP_DATA1:SYS_GPC_MFPH_PC9MFP_CAP_DATA1@GPC_MFPH', 'I2C3_SCL:SYS_GPC_MFPH_PC9MFP_I2C3_SCL@GPC_MFPH', 'EBI_A22:SYS_GPC_MFPH_PC9MFP_EBI_A22@GPC_MFPH', 'SD1_DAT0:SYS_GPC_MFPH_PC9MFP_SD1_DAT0@GPC_MFPH', 'EBI_A6:SYS_GPC_MFPH_PC9MFP_EBI_A6@GPC_MFPH'] },
	{ f: ['PC.10', 'GPIO:SYS_GPC_MFPH_PC10MFP_GPIO@GPC_MFPH', 'SC3_CD:SYS_GPC_MFPH_PC10MFP_SC3_CD@GPC_MFPH', 'UART2_RXD:SYS_GPC_MFPH_PC10MFP_UART2_RXD@GPC_MFPH', 'PWM0_2:SYS_GPC_MFPH_PC10MFP_PWM0_CH2@GPC_MFPH', 'EBI_A23:SYS_GPC_MFPH_PC10MFP_EBI_A23@GPC_MFPH', 'EBI_AD2:SYS_GPC_MFPH_PC10MFP_EBI_AD2@GPC_MFPH'] },
	{ f: ['PC.11', 'GPIO:SYS_GPC_MFPH_PC11MFP_GPIO@GPC_MFPH', 'UART2_TXD:SYS_GPC_MFPH_PC11MFP_UART2_TXD@GPC_MFPH', 'PWM0_3:SYS_GPC_MFPH_PC11MFP_PWM0_CH3@GPC_MFPH', 'EBI_A24:SYS_GPC_MFPH_PC11MFP_EBI_A24@GPC_MFPH', 'EBI_AD3:SYS_GPC_MFPH_PC11MFP_EBI_AD3@GPC_MFPH'] },
	{ f: ['PC.12', 'GPIO:SYS_GPC_MFPH_PC12MFP_GPIO@GPC_MFPH', 'SPI1_SS0:SYS_GPC_MFPH_PC12MFP_SPI1_SS0@GPC_MFPH', 'SC4_CD:SYS_GPC_MFPH_PC12MFP_SC4_CD@GPC_MFPH', 'SD1_CDn:SYS_GPC_MFPH_PC12MFP_SD1_CDn@GPC_MFPH', 'CAP_DATA7:SYS_GPC_MFPH_PC12MFP_CAP_DATA7@GPC_MFPH', 'ETM_TRACE_DATA3:SYS_GPC_MFPH_PC12MFP_ETM_TRACE_DATA3@GPC_MFPH', 'EBI_A0:SYS_GPC_MFPH_PC12MFP_EBI_A0@GPC_MFPH'] },
	{ f: ['PC.13', 'GPIO:SYS_GPC_MFPH_PC13MFP_GPIO@GPC_MFPH', 'SPI1_MOSI1:SYS_GPC_MFPH_PC13MFP_SPI1_MOSI1@GPC_MFPH', 'SC4_RST:SYS_GPC_MFPH_PC13MFP_SC4_RST@GPC_MFPH', 'SD1_CMD:SYS_GPC_MFPH_PC13MFP_SD1_CMD@GPC_MFPH', 'CAP_DATA6:SYS_GPC_MFPH_PC13MFP_CAP_DATA6@GPC_MFPH', 'ETM_TRACE_DATA2:SYS_GPC_MFPH_PC13MFP_ETM_TRACE_DATA2@GPC_MFPH', 'EBI_A1:SYS_GPC_MFPH_PC13MFP_EBI_A1@GPC_MFPH'] },
	{ f: ['PC.14', 'GPIO:SYS_GPC_MFPH_PC14MFP_GPIO@GPC_MFPH', 'SPI1_MISO1:SYS_GPC_MFPH_PC14MFP_SPI1_MISO1@GPC_MFPH', 'SC4_PWR:SYS_GPC_MFPH_PC14MFP_SC4_PWR@GPC_MFPH', 'TM3_EXT:SYS_GPC_MFPH_PC14MFP_TM3_EXT@GPC_MFPH', 'SD1_CLK:SYS_GPC_MFPH_PC14MFP_SD1_CLK@GPC_MFPH', 'CAP_DATA5:SYS_GPC_MFPH_PC14MFP_CAP_DATA5@GPC_MFPH', 'ETM_TRACE_DATA1:SYS_GPC_MFPH_PC14MFP_ETM_TRACE_DATA1@GPC_MFPH', 'EBI_A2:SYS_GPC_MFPH_PC14MFP_EBI_A2@GPC_MFPH'] },
	{ f: ['PC.15', 'GPIO:SYS_GPC_MFPH_PC15MFP_GPIO@GPC_MFPH', 'SPI1_MOSI0:SYS_GPC_MFPH_PC15MFP_SPI1_MOSI0@GPC_MFPH', 'SC4_DAT:SYS_GPC_MFPH_PC15MFP_SC4_DAT@GPC_MFPH', 'SD1_DAT3:SYS_GPC_MFPH_PC15MFP_SD1_DAT3@GPC_MFPH', 'CAP_DATA4:SYS_GPC_MFPH_PC15MFP_CAP_DATA4@GPC_MFPH', 'ETM_TRACE_DATA0:SYS_GPC_MFPH_PC15MFP_ETM_TRACE_DATA0@GPC_MFPH', 'EBI_A3:SYS_GPC_MFPH_PC15MFP_EBI_A3@GPC_MFPH'] },

	{ f: ['PD.0', 'GPIO:SYS_GPD_MFPL_PD0MFP_GPIO@GPD_MFPL', 'SPI1_MISO0:SYS_GPD_MFPL_PD0MFP_SPI1_MISO0@GPD_MFPL', 'SC4_CLK:SYS_GPD_MFPL_PD0MFP_SC4_CLK@GPD_MFPL', 'SD1_DAT2:SYS_GPD_MFPL_PD0MFP_SD1_DAT2@GPD_MFPL', 'CAP_DATA3:SYS_GPD_MFPL_PD0MFP_CAP_DATA3@GPD_MFPL', 'ETM_TRACE_CLK:SYS_GPD_MFPL_PD0MFP_ETM_TRACE_CLK@GPD_MFPL', 'EBI_A4:SYS_GPD_MFPL_PD0MFP_EBI_A4@GPD_MFPL', 'INT3:SYS_GPD_MFPL_PD0MFP_INT3@GPD_MFPL'] },
	{ f: ['PD.1', 'GPIO:SYS_GPD_MFPL_PD1MFP_GPIO@GPD_MFPL', 'SPI1_CLK:SYS_GPD_MFPL_PD1MFP_SPI1_CLK@GPD_MFPL', 'TM0_CNT_OUT:SYS_GPD_MFPL_PD1MFP_TM0_CNT_OUT@GPD_MFPL', 'SD1_DAT1:SYS_GPD_MFPL_PD1MFP_SD1_DAT1@GPD_MFPL', 'CAP_DATA2:SYS_GPD_MFPL_PD1MFP_CAP_DATA2@GPD_MFPL', 'EBI_A5:SYS_GPD_MFPL_PD1MFP_EBI_A5@GPD_MFPL'] },
	{ f: ['PD.2', 'GPIO:SYS_GPD_MFPL_PD2MFP_GPIO@GPD_MFPL', 'STADC:SYS_GPD_MFPL_PD2MFP_STADC@GPD_MFPL', 'I2C3_SCL:SYS_GPD_MFPL_PD2MFP_I2C3_SCL@GPD_MFPL', 'SD1_DAT0:SYS_GPD_MFPL_PD2MFP_SD1_DAT0@GPD_MFPL', 'CAP_DATA1:SYS_GPD_MFPL_PD2MFP_CAP_DATA1@GPD_MFPL', 'EBI_A6:SYS_GPD_MFPL_PD2MFP_EBI_A6@GPD_MFPL'] },
	{ f: ['PD.3', 'GPIO:SYS_GPD_MFPL_PD3MFP_GPIO@GPD_MFPL', 'SC5_CLK:SYS_GPD_MFPL_PD3MFP_SC5_CLK@GPD_MFPL', 'I2C3_SDA:SYS_GPD_MFPL_PD3MFP_I2C3_SDA@GPD_MFPL', 'ACMP2_O:SYS_GPD_MFPL_PD3MFP_ACMP2_O@GPD_MFPL', 'SD0_CDn:SYS_GPD_MFPL_PD3MFP_SD0_CDn@GPD_MFPL', 'CAP_DATA0:SYS_GPD_MFPL_PD3MFP_CAP_DATA0@GPD_MFPL', 'JTAG_TDO:SYS_GPD_MFPL_PD3MFP_JTAG_TDO@GPD_MFPL', 'EBI_A7:SYS_GPD_MFPL_PD3MFP_EBI_A7@GPD_MFPL'] },
	{ f: ['PD.4', 'GPIO:SYS_GPD_MFPL_PD4MFP_GPIO@GPD_MFPL', 'SC5_CD:SYS_GPD_MFPL_PD4MFP_SC5_CD@GPD_MFPL', 'UART3_RXD:SYS_GPD_MFPL_PD4MFP_UART3_RXD@GPD_MFPL', 'ACMP1_O:SYS_GPD_MFPL_PD4MFP_ACMP1_O@GPD_MFPL', 'CAP_SCLK:SYS_GPD_MFPL_PD4MFP_CAP_SCLK@GPD_MFPL', 'JTAG_TDI:SYS_GPD_MFPL_PD4MFP_JTAG_TDI@GPD_MFPL', 'EBI_A8:SYS_GPD_MFPL_PD4MFP_EBI_A8@GPD_MFPL'] },
	{ f: ['PD.5', 'GPIO:SYS_GPD_MFPL_PD5MFP_GPIO@GPD_MFPL', 'SC5_RST:SYS_GPD_MFPL_PD5MFP_SC5_RST@GPD_MFPL', 'UART3_TXD:SYS_GPD_MFPL_PD5MFP_UART3_TXD@GPD_MFPL', 'CAP_VSYNC:SYS_GPD_MFPL_PD5MFP_CAP_VSYNC@GPD_MFPL', 'JTAG_nTRST:SYS_GPD_MFPL_PD5MFP_JTAG_nTRST@GPD_MFPL', 'EBI_A9:SYS_GPD_MFPL_PD5MFP_EBI_A9@GPD_MFPL'] },
	{ f: ['PD.6', 'GPIO:SYS_GPD_MFPL_PD6MFP_GPIO@GPD_MFPL', 'SC5_PWR:SYS_GPD_MFPL_PD6MFP_SC5_PWR@GPD_MFPL', 'UART3_RTS:SYS_GPD_MFPL_PD6MFP_UART3_RTS@GPD_MFPL', 'SD0_CMD:SYS_GPD_MFPL_PD6MFP_SD0_CMD@GPD_MFPL', 'CAP_HSYNC:SYS_GPD_MFPL_PD6MFP_CAP_HSYNC@GPD_MFPL', 'EBI_A10:SYS_GPD_MFPL_PD6MFP_EBI_A10@GPD_MFPL'] },
	{ f: ['PD.7', 'GPIO:SYS_GPD_MFPL_PD7MFP_GPIO@GPD_MFPL', 'SC5_DAT:SYS_GPD_MFPL_PD7MFP_SC5_DAT@GPD_MFPL', 'UART3_CTS:SYS_GPD_MFPL_PD7MFP_UART3_CTS@GPD_MFPL', 'SD0_CLK:SYS_GPD_MFPL_PD7MFP_SD0_CLK@GPD_MFPL', 'CAP_PIXCLK:SYS_GPD_MFPL_PD7MFP_CAP_PIXCLK@GPD_MFPL', 'EBI_A11:SYS_GPD_MFPL_PD7MFP_EBI_A11@GPD_MFPL'] },
	{ f: ['PD.8', 'GPIO:SYS_GPD_MFPH_PD8MFP_GPIO@GPD_MFPH', 'SPI3_MISO1:SYS_GPD_MFPH_PD8MFP_SPI3_MISO1@GPD_MFPH', 'I2C0_SCL:SYS_GPD_MFPH_PD8MFP_I2C0_SCL@GPD_MFPH'] },
	{ f: ['PD.9', 'GPIO:SYS_GPD_MFPH_PD9MFP_GPIO@GPD_MFPH', 'SPI3_MOSI1:SYS_GPD_MFPH_PD9MFP_SPI3_MOSI1@GPD_MFPH', 'I2C0_SDA:SYS_GPD_MFPH_PD9MFP_I2C0_SDA@GPD_MFPH'] },
	{ f: ['PD.10', 'GPIO:SYS_GPD_MFPH_PD10MFP_GPIO@GPD_MFPH', 'SC3_DAT:SYS_GPD_MFPH_PD10MFP_SC3_DAT@GPD_MFPH', 'I2C4_SCL:SYS_GPD_MFPH_PD10MFP_I2C4_SCL@GPD_MFPH'] },
	{ f: ['PD.11', 'GPIO:SYS_GPD_MFPH_PD11MFP_GPIO@GPD_MFPH', 'SC3_RST:SYS_GPD_MFPH_PD11MFP_SC3_RST@GPD_MFPH', 'TM3_CNT_OUT:SYS_GPD_MFPH_PD11MFP_TM3_CNT_OUT@GPD_MFPH'] },
	{ f: ['PD.12', 'GPIO:SYS_GPD_MFPH_PD12MFP_GPIO@GPD_MFPH', 'SC3_CLK:SYS_GPD_MFPH_PD12MFP_SC3_CLK@GPD_MFPH', 'I2C4_SDA:SYS_GPD_MFPH_PD12MFP_I2C4_SDA@GPD_MFPH'] },
	{ f: ['PD.13', 'GPIO:SYS_GPD_MFPH_PD13MFP_GPIO@GPD_MFPH', 'SPI1_SS0:SYS_GPD_MFPH_PD13MFP_SPI1_SS0@GPD_MFPH', 'UART5_CTS:SYS_GPD_MFPH_PD13MFP_UART5_CTS@GPD_MFPH', 'ECAP0_IC2:SYS_GPD_MFPH_PD13MFP_ECAP0_IC2@GPD_MFPH'] },
	{ f: ['PD.14', 'GPIO:SYS_GPD_MFPH_PD14MFP_GPIO@GPD_MFPH', 'SPI1_CLK:SYS_GPD_MFPH_PD14MFP_SPI1_CLK@GPD_MFPH', 'UART5_RTS:SYS_GPD_MFPH_PD14MFP_UART5_RTS@GPD_MFPH', 'ECAP0_IC1:SYS_GPD_MFPH_PD14MFP_ECAP0_IC1@GPD_MFPH'] },
	{ f: ['PD.15', 'GPIO:SYS_GPD_MFPH_PD15MFP_GPIO@GPD_MFPH', 'SPI1_MISO0:SYS_GPD_MFPH_PD15MFP_SPI1_MISO0@GPD_MFPH', 'UART5_TXD:SYS_GPD_MFPH_PD15MFP_UART5_TXD@GPD_MFPH', 'ECAP0_IC0:SYS_GPD_MFPH_PD15MFP_ECAP0_IC0@GPD_MFPH'] },

	{ f: ['PE.0', 'GPIO:SYS_GPE_MFPL_PE0MFP_GPIO@GPE_MFPL', 'ADC0_0:SYS_GPE_MFPL_PE0MFP_ADC0_0@GPE_MFPL', 'INT4:SYS_GPE_MFPL_PE0MFP_INT4@GPE_MFPL'] },
	{ f: ['PE.1', 'GPIO:SYS_GPE_MFPL_PE1MFP_GPIO@GPE_MFPL', 'ADC0_1:SYS_GPE_MFPL_PE1MFP_ADC0_1@GPE_MFPL', 'TM2_CNT_OUT:SYS_GPE_MFPL_PE1MFP_TM2_CNT_OUT@GPE_MFPL'] },
	{ f: ['PE.2', 'GPIO:SYS_GPE_MFPL_PE2MFP_GPIO@GPE_MFPL', 'ADC0_2:SYS_GPE_MFPL_PE2MFP_ADC0_2@GPE_MFPL', 'ACMP0_O:SYS_GPE_MFPL_PE2MFP_ACMP0_O@GPE_MFPL', 'SPI0_MISO0:SYS_GPE_MFPL_PE2MFP_SPI0_MISO0@GPE_MFPL'] },
	{ f: ['PE.3', 'GPIO:SYS_GPE_MFPL_PE3MFP_GPIO@GPE_MFPL', 'ADC0_3:SYS_GPE_MFPL_PE3MFP_ADC0_3@GPE_MFPL', 'ACMP0_P3:SYS_GPE_MFPL_PE3MFP_ACMP0_P3@GPE_MFPL', 'SPI0_MOSI0:SYS_GPE_MFPL_PE3MFP_SPI0_MOSI0@GPE_MFPL'] },
	{ f: ['PE.4', 'GPIO:SYS_GPE_MFPL_PE4MFP_GPIO@GPE_MFPL', 'ADC0_4:SYS_GPE_MFPL_PE4MFP_ADC0_4@GPE_MFPL', 'ACMP0_P2:SYS_GPE_MFPL_PE4MFP_ACMP0_P2@GPE_MFPL', 'SPI0_SS0:SYS_GPE_MFPL_PE4MFP_SPI0_SS0@GPE_MFPL'] },
	{ f: ['PE.5', 'GPIO:SYS_GPE_MFPL_PE5MFP_GPIO@GPE_MFPL', 'ADC0_5:SYS_GPE_MFPL_PE5MFP_ADC0_5@GPE_MFPL', 'ACMP0_P1:SYS_GPE_MFPL_PE5MFP_ACMP0_P1@GPE_MFPL', 'SPI0_CLK:SYS_GPE_MFPL_PE5MFP_SPI0_CLK@GPE_MFPL', 'SD0_CDn:SYS_GPE_MFPL_PE5MFP_SD0_CDn@GPE_MFPL'] },
	{ f: ['PE.6', 'GPIO:SYS_GPE_MFPL_PE6MFP_GPIO@GPE_MFPL', 'ADC0_6:SYS_GPE_MFPL_PE6MFP_ADC0_6@GPE_MFPL', 'ACMP0_P0:SYS_GPE_MFPL_PE6MFP_ACMP0_P0@GPE_MFPL', 'SPI0_MISO0:SYS_GPE_MFPL_PE6MFP_SPI0_MISO0@GPE_MFPL', 'SD0_CMD:SYS_GPE_MFPL_PE6MFP_SD0_CMD@GPE_MFPL', 'EBI_nWR:SYS_GPE_MFPL_PE6MFP_EBI_nWR@GPE_MFPL'] },
	{ f: ['PE.7', 'GPIO:SYS_GPE_MFPL_PE7MFP_GPIO@GPE_MFPL', 'ADC0_7:SYS_GPE_MFPL_PE7MFP_ADC0_7@GPE_MFPL', 'ACMP0_N:SYS_GPE_MFPL_PE7MFP_ACMP0_N@GPE_MFPL', 'SPI0_MOSI0:SYS_GPE_MFPL_PE7MFP_SPI0_MOSI0@GPE_MFPL', 'SD0_CLK:SYS_GPE_MFPL_PE7MFP_SD0_CLK@GPE_MFPL', 'EBI_nRD:SYS_GPE_MFPL_PE7MFP_EBI_nRD@GPE_MFPL'] },
	{ f: ['PE.8', 'GPIO:SYS_GPE_MFPH_PE8MFP_GPIO@GPE_MFPH', 'ADC0_8:SYS_GPE_MFPH_PE8MFP_ADC0_8@GPE_MFPH', 'ADC1_0:SYS_GPE_MFPH_PE8MFP_ADC1_0@GPE_MFPH', 'ACMP1_N:SYS_GPE_MFPH_PE8MFP_ACMP1_N@GPE_MFPH', 'TM1_CNT_OUT:SYS_GPE_MFPH_PE8MFP_TM1_CNT_OUT@GPE_MFPH', 'SD0_DAT3:SYS_GPE_MFPH_PE8MFP_SD0_DAT3@GPE_MFPH', 'EBI_ALE:SYS_GPE_MFPH_PE8MFP_EBI_ALE@GPE_MFPH'] },
	{ f: ['PE.9', 'GPIO:SYS_GPE_MFPH_PE9MFP_GPIO@GPE_MFPH', 'ADC0_9:SYS_GPE_MFPH_PE9MFP_ADC0_9@GPE_MFPH', 'ADC1_1:SYS_GPE_MFPH_PE9MFP_ADC1_1@GPE_MFPH', 'ACMP1_P0:SYS_GPE_MFPH_PE9MFP_ACMP1_P0@GPE_MFPH', 'SD0_DAT2:SYS_GPE_MFPH_PE9MFP_SD0_DAT2@GPE_MFPH', 'EBI_nWRH:SYS_GPE_MFPH_PE9MFP_EBI_nWRH@GPE_MFPH'] },
	{ f: ['PE.10', 'GPIO:SYS_GPE_MFPH_PE10MFP_GPIO@GPE_MFPH', 'ADC0_10:SYS_GPE_MFPH_PE10MFP_ADC0_10@GPE_MFPH', 'ADC1_2:SYS_GPE_MFPH_PE10MFP_ADC1_2@GPE_MFPH', 'ACMP1_P1:SYS_GPE_MFPH_PE10MFP_ACMP1_P1@GPE_MFPH', 'SPI0_MISO1:SYS_GPE_MFPH_PE10MFP_SPI0_MISO1@GPE_MFPH', 'SD0_DAT1:SYS_GPE_MFPH_PE10MFP_SD0_DAT1@GPE_MFPH', 'EBI_nWRL:SYS_GPE_MFPH_PE10MFP_EBI_nWRL@GPE_MFPH'] },
	{ f: ['PE.11', 'GPIO:SYS_GPE_MFPH_PE11MFP_GPIO@GPE_MFPH', 'ADC0_11:SYS_GPE_MFPH_PE11MFP_ADC0_11@GPE_MFPH', 'ADC1_3:SYS_GPE_MFPH_PE11MFP_ADC1_3@GPE_MFPH', 'ACMP1_P2:SYS_GPE_MFPH_PE11MFP_ACMP1_P2@GPE_MFPH', 'SPI0_MOSI1:SYS_GPE_MFPH_PE11MFP_SPI0_MOSI1@GPE_MFPH', 'SD0_DAT0:SYS_GPE_MFPH_PE11MFP_SD0_DAT0@GPE_MFPH', 'ACMP2_P3:SYS_GPE_MFPH_PE11MFP_ACMP2_P3@GPE_MFPH', 'EBI_nCS0:SYS_GPE_MFPH_PE11MFP_EBI_nCS0@GPE_MFPH'] },
	{ f: ['PE.12', 'GPIO:SYS_GPE_MFPH_PE12MFP_GPIO@GPE_MFPH', 'ADC1_4:SYS_GPE_MFPH_PE12MFP_ADC1_4@GPE_MFPH', 'ACMP1_P3:SYS_GPE_MFPH_PE12MFP_ACMP1_P3@GPE_MFPH', 'ACMP2_P2:SYS_GPE_MFPH_PE12MFP_ACMP2_P2@GPE_MFPH', 'EBI_nCS1:SYS_GPE_MFPH_PE12MFP_EBI_nCS1@GPE_MFPH'] },
	{ f: ['PE.13', 'GPIO:SYS_GPE_MFPH_PE13MFP_GPIO@GPE_MFPH', 'ADC1_5:SYS_GPE_MFPH_PE13MFP_ADC1_5@GPE_MFPH', 'ACMP2_P1:SYS_GPE_MFPH_PE13MFP_ACMP2_P1@GPE_MFPH', 'EBI_nCS2:SYS_GPE_MFPH_PE13MFP_EBI_nCS2@GPE_MFPH'] },
	{ f: ['PE.14', 'GPIO:SYS_GPE_MFPH_PE14MFP_GPIO@GPE_MFPH', 'ADC1_6:SYS_GPE_MFPH_PE14MFP_ADC1_6@GPE_MFPH', 'ACMP2_P0:SYS_GPE_MFPH_PE14MFP_ACMP2_P0@GPE_MFPH', 'EBI_nCS3:SYS_GPE_MFPH_PE14MFP_EBI_nCS3@GPE_MFPH'] },
	{ f: ['PE.15', 'GPIO:SYS_GPE_MFPH_PE15MFP_GPIO@GPE_MFPH', 'ADC1_7:SYS_GPE_MFPH_PE15MFP_ADC1_7@GPE_MFPH', 'ACMP2_N:SYS_GPE_MFPH_PE15MFP_ACMP2_N@GPE_MFPH'] },

	{ f: ['PF.0', 'GPIO:SYS_GPF_MFPL_PF0MFP_GPIO@GPF_MFPL', 'SPI1_MOSI0:SYS_GPF_MFPL_PF0MFP_SPI1_MOSI0@GPF_MFPL', 'UART5_RXD:SYS_GPF_MFPL_PF0MFP_UART5_RXD@GPF_MFPL', 'INT5:SYS_GPF_MFPL_PF0MFP_INT5@GPF_MFPL'] },
	{ f: ['PF.1', 'GPIO:SYS_GPF_MFPL_PF1MFP_GPIO@GPF_MFPL', 'SPI2_MOSI1:SYS_GPF_MFPL_PF1MFP_SPI2_MOSI1@GPF_MFPL'] },
	{ f: ['PF.2', 'GPIO:SYS_GPF_MFPL_PF2MFP_GPIO@GPF_MFPL', 'SPI3_SS0:SYS_GPF_MFPL_PF2MFP_SPI3_SS0@GPF_MFPL', 'SD0_DAT3:SYS_GPF_MFPL_PF2MFP_SD0_DAT3@GPF_MFPL', 'EMAC_MII_RXD3:SYS_GPF_MFPL_PF2MFP_EMAC_MII_RXD3@GPF_MFPL'] },
	{ f: ['PF.3', 'GPIO:SYS_GPF_MFPL_PF3MFP_GPIO@GPF_MFPL', 'SPI3_CLK:SYS_GPF_MFPL_PF3MFP_SPI3_CLK@GPF_MFPL', 'SD0_DAT2:SYS_GPF_MFPL_PF3MFP_SD0_DAT2@GPF_MFPL', 'EMAC_MII_RXD2:SYS_GPF_MFPL_PF3MFP_EMAC_MII_RXD2@GPF_MFPL'] },
	{ f: ['PF.4', 'GPIO:SYS_GPF_MFPL_PF4MFP_GPIO@GPF_MFPL', 'SPI3_MISO0:SYS_GPF_MFPL_PF4MFP_SPI3_MISO0@GPF_MFPL', 'SD0_DAT1:SYS_GPF_MFPL_PF4MFP_SD0_DAT1@GPF_MFPL', 'EMAC_MII_COL0:SYS_GPF_MFPL_PF4MFP_EMAC_MII_COL0@GPF_MFPL'] },
	{ f: ['PF.5', 'GPIO:SYS_GPF_MFPL_PF5MFP_GPIO@GPF_MFPL', 'SPI3_MOSI0:SYS_GPF_MFPL_PF5MFP_SPI3_MOSI0@GPF_MFPL', 'SD0_DAT0:SYS_GPF_MFPL_PF5MFP_SD0_DAT0@GPF_MFPL', 'EMAC_MII_CRS:SYS_GPF_MFPL_PF5MFP_EMAC_MII_CRS@GPF_MFPL'] },
	{ f: ['PF.6', 'GPIO:SYS_GPF_MFPL_PF6MFP_GPIO@GPF_MFPL', 'UART2_RXD:SYS_GPF_MFPL_PF6MFP_UART2_RXD@GPF_MFPL', 'SD0_CDn:SYS_GPF_MFPL_PF6MFP_SD0_CDn@GPF_MFPL', 'EMAC_MII_TXCLK:SYS_GPF_MFPL_PF6MFP_EMAC_MII_TXCLK@GPF_MFPL'] },
	{ f: ['PF.7', 'GPIO:SYS_GPF_MFPL_PF7MFP_GPIO@GPF_MFPL', 'UART2_TXD:SYS_GPF_MFPL_PF7MFP_UART2_TXD@GPF_MFPL', 'SD0_CMD:SYS_GPF_MFPL_PF7MFP_SD0_CMD@GPF_MFPL', 'EMAC_MII_TXD3:SYS_GPF_MFPL_PF7MFP_EMAC_MII_TXD3@GPF_MFPL'] },
	{ f: ['PF.8', 'GPIO:SYS_GPF_MFPH_PF8MFP_GPIO@GPF_MFPH', 'UART2_RTS:SYS_GPF_MFPH_PF8MFP_UART2_RTS@GPF_MFPH', 'SD0_CLK:SYS_GPF_MFPH_PF8MFP_SD0_CLK@GPF_MFPH', 'EMAC_MII_TXD2:SYS_GPF_MFPH_PF8MFP_EMAC_MII_TXD2@GPF_MFPH'] },
	{ f: ['PF.9', 'GPIO:SYS_GPF_MFPH_PF9MFP_GPIO@GPF_MFPH', 'OPA0_P:SYS_GPF_MFPH_PF9MFP_OPA0_IN_P@GPF_MFPH', 'PWM0_0:SYS_GPF_MFPH_PF9MFP_PWM0_CH0@GPF_MFPH'] },
	{ f: ['PF.10', 'GPIO:SYS_GPF_MFPH_PF10MFP_GPIO@GPF_MFPH', 'OPA0_N:SYS_GPF_MFPH_PF10MFP_OPA0_IN_N@GPF_MFPH', 'PWM0_1:SYS_GPF_MFPH_PF10MFP_PWM0_CH1@GPF_MFPH'] },
	{ f: ['PF.11', 'GPIO:SYS_GPF_MFPH_PF11MFP_GPIO@GPF_MFPH', 'OPA0_O:SYS_GPF_MFPH_PF11MFP_OPA0_O@GPF_MFPH', 'UART1_RTS:SYS_GPF_MFPH_PF11MFP_UART1_RTS@GPF_MFPH'] },
	{ f: ['PF.12', 'GPIO:SYS_GPF_MFPH_PF12MFP_GPIO@GPF_MFPH', 'OPA1_P:SYS_GPF_MFPH_PF12MFP_OPA1_IN_P@GPF_MFPH', 'UART1_CTS:SYS_GPF_MFPH_PF12MFP_UART1_CTS@GPF_MFPH'] },
	{ f: ['PF.13', 'GPIO:SYS_GPF_MFPH_PF13MFP_GPIO@GPF_MFPH', 'OPA1_N:SYS_GPF_MFPH_PF13MFP_OPA1_IN_N@GPF_MFPH', 'UART1_TXD:SYS_GPF_MFPH_PF13MFP_UART1_TXD@GPF_MFPH'] },
	{ f: ['PF.14', 'GPIO:SYS_GPF_MFPH_PF14MFP_GPIO@GPF_MFPH', 'OPA1_O:SYS_GPF_MFPH_PF14MFP_OPA1_O@GPF_MFPH', 'UART1_RXD:SYS_GPF_MFPH_PF14MFP_UART1_RXD@GPF_MFPH'] },
	{ f: ['PF.15', 'GPIO:SYS_GPF_MFPH_PF15MFP_GPIO@GPF_MFPH', 'UART0_RTS:SYS_GPF_MFPH_PF15MFP_UART0_RTS@GPF_MFPH'] },

	{ f: ['PG.0', 'GPIO:SYS_GPG_MFPL_PG0MFP_GPIO@GPG_MFPL', 'UART0_CTS:SYS_GPG_MFPL_PG0MFP_UART0_CTS@GPG_MFPL', 'INT6:SYS_GPG_MFPL_PG0MFP_INT6@GPG_MFPL'] },
	{ f: ['PG.1', 'GPIO:SYS_GPG_MFPL_PG1MFP_GPIO@GPG_MFPL', 'UART0_RXD:SYS_GPG_MFPL_PG1MFP_UART0_RXD@GPG_MFPL'] },
	{ f: ['PG.2', 'GPIO:SYS_GPG_MFPL_PG2MFP_GPIO@GPG_MFPL', 'UART0_TXD:SYS_GPG_MFPL_PG2MFP_UART0_TXD@GPG_MFPL'] },
	{ f: ['PG.3', 'GPIO:SYS_GPG_MFPL_PG3MFP_GPIO@GPG_MFPL', 'PS2_CLK:SYS_GPG_MFPL_PG3MFP_PS2_CLK@GPG_MFPL', 'I2S1_DO:SYS_GPG_MFPL_PG3MFP_I2S1_DO@GPG_MFPL', 'SC1_RST:SYS_GPG_MFPL_PG3MFP_SC1_RST@GPG_MFPL'] },
	{ f: ['PG.4', 'GPIO:SYS_GPG_MFPL_PG4MFP_GPIO@GPG_MFPL', 'PS2_DAT:SYS_GPG_MFPL_PG4MFP_PS2_DAT@GPG_MFPL', 'I2S1_DI:SYS_GPG_MFPL_PG4MFP_I2S1_DI@GPG_MFPL', 'SC1_PWR:SYS_GPG_MFPL_PG4MFP_SC1_PWR@GPG_MFPL'] },
	{ f: ['PG.5', 'GPIO:SYS_GPG_MFPL_PG5MFP_GPIO@GPG_MFPL', 'I2S1_BCLK:SYS_GPG_MFPL_PG5MFP_I2S1_BCLK@GPG_MFPL', 'SC1_DAT:SYS_GPG_MFPL_PG5MFP_SC1_DAT@GPG_MFPL'] },
	{ f: ['PG.6', 'GPIO:SYS_GPG_MFPL_PG6MFP_GPIO@GPG_MFPL', 'I2S1_LRCK:SYS_GPG_MFPL_PG6MFP_I2S1_LRCK@GPG_MFPL', 'SC1_CLK:SYS_GPG_MFPL_PG6MFP_SC1_CLK@GPG_MFPL'] },
	{ f: ['PG.7', 'GPIO:SYS_GPG_MFPL_PG7MFP_GPIO@GPG_MFPL', 'SPI2_MISO0:SYS_GPG_MFPL_PG7MFP_SPI2_MISO0@GPG_MFPL', 'I2S1_MCLK:SYS_GPG_MFPL_PG7MFP_I2S1_MCLK@GPG_MFPL', 'SC1_CD:SYS_GPG_MFPL_PG7MFP_SC1_CD@GPG_MFPL', 'SC3_RST:SYS_GPG_MFPL_PG7MFP_SC3_RST@GPG_MFPL'] },
	{ f: ['PG.8', 'GPIO:SYS_GPG_MFPH_PG8MFP_GPIO@GPG_MFPH', 'SPI2_MOSI0:SYS_GPG_MFPH_PG8MFP_SPI2_MOSI0@GPG_MFPH', 'I2S1_DO:SYS_GPG_MFPH_PG8MFP_I2S1_DO@GPG_MFPH', 'UART4_RTS:SYS_GPG_MFPH_PG8MFP_UART4_RTS@GPG_MFPH', 'SC3_DAT:SYS_GPG_MFPH_PG8MFP_SC3_DAT@GPG_MFPH'] },
	{ f: ['PG.9', 'GPIO:SYS_GPG_MFPH_PG9MFP_GPIO@GPG_MFPH', 'SPI2_CLK:SYS_GPG_MFPH_PG9MFP_SPI2_CLK@GPG_MFPH', 'I2S1_DI:SYS_GPG_MFPH_PG9MFP_I2S1_DI@GPG_MFPH', 'UART4_CTS:SYS_GPG_MFPH_PG9MFP_UART4_CTS@GPG_MFPH', 'SC3_CLK:SYS_GPG_MFPH_PG9MFP_SC3_CLK@GPG_MFPH'] },
	{ f: ['PG.10', 'GPIO:SYS_GPG_MFPH_PG10MFP_GPIO@GPG_MFPH', 'ICE_CLK:SYS_GPG_MFPH_PG10MFP_ICE_CLK@GPG_MFPH', 'JTAG_TCK:SYS_GPG_MFPH_PG10MFP_JTAG_TCLK@GPG_MFPH'] },
	{ f: ['PG.11', 'GPIO:SYS_GPG_MFPH_PG11MFP_GPIO@GPG_MFPH', 'ICE_DAT:SYS_GPG_MFPH_PG11MFP_ICE_DAT@GPG_MFPH', 'JTAG_TMS:SYS_GPG_MFPH_PG11MFP_JTAG_TMS@GPG_MFPH'] },
	{ f: ['PG.12', 'GPIO:SYS_GPG_MFPH_PG12MFP_GPIO@GPG_MFPH', 'XT1_OUT:SYS_GPG_MFPH_PG12MFP_XT1_OUT@GPG_MFPH'] },
	{ f: ['PG.13', 'GPIO:SYS_GPG_MFPH_PG13MFP_GPIO@GPG_MFPH', 'XT1_IN:SYS_GPG_MFPH_PG13MFP_XT1_IN@GPG_MFPH'] },
	{ f: ['PG.14', 'GPIO:SYS_GPG_MFPH_PG14MFP_GPIO@GPG_MFPH', 'X32K_OUT:SYS_GPG_MFPH_PG14MFP_X32K_OUT@GPG_MFPH', 'I2C1_SDA:SYS_GPG_MFPH_PG14MFP_I2C1_SDA@GPG_MFPH'] },
	{ f: ['PG.15', 'GPIO:SYS_GPG_MFPH_PG15MFP_GPIO@GPG_MFPH', 'X32K_IN:SYS_GPG_MFPH_PG15MFP_X32K_IN@GPG_MFPH', 'I2C1_SCL:SYS_GPG_MFPH_PG15MFP_I2C1_SCL@GPG_MFPH'] },

	{ f: ['PH.0', 'GPIO:SYS_GPH_MFPL_PH0MFP_GPIO@GPH_MFPL', 'I2C1_SCL:SYS_GPH_MFPL_PH0MFP_I2C1_SCL@GPH_MFPL', 'UART4_RXD:SYS_GPH_MFPL_PH0MFP_UART4_RXD@GPH_MFPL', 'CAN1_RXD:SYS_GPH_MFPL_PH0MFP_CAN1_RXD@GPH_MFPL', 'INT7:SYS_GPH_MFPL_PH0MFP_INT7@GPH_MFPL'] },
	{ f: ['PH.1', 'GPIO:SYS_GPH_MFPL_PH1MFP_GPIO@GPH_MFPL', 'UART4_TXD:SYS_GPH_MFPL_PH1MFP_UART4_TXD@GPH_MFPL', 'I2C1_SDA:SYS_GPH_MFPL_PH1MFP_I2C1_SDA@GPH_MFPL', 'CAN1_TXD:SYS_GPH_MFPL_PH1MFP_CAN1_TXD@GPH_MFPL'] },
	{ f: ['PH.2', 'GPIO:SYS_GPH_MFPL_PH2MFP_GPIO@GPH_MFPL', 'UART2_CTS:SYS_GPH_MFPL_PH2MFP_UART2_CTS@GPH_MFPL'] },
	{ f: ['PH.3', 'GPIO:SYS_GPH_MFPL_PH3MFP_GPIO@GPH_MFPL', 'I2C3_SCL:SYS_GPH_MFPL_PH3MFP_I2C3_SCL@GPH_MFPL'] },
	{ f: ['PH.4', 'GPIO:SYS_GPH_MFPL_PH4MFP_GPIO@GPH_MFPL', 'I2C3_SDA:SYS_GPH_MFPL_PH4MFP_I2C3_SDA@GPH_MFPL'] },
	{ f: ['PH.5', 'GPIO:SYS_GPH_MFPL_PH5MFP_GPIO@GPH_MFPL', 'SPI2_SS0:SYS_GPH_MFPL_PH5MFP_SPI2_SS0@GPH_MFPL'] },
	{ f: ['PH.6', 'GPIO:SYS_GPH_MFPL_PH6MFP_GPIO@GPH_MFPL', 'SPI2_CLK:SYS_GPH_MFPL_PH6MFP_SPI2_CLK@GPH_MFPL'] },
	{ f: ['PH.7', 'GPIO:SYS_GPH_MFPL_PH7MFP_GPIO@GPH_MFPL', 'SPI2_MISO0:SYS_GPH_MFPL_PH7MFP_SPI2_MISO0@GPH_MFPL'] },
	{ f: ['PH.8', 'GPIO:SYS_GPH_MFPH_PH8MFP_GPIO@GPH_MFPH', 'SPI2_MOSI0:SYS_GPH_MFPH_PH8MFP_SPI2_MOSI0@GPH_MFPH'] },
	{ f: ['PH.9', 'GPIO:SYS_GPH_MFPH_PH9MFP_GPIO@GPH_MFPH', 'SPI2_MISO1:SYS_GPH_MFPH_PH9MFP_SPI2_MISO1@GPH_MFPH'] },
	{ f: ['PH.10', 'GPIO:SYS_GPH_MFPH_PH10MFP_GPIO@GPH_MFPH', 'SPI2_MOSI1:SYS_GPH_MFPH_PH10MFP_SPI2_MOSI1@GPH_MFPH'] },
	{ f: ['PH.11', 'GPIO:SYS_GPH_MFPH_PH11MFP_GPIO@GPH_MFPH', 'UART3_RXD:SYS_GPH_MFPH_PH11MFP_UART3_RXD@GPH_MFPH'] },
	{ f: ['PH.12', 'GPIO:SYS_GPH_MFPH_PH12MFP_GPIO@GPH_MFPH', 'UART3_TXD:SYS_GPH_MFPH_PH12MFP_UART3_TXD@GPH_MFPH'] },
	{ f: ['PH.13', 'GPIO:SYS_GPH_MFPH_PH13MFP_GPIO@GPH_MFPH', 'UART3_RTS:SYS_GPH_MFPH_PH13MFP_UART3_RTS@GPH_MFPH'] },
	{ f: ['PH.14', 'GPIO:SYS_GPH_MFPH_PH14MFP_GPIO@GPH_MFPH', 'UART3_CTS:SYS_GPH_MFPH_PH14MFP_UART3_CTS@GPH_MFPH'] },
	{ f: ['PH.15', 'GPIO:SYS_GPH_MFPH_PH15MFP_GPIO@GPH_MFPH', 'SC5_CLK:SYS_GPH_MFPH_PH15MFP_SC5_CLK@GPH_MFPH'] },

	{ f: ['PI.0', 'GPIO:SYS_GPI_MFPL_PI0MFP_GPIO@GPI_MFPL', 'SC5_RST:SYS_GPI_MFPL_PI0MFP_SC5_RST@GPI_MFPL'] },
	{ f: ['PI.1', 'GPIO:SYS_GPI_MFPL_PI1MFP_GPIO@GPI_MFPL', 'SC5_PWR:SYS_GPI_MFPL_PI1MFP_SC5_PWR@GPI_MFPL'] },
	{ f: ['PI.2', 'GPIO:SYS_GPI_MFPL_PI2MFP_GPIO@GPI_MFPL', 'SC5_DAT:SYS_GPI_MFPL_PI2MFP_SC5_DAT@GPI_MFPL'] },
	{ f: ['PI.3', 'GPIO:SYS_GPI_MFPL_PI3MFP_GPIO@GPI_MFPL', 'SPI3_SS0:SYS_GPI_MFPL_PI3MFP_SPI3_SS0@GPI_MFPL'] },
	{ f: ['PI.4', 'GPIO:SYS_GPI_MFPL_PI4MFP_GPIO@GPI_MFPL', 'SPI3_CLK:SYS_GPI_MFPL_PI4MFP_SPI3_CLK@GPI_MFPL'] },
	{ f: ['PI.5', 'GPIO:SYS_GPI_MFPL_PI5MFP_GPIO@GPI_MFPL', 'SPI3_MISO0:SYS_GPI_MFPL_PI5MFP_SPI3_MISO0@GPI_MFPL'] },
	{ f: ['PI.6', 'GPIO:SYS_GPI_MFPL_PI6MFP_GPIO@GPI_MFPL', 'SPI3_MOSI0:SYS_GPI_MFPL_PI6MFP_SPI3_MOSI0@GPI_MFPL'] },
	{ f: ['PI.7', 'GPIO:SYS_GPI_MFPL_PI7MFP_GPIO@GPI_MFPL', 'I2C2_SCL:SYS_GPI_MFPL_PI7MFP_I2C2_SCL@GPI_MFPL', 'SPI3_MISO1:SYS_GPI_MFPL_PI7MFP_SPI3_MISO1@GPI_MFPL'] },
	{ f: ['PI.8', 'GPIO:SYS_GPI_MFPH_PI8MFP_GPIO@GPI_MFPH', 'I2C2_SDA:SYS_GPI_MFPH_PI8MFP_I2C2_SDA@GPI_MFPH', 'SPI3_MOSI1:SYS_GPI_MFPH_PI8MFP_SPI3_MOSI1@GPI_MFPH'] },
	{ f: ['PI.9', 'GPIO:SYS_GPI_MFPH_PI9MFP_GPIO@GPI_MFPH', 'I2C4_SCL:SYS_GPI_MFPH_PI9MFP_I2C4_SCL@GPI_MFPH'] },
	{ f: ['PI.10', 'GPIO:SYS_GPI_MFPH_PI10MFP_GPIO@GPI_MFPH'] },
	{ f: ['PI.11', 'GPIO:SYS_GPI_MFPH_PI11MFP_GPIO@GPI_MFPH', 'SPI2_SS0:SYS_GPI_MFPH_PI11MFP_SPI2_SS0@GPI_MFPH', 'I2S1_BCLK:SYS_GPI_MFPH_PI11MFP_I2S1_BCLK@GPI_MFPH', 'I2C4_SCL:SYS_GPI_MFPH_PI11MFP_I2C4_SCL@GPI_MFPH', 'SC3_PWR:SYS_GPI_MFPH_PI11MFP_SC3_PWR@GPI_MFPH'] },
	{ f: ['PI.12', 'GPIO:SYS_GPI_MFPH_PI12MFP_GPIO@GPI_MFPH', 'SPI2_MISO1:SYS_GPI_MFPH_PI12MFP_SPI2_MISO1@GPI_MFPH', 'I2S1_LRCK:SYS_GPI_MFPH_PI12MFP_I2S1_LRCK@GPI_MFPH', 'I2C4_SDA:SYS_GPI_MFPH_PI12MFP_I2C4_SDA@GPI_MFPH', 'SC3_CD:SYS_GPI_MFPH_PI12MFP_SC3_CD@GPI_MFPH'] },
	{ f: ['PI.13', 'GPIO:SYS_GPI_MFPH_PI13MFP_GPIO@GPI_MFPH'] },
	{ f: ['PI.14', 'GPIO:SYS_GPI_MFPH_PI14MFP_GPIO@GPI_MFPH'] },
	{ f: ['PI.15', 'GPIO:SYS_GPI_MFPH_PI15MFP_GPIO@GPI_MFPH'] }
];

NUTOOL_PIN.g_cfg_gpiosDescriptions = [
	'ACMP0_N:Analog comparator0 negative input pin',
	'ACMP0_O:Analog comparator0 output',
	'ACMP0_P0:Analog comparator0 positive input pin',
	'ACMP0_P1:Analog comparator0 positive input pin',
	'ACMP0_P2:Analog comparator0 positive input pin',
	'ACMP0_P3:Analog comparator0 positive input pin',

	'ACMP1_N:Analog comparator1 negative input pin',
	'ACMP1_O:Analog comparator1 output',
	'ACMP1_P0:Analog comparator1 positive input pin',
	'ACMP1_P1:Analog comparator1 positive input pin',
	'ACMP1_P2:Analog comparator1 positive input pin',
	'ACMP1_P3:Analog comparator1 positive input pin',

	'ACMP2_N:Analog comparator2 negative input pin',
	'ACMP2_O:Analog comparator2 output',
	'ACMP2_P0:Analog comparator2 positive input pin',
	'ACMP2_P1:Analog comparator2 positive input pin',
	'ACMP2_P2:Analog comparator2 positive input pin',
	'ACMP2_P3:Analog comparator2 positive input pin',

	'ADC0_0:ADC0 analog input',
	'ADC0_1:ADC0 analog input',
	'ADC0_2:ADC0 analog input',
	'ADC0_3:ADC0 analog input',
	'ADC0_4:ADC0 analog input',
	'ADC0_5:ADC0 analog input',
	'ADC0_6:ADC0 analog input',
	'ADC0_7:ADC0 analog input',
	'ADC0_8:ADC0 analog input',
	'ADC0_9:ADC0 analog input',
	'ADC0_10:ADC0 analog input',
	'ADC0_11:ADC0 analog input',

	'ADC1_0:ADC1 analog input',
	'ADC1_1:ADC1 analog input',
	'ADC1_2:ADC1 analog input',
	'ADC1_3:ADC1 analog input',
	'ADC1_4:ADC1 analog input',
	'ADC1_5:ADC1 analog input',
	'ADC1_6:ADC1 analog input',
	'ADC1_7:ADC1 analog input',

	'AVDD:Power supply for internal analog circuit',
	'AVSS:Ground pin for digital circuit',

	'BRAKE00:Brake input pin 0 of EPWMB',
	'BRAKE01:Brake input pin 1 of EPWMB',
	'BRAKE10:Brake input pin 0 of EPWMA',
	'BRAKE11:Brake input pin 1 of EPWMA',

	'CAN0_RXD:CAN bus receiver0 input',
	'CAN0_TXD:CAN bus transmitter0 input',

	'CAN1_RXD:CAN bus receiver1 input',
	'CAN1_TXD:CAN bus transmitter1 input',

	'CAP_DATA0:Image data input bus bit 0',
	'CAP_DATA1:Image data input bus bit 1',
	'CAP_DATA2:Image data input bus bit 2',
	'CAP_DATA3:Image data input bus bit 3',
	'CAP_DATA4:Image data input bus bit 4',
	'CAP_DATA5:Image data input bus bit 5',
	'CAP_DATA6:Image data input bus bit 6',
	'CAP_DATA7:Image data input bus bit 7',
	'CAP_HSYNC:Image capture interface HSYNC input pin',
	'CAP_PIXCLK:Image capture interface pix clock input pin',
	'CAP_SCLK:Image capture interface sensor clock pin',
	'CAP_SFIELD:Video input interface SFIELD input pin',
	'CAP_VSYNC:Image capture interface VSYNC input pin',

	'CLKO:Clock Output Pin',

	'EBI_A0:EBI address bus bit0',
	'EBI_A1:EBI address bus bit1',
	'EBI_A2:EBI address bus bit2',
	'EBI_A3:EBI address bus bit3',
	'EBI_A4:EBI address bus bit4',
	'EBI_A5:EBI address bus bit5',
	'EBI_A6:EBI address bus bit6',
	'EBI_A7:EBI address bus bit7',
	'EBI_A8:EBI address bus bit8',
	'EBI_A9:EBI address bus bit9',
	'EBI_A10:EBI address bus bit10',
	'EBI_A11:EBI address bus bit11',
	'EBI_A12:EBI address bus bit12',
	'EBI_A13:EBI address bus bit13',
	'EBI_A14:EBI address bus bit14',
	'EBI_A15:EBI address bus bit15',
	'EBI_A16:EBI address bus bit16',
	'EBI_A17:EBI address bus bit17',
	'EBI_A18:EBI address bus bit18',
	'EBI_A19:EBI address bus bit19',
	'EBI_A20:EBI address bus bit20',
	'EBI_A21:EBI address bus bit21',
	'EBI_A22:EBI address bus bit22',
	'EBI_A23:EBI address bus bit23',
	'EBI_A24:EBI address bus bit24',

	'EBI_AD0:EBI address/data bus bit 0',
	'EBI_AD1:EBI address/data bus bit 1',
	'EBI_AD2:EBI address/data bus bit 2',
	'EBI_AD3:EBI address/data bus bit 3',
	'EBI_AD4:EBI address/data bus bit 4',
	'EBI_AD5:EBI address/data bus bit 5',
	'EBI_AD6:EBI address/data bus bit 6',
	'EBI_AD7:EBI address/data bus bit 7',
	'EBI_AD8:EBI address/data bus bit 8',
	'EBI_AD9:EBI address/data bus bit 9',
	'EBI_AD10:EBI address/data bus bit 10',
	'EBI_AD11:EBI address/data bus bit 11',
	'EBI_AD12:EBI address/data bus bit 12',
	'EBI_AD13:EBI address/data bus bit 13',
	'EBI_AD14:EBI address/data bus bit 14',
	'EBI_AD15:EBI address/data bus bit 15',
	'EBI_ALE:EBI address latch enable output pin',
	'EBI_MCLK:EBI interface clock output pin',
	'EBI_nCS0:EBI chip select 0 enable output pin',
	'EBI_nCS1:EBI chip select 1 enable output pin',
	'EBI_nCS2:EBI chip select 2 enable output pin',
	'EBI_nCS3:EBI chip select 3 enable output pin',
	'EBI_nRD:EBI read enable output pin',
	'EBI_nWR:EBI write enable output pin',
	'EBI_nWRH:EBI write enable output pin',
	'EBI_nWRL:EBI write enable output pin',

	'ECAP0_IC0:Input 0 of enhanced capture unit 0',
	'ECAP0_IC1:Input 1 of enhanced capture unit 0',
	'ECAP0_IC2:Input 2 of enhanced capture unit 0',
	'ECAP1_IC0:Input 0 of enhanced capture unit 1',
	'ECAP1_IC1:Input 1 of enhanced capture unit 1',
	'ECAP1_IC2:Input 2 of enhanced capture unit 1',

	'EMAC_MII_COL0:MII Collision Detect Input Pin',
	'EMAC_MII_CRS:MII Carrier Sense Input Pin',
	'EMAC_MII_MDC:MII/RMII Management Data Clock',
	'EMAC_MII_MDIO:MII/RMII Management Data I/O',
	'EMAC_MII_RXCLK:MII Receive Clock Input',
	'EMAC_MII_RXD0:MII/RMII Receive Data Bus Bit 0',
	'EMAC_MII_RXD1:MII/RMII Receive Data Bus Bit 1',
	'EMAC_MII_RXD2:MII Receive Data Bus Bit 2',
	'EMAC_MII_RXD3:MII Receive Data Bus Bit 3',
	'EMAC_MII_RXDV:MII Receive Data Valid / RMII CRS_DV Input',
	'EMAC_MII_RXERR:MII/RMII Receive Data error',
	'EMAC_MII_TXCLK:MII Transmit Output Clock Pin',
	'EMAC_MII_TXD0:MII/RMII Transmit Data Bus bit 0',
	'EMAC_MII_TXD1:MII/RMII Transmit Data Bus bit 1',
	'EMAC_MII_TXD2:MII Transmit Data Bus bit 2',
	'EMAC_MII_TXD3:MII Transmit Data Bus bit 3',
	'EMAC_MII_TXEN:MII/RMII  Transmit Enable',
	'EMAC_REFCLK:EMAC RMII mode clock input',

	'EPWM0_0:PWM0_0 output/capture input',
	'EPWM0_1:PWM0_1 output/capture input',
	'EPWM0_2:PWM0_2 output/capture input',
	'EPWM0_3:PWM0_3 output/capture input',
	'EPWM0_4:PWM0_4 output/capture input',
	'EPWM0_5:PWM0_5 output/capture input',

	'EPWM1_0:PWM1_0 output/capture input',
	'EPWM1_1:PWM1_1 output/capture input',
	'EPWM1_2:PWM1_2 output/capture input',
	'EPWM1_3:PWM1_3 output/capture input',
	'EPWM1_4:PWM1_4 output/capture input',
	'EPWM1_5:PWM1_5 output/capture input',

	'HS:This pad is embedded with "Slew Rate Control" capability',

	'I2C0_SCL:I2C0 clock pin',
	'I2C0_SDA:I2C0 data input/output pin',

	'I2C1_SCL:I2C1 clock pin',
	'I2C1_SDA:I2C1 data input/output pin',

	'I2C2_SCL:I2C2 clock pin',
	'I2C2_SDA:I2C2 data input/output pin',

	'I2C3_SCL:I2C3 clock pin',
	'I2C3_SDA:I2C3 data input/output pin',

	'I2C4_SCL:I2C4 clock pin',
	'I2C4_SDA:I2C4 data input/output pin',

	'I2S0_BCLK:I2S0 bit clock pin',
	'I2S0_DI:I2S0 data input',
	'I2S0_DO:I2S0 data output',
	'I2S0_LRCK:I2S0 left right channel clock',
	'I2S0_MCLK:I2S0 master clock output pin',

	'I2S1_BCLK:I2S1 bit clock pin',
	'I2S1_DI:I2S1 data input',
	'I2S1_DO:I2S1 data output',
	'I2S1_LRCK:I2S1 left right channel clock',
	'I2S1_MCLK:I2S1 master clock output pin',

	'ICE_CLK:Serial wired debugger clock pin',
	'ICE_DAT:Serial wired debugger data pin',

	'INT0:External interrupt0 input pin',
	'INT1:External interrupt1 input pin',
	'INT2:External interrupt2 input pin',
	'INT3:External interrupt3 input pin',
	'INT4:External interrupt4 input pin',
	'INT5:External interrupt5 input pin',
	'INT6:External interrupt6 input pin',
	'INT7:External interrupt7 input pin',

	'LDO_CAP:LDO output pin',

	'nRESET:External reset input: active LOW, with an internal pull-up. Set this pin low reset to initial state',

	'OPA0_N:General purpose digital I/O pin',
	'OPA0_O:Operational amplifier  output pin',
	'OPA0_P:General purpose digital I/O pin',

	'OPA1_N:General purpose digital I/O pin',
	'OPA1_O:Operational amplifier  output pin',
	'OPA1_P:General purpose digital I/O pin',

	'PS2_CLK:PS2 clock pin',
	'PS2_DAT:PS2 data pin',

	'PWM0_0:PWM0_0 output/capture input',
	'PWM0_1:PWM0_1 output/capture input',
	'PWM0_2:PWM0_2 output/capture input',
	'PWM0_3:PWM0_3 output/capture input',
	'PWM0_4:PWM0_4 output/capture input',
	'PWM0_5:PWM0_5 output/capture input',

	'PWM1_0:PWM1_0 output/capture input',
	'PWM1_1:PWM1_1 output/capture input',
	'PWM1_2:PWM1_2 output/capture input',
	'PWM1_3:PWM1_3 output/capture input',
	'PWM1_4:PWM1_4 output/capture input',
	'PWM1_5:PWM1_5 output/capture input',

	'QEI0_A:Quadrature encoder phase A input of QEI Unit 0',
	'QEI0_B:Quadrature encoder phase B input of QEI Unit 0',
	'QEI0_Z:Quadrature encoder phase Z input of QEI Unit 0',
	'QEI1_A:Quadrature encoder phase A input of QEI Unit 1',
	'QEI1_B:Quadrature encoder phase B input of QEI Unit 1',
	'QEI1_Z:Quadrature encoder phase Z input of QEI Unit 1',

	'SC0_CD:SmartCard0 card detect pin',
	'SC0_CLK:SmartCard0 clock pin',
	'SC0_DAT:SmartCard0 data pin',
	'SC0_PWR:SmartCard0 power pin',
	'SC0_RST:SmartCard0 reset pin',

	'SC1_CD:SmartCard1 card detect pin',
	'SC1_CLK:SmartCard1 clock pin',
	'SC1_DAT:SmartCard1 data pin',
	'SC1_PWR:SmartCard1 power pin',
	'SC1_RST:SmartCard1 reset pin',

	'SC2_CD:SmartCard2 card detect pin',
	'SC2_CLK:SmartCard2 clock pin',
	'SC2_DAT:SmartCard2 data pin',
	'SC2_PWR:SmartCard2 power pin',
	'SC2_RST:SmartCard2 reset pin',

	'SC3_CD:SmartCard3 card detect pin',
	'SC3_CLK:SmartCard3 clock pin',
	'SC3_DAT:SmartCard3 data pin',
	'SC3_PWR:SmartCard3 power pin',
	'SC3_RST:SmartCard3 reset pin',

	'SC4_CD:SmartCard4 card detect pin',
	'SC4_CLK:SmartCard4 clock pin',
	'SC4_DAT:SmartCard4 data pin',
	'SC4_PWR:SmartCard4 power pin',
	'SC4_RST:SmartCard4 reset pin',

	'SC5_CD:SmartCard5 card detect pin',
	'SC5_CLK:SmartCard5 clock pin',
	'SC5_DAT:SmartCard5 data pin',
	'SC5_PWR:SmartCard5 power pin',
	'SC5_RST:SmartCard5 reset pin',

	'SD0_CDn:SD mode #0 card detect',
	'SD0_CLK:SD mode #0 clock',
	'SD0_CMD:SD mode #0 command/response',
	'SD0_DAT0:SD mode #0 data line bit 0',
	'SD0_DAT1:SD mode #0 data line bit 1',
	'SD0_DAT2:SD mode #0 data line bit 2',
	'SD0_DAT3:SD mode #0 data line bit 3',

	'SD1_CDn:SD mode #1 card detect',
	'SD1_CLK:SD mode #1 clock',
	'SD1_CMD:SD mode #1 command/response',
	'SD1_DAT0:SD mode #1 data line bit 0',
	'SD1_DAT1:SD mode #1 data line bit 1',
	'SD1_DAT2:SD mode #1 data line bit 2',
	'SD1_DAT3:SD mode #1 data line bit 3',

	'SPI0_CLK:SPI0 serial clock pin',
	'SPI0_MISO0:1st SPI0 MISO (Master In, Slave Out) pin',
	'SPI0_MISO1:2nd SPI0 MISO (Master In, Slave Out) pin',
	'SPI0_MOSI0:1st SPI0 MOSI (Master Out, Slave In) pin',
	'SPI0_MOSI1:2nd SPI0 MOSI (Master Out, Slave In) pin',
	'SPI0_SS0:1st SPI0 slave select pin',

	'SPI1_CLK:SPI1 serial clock pin',
	'SPI1_MISO0:1st SPI1 MISO (Master In, Slave Out) pin',
	'SPI1_MISO1:2nd SPI1 MISO (Master In, Slave Out) pin',
	'SPI1_MOSI0:1st SPI1 MOSI (Master Out, Slave In) pin',
	'SPI1_MOSI1:2nd SPI1 MOSI (Master Out, Slave In) pin',
	'SPI1_SS0:1st SPI1 slave select pin',

	'SPI2_CLK:SPI2 serial clock pin',
	'SPI2_MISO0:1st SPI2 MISO (Master In, Slave Out) pin',
	'SPI2_MISO1:2nd SPI2 MISO (Master In, Slave Out) pin',
	'SPI2_MOSI0:1st SPI2 MOSI (Master Out, Slave In) pin',
	'SPI2_MOSI1:2nd SPI2 MOSI (Master Out, Slave In) pin',
	'SPI2_SS0:1st SPI2 slave select pin',

	'SPI3_CLK:SPI3 serial clock pin',
	'SPI3_MISO0:1st SPI3 MISO (Master In, Slave Out) pin',
	'SPI3_MISO1:2nd SPI3 MISO (Master In, Slave Out) pin',
	'SPI3_MOSI0:1st SPI3 MOSI (Master Out, Slave In) pin',
	'SPI3_MOSI1:2nd SPI3 MOSI (Master Out, Slave In) pin',
	'SPI3_SS0:1st SPI3 slave select pin',

	'STADC:ADC analog input',

	'TAMPER0:Tamper detect pin 0',
	'TAMPER1:Tamper detect pin 1',

	'TM0_CNT_OUT:Timer0 event counter input/toggle output',
	'TM0_EXT:Timer0 external capture input',

	'TM1_CNT_OUT:Timer1 event counter input/toggle output',
	'TM1_EXT:Timer1 external capture input',

	'TM2_CNT_OUT:Timer2 event counter input/toggle output',
	'TM2_EXT:Timer2 external capture input',

	'TM3_CNT_OUT:Timer3 event counter input/toggle output',
	'TM3_EXT:Timer3 external capture input',

	'UART0_CTS:Clear to Send input pin for UART0',
	'UART0_RTS:Request to Send output pin for UART0',
	'UART0_RXD:Data receiver input pin for UART0',
	'UART0_TXD:Data transmitter output pin for UART0',

	'UART1_CTS:Clear to Send input pin for UART1',
	'UART1_RTS:Request to Send output pin for UART1',
	'UART1_RXD:Data receiver input pin for UART1',
	'UART1_TXD:Data transmitter output pin for UART1',

	'UART2_CTS:Clear to Send input pin for UART2',
	'UART2_RTS:Request to Send output pin for UART2',
	'UART2_RXD:Data receiver input pin for UART2',
	'UART2_TXD:Data transmitter output pin for UART2',

	'UART3_CTS:Clear to Send input pin for UART3',
	'UART3_RTS:Request to Send output pin for UART3',
	'UART3_RXD:Data receiver input pin for UART3',
	'UART3_TXD:Data transmitter output pin for UART3',

	'UART4_CTS:Clear to Send input pin for UART4',
	'UART4_RTS:Request to Send output pin for UART4',
	'UART4_RXD:Data receiver input pin for UART4',
	'UART4_TXD:Data transmitter output pin for UART4',

	'UART5_CTS:Clear to Send input pin for UART5',
	'UART5_RTS:Request to Send output pin for UART5',
	'UART5_RXD:Data receiver input pin for UART5',
	'UART5_TXD:Data transmitter output pin for UART5',

	'USB_VDD33_CAP:Internal power regulator output 3.3V decoupling pin',
	'USB0_D-:USB0 differential signal D-',
	'USB0_D+:USB0 differential signal D+',
	'USB0_OTG_ID:USB0 OTG ID pin',
	'USB0_OTG5V_EN:USB0 external VBUS regulator enabled',
	'USB0_OTG5V_ST:USB0 external VBUS regulator status',
	'USB1_D-:USB1 differential signal D-',
	'USB1_D+:USB1 differential signal D+',

	'VBAT:Battery power input pin',
	'VBUS:USB PHY VBUS power input pin',
	'VDD:Power supply for I/O ports and LDO source for internal PLL and digital circuit',
	'VREF:Voltage reference input for ADC',
	'VRES:USB PHY VRES ground input pin. Add an 8.2K ohm resistor to VSSA',
	'VSS:Ground pin for digital circuit',
	'VSSA:Ground pin for digital circuit. Add a Feritte Bead to digital ground VSS',

	'X32K_IN:External 32.768 kHz (low-speed) crystal input pin',
	'X32K_OUT:External 32.768 kHz (low-speed) crystal output pin',

	'XT1_IN:External 4~24 MHz (high-speed) crystal input pin',
	'XT1_OUT:External 4~24 MHz (high-speed) crystal output pin'
];

NUTOOL_PIN.g_cfg_regDescriptions = {};
NUTOOL_PIN.g_cfg_regDescriptions.GPA_MFPL = '0x40000030';
NUTOOL_PIN.g_cfg_regDescriptions.GPA_MFPH = '0x40000034';
NUTOOL_PIN.g_cfg_regDescriptions.GPB_MFPL = '0x40000038';
NUTOOL_PIN.g_cfg_regDescriptions.GPB_MFPH = '0x4000003C';
NUTOOL_PIN.g_cfg_regDescriptions.GPC_MFPL = '0x40000040';
NUTOOL_PIN.g_cfg_regDescriptions.GPC_MFPH = '0x40000044';
NUTOOL_PIN.g_cfg_regDescriptions.GPD_MFPL = '0x40000048';
NUTOOL_PIN.g_cfg_regDescriptions.GPD_MFPH = '0x4000004C';
NUTOOL_PIN.g_cfg_regDescriptions.GPE_MFPL = '0x40000050';
NUTOOL_PIN.g_cfg_regDescriptions.GPE_MFPH = '0x40000054';
NUTOOL_PIN.g_cfg_regDescriptions.GPF_MFPL = '0x40000058';
NUTOOL_PIN.g_cfg_regDescriptions.GPF_MFPH = '0x4000005C';
NUTOOL_PIN.g_cfg_regDescriptions.GPG_MFPL = '0x40000060';
NUTOOL_PIN.g_cfg_regDescriptions.GPG_MFPH = '0x40000064';
NUTOOL_PIN.g_cfg_regDescriptions.GPH_MFPL = '0x40000068';
NUTOOL_PIN.g_cfg_regDescriptions.GPH_MFPH = '0x4000006C';
NUTOOL_PIN.g_cfg_regDescriptions.GPI_MFPL = '0x40000070';
NUTOOL_PIN.g_cfg_regDescriptions.GPI_MFPH = '0x40000074';

NUTOOL_PIN.g_cfg_gpioMatrix = [];
NUTOOL_PIN.g_cfg_shareBits = [];
NUTOOL_PIN.g_cfg_addGPIO = {};
NUTOOL_PIN.g_cfg_unusedGPIO = {
	"NUC442RI8AE(LQFP64)": {
		"PD.6": ["CAP_HSYNC"],
		"PD.7": ["CAP_PIXCLK"],
		"PA.6": ["QEI1_A", "ECAP1_IC0"],
		"PB.12": ["EMAC_MII_MDC"],
		"PB.13": ["EMAC_MII_MDIO"],
		"PC.0": ["EMAC_REFCLK"],
		"PC.1": ["EMAC_MII_RXERR"],
		"PC.2": ["EMAC_MII_RXDV"],
		"PC.3": ["EMAC_MII_RXD1", "QEI0_Z", "ECAP0_IC2"],
		"PC.4": ["EMAC_MII_RXD0", "QEI0_B", "ECAP0_IC1"],
		"PC.6": ["EMAC_MII_TXD0"],
		"PC.7": ["EMAC_MII_TXD1"],
		"PC.8": ["EMAC_MII_TXEN"],
		"PD.3": ["JTAG_TDO", "CAP_DATA0"],
		"PD.4": ["JTAG_TDI", "CAP_SCLK"],
		"PD.5": ["JTAG_nTRST", "CAP_VSYNC"],
		"PG.10": ["JTAG_TCK"],
		"PG.11": ["JTAG_TMS"]
	},
	"NUC442RG8AE(LQFP64)": function () {
		return this["NUC442RI8AE(LQFP64)"];
	},
	"NUC442VI8AE(LQFP100)": {
		"PB.7": ["ETM_TRACE_DATA3"],
		"PB.8": ["ETM_TRACE_DATA2"],
		"PB.9": ["ETM_TRACE_DATA1"],
		"PB.10": ["ETM_TRACE_DATA0"],
		"PB.11": ["ETM_TRACE_CLK"],
		"PB.12": ["EMAC_MII_MDC"],
		"PB.13": ["EMAC_MII_MDIO"],
		"PB.14": ["EMAC_MII_MDC"],
		"PB.15": ["EMAC_MII_MDIO"],
		"PC.0": ["EMAC_REFCLK"],
		"PC.1": ["EMAC_MII_RXERR"],
		"PC.2": ["EMAC_MII_RXDV"],
		"PC.3": ["EMAC_MII_RXD1"],
		"PC.4": ["EMAC_MII_RXD0"],
		"PC.5": ["EMAC_MII_RXCLK"],
		"PC.6": ["EMAC_MII_TXD0"],
		"PC.7": ["EMAC_MII_TXD1"],
		"PC.8": ["EMAC_MII_TXEN"],
		"PC.12": ["ETM_TRACE_DATA3"],
		"PC.13": ["ETM_TRACE_DATA2"],
		"PC.14": ["ETM_TRACE_DATA1"],
		"PC.15": ["ETM_TRACE_DATA0"],
		"PD.0": ["ETM_TRACE_CLK"],
		"PD.3": ["JTAG_TDO"],
		"PD.4": ["JTAG_TDI"],
		"PD.5": ["JTAG_nTRST"],
		"PG.10": ["JTAG_TCK"],
		"PG.11": ["JTAG_TMS"]
	},
	"NUC442VG8AE(LQFP100)": function () {
		return this["NUC442VI8AE(LQFP100)"];
	},
	"NUC472VI8AE(LQFP100)": {
		"PB.7": ["ETM_TRACE_DATA3"],
		"PB.8": ["ETM_TRACE_DATA2"],
		"PB.9": ["ETM_TRACE_DATA1"],
		"PB.10": ["ETM_TRACE_DATA0"],
		"PB.11": ["ETM_TRACE_CLK"],
		//"PB.12": ["EMAC_MII_MDC"],
		//"PB.13": ["EMAC_MII_MDIO"],
		//"PB.14": ["EMAC_MII_MDC"],
		//"PB.15": ["EMAC_MII_MDIO"],
		//"PC.0": ["EMAC_REFCLK"],
		//"PC.1": ["EMAC_MII_RXERR"],
		//"PC.2": ["EMAC_MII_RXDV"],
		//"PC.3": ["EMAC_MII_RXD1"],
		//"PC.4": ["EMAC_MII_RXD0"],
		//"PC.5": ["EMAC_MII_RXCLK"],
		//"PC.6": ["EMAC_MII_TXD0"],
		//"PC.7": ["EMAC_MII_TXD1"],
		//"PC.8": ["EMAC_MII_TXEN"],
		"PC.12": ["ETM_TRACE_DATA3"],
		"PC.13": ["ETM_TRACE_DATA2"],
		"PC.14": ["ETM_TRACE_DATA1"],
		"PC.15": ["ETM_TRACE_DATA0"],
		"PD.0": ["ETM_TRACE_CLK"],
		"PD.3": ["JTAG_TDO"],
		"PD.4": ["JTAG_TDI"],
		"PD.5": ["JTAG_nTRST"],
		"PG.10": ["JTAG_TCK"],
		"PG.11": ["JTAG_TMS"]
	},
	"NUC472VG8AE(LQFP100)": function () {
		return this["NUC472VI8AE(LQFP100)"];
	},
	"NUC442KI8AE(LQFP128)": {
		"PB.7": ["ETM_TRACE_DATA3"],
		"PB.8": ["ETM_TRACE_DATA2"],
		"PB.9": ["ETM_TRACE_DATA1"],
		"PB.10": ["ETM_TRACE_DATA0"],
		"PB.11": ["ETM_TRACE_CLK"],
		"PB.12": ["EMAC_MII_MDC"],
		"PB.13": ["EMAC_MII_MDIO"],
		"PB.14": ["EMAC_MII_MDC"],
		"PB.15": ["EMAC_MII_MDIO"],
		"PC.0": ["EMAC_REFCLK"],
		"PC.1": ["EMAC_MII_RXERR"],
		"PC.2": ["EMAC_MII_RXDV"],
		"PC.3": ["EMAC_MII_RXD1"],
		"PC.4": ["EMAC_MII_RXD0"],
		"PC.5": ["EMAC_MII_RXCLK"],
		"PC.6": ["EMAC_MII_TXD0"],
		"PC.7": ["EMAC_MII_TXD1"],
		"PC.8": ["EMAC_MII_TXEN"],
		"PC.12": ["ETM_TRACE_DATA3"],
		"PC.13": ["ETM_TRACE_DATA2"],
		"PC.14": ["ETM_TRACE_DATA1"],
		"PC.15": ["ETM_TRACE_DATA0"],
		"PD.0": ["ETM_TRACE_CLK"],
		"PD.3": ["JTAG_TDO"],
		"PD.4": ["JTAG_TDI"],
		"PD.5": ["JTAG_nTRST"],
		"PG.10": ["JTAG_TCK"],
		"PG.11": ["JTAG_TMS"],
		"PF.2": ["EMAC_MII_RXD3"],
		"PF.3": ["EMAC_MII_RXD2"],
		"PF.4": ["EMAC_MII_COL0"],
		"PF.5": ["EMAC_MII_CRS"],
		"PF.6": ["EMAC_MII_TXCLK"],
		"PF.7": ["EMAC_MII_TXD3"],
		"PF.8": ["EMAC_MII_TXD2"]
	},
	"NUC442KG8AE(LQFP128)": function () {
		return this["NUC442KI8AE(LQFP128)"];
	},
	"NUC442JI8AE(LQFP144)": function () {
		return this["NUC442KI8AE(LQFP128)"];
	},
	"NUC442JG8AE(LQFP144)": function () {
		return this["NUC442KI8AE(LQFP128)"];
	},
	"NUC472KI8AE(LQFP128)": {
		"PB.7": ["ETM_TRACE_DATA3"],
		"PB.8": ["ETM_TRACE_DATA2"],
		"PB.9": ["ETM_TRACE_DATA1"],
		"PB.10": ["ETM_TRACE_DATA0"],
		"PB.11": ["ETM_TRACE_CLK"],
		"PC.12": ["ETM_TRACE_DATA3"],
		"PC.13": ["ETM_TRACE_DATA2"],
		"PC.14": ["ETM_TRACE_DATA1"],
		"PC.15": ["ETM_TRACE_DATA0"],
		"PD.0": ["ETM_TRACE_CLK"],
		"PD.3": ["JTAG_TDO"],
		"PD.4": ["JTAG_TDI"],
		"PD.5": ["JTAG_nTRST"],
		"PG.10": ["JTAG_TCK"],
		"PG.11": ["JTAG_TMS"]
	},
	"NUC472KG8AE(LQFP128)": function () {
		return this["NUC472KI8AE(LQFP128)"];
	},
	"NUC472JI8AE(LQFP144)": function () {
		return this["NUC472KI8AE(LQFP128)"];
	},
	"NUC472JG8AE(LQFP144)": function () {
		return this["NUC472KI8AE(LQFP128)"];
	},
	"NUC472HI8AE(LQFP176)": {
		"PB.7": ["ETM_TRACE_DATA3"],
		"PB.8": ["ETM_TRACE_DATA2"],
		"PB.9": ["ETM_TRACE_DATA1"],
		"PB.10": ["ETM_TRACE_DATA0"],
		"PB.11": ["ETM_TRACE_CLK"],
		"PC.12": ["ETM_TRACE_DATA3"],
		"PC.13": ["ETM_TRACE_DATA2"],
		"PC.14": ["ETM_TRACE_DATA1"],
		"PC.15": ["ETM_TRACE_DATA0"],
		"PD.0": ["ETM_TRACE_CLK"],
		"PD.3": ["JTAG_TDO"],
		"PD.4": ["JTAG_TDI"],
		"PD.5": ["JTAG_nTRST"],
		"PG.10": ["JTAG_TCK"],
		"PG.11": ["JTAG_TMS"]
	},
	"NUC472HG8AE(LQFP176)": function () {
		return this["NUC472HI8AE(LQFP176)"];
	}
};

NUTOOL_PIN.decidepackageNumber = function (given_partNumber_package) {
	var partNumber_package,
		partNumber;

	if (typeof given_partNumber_package === 'undefined') {
		partNumber_package = NUTOOL_PIN.getg_partNumber_package();
	}
	else {
		partNumber_package = given_partNumber_package;
	}

	NUTOOL_PIN.g_packageNumber = partNumber_package.substring(partNumber_package.indexOf('(') + 1);
	NUTOOL_PIN.g_packageNumber = NUTOOL_PIN.g_packageNumber.substring(0, NUTOOL_PIN.g_packageNumber.indexOf(')'));

	partNumber = partNumber_package.substring(0, partNumber_package.indexOf('('));
	switch (NUTOOL_PIN.g_packageNumber) {
	case 'LQFP176':
		NUTOOL_PIN.g_packageNumberIndex = "ULQFP176";
		break;
	case 'LQFP144':
		NUTOOL_PIN.g_packageNumberIndex = "ULQFP144";
		break;
	case 'LQFP128':
		NUTOOL_PIN.g_packageNumberIndex = "ULQFP128";
		break;
	case 'LQFP100':
		NUTOOL_PIN.g_packageNumberIndex = "ULQFP100";
		break;
	case 'LQFP64':
		NUTOOL_PIN.g_packageNumberIndex = "ULQFP64";
		break;
	}
	partNumber_package = null;
	partNumber = null;
};
