/**************************************************************************//**
 * @file     gpio.h
 * @version  V1.0
 * @brief     Series GPIO Driver Header File
 *
 * SPDX-License-Identifier: Apache-2.0
 * Copyright (C) 2021 Nuvoton Technology Corp. Japan All rights reserved.
 ******************************************************************************/
#ifndef __GPIO_H__
#define __GPIO_H__

#ifdef __cplusplus
extern "C"
{
#endif


/** @addtogroup Standard_Driver Standard Driver
  @{
*/

/** @addtogroup GPIO_Driver GPIO Driver
  @{
*/

/** @addtogroup GPIO_EXPORTED_CONSTANTS GPIO Exported Constants
  @{
*/

/*@}*/ /* end of group GPIO_EXPORTED_CONSTANTS */


/** @addtogroup GPIO_EXPORTED_FUNCTIONS GPIO Exported Functions
  @{
*/

/*---------------------------------------------------------------------------------------------------------*/
/*  GPIO Port No. Definitions                                                                              */
/*---------------------------------------------------------------------------------------------------------*/
#define P0          (0)         /* !< Port 0 (GPIO)  \hideinitializer */
#define P1          (1)         /* !< Port 0 (GPIO)  \hideinitializer */
#define P2          (2)         /* !< Port 0 (GPIO)  \hideinitializer */
#define P3          (3)         /* !< Port 0 (GPIO)  \hideinitializer */
#define P4          (4)         /* !< Port 0 (GPIO)  \hideinitializer */
#define P5          (5)         /* !< Port 0 (GPIO)  \hideinitializer */
#define P6          (6)         /* !< Port 0 (GPIO)  \hideinitializer */
#define P7          (7)         /* !< Port 0 (GPIO)  \hideinitializer */
#define P8          (8)         /* !< Port 0 (GPIO)  \hideinitializer */
#define P9          (9)         /* !< Port 0 (GPIO)  \hideinitializer */
#define PA          (10)        /* !< Port 0 (GPIO)  \hideinitializer */
#define PB          (11)        /* !< Port 0 (GPIO)  \hideinitializer */
#define PC          (12)        /* !< Port 0 (GPIO)  \hideinitializer */
#define PD          (13)        /* !< Port 0 (GPIO)  \hideinitializer */
#define PE          (14)        /* !< Port 0 (GPIO)  \hideinitializer */
#define PF          (15)        /* !< Port 0 (GPIO)  \hideinitializer */
#define Pn_MAX      (16)        /* Range Max */

/*---------------------------------------------------------------------------------------------------------*/
/*  GPIO Pin Configuration Definitions   (Refer to Pin-Configuration Tool)                                 */
/*---------------------------------------------------------------------------------------------------------*/
#define IOP0MD      (GPIO_MD->IOPnMD[P0])           /*!< Port 0 Mode Register   \hideinitializer   */
#define IOP1MD      (GPIO_MD->IOPnMD[P1])           /*!< Port 1 Mode Register   \hideinitializer  */
#define IOP2MD      (GPIO_MD->IOPnMD[P2])           /*!< Port 2 Mode Register   \hideinitializer  */
#define IOP3MD      (GPIO_MD->IOPnMD[P3])           /*!< Port 3 Mode Register   \hideinitializer  */
#define IOP4MD      (GPIO_MD->IOPnMD[P4])           /*!< Port 4 Mode Register   \hideinitializer  */
#define IOP5MD      (GPIO_MD->IOPnMD[P5])           /*!< Port 5 Mode Register   \hideinitializer  */
#define IOP6MD      (GPIO_MD->IOPnMD[P6])           /*!< Port 6 Mode Register   \hideinitializer  */
#define IOP7MD      (GPIO_MD->IOPnMD[P7])           /*!< Port 7 Mode Register   \hideinitializer  */
#define IOP8MD      (GPIO_MD->IOPnMD[P8])           /*!< Port 8 Mode Register   \hideinitializer  */
#define IOP9MD      (GPIO_MD->IOPnMD[P9])           /*!< Port 9 Mode Register   \hideinitializer  */
#define IOPAMD      (GPIO_MD->IOPnMD[PA])           /*!< Port A Mode Register   \hideinitializer  */
#define IOPBMD      (GPIO_MD->IOPnMD[PB])           /*!< Port B Mode Register   \hideinitializer  */
#define IOPCMD      (GPIO_MD->IOPnMD[PC])           /*!< Port C Mode Register   \hideinitializer  */
#define IOPDMD      (GPIO_MD->IOPnMD[PD])           /*!< Port D Mode Register   \hideinitializer  */
#define IOPEMD      (GPIO_MD->IOPnMD[PE])           /*!< Port E Mode Register   \hideinitializer  */
#define IOPFMD      (GPIO_MD->IOPnMD[PF])           /*!< Port F Mode Register   \hideinitializer  */

/*---------------------------------------------------------------------------------------------------------*/
/*  Pin-Function constant definitions.                                                                     */
/*---------------------------------------------------------------------------------------------------------*/
/* How to use below #define?
Example 1: If user want to set P0.0 as DBG_TRCCLK in initial function,
           user can issue following command to achieve it.

           IOP0MD  = (IOP0MD & (~GPIO_IOP0MD_P00MD_Msk) ) | GPIO_IOP0MD_P00MD_DBG_TRCCLK  ;

*/
/********************* Bit definition of IOP0MD register **********************/
#define GPIO_IOP0MD_P00MD_GPIO                (0x00UL<<GPIO_IOP0MD_P00MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP0MD_P00MD_IRQ00               (0x01UL<<GPIO_IOP0MD_P00MD_Pos)     /*!< External interrupt 0 input pin. \hideinitializer */
#define GPIO_IOP0MD_P00MD_TM20A               (0x02UL<<GPIO_IOP0MD_P00MD_Pos)     /*!< Timer 20 input/output pin A. \hideinitializer */
#define GPIO_IOP0MD_P00MD_DBG_TRCCLK          (0x04UL<<GPIO_IOP0MD_P00MD_Pos)     /*!< ETM Trace clock output pin. \hideinitializer */

#define GPIO_IOP0MD_P01MD_GPIO                (0x00UL<<GPIO_IOP0MD_P01MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP0MD_P01MD_IRQ01               (0x01UL<<GPIO_IOP0MD_P01MD_Pos)     /*!< External interrupt 1 input pin. \hideinitializer */
#define GPIO_IOP0MD_P01MD_TM20B               (0x02UL<<GPIO_IOP0MD_P01MD_Pos)     /*!< Timer 20 input/output pin B. \hideinitializer */
#define GPIO_IOP0MD_P01MD_DBG_TRCSWO          (0x04UL<<GPIO_IOP0MD_P01MD_Pos)     /*!< Serial wire output pin. \hideinitializer */

#define GPIO_IOP0MD_P02MD_GPIO                (0x00UL<<GPIO_IOP0MD_P02MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP0MD_P02MD_IRQ02               (0x01UL<<GPIO_IOP0MD_P02MD_Pos)     /*!< External interrupt 2 input pin. \hideinitializer */
#define GPIO_IOP0MD_P02MD_TM00A               (0x02UL<<GPIO_IOP0MD_P02MD_Pos)     /*!< Timer 0 input/output pin A. \hideinitializer */
#define GPIO_IOP0MD_P02MD_DBG_TRCD0           (0x04UL<<GPIO_IOP0MD_P02MD_Pos)     /*!< ETM Trace data 0 output pin. \hideinitializer */

#define GPIO_IOP0MD_P03MD_GPIO                (0x00UL<<GPIO_IOP0MD_P03MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP0MD_P03MD_IRQ03               (0x01UL<<GPIO_IOP0MD_P03MD_Pos)     /*!< External interrupt 3 input pin. \hideinitializer */
#define GPIO_IOP0MD_P03MD_TM00B               (0x02UL<<GPIO_IOP0MD_P03MD_Pos)     /*!< Timer 0 input/output pin B. \hideinitializer */
#define GPIO_IOP0MD_P03MD_DBG_TRCD1           (0x04UL<<GPIO_IOP0MD_P03MD_Pos)     /*!< ETM Trace data 1 output pin. \hideinitializer */

#define GPIO_IOP0MD_P04MD_GPIO                (0x00UL<<GPIO_IOP0MD_P04MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP0MD_P04MD_IRQ04               (0x01UL<<GPIO_IOP0MD_P04MD_Pos)     /*!< External interrupt 4 input pin. \hideinitializer */
#define GPIO_IOP0MD_P04MD_TM01A               (0x02UL<<GPIO_IOP0MD_P04MD_Pos)     /*!< Timer 1 input/output pin A. \hideinitializer */
#define GPIO_IOP0MD_P04MD_DBG_TRCD2           (0x04UL<<GPIO_IOP0MD_P04MD_Pos)     /*!< ETM Trace data 2 output pin. \hideinitializer */

#define GPIO_IOP0MD_P05MD_GPIO                (0x00UL<<GPIO_IOP0MD_P05MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP0MD_P05MD_IRQ05               (0x01UL<<GPIO_IOP0MD_P05MD_Pos)     /*!< External interrupt 5 input pin. \hideinitializer */
#define GPIO_IOP0MD_P05MD_TM01B               (0x02UL<<GPIO_IOP0MD_P05MD_Pos)     /*!< Timer 1 input/output pin B. \hideinitializer */
#define GPIO_IOP0MD_P05MD_DBG_TRCD3           (0x04UL<<GPIO_IOP0MD_P05MD_Pos)     /*!< ETM Trace data 3 output pin. \hideinitializer */

#define GPIO_IOP0MD_P06MD_GPIO                (0x00UL<<GPIO_IOP0MD_P06MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP0MD_P06MD_IRQ06               (0x01UL<<GPIO_IOP0MD_P06MD_Pos)     /*!< External interrupt 6 input pin. \hideinitializer */
#define GPIO_IOP0MD_P06MD_TM02A               (0x02UL<<GPIO_IOP0MD_P06MD_Pos)     /*!< Timer 2 input/output pin A. \hideinitializer */
#define GPIO_IOP0MD_P06MD_SMBUS_SMCL          (0x03UL<<GPIO_IOP0MD_P06MD_Pos)     /*!< SMBUS clock input/output pin. \hideinitializer */
#define GPIO_IOP0MD_P06MD_CAN1_CRX            (0x04UL<<GPIO_IOP0MD_P06MD_Pos)     /*!< CAN1 receive input pin. \hideinitializer */

#define GPIO_IOP0MD_P07MD_GPIO                (0x00UL<<GPIO_IOP0MD_P07MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP0MD_P07MD_IRQ07               (0x01UL<<GPIO_IOP0MD_P07MD_Pos)     /*!< External interrupt 7 input pin. \hideinitializer */
#define GPIO_IOP0MD_P07MD_TM02B               (0x02UL<<GPIO_IOP0MD_P07MD_Pos)     /*!< Timer 2 input/output pin B. \hideinitializer */
#define GPIO_IOP0MD_P07MD_SMBUS_SMDA          (0x03UL<<GPIO_IOP0MD_P07MD_Pos)     /*!< SMBUS data input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP0MD_P07MD_CAN1_CTX            (0x04UL<<GPIO_IOP0MD_P07MD_Pos)     /*!< CAN1 transmit output (Use Nch open-drain) pin. \hideinitializer */

/********************* Bit definition of IOP1MD register **********************/
#define GPIO_IOP1MD_P10MD_GPIO                (0x00UL<<GPIO_IOP1MD_P10MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP1MD_P10MD_IRQ08               (0x01UL<<GPIO_IOP1MD_P10MD_Pos)     /*!< External interrupt 8 input pin. \hideinitializer */
#define GPIO_IOP1MD_P10MD_TM21A               (0x02UL<<GPIO_IOP1MD_P10MD_Pos)     /*!< Timer 21 input/output pin A. \hideinitializer */
#define GPIO_IOP1MD_P10MD_CMP0_CMPOT00        (0x03UL<<GPIO_IOP1MD_P10MD_Pos)     /*!< Comparator 00 output pin. \hideinitializer */
#define GPIO_IOP1MD_P10MD_CAN1_CTX            (0x04UL<<GPIO_IOP1MD_P10MD_Pos)     /*!< CAN1 transmit output (Use Nch open-drain) pin. \hideinitializer */

#define GPIO_IOP1MD_P11MD_GPIO                (0x00UL<<GPIO_IOP1MD_P11MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP1MD_P11MD_IRQ09               (0x01UL<<GPIO_IOP1MD_P11MD_Pos)     /*!< External interrupt 9 input pin. \hideinitializer */
#define GPIO_IOP1MD_P11MD_TM21B               (0x02UL<<GPIO_IOP1MD_P11MD_Pos)     /*!< Timer 21 input/output pin B. \hideinitializer */
#define GPIO_IOP1MD_P11MD_CMP1_CMPOT10        (0x03UL<<GPIO_IOP1MD_P11MD_Pos)     /*!< Comparator 10 output pin. \hideinitializer */
#define GPIO_IOP1MD_P11MD_CAN1_CRX            (0x04UL<<GPIO_IOP1MD_P11MD_Pos)     /*!< CAN1 receive input pin. \hideinitializer */

#define GPIO_IOP1MD_P12MD_GPIO                (0x00UL<<GPIO_IOP1MD_P12MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP1MD_P12MD_IRQ10               (0x01UL<<GPIO_IOP1MD_P12MD_Pos)     /*!< External interrupt 10 input pin. \hideinitializer */
#define GPIO_IOP1MD_P12MD_TM07A               (0x02UL<<GPIO_IOP1MD_P12MD_Pos)     /*!< Timer 7 input/output pin A. \hideinitializer */

#define GPIO_IOP1MD_P13MD_GPIO                (0x00UL<<GPIO_IOP1MD_P13MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP1MD_P13MD_IRQ11               (0x01UL<<GPIO_IOP1MD_P13MD_Pos)     /*!< External interrupt 11 input pin. \hideinitializer */
#define GPIO_IOP1MD_P13MD_TM07B               (0x02UL<<GPIO_IOP1MD_P13MD_Pos)     /*!< Timer 7 input/output pin B. \hideinitializer */
#define GPIO_IOP1MD_P13MD_GPWM0_GPWMST0       (0x03UL<<GPIO_IOP1MD_P13MD_Pos)     /*!< GPWM0 count state output pin. \hideinitializer */
#define GPIO_IOP1MD_P13MD_GPWM9_GPWMST9       (0x04UL<<GPIO_IOP1MD_P13MD_Pos)     /*!< GPWM9 count state output pin. \hideinitializer */

#define GPIO_IOP1MD_P14MD_GPIO                (0x00UL<<GPIO_IOP1MD_P14MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP1MD_P14MD_IRQ12               (0x01UL<<GPIO_IOP1MD_P14MD_Pos)     /*!< External interrupt 12 input pin. \hideinitializer */
#define GPIO_IOP1MD_P14MD_TM08A               (0x02UL<<GPIO_IOP1MD_P14MD_Pos)     /*!< Timer 8 input/output pin A. \hideinitializer */
#define GPIO_IOP1MD_P14MD_GPWM1_GPWMST1       (0x03UL<<GPIO_IOP1MD_P14MD_Pos)     /*!< GPWM1 count state output pin. \hideinitializer */
#define GPIO_IOP1MD_P14MD_GPWMA_GPWMSTA       (0x04UL<<GPIO_IOP1MD_P14MD_Pos)     /*!< GPWMA count state output pin. \hideinitializer */
#define GPIO_IOP1MD_P14MD_DAC_DAOT0           (0x05UL<<GPIO_IOP1MD_P14MD_Pos)     /*!< D/A Converter 0 output pin. \hideinitializer */

#define GPIO_IOP1MD_P15MD_GPIO                (0x00UL<<GPIO_IOP1MD_P15MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP1MD_P15MD_IRQ13               (0x01UL<<GPIO_IOP1MD_P15MD_Pos)     /*!< External interrupt 13 input pin. \hideinitializer */
#define GPIO_IOP1MD_P15MD_TM08B               (0x02UL<<GPIO_IOP1MD_P15MD_Pos)     /*!< Timer 8 input/output pin B. \hideinitializer */
#define GPIO_IOP1MD_P15MD_GPWM2_GPWMST2       (0x03UL<<GPIO_IOP1MD_P15MD_Pos)     /*!< GPWM2 count state output pin. \hideinitializer */
#define GPIO_IOP1MD_P15MD_GPWMB_GPWMSTB       (0x04UL<<GPIO_IOP1MD_P15MD_Pos)     /*!< GPWMB count state output pin. \hideinitializer */
#define GPIO_IOP1MD_P15MD_DAC_DAOT1           (0x05UL<<GPIO_IOP1MD_P15MD_Pos)     /*!< D/A Converter 1 output pin. \hideinitializer */

#define GPIO_IOP1MD_P16MD_GPIO                (0x00UL<<GPIO_IOP1MD_P16MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */

#define GPIO_IOP1MD_P17MD_GPIO                (0x00UL<<GPIO_IOP1MD_P17MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */

/********************* Bit definition of IOP2MD register **********************/
#define GPIO_IOP2MD_P20MD_GPIO                (0x00UL<<GPIO_IOP2MD_P20MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP2MD_P20MD_IRQ14               (0x01UL<<GPIO_IOP2MD_P20MD_Pos)     /*!< External interrupt 14 input pin. \hideinitializer */
#define GPIO_IOP2MD_P20MD_TM12A               (0x02UL<<GPIO_IOP2MD_P20MD_Pos)     /*!< Timer 12 input/output pin A. \hideinitializer */

#define GPIO_IOP2MD_P21MD_GPIO                (0x00UL<<GPIO_IOP2MD_P21MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP2MD_P21MD_IRQ15               (0x01UL<<GPIO_IOP2MD_P21MD_Pos)     /*!< External interrupt 15 input pin. \hideinitializer */
#define GPIO_IOP2MD_P21MD_TM12B               (0x02UL<<GPIO_IOP2MD_P21MD_Pos)     /*!< Timer 12 input/output pin B. \hideinitializer */

#define GPIO_IOP2MD_P22MD_GPIO                (0x00UL<<GPIO_IOP2MD_P22MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP2MD_P22MD_IRQ16               (0x01UL<<GPIO_IOP2MD_P22MD_Pos)     /*!< External interrupt 16 input pin. \hideinitializer */

#define GPIO_IOP2MD_P24MD_GPIO                (0x00UL<<GPIO_IOP2MD_P24MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP2MD_P24MD_IRQ17               (0x01UL<<GPIO_IOP2MD_P24MD_Pos)     /*!< External interrupt 17 input pin. \hideinitializer */
#define GPIO_IOP2MD_P24MD_SPI4_SBI            (0x02UL<<GPIO_IOP2MD_P24MD_Pos)     /*!< SPI4 data input pin. \hideinitializer */
#define GPIO_IOP2MD_P24MD_UART4_RX            (0x02UL<<GPIO_IOP2MD_P24MD_Pos)     /*!< UART4 data input pin. \hideinitializer */
#define GPIO_IOP2MD_P24MD_SPI7_SBI            (0x03UL<<GPIO_IOP2MD_P24MD_Pos)     /*!< SPI7 data input pin. \hideinitializer */
#define GPIO_IOP2MD_P24MD_UART7_RX            (0x03UL<<GPIO_IOP2MD_P24MD_Pos)     /*!< UART7 data input pin. \hideinitializer */
#define GPIO_IOP2MD_P24MD_CAN0_CRX            (0x04UL<<GPIO_IOP2MD_P24MD_Pos)     /*!< CAN0 receive input pin. \hideinitializer */
#define GPIO_IOP2MD_P24MD_ADTRG0              (0x05UL<<GPIO_IOP2MD_P24MD_Pos)     /*!< A/D0 conversion state output pin. \hideinitializer */

#define GPIO_IOP2MD_P25MD_GPIO                (0x00UL<<GPIO_IOP2MD_P25MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP2MD_P25MD_IRQ18               (0x01UL<<GPIO_IOP2MD_P25MD_Pos)     /*!< External interrupt 18 input pin. \hideinitializer */
#define GPIO_IOP2MD_P25MD_SPI4_SBO            (0x02UL<<GPIO_IOP2MD_P25MD_Pos)     /*!< SPI4 data input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP2MD_P25MD_UART4_TX            (0x02UL<<GPIO_IOP2MD_P25MD_Pos)     /*!< UART4 data input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP2MD_P25MD_SPI4_SBT            (0x03UL<<GPIO_IOP2MD_P25MD_Pos)     /*!< SPI4 clock input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP2MD_P25MD_SPI7_SBO            (0x04UL<<GPIO_IOP2MD_P25MD_Pos)     /*!< SPI7 data input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP2MD_P25MD_UART7_TX            (0x04UL<<GPIO_IOP2MD_P25MD_Pos)     /*!< UART7 data input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP2MD_P25MD_IIC7_SDA            (0x04UL<<GPIO_IOP2MD_P25MD_Pos)     /*!< IIC7 data input/ouput (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP2MD_P25MD_SPI7_SBT            (0x05UL<<GPIO_IOP2MD_P25MD_Pos)     /*!< SPI7 clock input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP2MD_P25MD_IIC7_SCL            (0x05UL<<GPIO_IOP2MD_P25MD_Pos)     /*!< IIC7 clock input/ouput (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP2MD_P25MD_CAN0_CTX            (0x06UL<<GPIO_IOP2MD_P25MD_Pos)     /*!< CAN0 transmit output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP2MD_P25MD_ADTRG1              (0x07UL<<GPIO_IOP2MD_P25MD_Pos)     /*!< A/D1 conversion state output pin. \hideinitializer */

#define GPIO_IOP2MD_P26MD_GPIO                (0x00UL<<GPIO_IOP2MD_P26MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP2MD_P26MD_IRQ19               (0x01UL<<GPIO_IOP2MD_P26MD_Pos)     /*!< External interrupt 19 input pin. \hideinitializer */
#define GPIO_IOP2MD_P26MD_SPI4_SBT            (0x02UL<<GPIO_IOP2MD_P26MD_Pos)     /*!< SPI4 clock input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP2MD_P26MD_SPI4_SBO            (0x03UL<<GPIO_IOP2MD_P26MD_Pos)     /*!< SPI4 data input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP2MD_P26MD_UART4_TX            (0x03UL<<GPIO_IOP2MD_P26MD_Pos)     /*!< UART4 data input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP2MD_P26MD_SPI7_SBT            (0x04UL<<GPIO_IOP2MD_P26MD_Pos)     /*!< SPI7 clock input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP2MD_P26MD_IIC7_SCL            (0x04UL<<GPIO_IOP2MD_P26MD_Pos)     /*!< IIC7 clock input/ouput (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP2MD_P26MD_SPI7_SBO            (0x05UL<<GPIO_IOP2MD_P26MD_Pos)     /*!< SPI7 data input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP2MD_P26MD_UART7_TX            (0x05UL<<GPIO_IOP2MD_P26MD_Pos)     /*!< UART7 data input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP2MD_P26MD_IIC7_SDA            (0x05UL<<GPIO_IOP2MD_P26MD_Pos)     /*!< IIC7 data input/ouput (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP2MD_P26MD_TM13A               (0x06UL<<GPIO_IOP2MD_P26MD_Pos)     /*!< Timer 13 input/output pin A. \hideinitializer */
#define GPIO_IOP2MD_P26MD_ADTRG2              (0x07UL<<GPIO_IOP2MD_P26MD_Pos)     /*!< A/D2 conversion state output pin. \hideinitializer */

#define GPIO_IOP2MD_P27MD_GPIO                (0x00UL<<GPIO_IOP2MD_P27MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP2MD_P27MD_SPI4_SBCS           (0x01UL<<GPIO_IOP2MD_P27MD_Pos)     /*!< SPI4 chip select input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP2MD_P27MD_SPI7_SBCS           (0x02UL<<GPIO_IOP2MD_P27MD_Pos)     /*!< SPI7 chip select input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP2MD_P27MD_TM13B               (0x03UL<<GPIO_IOP2MD_P27MD_Pos)     /*!< Timer 13 input/output pin B. \hideinitializer */

/********************* Bit definition of IOP3MD register **********************/
#define GPIO_IOP3MD_P30MD_GPIO                (0x00UL<<GPIO_IOP3MD_P30MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP3MD_P30MD_SPI0_SBO            (0x01UL<<GPIO_IOP3MD_P30MD_Pos)     /*!< SPI0 data input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP3MD_P30MD_IIC0_SDA            (0x01UL<<GPIO_IOP3MD_P30MD_Pos)     /*!< IIC0 data input/ouput (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP3MD_P30MD_SPI0_SBT            (0x02UL<<GPIO_IOP3MD_P30MD_Pos)     /*!< SPI0 clock input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP3MD_P30MD_IIC0_SCL            (0x02UL<<GPIO_IOP3MD_P30MD_Pos)     /*!< IIC0 clock input/ouput (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP3MD_P30MD_CMP2_CMPOT20        (0x03UL<<GPIO_IOP3MD_P30MD_Pos)     /*!< Comparator 20 output pin. \hideinitializer */

#define GPIO_IOP3MD_P31MD_GPIO                (0x00UL<<GPIO_IOP3MD_P31MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP3MD_P31MD_SPI0_SBT            (0x01UL<<GPIO_IOP3MD_P31MD_Pos)     /*!< SPI0 clock input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP3MD_P31MD_IIC0_SCL            (0x01UL<<GPIO_IOP3MD_P31MD_Pos)     /*!< IIC0 clock input/ouput (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP3MD_P31MD_SPI0_SBO            (0x02UL<<GPIO_IOP3MD_P31MD_Pos)     /*!< SPI0 data input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP3MD_P31MD_IIC0_SDA            (0x02UL<<GPIO_IOP3MD_P31MD_Pos)     /*!< IIC0 data input/ouput (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP3MD_P31MD_CMP3_CMPOT30        (0x03UL<<GPIO_IOP3MD_P31MD_Pos)     /*!< Comparator 30 output pin. \hideinitializer */

#define GPIO_IOP3MD_P32MD_GPIO                (0x00UL<<GPIO_IOP3MD_P32MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP3MD_P32MD_SPI0_SBI            (0x01UL<<GPIO_IOP3MD_P32MD_Pos)     /*!< SPI0 data input pin. \hideinitializer */
#define GPIO_IOP3MD_P32MD_CMP4_CMPOT40        (0x02UL<<GPIO_IOP3MD_P32MD_Pos)     /*!< Comparator 40 output pin. \hideinitializer */

#define GPIO_IOP3MD_P34MD_GPIO                (0x00UL<<GPIO_IOP3MD_P34MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP3MD_P34MD_SPI1_SBO            (0x01UL<<GPIO_IOP3MD_P34MD_Pos)     /*!< SPI1 data input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP3MD_P34MD_UART1_TX            (0x01UL<<GPIO_IOP3MD_P34MD_Pos)     /*!< UART1 data input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP3MD_P34MD_LIN_LTX             (0x01UL<<GPIO_IOP3MD_P34MD_Pos)     /*!< LIN transmission input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP3MD_P34MD_SPI1_SBT            (0x02UL<<GPIO_IOP3MD_P34MD_Pos)     /*!< SPI1 clock input/output (Use Nch open-drain) pin. \hideinitializer */

#define GPIO_IOP3MD_P35MD_GPIO                (0x00UL<<GPIO_IOP3MD_P35MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP3MD_P35MD_SPI1_SBT            (0x01UL<<GPIO_IOP3MD_P35MD_Pos)     /*!< SPI1 clock input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP3MD_P35MD_SPI1_SBO            (0x02UL<<GPIO_IOP3MD_P35MD_Pos)     /*!< SPI1 data input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP3MD_P35MD_UART1_TX            (0x02UL<<GPIO_IOP3MD_P35MD_Pos)     /*!< UART1 data input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP3MD_P35MD_LIN_LTX             (0x02UL<<GPIO_IOP3MD_P35MD_Pos)     /*!< LIN transmission input/output (Use Nch open-drain) pin. \hideinitializer */

#define GPIO_IOP3MD_P36MD_GPIO                (0x00UL<<GPIO_IOP3MD_P36MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP3MD_P36MD_SPI1_SBI            (0x01UL<<GPIO_IOP3MD_P36MD_Pos)     /*!< SPI1 data input pin. \hideinitializer */
#define GPIO_IOP3MD_P36MD_UART1_RX            (0x01UL<<GPIO_IOP3MD_P36MD_Pos)     /*!< UART1 data input pin. \hideinitializer */
#define GPIO_IOP3MD_P36MD_LIN_LRX             (0x01UL<<GPIO_IOP3MD_P36MD_Pos)     /*!< LIN reception input pin. \hideinitializer */

/********************* Bit definition of IOP4MD register **********************/
#define GPIO_IOP4MD_P40MD_GPIO                (0x00UL<<GPIO_IOP4MD_P40MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP4MD_P40MD_SPI2_SBO            (0x01UL<<GPIO_IOP4MD_P40MD_Pos)     /*!< SPI2 data input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP4MD_P40MD_UART2_TX            (0x01UL<<GPIO_IOP4MD_P40MD_Pos)     /*!< UART2 data input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP4MD_P40MD_SPI2_SBT            (0x02UL<<GPIO_IOP4MD_P40MD_Pos)     /*!< SPI2 clock input/output (Use Nch open-drain) pin. \hideinitializer */

#define GPIO_IOP4MD_P41MD_GPIO                (0x00UL<<GPIO_IOP4MD_P41MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP4MD_P41MD_SPI2_SBT            (0x01UL<<GPIO_IOP4MD_P41MD_Pos)     /*!< SPI2 clock input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP4MD_P41MD_SPI2_SBO            (0x02UL<<GPIO_IOP4MD_P41MD_Pos)     /*!< SPI2 data input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP4MD_P41MD_UART2_TX            (0x02UL<<GPIO_IOP4MD_P41MD_Pos)     /*!< UART2 data input/output (Use Nch open-drain) pin. \hideinitializer */

#define GPIO_IOP4MD_P42MD_GPIO                (0x00UL<<GPIO_IOP4MD_P42MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP4MD_P42MD_SPI2_SBI            (0x01UL<<GPIO_IOP4MD_P42MD_Pos)     /*!< SPI2 data input pin. \hideinitializer */
#define GPIO_IOP4MD_P42MD_UART2_RX            (0x01UL<<GPIO_IOP4MD_P42MD_Pos)     /*!< UART2 data input pin. \hideinitializer */

#define GPIO_IOP4MD_P44MD_GPIO                (0x00UL<<GPIO_IOP4MD_P44MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP4MD_P44MD_SPI3_SBO            (0x01UL<<GPIO_IOP4MD_P44MD_Pos)     /*!< SPI3 data input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP4MD_P44MD_UART3_TX            (0x01UL<<GPIO_IOP4MD_P44MD_Pos)     /*!< UART3 data input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP4MD_P44MD_SPI3_SBT            (0x02UL<<GPIO_IOP4MD_P44MD_Pos)     /*!< SPI3 clock input/output (Use Nch open-drain) pin. \hideinitializer */

#define GPIO_IOP4MD_P45MD_GPIO                (0x00UL<<GPIO_IOP4MD_P45MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP4MD_P45MD_SPI3_SBT            (0x01UL<<GPIO_IOP4MD_P45MD_Pos)     /*!< SPI3 clock input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP4MD_P45MD_SPI3_SBO            (0x02UL<<GPIO_IOP4MD_P45MD_Pos)     /*!< SPI3 data input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP4MD_P45MD_UART3_TX            (0x02UL<<GPIO_IOP4MD_P45MD_Pos)     /*!< UART3 data input/output (Use Nch open-drain) pin. \hideinitializer */

#define GPIO_IOP4MD_P46MD_GPIO                (0x00UL<<GPIO_IOP4MD_P46MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP4MD_P46MD_SPI3_SBI            (0x01UL<<GPIO_IOP4MD_P46MD_Pos)     /*!< SPI3 data input pin. \hideinitializer */
#define GPIO_IOP4MD_P46MD_UART3_RX            (0x01UL<<GPIO_IOP4MD_P46MD_Pos)     /*!< UART3 data input pin. \hideinitializer */

#define GPIO_IOP4MD_P47MD_GPIO                (0x00UL<<GPIO_IOP4MD_P47MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP4MD_P47MD_SPI3_SBCS           (0x01UL<<GPIO_IOP4MD_P47MD_Pos)     /*!< SPI3 chip select input/output (Use Nch open-drain) pin. \hideinitializer */

/********************* Bit definition of IOP5MD register **********************/
#define GPIO_IOP5MD_P50MD_GPIO                (0x00UL<<GPIO_IOP5MD_P50MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP5MD_P50MD_TM22A               (0x01UL<<GPIO_IOP5MD_P50MD_Pos)     /*!< Timer 22 input/output pin A. \hideinitializer */
#define GPIO_IOP5MD_P50MD_CAN0_CTX            (0x02UL<<GPIO_IOP5MD_P50MD_Pos)     /*!< CAN0 transmit output (Use Nch open-drain) pin. \hideinitializer */

#define GPIO_IOP5MD_P51MD_GPIO                (0x00UL<<GPIO_IOP5MD_P51MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP5MD_P51MD_TM22B               (0x01UL<<GPIO_IOP5MD_P51MD_Pos)     /*!< Timer 22 input/output pin B. \hideinitializer */
#define GPIO_IOP5MD_P51MD_CAN0_CRX            (0x02UL<<GPIO_IOP5MD_P51MD_Pos)     /*!< CAN0 receive input pin. \hideinitializer */

#define GPIO_IOP5MD_P52MD_GPIO                (0x00UL<<GPIO_IOP5MD_P52MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP5MD_P52MD_TM23A               (0x01UL<<GPIO_IOP5MD_P52MD_Pos)     /*!< Timer 23 input/output pin A. \hideinitializer */
#define GPIO_IOP5MD_P52MD_CMP0_CMPOT01        (0x02UL<<GPIO_IOP5MD_P52MD_Pos)     /*!< Comparator 01 output pin. \hideinitializer */
#define GPIO_IOP5MD_P52MD_SPI5_SBO            (0x03UL<<GPIO_IOP5MD_P52MD_Pos)     /*!< SPI5 data input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP5MD_P52MD_UART5_TX            (0x03UL<<GPIO_IOP5MD_P52MD_Pos)     /*!< UART5 data input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP5MD_P52MD_SPI5_SBT            (0x04UL<<GPIO_IOP5MD_P52MD_Pos)     /*!< SPI5 clock input/output (Use Nch open-drain) pin. \hideinitializer */

#define GPIO_IOP5MD_P53MD_GPIO                (0x00UL<<GPIO_IOP5MD_P53MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP5MD_P53MD_TM23B               (0x01UL<<GPIO_IOP5MD_P53MD_Pos)     /*!< Timer 23 input/output pin B. \hideinitializer */
#define GPIO_IOP5MD_P53MD_CMP1_CMPOT11        (0x02UL<<GPIO_IOP5MD_P53MD_Pos)     /*!< Comparator 11 output pin. \hideinitializer */
#define GPIO_IOP5MD_P53MD_SPI5_SBT            (0x03UL<<GPIO_IOP5MD_P53MD_Pos)     /*!< SPI5 clock input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP5MD_P53MD_SPI5_SBO            (0x04UL<<GPIO_IOP5MD_P53MD_Pos)     /*!< SPI5 data input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP5MD_P53MD_UART5_TX            (0x04UL<<GPIO_IOP5MD_P53MD_Pos)     /*!< UART5 data input/output (Use Nch open-drain) pin. \hideinitializer */

#define GPIO_IOP5MD_P54MD_GPIO                (0x00UL<<GPIO_IOP5MD_P54MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP5MD_P54MD_TM24A               (0x01UL<<GPIO_IOP5MD_P54MD_Pos)     /*!< Timer 24 input/output pin A. \hideinitializer */
#define GPIO_IOP5MD_P54MD_CMP2_CMPOT21        (0x02UL<<GPIO_IOP5MD_P54MD_Pos)     /*!< Comparator 21 output pin. \hideinitializer */
#define GPIO_IOP5MD_P54MD_SPI5_SBI            (0x03UL<<GPIO_IOP5MD_P54MD_Pos)     /*!< SPI5 data input pin. \hideinitializer */
#define GPIO_IOP5MD_P54MD_UART5_RX            (0x03UL<<GPIO_IOP5MD_P54MD_Pos)     /*!< UART5 data input pin. \hideinitializer */

#define GPIO_IOP5MD_P55MD_GPIO                (0x00UL<<GPIO_IOP5MD_P55MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP5MD_P55MD_TM24B               (0x01UL<<GPIO_IOP5MD_P55MD_Pos)     /*!< Timer 24 input/output pin B. \hideinitializer */
#define GPIO_IOP5MD_P55MD_CMP3_CMPOT31        (0x02UL<<GPIO_IOP5MD_P55MD_Pos)     /*!< Comparator 31 output pin. \hideinitializer */
#define GPIO_IOP5MD_P55MD_SPI6_SBO            (0x03UL<<GPIO_IOP5MD_P55MD_Pos)     /*!< SPI6 data input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP5MD_P55MD_UART6_TX            (0x03UL<<GPIO_IOP5MD_P55MD_Pos)     /*!< UART6 data input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP5MD_P55MD_SPI6_SBT            (0x04UL<<GPIO_IOP5MD_P55MD_Pos)     /*!< SPI6 clock input/output (Use Nch open-drain) pin. \hideinitializer */

#define GPIO_IOP5MD_P56MD_GPIO                (0x00UL<<GPIO_IOP5MD_P56MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP5MD_P56MD_TM25A               (0x01UL<<GPIO_IOP5MD_P56MD_Pos)     /*!< Timer 25 input/output pin A. \hideinitializer */
#define GPIO_IOP5MD_P56MD_CMP4_CMPOT41        (0x02UL<<GPIO_IOP5MD_P56MD_Pos)     /*!< Comparator 41 output pin. \hideinitializer */
#define GPIO_IOP5MD_P56MD_SPI6_SBT            (0x03UL<<GPIO_IOP5MD_P56MD_Pos)     /*!< SPI6 clock input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP5MD_P56MD_SPI6_SBO            (0x04UL<<GPIO_IOP5MD_P56MD_Pos)     /*!< SPI6 data input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP5MD_P56MD_UART6_TX            (0x04UL<<GPIO_IOP5MD_P56MD_Pos)     /*!< UART6 data input/output (Use Nch open-drain) pin. \hideinitializer */

#define GPIO_IOP5MD_P57MD_GPIO                (0x00UL<<GPIO_IOP5MD_P57MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP5MD_P57MD_TM25B               (0x01UL<<GPIO_IOP5MD_P57MD_Pos)     /*!< Timer 25 input/output pin B. \hideinitializer */
#define GPIO_IOP5MD_P57MD_SPI6_SBI            (0x02UL<<GPIO_IOP5MD_P57MD_Pos)     /*!< SPI6 data input pin. \hideinitializer */
#define GPIO_IOP5MD_P57MD_UART6_RX            (0x02UL<<GPIO_IOP5MD_P57MD_Pos)     /*!< UART6 data input pin. \hideinitializer */

/********************* Bit definition of IOP6MD register **********************/
#define GPIO_IOP6MD_P60MD_GPIO                (0x00UL<<GPIO_IOP6MD_P60MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP6MD_P60MD_TM03A               (0x01UL<<GPIO_IOP6MD_P60MD_Pos)     /*!< Timer 3 input/output pin A. \hideinitializer */
#define GPIO_IOP6MD_P60MD_GPWM5_GPWMST5       (0x02UL<<GPIO_IOP6MD_P60MD_Pos)     /*!< GPWM5 count state output pin. \hideinitializer */
#define GPIO_IOP6MD_P60MD_SPI4_SBI            (0x03UL<<GPIO_IOP6MD_P60MD_Pos)     /*!< SPI4 data input pin. \hideinitializer */
#define GPIO_IOP6MD_P60MD_UART4_RX            (0x03UL<<GPIO_IOP6MD_P60MD_Pos)     /*!< UART4 data input pin. \hideinitializer */
#define GPIO_IOP6MD_P60MD_SPI7_SBI            (0x04UL<<GPIO_IOP6MD_P60MD_Pos)     /*!< SPI7 data input pin. \hideinitializer */
#define GPIO_IOP6MD_P60MD_UART7_RX            (0x04UL<<GPIO_IOP6MD_P60MD_Pos)     /*!< UART7 data input pin. \hideinitializer */

#define GPIO_IOP6MD_P61MD_GPIO                (0x00UL<<GPIO_IOP6MD_P61MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP6MD_P61MD_TM03B               (0x01UL<<GPIO_IOP6MD_P61MD_Pos)     /*!< Timer 3 input/output pin B. \hideinitializer */
#define GPIO_IOP6MD_P61MD_GPWM6_GPWMST6       (0x02UL<<GPIO_IOP6MD_P61MD_Pos)     /*!< GPWM6 count state output pin. \hideinitializer */
#define GPIO_IOP6MD_P61MD_SPI4_SBO            (0x03UL<<GPIO_IOP6MD_P61MD_Pos)     /*!< SPI4 data input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP6MD_P61MD_UART4_TX            (0x03UL<<GPIO_IOP6MD_P61MD_Pos)     /*!< UART4 data input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP6MD_P61MD_SPI4_SBT            (0x04UL<<GPIO_IOP6MD_P61MD_Pos)     /*!< SPI4 clock input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP6MD_P61MD_SPI7_SBO            (0x05UL<<GPIO_IOP6MD_P61MD_Pos)     /*!< SPI7 data input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP6MD_P61MD_UART7_TX            (0x05UL<<GPIO_IOP6MD_P61MD_Pos)     /*!< UART7 data input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP6MD_P61MD_IIC7_SDA            (0x05UL<<GPIO_IOP6MD_P61MD_Pos)     /*!< IIC7 data input/ouput (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP6MD_P61MD_SPI7_SBT            (0x06UL<<GPIO_IOP6MD_P61MD_Pos)     /*!< SPI7 clock input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP6MD_P61MD_IIC7_SCL            (0x06UL<<GPIO_IOP6MD_P61MD_Pos)     /*!< IIC7 clock input/ouput (Use Nch open-drain) pin. \hideinitializer */

#define GPIO_IOP6MD_P62MD_GPIO                (0x00UL<<GPIO_IOP6MD_P62MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP6MD_P62MD_TM04A               (0x01UL<<GPIO_IOP6MD_P62MD_Pos)     /*!< Timer 4 input/output pin A. \hideinitializer */
#define GPIO_IOP6MD_P62MD_GPWM7_GPWMST7       (0x02UL<<GPIO_IOP6MD_P62MD_Pos)     /*!< GPWM7 count state output pin. \hideinitializer */
#define GPIO_IOP6MD_P62MD_SPI4_SBT            (0x03UL<<GPIO_IOP6MD_P62MD_Pos)     /*!< SPI4 clock input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP6MD_P62MD_SPI4_SBO            (0x04UL<<GPIO_IOP6MD_P62MD_Pos)     /*!< SPI4 data input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP6MD_P62MD_UART4_TX            (0x04UL<<GPIO_IOP6MD_P62MD_Pos)     /*!< UART4 data input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP6MD_P62MD_SPI7_SBT            (0x05UL<<GPIO_IOP6MD_P62MD_Pos)     /*!< SPI7 clock input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP6MD_P62MD_IIC7_SCL            (0x05UL<<GPIO_IOP6MD_P62MD_Pos)     /*!< IIC7 clock input/ouput (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP6MD_P62MD_SPI7_SBO            (0x06UL<<GPIO_IOP6MD_P62MD_Pos)     /*!< SPI7 data input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP6MD_P62MD_UART7_TX            (0x06UL<<GPIO_IOP6MD_P62MD_Pos)     /*!< UART7 data input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP6MD_P62MD_IIC7_SDA            (0x06UL<<GPIO_IOP6MD_P62MD_Pos)     /*!< IIC7 data input/ouput (Use Nch open-drain) pin. \hideinitializer */

#define GPIO_IOP6MD_P63MD_GPIO                (0x00UL<<GPIO_IOP6MD_P63MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP6MD_P63MD_TM04B               (0x01UL<<GPIO_IOP6MD_P63MD_Pos)     /*!< Timer 4 input/output pin B. \hideinitializer */
#define GPIO_IOP6MD_P63MD_GPWM8_GPWMST8       (0x02UL<<GPIO_IOP6MD_P63MD_Pos)     /*!< GPWM8 count state output pin. \hideinitializer */
#define GPIO_IOP6MD_P63MD_SPI4_SBCS           (0x03UL<<GPIO_IOP6MD_P63MD_Pos)     /*!< SPI4 chip select input/output (Use Nch open-drain) pin. \hideinitializer */
#define GPIO_IOP6MD_P63MD_SPI7_SBCS           (0x04UL<<GPIO_IOP6MD_P63MD_Pos)     /*!< SPI7 chip select input/output (Use Nch open-drain) pin. \hideinitializer */

#define GPIO_IOP6MD_P64MD_GPIO                (0x00UL<<GPIO_IOP6MD_P64MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP6MD_P64MD_TM05A               (0x01UL<<GPIO_IOP6MD_P64MD_Pos)     /*!< Timer 5 input/output pin A. \hideinitializer */

#define GPIO_IOP6MD_P65MD_GPIO                (0x00UL<<GPIO_IOP6MD_P65MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP6MD_P65MD_TM05B               (0x01UL<<GPIO_IOP6MD_P65MD_Pos)     /*!< Timer 5 input/output pin B. \hideinitializer */

#define GPIO_IOP6MD_P66MD_GPIO                (0x00UL<<GPIO_IOP6MD_P66MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */

#define GPIO_IOP6MD_P67MD_GPIO                (0x00UL<<GPIO_IOP6MD_P67MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */

/********************* Bit definition of IOP7MD register **********************/
#define GPIO_IOP7MD_P70MD_GPIO                (0x00UL<<GPIO_IOP7MD_P70MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP7MD_P70MD_GPWM9_GPWM90        (0x01UL<<GPIO_IOP7MD_P70MD_Pos)     /*!< GPWM90 output pin. \hideinitializer */
#define GPIO_IOP7MD_P70MD_TM09A               (0x02UL<<GPIO_IOP7MD_P70MD_Pos)     /*!< Timer 9 input/output pin A. \hideinitializer */

#define GPIO_IOP7MD_P71MD_GPIO                (0x00UL<<GPIO_IOP7MD_P71MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP7MD_P71MD_GPWM9_GPWM91        (0x01UL<<GPIO_IOP7MD_P71MD_Pos)     /*!< GPWM91 output pin. \hideinitializer */
#define GPIO_IOP7MD_P71MD_TM09B               (0x02UL<<GPIO_IOP7MD_P71MD_Pos)     /*!< Timer 9 input/output pin B. \hideinitializer */

#define GPIO_IOP7MD_P72MD_GPIO                (0x00UL<<GPIO_IOP7MD_P72MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP7MD_P72MD_GPWMA_GPWMA0        (0x01UL<<GPIO_IOP7MD_P72MD_Pos)     /*!< GPWMA0 output pin. \hideinitializer */
#define GPIO_IOP7MD_P72MD_TM10A               (0x02UL<<GPIO_IOP7MD_P72MD_Pos)     /*!< Timer 10 input/output pin A. \hideinitializer */

#define GPIO_IOP7MD_P73MD_GPIO                (0x00UL<<GPIO_IOP7MD_P73MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP7MD_P73MD_GPWMA_GPWMA1        (0x01UL<<GPIO_IOP7MD_P73MD_Pos)     /*!< GPWMA1 output pin. \hideinitializer */
#define GPIO_IOP7MD_P73MD_TM10B               (0x02UL<<GPIO_IOP7MD_P73MD_Pos)     /*!< Timer 10 input/output pin B. \hideinitializer */

#define GPIO_IOP7MD_P74MD_GPIO                (0x00UL<<GPIO_IOP7MD_P74MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP7MD_P74MD_TM11A               (0x01UL<<GPIO_IOP7MD_P74MD_Pos)     /*!< Timer 11 input/output pin A. \hideinitializer */
#define GPIO_IOP7MD_P74MD_GPWM3_GPWMST3       (0x02UL<<GPIO_IOP7MD_P74MD_Pos)     /*!< GPWM3 count state output pin. \hideinitializer */

#define GPIO_IOP7MD_P75MD_GPIO                (0x00UL<<GPIO_IOP7MD_P75MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP7MD_P75MD_TM11B               (0x01UL<<GPIO_IOP7MD_P75MD_Pos)     /*!< Timer 11 input/output pin B. \hideinitializer */
#define GPIO_IOP7MD_P75MD_GPWM4_GPWMST4       (0x02UL<<GPIO_IOP7MD_P75MD_Pos)     /*!< GPWM4 count state output pin. \hideinitializer */

#define GPIO_IOP7MD_P76MD_GPIO                (0x00UL<<GPIO_IOP7MD_P76MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */

#define GPIO_IOP7MD_P77MD_GPIO                (0x00UL<<GPIO_IOP7MD_P77MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */

/********************* Bit definition of IOP8MD register **********************/
#define GPIO_IOP8MD_P80MD_GPIO                (0x00UL<<GPIO_IOP8MD_P80MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP8MD_P80MD_GPWM0_GPWMH00       (0x01UL<<GPIO_IOP8MD_P80MD_Pos)     /*!< GPWM00 high-resolution output pin. \hideinitializer */
#define GPIO_IOP8MD_P80MD_GPWM0_GPWM00        (0x02UL<<GPIO_IOP8MD_P80MD_Pos)     /*!< GPWM00 output pin. \hideinitializer */

#define GPIO_IOP8MD_P81MD_GPIO                (0x00UL<<GPIO_IOP8MD_P81MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP8MD_P81MD_GPWM0_GPWMH01       (0x01UL<<GPIO_IOP8MD_P81MD_Pos)     /*!< GPWM01 high-resolution output pin. \hideinitializer */
#define GPIO_IOP8MD_P81MD_GPWM0_GPWM01        (0x02UL<<GPIO_IOP8MD_P81MD_Pos)     /*!< GPWM01 output pin. \hideinitializer */

#define GPIO_IOP8MD_P82MD_GPIO                (0x00UL<<GPIO_IOP8MD_P82MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP8MD_P82MD_GPWM1_GPWMH10       (0x01UL<<GPIO_IOP8MD_P82MD_Pos)     /*!< GPWM10 high-resolution output pin. \hideinitializer */
#define GPIO_IOP8MD_P82MD_GPWM1_GPWM10        (0x02UL<<GPIO_IOP8MD_P82MD_Pos)     /*!< GPWM10 output pin. \hideinitializer */

#define GPIO_IOP8MD_P83MD_GPIO                (0x00UL<<GPIO_IOP8MD_P83MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP8MD_P83MD_GPWM1_GPWMH11       (0x01UL<<GPIO_IOP8MD_P83MD_Pos)     /*!< GPWM11 high-resolution output pin. \hideinitializer */
#define GPIO_IOP8MD_P83MD_GPWM1_GPWM11        (0x02UL<<GPIO_IOP8MD_P83MD_Pos)     /*!< GPWM11 output pin. \hideinitializer */

#define GPIO_IOP8MD_P84MD_GPIO                (0x00UL<<GPIO_IOP8MD_P84MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP8MD_P84MD_GPWM2_GPWMH20       (0x01UL<<GPIO_IOP8MD_P84MD_Pos)     /*!< GPWM20 high-resolution output pin. \hideinitializer */
#define GPIO_IOP8MD_P84MD_GPWM2_GPWM20        (0x02UL<<GPIO_IOP8MD_P84MD_Pos)     /*!< GPWM20 output pin. \hideinitializer */

#define GPIO_IOP8MD_P85MD_GPIO                (0x00UL<<GPIO_IOP8MD_P85MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP8MD_P85MD_GPWM2_GPWMH21       (0x01UL<<GPIO_IOP8MD_P85MD_Pos)     /*!< GPWM21 high-resolution output pin. \hideinitializer */
#define GPIO_IOP8MD_P85MD_GPWM2_GPWM21        (0x02UL<<GPIO_IOP8MD_P85MD_Pos)     /*!< GPWM21 output pin. \hideinitializer */

#define GPIO_IOP8MD_P86MD_GPIO                (0x00UL<<GPIO_IOP8MD_P86MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP8MD_P86MD_TM06A               (0x01UL<<GPIO_IOP8MD_P86MD_Pos)     /*!< Timer 6 input/output pin A. \hideinitializer */

#define GPIO_IOP8MD_P87MD_GPIO                (0x00UL<<GPIO_IOP8MD_P87MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP8MD_P87MD_TM06B               (0x01UL<<GPIO_IOP8MD_P87MD_Pos)     /*!< Timer 6 input/output pin B. \hideinitializer */

/********************* Bit definition of IOP9MD register **********************/
#define GPIO_IOP9MD_P90MD_GPIO                (0x00UL<<GPIO_IOP9MD_P90MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP9MD_P90MD_GPWM3_GPWMH30       (0x01UL<<GPIO_IOP9MD_P90MD_Pos)     /*!< GPWM30 high-resolution output pin. \hideinitializer */
#define GPIO_IOP9MD_P90MD_GPWM3_GPWM30        (0x02UL<<GPIO_IOP9MD_P90MD_Pos)     /*!< GPWM30 output pin. \hideinitializer */

#define GPIO_IOP9MD_P91MD_GPIO                (0x00UL<<GPIO_IOP9MD_P91MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP9MD_P91MD_GPWM3_GPWMH31       (0x01UL<<GPIO_IOP9MD_P91MD_Pos)     /*!< GPWM31 high-resolution output pin. \hideinitializer */
#define GPIO_IOP9MD_P91MD_GPWM3_GPWM31        (0x02UL<<GPIO_IOP9MD_P91MD_Pos)     /*!< GPWM31 output pin. \hideinitializer */

#define GPIO_IOP9MD_P92MD_GPIO                (0x00UL<<GPIO_IOP9MD_P92MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP9MD_P92MD_GPWM4_GPWMH40       (0x01UL<<GPIO_IOP9MD_P92MD_Pos)     /*!< GPWM40 high-resolution output pin. \hideinitializer */
#define GPIO_IOP9MD_P92MD_GPWM4_GPWM40        (0x02UL<<GPIO_IOP9MD_P92MD_Pos)     /*!< GPWM40 output pin. \hideinitializer */

#define GPIO_IOP9MD_P93MD_GPIO                (0x00UL<<GPIO_IOP9MD_P93MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP9MD_P93MD_GPWM4_GPWMH41       (0x01UL<<GPIO_IOP9MD_P93MD_Pos)     /*!< GPWM41 high-resolution output pin. \hideinitializer */
#define GPIO_IOP9MD_P93MD_GPWM4_GPWM41        (0x02UL<<GPIO_IOP9MD_P93MD_Pos)     /*!< GPWM41 output pin. \hideinitializer */

#define GPIO_IOP9MD_P94MD_GPIO                (0x00UL<<GPIO_IOP9MD_P94MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP9MD_P94MD_GPWM5_GPWMH50       (0x01UL<<GPIO_IOP9MD_P94MD_Pos)     /*!< GPWM50 high-resolution output pin. \hideinitializer */
#define GPIO_IOP9MD_P94MD_GPWM5_GPWM50        (0x02UL<<GPIO_IOP9MD_P94MD_Pos)     /*!< GPWM50 output pin. \hideinitializer */

#define GPIO_IOP9MD_P95MD_GPIO                (0x00UL<<GPIO_IOP9MD_P95MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOP9MD_P95MD_GPWM5_GPWMH51       (0x01UL<<GPIO_IOP9MD_P95MD_Pos)     /*!< GPWM51 high-resolution output pin. \hideinitializer */
#define GPIO_IOP9MD_P95MD_GPWM5_GPWM51        (0x02UL<<GPIO_IOP9MD_P95MD_Pos)     /*!< GPWM51 output pin. \hideinitializer */

#define GPIO_IOP9MD_P96MD_GPIO                (0x00UL<<GPIO_IOP9MD_P96MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */

#define GPIO_IOP9MD_P97MD_GPIO                (0x00UL<<GPIO_IOP9MD_P97MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */

/********************* Bit definition of IOPAMD register **********************/
#define GPIO_IOPAMD_PA0MD_GPIO                (0x00UL<<GPIO_IOPAMD_PA0MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOPAMD_PA0MD_GPWM6_GPWMH60       (0x01UL<<GPIO_IOPAMD_PA0MD_Pos)     /*!< GPWM60 high-resolution output pin. \hideinitializer */
#define GPIO_IOPAMD_PA0MD_GPWM6_GPWM60        (0x02UL<<GPIO_IOPAMD_PA0MD_Pos)     /*!< GPWM60 output pin. \hideinitializer */

#define GPIO_IOPAMD_PA1MD_GPIO                (0x00UL<<GPIO_IOPAMD_PA1MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOPAMD_PA1MD_GPWM6_GPWMH61       (0x01UL<<GPIO_IOPAMD_PA1MD_Pos)     /*!< GPWM61 high-resolution output pin. \hideinitializer */
#define GPIO_IOPAMD_PA1MD_GPWM6_GPWM61        (0x02UL<<GPIO_IOPAMD_PA1MD_Pos)     /*!< GPWM61 output pin. \hideinitializer */

#define GPIO_IOPAMD_PA2MD_GPIO                (0x00UL<<GPIO_IOPAMD_PA2MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOPAMD_PA2MD_GPWM7_GPWMH70       (0x01UL<<GPIO_IOPAMD_PA2MD_Pos)     /*!< GPWM70 high-resolution output pin. \hideinitializer */
#define GPIO_IOPAMD_PA2MD_GPWM7_GPWM70        (0x02UL<<GPIO_IOPAMD_PA2MD_Pos)     /*!< GPWM70 output pin. \hideinitializer */

#define GPIO_IOPAMD_PA3MD_GPIO                (0x00UL<<GPIO_IOPAMD_PA3MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOPAMD_PA3MD_GPWM7_GPWMH71       (0x01UL<<GPIO_IOPAMD_PA3MD_Pos)     /*!< GPWM71 high-resolution output pin. \hideinitializer */
#define GPIO_IOPAMD_PA3MD_GPWM7_GPWM71        (0x02UL<<GPIO_IOPAMD_PA3MD_Pos)     /*!< GPWM71 output pin. \hideinitializer */

#define GPIO_IOPAMD_PA4MD_GPIO                (0x00UL<<GPIO_IOPAMD_PA4MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOPAMD_PA4MD_GPWM8_GPWMH80       (0x01UL<<GPIO_IOPAMD_PA4MD_Pos)     /*!< GPWM80 high-resolution output pin. \hideinitializer */
#define GPIO_IOPAMD_PA4MD_GPWM8_GPWM80        (0x02UL<<GPIO_IOPAMD_PA4MD_Pos)     /*!< GPWM80 output pin. \hideinitializer */

#define GPIO_IOPAMD_PA5MD_GPIO                (0x00UL<<GPIO_IOPAMD_PA5MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOPAMD_PA5MD_GPWM8_GPWMH81       (0x01UL<<GPIO_IOPAMD_PA5MD_Pos)     /*!< GPWM81 high-resolution output pin. \hideinitializer */
#define GPIO_IOPAMD_PA5MD_GPWM8_GPWM81        (0x02UL<<GPIO_IOPAMD_PA5MD_Pos)     /*!< GPWM81 output pin. \hideinitializer */

#define GPIO_IOPAMD_PA6MD_GPIO                (0x00UL<<GPIO_IOPAMD_PA6MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */

#define GPIO_IOPAMD_PA7MD_GPIO                (0x00UL<<GPIO_IOPAMD_PA7MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */

/********************* Bit definition of IOPBMD register **********************/
#define GPIO_IOPBMD_PB0MD_GPIO                (0x00UL<<GPIO_IOPBMD_PB0MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOPBMD_PB0MD_GPWMB_GPWMB0        (0x01UL<<GPIO_IOPBMD_PB0MD_Pos)     /*!< GPWMB0 output pin. \hideinitializer */

#define GPIO_IOPBMD_PB1MD_GPIO                (0x00UL<<GPIO_IOPBMD_PB1MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOPBMD_PB1MD_GPWMB_GPWMB1        (0x01UL<<GPIO_IOPBMD_PB1MD_Pos)     /*!< GPWMB1 output pin. \hideinitializer */

#define GPIO_IOPBMD_PB2MD_GPIO                (0x00UL<<GPIO_IOPBMD_PB2MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */

#define GPIO_IOPBMD_PB3MD_GPIO                (0x00UL<<GPIO_IOPBMD_PB3MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */

#define GPIO_IOPBMD_PB4MD_GPIO                (0x00UL<<GPIO_IOPBMD_PB4MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */

#define GPIO_IOPBMD_PB6MD_GPIO                (0x00UL<<GPIO_IOPBMD_PB6MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */

#define GPIO_IOPBMD_PB7MD_GPIO                (0x00UL<<GPIO_IOPBMD_PB7MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */

/********************* Bit definition of IOPCMD register **********************/
#define GPIO_IOPCMD_PC0MD_GPIO                (0x00UL<<GPIO_IOPCMD_PC0MD_Pos)     /*!< General-purpose input pin. \hideinitializer */
#define GPIO_IOPCMD_PC0MD_ADIN00              (0x01UL<<GPIO_IOPCMD_PC0MD_Pos)     /*!< A/D converter analog input 00 pin. \hideinitializer */
#define GPIO_IOPCMD_PC0MD_VGA0_VGAN           (0x01UL<<GPIO_IOPCMD_PC0MD_Pos)     /*!< VGA0 negative input pin. \hideinitializer */

#define GPIO_IOPCMD_PC1MD_GPIO                (0x00UL<<GPIO_IOPCMD_PC1MD_Pos)     /*!< General-purpose input pin. \hideinitializer */
#define GPIO_IOPCMD_PC1MD_ADIN01              (0x01UL<<GPIO_IOPCMD_PC1MD_Pos)     /*!< A/D converter analog input 01 pin. \hideinitializer */
#define GPIO_IOPCMD_PC1MD_VGA0_VGAP0          (0x01UL<<GPIO_IOPCMD_PC1MD_Pos)     /*!< VGA0 positive 0 input pin. \hideinitializer */
#define GPIO_IOPCMD_PC1MD_CMP0_CMPIN0         (0x01UL<<GPIO_IOPCMD_PC1MD_Pos)     /*!< Comparator 00/01 input pin. \hideinitializer */

#define GPIO_IOPCMD_PC2MD_GPIO                (0x00UL<<GPIO_IOPCMD_PC2MD_Pos)     /*!< General-purpose input pin. \hideinitializer */
#define GPIO_IOPCMD_PC2MD_ADIN02              (0x01UL<<GPIO_IOPCMD_PC2MD_Pos)     /*!< A/D converter analog input 02 pin. \hideinitializer */
#define GPIO_IOPCMD_PC2MD_VGA0_VGAP1          (0x01UL<<GPIO_IOPCMD_PC2MD_Pos)     /*!< VGA0 positive 1 input pin. \hideinitializer */
#define GPIO_IOPCMD_PC2MD_CMP1_CMPIN1         (0x01UL<<GPIO_IOPCMD_PC2MD_Pos)     /*!< Comparator 10/11 input pin. \hideinitializer */

#define GPIO_IOPCMD_PC3MD_GPIO                (0x00UL<<GPIO_IOPCMD_PC3MD_Pos)     /*!< General-purpose input pin. \hideinitializer */
#define GPIO_IOPCMD_PC3MD_ADIN03              (0x01UL<<GPIO_IOPCMD_PC3MD_Pos)     /*!< A/D converter analog input 03 pin. \hideinitializer */
#define GPIO_IOPCMD_PC3MD_VGA0_VGAP2          (0x01UL<<GPIO_IOPCMD_PC3MD_Pos)     /*!< VGA0 positive 2 input pin. \hideinitializer */
#define GPIO_IOPCMD_PC3MD_CMP2_CMPIN2         (0x01UL<<GPIO_IOPCMD_PC3MD_Pos)     /*!< Comparator 20/21 input pin. \hideinitializer */

#define GPIO_IOPCMD_PC4MD_GPIO                (0x00UL<<GPIO_IOPCMD_PC4MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOPCMD_PC4MD_ADIN04              (0x01UL<<GPIO_IOPCMD_PC4MD_Pos)     /*!< A/D converter analog input 04 pin. \hideinitializer */

#define GPIO_IOPCMD_PC5MD_GPIO                (0x00UL<<GPIO_IOPCMD_PC5MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOPCMD_PC5MD_ADIN05              (0x01UL<<GPIO_IOPCMD_PC5MD_Pos)     /*!< A/D converter analog input 05 pin. \hideinitializer */

#define GPIO_IOPCMD_PC6MD_GPIO                (0x00UL<<GPIO_IOPCMD_PC6MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOPCMD_PC6MD_ADIN06              (0x01UL<<GPIO_IOPCMD_PC6MD_Pos)     /*!< A/D converter analog input 06 pin. \hideinitializer */

#define GPIO_IOPCMD_PC7MD_GPIO                (0x00UL<<GPIO_IOPCMD_PC7MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOPCMD_PC7MD_ADIN07              (0x01UL<<GPIO_IOPCMD_PC7MD_Pos)     /*!< A/D converter analog input 07 pin. \hideinitializer */

/********************* Bit definition of IOPDMD register **********************/
#define GPIO_IOPDMD_PD0MD_GPIO                (0x00UL<<GPIO_IOPDMD_PD0MD_Pos)     /*!< General-purpose input pin. \hideinitializer */
#define GPIO_IOPDMD_PD0MD_ADIN08              (0x01UL<<GPIO_IOPDMD_PD0MD_Pos)     /*!< A/D converter analog input 08 pin. \hideinitializer */
#define GPIO_IOPDMD_PD0MD_VGA1_VGAN           (0x01UL<<GPIO_IOPDMD_PD0MD_Pos)     /*!< VGA1 negative input pin. \hideinitializer */

#define GPIO_IOPDMD_PD1MD_GPIO                (0x00UL<<GPIO_IOPDMD_PD1MD_Pos)     /*!< General-purpose input pin. \hideinitializer */
#define GPIO_IOPDMD_PD1MD_ADIN09              (0x01UL<<GPIO_IOPDMD_PD1MD_Pos)     /*!< A/D converter analog input 09 pin. \hideinitializer */
#define GPIO_IOPDMD_PD1MD_VGA1_VGAP           (0x01UL<<GPIO_IOPDMD_PD1MD_Pos)     /*!< VGA1 positive input pin. \hideinitializer */
#define GPIO_IOPDMD_PD1MD_CMP3_CMPIN3         (0x01UL<<GPIO_IOPDMD_PD1MD_Pos)     /*!< Comparator 30/31 input pin. \hideinitializer */

#define GPIO_IOPDMD_PD2MD_GPIO                (0x00UL<<GPIO_IOPDMD_PD2MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOPDMD_PD2MD_ADIN10              (0x01UL<<GPIO_IOPDMD_PD2MD_Pos)     /*!< A/D converter analog input 10 pin. \hideinitializer */

#define GPIO_IOPDMD_PD3MD_GPIO                (0x00UL<<GPIO_IOPDMD_PD3MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOPDMD_PD3MD_ADIN11              (0x01UL<<GPIO_IOPDMD_PD3MD_Pos)     /*!< A/D converter analog input 11 pin. \hideinitializer */

#define GPIO_IOPDMD_PD4MD_GPIO                (0x00UL<<GPIO_IOPDMD_PD4MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOPDMD_PD4MD_ADIN12              (0x01UL<<GPIO_IOPDMD_PD4MD_Pos)     /*!< A/D converter analog input 12 pin. \hideinitializer */

#define GPIO_IOPDMD_PD5MD_GPIO                (0x00UL<<GPIO_IOPDMD_PD5MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOPDMD_PD5MD_ADIN13              (0x01UL<<GPIO_IOPDMD_PD5MD_Pos)     /*!< A/D converter analog input 13 pin. \hideinitializer */

#define GPIO_IOPDMD_PD6MD_GPIO                (0x00UL<<GPIO_IOPDMD_PD6MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOPDMD_PD6MD_ADIN14              (0x01UL<<GPIO_IOPDMD_PD6MD_Pos)     /*!< A/D converter analog input 14 pin. \hideinitializer */

#define GPIO_IOPDMD_PD7MD_GPIO                (0x00UL<<GPIO_IOPDMD_PD7MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOPDMD_PD7MD_ADIN15              (0x01UL<<GPIO_IOPDMD_PD7MD_Pos)     /*!< A/D converter analog input 15 pin. \hideinitializer */

/********************* Bit definition of IOPEMD register **********************/
#define GPIO_IOPEMD_PE0MD_GPIO                (0x00UL<<GPIO_IOPEMD_PE0MD_Pos)     /*!< General-purpose input pin. \hideinitializer */
#define GPIO_IOPEMD_PE0MD_ADIN16              (0x01UL<<GPIO_IOPEMD_PE0MD_Pos)     /*!< A/D converter analog input 16 pin. \hideinitializer */
#define GPIO_IOPEMD_PE0MD_VGA2_VGAP           (0x01UL<<GPIO_IOPEMD_PE0MD_Pos)     /*!< VGA2 positive input pin. \hideinitializer */
#define GPIO_IOPEMD_PE0MD_CMP4_CMPIN4         (0x01UL<<GPIO_IOPEMD_PE0MD_Pos)     /*!< Comparator 40/41 input pin. \hideinitializer */

#define GPIO_IOPEMD_PE1MD_GPIO                (0x00UL<<GPIO_IOPEMD_PE1MD_Pos)     /*!< General-purpose input pin. \hideinitializer */
#define GPIO_IOPEMD_PE1MD_ADIN17              (0x01UL<<GPIO_IOPEMD_PE1MD_Pos)     /*!< A/D converter analog input 17 pin. \hideinitializer */
#define GPIO_IOPEMD_PE1MD_VGA2_VGAN           (0x01UL<<GPIO_IOPEMD_PE1MD_Pos)     /*!< VGA2 negative input pin. \hideinitializer */

#define GPIO_IOPEMD_PE2MD_GPIO                (0x00UL<<GPIO_IOPEMD_PE2MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOPEMD_PE2MD_ADIN18              (0x01UL<<GPIO_IOPEMD_PE2MD_Pos)     /*!< A/D converter analog input 18 pin. \hideinitializer */

#define GPIO_IOPEMD_PE3MD_GPIO                (0x00UL<<GPIO_IOPEMD_PE3MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOPEMD_PE3MD_ADIN19              (0x01UL<<GPIO_IOPEMD_PE3MD_Pos)     /*!< A/D converter analog input 19 pin. \hideinitializer */

#define GPIO_IOPEMD_PE4MD_GPIO                (0x00UL<<GPIO_IOPEMD_PE4MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOPEMD_PE4MD_ADIN20              (0x01UL<<GPIO_IOPEMD_PE4MD_Pos)     /*!< A/D converter analog input 20 pin. \hideinitializer */

#define GPIO_IOPEMD_PE5MD_GPIO                (0x00UL<<GPIO_IOPEMD_PE5MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOPEMD_PE5MD_ADIN21              (0x01UL<<GPIO_IOPEMD_PE5MD_Pos)     /*!< A/D converter analog input 21 pin. \hideinitializer */

#define GPIO_IOPEMD_PE6MD_GPIO                (0x00UL<<GPIO_IOPEMD_PE6MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOPEMD_PE6MD_ADIN22              (0x01UL<<GPIO_IOPEMD_PE6MD_Pos)     /*!< A/D converter analog input 22 pin. \hideinitializer */

#define GPIO_IOPEMD_PE7MD_GPIO                (0x00UL<<GPIO_IOPEMD_PE7MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOPEMD_PE7MD_ADIN23              (0x01UL<<GPIO_IOPEMD_PE7MD_Pos)     /*!< A/D converter analog input 23 pin. \hideinitializer */

/********************* Bit definition of IOPFMD register **********************/
#define GPIO_IOPFMD_PF0MD_GPIO                (0x00UL<<GPIO_IOPFMD_PF0MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOPFMD_PF0MD_ADIN24              (0x01UL<<GPIO_IOPFMD_PF0MD_Pos)     /*!< A/D converter analog input 24 pin. \hideinitializer */

#define GPIO_IOPFMD_PF1MD_GPIO                (0x00UL<<GPIO_IOPFMD_PF1MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOPFMD_PF1MD_ADIN25              (0x01UL<<GPIO_IOPFMD_PF1MD_Pos)     /*!< A/D converter analog input 25 pin. \hideinitializer */

#define GPIO_IOPFMD_PF2MD_GPIO                (0x00UL<<GPIO_IOPFMD_PF2MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOPFMD_PF2MD_ADIN26              (0x01UL<<GPIO_IOPFMD_PF2MD_Pos)     /*!< A/D converter analog input 26 pin. \hideinitializer */

#define GPIO_IOPFMD_PF3MD_GPIO                (0x00UL<<GPIO_IOPFMD_PF3MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOPFMD_PF3MD_ADIN27              (0x01UL<<GPIO_IOPFMD_PF3MD_Pos)     /*!< A/D converter analog input 27 pin. \hideinitializer */

#define GPIO_IOPFMD_PF4MD_GPIO                (0x00UL<<GPIO_IOPFMD_PF4MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOPFMD_PF4MD_ADIN28              (0x01UL<<GPIO_IOPFMD_PF4MD_Pos)     /*!< A/D converter analog input 28 pin. \hideinitializer */

#define GPIO_IOPFMD_PF5MD_GPIO                (0x00UL<<GPIO_IOPFMD_PF5MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOPFMD_PF5MD_ADIN29              (0x01UL<<GPIO_IOPFMD_PF5MD_Pos)     /*!< A/D converter analog input 29 pin. \hideinitializer */

#define GPIO_IOPFMD_PF6MD_GPIO                (0x00UL<<GPIO_IOPFMD_PF6MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOPFMD_PF6MD_ADIN30              (0x01UL<<GPIO_IOPFMD_PF6MD_Pos)     /*!< A/D converter analog input 30 pin. \hideinitializer */

#define GPIO_IOPFMD_PF7MD_GPIO                (0x00UL<<GPIO_IOPFMD_PF7MD_Pos)     /*!< General-purpose input/output pin. \hideinitializer */
#define GPIO_IOPFMD_PF7MD_ADIN31              (0x01UL<<GPIO_IOPFMD_PF7MD_Pos)     /*!< A/D converter analog input 31 pin. \hideinitializer */

/*---------------------------------------------------------------------------------------------------------*/
/*  Specify Maximum External Interrupt                                                                     */
/*---------------------------------------------------------------------------------------------------------*/
#define EXIRQ_PIN_MAX           (20)    /*!< Specify Maximum Pins of Each GPIO Port \hideinitializer */

/*---------------------------------------------------------------------------------------------------------*/
/*  External Interrupt Pin No. Definitions                                                                 */
/*---------------------------------------------------------------------------------------------------------*/
#define EXIRQ00                 (0)     /*!< External Interrupt 0 (IRQ00) \hideinitializer */
#define EXIRQ01                 (1)     /*!< External Interrupt 1 (IRQ01) \hideinitializer */
#define EXIRQ02                 (2)     /*!< External Interrupt 2 (IRQ02) \hideinitializer */
#define EXIRQ03                 (3)     /*!< External Interrupt 3 (IRQ03) \hideinitializer */
#define EXIRQ04                 (4)     /*!< External Interrupt 4 (IRQ04) \hideinitializer */
#define EXIRQ05                 (5)     /*!< External Interrupt 5 (IRQ05) \hideinitializer */
#define EXIRQ06                 (6)     /*!< External Interrupt 6 (IRQ06) \hideinitializer */
#define EXIRQ07                 (7)     /*!< External Interrupt 7 (IRQ07) \hideinitializer */
#define EXIRQ08                 (8)     /*!< External Interrupt 8 (IRQ08) \hideinitializer */
#define EXIRQ09                 (9)     /*!< External Interrupt 9 (IRQ09) \hideinitializer */
#define EXIRQ10                 (10)    /*!< External Interrupt 10 (IRQ10) \hideinitializer */
#define EXIRQ11                 (11)    /*!< External Interrupt 11 (IRQ11) \hideinitializer */
#define EXIRQ12                 (12)    /*!< External Interrupt 12 (IRQ12) \hideinitializer */
#define EXIRQ13                 (13)    /*!< External Interrupt 13 (IRQ13) \hideinitializer */
#define EXIRQ14                 (14)    /*!< External Interrupt 14 (IRQ14) \hideinitializer */
#define EXIRQ15                 (15)    /*!< External Interrupt 15 (IRQ15) \hideinitializer */
#define EXIRQ16                 (16)    /*!< External Interrupt 16 (IRQ16) \hideinitializer */
#define EXIRQ17                 (17)    /*!< External Interrupt 17 (IRQ17) \hideinitializer */
#define EXIRQ18                 (18)    /*!< External Interrupt 18 (IRQ18) \hideinitializer */
#define EXIRQ19                 (19)    /*!< External Interrupt 19 (IRQ19) \hideinitializer */

/*---------------------------------------------------------------------------------------------------------*/
/*  Both edge detect selection                                                                             */
/*---------------------------------------------------------------------------------------------------------*/
#define GPIO_INTCGnDETMD_IRQEG_Pos          (2)
#define GPIO_EXIRQ_BOTHEDGE_DISABLE         (0x00 << GPIO_INTCGnDETMD_IRQEG_Pos)        /*!< GPIO external interrupt both-edge : disable  \hideinitializer */
#define GPIO_EXIRQ_BOTHEDGE_ENABLE          (0x01 << GPIO_INTCGnDETMD_IRQEG_Pos)        /*!< GPIO external interrupt both-edge : enable  \hideinitializer */

/*---------------------------------------------------------------------------------------------------------*/
/*  External interrupt trigger settings                                                                    */
/*---------------------------------------------------------------------------------------------------------*/
#define GPIO_INTCGnDETMD_IRQTG_Pos          (0)
#define GPIO_EXIRQ_TRIGGER_RISINGEDGE       (0x00 << GPIO_INTCGnDETMD_IRQTG_Pos)        /*!< GPIO external interrupt trigger : rising edge  \hideinitializer */
#define GPIO_EXIRQ_TRIGGER_FALLINGEDGE      (0x01 << GPIO_INTCGnDETMD_IRQTG_Pos)        /*!< GPIO external interrupt trigger : falling edge  \hideinitializer */
#define GPIO_EXIRQ_TRIGGER_H_LEVEL          (0x02 << GPIO_INTCGnDETMD_IRQTG_Pos)        /*!< GPIO external interrupt trigger : "H" level  \hideinitializer */
#define GPIO_EXIRQ_TRIGGER_L_LEVEL          (0x03 << GPIO_INTCGnDETMD_IRQTG_Pos)        /*!< GPIO external interrupt trigger : "L" level  \hideinitializer */

/*---------------------------------------------------------------------------------------------------------*/
/*  Noise Filter Sampling clock frequency selection                                                        */
/*---------------------------------------------------------------------------------------------------------*/
#define GPIO_NF_SMP_IOCLK_DIV_8         (0x00000000)        /*!< Noise Filter Sampling clock frequency : IOCLK/8 \hideinitializer */
#define GPIO_NF_SMP_IOCLK_DIV_16        (0x00000001)        /*!< Noise Filter Sampling clock frequency : IOCLK/16 \hideinitializer */
#define GPIO_NF_SMP_IOCLK_DIV_32        (0x00000002)        /*!< Noise Filter Sampling clock frequency : IOCLK/32 \hideinitializer */
#define GPIO_NF_SMP_IOCLK_DIV_64        (0x00000003)        /*!< Noise Filter Sampling clock frequency : IOCLK/64 \hideinitializer */
#define GPIO_NF_SMP_IOCLK_DIV_128       (0x00000004)        /*!< Noise Filter Sampling clock frequency : IOCLK/128 \hideinitializer */
#define GPIO_NF_SMP_IOCLK_DIV_256       (0x00000005)        /*!< Noise Filter Sampling clock frequency : IOCLK/256 \hideinitializer */
#define GPIO_NF_SMP_IOCLK_DIV_512       (0x00000006)        /*!< Noise Filter Sampling clock frequency : IOCLK/512 \hideinitializer */
#define GPIO_NF_SMP_IOCLK_DIV_1024      (0x00000007)        /*!< Noise Filter Sampling clock frequency : IOCLK/1024 \hideinitializer */

/*---------------------------------------------------------------------------------------------------------*/
/*  Port (Pn0 ~ Pn7) overall input level reading                                                           */
/*---------------------------------------------------------------------------------------------------------*/
#define GPIO_IN_PORT0       (GPIO_CTL->IOPnIN[P0])              /*!< Port0 overall inport \hideinitializer */
#define GPIO_IN_PORT1       (GPIO_CTL->IOPnIN[P1])              /*!< Port1 overall inport \hideinitializer */
#define GPIO_IN_PORT2       (GPIO_CTL->IOPnIN[P2])              /*!< Port2 overall inport \hideinitializer */
#define GPIO_IN_PORT3       (GPIO_CTL->IOPnIN[P3])              /*!< Port3 overall inport \hideinitializer */
#define GPIO_IN_PORT4       (GPIO_CTL->IOPnIN[P4])              /*!< Port4 overall inport \hideinitializer */
#define GPIO_IN_PORT5       (GPIO_CTL->IOPnIN[P5])              /*!< Port5 overall inport \hideinitializer */
#define GPIO_IN_PORT6       (GPIO_CTL->IOPnIN[P6])              /*!< Port6 overall inport \hideinitializer */
#define GPIO_IN_PORT7       (GPIO_CTL->IOPnIN[P7])              /*!< Port7 overall inport \hideinitializer */
#define GPIO_IN_PORT8       (GPIO_CTL->IOPnIN[P8])              /*!< Port8 overall inport \hideinitializer */
#define GPIO_IN_PORT9       (GPIO_CTL->IOPnIN[P9])              /*!< Port9 overall inport \hideinitializer */
#define GPIO_IN_PORTA       (GPIO_CTL->IOPnIN[PA])              /*!< PortA overall inport \hideinitializer */
#define GPIO_IN_PORTB       (GPIO_CTL->IOPnIN[PB])              /*!< PortB overall inport \hideinitializer */
#define GPIO_IN_PORTC       (GPIO_CTL->IOPnIN[PC])              /*!< PortC overall inport \hideinitializer */
#define GPIO_IN_PORTD       (GPIO_CTL->IOPnIN[PD])              /*!< PortD overall inport \hideinitializer */
#define GPIO_IN_PORTE       (GPIO_CTL->IOPnIN[PE])              /*!< PortE overall inport \hideinitializer */
#define GPIO_IN_PORTF       (GPIO_CTL->IOPnIN[PF])              /*!< PortF overall inport \hideinitializer */

/*---------------------------------------------------------------------------------------------------------*/
/*  Port (Pn0 ~ Pn7) overall output level writing                                                          */
/*---------------------------------------------------------------------------------------------------------*/
#define GPIO_OUT_PORT0      (GPIO_CTL->IOPnOUT[P0])             /*!< Port0 overall output \hideinitializer */
#define GPIO_OUT_PORT1      (GPIO_CTL->IOPnOUT[P1])             /*!< Port1 overall output \hideinitializer */
#define GPIO_OUT_PORT2      (GPIO_CTL->IOPnOUT[P2])             /*!< Port2 overall output \hideinitializer */
#define GPIO_OUT_PORT3      (GPIO_CTL->IOPnOUT[P3])             /*!< Port3 overall output \hideinitializer */
#define GPIO_OUT_PORT4      (GPIO_CTL->IOPnOUT[P4])             /*!< Port4 overall output \hideinitializer */
#define GPIO_OUT_PORT5      (GPIO_CTL->IOPnOUT[P5])             /*!< Port5 overall output \hideinitializer */
#define GPIO_OUT_PORT6      (GPIO_CTL->IOPnOUT[P6])             /*!< Port6 overall output \hideinitializer */
#define GPIO_OUT_PORT7      (GPIO_CTL->IOPnOUT[P7])             /*!< Port7 overall output \hideinitializer */
#define GPIO_OUT_PORT8      (GPIO_CTL->IOPnOUT[P8])             /*!< Port8 overall output \hideinitializer */
#define GPIO_OUT_PORT9      (GPIO_CTL->IOPnOUT[P9])             /*!< Port9 overall output \hideinitializer */
#define GPIO_OUT_PORTA      (GPIO_CTL->IOPnOUT[PA])             /*!< PortA overall output \hideinitializer */
#define GPIO_OUT_PORTB      (GPIO_CTL->IOPnOUT[PB])             /*!< PortB overall output \hideinitializer */
#define GPIO_OUT_PORTC      (GPIO_CTL->IOPnOUT[PC])             /*!< PortC overall output \hideinitializer */
#define GPIO_OUT_PORTD      (GPIO_CTL->IOPnOUT[PD])             /*!< PortD overall output \hideinitializer */
#define GPIO_OUT_PORTE      (GPIO_CTL->IOPnOUT[PE])             /*!< PortE overall output \hideinitializer */
#define GPIO_OUT_PORTF      (GPIO_CTL->IOPnOUT[PF])             /*!< PortF overall output \hideinitializer */

/*---------------------------------------------------------------------------------------------------------*/
/*  Input level reading of the specified pin                                                               */
/*---------------------------------------------------------------------------------------------------------*/
#define GPIO_IN_PIN_P00     (GPIO_CTL->IOPnIN_b[P0].P0IN)            /*!< [0..0] Input data of P00 */
#define GPIO_IN_PIN_P01     (GPIO_CTL->IOPnIN_b[P0].P1IN)            /*!< [1..1] Input data of P01 */
#define GPIO_IN_PIN_P02     (GPIO_CTL->IOPnIN_b[P0].P2IN)            /*!< [2..2] Input data of P02 */
#define GPIO_IN_PIN_P03     (GPIO_CTL->IOPnIN_b[P0].P3IN)            /*!< [3..3] Input data of P03 */
#define GPIO_IN_PIN_P04     (GPIO_CTL->IOPnIN_b[P0].P4IN)            /*!< [4..4] Input data of P04 */
#define GPIO_IN_PIN_P05     (GPIO_CTL->IOPnIN_b[P0].P5IN)            /*!< [5..5] Input data of P05 */
#define GPIO_IN_PIN_P06     (GPIO_CTL->IOPnIN_b[P0].P6IN)            /*!< [6..6] Input data of P06 */
#define GPIO_IN_PIN_P07     (GPIO_CTL->IOPnIN_b[P0].P7IN)            /*!< [7..7] Input data of P07 */

#define GPIO_IN_PIN_P10     (GPIO_CTL->IOPnIN_b[P1].P0IN)            /*!< [0..0] Input data of P10 */
#define GPIO_IN_PIN_P11     (GPIO_CTL->IOPnIN_b[P1].P1IN)            /*!< [1..1] Input data of P11 */
#define GPIO_IN_PIN_P12     (GPIO_CTL->IOPnIN_b[P1].P2IN)            /*!< [2..2] Input data of P12 */
#define GPIO_IN_PIN_P13     (GPIO_CTL->IOPnIN_b[P1].P3IN)            /*!< [3..3] Input data of P13 */
#define GPIO_IN_PIN_P14     (GPIO_CTL->IOPnIN_b[P1].P4IN)            /*!< [4..4] Input data of P14 */
#define GPIO_IN_PIN_P15     (GPIO_CTL->IOPnIN_b[P1].P5IN)            /*!< [5..5] Input data of P15 */
#define GPIO_IN_PIN_P16     (GPIO_CTL->IOPnIN_b[P1].P6IN)            /*!< [6..6] Input data of P16 */
#define GPIO_IN_PIN_P17     (GPIO_CTL->IOPnIN_b[P1].P7IN)            /*!< [7..7] Input data of P17 */

#define GPIO_IN_PIN_P20     (GPIO_CTL->IOPnIN_b[P2].P0IN)            /*!< [0..0] Input data of P20 */
#define GPIO_IN_PIN_P21     (GPIO_CTL->IOPnIN_b[P2].P1IN)            /*!< [1..1] Input data of P21 */
#define GPIO_IN_PIN_P22     (GPIO_CTL->IOPnIN_b[P2].P2IN)            /*!< [2..2] Input data of P22 */
#define GPIO_IN_PIN_P24     (GPIO_CTL->IOPnIN_b[P2].P4IN)            /*!< [4..4] Input data of P24 */
#define GPIO_IN_PIN_P25     (GPIO_CTL->IOPnIN_b[P2].P5IN)            /*!< [5..5] Input data of P25 */
#define GPIO_IN_PIN_P26     (GPIO_CTL->IOPnIN_b[P2].P6IN)            /*!< [6..6] Input data of P26 */
#define GPIO_IN_PIN_P27     (GPIO_CTL->IOPnIN_b[P2].P7IN)            /*!< [7..7] Input data of P27 */

#define GPIO_IN_PIN_P30     (GPIO_CTL->IOPnIN_b[P3].P0IN)            /*!< [0..0] Input data of P30 */
#define GPIO_IN_PIN_P31     (GPIO_CTL->IOPnIN_b[P3].P1IN)            /*!< [1..1] Input data of P31 */
#define GPIO_IN_PIN_P32     (GPIO_CTL->IOPnIN_b[P3].P2IN)            /*!< [2..2] Input data of P32 */
#define GPIO_IN_PIN_P34     (GPIO_CTL->IOPnIN_b[P3].P4IN)            /*!< [4..4] Input data of P34 */
#define GPIO_IN_PIN_P35     (GPIO_CTL->IOPnIN_b[P3].P5IN)            /*!< [5..5] Input data of P35 */
#define GPIO_IN_PIN_P36     (GPIO_CTL->IOPnIN_b[P3].P6IN)            /*!< [6..6] Input data of P36 */

#define GPIO_IN_PIN_P40     (GPIO_CTL->IOPnIN_b[P4].P0IN)            /*!< [0..0] Input data of P40 */
#define GPIO_IN_PIN_P41     (GPIO_CTL->IOPnIN_b[P4].P1IN)            /*!< [1..1] Input data of P41 */
#define GPIO_IN_PIN_P42     (GPIO_CTL->IOPnIN_b[P4].P2IN)            /*!< [2..2] Input data of P42 */
#define GPIO_IN_PIN_P44     (GPIO_CTL->IOPnIN_b[P4].P4IN)            /*!< [4..4] Input data of P44 */
#define GPIO_IN_PIN_P45     (GPIO_CTL->IOPnIN_b[P4].P5IN)            /*!< [5..5] Input data of P45 */
#define GPIO_IN_PIN_P46     (GPIO_CTL->IOPnIN_b[P4].P6IN)            /*!< [6..6] Input data of P46 */
#define GPIO_IN_PIN_P47     (GPIO_CTL->IOPnIN_b[P4].P7IN)            /*!< [7..7] Input data of P47 */

#define GPIO_IN_PIN_P50     (GPIO_CTL->IOPnIN_b[P5].P0IN)            /*!< [0..0] Input data of P50 */
#define GPIO_IN_PIN_P51     (GPIO_CTL->IOPnIN_b[P5].P1IN)            /*!< [1..1] Input data of P51 */
#define GPIO_IN_PIN_P52     (GPIO_CTL->IOPnIN_b[P5].P2IN)            /*!< [2..2] Input data of P52 */
#define GPIO_IN_PIN_P53     (GPIO_CTL->IOPnIN_b[P5].P3IN)            /*!< [3..3] Input data of P53 */
#define GPIO_IN_PIN_P54     (GPIO_CTL->IOPnIN_b[P5].P4IN)            /*!< [4..4] Input data of P54 */
#define GPIO_IN_PIN_P55     (GPIO_CTL->IOPnIN_b[P5].P5IN)            /*!< [5..5] Input data of P55 */
#define GPIO_IN_PIN_P56     (GPIO_CTL->IOPnIN_b[P5].P6IN)            /*!< [6..6] Input data of P56 */
#define GPIO_IN_PIN_P57     (GPIO_CTL->IOPnIN_b[P5].P7IN)            /*!< [7..7] Input data of P57 */

#define GPIO_IN_PIN_P60     (GPIO_CTL->IOPnIN_b[P6].P0IN)            /*!< [0..0] Input data of P60 */
#define GPIO_IN_PIN_P61     (GPIO_CTL->IOPnIN_b[P6].P1IN)            /*!< [1..1] Input data of P61 */
#define GPIO_IN_PIN_P62     (GPIO_CTL->IOPnIN_b[P6].P2IN)            /*!< [2..2] Input data of P62 */
#define GPIO_IN_PIN_P63     (GPIO_CTL->IOPnIN_b[P6].P3IN)            /*!< [3..3] Input data of P63 */
#define GPIO_IN_PIN_P64     (GPIO_CTL->IOPnIN_b[P6].P4IN)            /*!< [4..4] Input data of P64 */
#define GPIO_IN_PIN_P65     (GPIO_CTL->IOPnIN_b[P6].P5IN)            /*!< [5..5] Input data of P65 */
#define GPIO_IN_PIN_P66     (GPIO_CTL->IOPnIN_b[P6].P6IN)            /*!< [6..6] Input data of P66 */
#define GPIO_IN_PIN_P67     (GPIO_CTL->IOPnIN_b[P6].P7IN)            /*!< [7..7] Input data of P67 */

#define GPIO_IN_PIN_P70     (GPIO_CTL->IOPnIN_b[P7].P0IN)            /*!< [0..0] Input data of P70 */
#define GPIO_IN_PIN_P71     (GPIO_CTL->IOPnIN_b[P7].P1IN)            /*!< [1..1] Input data of P71 */
#define GPIO_IN_PIN_P72     (GPIO_CTL->IOPnIN_b[P7].P2IN)            /*!< [2..2] Input data of P72 */
#define GPIO_IN_PIN_P73     (GPIO_CTL->IOPnIN_b[P7].P3IN)            /*!< [3..3] Input data of P73 */
#define GPIO_IN_PIN_P74     (GPIO_CTL->IOPnIN_b[P7].P4IN)            /*!< [4..4] Input data of P74 */
#define GPIO_IN_PIN_P75     (GPIO_CTL->IOPnIN_b[P7].P5IN)            /*!< [5..5] Input data of P75 */
#define GPIO_IN_PIN_P76     (GPIO_CTL->IOPnIN_b[P7].P6IN)            /*!< [6..6] Input data of P76 */
#define GPIO_IN_PIN_P77     (GPIO_CTL->IOPnIN_b[P7].P7IN)            /*!< [7..7] Input data of P77 */

#define GPIO_IN_PIN_P80     (GPIO_CTL->IOPnIN_b[P8].P0IN)            /*!< [0..0] Input data of P80 */
#define GPIO_IN_PIN_P81     (GPIO_CTL->IOPnIN_b[P8].P1IN)            /*!< [1..1] Input data of P81 */
#define GPIO_IN_PIN_P82     (GPIO_CTL->IOPnIN_b[P8].P2IN)            /*!< [2..2] Input data of P82 */
#define GPIO_IN_PIN_P83     (GPIO_CTL->IOPnIN_b[P8].P3IN)            /*!< [3..3] Input data of P83 */
#define GPIO_IN_PIN_P84     (GPIO_CTL->IOPnIN_b[P8].P4IN)            /*!< [4..4] Input data of P84 */
#define GPIO_IN_PIN_P85     (GPIO_CTL->IOPnIN_b[P8].P5IN)            /*!< [5..5] Input data of P85 */
#define GPIO_IN_PIN_P86     (GPIO_CTL->IOPnIN_b[P8].P6IN)            /*!< [6..6] Input data of P86 */
#define GPIO_IN_PIN_P87     (GPIO_CTL->IOPnIN_b[P8].P7IN)            /*!< [7..7] Input data of P87 */

#define GPIO_IN_PIN_P90     (GPIO_CTL->IOPnIN_b[P9].P0IN)            /*!< [0..0] Input data of P90 */
#define GPIO_IN_PIN_P91     (GPIO_CTL->IOPnIN_b[P9].P1IN)            /*!< [1..1] Input data of P91 */
#define GPIO_IN_PIN_P92     (GPIO_CTL->IOPnIN_b[P9].P2IN)            /*!< [2..2] Input data of P92 */
#define GPIO_IN_PIN_P93     (GPIO_CTL->IOPnIN_b[P9].P3IN)            /*!< [3..3] Input data of P93 */
#define GPIO_IN_PIN_P94     (GPIO_CTL->IOPnIN_b[P9].P4IN)            /*!< [4..4] Input data of P94 */
#define GPIO_IN_PIN_P95     (GPIO_CTL->IOPnIN_b[P9].P5IN)            /*!< [5..5] Input data of P95 */
#define GPIO_IN_PIN_P96     (GPIO_CTL->IOPnIN_b[P9].P6IN)            /*!< [6..6] Input data of P96 */
#define GPIO_IN_PIN_P97     (GPIO_CTL->IOPnIN_b[P9].P7IN)            /*!< [7..7] Input data of P97 */

#define GPIO_IN_PIN_PA0     (GPIO_CTL->IOPnIN_b[PA].P0IN)            /*!< [0..0] Input data of PA0 */
#define GPIO_IN_PIN_PA1     (GPIO_CTL->IOPnIN_b[PA].P1IN)            /*!< [1..1] Input data of PA1 */
#define GPIO_IN_PIN_PA2     (GPIO_CTL->IOPnIN_b[PA].P2IN)            /*!< [2..2] Input data of PA2 */
#define GPIO_IN_PIN_PA3     (GPIO_CTL->IOPnIN_b[PA].P3IN)            /*!< [3..3] Input data of PA3 */
#define GPIO_IN_PIN_PA4     (GPIO_CTL->IOPnIN_b[PA].P4IN)            /*!< [4..4] Input data of PA4 */
#define GPIO_IN_PIN_PA5     (GPIO_CTL->IOPnIN_b[PA].P5IN)            /*!< [5..5] Input data of PA5 */
#define GPIO_IN_PIN_PA6     (GPIO_CTL->IOPnIN_b[PA].P6IN)            /*!< [6..6] Input data of PA6 */
#define GPIO_IN_PIN_PA7     (GPIO_CTL->IOPnIN_b[PA].P7IN)            /*!< [7..7] Input data of PA7 */

#define GPIO_IN_PIN_PB0     (GPIO_CTL->IOPnIN_b[PB].P0IN)            /*!< [0..0] Input data of PB0 */
#define GPIO_IN_PIN_PB1     (GPIO_CTL->IOPnIN_b[PB].P1IN)            /*!< [1..1] Input data of PB1 */
#define GPIO_IN_PIN_PB2     (GPIO_CTL->IOPnIN_b[PB].P2IN)            /*!< [2..2] Input data of PB2 */
#define GPIO_IN_PIN_PB3     (GPIO_CTL->IOPnIN_b[PB].P3IN)            /*!< [3..3] Input data of PB3 */
#define GPIO_IN_PIN_PB4     (GPIO_CTL->IOPnIN_b[PB].P4IN)            /*!< [4..4] Input data of PB4 */
#define GPIO_IN_PIN_PB6     (GPIO_CTL->IOPnIN_b[PB].P6IN)            /*!< [6..6] Input data of PB6 */
#define GPIO_IN_PIN_PB7     (GPIO_CTL->IOPnIN_b[PB].P7IN)            /*!< [7..7] Input data of PB7 */

#define GPIO_IN_PIN_PC0     (GPIO_CTL->IOPnIN_b[PC].P0IN)            /*!< [0..0] Input data of PC0 */
#define GPIO_IN_PIN_PC1     (GPIO_CTL->IOPnIN_b[PC].P1IN)            /*!< [1..1] Input data of PC1 */
#define GPIO_IN_PIN_PC2     (GPIO_CTL->IOPnIN_b[PC].P2IN)            /*!< [2..2] Input data of PC2 */
#define GPIO_IN_PIN_PC3     (GPIO_CTL->IOPnIN_b[PC].P3IN)            /*!< [3..3] Input data of PC3 */
#define GPIO_IN_PIN_PC4     (GPIO_CTL->IOPnIN_b[PC].P4IN)            /*!< [4..4] Input data of PC4 */
#define GPIO_IN_PIN_PC5     (GPIO_CTL->IOPnIN_b[PC].P5IN)            /*!< [5..5] Input data of PC5 */
#define GPIO_IN_PIN_PC6     (GPIO_CTL->IOPnIN_b[PC].P6IN)            /*!< [6..6] Input data of PC6 */
#define GPIO_IN_PIN_PC7     (GPIO_CTL->IOPnIN_b[PC].P7IN)            /*!< [7..7] Input data of PC7 */

#define GPIO_IN_PIN_PD0     (GPIO_CTL->IOPnIN_b[PD].P0IN)            /*!< [0..0] Input data of PD0 */
#define GPIO_IN_PIN_PD1     (GPIO_CTL->IOPnIN_b[PD].P1IN)            /*!< [1..1] Input data of PD1 */
#define GPIO_IN_PIN_PD2     (GPIO_CTL->IOPnIN_b[PD].P2IN)            /*!< [2..2] Input data of PD2 */
#define GPIO_IN_PIN_PD3     (GPIO_CTL->IOPnIN_b[PD].P3IN)            /*!< [3..3] Input data of PD3 */
#define GPIO_IN_PIN_PD4     (GPIO_CTL->IOPnIN_b[PD].P4IN)            /*!< [4..4] Input data of PD4 */
#define GPIO_IN_PIN_PD5     (GPIO_CTL->IOPnIN_b[PD].P5IN)            /*!< [5..5] Input data of PD5 */
#define GPIO_IN_PIN_PD6     (GPIO_CTL->IOPnIN_b[PD].P6IN)            /*!< [6..6] Input data of PD6 */
#define GPIO_IN_PIN_PD7     (GPIO_CTL->IOPnIN_b[PD].P7IN)            /*!< [7..7] Input data of PD7 */

#define GPIO_IN_PIN_PE0     (GPIO_CTL->IOPnIN_b[PE].P0IN)            /*!< [0..0] Input data of PE0 */
#define GPIO_IN_PIN_PE1     (GPIO_CTL->IOPnIN_b[PE].P1IN)            /*!< [1..1] Input data of PE1 */
#define GPIO_IN_PIN_PE2     (GPIO_CTL->IOPnIN_b[PE].P2IN)            /*!< [2..2] Input data of PE2 */
#define GPIO_IN_PIN_PE3     (GPIO_CTL->IOPnIN_b[PE].P3IN)            /*!< [3..3] Input data of PE3 */
#define GPIO_IN_PIN_PE4     (GPIO_CTL->IOPnIN_b[PE].P4IN)            /*!< [4..4] Input data of PE4 */
#define GPIO_IN_PIN_PE5     (GPIO_CTL->IOPnIN_b[PE].P5IN)            /*!< [5..5] Input data of PE5 */
#define GPIO_IN_PIN_PE6     (GPIO_CTL->IOPnIN_b[PE].P6IN)            /*!< [6..6] Input data of PE6 */
#define GPIO_IN_PIN_PE7     (GPIO_CTL->IOPnIN_b[PE].P7IN)            /*!< [7..7] Input data of PE7 */

#define GPIO_IN_PIN_PF0     (GPIO_CTL->IOPnIN_b[PF].P0IN)            /*!< [0..0] Input data of PF0 */
#define GPIO_IN_PIN_PF1     (GPIO_CTL->IOPnIN_b[PF].P1IN)            /*!< [1..1] Input data of PF1 */
#define GPIO_IN_PIN_PF2     (GPIO_CTL->IOPnIN_b[PF].P2IN)            /*!< [2..2] Input data of PF2 */
#define GPIO_IN_PIN_PF3     (GPIO_CTL->IOPnIN_b[PF].P3IN)            /*!< [3..3] Input data of PF3 */
#define GPIO_IN_PIN_PF4     (GPIO_CTL->IOPnIN_b[PF].P4IN)            /*!< [4..4] Input data of PF4 */
#define GPIO_IN_PIN_PF5     (GPIO_CTL->IOPnIN_b[PF].P5IN)            /*!< [5..5] Input data of PF5 */
#define GPIO_IN_PIN_PF6     (GPIO_CTL->IOPnIN_b[PF].P6IN)            /*!< [6..6] Input data of PF6 */
#define GPIO_IN_PIN_PF7     (GPIO_CTL->IOPnIN_b[PF].P7IN)            /*!< [7..7] Input data of PF7 */

/*---------------------------------------------------------------------------------------------------------*/
/*  The output level of the specified pin to Low                                                           */
/*---------------------------------------------------------------------------------------------------------*/
#define GPIO_OUT_PIN_L_P00     (GPIO_CTL->IOPnCLR_b[P0].P0CLR)            /*!< [0..0] output clear data of P00 */
#define GPIO_OUT_PIN_L_P01     (GPIO_CTL->IOPnCLR_b[P0].P1CLR)            /*!< [1..1] output clear data of P01 */
#define GPIO_OUT_PIN_L_P02     (GPIO_CTL->IOPnCLR_b[P0].P2CLR)            /*!< [2..2] output clear data of P02 */
#define GPIO_OUT_PIN_L_P03     (GPIO_CTL->IOPnCLR_b[P0].P3CLR)            /*!< [3..3] output clear data of P03 */
#define GPIO_OUT_PIN_L_P04     (GPIO_CTL->IOPnCLR_b[P0].P4CLR)            /*!< [4..4] output clear data of P04 */
#define GPIO_OUT_PIN_L_P05     (GPIO_CTL->IOPnCLR_b[P0].P5CLR)            /*!< [5..5] output clear data of P05 */
#define GPIO_OUT_PIN_L_P06     (GPIO_CTL->IOPnCLR_b[P0].P6CLR)            /*!< [6..6] output clear data of P06 */
#define GPIO_OUT_PIN_L_P07     (GPIO_CTL->IOPnCLR_b[P0].P7CLR)            /*!< [7..7] output clear data of P07 */

#define GPIO_OUT_PIN_L_P10     (GPIO_CTL->IOPnCLR_b[P1].P0CLR)            /*!< [0..0] output clear data of P10 */
#define GPIO_OUT_PIN_L_P11     (GPIO_CTL->IOPnCLR_b[P1].P1CLR)            /*!< [1..1] output clear data of P11 */
#define GPIO_OUT_PIN_L_P12     (GPIO_CTL->IOPnCLR_b[P1].P2CLR)            /*!< [2..2] output clear data of P12 */
#define GPIO_OUT_PIN_L_P13     (GPIO_CTL->IOPnCLR_b[P1].P3CLR)            /*!< [3..3] output clear data of P13 */
#define GPIO_OUT_PIN_L_P14     (GPIO_CTL->IOPnCLR_b[P1].P4CLR)            /*!< [4..4] output clear data of P14 */
#define GPIO_OUT_PIN_L_P15     (GPIO_CTL->IOPnCLR_b[P1].P5CLR)            /*!< [5..5] output clear data of P15 */
#define GPIO_OUT_PIN_L_P16     (GPIO_CTL->IOPnCLR_b[P1].P6CLR)            /*!< [6..6] output clear data of P16 */
#define GPIO_OUT_PIN_L_P17     (GPIO_CTL->IOPnCLR_b[P1].P7CLR)            /*!< [7..7] output clear data of P17 */

#define GPIO_OUT_PIN_L_P20     (GPIO_CTL->IOPnCLR_b[P2].P0CLR)            /*!< [0..0] output clear data of P20 */
#define GPIO_OUT_PIN_L_P21     (GPIO_CTL->IOPnCLR_b[P2].P1CLR)            /*!< [1..1] output clear data of P21 */
#define GPIO_OUT_PIN_L_P22     (GPIO_CTL->IOPnCLR_b[P2].P2CLR)            /*!< [2..2] output clear data of P22 */
#define GPIO_OUT_PIN_L_P24     (GPIO_CTL->IOPnCLR_b[P2].P4CLR)            /*!< [4..4] output clear data of P24 */
#define GPIO_OUT_PIN_L_P25     (GPIO_CTL->IOPnCLR_b[P2].P5CLR)            /*!< [5..5] output clear data of P25 */
#define GPIO_OUT_PIN_L_P26     (GPIO_CTL->IOPnCLR_b[P2].P6CLR)            /*!< [6..6] output clear data of P26 */
#define GPIO_OUT_PIN_L_P27     (GPIO_CTL->IOPnCLR_b[P2].P7CLR)            /*!< [7..7] output clear data of P27 */

#define GPIO_OUT_PIN_L_P30     (GPIO_CTL->IOPnCLR_b[P3].P0CLR)            /*!< [0..0] output clear data of P30 */
#define GPIO_OUT_PIN_L_P31     (GPIO_CTL->IOPnCLR_b[P3].P1CLR)            /*!< [1..1] output clear data of P31 */
#define GPIO_OUT_PIN_L_P32     (GPIO_CTL->IOPnCLR_b[P3].P2CLR)            /*!< [2..2] output clear data of P32 */
#define GPIO_OUT_PIN_L_P34     (GPIO_CTL->IOPnCLR_b[P3].P4CLR)            /*!< [4..4] output clear data of P34 */
#define GPIO_OUT_PIN_L_P35     (GPIO_CTL->IOPnCLR_b[P3].P5CLR)            /*!< [5..5] output clear data of P35 */
#define GPIO_OUT_PIN_L_P36     (GPIO_CTL->IOPnCLR_b[P3].P6CLR)            /*!< [6..6] output clear data of P36 */

#define GPIO_OUT_PIN_L_P40     (GPIO_CTL->IOPnCLR_b[P4].P0CLR)            /*!< [0..0] output clear data of P40 */
#define GPIO_OUT_PIN_L_P41     (GPIO_CTL->IOPnCLR_b[P4].P1CLR)            /*!< [1..1] output clear data of P41 */
#define GPIO_OUT_PIN_L_P42     (GPIO_CTL->IOPnCLR_b[P4].P2CLR)            /*!< [2..2] output clear data of P42 */
#define GPIO_OUT_PIN_L_P44     (GPIO_CTL->IOPnCLR_b[P4].P4CLR)            /*!< [4..4] output clear data of P44 */
#define GPIO_OUT_PIN_L_P45     (GPIO_CTL->IOPnCLR_b[P4].P5CLR)            /*!< [5..5] output clear data of P45 */
#define GPIO_OUT_PIN_L_P46     (GPIO_CTL->IOPnCLR_b[P4].P6CLR)            /*!< [6..6] output clear data of P46 */
#define GPIO_OUT_PIN_L_P47     (GPIO_CTL->IOPnCLR_b[P4].P7CLR)            /*!< [7..7] output clear data of P47 */

#define GPIO_OUT_PIN_L_P50     (GPIO_CTL->IOPnCLR_b[P5].P0CLR)            /*!< [0..0] output clear data of P50 */
#define GPIO_OUT_PIN_L_P51     (GPIO_CTL->IOPnCLR_b[P5].P1CLR)            /*!< [1..1] output clear data of P51 */
#define GPIO_OUT_PIN_L_P52     (GPIO_CTL->IOPnCLR_b[P5].P2CLR)            /*!< [2..2] output clear data of P52 */
#define GPIO_OUT_PIN_L_P53     (GPIO_CTL->IOPnCLR_b[P5].P3CLR)            /*!< [3..3] output clear data of P53 */
#define GPIO_OUT_PIN_L_P54     (GPIO_CTL->IOPnCLR_b[P5].P4CLR)            /*!< [4..4] output clear data of P54 */
#define GPIO_OUT_PIN_L_P55     (GPIO_CTL->IOPnCLR_b[P5].P5CLR)            /*!< [5..5] output clear data of P55 */
#define GPIO_OUT_PIN_L_P56     (GPIO_CTL->IOPnCLR_b[P5].P6CLR)            /*!< [6..6] output clear data of P56 */
#define GPIO_OUT_PIN_L_P57     (GPIO_CTL->IOPnCLR_b[P5].P7CLR)            /*!< [7..7] output clear data of P57 */

#define GPIO_OUT_PIN_L_P60     (GPIO_CTL->IOPnCLR_b[P6].P0CLR)            /*!< [0..0] output clear data of P60 */
#define GPIO_OUT_PIN_L_P61     (GPIO_CTL->IOPnCLR_b[P6].P1CLR)            /*!< [1..1] output clear data of P61 */
#define GPIO_OUT_PIN_L_P62     (GPIO_CTL->IOPnCLR_b[P6].P2CLR)            /*!< [2..2] output clear data of P62 */
#define GPIO_OUT_PIN_L_P63     (GPIO_CTL->IOPnCLR_b[P6].P3CLR)            /*!< [3..3] output clear data of P63 */
#define GPIO_OUT_PIN_L_P64     (GPIO_CTL->IOPnCLR_b[P6].P4CLR)            /*!< [4..4] output clear data of P64 */
#define GPIO_OUT_PIN_L_P65     (GPIO_CTL->IOPnCLR_b[P6].P5CLR)            /*!< [5..5] output clear data of P65 */
#define GPIO_OUT_PIN_L_P66     (GPIO_CTL->IOPnCLR_b[P6].P6CLR)            /*!< [6..6] output clear data of P66 */
#define GPIO_OUT_PIN_L_P67     (GPIO_CTL->IOPnCLR_b[P6].P7CLR)            /*!< [7..7] output clear data of P67 */

#define GPIO_OUT_PIN_L_P70     (GPIO_CTL->IOPnCLR_b[P7].P0CLR)            /*!< [0..0] output clear data of P70 */
#define GPIO_OUT_PIN_L_P71     (GPIO_CTL->IOPnCLR_b[P7].P1CLR)            /*!< [1..1] output clear data of P71 */
#define GPIO_OUT_PIN_L_P72     (GPIO_CTL->IOPnCLR_b[P7].P2CLR)            /*!< [2..2] output clear data of P72 */
#define GPIO_OUT_PIN_L_P73     (GPIO_CTL->IOPnCLR_b[P7].P3CLR)            /*!< [3..3] output clear data of P73 */
#define GPIO_OUT_PIN_L_P74     (GPIO_CTL->IOPnCLR_b[P7].P4CLR)            /*!< [4..4] output clear data of P74 */
#define GPIO_OUT_PIN_L_P75     (GPIO_CTL->IOPnCLR_b[P7].P5CLR)            /*!< [5..5] output clear data of P75 */
#define GPIO_OUT_PIN_L_P76     (GPIO_CTL->IOPnCLR_b[P7].P6CLR)            /*!< [6..6] output clear data of P76 */
#define GPIO_OUT_PIN_L_P77     (GPIO_CTL->IOPnCLR_b[P7].P7CLR)            /*!< [7..7] output clear data of P77 */

#define GPIO_OUT_PIN_L_P80     (GPIO_CTL->IOPnCLR_b[P8].P0CLR)            /*!< [0..0] output clear data of P80 */
#define GPIO_OUT_PIN_L_P81     (GPIO_CTL->IOPnCLR_b[P8].P1CLR)            /*!< [1..1] output clear data of P81 */
#define GPIO_OUT_PIN_L_P82     (GPIO_CTL->IOPnCLR_b[P8].P2CLR)            /*!< [2..2] output clear data of P82 */
#define GPIO_OUT_PIN_L_P83     (GPIO_CTL->IOPnCLR_b[P8].P3CLR)            /*!< [3..3] output clear data of P83 */
#define GPIO_OUT_PIN_L_P84     (GPIO_CTL->IOPnCLR_b[P8].P4CLR)            /*!< [4..4] output clear data of P84 */
#define GPIO_OUT_PIN_L_P85     (GPIO_CTL->IOPnCLR_b[P8].P5CLR)            /*!< [5..5] output clear data of P85 */
#define GPIO_OUT_PIN_L_P86     (GPIO_CTL->IOPnCLR_b[P8].P6CLR)            /*!< [6..6] output clear data of P86 */
#define GPIO_OUT_PIN_L_P87     (GPIO_CTL->IOPnCLR_b[P8].P7CLR)            /*!< [7..7] output clear data of P87 */

#define GPIO_OUT_PIN_L_P90     (GPIO_CTL->IOPnCLR_b[P9].P0CLR)            /*!< [0..0] output clear data of P90 */
#define GPIO_OUT_PIN_L_P91     (GPIO_CTL->IOPnCLR_b[P9].P1CLR)            /*!< [1..1] output clear data of P91 */
#define GPIO_OUT_PIN_L_P92     (GPIO_CTL->IOPnCLR_b[P9].P2CLR)            /*!< [2..2] output clear data of P92 */
#define GPIO_OUT_PIN_L_P93     (GPIO_CTL->IOPnCLR_b[P9].P3CLR)            /*!< [3..3] output clear data of P93 */
#define GPIO_OUT_PIN_L_P94     (GPIO_CTL->IOPnCLR_b[P9].P4CLR)            /*!< [4..4] output clear data of P94 */
#define GPIO_OUT_PIN_L_P95     (GPIO_CTL->IOPnCLR_b[P9].P5CLR)            /*!< [5..5] output clear data of P95 */
#define GPIO_OUT_PIN_L_P96     (GPIO_CTL->IOPnCLR_b[P9].P6CLR)            /*!< [6..6] output clear data of P96 */
#define GPIO_OUT_PIN_L_P97     (GPIO_CTL->IOPnCLR_b[P9].P7CLR)            /*!< [7..7] output clear data of P97 */

#define GPIO_OUT_PIN_L_PA0     (GPIO_CTL->IOPnCLR_b[PA].P0CLR)            /*!< [0..0] output clear data of PA0 */
#define GPIO_OUT_PIN_L_PA1     (GPIO_CTL->IOPnCLR_b[PA].P1CLR)            /*!< [1..1] output clear data of PA1 */
#define GPIO_OUT_PIN_L_PA2     (GPIO_CTL->IOPnCLR_b[PA].P2CLR)            /*!< [2..2] output clear data of PA2 */
#define GPIO_OUT_PIN_L_PA3     (GPIO_CTL->IOPnCLR_b[PA].P3CLR)            /*!< [3..3] output clear data of PA3 */
#define GPIO_OUT_PIN_L_PA4     (GPIO_CTL->IOPnCLR_b[PA].P4CLR)            /*!< [4..4] output clear data of PA4 */
#define GPIO_OUT_PIN_L_PA5     (GPIO_CTL->IOPnCLR_b[PA].P5CLR)            /*!< [5..5] output clear data of PA5 */
#define GPIO_OUT_PIN_L_PA6     (GPIO_CTL->IOPnCLR_b[PA].P6CLR)            /*!< [6..6] output clear data of PA6 */
#define GPIO_OUT_PIN_L_PA7     (GPIO_CTL->IOPnCLR_b[PA].P7CLR)            /*!< [7..7] output clear data of PA7 */

#define GPIO_OUT_PIN_L_PB0     (GPIO_CTL->IOPnCLR_b[PB].P0CLR)            /*!< [0..0] output clear data of PB0 */
#define GPIO_OUT_PIN_L_PB1     (GPIO_CTL->IOPnCLR_b[PB].P1CLR)            /*!< [1..1] output clear data of PB1 */
#define GPIO_OUT_PIN_L_PB2     (GPIO_CTL->IOPnCLR_b[PB].P2CLR)            /*!< [2..2] output clear data of PB2 */
#define GPIO_OUT_PIN_L_PB3     (GPIO_CTL->IOPnCLR_b[PB].P3CLR)            /*!< [3..3] output clear data of PB3 */
#define GPIO_OUT_PIN_L_PB4     (GPIO_CTL->IOPnCLR_b[PB].P4CLR)            /*!< [4..4] output clear data of PB4 */
#define GPIO_OUT_PIN_L_PB6     (GPIO_CTL->IOPnCLR_b[PB].P6CLR)            /*!< [6..6] output clear data of PB6 */
#define GPIO_OUT_PIN_L_PB7     (GPIO_CTL->IOPnCLR_b[PB].P7CLR)            /*!< [7..7] output clear data of PB7 */

#define GPIO_OUT_PIN_L_PC4     (GPIO_CTL->IOPnCLR_b[PC].P4CLR)            /*!< [4..4] output clear data of PC4 */
#define GPIO_OUT_PIN_L_PC5     (GPIO_CTL->IOPnCLR_b[PC].P5CLR)            /*!< [5..5] output clear data of PC5 */
#define GPIO_OUT_PIN_L_PC6     (GPIO_CTL->IOPnCLR_b[PC].P6CLR)            /*!< [6..6] output clear data of PC6 */
#define GPIO_OUT_PIN_L_PC7     (GPIO_CTL->IOPnCLR_b[PC].P7CLR)            /*!< [7..7] output clear data of PC7 */

#define GPIO_OUT_PIN_L_PD2     (GPIO_CTL->IOPnCLR_b[PD].P2CLR)            /*!< [2..2] output clear data of PD2 */
#define GPIO_OUT_PIN_L_PD3     (GPIO_CTL->IOPnCLR_b[PD].P3CLR)            /*!< [3..3] output clear data of PD3 */
#define GPIO_OUT_PIN_L_PD4     (GPIO_CTL->IOPnCLR_b[PD].P4CLR)            /*!< [4..4] output clear data of PD4 */
#define GPIO_OUT_PIN_L_PD5     (GPIO_CTL->IOPnCLR_b[PD].P5CLR)            /*!< [5..5] output clear data of PD5 */
#define GPIO_OUT_PIN_L_PD6     (GPIO_CTL->IOPnCLR_b[PD].P6CLR)            /*!< [6..6] output clear data of PD6 */
#define GPIO_OUT_PIN_L_PD7     (GPIO_CTL->IOPnCLR_b[PD].P7CLR)            /*!< [7..7] output clear data of PD7 */

#define GPIO_OUT_PIN_L_PE2     (GPIO_CTL->IOPnCLR_b[PE].P2CLR)            /*!< [2..2] output clear data of PE2 */
#define GPIO_OUT_PIN_L_PE3     (GPIO_CTL->IOPnCLR_b[PE].P3CLR)            /*!< [3..3] output clear data of PE3 */
#define GPIO_OUT_PIN_L_PE4     (GPIO_CTL->IOPnCLR_b[PE].P4CLR)            /*!< [4..4] output clear data of PE4 */
#define GPIO_OUT_PIN_L_PE5     (GPIO_CTL->IOPnCLR_b[PE].P5CLR)            /*!< [5..5] output clear data of PE5 */
#define GPIO_OUT_PIN_L_PE6     (GPIO_CTL->IOPnCLR_b[PE].P6CLR)            /*!< [6..6] output clear data of PE6 */
#define GPIO_OUT_PIN_L_PE7     (GPIO_CTL->IOPnCLR_b[PE].P7CLR)            /*!< [7..7] output clear data of PE7 */

#define GPIO_OUT_PIN_L_PF0     (GPIO_CTL->IOPnCLR_b[PF].P0CLR)            /*!< [0..0] output clear data of PF0 */
#define GPIO_OUT_PIN_L_PF1     (GPIO_CTL->IOPnCLR_b[PF].P1CLR)            /*!< [1..1] output clear data of PF1 */
#define GPIO_OUT_PIN_L_PF2     (GPIO_CTL->IOPnCLR_b[PF].P2CLR)            /*!< [2..2] output clear data of PF2 */
#define GPIO_OUT_PIN_L_PF3     (GPIO_CTL->IOPnCLR_b[PF].P3CLR)            /*!< [3..3] output clear data of PF3 */
#define GPIO_OUT_PIN_L_PF4     (GPIO_CTL->IOPnCLR_b[PF].P4CLR)            /*!< [4..4] output clear data of PF4 */
#define GPIO_OUT_PIN_L_PF5     (GPIO_CTL->IOPnCLR_b[PF].P5CLR)            /*!< [5..5] output clear data of PF5 */
#define GPIO_OUT_PIN_L_PF6     (GPIO_CTL->IOPnCLR_b[PF].P6CLR)            /*!< [6..6] output clear data of PF6 */
#define GPIO_OUT_PIN_L_PF7     (GPIO_CTL->IOPnCLR_b[PF].P7CLR)            /*!< [7..7] output clear data of PF7 */

/*---------------------------------------------------------------------------------------------------------*/
/*  The output level of the specified pin to High                                                          */
/*---------------------------------------------------------------------------------------------------------*/
#define GPIO_OUT_PIN_H_P00     (GPIO_CTL->IOPnSET_b[P0].P0SET)            /*!< [0..0] output set data of P00 */
#define GPIO_OUT_PIN_H_P01     (GPIO_CTL->IOPnSET_b[P0].P1SET)            /*!< [1..1] output set data of P01 */
#define GPIO_OUT_PIN_H_P02     (GPIO_CTL->IOPnSET_b[P0].P2SET)            /*!< [2..2] output set data of P02 */
#define GPIO_OUT_PIN_H_P03     (GPIO_CTL->IOPnSET_b[P0].P3SET)            /*!< [3..3] output set data of P03 */
#define GPIO_OUT_PIN_H_P04     (GPIO_CTL->IOPnSET_b[P0].P4SET)            /*!< [4..4] output set data of P04 */
#define GPIO_OUT_PIN_H_P05     (GPIO_CTL->IOPnSET_b[P0].P5SET)            /*!< [5..5] output set data of P05 */
#define GPIO_OUT_PIN_H_P06     (GPIO_CTL->IOPnSET_b[P0].P6SET)            /*!< [6..6] output set data of P06 */
#define GPIO_OUT_PIN_H_P07     (GPIO_CTL->IOPnSET_b[P0].P7SET)            /*!< [7..7] output set data of P07 */

#define GPIO_OUT_PIN_H_P10     (GPIO_CTL->IOPnSET_b[P1].P0SET)            /*!< [0..0] output set data of P10 */
#define GPIO_OUT_PIN_H_P11     (GPIO_CTL->IOPnSET_b[P1].P1SET)            /*!< [1..1] output set data of P11 */
#define GPIO_OUT_PIN_H_P12     (GPIO_CTL->IOPnSET_b[P1].P2SET)            /*!< [2..2] output set data of P12 */
#define GPIO_OUT_PIN_H_P13     (GPIO_CTL->IOPnSET_b[P1].P3SET)            /*!< [3..3] output set data of P13 */
#define GPIO_OUT_PIN_H_P14     (GPIO_CTL->IOPnSET_b[P1].P4SET)            /*!< [4..4] output set data of P14 */
#define GPIO_OUT_PIN_H_P15     (GPIO_CTL->IOPnSET_b[P1].P5SET)            /*!< [5..5] output set data of P15 */
#define GPIO_OUT_PIN_H_P16     (GPIO_CTL->IOPnSET_b[P1].P6SET)            /*!< [6..6] output set data of P16 */
#define GPIO_OUT_PIN_H_P17     (GPIO_CTL->IOPnSET_b[P1].P7SET)            /*!< [7..7] output set data of P17 */

#define GPIO_OUT_PIN_H_P20     (GPIO_CTL->IOPnSET_b[P2].P0SET)            /*!< [0..0] output set data of P20 */
#define GPIO_OUT_PIN_H_P21     (GPIO_CTL->IOPnSET_b[P2].P1SET)            /*!< [1..1] output set data of P21 */
#define GPIO_OUT_PIN_H_P22     (GPIO_CTL->IOPnSET_b[P2].P2SET)            /*!< [2..2] output set data of P22 */
#define GPIO_OUT_PIN_H_P24     (GPIO_CTL->IOPnSET_b[P2].P4SET)            /*!< [4..4] output set data of P24 */
#define GPIO_OUT_PIN_H_P25     (GPIO_CTL->IOPnSET_b[P2].P5SET)            /*!< [5..5] output set data of P25 */
#define GPIO_OUT_PIN_H_P26     (GPIO_CTL->IOPnSET_b[P2].P6SET)            /*!< [6..6] output set data of P26 */
#define GPIO_OUT_PIN_H_P27     (GPIO_CTL->IOPnSET_b[P2].P7SET)            /*!< [7..7] output set data of P27 */

#define GPIO_OUT_PIN_H_P30     (GPIO_CTL->IOPnSET_b[P3].P0SET)            /*!< [0..0] output set data of P30 */
#define GPIO_OUT_PIN_H_P31     (GPIO_CTL->IOPnSET_b[P3].P1SET)            /*!< [1..1] output set data of P31 */
#define GPIO_OUT_PIN_H_P32     (GPIO_CTL->IOPnSET_b[P3].P2SET)            /*!< [2..2] output set data of P32 */
#define GPIO_OUT_PIN_H_P34     (GPIO_CTL->IOPnSET_b[P3].P4SET)            /*!< [4..4] output set data of P34 */
#define GPIO_OUT_PIN_H_P35     (GPIO_CTL->IOPnSET_b[P3].P5SET)            /*!< [5..5] output set data of P35 */
#define GPIO_OUT_PIN_H_P36     (GPIO_CTL->IOPnSET_b[P3].P6SET)            /*!< [6..6] output set data of P36 */

#define GPIO_OUT_PIN_H_P40     (GPIO_CTL->IOPnSET_b[P4].P0SET)            /*!< [0..0] output set data of P40 */
#define GPIO_OUT_PIN_H_P41     (GPIO_CTL->IOPnSET_b[P4].P1SET)            /*!< [1..1] output set data of P41 */
#define GPIO_OUT_PIN_H_P42     (GPIO_CTL->IOPnSET_b[P4].P2SET)            /*!< [2..2] output set data of P42 */
#define GPIO_OUT_PIN_H_P44     (GPIO_CTL->IOPnSET_b[P4].P4SET)            /*!< [4..4] output set data of P44 */
#define GPIO_OUT_PIN_H_P45     (GPIO_CTL->IOPnSET_b[P4].P5SET)            /*!< [5..5] output set data of P45 */
#define GPIO_OUT_PIN_H_P46     (GPIO_CTL->IOPnSET_b[P4].P6SET)            /*!< [6..6] output set data of P46 */
#define GPIO_OUT_PIN_H_P47     (GPIO_CTL->IOPnSET_b[P4].P7SET)            /*!< [7..7] output set data of P47 */

#define GPIO_OUT_PIN_H_P50     (GPIO_CTL->IOPnSET_b[P5].P0SET)            /*!< [0..0] output set data of P50 */
#define GPIO_OUT_PIN_H_P51     (GPIO_CTL->IOPnSET_b[P5].P1SET)            /*!< [1..1] output set data of P51 */
#define GPIO_OUT_PIN_H_P52     (GPIO_CTL->IOPnSET_b[P5].P2SET)            /*!< [2..2] output set data of P52 */
#define GPIO_OUT_PIN_H_P53     (GPIO_CTL->IOPnSET_b[P5].P3SET)            /*!< [3..3] output set data of P53 */
#define GPIO_OUT_PIN_H_P54     (GPIO_CTL->IOPnSET_b[P5].P4SET)            /*!< [4..4] output set data of P54 */
#define GPIO_OUT_PIN_H_P55     (GPIO_CTL->IOPnSET_b[P5].P5SET)            /*!< [5..5] output set data of P55 */
#define GPIO_OUT_PIN_H_P56     (GPIO_CTL->IOPnSET_b[P5].P6SET)            /*!< [6..6] output set data of P56 */
#define GPIO_OUT_PIN_H_P57     (GPIO_CTL->IOPnSET_b[P5].P7SET)            /*!< [7..7] output set data of P57 */

#define GPIO_OUT_PIN_H_P60     (GPIO_CTL->IOPnSET_b[P6].P0SET)            /*!< [0..0] output set data of P60 */
#define GPIO_OUT_PIN_H_P61     (GPIO_CTL->IOPnSET_b[P6].P1SET)            /*!< [1..1] output set data of P61 */
#define GPIO_OUT_PIN_H_P62     (GPIO_CTL->IOPnSET_b[P6].P2SET)            /*!< [2..2] output set data of P62 */
#define GPIO_OUT_PIN_H_P63     (GPIO_CTL->IOPnSET_b[P6].P3SET)            /*!< [3..3] output set data of P63 */
#define GPIO_OUT_PIN_H_P64     (GPIO_CTL->IOPnSET_b[P6].P4SET)            /*!< [4..4] output set data of P64 */
#define GPIO_OUT_PIN_H_P65     (GPIO_CTL->IOPnSET_b[P6].P5SET)            /*!< [5..5] output set data of P65 */
#define GPIO_OUT_PIN_H_P66     (GPIO_CTL->IOPnSET_b[P6].P6SET)            /*!< [6..6] output set data of P66 */
#define GPIO_OUT_PIN_H_P67     (GPIO_CTL->IOPnSET_b[P6].P7SET)            /*!< [7..7] output set data of P67 */

#define GPIO_OUT_PIN_H_P70     (GPIO_CTL->IOPnSET_b[P7].P0SET)            /*!< [0..0] output set data of P70 */
#define GPIO_OUT_PIN_H_P71     (GPIO_CTL->IOPnSET_b[P7].P1SET)            /*!< [1..1] output set data of P71 */
#define GPIO_OUT_PIN_H_P72     (GPIO_CTL->IOPnSET_b[P7].P2SET)            /*!< [2..2] output set data of P72 */
#define GPIO_OUT_PIN_H_P73     (GPIO_CTL->IOPnSET_b[P7].P3SET)            /*!< [3..3] output set data of P73 */
#define GPIO_OUT_PIN_H_P74     (GPIO_CTL->IOPnSET_b[P7].P4SET)            /*!< [4..4] output set data of P74 */
#define GPIO_OUT_PIN_H_P75     (GPIO_CTL->IOPnSET_b[P7].P5SET)            /*!< [5..5] output set data of P75 */
#define GPIO_OUT_PIN_H_P76     (GPIO_CTL->IOPnSET_b[P7].P6SET)            /*!< [6..6] output set data of P76 */
#define GPIO_OUT_PIN_H_P77     (GPIO_CTL->IOPnSET_b[P7].P7SET)            /*!< [7..7] output set data of P77 */

#define GPIO_OUT_PIN_H_P80     (GPIO_CTL->IOPnSET_b[P8].P0SET)            /*!< [0..0] output set data of P80 */
#define GPIO_OUT_PIN_H_P81     (GPIO_CTL->IOPnSET_b[P8].P1SET)            /*!< [1..1] output set data of P81 */
#define GPIO_OUT_PIN_H_P82     (GPIO_CTL->IOPnSET_b[P8].P2SET)            /*!< [2..2] output set data of P82 */
#define GPIO_OUT_PIN_H_P83     (GPIO_CTL->IOPnSET_b[P8].P3SET)            /*!< [3..3] output set data of P83 */
#define GPIO_OUT_PIN_H_P84     (GPIO_CTL->IOPnSET_b[P8].P4SET)            /*!< [4..4] output set data of P84 */
#define GPIO_OUT_PIN_H_P85     (GPIO_CTL->IOPnSET_b[P8].P5SET)            /*!< [5..5] output set data of P85 */
#define GPIO_OUT_PIN_H_P86     (GPIO_CTL->IOPnSET_b[P8].P6SET)            /*!< [6..6] output set data of P86 */
#define GPIO_OUT_PIN_H_P87     (GPIO_CTL->IOPnSET_b[P8].P7SET)            /*!< [7..7] output set data of P87 */

#define GPIO_OUT_PIN_H_P90     (GPIO_CTL->IOPnSET_b[P9].P0SET)            /*!< [0..0] output set data of P90 */
#define GPIO_OUT_PIN_H_P91     (GPIO_CTL->IOPnSET_b[P9].P1SET)            /*!< [1..1] output set data of P91 */
#define GPIO_OUT_PIN_H_P92     (GPIO_CTL->IOPnSET_b[P9].P2SET)            /*!< [2..2] output set data of P92 */
#define GPIO_OUT_PIN_H_P93     (GPIO_CTL->IOPnSET_b[P9].P3SET)            /*!< [3..3] output set data of P93 */
#define GPIO_OUT_PIN_H_P94     (GPIO_CTL->IOPnSET_b[P9].P4SET)            /*!< [4..4] output set data of P94 */
#define GPIO_OUT_PIN_H_P95     (GPIO_CTL->IOPnSET_b[P9].P5SET)            /*!< [5..5] output set data of P95 */
#define GPIO_OUT_PIN_H_P96     (GPIO_CTL->IOPnSET_b[P9].P6SET)            /*!< [6..6] output set data of P96 */
#define GPIO_OUT_PIN_H_P97     (GPIO_CTL->IOPnSET_b[P9].P7SET)            /*!< [7..7] output set data of P97 */

#define GPIO_OUT_PIN_H_PA0     (GPIO_CTL->IOPnSET_b[PA].P0SET)            /*!< [0..0] output set data of PA0 */
#define GPIO_OUT_PIN_H_PA1     (GPIO_CTL->IOPnSET_b[PA].P1SET)            /*!< [1..1] output set data of PA1 */
#define GPIO_OUT_PIN_H_PA2     (GPIO_CTL->IOPnSET_b[PA].P2SET)            /*!< [2..2] output set data of PA2 */
#define GPIO_OUT_PIN_H_PA3     (GPIO_CTL->IOPnSET_b[PA].P3SET)            /*!< [3..3] output set data of PA3 */
#define GPIO_OUT_PIN_H_PA4     (GPIO_CTL->IOPnSET_b[PA].P4SET)            /*!< [4..4] output set data of PA4 */
#define GPIO_OUT_PIN_H_PA5     (GPIO_CTL->IOPnSET_b[PA].P5SET)            /*!< [5..5] output set data of PA5 */
#define GPIO_OUT_PIN_H_PA6     (GPIO_CTL->IOPnSET_b[PA].P6SET)            /*!< [6..6] output set data of PA6 */
#define GPIO_OUT_PIN_H_PA7     (GPIO_CTL->IOPnSET_b[PA].P7SET)            /*!< [7..7] output set data of PA7 */

#define GPIO_OUT_PIN_H_PB0     (GPIO_CTL->IOPnSET_b[PB].P0SET)            /*!< [0..0] output set data of PB0 */
#define GPIO_OUT_PIN_H_PB1     (GPIO_CTL->IOPnSET_b[PB].P1SET)            /*!< [1..1] output set data of PB1 */
#define GPIO_OUT_PIN_H_PB2     (GPIO_CTL->IOPnSET_b[PB].P2SET)            /*!< [2..2] output set data of PB2 */
#define GPIO_OUT_PIN_H_PB3     (GPIO_CTL->IOPnSET_b[PB].P3SET)            /*!< [3..3] output set data of PB3 */
#define GPIO_OUT_PIN_H_PB4     (GPIO_CTL->IOPnSET_b[PB].P4SET)            /*!< [4..4] output set data of PB4 */
#define GPIO_OUT_PIN_H_PB6     (GPIO_CTL->IOPnSET_b[PB].P6SET)            /*!< [6..6] output set data of PB6 */
#define GPIO_OUT_PIN_H_PB7     (GPIO_CTL->IOPnSET_b[PB].P7SET)            /*!< [7..7] output set data of PB7 */

#define GPIO_OUT_PIN_H_PC4     (GPIO_CTL->IOPnSET_b[PC].P4SET)            /*!< [4..4] output set data of PC4 */
#define GPIO_OUT_PIN_H_PC5     (GPIO_CTL->IOPnSET_b[PC].P5SET)            /*!< [5..5] output set data of PC5 */
#define GPIO_OUT_PIN_H_PC6     (GPIO_CTL->IOPnSET_b[PC].P6SET)            /*!< [6..6] output set data of PC6 */
#define GPIO_OUT_PIN_H_PC7     (GPIO_CTL->IOPnSET_b[PC].P7SET)            /*!< [7..7] output set data of PC7 */

#define GPIO_OUT_PIN_H_PD2     (GPIO_CTL->IOPnSET_b[PD].P2SET)            /*!< [2..2] output set data of PD2 */
#define GPIO_OUT_PIN_H_PD3     (GPIO_CTL->IOPnSET_b[PD].P3SET)            /*!< [3..3] output set data of PD3 */
#define GPIO_OUT_PIN_H_PD4     (GPIO_CTL->IOPnSET_b[PD].P4SET)            /*!< [4..4] output set data of PD4 */
#define GPIO_OUT_PIN_H_PD5     (GPIO_CTL->IOPnSET_b[PD].P5SET)            /*!< [5..5] output set data of PD5 */
#define GPIO_OUT_PIN_H_PD6     (GPIO_CTL->IOPnSET_b[PD].P6SET)            /*!< [6..6] output set data of PD6 */
#define GPIO_OUT_PIN_H_PD7     (GPIO_CTL->IOPnSET_b[PD].P7SET)            /*!< [7..7] output set data of PD7 */

#define GPIO_OUT_PIN_H_PE2     (GPIO_CTL->IOPnSET_b[PE].P2SET)            /*!< [2..2] output set data of PE2 */
#define GPIO_OUT_PIN_H_PE3     (GPIO_CTL->IOPnSET_b[PE].P3SET)            /*!< [3..3] output set data of PE3 */
#define GPIO_OUT_PIN_H_PE4     (GPIO_CTL->IOPnSET_b[PE].P4SET)            /*!< [4..4] output set data of PE4 */
#define GPIO_OUT_PIN_H_PE5     (GPIO_CTL->IOPnSET_b[PE].P5SET)            /*!< [5..5] output set data of PE5 */
#define GPIO_OUT_PIN_H_PE6     (GPIO_CTL->IOPnSET_b[PE].P6SET)            /*!< [6..6] output set data of PE6 */
#define GPIO_OUT_PIN_H_PE7     (GPIO_CTL->IOPnSET_b[PE].P7SET)            /*!< [7..7] output set data of PE7 */

#define GPIO_OUT_PIN_H_PF0     (GPIO_CTL->IOPnSET_b[PF].P0SET)            /*!< [0..0] output set data of PF0 */
#define GPIO_OUT_PIN_H_PF1     (GPIO_CTL->IOPnSET_b[PF].P1SET)            /*!< [1..1] output set data of PF1 */
#define GPIO_OUT_PIN_H_PF2     (GPIO_CTL->IOPnSET_b[PF].P2SET)            /*!< [2..2] output set data of PF2 */
#define GPIO_OUT_PIN_H_PF3     (GPIO_CTL->IOPnSET_b[PF].P3SET)            /*!< [3..3] output set data of PF3 */
#define GPIO_OUT_PIN_H_PF4     (GPIO_CTL->IOPnSET_b[PF].P4SET)            /*!< [4..4] output set data of PF4 */
#define GPIO_OUT_PIN_H_PF5     (GPIO_CTL->IOPnSET_b[PF].P5SET)            /*!< [5..5] output set data of PF5 */
#define GPIO_OUT_PIN_H_PF6     (GPIO_CTL->IOPnSET_b[PF].P6SET)            /*!< [6..6] output set data of PF6 */
#define GPIO_OUT_PIN_H_PF7     (GPIO_CTL->IOPnSET_b[PF].P7SET)            /*!< [7..7] output set data of PF7 */

/*---------------------------------------------------------------------------------------------------------*/
/*  Toggle the output level of the specified pin (0 -> 1, 1 -> 0)                                          */
/*---------------------------------------------------------------------------------------------------------*/
#define GPIO_TGL_PIN_P00     (GPIO_CTL->IOPnTGL_b[P0].P0TGL)            /*!< [0..0] output toggle data of P00 */
#define GPIO_TGL_PIN_P01     (GPIO_CTL->IOPnTGL_b[P0].P1TGL)            /*!< [1..1] output toggle data of P01 */
#define GPIO_TGL_PIN_P02     (GPIO_CTL->IOPnTGL_b[P0].P2TGL)            /*!< [2..2] output toggle data of P02 */
#define GPIO_TGL_PIN_P03     (GPIO_CTL->IOPnTGL_b[P0].P3TGL)            /*!< [3..3] output toggle data of P03 */
#define GPIO_TGL_PIN_P04     (GPIO_CTL->IOPnTGL_b[P0].P4TGL)            /*!< [4..4] output toggle data of P04 */
#define GPIO_TGL_PIN_P05     (GPIO_CTL->IOPnTGL_b[P0].P5TGL)            /*!< [5..5] output toggle data of P05 */
#define GPIO_TGL_PIN_P06     (GPIO_CTL->IOPnTGL_b[P0].P6TGL)            /*!< [6..6] output toggle data of P06 */
#define GPIO_TGL_PIN_P07     (GPIO_CTL->IOPnTGL_b[P0].P7TGL)            /*!< [7..7] output toggle data of P07 */

#define GPIO_TGL_PIN_P10     (GPIO_CTL->IOPnTGL_b[P1].P0TGL)            /*!< [0..0] output toggle data of P10 */
#define GPIO_TGL_PIN_P11     (GPIO_CTL->IOPnTGL_b[P1].P1TGL)            /*!< [1..1] output toggle data of P11 */
#define GPIO_TGL_PIN_P12     (GPIO_CTL->IOPnTGL_b[P1].P2TGL)            /*!< [2..2] output toggle data of P12 */
#define GPIO_TGL_PIN_P13     (GPIO_CTL->IOPnTGL_b[P1].P3TGL)            /*!< [3..3] output toggle data of P13 */
#define GPIO_TGL_PIN_P14     (GPIO_CTL->IOPnTGL_b[P1].P4TGL)            /*!< [4..4] output toggle data of P14 */
#define GPIO_TGL_PIN_P15     (GPIO_CTL->IOPnTGL_b[P1].P5TGL)            /*!< [5..5] output toggle data of P15 */
#define GPIO_TGL_PIN_P16     (GPIO_CTL->IOPnTGL_b[P1].P6TGL)            /*!< [6..6] output toggle data of P16 */
#define GPIO_TGL_PIN_P17     (GPIO_CTL->IOPnTGL_b[P1].P7TGL)            /*!< [7..7] output toggle data of P17 */

#define GPIO_TGL_PIN_P20     (GPIO_CTL->IOPnTGL_b[P2].P0TGL)            /*!< [0..0] output toggle data of P20 */
#define GPIO_TGL_PIN_P21     (GPIO_CTL->IOPnTGL_b[P2].P1TGL)            /*!< [1..1] output toggle data of P21 */
#define GPIO_TGL_PIN_P22     (GPIO_CTL->IOPnTGL_b[P2].P2TGL)            /*!< [2..2] output toggle data of P22 */
#define GPIO_TGL_PIN_P24     (GPIO_CTL->IOPnTGL_b[P2].P4TGL)            /*!< [4..4] output toggle data of P24 */
#define GPIO_TGL_PIN_P25     (GPIO_CTL->IOPnTGL_b[P2].P5TGL)            /*!< [5..5] output toggle data of P25 */
#define GPIO_TGL_PIN_P26     (GPIO_CTL->IOPnTGL_b[P2].P6TGL)            /*!< [6..6] output toggle data of P26 */
#define GPIO_TGL_PIN_P27     (GPIO_CTL->IOPnTGL_b[P2].P7TGL)            /*!< [7..7] output toggle data of P27 */

#define GPIO_TGL_PIN_P30     (GPIO_CTL->IOPnTGL_b[P3].P0TGL)            /*!< [0..0] output toggle data of P30 */
#define GPIO_TGL_PIN_P31     (GPIO_CTL->IOPnTGL_b[P3].P1TGL)            /*!< [1..1] output toggle data of P31 */
#define GPIO_TGL_PIN_P32     (GPIO_CTL->IOPnTGL_b[P3].P2TGL)            /*!< [2..2] output toggle data of P32 */
#define GPIO_TGL_PIN_P34     (GPIO_CTL->IOPnTGL_b[P3].P4TGL)            /*!< [4..4] output toggle data of P34 */
#define GPIO_TGL_PIN_P35     (GPIO_CTL->IOPnTGL_b[P3].P5TGL)            /*!< [5..5] output toggle data of P35 */
#define GPIO_TGL_PIN_P36     (GPIO_CTL->IOPnTGL_b[P3].P6TGL)            /*!< [6..6] output toggle data of P36 */

#define GPIO_TGL_PIN_P40     (GPIO_CTL->IOPnTGL_b[P4].P0TGL)            /*!< [0..0] output toggle data of P40 */
#define GPIO_TGL_PIN_P41     (GPIO_CTL->IOPnTGL_b[P4].P1TGL)            /*!< [1..1] output toggle data of P41 */
#define GPIO_TGL_PIN_P42     (GPIO_CTL->IOPnTGL_b[P4].P2TGL)            /*!< [2..2] output toggle data of P42 */
#define GPIO_TGL_PIN_P44     (GPIO_CTL->IOPnTGL_b[P4].P4TGL)            /*!< [4..4] output toggle data of P44 */
#define GPIO_TGL_PIN_P45     (GPIO_CTL->IOPnTGL_b[P4].P5TGL)            /*!< [5..5] output toggle data of P45 */
#define GPIO_TGL_PIN_P46     (GPIO_CTL->IOPnTGL_b[P4].P6TGL)            /*!< [6..6] output toggle data of P46 */
#define GPIO_TGL_PIN_P47     (GPIO_CTL->IOPnTGL_b[P4].P7TGL)            /*!< [7..7] output toggle data of P47 */

#define GPIO_TGL_PIN_P50     (GPIO_CTL->IOPnTGL_b[P5].P0TGL)            /*!< [0..0] output toggle data of P50 */
#define GPIO_TGL_PIN_P51     (GPIO_CTL->IOPnTGL_b[P5].P1TGL)            /*!< [1..1] output toggle data of P51 */
#define GPIO_TGL_PIN_P52     (GPIO_CTL->IOPnTGL_b[P5].P2TGL)            /*!< [2..2] output toggle data of P52 */
#define GPIO_TGL_PIN_P53     (GPIO_CTL->IOPnTGL_b[P5].P3TGL)            /*!< [3..3] output toggle data of P53 */
#define GPIO_TGL_PIN_P54     (GPIO_CTL->IOPnTGL_b[P5].P4TGL)            /*!< [4..4] output toggle data of P54 */
#define GPIO_TGL_PIN_P55     (GPIO_CTL->IOPnTGL_b[P5].P5TGL)            /*!< [5..5] output toggle data of P55 */
#define GPIO_TGL_PIN_P56     (GPIO_CTL->IOPnTGL_b[P5].P6TGL)            /*!< [6..6] output toggle data of P56 */
#define GPIO_TGL_PIN_P57     (GPIO_CTL->IOPnTGL_b[P5].P7TGL)            /*!< [7..7] output toggle data of P57 */

#define GPIO_TGL_PIN_P60     (GPIO_CTL->IOPnTGL_b[P6].P0TGL)            /*!< [0..0] output toggle data of P60 */
#define GPIO_TGL_PIN_P61     (GPIO_CTL->IOPnTGL_b[P6].P1TGL)            /*!< [1..1] output toggle data of P61 */
#define GPIO_TGL_PIN_P62     (GPIO_CTL->IOPnTGL_b[P6].P2TGL)            /*!< [2..2] output toggle data of P62 */
#define GPIO_TGL_PIN_P63     (GPIO_CTL->IOPnTGL_b[P6].P3TGL)            /*!< [3..3] output toggle data of P63 */
#define GPIO_TGL_PIN_P64     (GPIO_CTL->IOPnTGL_b[P6].P4TGL)            /*!< [4..4] output toggle data of P64 */
#define GPIO_TGL_PIN_P65     (GPIO_CTL->IOPnTGL_b[P6].P5TGL)            /*!< [5..5] output toggle data of P65 */
#define GPIO_TGL_PIN_P66     (GPIO_CTL->IOPnTGL_b[P6].P6TGL)            /*!< [6..6] output toggle data of P66 */
#define GPIO_TGL_PIN_P67     (GPIO_CTL->IOPnTGL_b[P6].P7TGL)            /*!< [7..7] output toggle data of P67 */

#define GPIO_TGL_PIN_P70     (GPIO_CTL->IOPnTGL_b[P7].P0TGL)            /*!< [0..0] output toggle data of P70 */
#define GPIO_TGL_PIN_P71     (GPIO_CTL->IOPnTGL_b[P7].P1TGL)            /*!< [1..1] output toggle data of P71 */
#define GPIO_TGL_PIN_P72     (GPIO_CTL->IOPnTGL_b[P7].P2TGL)            /*!< [2..2] output toggle data of P72 */
#define GPIO_TGL_PIN_P73     (GPIO_CTL->IOPnTGL_b[P7].P3TGL)            /*!< [3..3] output toggle data of P73 */
#define GPIO_TGL_PIN_P74     (GPIO_CTL->IOPnTGL_b[P7].P4TGL)            /*!< [4..4] output toggle data of P74 */
#define GPIO_TGL_PIN_P75     (GPIO_CTL->IOPnTGL_b[P7].P5TGL)            /*!< [5..5] output toggle data of P75 */
#define GPIO_TGL_PIN_P76     (GPIO_CTL->IOPnTGL_b[P7].P6TGL)            /*!< [6..6] output toggle data of P76 */
#define GPIO_TGL_PIN_P77     (GPIO_CTL->IOPnTGL_b[P7].P7TGL)            /*!< [7..7] output toggle data of P77 */

#define GPIO_TGL_PIN_P80     (GPIO_CTL->IOPnTGL_b[P8].P0TGL)            /*!< [0..0] output toggle data of P80 */
#define GPIO_TGL_PIN_P81     (GPIO_CTL->IOPnTGL_b[P8].P1TGL)            /*!< [1..1] output toggle data of P81 */
#define GPIO_TGL_PIN_P82     (GPIO_CTL->IOPnTGL_b[P8].P2TGL)            /*!< [2..2] output toggle data of P82 */
#define GPIO_TGL_PIN_P83     (GPIO_CTL->IOPnTGL_b[P8].P3TGL)            /*!< [3..3] output toggle data of P83 */
#define GPIO_TGL_PIN_P84     (GPIO_CTL->IOPnTGL_b[P8].P4TGL)            /*!< [4..4] output toggle data of P84 */
#define GPIO_TGL_PIN_P85     (GPIO_CTL->IOPnTGL_b[P8].P5TGL)            /*!< [5..5] output toggle data of P85 */
#define GPIO_TGL_PIN_P86     (GPIO_CTL->IOPnTGL_b[P8].P6TGL)            /*!< [6..6] output toggle data of P86 */
#define GPIO_TGL_PIN_P87     (GPIO_CTL->IOPnTGL_b[P8].P7TGL)            /*!< [7..7] output toggle data of P87 */

#define GPIO_TGL_PIN_P90     (GPIO_CTL->IOPnTGL_b[P9].P0TGL)            /*!< [0..0] output toggle data of P90 */
#define GPIO_TGL_PIN_P91     (GPIO_CTL->IOPnTGL_b[P9].P1TGL)            /*!< [1..1] output toggle data of P91 */
#define GPIO_TGL_PIN_P92     (GPIO_CTL->IOPnTGL_b[P9].P2TGL)            /*!< [2..2] output toggle data of P92 */
#define GPIO_TGL_PIN_P93     (GPIO_CTL->IOPnTGL_b[P9].P3TGL)            /*!< [3..3] output toggle data of P93 */
#define GPIO_TGL_PIN_P94     (GPIO_CTL->IOPnTGL_b[P9].P4TGL)            /*!< [4..4] output toggle data of P94 */
#define GPIO_TGL_PIN_P95     (GPIO_CTL->IOPnTGL_b[P9].P5TGL)            /*!< [5..5] output toggle data of P95 */
#define GPIO_TGL_PIN_P96     (GPIO_CTL->IOPnTGL_b[P9].P6TGL)            /*!< [6..6] output toggle data of P96 */
#define GPIO_TGL_PIN_P97     (GPIO_CTL->IOPnTGL_b[P9].P7TGL)            /*!< [7..7] output toggle data of P97 */

#define GPIO_TGL_PIN_PA0     (GPIO_CTL->IOPnTGL_b[PA].P0TGL)            /*!< [0..0] output toggle data of PA0 */
#define GPIO_TGL_PIN_PA1     (GPIO_CTL->IOPnTGL_b[PA].P1TGL)            /*!< [1..1] output toggle data of PA1 */
#define GPIO_TGL_PIN_PA2     (GPIO_CTL->IOPnTGL_b[PA].P2TGL)            /*!< [2..2] output toggle data of PA2 */
#define GPIO_TGL_PIN_PA3     (GPIO_CTL->IOPnTGL_b[PA].P3TGL)            /*!< [3..3] output toggle data of PA3 */
#define GPIO_TGL_PIN_PA4     (GPIO_CTL->IOPnTGL_b[PA].P4TGL)            /*!< [4..4] output toggle data of PA4 */
#define GPIO_TGL_PIN_PA5     (GPIO_CTL->IOPnTGL_b[PA].P5TGL)            /*!< [5..5] output toggle data of PA5 */
#define GPIO_TGL_PIN_PA6     (GPIO_CTL->IOPnTGL_b[PA].P6TGL)            /*!< [6..6] output toggle data of PA6 */
#define GPIO_TGL_PIN_PA7     (GPIO_CTL->IOPnTGL_b[PA].P7TGL)            /*!< [7..7] output toggle data of PA7 */

#define GPIO_TGL_PIN_PB0     (GPIO_CTL->IOPnTGL_b[PB].P0TGL)            /*!< [0..0] output toggle data of PB0 */
#define GPIO_TGL_PIN_PB1     (GPIO_CTL->IOPnTGL_b[PB].P1TGL)            /*!< [1..1] output toggle data of PB1 */
#define GPIO_TGL_PIN_PB2     (GPIO_CTL->IOPnTGL_b[PB].P2TGL)            /*!< [2..2] output toggle data of PB2 */
#define GPIO_TGL_PIN_PB3     (GPIO_CTL->IOPnTGL_b[PB].P3TGL)            /*!< [3..3] output toggle data of PB3 */
#define GPIO_TGL_PIN_PB4     (GPIO_CTL->IOPnTGL_b[PB].P4TGL)            /*!< [4..4] output toggle data of PB4 */
#define GPIO_TGL_PIN_PB6     (GPIO_CTL->IOPnTGL_b[PB].P6TGL)            /*!< [6..6] output toggle data of PB6 */
#define GPIO_TGL_PIN_PB7     (GPIO_CTL->IOPnTGL_b[PB].P7TGL)            /*!< [7..7] output toggle data of PB7 */

#define GPIO_TGL_PIN_PC4     (GPIO_CTL->IOPnTGL_b[PC].P4TGL)            /*!< [4..4] output toggle data of PC4 */
#define GPIO_TGL_PIN_PC5     (GPIO_CTL->IOPnTGL_b[PC].P5TGL)            /*!< [5..5] output toggle data of PC5 */
#define GPIO_TGL_PIN_PC6     (GPIO_CTL->IOPnTGL_b[PC].P6TGL)            /*!< [6..6] output toggle data of PC6 */
#define GPIO_TGL_PIN_PC7     (GPIO_CTL->IOPnTGL_b[PC].P7TGL)            /*!< [7..7] output toggle data of PC7 */

#define GPIO_TGL_PIN_PD2     (GPIO_CTL->IOPnTGL_b[PD].P2TGL)            /*!< [2..2] output toggle data of PD2 */
#define GPIO_TGL_PIN_PD3     (GPIO_CTL->IOPnTGL_b[PD].P3TGL)            /*!< [3..3] output toggle data of PD3 */
#define GPIO_TGL_PIN_PD4     (GPIO_CTL->IOPnTGL_b[PD].P4TGL)            /*!< [4..4] output toggle data of PD4 */
#define GPIO_TGL_PIN_PD5     (GPIO_CTL->IOPnTGL_b[PD].P5TGL)            /*!< [5..5] output toggle data of PD5 */
#define GPIO_TGL_PIN_PD6     (GPIO_CTL->IOPnTGL_b[PD].P6TGL)            /*!< [6..6] output toggle data of PD6 */
#define GPIO_TGL_PIN_PD7     (GPIO_CTL->IOPnTGL_b[PD].P7TGL)            /*!< [7..7] output toggle data of PD7 */

#define GPIO_TGL_PIN_PE2     (GPIO_CTL->IOPnTGL_b[PE].P2TGL)            /*!< [2..2] output toggle data of PE2 */
#define GPIO_TGL_PIN_PE3     (GPIO_CTL->IOPnTGL_b[PE].P3TGL)            /*!< [3..3] output toggle data of PE3 */
#define GPIO_TGL_PIN_PE4     (GPIO_CTL->IOPnTGL_b[PE].P4TGL)            /*!< [4..4] output toggle data of PE4 */
#define GPIO_TGL_PIN_PE5     (GPIO_CTL->IOPnTGL_b[PE].P5TGL)            /*!< [5..5] output toggle data of PE5 */
#define GPIO_TGL_PIN_PE6     (GPIO_CTL->IOPnTGL_b[PE].P6TGL)            /*!< [6..6] output toggle data of PE6 */
#define GPIO_TGL_PIN_PE7     (GPIO_CTL->IOPnTGL_b[PE].P7TGL)            /*!< [7..7] output toggle data of PE7 */

#define GPIO_TGL_PIN_PF0     (GPIO_CTL->IOPnTGL_b[PF].P0TGL)            /*!< [0..0] output toggle data of PF0 */
#define GPIO_TGL_PIN_PF1     (GPIO_CTL->IOPnTGL_b[PF].P1TGL)            /*!< [1..1] output toggle data of PF1 */
#define GPIO_TGL_PIN_PF2     (GPIO_CTL->IOPnTGL_b[PF].P2TGL)            /*!< [2..2] output toggle data of PF2 */
#define GPIO_TGL_PIN_PF3     (GPIO_CTL->IOPnTGL_b[PF].P3TGL)            /*!< [3..3] output toggle data of PF3 */
#define GPIO_TGL_PIN_PF4     (GPIO_CTL->IOPnTGL_b[PF].P4TGL)            /*!< [4..4] output toggle data of PF4 */
#define GPIO_TGL_PIN_PF5     (GPIO_CTL->IOPnTGL_b[PF].P5TGL)            /*!< [5..5] output toggle data of PF5 */
#define GPIO_TGL_PIN_PF6     (GPIO_CTL->IOPnTGL_b[PF].P6TGL)            /*!< [6..6] output toggle data of PF6 */
#define GPIO_TGL_PIN_PF7     (GPIO_CTL->IOPnTGL_b[PF].P7TGL)            /*!< [7..7] output toggle data of PF7 */

/*---------------------------------------------------------------------------------------------------------*/
/*  Input enable/disable of the specified pin                                                              */
/*---------------------------------------------------------------------------------------------------------*/
#define GPIO_IE_PIN_P00     (GPIO_CTL->IOPnIE_b[P0].P0IE)            /*!< [0..0] Input enable data of P00 */
#define GPIO_IE_PIN_P01     (GPIO_CTL->IOPnIE_b[P0].P1IE)            /*!< [1..1] Input enable data of P01 */
#define GPIO_IE_PIN_P02     (GPIO_CTL->IOPnIE_b[P0].P2IE)            /*!< [2..2] Input enable data of P02 */
#define GPIO_IE_PIN_P03     (GPIO_CTL->IOPnIE_b[P0].P3IE)            /*!< [3..3] Input enable data of P03 */
#define GPIO_IE_PIN_P04     (GPIO_CTL->IOPnIE_b[P0].P4IE)            /*!< [4..4] Input enable data of P04 */
#define GPIO_IE_PIN_P05     (GPIO_CTL->IOPnIE_b[P0].P5IE)            /*!< [5..5] Input enable data of P05 */
#define GPIO_IE_PIN_P06     (GPIO_CTL->IOPnIE_b[P0].P6IE)            /*!< [6..6] Input enable data of P06 */
#define GPIO_IE_PIN_P07     (GPIO_CTL->IOPnIE_b[P0].P7IE)            /*!< [7..7] Input enable data of P07 */

#define GPIO_IE_PIN_P10     (GPIO_CTL->IOPnIE_b[P1].P0IE)            /*!< [0..0] Input enable data of P10 */
#define GPIO_IE_PIN_P11     (GPIO_CTL->IOPnIE_b[P1].P1IE)            /*!< [1..1] Input enable data of P11 */
#define GPIO_IE_PIN_P12     (GPIO_CTL->IOPnIE_b[P1].P2IE)            /*!< [2..2] Input enable data of P12 */
#define GPIO_IE_PIN_P13     (GPIO_CTL->IOPnIE_b[P1].P3IE)            /*!< [3..3] Input enable data of P13 */
#define GPIO_IE_PIN_P14     (GPIO_CTL->IOPnIE_b[P1].P4IE)            /*!< [4..4] Input enable data of P14 */
#define GPIO_IE_PIN_P15     (GPIO_CTL->IOPnIE_b[P1].P5IE)            /*!< [5..5] Input enable data of P15 */
#define GPIO_IE_PIN_P16     (GPIO_CTL->IOPnIE_b[P1].P6IE)            /*!< [6..6] Input enable data of P16 */
#define GPIO_IE_PIN_P17     (GPIO_CTL->IOPnIE_b[P1].P7IE)            /*!< [7..7] Input enable data of P17 */

#define GPIO_IE_PIN_P20     (GPIO_CTL->IOPnIE_b[P2].P0IE)            /*!< [0..0] Input enable data of P20 */
#define GPIO_IE_PIN_P21     (GPIO_CTL->IOPnIE_b[P2].P1IE)            /*!< [1..1] Input enable data of P21 */
#define GPIO_IE_PIN_P22     (GPIO_CTL->IOPnIE_b[P2].P2IE)            /*!< [2..2] Input enable data of P22 */
#define GPIO_IE_PIN_P24     (GPIO_CTL->IOPnIE_b[P2].P4IE)            /*!< [4..4] Input enable data of P24 */
#define GPIO_IE_PIN_P25     (GPIO_CTL->IOPnIE_b[P2].P5IE)            /*!< [5..5] Input enable data of P25 */
#define GPIO_IE_PIN_P26     (GPIO_CTL->IOPnIE_b[P2].P6IE)            /*!< [6..6] Input enable data of P26 */
#define GPIO_IE_PIN_P27     (GPIO_CTL->IOPnIE_b[P2].P7IE)            /*!< [7..7] Input enable data of P27 */

#define GPIO_IE_PIN_P30     (GPIO_CTL->IOPnIE_b[P3].P0IE)            /*!< [0..0] Input enable data of P30 */
#define GPIO_IE_PIN_P31     (GPIO_CTL->IOPnIE_b[P3].P1IE)            /*!< [1..1] Input enable data of P31 */
#define GPIO_IE_PIN_P32     (GPIO_CTL->IOPnIE_b[P3].P2IE)            /*!< [2..2] Input enable data of P32 */
#define GPIO_IE_PIN_P34     (GPIO_CTL->IOPnIE_b[P3].P4IE)            /*!< [4..4] Input enable data of P34 */
#define GPIO_IE_PIN_P35     (GPIO_CTL->IOPnIE_b[P3].P5IE)            /*!< [5..5] Input enable data of P35 */
#define GPIO_IE_PIN_P36     (GPIO_CTL->IOPnIE_b[P3].P6IE)            /*!< [6..6] Input enable data of P36 */

#define GPIO_IE_PIN_P40     (GPIO_CTL->IOPnIE_b[P4].P0IE)            /*!< [0..0] Input enable data of P40 */
#define GPIO_IE_PIN_P41     (GPIO_CTL->IOPnIE_b[P4].P1IE)            /*!< [1..1] Input enable data of P41 */
#define GPIO_IE_PIN_P42     (GPIO_CTL->IOPnIE_b[P4].P2IE)            /*!< [2..2] Input enable data of P42 */
#define GPIO_IE_PIN_P44     (GPIO_CTL->IOPnIE_b[P4].P4IE)            /*!< [4..4] Input enable data of P44 */
#define GPIO_IE_PIN_P45     (GPIO_CTL->IOPnIE_b[P4].P5IE)            /*!< [5..5] Input enable data of P45 */
#define GPIO_IE_PIN_P46     (GPIO_CTL->IOPnIE_b[P4].P6IE)            /*!< [6..6] Input enable data of P46 */
#define GPIO_IE_PIN_P47     (GPIO_CTL->IOPnIE_b[P4].P7IE)            /*!< [7..7] Input enable data of P47 */

#define GPIO_IE_PIN_P50     (GPIO_CTL->IOPnIE_b[P5].P0IE)            /*!< [0..0] Input enable data of P50 */
#define GPIO_IE_PIN_P51     (GPIO_CTL->IOPnIE_b[P5].P1IE)            /*!< [1..1] Input enable data of P51 */
#define GPIO_IE_PIN_P52     (GPIO_CTL->IOPnIE_b[P5].P2IE)            /*!< [2..2] Input enable data of P52 */
#define GPIO_IE_PIN_P53     (GPIO_CTL->IOPnIE_b[P5].P3IE)            /*!< [3..3] Input enable data of P53 */
#define GPIO_IE_PIN_P54     (GPIO_CTL->IOPnIE_b[P5].P4IE)            /*!< [4..4] Input enable data of P54 */
#define GPIO_IE_PIN_P55     (GPIO_CTL->IOPnIE_b[P5].P5IE)            /*!< [5..5] Input enable data of P55 */
#define GPIO_IE_PIN_P56     (GPIO_CTL->IOPnIE_b[P5].P6IE)            /*!< [6..6] Input enable data of P56 */
#define GPIO_IE_PIN_P57     (GPIO_CTL->IOPnIE_b[P5].P7IE)            /*!< [7..7] Input enable data of P57 */

#define GPIO_IE_PIN_P60     (GPIO_CTL->IOPnIE_b[P6].P0IE)            /*!< [0..0] Input enable data of P60 */
#define GPIO_IE_PIN_P61     (GPIO_CTL->IOPnIE_b[P6].P1IE)            /*!< [1..1] Input enable data of P61 */
#define GPIO_IE_PIN_P62     (GPIO_CTL->IOPnIE_b[P6].P2IE)            /*!< [2..2] Input enable data of P62 */
#define GPIO_IE_PIN_P63     (GPIO_CTL->IOPnIE_b[P6].P3IE)            /*!< [3..3] Input enable data of P63 */
#define GPIO_IE_PIN_P64     (GPIO_CTL->IOPnIE_b[P6].P4IE)            /*!< [4..4] Input enable data of P64 */
#define GPIO_IE_PIN_P65     (GPIO_CTL->IOPnIE_b[P6].P5IE)            /*!< [5..5] Input enable data of P65 */
#define GPIO_IE_PIN_P66     (GPIO_CTL->IOPnIE_b[P6].P6IE)            /*!< [6..6] Input enable data of P66 */
#define GPIO_IE_PIN_P67     (GPIO_CTL->IOPnIE_b[P6].P7IE)            /*!< [7..7] Input enable data of P67 */

#define GPIO_IE_PIN_P70     (GPIO_CTL->IOPnIE_b[P7].P0IE)            /*!< [0..0] Input enable data of P70 */
#define GPIO_IE_PIN_P71     (GPIO_CTL->IOPnIE_b[P7].P1IE)            /*!< [1..1] Input enable data of P71 */
#define GPIO_IE_PIN_P72     (GPIO_CTL->IOPnIE_b[P7].P2IE)            /*!< [2..2] Input enable data of P72 */
#define GPIO_IE_PIN_P73     (GPIO_CTL->IOPnIE_b[P7].P3IE)            /*!< [3..3] Input enable data of P73 */
#define GPIO_IE_PIN_P74     (GPIO_CTL->IOPnIE_b[P7].P4IE)            /*!< [4..4] Input enable data of P74 */
#define GPIO_IE_PIN_P75     (GPIO_CTL->IOPnIE_b[P7].P5IE)            /*!< [5..5] Input enable data of P75 */
#define GPIO_IE_PIN_P76     (GPIO_CTL->IOPnIE_b[P7].P6IE)            /*!< [6..6] Input enable data of P76 */
#define GPIO_IE_PIN_P77     (GPIO_CTL->IOPnIE_b[P7].P7IE)            /*!< [7..7] Input enable data of P77 */

#define GPIO_IE_PIN_P80     (GPIO_CTL->IOPnIE_b[P8].P0IE)            /*!< [0..0] Input enable data of P80 */
#define GPIO_IE_PIN_P81     (GPIO_CTL->IOPnIE_b[P8].P1IE)            /*!< [1..1] Input enable data of P81 */
#define GPIO_IE_PIN_P82     (GPIO_CTL->IOPnIE_b[P8].P2IE)            /*!< [2..2] Input enable data of P82 */
#define GPIO_IE_PIN_P83     (GPIO_CTL->IOPnIE_b[P8].P3IE)            /*!< [3..3] Input enable data of P83 */
#define GPIO_IE_PIN_P84     (GPIO_CTL->IOPnIE_b[P8].P4IE)            /*!< [4..4] Input enable data of P84 */
#define GPIO_IE_PIN_P85     (GPIO_CTL->IOPnIE_b[P8].P5IE)            /*!< [5..5] Input enable data of P85 */
#define GPIO_IE_PIN_P86     (GPIO_CTL->IOPnIE_b[P8].P6IE)            /*!< [6..6] Input enable data of P86 */
#define GPIO_IE_PIN_P87     (GPIO_CTL->IOPnIE_b[P8].P7IE)            /*!< [7..7] Input enable data of P87 */

#define GPIO_IE_PIN_P90     (GPIO_CTL->IOPnIE_b[P9].P0IE)            /*!< [0..0] Input enable data of P90 */
#define GPIO_IE_PIN_P91     (GPIO_CTL->IOPnIE_b[P9].P1IE)            /*!< [1..1] Input enable data of P91 */
#define GPIO_IE_PIN_P92     (GPIO_CTL->IOPnIE_b[P9].P2IE)            /*!< [2..2] Input enable data of P92 */
#define GPIO_IE_PIN_P93     (GPIO_CTL->IOPnIE_b[P9].P3IE)            /*!< [3..3] Input enable data of P93 */
#define GPIO_IE_PIN_P94     (GPIO_CTL->IOPnIE_b[P9].P4IE)            /*!< [4..4] Input enable data of P94 */
#define GPIO_IE_PIN_P95     (GPIO_CTL->IOPnIE_b[P9].P5IE)            /*!< [5..5] Input enable data of P95 */
#define GPIO_IE_PIN_P96     (GPIO_CTL->IOPnIE_b[P9].P6IE)            /*!< [6..6] Input enable data of P96 */
#define GPIO_IE_PIN_P97     (GPIO_CTL->IOPnIE_b[P9].P7IE)            /*!< [7..7] Input enable data of P97 */

#define GPIO_IE_PIN_PA0     (GPIO_CTL->IOPnIE_b[PA].P0IE)            /*!< [0..0] Input enable data of PA0 */
#define GPIO_IE_PIN_PA1     (GPIO_CTL->IOPnIE_b[PA].P1IE)            /*!< [1..1] Input enable data of PA1 */
#define GPIO_IE_PIN_PA2     (GPIO_CTL->IOPnIE_b[PA].P2IE)            /*!< [2..2] Input enable data of PA2 */
#define GPIO_IE_PIN_PA3     (GPIO_CTL->IOPnIE_b[PA].P3IE)            /*!< [3..3] Input enable data of PA3 */
#define GPIO_IE_PIN_PA4     (GPIO_CTL->IOPnIE_b[PA].P4IE)            /*!< [4..4] Input enable data of PA4 */
#define GPIO_IE_PIN_PA5     (GPIO_CTL->IOPnIE_b[PA].P5IE)            /*!< [5..5] Input enable data of PA5 */
#define GPIO_IE_PIN_PA6     (GPIO_CTL->IOPnIE_b[PA].P6IE)            /*!< [6..6] Input enable data of PA6 */
#define GPIO_IE_PIN_PA7     (GPIO_CTL->IOPnIE_b[PA].P7IE)            /*!< [7..7] Input enable data of PA7 */

#define GPIO_IE_PIN_PB0     (GPIO_CTL->IOPnIE_b[PB].P0IE)            /*!< [0..0] Input enable data of PB0 */
#define GPIO_IE_PIN_PB1     (GPIO_CTL->IOPnIE_b[PB].P1IE)            /*!< [1..1] Input enable data of PB1 */
#define GPIO_IE_PIN_PB2     (GPIO_CTL->IOPnIE_b[PB].P2IE)            /*!< [2..2] Input enable data of PB2 */
#define GPIO_IE_PIN_PB3     (GPIO_CTL->IOPnIE_b[PB].P3IE)            /*!< [3..3] Input enable data of PB3 */
#define GPIO_IE_PIN_PB4     (GPIO_CTL->IOPnIE_b[PB].P4IE)            /*!< [4..4] Input enable data of PB4 */
#define GPIO_IE_PIN_PB6     (GPIO_CTL->IOPnIE_b[PB].P6IE)            /*!< [6..6] Input enable data of PB6 */
#define GPIO_IE_PIN_PB7     (GPIO_CTL->IOPnIE_b[PB].P7IE)            /*!< [7..7] Input enable data of PB7 */

#define GPIO_IE_PIN_PC0     (GPIO_CTL->IOPnIE_b[PC].P0IE)            /*!< [0..0] Input enable data of PC0 */
#define GPIO_IE_PIN_PC1     (GPIO_CTL->IOPnIE_b[PC].P1IE)            /*!< [1..1] Input enable data of PC1 */
#define GPIO_IE_PIN_PC2     (GPIO_CTL->IOPnIE_b[PC].P2IE)            /*!< [2..2] Input enable data of PC2 */
#define GPIO_IE_PIN_PC3     (GPIO_CTL->IOPnIE_b[PC].P3IE)            /*!< [3..3] Input enable data of PC3 */
#define GPIO_IE_PIN_PC4     (GPIO_CTL->IOPnIE_b[PC].P4IE)            /*!< [4..4] Input enable data of PC4 */
#define GPIO_IE_PIN_PC5     (GPIO_CTL->IOPnIE_b[PC].P5IE)            /*!< [5..5] Input enable data of PC5 */
#define GPIO_IE_PIN_PC6     (GPIO_CTL->IOPnIE_b[PC].P6IE)            /*!< [6..6] Input enable data of PC6 */
#define GPIO_IE_PIN_PC7     (GPIO_CTL->IOPnIE_b[PC].P7IE)            /*!< [7..7] Input enable data of PC7 */

#define GPIO_IE_PIN_PD0     (GPIO_CTL->IOPnIE_b[PD].P0IE)            /*!< [0..0] Input enable data of PD0 */
#define GPIO_IE_PIN_PD1     (GPIO_CTL->IOPnIE_b[PD].P1IE)            /*!< [1..1] Input enable data of PD1 */
#define GPIO_IE_PIN_PD2     (GPIO_CTL->IOPnIE_b[PD].P2IE)            /*!< [2..2] Input enable data of PD2 */
#define GPIO_IE_PIN_PD3     (GPIO_CTL->IOPnIE_b[PD].P3IE)            /*!< [3..3] Input enable data of PD3 */
#define GPIO_IE_PIN_PD4     (GPIO_CTL->IOPnIE_b[PD].P4IE)            /*!< [4..4] Input enable data of PD4 */
#define GPIO_IE_PIN_PD5     (GPIO_CTL->IOPnIE_b[PD].P5IE)            /*!< [5..5] Input enable data of PD5 */
#define GPIO_IE_PIN_PD6     (GPIO_CTL->IOPnIE_b[PD].P6IE)            /*!< [6..6] Input enable data of PD6 */
#define GPIO_IE_PIN_PD7     (GPIO_CTL->IOPnIE_b[PD].P7IE)            /*!< [7..7] Input enable data of PD7 */

#define GPIO_IE_PIN_PE0     (GPIO_CTL->IOPnIE_b[PE].P0IE)            /*!< [0..0] Input enable data of PE0 */
#define GPIO_IE_PIN_PE1     (GPIO_CTL->IOPnIE_b[PE].P1IE)            /*!< [1..1] Input enable data of PE1 */
#define GPIO_IE_PIN_PE2     (GPIO_CTL->IOPnIE_b[PE].P2IE)            /*!< [2..2] Input enable data of PE2 */
#define GPIO_IE_PIN_PE3     (GPIO_CTL->IOPnIE_b[PE].P3IE)            /*!< [3..3] Input enable data of PE3 */
#define GPIO_IE_PIN_PE4     (GPIO_CTL->IOPnIE_b[PE].P4IE)            /*!< [4..4] Input enable data of PE4 */
#define GPIO_IE_PIN_PE5     (GPIO_CTL->IOPnIE_b[PE].P5IE)            /*!< [5..5] Input enable data of PE5 */
#define GPIO_IE_PIN_PE6     (GPIO_CTL->IOPnIE_b[PE].P6IE)            /*!< [6..6] Input enable data of PE6 */
#define GPIO_IE_PIN_PE7     (GPIO_CTL->IOPnIE_b[PE].P7IE)            /*!< [7..7] Input enable data of PE7 */

#define GPIO_IE_PIN_PF0     (GPIO_CTL->IOPnIE_b[PF].P0IE)            /*!< [0..0] Input enable data of PF0 */
#define GPIO_IE_PIN_PF1     (GPIO_CTL->IOPnIE_b[PF].P1IE)            /*!< [1..1] Input enable data of PF1 */
#define GPIO_IE_PIN_PF2     (GPIO_CTL->IOPnIE_b[PF].P2IE)            /*!< [2..2] Input enable data of PF2 */
#define GPIO_IE_PIN_PF3     (GPIO_CTL->IOPnIE_b[PF].P3IE)            /*!< [3..3] Input enable data of PF3 */
#define GPIO_IE_PIN_PF4     (GPIO_CTL->IOPnIE_b[PF].P4IE)            /*!< [4..4] Input enable data of PF4 */
#define GPIO_IE_PIN_PF5     (GPIO_CTL->IOPnIE_b[PF].P5IE)            /*!< [5..5] Input enable data of PF5 */
#define GPIO_IE_PIN_PF6     (GPIO_CTL->IOPnIE_b[PF].P6IE)            /*!< [6..6] Input enable data of PF6 */
#define GPIO_IE_PIN_PF7     (GPIO_CTL->IOPnIE_b[PF].P7IE)            /*!< [7..7] Input enable data of PF7 */

/*---------------------------------------------------------------------------------------------------------*/
/*  Output enable/disable of the specified pin                                                             */
/*---------------------------------------------------------------------------------------------------------*/
#define GPIO_OE_PIN_P00     (GPIO_CTL->IOPnOE_b[P0].P0OE)            /*!< [0..0] output enable data of P00 */
#define GPIO_OE_PIN_P01     (GPIO_CTL->IOPnOE_b[P0].P1OE)            /*!< [1..1] output enable data of P01 */
#define GPIO_OE_PIN_P02     (GPIO_CTL->IOPnOE_b[P0].P2OE)            /*!< [2..2] output enable data of P02 */
#define GPIO_OE_PIN_P03     (GPIO_CTL->IOPnOE_b[P0].P3OE)            /*!< [3..3] output enable data of P03 */
#define GPIO_OE_PIN_P04     (GPIO_CTL->IOPnOE_b[P0].P4OE)            /*!< [4..4] output enable data of P04 */
#define GPIO_OE_PIN_P05     (GPIO_CTL->IOPnOE_b[P0].P5OE)            /*!< [5..5] output enable data of P05 */
#define GPIO_OE_PIN_P06     (GPIO_CTL->IOPnOE_b[P0].P6OE)            /*!< [6..6] output enable data of P06 */
#define GPIO_OE_PIN_P07     (GPIO_CTL->IOPnOE_b[P0].P7OE)            /*!< [7..7] output enable data of P07 */

#define GPIO_OE_PIN_P10     (GPIO_CTL->IOPnOE_b[P1].P0OE)            /*!< [0..0] output enable data of P10 */
#define GPIO_OE_PIN_P11     (GPIO_CTL->IOPnOE_b[P1].P1OE)            /*!< [1..1] output enable data of P11 */
#define GPIO_OE_PIN_P12     (GPIO_CTL->IOPnOE_b[P1].P2OE)            /*!< [2..2] output enable data of P12 */
#define GPIO_OE_PIN_P13     (GPIO_CTL->IOPnOE_b[P1].P3OE)            /*!< [3..3] output enable data of P13 */
#define GPIO_OE_PIN_P14     (GPIO_CTL->IOPnOE_b[P1].P4OE)            /*!< [4..4] output enable data of P14 */
#define GPIO_OE_PIN_P15     (GPIO_CTL->IOPnOE_b[P1].P5OE)            /*!< [5..5] output enable data of P15 */
#define GPIO_OE_PIN_P16     (GPIO_CTL->IOPnOE_b[P1].P6OE)            /*!< [6..6] output enable data of P16 */
#define GPIO_OE_PIN_P17     (GPIO_CTL->IOPnOE_b[P1].P7OE)            /*!< [7..7] output enable data of P17 */

#define GPIO_OE_PIN_P20     (GPIO_CTL->IOPnOE_b[P2].P0OE)            /*!< [0..0] output enable data of P20 */
#define GPIO_OE_PIN_P21     (GPIO_CTL->IOPnOE_b[P2].P1OE)            /*!< [1..1] output enable data of P21 */
#define GPIO_OE_PIN_P22     (GPIO_CTL->IOPnOE_b[P2].P2OE)            /*!< [2..2] output enable data of P22 */
#define GPIO_OE_PIN_P24     (GPIO_CTL->IOPnOE_b[P2].P4OE)            /*!< [4..4] output enable data of P24 */
#define GPIO_OE_PIN_P25     (GPIO_CTL->IOPnOE_b[P2].P5OE)            /*!< [5..5] output enable data of P25 */
#define GPIO_OE_PIN_P26     (GPIO_CTL->IOPnOE_b[P2].P6OE)            /*!< [6..6] output enable data of P26 */
#define GPIO_OE_PIN_P27     (GPIO_CTL->IOPnOE_b[P2].P7OE)            /*!< [7..7] output enable data of P27 */

#define GPIO_OE_PIN_P30     (GPIO_CTL->IOPnOE_b[P3].P0OE)            /*!< [0..0] output enable data of P30 */
#define GPIO_OE_PIN_P31     (GPIO_CTL->IOPnOE_b[P3].P1OE)            /*!< [1..1] output enable data of P31 */
#define GPIO_OE_PIN_P32     (GPIO_CTL->IOPnOE_b[P3].P2OE)            /*!< [2..2] output enable data of P32 */
#define GPIO_OE_PIN_P34     (GPIO_CTL->IOPnOE_b[P3].P4OE)            /*!< [4..4] output enable data of P34 */
#define GPIO_OE_PIN_P35     (GPIO_CTL->IOPnOE_b[P3].P5OE)            /*!< [5..5] output enable data of P35 */
#define GPIO_OE_PIN_P36     (GPIO_CTL->IOPnOE_b[P3].P6OE)            /*!< [6..6] output enable data of P36 */

#define GPIO_OE_PIN_P40     (GPIO_CTL->IOPnOE_b[P4].P0OE)            /*!< [0..0] output enable data of P40 */
#define GPIO_OE_PIN_P41     (GPIO_CTL->IOPnOE_b[P4].P1OE)            /*!< [1..1] output enable data of P41 */
#define GPIO_OE_PIN_P42     (GPIO_CTL->IOPnOE_b[P4].P2OE)            /*!< [2..2] output enable data of P42 */
#define GPIO_OE_PIN_P44     (GPIO_CTL->IOPnOE_b[P4].P4OE)            /*!< [4..4] output enable data of P44 */
#define GPIO_OE_PIN_P45     (GPIO_CTL->IOPnOE_b[P4].P5OE)            /*!< [5..5] output enable data of P45 */
#define GPIO_OE_PIN_P46     (GPIO_CTL->IOPnOE_b[P4].P6OE)            /*!< [6..6] output enable data of P46 */
#define GPIO_OE_PIN_P47     (GPIO_CTL->IOPnOE_b[P4].P7OE)            /*!< [7..7] output enable data of P47 */

#define GPIO_OE_PIN_P50     (GPIO_CTL->IOPnOE_b[P5].P0OE)            /*!< [0..0] output enable data of P50 */
#define GPIO_OE_PIN_P51     (GPIO_CTL->IOPnOE_b[P5].P1OE)            /*!< [1..1] output enable data of P51 */
#define GPIO_OE_PIN_P52     (GPIO_CTL->IOPnOE_b[P5].P2OE)            /*!< [2..2] output enable data of P52 */
#define GPIO_OE_PIN_P53     (GPIO_CTL->IOPnOE_b[P5].P3OE)            /*!< [3..3] output enable data of P53 */
#define GPIO_OE_PIN_P54     (GPIO_CTL->IOPnOE_b[P5].P4OE)            /*!< [4..4] output enable data of P54 */
#define GPIO_OE_PIN_P55     (GPIO_CTL->IOPnOE_b[P5].P5OE)            /*!< [5..5] output enable data of P55 */
#define GPIO_OE_PIN_P56     (GPIO_CTL->IOPnOE_b[P5].P6OE)            /*!< [6..6] output enable data of P56 */
#define GPIO_OE_PIN_P57     (GPIO_CTL->IOPnOE_b[P5].P7OE)            /*!< [7..7] output enable data of P57 */

#define GPIO_OE_PIN_P60     (GPIO_CTL->IOPnOE_b[P6].P0OE)            /*!< [0..0] output enable data of P60 */
#define GPIO_OE_PIN_P61     (GPIO_CTL->IOPnOE_b[P6].P1OE)            /*!< [1..1] output enable data of P61 */
#define GPIO_OE_PIN_P62     (GPIO_CTL->IOPnOE_b[P6].P2OE)            /*!< [2..2] output enable data of P62 */
#define GPIO_OE_PIN_P63     (GPIO_CTL->IOPnOE_b[P6].P3OE)            /*!< [3..3] output enable data of P63 */
#define GPIO_OE_PIN_P64     (GPIO_CTL->IOPnOE_b[P6].P4OE)            /*!< [4..4] output enable data of P64 */
#define GPIO_OE_PIN_P65     (GPIO_CTL->IOPnOE_b[P6].P5OE)            /*!< [5..5] output enable data of P65 */
#define GPIO_OE_PIN_P66     (GPIO_CTL->IOPnOE_b[P6].P6OE)            /*!< [6..6] output enable data of P66 */
#define GPIO_OE_PIN_P67     (GPIO_CTL->IOPnOE_b[P6].P7OE)            /*!< [7..7] output enable data of P67 */

#define GPIO_OE_PIN_P70     (GPIO_CTL->IOPnOE_b[P7].P0OE)            /*!< [0..0] output enable data of P70 */
#define GPIO_OE_PIN_P71     (GPIO_CTL->IOPnOE_b[P7].P1OE)            /*!< [1..1] output enable data of P71 */
#define GPIO_OE_PIN_P72     (GPIO_CTL->IOPnOE_b[P7].P2OE)            /*!< [2..2] output enable data of P72 */
#define GPIO_OE_PIN_P73     (GPIO_CTL->IOPnOE_b[P7].P3OE)            /*!< [3..3] output enable data of P73 */
#define GPIO_OE_PIN_P74     (GPIO_CTL->IOPnOE_b[P7].P4OE)            /*!< [4..4] output enable data of P74 */
#define GPIO_OE_PIN_P75     (GPIO_CTL->IOPnOE_b[P7].P5OE)            /*!< [5..5] output enable data of P75 */
#define GPIO_OE_PIN_P76     (GPIO_CTL->IOPnOE_b[P7].P6OE)            /*!< [6..6] output enable data of P76 */
#define GPIO_OE_PIN_P77     (GPIO_CTL->IOPnOE_b[P7].P7OE)            /*!< [7..7] output enable data of P77 */

#define GPIO_OE_PIN_P80     (GPIO_CTL->IOPnOE_b[P8].P0OE)            /*!< [0..0] output enable data of P80 */
#define GPIO_OE_PIN_P81     (GPIO_CTL->IOPnOE_b[P8].P1OE)            /*!< [1..1] output enable data of P81 */
#define GPIO_OE_PIN_P82     (GPIO_CTL->IOPnOE_b[P8].P2OE)            /*!< [2..2] output enable data of P82 */
#define GPIO_OE_PIN_P83     (GPIO_CTL->IOPnOE_b[P8].P3OE)            /*!< [3..3] output enable data of P83 */
#define GPIO_OE_PIN_P84     (GPIO_CTL->IOPnOE_b[P8].P4OE)            /*!< [4..4] output enable data of P84 */
#define GPIO_OE_PIN_P85     (GPIO_CTL->IOPnOE_b[P8].P5OE)            /*!< [5..5] output enable data of P85 */
#define GPIO_OE_PIN_P86     (GPIO_CTL->IOPnOE_b[P8].P6OE)            /*!< [6..6] output enable data of P86 */
#define GPIO_OE_PIN_P87     (GPIO_CTL->IOPnOE_b[P8].P7OE)            /*!< [7..7] output enable data of P87 */

#define GPIO_OE_PIN_P90     (GPIO_CTL->IOPnOE_b[P9].P0OE)            /*!< [0..0] output enable data of P90 */
#define GPIO_OE_PIN_P91     (GPIO_CTL->IOPnOE_b[P9].P1OE)            /*!< [1..1] output enable data of P91 */
#define GPIO_OE_PIN_P92     (GPIO_CTL->IOPnOE_b[P9].P2OE)            /*!< [2..2] output enable data of P92 */
#define GPIO_OE_PIN_P93     (GPIO_CTL->IOPnOE_b[P9].P3OE)            /*!< [3..3] output enable data of P93 */
#define GPIO_OE_PIN_P94     (GPIO_CTL->IOPnOE_b[P9].P4OE)            /*!< [4..4] output enable data of P94 */
#define GPIO_OE_PIN_P95     (GPIO_CTL->IOPnOE_b[P9].P5OE)            /*!< [5..5] output enable data of P95 */
#define GPIO_OE_PIN_P96     (GPIO_CTL->IOPnOE_b[P9].P6OE)            /*!< [6..6] output enable data of P96 */
#define GPIO_OE_PIN_P97     (GPIO_CTL->IOPnOE_b[P9].P7OE)            /*!< [7..7] output enable data of P97 */

#define GPIO_OE_PIN_PA0     (GPIO_CTL->IOPnOE_b[PA].P0OE)            /*!< [0..0] output enable data of PA0 */
#define GPIO_OE_PIN_PA1     (GPIO_CTL->IOPnOE_b[PA].P1OE)            /*!< [1..1] output enable data of PA1 */
#define GPIO_OE_PIN_PA2     (GPIO_CTL->IOPnOE_b[PA].P2OE)            /*!< [2..2] output enable data of PA2 */
#define GPIO_OE_PIN_PA3     (GPIO_CTL->IOPnOE_b[PA].P3OE)            /*!< [3..3] output enable data of PA3 */
#define GPIO_OE_PIN_PA4     (GPIO_CTL->IOPnOE_b[PA].P4OE)            /*!< [4..4] output enable data of PA4 */
#define GPIO_OE_PIN_PA5     (GPIO_CTL->IOPnOE_b[PA].P5OE)            /*!< [5..5] output enable data of PA5 */
#define GPIO_OE_PIN_PA6     (GPIO_CTL->IOPnOE_b[PA].P6OE)            /*!< [6..6] output enable data of PA6 */
#define GPIO_OE_PIN_PA7     (GPIO_CTL->IOPnOE_b[PA].P7OE)            /*!< [7..7] output enable data of PA7 */

#define GPIO_OE_PIN_PB0     (GPIO_CTL->IOPnOE_b[PB].P0OE)            /*!< [0..0] output enable data of PB0 */
#define GPIO_OE_PIN_PB1     (GPIO_CTL->IOPnOE_b[PB].P1OE)            /*!< [1..1] output enable data of PB1 */
#define GPIO_OE_PIN_PB2     (GPIO_CTL->IOPnOE_b[PB].P2OE)            /*!< [2..2] output enable data of PB2 */
#define GPIO_OE_PIN_PB3     (GPIO_CTL->IOPnOE_b[PB].P3OE)            /*!< [3..3] output enable data of PB3 */
#define GPIO_OE_PIN_PB4     (GPIO_CTL->IOPnOE_b[PB].P4OE)            /*!< [4..4] output enable data of PB4 */
#define GPIO_OE_PIN_PB6     (GPIO_CTL->IOPnOE_b[PB].P6OE)            /*!< [6..6] output enable data of PB6 */
#define GPIO_OE_PIN_PB7     (GPIO_CTL->IOPnOE_b[PB].P7OE)            /*!< [7..7] output enable data of PB7 */

#define GPIO_OE_PIN_PC4     (GPIO_CTL->IOPnOE_b[PC].P4OE)            /*!< [4..4] output enable data of PC4 */
#define GPIO_OE_PIN_PC5     (GPIO_CTL->IOPnOE_b[PC].P5OE)            /*!< [5..5] output enable data of PC5 */
#define GPIO_OE_PIN_PC6     (GPIO_CTL->IOPnOE_b[PC].P6OE)            /*!< [6..6] output enable data of PC6 */
#define GPIO_OE_PIN_PC7     (GPIO_CTL->IOPnOE_b[PC].P7OE)            /*!< [7..7] output enable data of PC7 */

#define GPIO_OE_PIN_PD2     (GPIO_CTL->IOPnOE_b[PD].P2OE)            /*!< [2..2] output enable data of PD2 */
#define GPIO_OE_PIN_PD3     (GPIO_CTL->IOPnOE_b[PD].P3OE)            /*!< [3..3] output enable data of PD3 */
#define GPIO_OE_PIN_PD4     (GPIO_CTL->IOPnOE_b[PD].P4OE)            /*!< [4..4] output enable data of PD4 */
#define GPIO_OE_PIN_PD5     (GPIO_CTL->IOPnOE_b[PD].P5OE)            /*!< [5..5] output enable data of PD5 */
#define GPIO_OE_PIN_PD6     (GPIO_CTL->IOPnOE_b[PD].P6OE)            /*!< [6..6] output enable data of PD6 */
#define GPIO_OE_PIN_PD7     (GPIO_CTL->IOPnOE_b[PD].P7OE)            /*!< [7..7] output enable data of PD7 */

#define GPIO_OE_PIN_PE2     (GPIO_CTL->IOPnOE_b[PE].P2OE)            /*!< [2..2] output enable data of PE2 */
#define GPIO_OE_PIN_PE3     (GPIO_CTL->IOPnOE_b[PE].P3OE)            /*!< [3..3] output enable data of PE3 */
#define GPIO_OE_PIN_PE4     (GPIO_CTL->IOPnOE_b[PE].P4OE)            /*!< [4..4] output enable data of PE4 */
#define GPIO_OE_PIN_PE5     (GPIO_CTL->IOPnOE_b[PE].P5OE)            /*!< [5..5] output enable data of PE5 */
#define GPIO_OE_PIN_PE6     (GPIO_CTL->IOPnOE_b[PE].P6OE)            /*!< [6..6] output enable data of PE6 */
#define GPIO_OE_PIN_PE7     (GPIO_CTL->IOPnOE_b[PE].P7OE)            /*!< [7..7] output enable data of PE7 */

#define GPIO_OE_PIN_PF0     (GPIO_CTL->IOPnOE_b[PF].P0OE)            /*!< [0..0] output enable data of PF0 */
#define GPIO_OE_PIN_PF1     (GPIO_CTL->IOPnOE_b[PF].P1OE)            /*!< [1..1] output enable data of PF1 */
#define GPIO_OE_PIN_PF2     (GPIO_CTL->IOPnOE_b[PF].P2OE)            /*!< [2..2] output enable data of PF2 */
#define GPIO_OE_PIN_PF3     (GPIO_CTL->IOPnOE_b[PF].P3OE)            /*!< [3..3] output enable data of PF3 */
#define GPIO_OE_PIN_PF4     (GPIO_CTL->IOPnOE_b[PF].P4OE)            /*!< [4..4] output enable data of PF4 */
#define GPIO_OE_PIN_PF5     (GPIO_CTL->IOPnOE_b[PF].P5OE)            /*!< [5..5] output enable data of PF5 */
#define GPIO_OE_PIN_PF6     (GPIO_CTL->IOPnOE_b[PF].P6OE)            /*!< [6..6] output enable data of PF6 */
#define GPIO_OE_PIN_PF7     (GPIO_CTL->IOPnOE_b[PF].P7OE)            /*!< [7..7] output enable data of PF7 */

/*---------------------------------------------------------------------------------------------------------*/
/*  To select the Nch open-drain output of the specified pin                                               */
/*---------------------------------------------------------------------------------------------------------*/
#define GPIO_ODC_PIN_P06     (GPIO_CTL->IOPnODC_b[P0].P6ODC)            /*!< [6..6] Nch open-drain selection of P06 */
#define GPIO_ODC_PIN_P07     (GPIO_CTL->IOPnODC_b[P0].P7ODC)            /*!< [7..7] Nch open-drain selection of P07 */

#define GPIO_ODC_PIN_P10     (GPIO_CTL->IOPnODC_b[P1].P0ODC)            /*!< [0..0] Nch open-drain selection of P10 */

#define GPIO_ODC_PIN_P25     (GPIO_CTL->IOPnODC_b[P2].P5ODC)            /*!< [5..5] Nch open-drain selection of P25 */
#define GPIO_ODC_PIN_P26     (GPIO_CTL->IOPnODC_b[P2].P6ODC)            /*!< [6..6] Nch open-drain selection of P26 */
#define GPIO_ODC_PIN_P27     (GPIO_CTL->IOPnODC_b[P2].P7ODC)            /*!< [7..7] Nch open-drain selection of P27 */

#define GPIO_ODC_PIN_P30     (GPIO_CTL->IOPnODC_b[P3].P0ODC)            /*!< [0..0] Nch open-drain selection of P30 */
#define GPIO_ODC_PIN_P31     (GPIO_CTL->IOPnODC_b[P3].P1ODC)            /*!< [1..1] Nch open-drain selection of P31 */
#define GPIO_ODC_PIN_P34     (GPIO_CTL->IOPnODC_b[P3].P4ODC)            /*!< [4..4] Nch open-drain selection of P34 */
#define GPIO_ODC_PIN_P35     (GPIO_CTL->IOPnODC_b[P3].P5ODC)            /*!< [5..5] Nch open-drain selection of P35 */

#define GPIO_ODC_PIN_P40     (GPIO_CTL->IOPnODC_b[P4].P0ODC)            /*!< [0..0] Nch open-drain selection of P40 */
#define GPIO_ODC_PIN_P41     (GPIO_CTL->IOPnODC_b[P4].P1ODC)            /*!< [1..1] Nch open-drain selection of P41 */
#define GPIO_ODC_PIN_P44     (GPIO_CTL->IOPnODC_b[P4].P4ODC)            /*!< [4..4] Nch open-drain selection of P44 */
#define GPIO_ODC_PIN_P45     (GPIO_CTL->IOPnODC_b[P4].P5ODC)            /*!< [5..5] Nch open-drain selection of P45 */
#define GPIO_ODC_PIN_P47     (GPIO_CTL->IOPnODC_b[P4].P7ODC)            /*!< [7..7] Nch open-drain selection of P47 */

#define GPIO_ODC_PIN_P50     (GPIO_CTL->IOPnODC_b[P5].P0ODC)            /*!< [0..0] Nch open-drain selection of P50 */
#define GPIO_ODC_PIN_P52     (GPIO_CTL->IOPnODC_b[P5].P2ODC)            /*!< [2..2] Nch open-drain selection of P52 */
#define GPIO_ODC_PIN_P53     (GPIO_CTL->IOPnODC_b[P5].P3ODC)            /*!< [3..3] Nch open-drain selection of P53 */
#define GPIO_ODC_PIN_P55     (GPIO_CTL->IOPnODC_b[P5].P5ODC)            /*!< [5..5] Nch open-drain selection of P55 */
#define GPIO_ODC_PIN_P56     (GPIO_CTL->IOPnODC_b[P5].P6ODC)            /*!< [6..6] Nch open-drain selection of P56 */
#define GPIO_ODC_PIN_P57     (GPIO_CTL->IOPnODC_b[P5].P7ODC)            /*!< [7..7] Nch open-drain selection of P57 */

#define GPIO_ODC_PIN_P61     (GPIO_CTL->IOPnODC_b[P6].P1ODC)            /*!< [1..1] Nch open-drain selection of P61 */
#define GPIO_ODC_PIN_P62     (GPIO_CTL->IOPnODC_b[P6].P2ODC)            /*!< [2..2] Nch open-drain selection of P62 */
#define GPIO_ODC_PIN_P63     (GPIO_CTL->IOPnODC_b[P6].P3ODC)            /*!< [3..3] Nch open-drain selection of P63 */

/*---------------------------------------------------------------------------------------------------------*/
/*  Specify the pull-up resistor connection of the specified for pins                                      */
/*---------------------------------------------------------------------------------------------------------*/
#define GPIO_PLU_PIN_P00     (GPIO_CTL->IOPnPLU_b[P0].P0PLU)            /*!< [0..0] Pull-up selection of P00 */
#define GPIO_PLU_PIN_P01     (GPIO_CTL->IOPnPLU_b[P0].P1PLU)            /*!< [1..1] Pull-up selection of P01 */
#define GPIO_PLU_PIN_P02     (GPIO_CTL->IOPnPLU_b[P0].P2PLU)            /*!< [2..2] Pull-up selection of P02 */
#define GPIO_PLU_PIN_P03     (GPIO_CTL->IOPnPLU_b[P0].P3PLU)            /*!< [3..3] Pull-up selection of P03 */
#define GPIO_PLU_PIN_P04     (GPIO_CTL->IOPnPLU_b[P0].P4PLU)            /*!< [4..4] Pull-up selection of P04 */
#define GPIO_PLU_PIN_P05     (GPIO_CTL->IOPnPLU_b[P0].P5PLU)            /*!< [5..5] Pull-up selection of P05 */
#define GPIO_PLU_PIN_P06     (GPIO_CTL->IOPnPLU_b[P0].P6PLU)            /*!< [6..6] Pull-up selection of P06 */
#define GPIO_PLU_PIN_P07     (GPIO_CTL->IOPnPLU_b[P0].P7PLU)            /*!< [7..7] Pull-up selection of P07 */

#define GPIO_PLU_PIN_P10     (GPIO_CTL->IOPnPLU_b[P1].P0PLU)            /*!< [0..0] Pull-up selection of P10 */
#define GPIO_PLU_PIN_P11     (GPIO_CTL->IOPnPLU_b[P1].P1PLU)            /*!< [1..1] Pull-up selection of P11 */
#define GPIO_PLU_PIN_P12     (GPIO_CTL->IOPnPLU_b[P1].P2PLU)            /*!< [2..2] Pull-up selection of P12 */
#define GPIO_PLU_PIN_P13     (GPIO_CTL->IOPnPLU_b[P1].P3PLU)            /*!< [3..3] Pull-up selection of P13 */
#define GPIO_PLU_PIN_P14     (GPIO_CTL->IOPnPLU_b[P1].P4PLU)            /*!< [4..4] Pull-up selection of P14 */
#define GPIO_PLU_PIN_P15     (GPIO_CTL->IOPnPLU_b[P1].P5PLU)            /*!< [5..5] Pull-up selection of P15 */
#define GPIO_PLU_PIN_P16     (GPIO_CTL->IOPnPLU_b[P1].P6PLU)            /*!< [6..6] Pull-up selection of P16 */
#define GPIO_PLU_PIN_P17     (GPIO_CTL->IOPnPLU_b[P1].P7PLU)            /*!< [7..7] Pull-up selection of P17 */

#define GPIO_PLU_PIN_P20     (GPIO_CTL->IOPnPLU_b[P2].P0PLU)            /*!< [0..0] Pull-up selection of P20 */
#define GPIO_PLU_PIN_P21     (GPIO_CTL->IOPnPLU_b[P2].P1PLU)            /*!< [1..1] Pull-up selection of P21 */
#define GPIO_PLU_PIN_P22     (GPIO_CTL->IOPnPLU_b[P2].P2PLU)            /*!< [2..2] Pull-up selection of P22 */
#define GPIO_PLU_PIN_P24     (GPIO_CTL->IOPnPLU_b[P2].P4PLU)            /*!< [4..4] Pull-up selection of P24 */
#define GPIO_PLU_PIN_P25     (GPIO_CTL->IOPnPLU_b[P2].P5PLU)            /*!< [5..5] Pull-up selection of P25 */
#define GPIO_PLU_PIN_P26     (GPIO_CTL->IOPnPLU_b[P2].P6PLU)            /*!< [6..6] Pull-up selection of P26 */
#define GPIO_PLU_PIN_P27     (GPIO_CTL->IOPnPLU_b[P2].P7PLU)            /*!< [7..7] Pull-up selection of P27 */

#define GPIO_PLU_PIN_P30     (GPIO_CTL->IOPnPLU_b[P3].P0PLU)            /*!< [0..0] Pull-up selection of P30 */
#define GPIO_PLU_PIN_P31     (GPIO_CTL->IOPnPLU_b[P3].P1PLU)            /*!< [1..1] Pull-up selection of P31 */
#define GPIO_PLU_PIN_P32     (GPIO_CTL->IOPnPLU_b[P3].P2PLU)            /*!< [2..2] Pull-up selection of P32 */
#define GPIO_PLU_PIN_P34     (GPIO_CTL->IOPnPLU_b[P3].P4PLU)            /*!< [4..4] Pull-up selection of P34 */
#define GPIO_PLU_PIN_P35     (GPIO_CTL->IOPnPLU_b[P3].P5PLU)            /*!< [5..5] Pull-up selection of P35 */
#define GPIO_PLU_PIN_P36     (GPIO_CTL->IOPnPLU_b[P3].P6PLU)            /*!< [6..6] Pull-up selection of P36 */

#define GPIO_PLU_PIN_P40     (GPIO_CTL->IOPnPLU_b[P4].P0PLU)            /*!< [0..0] Pull-up selection of P40 */
#define GPIO_PLU_PIN_P41     (GPIO_CTL->IOPnPLU_b[P4].P1PLU)            /*!< [1..1] Pull-up selection of P41 */
#define GPIO_PLU_PIN_P42     (GPIO_CTL->IOPnPLU_b[P4].P2PLU)            /*!< [2..2] Pull-up selection of P42 */
#define GPIO_PLU_PIN_P44     (GPIO_CTL->IOPnPLU_b[P4].P4PLU)            /*!< [4..4] Pull-up selection of P44 */
#define GPIO_PLU_PIN_P45     (GPIO_CTL->IOPnPLU_b[P4].P5PLU)            /*!< [5..5] Pull-up selection of P45 */
#define GPIO_PLU_PIN_P46     (GPIO_CTL->IOPnPLU_b[P4].P6PLU)            /*!< [6..6] Pull-up selection of P46 */
#define GPIO_PLU_PIN_P47     (GPIO_CTL->IOPnPLU_b[P4].P7PLU)            /*!< [7..7] Pull-up selection of P47 */

#define GPIO_PLU_PIN_P50     (GPIO_CTL->IOPnPLU_b[P5].P0PLU)            /*!< [0..0] Pull-up selection of P50 */
#define GPIO_PLU_PIN_P51     (GPIO_CTL->IOPnPLU_b[P5].P1PLU)            /*!< [1..1] Pull-up selection of P51 */
#define GPIO_PLU_PIN_P52     (GPIO_CTL->IOPnPLU_b[P5].P2PLU)            /*!< [2..2] Pull-up selection of P52 */
#define GPIO_PLU_PIN_P53     (GPIO_CTL->IOPnPLU_b[P5].P3PLU)            /*!< [3..3] Pull-up selection of P53 */
#define GPIO_PLU_PIN_P54     (GPIO_CTL->IOPnPLU_b[P5].P4PLU)            /*!< [4..4] Pull-up selection of P54 */
#define GPIO_PLU_PIN_P55     (GPIO_CTL->IOPnPLU_b[P5].P5PLU)            /*!< [5..5] Pull-up selection of P55 */
#define GPIO_PLU_PIN_P56     (GPIO_CTL->IOPnPLU_b[P5].P6PLU)            /*!< [6..6] Pull-up selection of P56 */
#define GPIO_PLU_PIN_P57     (GPIO_CTL->IOPnPLU_b[P5].P7PLU)            /*!< [7..7] Pull-up selection of P57 */

#define GPIO_PLU_PIN_P60     (GPIO_CTL->IOPnPLU_b[P6].P0PLU)            /*!< [0..0] Pull-up selection of P60 */
#define GPIO_PLU_PIN_P61     (GPIO_CTL->IOPnPLU_b[P6].P1PLU)            /*!< [1..1] Pull-up selection of P61 */
#define GPIO_PLU_PIN_P62     (GPIO_CTL->IOPnPLU_b[P6].P2PLU)            /*!< [2..2] Pull-up selection of P62 */
#define GPIO_PLU_PIN_P63     (GPIO_CTL->IOPnPLU_b[P6].P3PLU)            /*!< [3..3] Pull-up selection of P63 */
#define GPIO_PLU_PIN_P64     (GPIO_CTL->IOPnPLU_b[P6].P4PLU)            /*!< [4..4] Pull-up selection of P64 */
#define GPIO_PLU_PIN_P65     (GPIO_CTL->IOPnPLU_b[P6].P5PLU)            /*!< [5..5] Pull-up selection of P65 */
#define GPIO_PLU_PIN_P66     (GPIO_CTL->IOPnPLU_b[P6].P6PLU)            /*!< [6..6] Pull-up selection of P66 */
#define GPIO_PLU_PIN_P67     (GPIO_CTL->IOPnPLU_b[P6].P7PLU)            /*!< [7..7] Pull-up selection of P67 */

#define GPIO_PLU_PIN_P70     (GPIO_CTL->IOPnPLU_b[P7].P0PLU)            /*!< [0..0] Pull-up selection of P70 */
#define GPIO_PLU_PIN_P71     (GPIO_CTL->IOPnPLU_b[P7].P1PLU)            /*!< [1..1] Pull-up selection of P71 */
#define GPIO_PLU_PIN_P72     (GPIO_CTL->IOPnPLU_b[P7].P2PLU)            /*!< [2..2] Pull-up selection of P72 */
#define GPIO_PLU_PIN_P73     (GPIO_CTL->IOPnPLU_b[P7].P3PLU)            /*!< [3..3] Pull-up selection of P73 */
#define GPIO_PLU_PIN_P74     (GPIO_CTL->IOPnPLU_b[P7].P4PLU)            /*!< [4..4] Pull-up selection of P74 */
#define GPIO_PLU_PIN_P75     (GPIO_CTL->IOPnPLU_b[P7].P5PLU)            /*!< [5..5] Pull-up selection of P75 */
#define GPIO_PLU_PIN_P76     (GPIO_CTL->IOPnPLU_b[P7].P6PLU)            /*!< [6..6] Pull-up selection of P76 */
#define GPIO_PLU_PIN_P77     (GPIO_CTL->IOPnPLU_b[P7].P7PLU)            /*!< [7..7] Pull-up selection of P77 */

#define GPIO_PLU_PIN_P80     (GPIO_CTL->IOPnPLU_b[P8].P0PLU)            /*!< [0..0] Pull-up selection of P80 */
#define GPIO_PLU_PIN_P81     (GPIO_CTL->IOPnPLU_b[P8].P1PLU)            /*!< [1..1] Pull-up selection of P81 */
#define GPIO_PLU_PIN_P82     (GPIO_CTL->IOPnPLU_b[P8].P2PLU)            /*!< [2..2] Pull-up selection of P82 */
#define GPIO_PLU_PIN_P83     (GPIO_CTL->IOPnPLU_b[P8].P3PLU)            /*!< [3..3] Pull-up selection of P83 */
#define GPIO_PLU_PIN_P84     (GPIO_CTL->IOPnPLU_b[P8].P4PLU)            /*!< [4..4] Pull-up selection of P84 */
#define GPIO_PLU_PIN_P85     (GPIO_CTL->IOPnPLU_b[P8].P5PLU)            /*!< [5..5] Pull-up selection of P85 */
#define GPIO_PLU_PIN_P86     (GPIO_CTL->IOPnPLU_b[P8].P6PLU)            /*!< [6..6] Pull-up selection of P86 */
#define GPIO_PLU_PIN_P87     (GPIO_CTL->IOPnPLU_b[P8].P7PLU)            /*!< [7..7] Pull-up selection of P87 */

#define GPIO_PLU_PIN_P90     (GPIO_CTL->IOPnPLU_b[P9].P0PLU)            /*!< [0..0] Pull-up selection of P90 */
#define GPIO_PLU_PIN_P91     (GPIO_CTL->IOPnPLU_b[P9].P1PLU)            /*!< [1..1] Pull-up selection of P91 */
#define GPIO_PLU_PIN_P92     (GPIO_CTL->IOPnPLU_b[P9].P2PLU)            /*!< [2..2] Pull-up selection of P92 */
#define GPIO_PLU_PIN_P93     (GPIO_CTL->IOPnPLU_b[P9].P3PLU)            /*!< [3..3] Pull-up selection of P93 */
#define GPIO_PLU_PIN_P94     (GPIO_CTL->IOPnPLU_b[P9].P4PLU)            /*!< [4..4] Pull-up selection of P94 */
#define GPIO_PLU_PIN_P95     (GPIO_CTL->IOPnPLU_b[P9].P5PLU)            /*!< [5..5] Pull-up selection of P95 */
#define GPIO_PLU_PIN_P96     (GPIO_CTL->IOPnPLU_b[P9].P6PLU)            /*!< [6..6] Pull-up selection of P96 */
#define GPIO_PLU_PIN_P97     (GPIO_CTL->IOPnPLU_b[P9].P7PLU)            /*!< [7..7] Pull-up selection of P97 */

#define GPIO_PLU_PIN_PA0     (GPIO_CTL->IOPnPLU_b[PA].P0PLU)            /*!< [0..0] Pull-up selection of PA0 */
#define GPIO_PLU_PIN_PA1     (GPIO_CTL->IOPnPLU_b[PA].P1PLU)            /*!< [1..1] Pull-up selection of PA1 */
#define GPIO_PLU_PIN_PA2     (GPIO_CTL->IOPnPLU_b[PA].P2PLU)            /*!< [2..2] Pull-up selection of PA2 */
#define GPIO_PLU_PIN_PA3     (GPIO_CTL->IOPnPLU_b[PA].P3PLU)            /*!< [3..3] Pull-up selection of PA3 */
#define GPIO_PLU_PIN_PA4     (GPIO_CTL->IOPnPLU_b[PA].P4PLU)            /*!< [4..4] Pull-up selection of PA4 */
#define GPIO_PLU_PIN_PA5     (GPIO_CTL->IOPnPLU_b[PA].P5PLU)            /*!< [5..5] Pull-up selection of PA5 */
#define GPIO_PLU_PIN_PA6     (GPIO_CTL->IOPnPLU_b[PA].P6PLU)            /*!< [6..6] Pull-up selection of PA6 */
#define GPIO_PLU_PIN_PA7     (GPIO_CTL->IOPnPLU_b[PA].P7PLU)            /*!< [7..7] Pull-up selection of PA7 */

#define GPIO_PLU_PIN_PB0     (GPIO_CTL->IOPnPLU_b[PB].P0PLU)            /*!< [0..0] Pull-up selection of PB0 */
#define GPIO_PLU_PIN_PB1     (GPIO_CTL->IOPnPLU_b[PB].P1PLU)            /*!< [1..1] Pull-up selection of PB1 */
#define GPIO_PLU_PIN_PB2     (GPIO_CTL->IOPnPLU_b[PB].P2PLU)            /*!< [2..2] Pull-up selection of PB2 */
#define GPIO_PLU_PIN_PB3     (GPIO_CTL->IOPnPLU_b[PB].P3PLU)            /*!< [3..3] Pull-up selection of PB3 */
#define GPIO_PLU_PIN_PB4     (GPIO_CTL->IOPnPLU_b[PB].P4PLU)            /*!< [4..4] Pull-up selection of PB4 */
#define GPIO_PLU_PIN_PB6     (GPIO_CTL->IOPnPLU_b[PB].P6PLU)            /*!< [6..6] Pull-up selection of PB6 */
#define GPIO_PLU_PIN_PB7     (GPIO_CTL->IOPnPLU_b[PB].P7PLU)            /*!< [7..7] Pull-up selection of PB7 */

#define GPIO_PLU_PIN_PC4     (GPIO_CTL->IOPnPLU_b[PC].P4PLU)            /*!< [4..4] Pull-up selection of PC4 */
#define GPIO_PLU_PIN_PC5     (GPIO_CTL->IOPnPLU_b[PC].P5PLU)            /*!< [5..5] Pull-up selection of PC5 */
#define GPIO_PLU_PIN_PC6     (GPIO_CTL->IOPnPLU_b[PC].P6PLU)            /*!< [6..6] Pull-up selection of PC6 */
#define GPIO_PLU_PIN_PC7     (GPIO_CTL->IOPnPLU_b[PC].P7PLU)            /*!< [7..7] Pull-up selection of PC7 */

#define GPIO_PLU_PIN_PD2     (GPIO_CTL->IOPnPLU_b[PD].P2PLU)            /*!< [2..2] Pull-up selection of PD2 */
#define GPIO_PLU_PIN_PD3     (GPIO_CTL->IOPnPLU_b[PD].P3PLU)            /*!< [3..3] Pull-up selection of PD3 */
#define GPIO_PLU_PIN_PD4     (GPIO_CTL->IOPnPLU_b[PD].P4PLU)            /*!< [4..4] Pull-up selection of PD4 */
#define GPIO_PLU_PIN_PD5     (GPIO_CTL->IOPnPLU_b[PD].P5PLU)            /*!< [5..5] Pull-up selection of PD5 */
#define GPIO_PLU_PIN_PD6     (GPIO_CTL->IOPnPLU_b[PD].P6PLU)            /*!< [6..6] Pull-up selection of PD6 */
#define GPIO_PLU_PIN_PD7     (GPIO_CTL->IOPnPLU_b[PD].P7PLU)            /*!< [7..7] Pull-up selection of PD7 */

#define GPIO_PLU_PIN_PE2     (GPIO_CTL->IOPnPLU_b[PE].P2PLU)            /*!< [2..2] Pull-up selection of PE2 */
#define GPIO_PLU_PIN_PE3     (GPIO_CTL->IOPnPLU_b[PE].P3PLU)            /*!< [3..3] Pull-up selection of PE3 */
#define GPIO_PLU_PIN_PE4     (GPIO_CTL->IOPnPLU_b[PE].P4PLU)            /*!< [4..4] Pull-up selection of PE4 */
#define GPIO_PLU_PIN_PE5     (GPIO_CTL->IOPnPLU_b[PE].P5PLU)            /*!< [5..5] Pull-up selection of PE5 */
#define GPIO_PLU_PIN_PE6     (GPIO_CTL->IOPnPLU_b[PE].P6PLU)            /*!< [6..6] Pull-up selection of PE6 */
#define GPIO_PLU_PIN_PE7     (GPIO_CTL->IOPnPLU_b[PE].P7PLU)            /*!< [7..7] Pull-up selection of PE7 */

#define GPIO_PLU_PIN_PF0     (GPIO_CTL->IOPnPLU_b[PF].P0PLU)            /*!< [0..0] Pull-up selection of PF0 */
#define GPIO_PLU_PIN_PF1     (GPIO_CTL->IOPnPLU_b[PF].P1PLU)            /*!< [1..1] Pull-up selection of PF1 */
#define GPIO_PLU_PIN_PF2     (GPIO_CTL->IOPnPLU_b[PF].P2PLU)            /*!< [2..2] Pull-up selection of PF2 */
#define GPIO_PLU_PIN_PF3     (GPIO_CTL->IOPnPLU_b[PF].P3PLU)            /*!< [3..3] Pull-up selection of PF3 */
#define GPIO_PLU_PIN_PF4     (GPIO_CTL->IOPnPLU_b[PF].P4PLU)            /*!< [4..4] Pull-up selection of PF4 */
#define GPIO_PLU_PIN_PF5     (GPIO_CTL->IOPnPLU_b[PF].P5PLU)            /*!< [5..5] Pull-up selection of PF5 */
#define GPIO_PLU_PIN_PF6     (GPIO_CTL->IOPnPLU_b[PF].P6PLU)            /*!< [6..6] Pull-up selection of PF6 */
#define GPIO_PLU_PIN_PF7     (GPIO_CTL->IOPnPLU_b[PF].P7PLU)            /*!< [7..7] Pull-up selection of PF7 */

/*---------------------------------------------------------------------------------------------------------*/
/*  To select the input level of the specified pin                                                         */
/*---------------------------------------------------------------------------------------------------------*/
#define GPIO_ILV_PIN_P06     (GPIO_CTL->IOPnILV_b[P0].P6ILV)            /*!< [6..6] Input level selection of P06 */
#define GPIO_ILV_PIN_P07     (GPIO_CTL->IOPnILV_b[P0].P7ILV)            /*!< [7..7] Input level selection of P07 */

#define GPIO_ILV_PIN_P12     (GPIO_CTL->IOPnILV_b[P1].P2ILV)            /*!< [2..2] Input level selection of P12 */
#define GPIO_ILV_PIN_P13     (GPIO_CTL->IOPnILV_b[P1].P3ILV)            /*!< [3..3] Input level selection of P13 */
#define GPIO_ILV_PIN_P14     (GPIO_CTL->IOPnILV_b[P1].P4ILV)            /*!< [4..4] Input level selection of P14 */
#define GPIO_ILV_PIN_P15     (GPIO_CTL->IOPnILV_b[P1].P5ILV)            /*!< [5..5] Input level selection of P15 */

#define GPIO_ILV_PIN_P20     (GPIO_CTL->IOPnILV_b[P2].P0ILV)            /*!< [0..0] Input level selection of P20 */
#define GPIO_ILV_PIN_P21     (GPIO_CTL->IOPnILV_b[P2].P1ILV)            /*!< [1..1] Input level selection of P21 */

#define GPIO_ILV_PIN_P52     (GPIO_CTL->IOPnILV_b[P5].P2ILV)            /*!< [2..2] Input level selection of P52 */
#define GPIO_ILV_PIN_P53     (GPIO_CTL->IOPnILV_b[P5].P3ILV)            /*!< [3..3] Input level selection of P53 */

/*-----------------------------*/
/* BSP API function prototypes */
/*-----------------------------*/
void GPIO_EXIntClose(uint32_t u32exirq);
void GPIO_EXIntOpen(uint32_t u32exirq, uint8_t u8irqeg,  uint8_t u8irqtg, uint32_t u32priority);
void GPIO_NoiseFilterClose(uint32_t u32exirq);
void GPIO_NoiseFilterOpen(uint32_t u32exirq, uint32_t u32smp);
void GPIO_EXDisableInt(uint32_t u32exirq);
void GPIO_EXEnableInt(uint32_t u32exirq, uint32_t u32priority);
void GPIO_SetMode(uint32_t u32port, uint32_t u32pin, uint32_t u32value);

/*@}*/ /* end of group GPIO_EXPORTED_FUNCTIONS */

/*@}*/ /* end of group GPIO_Driver */

/*@}*/ /* end of group Standard_Driver */


#ifdef __cplusplus
}
#endif

#endif  /* __GPIO_H__ */

/*** (C) COPYRIGHT 2021 Nuvoton Technology Corp. Japan ***/
