
#if (NUCODEGEN_ADC)

#if (NUCODEGEN_ADC_COMPAER0_INTERRUPT)
    extern volatile uint32_t g_u32AdcCmp0IntFlag;
#endif

#if (NUCODEGEN_ADC_COMPAER1_INTERRUPT)
    extern volatile uint32_t g_u32AdcCmp1IntFlag;
#endif

#if (NUCODEGEN_ADC_INTERRUPT)
    extern volatile uint32_t g_u32AdcIntFlag;
#endif

void ADC_Init(void)
{
    ADC_POWER_ON(ADC);

#if (NUCODEGEN_ADC_INPUT_MODE == NUCODEGEN_ADC_INPUT_MODE_SINGLE_END)
    ADC_Open(ADC, ADC_ADCR_DIFFEN_SINGLE_END, NUCODEGEN_ADC_OP_MODE,
#elif (NUCODEGEN_ADC_INPUT_MODE == NUCODEGEN_ADC_INPUT_MODE_DIFFERENTIAL)
    ADC_SET_DMOF(ADC, ADC_ADCR_DMOF_UNSIGNED_OUTPUT);
    ADC_Open(ADC, ADC_ADCR_DIFFEN_DIFFERENTIAL, NUCODEGEN_ADC_OP_MODE,
#elif (NUCODEGEN_ADC_INPUT_MODE == NUCODEGEN_ADC_INPUT_MODE_DIFFERENTIAL_2_COMPLEMENT)
    ADC_SET_DMOF(ADC, ADC_ADCR_DMOF_TWOS_COMPLEMENT);
    ADC_Open(ADC, ADC_ADCR_DIFFEN_DIFFERENTIAL, NUCODEGEN_ADC_OP_MODE,
#endif
        NUCODEGEN_ADC_CHANNEL
        );


#if (NUCODEGEN_ADC_TRIGGER_SRC == NUCODEGEN_ADC_TRIGGER_SRC_STADC_LOW_LEVEL)
    ADC_EnableHWTrigger(ADC, ADC_ADCR_TRGS_STADC, ADC_ADCR_TRGCOND_LOW_LEVEL);
#elif (NUCODEGEN_ADC_TRIGGER_SRC == NUCODEGEN_ADC_TRIGGER_SRC_STADC_HIGH_LEVEL)
    ADC_EnableHWTrigger(ADC, ADC_ADCR_TRGS_STADC, ADC_ADCR_TRGCOND_HIGH_LEVEL);
#elif (NUCODEGEN_ADC_TRIGGER_SRC == NUCODEGEN_ADC_TRIGGER_SRC_STADC_FALLING_EDGE)
    ADC_EnableHWTrigger(ADC, ADC_ADCR_TRGS_STADC, ADC_ADCR_TRGCOND_FALLING_EDGE);
#elif (NUCODEGEN_ADC_TRIGGER_SRC == NUCODEGEN_ADC_TRIGGER_SRC_STADC_RISING_EDGE)
    ADC_EnableHWTrigger(ADC, ADC_ADCR_TRGS_STADC, ADC_ADCR_TRGCOND_RISING_EDGE);
#elif (NUCODEGEN_ADC_TRIGGER_SRC == NUCODEGEN_ADC_TRIGGER_SRC_TIMER)
    ADC_EnableHWTrigger(ADC, ADC_ADCR_TRGS_TIMER, NULL);
#elif (NUCODEGEN_ADC_TRIGGER_SRC == NUCODEGEN_ADC_TRIGGER_SRC_BPWM)
    ADC_EnableHWTrigger(ADC, ADC_ADCR_TRGS_BPWM, NULL);
#elif (NUCODEGEN_ADC_TRIGGER_SRC == NUCODEGEN_ADC_TRIGGER_SRC_PWM)
    ADC_EnableHWTrigger(ADC, ADC_ADCR_TRGS_PWM, NULL);
#endif


    ADC_SetExtendSampleTime(ADC, 0, NUCODEGEN_ADC_EXTEND_SAMPLE_TIME);


#if (NUCODEGEN_ADC_INTERRUPT)
    g_u32AdcIntFlag = 0;
    ADC_CLR_INT_FLAG(ADC, ADC_ADF_INT);
    ADC_ENABLE_INT(ADC, ADC_ADF_INT);
    NVIC_EnableIRQ(ADC_IRQn);
#endif


#if (NUCODEGEN_ADC_PDMA)
    ADC_ENABLE_PDMA(ADC);
#endif


#if (NUCODEGEN_ADC_COMPAER0_ENABLE)
    ADC_ENABLE_CMP0(ADC, NUCODEGEN_ADC_COMPAER0_CHANNEL, NUCODEGEN_ADC_COMPAER0_CONDITION, 
                    NUCODEGEN_ADC_COMPAER0_DATA, NUCODEGEN_ADC_COMPAER0_MATCH_COUNT);
#if (NUCODEGEN_ADC_COMPAER0_INTERRUPT)
    g_u32AdcCmp0IntFlag = 0;
    ADC_CLR_INT_FLAG(ADC, ADC_CMP0_INT);
    ADC_ENABLE_INT(ADC, ADC_CMP0_INT);
    NVIC_EnableIRQ(ADC_IRQn);
#endif
#if (NUCODEGEN_ADC_COMPAER0_WINDOW)
    ADC_ENABLE_CMP_WINDOW_MODE(ADC, 0);
#else
    ADC_DISABLE_CMP_WINDOW_MODE(ADC, 0);
#endif
#endif


#if (NUCODEGEN_ADC_COMPAER1_ENABLE)
    ADC_ENABLE_CMP1(ADC, NUCODEGEN_ADC_COMPAER1_CHANNEL, NUCODEGEN_ADC_COMPAER1_CONDITION, 
                    NUCODEGEN_ADC_COMPAER1_DATA, NUCODEGEN_ADC_COMPAER1_MATCH_COUNT);
#if (NUCODEGEN_ADC_COMPAER1_INTERRUPT)
    g_u32AdcCmp1IntFlag = 0;
    ADC_CLR_INT_FLAG(ADC, ADC_CMP1_INT);
    ADC_ENABLE_INT(ADC, ADC_CMP1_INT);
    NVIC_EnableIRQ(ADC_IRQn);
#endif
#endif
}

#endif /* end of NUCODEGEN_ADC */
