
#if (NUCODEGEN_ADC)

#if (NUCODEGEN_ADC_COMPAER0_INTERRUPT)
    extern volatile uint32_t g_u32AdcCmp0IntFlag;
#endif

#if (NUCODEGEN_ADC_COMPAER1_INTERRUPT)
    extern volatile uint32_t g_u32AdcCmp1IntFlag;
#endif

#if (NUCODEGEN_ADC_INTERRUPT)
    extern volatile uint32_t g_u32AdcIntFlag;
#endif

void ADC_Init(void)
{
    ADC_POWER_ON(ADC);

#if (NUCODEGEN_ADC_INPUT_MODE == NUCODEGEN_ADC_INPUT_MODE_SINGLE_END)
	ADC_SET_DMOF(ADC, ADC_ADCR_DMOF_UNSIGNED_OUTPUT);
    ADC_Open(ADC, ADC_ADCR_DIFFEN_SINGLE_END, NUCODEGEN_ADC_OP_MODE,
#elif (NUCODEGEN_ADC_INPUT_MODE == NUCODEGEN_ADC_INPUT_MODE_SINGLE_END_2_COMPLEMENT)
    ADC_SET_DMOF(ADC, ADC_ADCR_DMOF_TWOS_COMPLEMENT); 
    ADC_Open(ADC, ADC_ADCR_DIFFEN_SINGLE_END, NUCODEGEN_ADC_OP_MODE,
#elif (NUCODEGEN_ADC_INPUT_MODE == NUCODEGEN_ADC_INPUT_MODE_DIFFERENTIAL)
    ADC_SET_DMOF(ADC, ADC_ADCR_DMOF_UNSIGNED_OUTPUT);
    ADC_Open(ADC, ADC_ADCR_DIFFEN_DIFFERENTIAL, NUCODEGEN_ADC_OP_MODE,
#elif (NUCODEGEN_ADC_INPUT_MODE == NUCODEGEN_ADC_INPUT_MODE_DIFFERENTIAL_2_COMPLEMENT)
    ADC_SET_DMOF(ADC, ADC_ADCR_DMOF_TWOS_COMPLEMENT); 
    ADC_Open(ADC, ADC_ADCR_DIFFEN_DIFFERENTIAL, NUCODEGEN_ADC_OP_MODE,
#endif

#if (NUCODEGEN_ADC_CHANNEL0)
        BIT0 |
#endif
#if (NUCODEGEN_ADC_CHANNEL1)
        BIT1 |
#endif
#if (NUCODEGEN_ADC_CHANNEL2)
        BIT2 |
#endif
#if (NUCODEGEN_ADC_CHANNEL3)
        BIT3 |
#endif
#if (NUCODEGEN_ADC_CHANNEL4)
        BIT4 |
#endif
#if (NUCODEGEN_ADC_CHANNEL5)
        BIT5 |
#endif
#if (NUCODEGEN_ADC_CHANNEL6)
        BIT6 |
#endif
#if (NUCODEGEN_ADC_CHANNEL7)
        BIT7 |
#endif
#if (NUCODEGEN_ADC_CHANNEL29)
        BIT29 |
#endif
#if (NUCODEGEN_ADC_CHANNEL30)
        BIT30 |
#endif
        NULL
    );


#if (NUCODEGEN_ADC_TRIGGER_SRC == NUCODEGEN_ADC_TRIGGER_SRC_STADC_LOW_LEVEL)
    ADC_EnableHWTrigger(ADC, ADC_ADCR_TRGS_STADC, ADC_ADCR_TRGCOND_LOW_LEVEL);
#elif (NUCODEGEN_ADC_TRIGGER_SRC == NUCODEGEN_ADC_TRIGGER_SRC_STADC_HIGH_LEVEL)
    ADC_EnableHWTrigger(ADC, ADC_ADCR_TRGS_STADC, ADC_ADCR_TRGCOND_HIGH_LEVEL);
#elif (NUCODEGEN_ADC_TRIGGER_SRC == NUCODEGEN_ADC_TRIGGER_SRC_STADC_FALLING_EDGE)
    ADC_EnableHWTrigger(ADC, ADC_ADCR_TRGS_STADC, ADC_ADCR_TRGCOND_FALLING_EDGE);
#elif (NUCODEGEN_ADC_TRIGGER_SRC == NUCODEGEN_ADC_TRIGGER_SRC_STADC_RISING_EDGE)
    ADC_EnableHWTrigger(ADC, ADC_ADCR_TRGS_STADC, ADC_ADCR_TRGCOND_RISING_EDGE);
#elif (NUCODEGEN_ADC_TRIGGER_SRC == NUCODEGEN_ADC_TRIGGER_SRC_TIMER)
    ADC_EnableHWTrigger(ADC, ADC_ADCR_TRGS_TIMER, NULL);
#elif (NUCODEGEN_ADC_TRIGGER_SRC == NUCODEGEN_ADC_TRIGGER_SRC_BPWM)
    ADC_EnableHWTrigger(ADC, ADC_ADCR_TRGS_BPWM, NULL);
#endif

//#if (NUCODEGEN_ADC_INTERNAL_SAMPLE_TIME)
	ADC->ADCR = (ADC->ADCR &(~(ADC_ADCR_SMPTSEL_Msk))) | NUCODEGEN_ADC_INTERNAL_SAMPLE_TIME;
//#endif

#if (NUCODEGEN_ADC_INTERRUPT)
    g_u32AdcIntFlag = 0;
    ADC_CLR_INT_FLAG(ADC, ADC_ADF_INT);
    ADC_EnableInt(ADC, ADC_ADF_INT);
    NVIC_EnableIRQ(ADC_IRQn);
#endif


#if (NUCODEGEN_ADC_PDMA)
    ADC_ENABLE_PDMA(ADC);
#endif


#if (NUCODEGEN_ADC_COMPAER0_ENABLE)
    ADC_ENABLE_CMP0(ADC, NUCODEGEN_ADC_COMPAER0_CHANNEL, NUCODEGEN_ADC_COMPAER0_CONDITION, NUCODEGEN_ADC_COMPAER0_DATA, NUCODEGEN_ADC_COMPAER0_MATCH_COUNT);
#if (NUCODEGEN_ADC_COMPAER0_INTERRUPT)
    g_u32AdcCmp0IntFlag = 0;
    ADC_CLR_INT_FLAG(ADC, ADC_CMP0_INT);
    ADC_EnableInt(ADC, ADC_CMP0_INT);
    NVIC_EnableIRQ(ADC_IRQn);
#endif
#if (NUCODEGEN_ADC_COMPAER0_WINDOW)
	ADC->ADCMPR[0] |= ADC_ADCMPR_CMPWEN_Msk;
#else
	ADC->ADCMPR[0] &= (~ADC_ADCMPR_CMPWEN_Msk);
#endif
#endif


#if (NUCODEGEN_ADC_COMPAER1_ENABLE)
    ADC_ENABLE_CMP1(ADC, NUCODEGEN_ADC_COMPAER1_CHANNEL, NUCODEGEN_ADC_COMPAER1_CONDITION, NUCODEGEN_ADC_COMPAER1_DATA, NUCODEGEN_ADC_COMPAER1_MATCH_COUNT);
#if (NUCODEGEN_ADC_COMPAER1_INTERRUPT)
    g_u32AdcCmp1IntFlag = 0;
    ADC_CLR_INT_FLAG(ADC, ADC_CMP1_INT);
    ADC_EnableInt(ADC, ADC_CMP1_INT);
    NVIC_EnableIRQ(ADC_IRQn);
#endif
#endif
}

#endif /* end of NUCODEGEN_ADC */
