//chip content
NUTOOL_PIN.g_cfg_chips = [
	// M030G
	{ name: "M030GGC0AE", pkg: "QFN24" },
	{ name: "M030GGD1AE", pkg: "QFN24" },
	{ name: "M030GGC1AE", pkg: "QFN24" },
	{ name: "M030GTC1AE", pkg: "QFN33" },
	{ name: "M030GTC0AE", pkg: "QFN33" },
	{ name: "M030GTD1AE", pkg: "QFN33" },
	// M030G_31G
	{ name: "M031GGD2AE", pkg: "QFN24" },
	{ name: "M031GGC2AE", pkg: "QFN24" },
	{ name: "M031GGC1AE", pkg: "QFN24" },
	{ name: "M031GTD2AE", pkg: "QFN33" },
	{ name: "M031GTC2AE", pkg: "QFN33" },
	{ name: "M031GTC1AE", pkg: "QFN33" },
	// M031
	{ name: "M031FB0AE", pkg: "TSSOP20" },
	{ name: "M031FC1AE", pkg: "TSSOP20" },
	{ name: "M031EB0AE", pkg: "TSSOP28" },
	{ name: "M031EC1AE", pkg: "TSSOP28" },
	{ name: "M031TB0AE", pkg: "QFN33" },
	{ name: "M031TC1AE", pkg: "QFN33" },
	{ name: "M031TD2AE", pkg: "QFN33" },
	{ name: "M031TE3AE", pkg: "QFN33" },
	{ name: "M031LC2AE", pkg: "LQFP48" },
	{ name: "M031LD2AE", pkg: "LQFP48" },
	{ name: "M031LE3AE", pkg: "LQFP48" },
	{ name: "M032LE3AE", pkg: "LQFP48" },
	{ name: "M031SC2AE", pkg: "LQFP64" },
	{ name: "M031SD2AE", pkg: "LQFP64" },
	{ name: "M031SE3AE", pkg: "LQFP64" },
	{ name: "M032SE3AE", pkg: "LQFP64" },
	// M031G
	{ name: "M031LG6AE", pkg: "LQFP48" },
	{ name: "M031SG6AE", pkg: "LQFP64" },
	{ name: "M031KG6AE", pkg: "LQFP128" },
	{ name: "M031LG8AE", pkg: "LQFP48" },
	{ name: "M031SG8AE", pkg: "LQFP64" },
	{ name: "M031KG8AE", pkg: "LQFP128" },
	{ name: "M032LG6AE", pkg: "LQFP48" },
	{ name: "M032SG6AE", pkg: "LQFP64" },
	{ name: "M032KG6AE", pkg: "LQFP128" },
	{ name: "M032LG8AE", pkg: "LQFP48" },
	{ name: "M032SG8AE", pkg: "LQFP64" },
	{ name: "M032KG8AE", pkg: "LQFP128" },
	{ name: "M032BTAG8AN", pkg: "QFN68" },
	// M031I
	{ name: "M031SIAAE", pkg: "LQFP64" },
	{ name: "M031KIAAE", pkg: "LQFP128" },
	{ name: "M032SIAAE", pkg: "LQFP64" },
	{ name: "M032KIAAE", pkg: "LQFP128" },
	{ name: "M032BTAIAAN", pkg: "QFN68" },
	// M031KM
	{ name: "M030FD2AE", pkg: "TSSOP20" },
	{ name: "M030TD2AE", pkg: "QFN33" },
	{ name: "M030LD2AE", pkg: "LQFP48" },
	{ name: "M032FC1AE", pkg: "TSSOP20" },
	{ name: "M032EC1AE", pkg: "TSSOP28" },
	{ name: "M032TC1AE", pkg: "QFN33" },
	{ name: "M032TD2AE", pkg: "QFN33" },
	{ name: "M032LC2AE", pkg: "LQFP48" },
	{ name: "M032LD2AE", pkg: "LQFP48" },
	// M031BT
	{ name: "M031BTYD2AN", pkg: "QFN48" },
	{ name: "M031BTYE3AN", pkg: "QFN48" }
];

NUTOOL_PIN.g_cfg_pkgs = {
	"LQFP64": [
		'PB.6', 'PB.5', 'PB.4', 'PB.3', 'PB.2', 'PB.1', 'PB.0', 'PA.11', 'PA.10', 'PA.9',
		'PA.8', 'PF.6', 'PF.14', 'PF.5', 'PF.4', 'PF.3',
		'PF.2', 'PC.7', 'PC.6', 'PA.7', 'PA.6', 'VSS', 'VDD', 'PD.15', 'PA.5', 'PA.4',
		'PA.3', 'PA.2', 'PA.1', 'PA.0', 'PF.15', 'nRESET',
		'PF.0', 'PF.1', 'PC.5', 'PC.4', 'PC.3', 'PC.2', 'PC.1', 'PC.0', 'PD.3', 'PD.2',
		'PD.1', 'PD.0', 'PA.12', 'PA.13', 'PA.14', 'PA.15',
		'VSS', 'LDO_CAP', 'VDD', 'PC.14', 'PB.15', 'PB.14', 'PB.13', 'PB.12', 'AVDD', 'VREF',
		'AVSS', 'PB.11', 'PB.10', 'PB.9', 'PB.8', 'PB.7'
	],
	"ULQFP64": [
		'PB.6', 'PB.5', 'PB.4', 'PB.3', 'PB.2', 'PB.1', 'PB.0', 'PA.11', 'PA.10', 'PA.9',
		'PA.8', 'PF.6', 'PF.14', 'PF.5', 'PF.4', 'PF.3',
		'PF.2', 'PC.7', 'PC.6', 'PA.7', 'PA.6', 'VSS', 'VDD', 'PD.15', 'PA.5', 'PA.4',
		'PA.3', 'PA.2', 'PA.1', 'PA.0', 'PF.15', 'nRESET',
		'PF.0', 'PF.1', 'PC.5', 'PC.4', 'PC.3', 'PC.2', 'PC.1', 'PC.0', 'PD.3', 'PD.2',
		'PD.1', 'PD.0', 'USB_VBUS', 'USB_D-', 'USB_D+', 'USB_VDD33_CAP',
		'VSS', 'LDO_CAP', 'VDD', 'PC.14', 'PB.15', 'PB.14', 'PB.13', 'PB.12', 'AVDD', 'VREF',
		'AVSS', 'PB.11', 'PB.10', 'PB.9', 'PB.8', 'PB.7'
	],
	"UQFN68": [
		'RF_BUCK_OUT', 'VSS', 'VSS', 'LDO_CAP', 'VDD', 'PB.15', 'PB.14', 'PB.13', 'PB.12', 'AVDD',
		'AVSS', 'PB.11', 'PB.10', 'PB.9', 'PB.8', 'PB.7', 'PB.6',
		'PB.5', 'PB.4', 'PB.3', 'PB.2', 'PB.1', 'PB.0', 'PA.11', 'PA.10', 'PA.9', 'RF_VDD',
		'RF_CLKO', 'PA.8', 'PC.13', 'PF.14', 'PF.5', 'PF.4', 'PF.3',
		'PF.2', 'PE.8', 'PE.9', 'PC.7', 'PC.6', 'PA.7', 'PA.6', 'VSS', 'VDD', 'PA.5',
		'PA.4', 'PA.3', 'PA.2', 'PA.1', 'PA.0', 'PF.15', 'nRESET',
		'PF.0', 'PF.1', 'PC.1', 'PC.0', 'RF_AVDD1V2', 'VSS', 'RF_IO', 'VSS', 'RF_VDDPA', 'RF_XTAL_IN',
		'RF_XTAL_OUT', 'USB_VBUS', 'USB_D-', 'USB_D+', 'USB_VDD33_CAP', 'RF_AVDD1V2', 'RF_BUCK_FB'
	],
	"LQFP128": [
		'PB.5', 'PB.4', 'PB.3', 'PB.2', 'PC.12', 'PC.11', 'PC.10', 'PC.9', 'PB.1', 'PB.0',
		'VSS', 'VDD', 'PA.11', 'PA.10', 'PA.9', 'PA.8', 'PC.13', 'PD.12', 'PD.11', 'PD.10',
		'PG.2', 'PG.3', 'PG.4', 'PF.11', 'PF.10', 'PF.9', 'PF.8', 'PF.7', 'PF.6', 'PF.14',
		'PF.5', 'PF.4',
		'PH.4', 'PH.5', 'PH.6', 'PH.7', 'PF.3', 'PF.2', 'VSS', 'VDD', 'PE.8', 'PE.9',
		'PE.10', 'PE.11', 'PE.12', 'PE.13', 'PC.8', 'PC.7', 'PC.6', 'PA.7', 'PA.6', 'VSS',
		'VDD', 'PD.15', 'PA.5', 'PA.4', 'PA.3', 'PA.2', 'PA.1', 'PA.0', 'PF.15', 'PE.14',
		'PE.15', 'nRESET',
		'PF.0', 'PF.1', 'PD.9', 'PD.8', 'PC.5', 'PC.4', 'PC.3', 'PC.2', 'PC.1', 'PC.0',
		'VSS', 'VDD', 'PG.9', 'PG.10', 'PG.11', 'PG.12', 'PG.13', 'PG.14', 'PG.15', 'PD.7',
		'PD.6', 'PD.5', 'PD.4', 'PD.3', 'PD.2', 'PD.1', 'PD.0', 'PD.13', 'PA.12', 'PA.13',
		'PA.14', 'PA.15',
		'PE.7', 'PE.6', 'PE.5', 'PE.4', 'PE.3', 'PE.2', 'VSS', 'VDD', 'PE.1', 'PE.0',
		'PH.8', 'PH.9', 'PH.10', 'PH.11', 'PD.14', 'VSS', 'LDO_CAP', 'VDD', 'PC.14', 'PB.15',
		'PB.14', 'PB.13', 'PB.12', 'AVDD', 'VREF', 'AVSS', 'PB.11', 'PB.10', 'PB.9', 'PB.8',
		'PB.7', 'PB.6'
	],
	"ULQFP128": [
		'PB.5', 'PB.4', 'PB.3', 'PB.2', 'PC.12', 'PC.11', 'PC.10', 'PC.9', 'PB.1', 'PB.0',
		'VSS', 'VDD', 'PA.11', 'PA.10', 'PA.9', 'PA.8', 'PC.13', 'PD.12', 'PD.11', 'PD.10',
		'PG.2', 'PG.3', 'PG.4', 'PF.11', 'PF.10', 'PF.9', 'PF.8', 'PF.7', 'PF.6', 'PF.14',
		'PF.5', 'PF.4',
		'PH.4', 'PH.5', 'PH.6', 'PH.7', 'PF.3', 'PF.2', 'VSS', 'VDD', 'PE.8', 'PE.9',
		'PE.10', 'PE.11', 'PE.12', 'PE.13', 'PC.8', 'PC.7', 'PC.6', 'PA.7', 'PA.6', 'VSS',
		'VDD', 'PD.15', 'PA.5', 'PA.4', 'PA.3', 'PA.2', 'PA.1', 'PA.0', 'PF.15', 'PE.14',
		'PE.15', 'nRESET',
		'PF.0', 'PF.1', 'PD.9', 'PD.8', 'PC.5', 'PC.4', 'PC.3', 'PC.2', 'PC.1', 'PC.0',
		'VSS', 'VDD', 'PG.9', 'PG.10', 'PG.11', 'PG.12', 'PG.13', 'PG.14', 'PG.15', 'PD.7',
		'PD.6', 'PD.5', 'PD.4', 'PD.3', 'PD.2', 'PD.1', 'PD.0', 'PD.13', 'USB_VBUS', 'USB_D-',
		'USB_D+', 'USB_VDD33_CAP',
		'PE.7', 'PE.6', 'PE.5', 'PE.4', 'PE.3', 'PE.2', 'VSS', 'VDD', 'PE.1', 'PE.0',
		'PH.8', 'PH.9', 'PH.10', 'PH.11', 'PD.14', 'VSS', 'LDO_CAP', 'VDD', 'PC.14', 'PB.15',
		'PB.14', 'PB.13', 'PB.12', 'AVDD', 'VREF', 'AVSS', 'PB.11', 'PB.10', 'PB.9', 'PB.8',
		'PB.7', 'PB.6'
	]
};

NUTOOL_PIN.g_cfg_gpios = [
	{ f: ['PA.0:0', 'QSPI0_MOSI0:3', 'SPI0_MOSI:4', 'UART0_RXD:7', 'UART1_nRTS:8', 'BPWM0_CH0:12', 'PWM0_CH5:13']},
	{ f: ['PA.1:0', 'QSPI0_MISO0:3', 'SPI0_MISO:4', 'UART0_TXD:7', 'UART1_nCTS:8', 'BPWM0_CH1:12', 'PWM0_CH4:13']},
	{ f: ['PA.2:0', 'QSPI0_CLK:3', 'SPI0_CLK:4', 'UART4_RXD:5', 'I2C0_SMBSUS:7', 'UART1_RXD:8', 'I2C1_SDA:9', 'BPWM0_CH2:12', 'PWM0_CH3:13']},
	{ f: ['PA.3:0', 'QSPI0_SS:3', 'SPI0_SS:4', 'UART4_TXD:5', 'I2C0_SMBAL:7', 'UART1_TXD:8', 'I2C1_SCL:9', 'BPWM0_CH3:12', 'PWM0_CH2:13', 'CLKO:14', 'PWM1_BRAKE1:15']},
	{ f: ['PA.4:0', 'QSPI0_MOSI1:3', 'SPI0_I2SMCLK:4', 'UART0_nRTS:7', 'UART0_RXD:8', 'I2C0_SDA:9', 'UART5_RXD:11', 'BPWM0_CH4:12', 'PWM0_CH1:13']},
	{ f: ['PA.5:0', 'QSPI0_MISO1:3', 'UART0_nCTS:7', 'UART0_TXD:8', 'I2C0_SCL:9', 'UART5_TXD:11', 'BPWM0_CH5:12', 'PWM0_CH0:13']},
	{ f: ['PA.6:0', 'EBI_AD6:2', 'UART0_RXD:7', 'I2C1_SDA:8', 'PWM1_CH5:11', 'BPWM1_CH3:12', 'ACMP1_WLAT:13', 'TM3:14', 'INT0:15']},
	{ f: ['PA.7:0', 'EBI_AD7:2', 'UART0_TXD:7', 'I2C1_SCL:8', 'PWM1_CH4:11', 'BPWM1_CH2:12', 'ACMP0_WLAT:13', 'TM2:14', 'INT1:15']},
	{ f: ['PA.8:0', 'EBI_ALE:2', 'USCI0_CTL1:6', 'UART1_RXD:7', 'UART7_RXD:8', 'BPWM0_CH3:9', 'TM3_EXT:13', 'INT4:15']},
	{ f: ['PA.9:0', 'EBI_MCLK:2', 'USCI0_DAT1:6', 'UART1_TXD:7', 'UART7_TXD:8', 'BPWM0_CH2:9', 'TM2_EXT:13']},
	{ f: ['PA.10:0', 'ACMP1_P0:1', 'EBI_nWR:2', 'USCI0_DAT0:6', 'UART6_RXD:8', 'BPWM0_CH1:9', 'TM1_EXT:13']},
	{ f: ['PA.11:0', 'ACMP0_P0:1', 'EBI_nRD:2', 'USCI0_CLK:6', 'UART6_TXD:8', 'BPWM0_CH0:9', 'TM0_EXT:13']},
	{ f: ['PA.12:0', 'UART4_TXD:3', 'I2C1_SCL:4', 'BPWM1_CH2:11']},
	{ f: ['PA.13:0', 'UART4_RXD:3', 'I2C1_SDA:4', 'BPWM1_CH3:11']},
	{ f: ['PA.14:0', 'UART0_TXD:3', 'BPWM1_CH4:11']},
	{ f: ['PA.15:0', 'UART0_RXD:3', 'BPWM1_CH5:11']},

	{ f: ['PB.0:0', 'ADC0_CH0:1', 'EBI_ADR9:2', 'UART2_RXD:7', 'SPI0_I2SMCLK:8', 'I2C1_SDA:9', 'QSPI0_MOSI1:10', 'PWM0_CH5:11', 'PWM1_CH5:12', 'PWM0_BRAKE1:13']},
	{ f: ['PB.1:0', 'ADC0_CH1:1', 'EBI_ADR8:2', 'UART2_TXD:7', 'USCI1_CLK:8', 'I2C1_SCL:9', 'QSPI0_MISO1:10', 'PWM0_CH4:11', 'PWM1_CH4:12', 'PWM0_BRAKE0:13']},
	{ f: ['PB.2:0', 'ADC0_CH2:1', 'ACMP0_P1:1', 'EBI_ADR3:2', 'I2C1_SDA:4', 'UART1_RXD:6', 'UART5_nCTS:7', 'USCI1_DAT0:8', 'PWM0_CH3:11', 'TM3:14', 'INT3:15']},
	{ f: ['PB.3:0', 'ADC0_CH3:1', 'ACMP0_N:1', 'EBI_ADR2:2', 'I2C1_SCL:4', 'UART1_TXD:6', 'UART5_nRTS:7', 'USCI1_DAT1:8', 'PWM0_CH2:11', 'PWM0_BRAKE0:13', 'TM2:14', 'INT2:15']},
	{ f: ['PB.4:0', 'ADC0_CH4:1', 'ACMP1_P1:1', 'EBI_ADR1:2', 'I2C0_SDA:6', 'UART5_RXD:7', 'USCI1_CTL1:8', 'PWM0_CH1:11', 'UART2_RXD:13', 'TM1:14', 'INT1:15']},
	{ f: ['PB.5:0', 'ADC0_CH5:1', 'ACMP1_N:1', 'EBI_ADR0:2', 'I2C0_SCL:6', 'UART5_TXD:7', 'USCI1_CTL0:8', 'PWM0_CH0:11', 'UART2_TXD:13', 'TM0:14', 'INT0:15']},
	{ f: ['PB.6:0', 'ADC0_CH6:1', 'EBI_nWRH:2', 'USCI1_DAT1:4', 'UART1_RXD:6', 'EBI_nCS1:8', 'BPWM1_CH5:10', 'PWM1_BRAKE1:11', 'PWM1_CH5:12', 'INT4:13', 'ACMP1_O:15']},
	{ f: ['PB.7:0', 'ADC0_CH7:1', 'EBI_nWRL:2', 'USCI1_DAT0:4', 'UART1_TXD:6', 'EBI_nCS0:8', 'BPWM1_CH4:10', 'PWM1_BRAKE0:11', 'PWM1_CH4:12', 'INT5:13', 'ACMP0_O:15']},
	{ f: ['PB.8:0', 'ADC0_CH8:1', 'EBI_ADR19:2', 'USCI1_CLK:4', 'UART0_RXD:5', 'UART1_nRTS:6', 'UART7_RXD:8', 'BPWM1_CH3:10']},
	{ f: ['PB.9:0', 'ADC0_CH9:1', 'EBI_ADR18:2', 'USCI1_CTL1:4', 'UART0_TXD:5', 'UART1_nCTS:6', 'UART7_TXD:8', 'BPWM1_CH2:10']},
	{ f: ['PB.10:0', 'ADC0_CH10:1', 'EBI_ADR17:2', 'USCI1_CTL0:4', 'UART0_nRTS:5', 'UART4_RXD:6', 'I2C1_SDA:7', 'BPWM1_CH1:10']},
	{ f: ['PB.11:0', 'ADC0_CH11:1', 'EBI_ADR16:2', 'UART0_nCTS:5', 'UART4_TXD:6', 'I2C1_SCL:7', 'SPI0_I2SMCLK:9', 'BPWM1_CH0:10']},
	{ f: ['PB.12:0', 'ADC0_CH12:1', 'ACMP0_P2:1', 'ACMP1_P2:1', 'EBI_AD15:2', 'SPI0_MOSI:4', 'USCI0_CLK:5', 'UART0_RXD:6', 'UART3_nCTS:7', 'PWM1_CH3:11', 'TM3_EXT:13']},
	{ f: ['PB.13:0', 'ADC0_CH13:1', 'ACMP0_P3:1', 'ACMP1_P3:1', 'EBI_AD14:2', 'SPI0_MISO:4', 'USCI0_DAT0:5', 'UART0_TXD:6', 'UART3_nRTS:7', 'PWM1_CH2:11', 'TM2_EXT:13']},
	{ f: ['PB.14:0', 'ADC0_CH14:1', 'EBI_AD13:2', 'SPI0_CLK:4', 'USCI0_DAT1:5', 'UART0_nRTS:6', 'UART3_RXD:7', 'PWM1_CH1:11', 'TM1_EXT:13', 'CLKO:14']},
	{ f: ['PB.15:0', 'ADC0_CH15:1', 'EBI_AD12:2', 'SPI0_SS:4', 'USCI0_CTL1:5', 'UART0_nCTS:6', 'UART3_TXD:7', 'PWM1_CH0:11', 'TM0_EXT:13', 'PWM0_BRAKE1:15']},

	{ f: ['PC.0:0', 'EBI_AD0:2', 'QSPI0_MOSI0:4', 'UART2_RXD:8', 'I2C0_SDA:9', 'PWM1_CH5:12', 'ACMP1_O:14']},
	{ f: ['PC.1:0', 'EBI_AD1:2', 'QSPI0_MISO0:4', 'UART2_TXD:8', 'I2C0_SCL:9', 'PWM1_CH4:12', 'ACMP0_O:14', 'ADC0_ST:15']},
	{ f: ['PC.2:0', 'EBI_AD2:2', 'QSPI0_CLK:4', 'UART2_nCTS:8', 'I2C0_SMBSUS:9', 'UART3_RXD:11', 'PWM1_CH3:12']},
	{ f: ['PC.3:0', 'EBI_AD3:2', 'QSPI0_SS:4', 'UART2_nRTS:8', 'I2C0_SMBAL:9', 'UART3_TXD:11', 'PWM1_CH2:12']},
	{ f: ['PC.4:0', 'EBI_AD4:2', 'QSPI0_MOSI1:4', 'UART2_RXD:8', 'I2C1_SDA:9', 'UART4_RXD:11', 'PWM1_CH1:12']},
	{ f: ['PC.5:0', 'EBI_AD5:2', 'QSPI0_MISO1:4', 'UART2_TXD:8', 'I2C1_SCL:9', 'UART4_TXD:11', 'PWM1_CH0:12']},
	{ f: ['PC.6:0', 'EBI_AD8:2', 'UART4_RXD:5', 'UART0_nRTS:7', 'UART6_RXD:9', 'PWM1_CH3:11', 'BPWM1_CH1:12', 'TM1:14', 'INT2:15']},
	{ f: ['PC.7:0', 'EBI_AD9:2', 'UART4_TXD:5', 'UART0_nCTS:7', 'UART6_TXD:9', 'PWM1_CH2:11', 'BPWM1_CH0:12', 'TM0:14', 'INT3:15']},
	{ f: ['PC.8:0', 'EBI_ADR16:2', 'I2C0_SDA:4', 'UART4_nCTS:5', 'UART1_RXD:8', 'PWM1_CH1:11', 'BPWM1_CH4:12']},
	{ f: ['PC.9:0', 'EBI_ADR7:2', 'UART6_nCTS:5', 'UART3_RXD:7', 'PWM1_CH3:12']},
	{ f: ['PC.10:0', 'EBI_ADR6:2', 'UART6_nRTS:5', 'UART3_TXD:7', 'PWM1_CH2:12']},
	{ f: ['PC.11:0', 'EBI_ADR5:2', 'UART0_RXD:3', 'I2C0_SDA:4', 'UART6_RXD:5', 'PWM1_CH1:12', 'ACMP1_O:14']},
	{ f: ['PC.12:0', 'EBI_ADR4:2', 'UART0_TXD:3', 'I2C0_SCL:4', 'UART6_TXD:5', 'PWM1_CH0:12', 'ACMP0_O:14']},
	{ f: ['PC.13:0', 'EBI_ADR10:2', 'USCI0_CTL0:6', 'UART2_TXD:7', 'BPWM0_CH4:9', 'CLKO:13', 'ADC0_ST:14']},
	{ f: ['PC.14:0', 'EBI_AD11:2', 'SPI0_I2SMCLK:4', 'USCI0_CTL0:5', 'QSPI0_CLK:6', 'TM1:13']},
	{ f: ['PC.15:0']},

	{ f: ['PD.0:0', 'EBI_AD13:2', 'USCI0_CLK:3', 'SPI0_MOSI:4', 'UART3_RXD:5', 'TM2:14']},
	{ f: ['PD.1:0', 'EBI_AD12:2', 'USCI0_DAT0:3', 'SPI0_MISO:4', 'UART3_TXD:5']},
	{ f: ['PD.2:0', 'EBI_AD11:2', 'USCI0_DAT1:3', 'SPI0_CLK:4', 'UART3_nCTS:5', 'UART0_RXD:9']},
	{ f: ['PD.3:0', 'EBI_AD10:2', 'USCI0_CTL1:3', 'SPI0_SS:4', 'UART3_nRTS:5', 'USCI1_CTL0:6', 'UART0_TXD:9']},
	{ f: ['PD.4:0', 'USCI0_CTL0:3', 'I2C1_SDA:4', 'USCI1_CTL1:6']},
	{ f: ['PD.5:0', 'I2C1_SCL:4', 'USCI1_DAT0:6']},
	{ f: ['PD.6:0', 'UART1_RXD:3', 'I2C0_SDA:4', 'USCI1_DAT1:6']},
	{ f: ['PD.7:0', 'UART1_TXD:3', 'I2C0_SCL:4', 'USCI1_CLK:6']},
	{ f: ['PD.8:0', 'EBI_AD6:2', 'UART2_nRTS:4', 'UART7_RXD:5']},
	{ f: ['PD.9:0', 'EBI_AD7:2', 'UART2_nCTS:4', 'UART7_TXD:5']},
	{ f: ['PD.10:0', 'UART1_RXD:3']},
	{ f: ['PD.11:0', 'EBI_nCS1:2', 'UART1_TXD:3']},
	{ f: ['PD.12:0', 'EBI_nCS0:2', 'UART2_RXD:7', 'BPWM0_CH5:9', 'CLKO:13', 'ADC0_ST:14', 'INT5:15']},
	{ f: ['PD.13:0', 'EBI_AD10:2', 'SPI0_I2SMCLK:4']},
	{ f: ['PD.14:0', 'EBI_nCS0:2', 'SPI0_I2SMCLK:5', 'USCI0_CTL0:8', 'PWM0_CH4:11']},
	{ f: ['PD.15:0', 'PWM0_CH5:12', 'TM3:14', 'INT1:15']},

	{ f: ['PE.0:0', 'EBI_AD11:2', 'QSPI0_MOSI0:3', 'UART3_RXD:7', 'I2C1_SDA:8', 'UART4_nRTS:9']},
	{ f: ['PE.1:0', 'EBI_AD10:2', 'QSPI0_MISO0:3', 'UART3_TXD:7', 'I2C1_SCL:8', 'UART4_nCTS:9']},
	{ f: ['PE.2:0', 'EBI_ALE:2', 'USCI0_CLK:7', 'UART6_nCTS:8', 'UART7_RXD:9', 'PWM0_CH5:12', 'BPWM0_CH0:13']},
	{ f: ['PE.3:0', 'EBI_MCLK:2', 'USCI0_DAT0:7', 'UART6_nRTS:8', 'UART7_TXD:9', 'PWM0_CH4:12', 'BPWM0_CH1:13']},
	{ f: ['PE.4:0', 'EBI_nWR:2', 'USCI0_DAT1:7', 'UART6_RXD:8', 'UART7_nCTS:9', 'PWM0_CH3:12', 'BPWM0_CH2:13']},
	{ f: ['PE.5:0', 'EBI_nRD:2', 'USCI0_CTL1:7', 'UART6_TXD:8', 'UART7_nRTS:9', 'PWM0_CH2:12', 'BPWM0_CH3:13']},
	{ f: ['PE.6:0', 'USCI0_CTL0:7', 'UART5_RXD:8', 'PWM0_CH1:12', 'BPWM0_CH4:13']},
	{ f: ['PE.7:0', 'UART5_TXD:8', 'PWM0_CH0:12', 'BPWM0_CH5:13']},
	{ f: ['PE.8:0', 'EBI_ADR10:2', 'USCI1_CTL1:6', 'UART2_TXD:7', 'PWM0_CH0:10', 'PWM0_BRAKE0:11']},
	{ f: ['PE.9:0', 'EBI_ADR11:2', 'USCI1_CTL0:6', 'UART2_RXD:7', 'PWM0_CH1:10', 'PWM0_BRAKE1:11']},
	{ f: ['PE.10:0', 'EBI_ADR12:2', 'USCI1_DAT0:6', 'UART3_TXD:7', 'PWM0_CH2:10', 'PWM1_BRAKE0:11']},
	{ f: ['PE.11:0', 'EBI_ADR13:2', 'USCI1_DAT1:6', 'UART3_RXD:7', 'UART1_nCTS:8', 'PWM0_CH3:10', 'PWM1_BRAKE1:11']},
	{ f: ['PE.12:0', 'EBI_ADR14:2', 'USCI1_CLK:6', 'UART1_nRTS:8', 'PWM0_CH4:10']},
	{ f: ['PE.13:0', 'EBI_ADR15:2', 'I2C0_SCL:4', 'UART4_nRTS:5', 'UART1_TXD:8', 'PWM0_CH5:10', 'PWM1_CH0:11', 'BPWM1_CH5:12']},
	{ f: ['PE.14:0', 'EBI_AD8:2', 'UART2_TXD:3', 'UART6_TXD:6']},
	{ f: ['PE.15:0', 'EBI_AD9:2', 'UART2_RXD:3', 'UART6_RXD:6']},

	{ f: ['PF.0:0', 'UART1_TXD:2', 'I2C1_SCL:3', 'UART0_TXD:4', 'BPWM1_CH0:12', 'ICE_DAT:14']},
	{ f: ['PF.1:0', 'UART1_RXD:2', 'I2C1_SDA:3', 'UART0_RXD:4', 'BPWM1_CH1:12', 'ICE_CLK:14']},
	{ f: ['PF.2:0', 'EBI_nCS1:2', 'UART0_RXD:3', 'I2C0_SDA:4', 'QSPI0_CLK:5', 'XT1_OUT:10', 'BPWM1_CH1:11']},
	{ f: ['PF.3:0', 'EBI_nCS0:2', 'UART0_TXD:3', 'I2C0_SCL:4', 'XT1_IN:10', 'BPWM1_CH0:11']},
	{ f: ['PF.4:0', 'UART2_TXD:2', 'UART2_nRTS:4', 'PWM0_CH1:7', 'BPWM0_CH5:8', 'X32_OUT:10']},
	{ f: ['PF.5:0', 'UART2_RXD:2', 'UART2_nCTS:4', 'PWM0_CH0:7', 'BPWM0_CH4:8', 'X32_IN:10', 'ADC0_ST:11']},
	{ f: ['PF.6:0', 'EBI_ADR19:2', 'SPI0_MOSI:5', 'UART4_RXD:6', 'EBI_nCS0:7']},
	{ f: ['PF.7:0', 'EBI_ADR18:2', 'SPI0_MISO:5', 'UART4_TXD:6']},
	{ f: ['PF.8:0', 'EBI_ADR17:2', 'SPI0_CLK:5', 'UART5_nCTS:6']},
	{ f: ['PF.9:0', 'EBI_ADR16:2', 'SPI0_SS:5', 'UART5_nRTS:6']},
	{ f: ['PF.10:0', 'EBI_ADR15:2', 'SPI0_I2SMCLK:5', 'UART5_RXD:6']},
	{ f: ['PF.11:0', 'EBI_ADR14:2', 'UART5_TXD:6', 'TM3:13']},
	{ f: ['PF.12:0']},
	{ f: ['PF.13:0']},
	{ f: ['PF.14:0', 'PWM1_BRAKE0:9', 'PWM0_BRAKE0:10', 'PWM0_CH4:12', 'CLKO:13', 'TM3:14', 'INT5:15']},
	{ f: ['PF.15:0', 'PWM0_BRAKE0:11', 'PWM0_CH1:12', 'TM2:13', 'CLKO:14', 'INT4:15']},

	{ f: ['PG.0:0']},
	{ f: ['PG.1:0']},
	{ f: ['PG.2:0', 'EBI_ADR11:2', 'I2C0_SMBAL:4', 'I2C1_SCL:5', 'TM0:13']},
	{ f: ['PG.3:0', 'EBI_ADR12:2', 'I2C0_SMBSUS:4', 'I2C1_SDA:5', 'TM1:13']},
	{ f: ['PG.4:0', 'EBI_ADR13:2', 'TM2:13']},
	{ f: ['PG.5:0']},
	{ f: ['PG.6:0']},
	{ f: ['PG.7:0']},
	{ f: ['PG.8:0']},
	{ f: ['PG.9:0', 'EBI_AD0:2', 'BPWM0_CH5:12']},
	{ f: ['PG.10:0', 'EBI_AD1:2', 'BPWM0_CH4:12']},
	{ f: ['PG.11:0', 'EBI_AD2:2', 'UART7_TXD:6', 'BPWM0_CH3:12']},
	{ f: ['PG.12:0', 'EBI_AD3:2', 'UART7_RXD:6', 'BPWM0_CH2:12']},
	{ f: ['PG.13:0', 'EBI_AD4:2', 'UART6_TXD:6', 'BPWM0_CH1:12']},
	{ f: ['PG.14:0', 'EBI_AD5:2', 'UART6_RXD:6', 'BPWM0_CH0:12']},
	{ f: ['PG.15:0', 'CLKO:14', 'ADC0_ST:15']},

	{ f: ['PH.0:0']},
	{ f: ['PH.1:0']},
	{ f: ['PH.2:0']},
	{ f: ['PH.3:0']},
	{ f: ['PH.4:0', 'EBI_ADR3:2', 'UART7_nRTS:4', 'UART6_TXD:5']},
	{ f: ['PH.5:0', 'EBI_ADR2:2', 'UART7_nCTS:4', 'UART6_RXD:5']},
	{ f: ['PH.6:0', 'EBI_ADR1:2', 'UART7_TXD:4']},
	{ f: ['PH.7:0', 'EBI_ADR0:2', 'UART7_RXD:4']},
	{ f: ['PH.8:0', 'EBI_AD12:2', 'QSPI0_CLK:3', 'UART3_nRTS:7', 'UART1_TXD:10']},
	{ f: ['PH.9:0', 'EBI_AD13:2', 'QSPI0_SS:3', 'UART3_nCTS:7', 'UART1_RXD:10']},
	{ f: ['PH.10:0', 'EBI_AD14:2', 'QSPI0_MISO1:3', 'UART4_TXD:7', 'UART0_TXD:8']},
	{ f: ['PH.11:0', 'EBI_AD15:2', 'QSPI0_MOSI1:3', 'UART4_RXD:7', 'UART0_RXD:8', 'PWM0_CH5:11']},
	{ f: ['PH.12:0']},
	{ f: ['PH.13:0']},
	{ f: ['PH.14:0']},
	{ f: ['PH.15:0']}
];

NUTOOL_PIN.g_cfg_gpiosDefines = [
	{ f: ['PA.0', 'GPIO:SYS_GPA_MFPL_PA0MFP_GPIO@GPA_MFPL', 'QSPI0_MOSI0:SYS_GPA_MFPL_PA0MFP_QSPI0_MOSI0@GPA_MFPL', 'SPI0_MOSI:SYS_GPA_MFPL_PA0MFP_SPI0_MOSI@GPA_MFPL', 'UART0_RXD:SYS_GPA_MFPL_PA0MFP_UART0_RXD@GPA_MFPL', 'UART1_nRTS:SYS_GPA_MFPL_PA0MFP_UART1_nRTS@GPA_MFPL', 'BPWM0_CH0:SYS_GPA_MFPL_PA0MFP_BPWM0_CH0@GPA_MFPL', 'PWM0_CH5:SYS_GPA_MFPL_PA0MFP_PWM0_CH5@GPA_MFPL'] },
	{ f: ['PA.1', 'GPIO:SYS_GPA_MFPL_PA1MFP_GPIO@GPA_MFPL', 'QSPI0_MISO0:SYS_GPA_MFPL_PA1MFP_QSPI0_MISO0@GPA_MFPL', 'SPI0_MISO:SYS_GPA_MFPL_PA1MFP_SPI0_MISO@GPA_MFPL', 'UART0_TXD:SYS_GPA_MFPL_PA1MFP_UART0_TXD@GPA_MFPL', 'UART1_nCTS:SYS_GPA_MFPL_PA1MFP_UART1_nCTS@GPA_MFPL', 'USCI1_CLK:SYS_GPA_MFPL_PA1MFP_USCI1_CLK@GPA_MFPL', 'BPWM0_CH1:SYS_GPA_MFPL_PA1MFP_BPWM0_CH1@GPA_MFPL', 'PWM0_CH4:SYS_GPA_MFPL_PA1MFP_PWM0_CH4@GPA_MFPL'] },
	{ f: ['PA.2', 'GPIO:SYS_GPA_MFPL_PA2MFP_GPIO@GPA_MFPL', 'QSPI0_CLK:SYS_GPA_MFPL_PA2MFP_QSPI0_CLK@GPA_MFPL', 'SPI0_CLK:SYS_GPA_MFPL_PA2MFP_SPI0_CLK@GPA_MFPL', 'UART4_RXD:SYS_GPA_MFPL_PA2MFP_UART4_RXD@GPA_MFPL', 'I2C0_SMBSUS:SYS_GPA_MFPL_PA2MFP_I2C0_SMBSUS@GPA_MFPL', 'UART1_RXD:SYS_GPA_MFPL_PA2MFP_UART1_RXD@GPA_MFPL', 'I2C1_SDA:SYS_GPA_MFPL_PA2MFP_I2C1_SDA@GPA_MFPL', 'USCI1_DAT0:SYS_GPA_MFPL_PA2MFP_USCI1_DAT0@GPA_MFPL', 'BPWM0_CH2:SYS_GPA_MFPL_PA2MFP_BPWM0_CH2@GPA_MFPL', 'PWM0_CH3:SYS_GPA_MFPL_PA2MFP_PWM0_CH3@GPA_MFPL'] },
	{ f: ['PA.3', 'GPIO:SYS_GPA_MFPL_PA3MFP_GPIO@GPA_MFPL', 'QSPI0_SS:SYS_GPA_MFPL_PA3MFP_QSPI0_SS@GPA_MFPL', 'SPI0_SS:SYS_GPA_MFPL_PA3MFP_SPI0_SS@GPA_MFPL', 'UART4_TXD:SYS_GPA_MFPL_PA3MFP_UART4_TXD@GPA_MFPL', 'I2C0_SMBAL:SYS_GPA_MFPL_PA3MFP_I2C0_SMBAL@GPA_MFPL', 'UART1_TXD:SYS_GPA_MFPL_PA3MFP_UART1_TXD@GPA_MFPL', 'I2C1_SCL:SYS_GPA_MFPL_PA3MFP_I2C1_SCL@GPA_MFPL', 'USCI1_DAT1:SYS_GPA_MFPL_PA3MFP_USCI1_DAT1@GPA_MFPL', 'BPWM0_CH3:SYS_GPA_MFPL_PA3MFP_BPWM0_CH3@GPA_MFPL', 'PWM0_CH2:SYS_GPA_MFPL_PA3MFP_PWM0_CH2@GPA_MFPL', 'CLKO:SYS_GPA_MFPL_PA3MFP_CLKO@GPA_MFPL', 'PWM1_BRAKE1:SYS_GPA_MFPL_PA3MFP_PWM1_BRAKE1@GPA_MFPL'] },
	{ f: ['PA.4', 'GPIO:SYS_GPA_MFPL_PA4MFP_GPIO@GPA_MFPL', 'QSPI0_MOSI1:SYS_GPA_MFPL_PA4MFP_QSPI0_MOSI1@GPA_MFPL', 'SPI0_I2SMCLK:SYS_GPA_MFPL_PA4MFP_SPI0_I2SMCLK@GPA_MFPL', 'UART0_nRTS:SYS_GPA_MFPL_PA4MFP_UART0_nRTS@GPA_MFPL', 'UART0_RXD:SYS_GPA_MFPL_PA4MFP_UART0_RXD@GPA_MFPL', 'I2C0_SDA:SYS_GPA_MFPL_PA4MFP_I2C0_SDA@GPA_MFPL', 'UART5_RXD:SYS_GPA_MFPL_PA4MFP_UART5_RXD@GPA_MFPL', 'BPWM0_CH4:SYS_GPA_MFPL_PA4MFP_BPWM0_CH4@GPA_MFPL', 'PWM0_CH1:SYS_GPA_MFPL_PA4MFP_PWM0_CH1@GPA_MFPL'] },
	{ f: ['PA.5', 'GPIO:SYS_GPA_MFPL_PA5MFP_GPIO@GPA_MFPL', 'QSPI0_MISO1:SYS_GPA_MFPL_PA5MFP_QSPI0_MISO1@GPA_MFPL', 'UART0_nCTS:SYS_GPA_MFPL_PA5MFP_UART0_nCTS@GPA_MFPL', 'UART0_TXD:SYS_GPA_MFPL_PA5MFP_UART0_TXD@GPA_MFPL', 'I2C0_SCL:SYS_GPA_MFPL_PA5MFP_I2C0_SCL@GPA_MFPL', 'UART5_TXD:SYS_GPA_MFPL_PA5MFP_UART5_TXD@GPA_MFPL', 'BPWM0_CH5:SYS_GPA_MFPL_PA5MFP_BPWM0_CH5@GPA_MFPL', 'PWM0_CH0:SYS_GPA_MFPL_PA5MFP_PWM0_CH0@GPA_MFPL'] },
	{ f: ['PA.6', 'GPIO:SYS_GPA_MFPL_PA6MFP_GPIO@GPA_MFPL', 'EBI_AD6:SYS_GPA_MFPL_PA6MFP_EBI_AD6@GPA_MFPL', 'UART0_RXD:SYS_GPA_MFPL_PA6MFP_UART0_RXD@GPA_MFPL', 'I2C1_SDA:SYS_GPA_MFPL_PA6MFP_I2C1_SDA@GPA_MFPL', 'PWM1_CH5:SYS_GPA_MFPL_PA6MFP_PWM1_CH5@GPA_MFPL', 'BPWM1_CH3:SYS_GPA_MFPL_PA6MFP_BPWM1_CH3@GPA_MFPL', 'ACMP1_WLAT:SYS_GPA_MFPL_PA6MFP_ACMP1_WLAT@GPA_MFPL', 'TM3:SYS_GPA_MFPL_PA6MFP_TM3@GPA_MFPL', 'INT0:SYS_GPA_MFPL_PA6MFP_INT0@GPA_MFPL'] },
	{ f: ['PA.7', 'GPIO:SYS_GPA_MFPL_PA7MFP_GPIO@GPA_MFPL', 'EBI_AD7:SYS_GPA_MFPL_PA7MFP_EBI_AD7@GPA_MFPL', 'UART0_TXD:SYS_GPA_MFPL_PA7MFP_UART0_TXD@GPA_MFPL', 'I2C1_SCL:SYS_GPA_MFPL_PA7MFP_I2C1_SCL@GPA_MFPL', 'PWM1_CH4:SYS_GPA_MFPL_PA7MFP_PWM1_CH4@GPA_MFPL', 'BPWM1_CH2:SYS_GPA_MFPL_PA7MFP_BPWM1_CH2@GPA_MFPL', 'ACMP0_WLAT:SYS_GPA_MFPL_PA7MFP_ACMP0_WLAT@GPA_MFPL', 'TM2:SYS_GPA_MFPL_PA7MFP_TM2@GPA_MFPL', 'INT1:SYS_GPA_MFPL_PA7MFP_INT1@GPA_MFPL'] },
	{ f: ['PA.8', 'GPIO:SYS_GPA_MFPH_PA8MFP_GPIO@GPA_MFPH', 'EBI_ALE:SYS_GPA_MFPH_PA8MFP_EBI_ALE@GPA_MFPH', 'USCI0_CTL1:SYS_GPA_MFPH_PA8MFP_USCI0_CTL1@GPA_MFPH', 'UART1_RXD:SYS_GPA_MFPH_PA8MFP_UART1_RXD@GPA_MFPH', 'UART7_RXD:SYS_GPA_MFPH_PA8MFP_UART7_RXD@GPA_MFPH', 'BPWM0_CH3:SYS_GPA_MFPH_PA8MFP_BPWM0_CH3@GPA_MFPH', 'TM3_EXT:SYS_GPA_MFPH_PA8MFP_TM3_EXT@GPA_MFPH', 'INT4:SYS_GPA_MFPH_PA8MFP_INT4@GPA_MFPH'] },
	{ f: ['PA.9', 'GPIO:SYS_GPA_MFPH_PA9MFP_GPIO@GPA_MFPH', 'EBI_MCLK:SYS_GPA_MFPH_PA9MFP_EBI_MCLK@GPA_MFPH', 'USCI0_DAT1:SYS_GPA_MFPH_PA9MFP_USCI0_DAT1@GPA_MFPH', 'UART1_TXD:SYS_GPA_MFPH_PA9MFP_UART1_TXD@GPA_MFPH', 'UART7_TXD:SYS_GPA_MFPH_PA9MFP_UART7_TXD@GPA_MFPH', 'BPWM0_CH2:SYS_GPA_MFPH_PA9MFP_BPWM0_CH2@GPA_MFPH', 'TM2_EXT:SYS_GPA_MFPH_PA9MFP_TM2_EXT@GPA_MFPH'] },
	{ f: ['PA.10', 'GPIO:SYS_GPA_MFPH_PA10MFP_GPIO@GPA_MFPH', 'ACMP1_P0:SYS_GPA_MFPH_PA10MFP_ACMP1_P0@GPA_MFPH', 'EBI_nWR:SYS_GPA_MFPH_PA10MFP_EBI_nWR@GPA_MFPH', 'USCI0_DAT0:SYS_GPA_MFPH_PA10MFP_USCI0_DAT0@GPA_MFPH', 'UART6_RXD:SYS_GPA_MFPH_PA10MFP_UART6_RXD@GPA_MFPH', 'BPWM0_CH1:SYS_GPA_MFPH_PA10MFP_BPWM0_CH1@GPA_MFPH', 'TM1_EXT:SYS_GPA_MFPH_PA10MFP_TM1_EXT@GPA_MFPH'] },
	{ f: ['PA.11', 'GPIO:SYS_GPA_MFPH_PA11MFP_GPIO@GPA_MFPH', 'ACMP0_P0:SYS_GPA_MFPH_PA11MFP_ACMP0_P0@GPA_MFPH', 'EBI_nRD:SYS_GPA_MFPH_PA11MFP_EBI_nRD@GPA_MFPH', 'USCI0_CLK:SYS_GPA_MFPH_PA11MFP_USCI0_CLK@GPA_MFPH', 'UART6_TXD:SYS_GPA_MFPH_PA11MFP_UART6_TXD@GPA_MFPH', 'BPWM0_CH0:SYS_GPA_MFPH_PA11MFP_BPWM0_CH0@GPA_MFPH', 'TM0_EXT:SYS_GPA_MFPH_PA11MFP_TM0_EXT@GPA_MFPH'] },
	{ f: ['PA.12', 'GPIO:SYS_GPA_MFPH_PA12MFP_GPIO@GPA_MFPH', 'UART4_TXD:SYS_GPA_MFPH_PA12MFP_UART4_TXD@GPA_MFPH', 'I2C1_SCL:SYS_GPA_MFPH_PA12MFP_I2C1_SCL@GPA_MFPH', 'BPWM1_CH2:SYS_GPA_MFPH_PA12MFP_BPWM1_CH2@GPA_MFPH'] },
	{ f: ['PA.13', 'GPIO:SYS_GPA_MFPH_PA13MFP_GPIO@GPA_MFPH', 'UART4_RXD:SYS_GPA_MFPH_PA13MFP_UART4_RXD@GPA_MFPH', 'I2C1_SDA:SYS_GPA_MFPH_PA13MFP_I2C1_SDA@GPA_MFPH', 'BPWM1_CH3:SYS_GPA_MFPH_PA13MFP_BPWM1_CH3@GPA_MFPH'] },
	{ f: ['PA.14', 'GPIO:SYS_GPA_MFPH_PA14MFP_GPIO@GPA_MFPH', 'UART0_TXD:SYS_GPA_MFPH_PA14MFP_UART0_TXD@GPA_MFPH', 'BPWM1_CH4:SYS_GPA_MFPH_PA14MFP_BPWM1_CH4@GPA_MFPH'] },
	{ f: ['PA.15', 'GPIO:SYS_GPA_MFPH_PA15MFP_GPIO@GPA_MFPH', 'UART0_RXD:SYS_GPA_MFPH_PA15MFP_UART0_RXD@GPA_MFPH', 'BPWM1_CH5:SYS_GPA_MFPH_PA15MFP_BPWM1_CH5@GPA_MFPH'] },

	{ f: ['PB.0', 'GPIO:SYS_GPB_MFPL_PB0MFP_GPIO@GPB_MFPL', 'ADC_CH0:SYS_GPB_MFPL_PB0MFP_ADC_CH0@GPB_MFPL', 'ADC0_CH0:SYS_GPB_MFPL_PB0MFP_ADC0_CH0@GPB_MFPL', 'EBI_ADR9:SYS_GPB_MFPL_PB0MFP_EBI_ADR9@GPB_MFPL', 'UART2_RXD:SYS_GPB_MFPL_PB0MFP_UART2_RXD@GPB_MFPL', 'SPI0_I2SMCLK:SYS_GPB_MFPL_PB0MFP_SPI0_I2SMCLK@GPB_MFPL', 'I2C1_SDA:SYS_GPB_MFPL_PB0MFP_I2C1_SDA@GPB_MFPL', 'QSPI0_MOSI1:SYS_GPB_MFPL_PB0MFP_QSPI0_MOSI1@GPB_MFPL', 'PWM0_CH5:SYS_GPB_MFPL_PB0MFP_PWM0_CH5@GPB_MFPL', 'PWM1_CH5:SYS_GPB_MFPL_PB0MFP_PWM1_CH5@GPB_MFPL', 'PWM0_BRAKE1:SYS_GPB_MFPL_PB0MFP_PWM0_BRAKE1@GPB_MFPL'] },
	{ f: ['PB.1', 'GPIO:SYS_GPB_MFPL_PB1MFP_GPIO@GPB_MFPL', 'ADC_CH1:SYS_GPB_MFPL_PB1MFP_ADC_CH1@GPB_MFPL', 'ADC0_CH1:SYS_GPB_MFPL_PB1MFP_ADC0_CH1@GPB_MFPL', 'EBI_ADR8:SYS_GPB_MFPL_PB1MFP_EBI_ADR8@GPB_MFPL', 'UART2_TXD:SYS_GPB_MFPL_PB1MFP_UART2_TXD@GPB_MFPL', 'USCI1_CLK:SYS_GPB_MFPL_PB1MFP_USCI1_CLK@GPB_MFPL', 'I2C1_SCL:SYS_GPB_MFPL_PB1MFP_I2C1_SCL@GPB_MFPL', 'QSPI0_MISO1:SYS_GPB_MFPL_PB1MFP_QSPI0_MISO1@GPB_MFPL', 'PWM0_CH4:SYS_GPB_MFPL_PB1MFP_PWM0_CH4@GPB_MFPL', 'PWM1_CH4:SYS_GPB_MFPL_PB1MFP_PWM1_CH4@GPB_MFPL', 'PWM0_BRAKE0:SYS_GPB_MFPL_PB1MFP_PWM0_BRAKE0@GPB_MFPL'] },
	{ f: ['PB.2', 'GPIO:SYS_GPB_MFPL_PB2MFP_GPIO@GPB_MFPL', 'ADC_CH2:SYS_GPB_MFPL_PB2MFP_ADC_CH2@GPB_MFPL', 'ADC0_CH2:SYS_GPB_MFPL_PB2MFP_ADC0_CH2@GPB_MFPL', 'ACMP0_P1:SYS_GPB_MFPL_PB2MFP_ACMP0_P1@GPB_MFPL', 'EBI_ADR3:SYS_GPB_MFPL_PB2MFP_EBI_ADR3@GPB_MFPL', 'I2C1_SDA:SYS_GPB_MFPL_PB2MFP_I2C1_SDA@GPB_MFPL', 'UART1_RXD:SYS_GPB_MFPL_PB2MFP_UART1_RXD@GPB_MFPL', 'UART5_nCTS:SYS_GPB_MFPL_PB2MFP_UART5_nCTS@GPB_MFPL', 'USCI1_DAT0:SYS_GPB_MFPL_PB2MFP_USCI1_DAT0@GPB_MFPL', 'PWM0_CH3:SYS_GPB_MFPL_PB2MFP_PWM0_CH3@GPB_MFPL', 'TM3:SYS_GPB_MFPL_PB2MFP_TM3@GPB_MFPL', 'INT3:SYS_GPB_MFPL_PB2MFP_INT3@GPB_MFPL'] },
	{ f: ['PB.3', 'GPIO:SYS_GPB_MFPL_PB3MFP_GPIO@GPB_MFPL', 'ADC_CH3:SYS_GPB_MFPL_PB3MFP_ADC_CH3@GPB_MFPL', 'ADC0_CH3:SYS_GPB_MFPL_PB3MFP_ADC0_CH3@GPB_MFPL', 'ACMP0_N:SYS_GPB_MFPL_PB3MFP_ACMP0_N@GPB_MFPL', 'EBI_ADR2:SYS_GPB_MFPL_PB3MFP_EBI_ADR2@GPB_MFPL', 'I2C1_SCL:SYS_GPB_MFPL_PB3MFP_I2C1_SCL@GPB_MFPL', 'UART1_TXD:SYS_GPB_MFPL_PB3MFP_UART1_TXD@GPB_MFPL', 'UART5_nRTS:SYS_GPB_MFPL_PB3MFP_UART5_nRTS@GPB_MFPL', 'USCI1_DAT1:SYS_GPB_MFPL_PB3MFP_USCI1_DAT1@GPB_MFPL', 'PWM0_CH2:SYS_GPB_MFPL_PB3MFP_PWM0_CH2@GPB_MFPL', 'PWM0_BRAKE0:SYS_GPB_MFPL_PB3MFP_PWM0_BRAKE0@GPB_MFPL', 'TM2:SYS_GPB_MFPL_PB3MFP_TM2@GPB_MFPL', 'INT2:SYS_GPB_MFPL_PB3MFP_INT2@GPB_MFPL'] },
	{ f: ['PB.4', 'GPIO:SYS_GPB_MFPL_PB4MFP_GPIO@GPB_MFPL', 'ADC_CH4:SYS_GPB_MFPL_PB4MFP_ADC_CH4@GPB_MFPL', 'ADC0_CH4:SYS_GPB_MFPL_PB4MFP_ADC0_CH4@GPB_MFPL', 'ACMP1_P1:SYS_GPB_MFPL_PB4MFP_ACMP1_P1@GPB_MFPL', 'EBI_ADR1:SYS_GPB_MFPL_PB4MFP_EBI_ADR1@GPB_MFPL', 'I2C0_SDA:SYS_GPB_MFPL_PB4MFP_I2C0_SDA@GPB_MFPL', 'UART5_RXD:SYS_GPB_MFPL_PB4MFP_UART5_RXD@GPB_MFPL', 'USCI1_CTL1:SYS_GPB_MFPL_PB4MFP_USCI1_CTL1@GPB_MFPL', 'PWM0_CH1:SYS_GPB_MFPL_PB4MFP_PWM0_CH1@GPB_MFPL', 'UART2_RXD:SYS_GPB_MFPL_PB4MFP_UART2_RXD@GPB_MFPL', 'TM1:SYS_GPB_MFPL_PB4MFP_TM1@GPB_MFPL', 'INT1:SYS_GPB_MFPL_PB4MFP_INT1@GPB_MFPL'] },
	{ f: ['PB.5', 'GPIO:SYS_GPB_MFPL_PB5MFP_GPIO@GPB_MFPL', 'ADC_CH5:SYS_GPB_MFPL_PB5MFP_ADC_CH5@GPB_MFPL', 'ADC0_CH5:SYS_GPB_MFPL_PB5MFP_ADC0_CH5@GPB_MFPL', 'ACMP1_N:SYS_GPB_MFPL_PB5MFP_ACMP1_N@GPB_MFPL', 'EBI_ADR0:SYS_GPB_MFPL_PB5MFP_EBI_ADR0@GPB_MFPL', 'I2C0_SCL:SYS_GPB_MFPL_PB5MFP_I2C0_SCL@GPB_MFPL', 'UART5_TXD:SYS_GPB_MFPL_PB5MFP_UART5_TXD@GPB_MFPL', 'USCI1_CTL0:SYS_GPB_MFPL_PB5MFP_USCI1_CTL0@GPB_MFPL', 'PWM0_CH0:SYS_GPB_MFPL_PB5MFP_PWM0_CH0@GPB_MFPL', 'UART2_TXD:SYS_GPB_MFPL_PB5MFP_UART2_TXD@GPB_MFPL', 'TM0:SYS_GPB_MFPL_PB5MFP_TM0@GPB_MFPL', 'INT0:SYS_GPB_MFPL_PB5MFP_INT0@GPB_MFPL'] },
	{ f: ['PB.6', 'GPIO:SYS_GPB_MFPL_PB6MFP_GPIO@GPB_MFPL', 'ADC_CH6:SYS_GPB_MFPL_PB6MFP_ADC_CH6@GPB_MFPL', 'ADC0_CH6:SYS_GPB_MFPL_PB6MFP_ADC0_CH6@GPB_MFPL', 'EBI_nWRH:SYS_GPB_MFPL_PB6MFP_EBI_nWRH@GPB_MFPL', 'USCI1_DAT1:SYS_GPB_MFPL_PB6MFP_USCI1_DAT1@GPB_MFPL', 'UART1_RXD:SYS_GPB_MFPL_PB6MFP_UART1_RXD@GPB_MFPL', 'EBI_nCS1:SYS_GPB_MFPL_PB6MFP_EBI_nCS1@GPB_MFPL', 'BPWM1_CH5:SYS_GPB_MFPL_PB6MFP_BPWM1_CH5@GPB_MFPL', 'PWM1_BRAKE1:SYS_GPB_MFPL_PB6MFP_PWM1_BRAKE1@GPB_MFPL', 'PWM1_CH5:SYS_GPB_MFPL_PB6MFP_PWM1_CH5@GPB_MFPL', 'INT4:SYS_GPB_MFPL_PB6MFP_INT4@GPB_MFPL', 'ACMP1_O:SYS_GPB_MFPL_PB6MFP_ACMP1_O@GPB_MFPL'] },
	{ f: ['PB.7', 'GPIO:SYS_GPB_MFPL_PB7MFP_GPIO@GPB_MFPL', 'ADC_CH7:SYS_GPB_MFPL_PB7MFP_ADC_CH7@GPB_MFPL', 'ADC0_CH7:SYS_GPB_MFPL_PB7MFP_ADC0_CH7@GPB_MFPL', 'EBI_nWRL:SYS_GPB_MFPL_PB7MFP_EBI_nWRL@GPB_MFPL', 'USCI1_DAT0:SYS_GPB_MFPL_PB7MFP_USCI1_DAT0@GPB_MFPL', 'UART1_TXD:SYS_GPB_MFPL_PB7MFP_UART1_TXD@GPB_MFPL', 'EBI_nCS0:SYS_GPB_MFPL_PB7MFP_EBI_nCS0@GPB_MFPL', 'BPWM1_CH4:SYS_GPB_MFPL_PB7MFP_BPWM1_CH4@GPB_MFPL', 'PWM1_BRAKE0:SYS_GPB_MFPL_PB7MFP_PWM1_BRAKE0@GPB_MFPL', 'PWM1_CH4:SYS_GPB_MFPL_PB7MFP_PWM1_CH4@GPB_MFPL', 'INT5:SYS_GPB_MFPL_PB7MFP_INT5@GPB_MFPL', 'ACMP0_O:SYS_GPB_MFPL_PB7MFP_ACMP0_O@GPB_MFPL'] },
	{ f: ['PB.8', 'GPIO:SYS_GPB_MFPH_PB8MFP_GPIO@GPB_MFPH', 'ADC_CH8:SYS_GPB_MFPH_PB8MFP_ADC_CH8@GPB_MFPH', 'ADC0_CH8:SYS_GPB_MFPH_PB8MFP_ADC0_CH8@GPB_MFPH', 'EBI_ADR19:SYS_GPB_MFPH_PB8MFP_EBI_ADR19@GPB_MFPH', 'USCI1_CLK:SYS_GPB_MFPH_PB8MFP_USCI1_CLK@GPB_MFPH', 'UART0_RXD:SYS_GPB_MFPH_PB8MFP_UART0_RXD@GPB_MFPH', 'UART1_nRTS:SYS_GPB_MFPH_PB8MFP_UART1_nRTS@GPB_MFPH', 'UART7_RXD:SYS_GPB_MFPH_PB8MFP_UART7_RXD@GPB_MFPH', 'BPWM1_CH3:SYS_GPB_MFPH_PB8MFP_BPWM1_CH3@GPB_MFPH'] },
	{ f: ['PB.9', 'GPIO:SYS_GPB_MFPH_PB9MFP_GPIO@GPB_MFPH', 'ADC_CH9:SYS_GPB_MFPH_PB9MFP_ADC_CH9@GPB_MFPH', 'ADC0_CH9:SYS_GPB_MFPH_PB9MFP_ADC0_CH9@GPB_MFPH', 'EBI_ADR18:SYS_GPB_MFPH_PB9MFP_EBI_ADR18@GPB_MFPH', 'USCI1_CTL1:SYS_GPB_MFPH_PB9MFP_USCI1_CTL1@GPB_MFPH', 'UART0_TXD:SYS_GPB_MFPH_PB9MFP_UART0_TXD@GPB_MFPH', 'UART1_nCTS:SYS_GPB_MFPH_PB9MFP_UART1_nCTS@GPB_MFPH', 'UART7_TXD:SYS_GPB_MFPH_PB9MFP_UART7_TXD@GPB_MFPH', 'BPWM1_CH2:SYS_GPB_MFPH_PB9MFP_BPWM1_CH2@GPB_MFPH'] },
	{ f: ['PB.10', 'GPIO:SYS_GPB_MFPH_PB10MFP_GPIO@GPB_MFPH', 'ADC_CH10:SYS_GPB_MFPH_PB10MFP_ADC_CH10@GPB_MFPH', 'ADC0_CH10:SYS_GPB_MFPH_PB10MFP_ADC0_CH10@GPB_MFPH', 'EBI_ADR17:SYS_GPB_MFPH_PB10MFP_EBI_ADR17@GPB_MFPH', 'USCI1_CTL0:SYS_GPB_MFPH_PB10MFP_USCI1_CTL0@GPB_MFPH', 'UART0_nRTS:SYS_GPB_MFPH_PB10MFP_UART0_nRTS@GPB_MFPH', 'UART4_RXD:SYS_GPB_MFPH_PB10MFP_UART4_RXD@GPB_MFPH', 'I2C1_SDA:SYS_GPB_MFPH_PB10MFP_I2C1_SDA@GPB_MFPH', 'BPWM1_CH1:SYS_GPB_MFPH_PB10MFP_BPWM1_CH1@GPB_MFPH'] },
	{ f: ['PB.11', 'GPIO:SYS_GPB_MFPH_PB11MFP_GPIO@GPB_MFPH', 'ADC_CH11:SYS_GPB_MFPH_PB11MFP_ADC_CH11@GPB_MFPH', 'ADC0_CH11:SYS_GPB_MFPH_PB11MFP_ADC0_CH11@GPB_MFPH', 'EBI_ADR16:SYS_GPB_MFPH_PB11MFP_EBI_ADR16@GPB_MFPH', 'UART0_nCTS:SYS_GPB_MFPH_PB11MFP_UART0_nCTS@GPB_MFPH', 'UART4_TXD:SYS_GPB_MFPH_PB11MFP_UART4_TXD@GPB_MFPH', 'I2C1_SCL:SYS_GPB_MFPH_PB11MFP_I2C1_SCL@GPB_MFPH', 'SPI0_I2SMCLK:SYS_GPB_MFPH_PB11MFP_SPI0_I2SMCLK@GPB_MFPH', 'BPWM1_CH0:SYS_GPB_MFPH_PB11MFP_BPWM1_CH0@GPB_MFPH'] },
	{ f: ['PB.12', 'GPIO:SYS_GPB_MFPH_PB12MFP_GPIO@GPB_MFPH', 'ADC_CH12:SYS_GPB_MFPH_PB12MFP_ADC_CH12@GPB_MFPH', 'ADC0_CH12:SYS_GPB_MFPH_PB12MFP_ADC0_CH12@GPB_MFPH', 'ACMP0_P2:SYS_GPB_MFPH_PB12MFP_ACMP0_P2@GPB_MFPH', 'ACMP1_P2:SYS_GPB_MFPH_PB12MFP_ACMP1_P2@GPB_MFPH', 'EBI_AD15:SYS_GPB_MFPH_PB12MFP_EBI_AD15@GPB_MFPH', 'SPI0_MOSI:SYS_GPB_MFPH_PB12MFP_SPI0_MOSI@GPB_MFPH', 'USCI0_CLK:SYS_GPB_MFPH_PB12MFP_USCI0_CLK@GPB_MFPH', 'UART0_RXD:SYS_GPB_MFPH_PB12MFP_UART0_RXD@GPB_MFPH', 'UART3_nCTS:SYS_GPB_MFPH_PB12MFP_UART3_nCTS@GPB_MFPH', 'PWM1_CH3:SYS_GPB_MFPH_PB12MFP_PWM1_CH3@GPB_MFPH', 'BPWM0_CH0:SYS_GPB_MFPH_PB12MFP_BPWM0_CH0@GPB_MFPH', 'TM3_EXT:SYS_GPB_MFPH_PB12MFP_TM3_EXT@GPB_MFPH'] },
	{ f: ['PB.13', 'GPIO:SYS_GPB_MFPH_PB13MFP_GPIO@GPB_MFPH', 'ADC_CH13:SYS_GPB_MFPH_PB13MFP_ADC_CH13@GPB_MFPH', 'ADC0_CH13:SYS_GPB_MFPH_PB13MFP_ADC0_CH13@GPB_MFPH', 'ACMP0_P3:SYS_GPB_MFPH_PB13MFP_ACMP0_P3@GPB_MFPH', 'ACMP1_P3:SYS_GPB_MFPH_PB13MFP_ACMP1_P3@GPB_MFPH', 'EBI_AD14:SYS_GPB_MFPH_PB13MFP_EBI_AD14@GPB_MFPH', 'SPI0_MISO:SYS_GPB_MFPH_PB13MFP_SPI0_MISO@GPB_MFPH', 'USCI0_DAT0:SYS_GPB_MFPH_PB13MFP_USCI0_DAT0@GPB_MFPH', 'UART0_TXD:SYS_GPB_MFPH_PB13MFP_UART0_TXD@GPB_MFPH', 'UART3_nRTS:SYS_GPB_MFPH_PB13MFP_UART3_nRTS@GPB_MFPH', 'PWM1_CH2:SYS_GPB_MFPH_PB13MFP_PWM1_CH2@GPB_MFPH', 'BPWM0_CH1:SYS_GPB_MFPH_PB13MFP_BPWM0_CH1@GPB_MFPH', 'TM2_EXT:SYS_GPB_MFPH_PB13MFP_TM2_EXT@GPB_MFPH'] },
	{ f: ['PB.14', 'GPIO:SYS_GPB_MFPH_PB14MFP_GPIO@GPB_MFPH', 'ADC_CH14:SYS_GPB_MFPH_PB14MFP_ADC_CH14@GPB_MFPH', 'ADC0_CH14:SYS_GPB_MFPH_PB14MFP_ADC0_CH14@GPB_MFPH', 'EBI_AD13:SYS_GPB_MFPH_PB14MFP_EBI_AD13@GPB_MFPH', 'SPI0_CLK:SYS_GPB_MFPH_PB14MFP_SPI0_CLK@GPB_MFPH', 'USCI0_DAT1:SYS_GPB_MFPH_PB14MFP_USCI0_DAT1@GPB_MFPH', 'UART0_nRTS:SYS_GPB_MFPH_PB14MFP_UART0_nRTS@GPB_MFPH', 'UART3_RXD:SYS_GPB_MFPH_PB14MFP_UART3_RXD@GPB_MFPH', 'BPWM1_CH5:SYS_GPB_MFPH_PB14MFP_BPWM1_CH5@GPB_MFPH', 'PWM1_CH1:SYS_GPB_MFPH_PB14MFP_PWM1_CH1@GPB_MFPH', 'BPWM0_CH2:SYS_GPB_MFPH_PB14MFP_BPWM0_CH2@GPB_MFPH', 'TM1_EXT:SYS_GPB_MFPH_PB14MFP_TM1_EXT@GPB_MFPH', 'CLKO:SYS_GPB_MFPH_PB14MFP_CLKO@GPB_MFPH'] },
	{ f: ['PB.15', 'GPIO:SYS_GPB_MFPH_PB15MFP_GPIO@GPB_MFPH', 'ADC_CH15:SYS_GPB_MFPH_PB15MFP_ADC_CH15@GPB_MFPH', 'ADC0_CH15:SYS_GPB_MFPH_PB15MFP_ADC0_CH15@GPB_MFPH', 'EBI_AD12:SYS_GPB_MFPH_PB15MFP_EBI_AD12@GPB_MFPH', 'SPI0_SS:SYS_GPB_MFPH_PB15MFP_SPI0_SS@GPB_MFPH', 'USCI0_CTL1:SYS_GPB_MFPH_PB15MFP_USCI0_CTL1@GPB_MFPH', 'UART0_nCTS:SYS_GPB_MFPH_PB15MFP_UART0_nCTS@GPB_MFPH', 'UART3_TXD:SYS_GPB_MFPH_PB15MFP_UART3_TXD@GPB_MFPH', 'BPWM1_CH4:SYS_GPB_MFPH_PB15MFP_BPWM1_CH4@GPB_MFPH', 'PWM1_CH0:SYS_GPB_MFPH_PB15MFP_PWM1_CH0@GPB_MFPH', 'BPWM0_CH3:SYS_GPB_MFPH_PB15MFP_BPWM0_CH3@GPB_MFPH', 'TM0_EXT:SYS_GPB_MFPH_PB15MFP_TM0_EXT@GPB_MFPH', 'PWM0_BRAKE1:SYS_GPB_MFPH_PB15MFP_PWM0_BRAKE1@GPB_MFPH'] },

	{ f: ['PC.0', 'GPIO:SYS_GPC_MFPL_PC0MFP_GPIO@GPC_MFPL', 'EBI_AD0:SYS_GPC_MFPL_PC0MFP_EBI_AD0@GPC_MFPL', 'QSPI0_MOSI0:SYS_GPC_MFPL_PC0MFP_QSPI0_MOSI0@GPC_MFPL', 'UART2_RXD:SYS_GPC_MFPL_PC0MFP_UART2_RXD@GPC_MFPL', 'I2C0_SDA:SYS_GPC_MFPL_PC0MFP_I2C0_SDA@GPC_MFPL', 'BPWM1_CH3:SYS_GPC_MFPL_PC0MFP_BPWM1_CH3@GPC_MFPL', 'PWM1_CH5:SYS_GPC_MFPL_PC0MFP_PWM1_CH5@GPC_MFPL', 'BPWM0_CH4:SYS_GPC_MFPL_PC0MFP_BPWM0_CH4@GPC_MFPL', 'ACMP1_O:SYS_GPC_MFPL_PC0MFP_ACMP1_O@GPC_MFPL'] },
	{ f: ['PC.1', 'GPIO:SYS_GPC_MFPL_PC1MFP_GPIO@GPC_MFPL', 'EBI_AD1:SYS_GPC_MFPL_PC1MFP_EBI_AD1@GPC_MFPL', 'QSPI0_MISO0:SYS_GPC_MFPL_PC1MFP_QSPI0_MISO0@GPC_MFPL', 'UART2_TXD:SYS_GPC_MFPL_PC1MFP_UART2_TXD@GPC_MFPL', 'I2C0_SCL:SYS_GPC_MFPL_PC1MFP_I2C0_SCL@GPC_MFPL', 'BPWM1_CH2:SYS_GPC_MFPL_PC1MFP_BPWM1_CH2@GPC_MFPL', 'PWM1_CH4:SYS_GPC_MFPL_PC1MFP_PWM1_CH4@GPC_MFPL', 'BPWM0_CH5:SYS_GPC_MFPL_PC1MFP_BPWM0_CH5@GPC_MFPL', 'ACMP0_O:SYS_GPC_MFPL_PC1MFP_ACMP0_O@GPC_MFPL', 'ADC_ST:SYS_GPC_MFPL_PC1MFP_ADC_ST@GPC_MFPL', 'ADC0_ST:SYS_GPC_MFPL_PC1MFP_ADC0_ST@GPC_MFPL'] },
	{ f: ['PC.2', 'GPIO:SYS_GPC_MFPL_PC2MFP_GPIO@GPC_MFPL', 'EBI_AD2:SYS_GPC_MFPL_PC2MFP_EBI_AD2@GPC_MFPL', 'QSPI0_CLK:SYS_GPC_MFPL_PC2MFP_QSPI0_CLK@GPC_MFPL', 'UART2_nCTS:SYS_GPC_MFPL_PC2MFP_UART2_nCTS@GPC_MFPL', 'I2C0_SMBSUS:SYS_GPC_MFPL_PC2MFP_I2C0_SMBSUS@GPC_MFPL', 'UART3_RXD:SYS_GPC_MFPL_PC2MFP_UART3_RXD@GPC_MFPL', 'PWM1_CH3:SYS_GPC_MFPL_PC2MFP_PWM1_CH3@GPC_MFPL'] },
	{ f: ['PC.3', 'GPIO:SYS_GPC_MFPL_PC3MFP_GPIO@GPC_MFPL', 'EBI_AD3:SYS_GPC_MFPL_PC3MFP_EBI_AD3@GPC_MFPL', 'QSPI0_SS:SYS_GPC_MFPL_PC3MFP_QSPI0_SS@GPC_MFPL', 'UART2_nRTS:SYS_GPC_MFPL_PC3MFP_UART2_nRTS@GPC_MFPL', 'I2C0_SMBAL:SYS_GPC_MFPL_PC3MFP_I2C0_SMBAL@GPC_MFPL', 'UART3_TXD:SYS_GPC_MFPL_PC3MFP_UART3_TXD@GPC_MFPL', 'PWM1_CH2:SYS_GPC_MFPL_PC3MFP_PWM1_CH2@GPC_MFPL'] },
	{ f: ['PC.4', 'GPIO:SYS_GPC_MFPL_PC4MFP_GPIO@GPC_MFPL', 'EBI_AD4:SYS_GPC_MFPL_PC4MFP_EBI_AD4@GPC_MFPL', 'QSPI0_MOSI1:SYS_GPC_MFPL_PC4MFP_QSPI0_MOSI1@GPC_MFPL', 'UART2_RXD:SYS_GPC_MFPL_PC4MFP_UART2_RXD@GPC_MFPL', 'I2C1_SDA:SYS_GPC_MFPL_PC4MFP_I2C1_SDA@GPC_MFPL', 'UART4_RXD:SYS_GPC_MFPL_PC4MFP_UART4_RXD@GPC_MFPL', 'PWM1_CH1:SYS_GPC_MFPL_PC4MFP_PWM1_CH1@GPC_MFPL'] },
	{ f: ['PC.5', 'GPIO:SYS_GPC_MFPL_PC5MFP_GPIO@GPC_MFPL', 'EBI_AD5:SYS_GPC_MFPL_PC5MFP_EBI_AD5@GPC_MFPL', 'QSPI0_MISO1:SYS_GPC_MFPL_PC5MFP_QSPI0_MISO1@GPC_MFPL', 'UART2_TXD:SYS_GPC_MFPL_PC5MFP_UART2_TXD@GPC_MFPL', 'I2C1_SCL:SYS_GPC_MFPL_PC5MFP_I2C1_SCL@GPC_MFPL', 'UART4_TXD:SYS_GPC_MFPL_PC5MFP_UART4_TXD@GPC_MFPL', 'PWM1_CH0:SYS_GPC_MFPL_PC5MFP_PWM1_CH0@GPC_MFPL'] },
	{ f: ['PC.6', 'GPIO:SYS_GPC_MFPL_PC6MFP_GPIO@GPC_MFPL', 'EBI_AD8:SYS_GPC_MFPL_PC6MFP_EBI_AD8@GPC_MFPL', 'UART4_RXD:SYS_GPC_MFPL_PC6MFP_UART4_RXD@GPC_MFPL', 'UART0_nRTS:SYS_GPC_MFPL_PC6MFP_UART0_nRTS@GPC_MFPL', 'UART6_RXD:SYS_GPC_MFPL_PC6MFP_UART6_RXD@GPC_MFPL', 'PWM1_CH3:SYS_GPC_MFPL_PC6MFP_PWM1_CH3@GPC_MFPL', 'BPWM1_CH1:SYS_GPC_MFPL_PC6MFP_BPWM1_CH1@GPC_MFPL', 'TM1:SYS_GPC_MFPL_PC6MFP_TM1@GPC_MFPL', 'INT2:SYS_GPC_MFPL_PC6MFP_INT2@GPC_MFPL'] },
	{ f: ['PC.7', 'GPIO:SYS_GPC_MFPL_PC7MFP_GPIO@GPC_MFPL', 'EBI_AD9:SYS_GPC_MFPL_PC7MFP_EBI_AD9@GPC_MFPL', 'UART4_TXD:SYS_GPC_MFPL_PC7MFP_UART4_TXD@GPC_MFPL', 'UART0_nCTS:SYS_GPC_MFPL_PC7MFP_UART0_nCTS@GPC_MFPL', 'UART6_TXD:SYS_GPC_MFPL_PC7MFP_UART6_TXD@GPC_MFPL', 'PWM1_CH2:SYS_GPC_MFPL_PC7MFP_PWM1_CH2@GPC_MFPL', 'BPWM1_CH0:SYS_GPC_MFPL_PC7MFP_BPWM1_CH0@GPC_MFPL', 'TM0:SYS_GPC_MFPL_PC7MFP_TM0@GPC_MFPL', 'INT3:SYS_GPC_MFPL_PC7MFP_INT3@GPC_MFPL'] },
	{ f: ['PC.8', 'GPIO:SYS_GPC_MFPH_PC8MFP_GPIO@GPC_MFPH', 'EBI_ADR16:SYS_GPC_MFPH_PC8MFP_EBI_ADR16@GPC_MFPH', 'I2C0_SDA:SYS_GPC_MFPH_PC8MFP_I2C0_SDA@GPC_MFPH', 'UART4_nCTS:SYS_GPC_MFPH_PC8MFP_UART4_nCTS@GPC_MFPH', 'UART1_RXD:SYS_GPC_MFPH_PC8MFP_UART1_RXD@GPC_MFPH', 'PWM1_CH1:SYS_GPC_MFPH_PC8MFP_PWM1_CH1@GPC_MFPH', 'BPWM1_CH4:SYS_GPC_MFPH_PC8MFP_BPWM1_CH4@GPC_MFPH'] },
	{ f: ['PC.9', 'GPIO:SYS_GPC_MFPH_PC9MFP_GPIO@GPC_MFPH', 'EBI_ADR7:SYS_GPC_MFPH_PC9MFP_EBI_ADR7@GPC_MFPH', 'UART6_nCTS:SYS_GPC_MFPH_PC9MFP_UART6_nCTS@GPC_MFPH', 'UART3_RXD:SYS_GPC_MFPH_PC9MFP_UART3_RXD@GPC_MFPH', 'PWM1_CH3:SYS_GPC_MFPH_PC9MFP_PWM1_CH3@GPC_MFPH'] },
	{ f: ['PC.10', 'GPIO:SYS_GPC_MFPH_PC10MFP_GPIO@GPC_MFPH', 'EBI_ADR6:SYS_GPC_MFPH_PC10MFP_EBI_ADR6@GPC_MFPH', 'UART6_nRTS:SYS_GPC_MFPH_PC10MFP_UART6_nRTS@GPC_MFPH', 'UART3_TXD:SYS_GPC_MFPH_PC10MFP_UART3_TXD@GPC_MFPH', 'PWM1_CH2:SYS_GPC_MFPH_PC10MFP_PWM1_CH2@GPC_MFPH'] },
	{ f: ['PC.11', 'GPIO:SYS_GPC_MFPH_PC11MFP_GPIO@GPC_MFPH', 'EBI_ADR5:SYS_GPC_MFPH_PC11MFP_EBI_ADR5@GPC_MFPH', 'UART0_RXD:SYS_GPC_MFPH_PC11MFP_UART0_RXD@GPC_MFPH', 'I2C0_SDA:SYS_GPC_MFPH_PC11MFP_I2C0_SDA@GPC_MFPH', 'UART6_RXD:SYS_GPC_MFPH_PC11MFP_UART6_RXD@GPC_MFPH', 'PWM1_CH1:SYS_GPC_MFPH_PC11MFP_PWM1_CH1@GPC_MFPH', 'ACMP1_O:SYS_GPC_MFPH_PC11MFP_ACMP1_O@GPC_MFPH'] },
	{ f: ['PC.12', 'GPIO:SYS_GPC_MFPH_PC12MFP_GPIO@GPC_MFPH', 'EBI_ADR4:SYS_GPC_MFPH_PC12MFP_EBI_ADR4@GPC_MFPH', 'UART0_TXD:SYS_GPC_MFPH_PC12MFP_UART0_TXD@GPC_MFPH', 'I2C0_SCL:SYS_GPC_MFPH_PC12MFP_I2C0_SCL@GPC_MFPH', 'UART6_TXD:SYS_GPC_MFPH_PC12MFP_UART6_TXD@GPC_MFPH', 'PWM1_CH0:SYS_GPC_MFPH_PC12MFP_PWM1_CH0@GPC_MFPH', 'ACMP0_O:SYS_GPC_MFPH_PC12MFP_ACMP0_O@GPC_MFPH'] },
	{ f: ['PC.13', 'GPIO:SYS_GPC_MFPH_PC13MFP_GPIO@GPC_MFPH', 'EBI_ADR10:SYS_GPC_MFPH_PC13MFP_EBI_ADR10@GPC_MFPH', 'USCI0_CTL0:SYS_GPC_MFPH_PC13MFP_USCI0_CTL0@GPC_MFPH', 'UART2_TXD:SYS_GPC_MFPH_PC13MFP_UART2_TXD@GPC_MFPH', 'BPWM0_CH4:SYS_GPC_MFPH_PC13MFP_BPWM0_CH4@GPC_MFPH', 'CLKO:SYS_GPC_MFPH_PC13MFP_CLKO@GPC_MFPH', 'ADC_ST:SYS_GPC_MFPH_PC13MFP_ADC_ST@GPC_MFPH', 'ADC0_ST:SYS_GPC_MFPH_PC13MFP_ADC0_ST@GPC_MFPH'] },
	{ f: ['PC.14', 'GPIO:SYS_GPC_MFPH_PC14MFP_GPIO@GPC_MFPH', 'EBI_AD11:SYS_GPC_MFPH_PC14MFP_EBI_AD11@GPC_MFPH', 'SPI0_I2SMCLK:SYS_GPC_MFPH_PC14MFP_SPI0_I2SMCLK@GPC_MFPH', 'USCI0_CTL0:SYS_GPC_MFPH_PC14MFP_USCI0_CTL0@GPC_MFPH', 'QSPI0_CLK:SYS_GPC_MFPH_PC14MFP_QSPI0_CLK@GPC_MFPH', 'TM1:SYS_GPC_MFPH_PC14MFP_TM1@GPC_MFPH'] },
	{ f: ['PC.15', 'GPIO:SYS_GPC_MFPH_PC15MFP_GPIO@GPC_MFPH'] },

	{ f: ['PD.0', 'GPIO:SYS_GPD_MFPL_PD0MFP_GPIO@GPD_MFPL', 'EBI_AD13:SYS_GPD_MFPL_PD0MFP_EBI_AD13@GPD_MFPL', 'USCI0_CLK:SYS_GPD_MFPL_PD0MFP_USCI0_CLK@GPD_MFPL', 'SPI0_MOSI:SYS_GPD_MFPL_PD0MFP_SPI0_MOSI@GPD_MFPL', 'UART3_RXD:SYS_GPD_MFPL_PD0MFP_UART3_RXD@GPD_MFPL', 'TM2:SYS_GPD_MFPL_PD0MFP_TM2@GPD_MFPL'] },
	{ f: ['PD.1', 'GPIO:SYS_GPD_MFPL_PD1MFP_GPIO@GPD_MFPL', 'EBI_AD12:SYS_GPD_MFPL_PD1MFP_EBI_AD12@GPD_MFPL', 'USCI0_DAT0:SYS_GPD_MFPL_PD1MFP_USCI0_DAT0@GPD_MFPL', 'SPI0_MISO:SYS_GPD_MFPL_PD1MFP_SPI0_MISO@GPD_MFPL', 'UART3_TXD:SYS_GPD_MFPL_PD1MFP_UART3_TXD@GPD_MFPL'] },
	{ f: ['PD.2', 'GPIO:SYS_GPD_MFPL_PD2MFP_GPIO@GPD_MFPL', 'EBI_AD11:SYS_GPD_MFPL_PD2MFP_EBI_AD11@GPD_MFPL', 'USCI0_DAT1:SYS_GPD_MFPL_PD2MFP_USCI0_DAT1@GPD_MFPL', 'SPI0_CLK:SYS_GPD_MFPL_PD2MFP_SPI0_CLK@GPD_MFPL', 'UART3_nCTS:SYS_GPD_MFPL_PD2MFP_UART3_nCTS@GPD_MFPL', 'UART0_RXD:SYS_GPD_MFPL_PD2MFP_UART0_RXD@GPD_MFPL'] },
	{ f: ['PD.3', 'GPIO:SYS_GPD_MFPL_PD3MFP_GPIO@GPD_MFPL', 'EBI_AD10:SYS_GPD_MFPL_PD3MFP_EBI_AD10@GPD_MFPL', 'USCI0_CTL1:SYS_GPD_MFPL_PD3MFP_USCI0_CTL1@GPD_MFPL', 'SPI0_SS:SYS_GPD_MFPL_PD3MFP_SPI0_SS@GPD_MFPL', 'UART3_nRTS:SYS_GPD_MFPL_PD3MFP_UART3_nRTS@GPD_MFPL', 'USCI1_CTL0:SYS_GPD_MFPL_PD3MFP_USCI1_CTL0@GPD_MFPL', 'UART0_TXD:SYS_GPD_MFPL_PD3MFP_UART0_TXD@GPD_MFPL'] },
	{ f: ['PD.4', 'GPIO:SYS_GPD_MFPL_PD4MFP_GPIO@GPD_MFPL', 'USCI0_CTL0:SYS_GPD_MFPL_PD4MFP_USCI0_CTL0@GPD_MFPL', 'I2C1_SDA:SYS_GPD_MFPL_PD4MFP_I2C1_SDA@GPD_MFPL', 'USCI1_CTL1:SYS_GPD_MFPL_PD4MFP_USCI1_CTL1@GPD_MFPL'] },
	{ f: ['PD.5', 'GPIO:SYS_GPD_MFPL_PD5MFP_GPIO@GPD_MFPL', 'I2C1_SCL:SYS_GPD_MFPL_PD5MFP_I2C1_SCL@GPD_MFPL', 'USCI1_DAT0:SYS_GPD_MFPL_PD5MFP_USCI1_DAT0@GPD_MFPL'] },
	{ f: ['PD.6', 'GPIO:SYS_GPD_MFPL_PD6MFP_GPIO@GPD_MFPL', 'UART1_RXD:SYS_GPD_MFPL_PD6MFP_UART1_RXD@GPD_MFPL', 'I2C0_SDA:SYS_GPD_MFPL_PD6MFP_I2C0_SDA@GPD_MFPL', 'USCI1_DAT1:SYS_GPD_MFPL_PD6MFP_USCI1_DAT1@GPD_MFPL'] },
	{ f: ['PD.7', 'GPIO:SYS_GPD_MFPL_PD7MFP_GPIO@GPD_MFPL', 'UART1_TXD:SYS_GPD_MFPL_PD7MFP_UART1_TXD@GPD_MFPL', 'I2C0_SCL:SYS_GPD_MFPL_PD7MFP_I2C0_SCL@GPD_MFPL', 'USCI1_CLK:SYS_GPD_MFPL_PD7MFP_USCI1_CLK@GPD_MFPL'] },
	{ f: ['PD.8', 'GPIO:SYS_GPD_MFPH_PD8MFP_GPIO@GPD_MFPH', 'EBI_AD6:SYS_GPD_MFPH_PD8MFP_EBI_AD6@GPD_MFPH', 'UART2_nRTS:SYS_GPD_MFPH_PD8MFP_UART2_nRTS@GPD_MFPH', 'UART7_RXD:SYS_GPD_MFPH_PD8MFP_UART7_RXD@GPD_MFPH'] },
	{ f: ['PD.9', 'GPIO:SYS_GPD_MFPH_PD9MFP_GPIO@GPD_MFPH', 'EBI_AD7:SYS_GPD_MFPH_PD9MFP_EBI_AD7@GPD_MFPH', 'UART2_nCTS:SYS_GPD_MFPH_PD9MFP_UART2_nCTS@GPD_MFPH', 'UART7_TXD:SYS_GPD_MFPH_PD9MFP_UART7_TXD@GPD_MFPH'] },
	{ f: ['PD.10', 'GPIO:SYS_GPD_MFPH_PD10MFP_GPIO@GPD_MFPH', 'EBI_nCS2:SYS_GPD_MFPH_PD10MFP_EBI_nCS2@GPD_MFPH', 'UART1_RXD:SYS_GPD_MFPH_PD10MFP_UART1_RXD@GPD_MFPH'] },
	{ f: ['PD.11', 'GPIO:SYS_GPD_MFPH_PD11MFP_GPIO@GPD_MFPH', 'EBI_nCS1:SYS_GPD_MFPH_PD11MFP_EBI_nCS1@GPD_MFPH', 'UART1_TXD:SYS_GPD_MFPH_PD11MFP_UART1_TXD@GPD_MFPH'] },
	{ f: ['PD.12', 'GPIO:SYS_GPD_MFPH_PD12MFP_GPIO@GPD_MFPH', 'EBI_nCS0:SYS_GPD_MFPH_PD12MFP_EBI_nCS0@GPD_MFPH', 'UART2_RXD:SYS_GPD_MFPH_PD12MFP_UART2_RXD@GPD_MFPH', 'BPWM0_CH5:SYS_GPD_MFPH_PD12MFP_BPWM0_CH5@GPD_MFPH', 'CLKO:SYS_GPD_MFPH_PD12MFP_CLKO@GPD_MFPH', 'ADC_ST:SYS_GPD_MFPH_PD12MFP_ADC_ST@GPD_MFPH', 'ADC0_ST:SYS_GPD_MFPH_PD12MFP_ADC0_ST@GPD_MFPH', 'INT5:SYS_GPD_MFPH_PD12MFP_INT5@GPD_MFPH'] },
	{ f: ['PD.13', 'GPIO:SYS_GPD_MFPH_PD13MFP_GPIO@GPD_MFPH', 'EBI_AD10:SYS_GPD_MFPH_PD13MFP_EBI_AD10@GPD_MFPH', 'SPI0_I2SMCLK:SYS_GPD_MFPH_PD13MFP_SPI0_I2SMCLK@GPD_MFPH'] },
	{ f: ['PD.14', 'GPIO:SYS_GPD_MFPH_PD14MFP_GPIO@GPD_MFPH', 'EBI_nCS0:SYS_GPD_MFPH_PD14MFP_EBI_nCS0@GPD_MFPH', 'SPI0_I2SMCLK:SYS_GPD_MFPH_PD14MFP_SPI0_I2SMCLK@GPD_MFPH', 'USCI0_CTL0:SYS_GPD_MFPH_PD14MFP_USCI0_CTL0@GPD_MFPH', 'PWM0_CH4:SYS_GPD_MFPH_PD14MFP_PWM0_CH4@GPD_MFPH'] },
	{ f: ['PD.15', 'GPIO:SYS_GPD_MFPH_PD15MFP_GPIO@GPD_MFPH', 'PWM0_CH5:SYS_GPD_MFPH_PD15MFP_PWM0_CH5@GPD_MFPH', 'TM3:SYS_GPD_MFPH_PD15MFP_TM3@GPD_MFPH', 'INT1:SYS_GPD_MFPH_PD15MFP_INT1@GPD_MFPH'] },

	{ f: ['PE.0', 'GPIO:SYS_GPE_MFPL_PE0MFP_GPIO@GPE_MFPL', 'EBI_AD11:SYS_GPE_MFPL_PE0MFP_EBI_AD11@GPE_MFPL', 'QSPI0_MOSI0:SYS_GPE_MFPL_PE0MFP_QSPI0_MOSI0@GPE_MFPL', 'UART3_RXD:SYS_GPE_MFPL_PE0MFP_UART3_RXD@GPE_MFPL', 'I2C1_SDA:SYS_GPE_MFPL_PE0MFP_I2C1_SDA@GPE_MFPL', 'UART4_nRTS:SYS_GPE_MFPL_PE0MFP_UART4_nRTS@GPE_MFPL'] },
	{ f: ['PE.1', 'GPIO:SYS_GPE_MFPL_PE1MFP_GPIO@GPE_MFPL', 'EBI_AD10:SYS_GPE_MFPL_PE1MFP_EBI_AD10@GPE_MFPL', 'QSPI0_MISO0:SYS_GPE_MFPL_PE1MFP_QSPI0_MISO0@GPE_MFPL', 'UART3_TXD:SYS_GPE_MFPL_PE1MFP_UART3_TXD@GPE_MFPL', 'I2C1_SCL:SYS_GPE_MFPL_PE1MFP_I2C1_SCL@GPE_MFPL', 'UART4_nCTS:SYS_GPE_MFPL_PE1MFP_UART4_nCTS@GPE_MFPL'] },
	{ f: ['PE.2', 'GPIO:SYS_GPE_MFPL_PE2MFP_GPIO@GPE_MFPL', 'EBI_ALE:SYS_GPE_MFPL_PE2MFP_EBI_ALE@GPE_MFPL', 'USCI0_CLK:SYS_GPE_MFPL_PE2MFP_USCI0_CLK@GPE_MFPL', 'UART6_nCTS:SYS_GPE_MFPL_PE2MFP_UART6_nCTS@GPE_MFPL', 'UART7_RXD:SYS_GPE_MFPL_PE2MFP_UART7_RXD@GPE_MFPL', 'PWM0_CH5:SYS_GPE_MFPL_PE2MFP_PWM0_CH5@GPE_MFPL', 'BPWM0_CH0:SYS_GPE_MFPL_PE2MFP_BPWM0_CH0@GPE_MFPL'] },
	{ f: ['PE.3', 'GPIO:SYS_GPE_MFPL_PE3MFP_GPIO@GPE_MFPL', 'EBI_MCLK:SYS_GPE_MFPL_PE3MFP_EBI_MCLK@GPE_MFPL', 'USCI0_DAT0:SYS_GPE_MFPL_PE3MFP_USCI0_DAT0@GPE_MFPL', 'UART6_nRTS:SYS_GPE_MFPL_PE3MFP_UART6_nRTS@GPE_MFPL', 'UART7_TXD:SYS_GPE_MFPL_PE3MFP_UART7_TXD@GPE_MFPL', 'PWM0_CH4:SYS_GPE_MFPL_PE3MFP_PWM0_CH4@GPE_MFPL', 'BPWM0_CH1:SYS_GPE_MFPL_PE3MFP_BPWM0_CH1@GPE_MFPL'] },
	{ f: ['PE.4', 'GPIO:SYS_GPE_MFPL_PE4MFP_GPIO@GPE_MFPL', 'EBI_nWR:SYS_GPE_MFPL_PE4MFP_EBI_nWR@GPE_MFPL', 'USCI0_DAT1:SYS_GPE_MFPL_PE4MFP_USCI0_DAT1@GPE_MFPL', 'UART6_RXD:SYS_GPE_MFPL_PE4MFP_UART6_RXD@GPE_MFPL', 'UART7_nCTS:SYS_GPE_MFPL_PE4MFP_UART7_nCTS@GPE_MFPL', 'PWM0_CH3:SYS_GPE_MFPL_PE4MFP_PWM0_CH3@GPE_MFPL', 'BPWM0_CH2:SYS_GPE_MFPL_PE4MFP_BPWM0_CH2@GPE_MFPL'] },
	{ f: ['PE.5', 'GPIO:SYS_GPE_MFPL_PE5MFP_GPIO@GPE_MFPL', 'EBI_nRD:SYS_GPE_MFPL_PE5MFP_EBI_nRD@GPE_MFPL', 'USCI0_CTL1:SYS_GPE_MFPL_PE5MFP_USCI0_CTL1@GPE_MFPL', 'UART6_TXD:SYS_GPE_MFPL_PE5MFP_UART6_TXD@GPE_MFPL', 'UART7_nRTS:SYS_GPE_MFPL_PE5MFP_UART7_nRTS@GPE_MFPL', 'PWM0_CH2:SYS_GPE_MFPL_PE5MFP_PWM0_CH2@GPE_MFPL', 'BPWM0_CH3:SYS_GPE_MFPL_PE5MFP_BPWM0_CH3@GPE_MFPL'] },
	{ f: ['PE.6', 'GPIO:SYS_GPE_MFPL_PE6MFP_GPIO@GPE_MFPL', 'USCI0_CTL0:SYS_GPE_MFPL_PE6MFP_USCI0_CTL0@GPE_MFPL', 'UART5_RXD:SYS_GPE_MFPL_PE6MFP_UART5_RXD@GPE_MFPL', 'PWM0_CH1:SYS_GPE_MFPL_PE6MFP_PWM0_CH1@GPE_MFPL', 'BPWM0_CH4:SYS_GPE_MFPL_PE6MFP_BPWM0_CH4@GPE_MFPL'] },
	{ f: ['PE.7', 'GPIO:SYS_GPE_MFPL_PE7MFP_GPIO@GPE_MFPL', 'UART5_TXD:SYS_GPE_MFPL_PE7MFP_UART5_TXD@GPE_MFPL', 'PWM0_CH0:SYS_GPE_MFPL_PE7MFP_PWM0_CH0@GPE_MFPL', 'BPWM0_CH5:SYS_GPE_MFPL_PE7MFP_BPWM0_CH5@GPE_MFPL'] },
	{ f: ['PE.8', 'GPIO:SYS_GPE_MFPH_PE8MFP_GPIO@GPE_MFPH', 'EBI_ADR10:SYS_GPE_MFPH_PE8MFP_EBI_ADR10@GPE_MFPH', 'USCI1_CTL1:SYS_GPE_MFPH_PE8MFP_USCI1_CTL1@GPE_MFPH', 'UART2_TXD:SYS_GPE_MFPH_PE8MFP_UART2_TXD@GPE_MFPH', 'PWM0_CH0:SYS_GPE_MFPH_PE8MFP_PWM0_CH0@GPE_MFPH', 'PWM0_BRAKE0:SYS_GPE_MFPH_PE8MFP_PWM0_BRAKE0@GPE_MFPH'] },
	{ f: ['PE.9', 'GPIO:SYS_GPE_MFPH_PE9MFP_GPIO@GPE_MFPH', 'EBI_ADR11:SYS_GPE_MFPH_PE9MFP_EBI_ADR11@GPE_MFPH', 'USCI1_CTL0:SYS_GPE_MFPH_PE9MFP_USCI1_CTL0@GPE_MFPH', 'UART2_RXD:SYS_GPE_MFPH_PE9MFP_UART2_RXD@GPE_MFPH', 'PWM0_CH1:SYS_GPE_MFPH_PE9MFP_PWM0_CH1@GPE_MFPH', 'PWM0_BRAKE1:SYS_GPE_MFPH_PE9MFP_PWM0_BRAKE1@GPE_MFPH'] },
	{ f: ['PE.10', 'GPIO:SYS_GPE_MFPH_PE10MFP_GPIO@GPE_MFPH', 'EBI_ADR12:SYS_GPE_MFPH_PE10MFP_EBI_ADR12@GPE_MFPH', 'USCI1_DAT0:SYS_GPE_MFPH_PE10MFP_USCI1_DAT0@GPE_MFPH', 'UART3_TXD:SYS_GPE_MFPH_PE10MFP_UART3_TXD@GPE_MFPH', 'PWM0_CH2:SYS_GPE_MFPH_PE10MFP_PWM0_CH2@GPE_MFPH', 'PWM1_BRAKE0:SYS_GPE_MFPH_PE10MFP_PWM1_BRAKE0@GPE_MFPH'] },
	{ f: ['PE.11', 'GPIO:SYS_GPE_MFPH_PE11MFP_GPIO@GPE_MFPH', 'EBI_ADR13:SYS_GPE_MFPH_PE11MFP_EBI_ADR13@GPE_MFPH', 'USCI1_DAT1:SYS_GPE_MFPH_PE11MFP_USCI1_DAT1@GPE_MFPH', 'UART3_RXD:SYS_GPE_MFPH_PE11MFP_UART3_RXD@GPE_MFPH', 'UART1_nCTS:SYS_GPE_MFPH_PE11MFP_UART1_nCTS@GPE_MFPH', 'PWM0_CH3:SYS_GPE_MFPH_PE11MFP_PWM0_CH3@GPE_MFPH', 'PWM1_BRAKE1:SYS_GPE_MFPH_PE11MFP_PWM1_BRAKE1@GPE_MFPH'] },
	{ f: ['PE.12', 'GPIO:SYS_GPE_MFPH_PE12MFP_GPIO@GPE_MFPH', 'EBI_ADR14:SYS_GPE_MFPH_PE12MFP_EBI_ADR14@GPE_MFPH', 'USCI1_CLK:SYS_GPE_MFPH_PE12MFP_USCI1_CLK@GPE_MFPH', 'UART1_nRTS:SYS_GPE_MFPH_PE12MFP_UART1_nRTS@GPE_MFPH', 'PWM0_CH4:SYS_GPE_MFPH_PE12MFP_PWM0_CH4@GPE_MFPH'] },
	{ f: ['PE.13', 'GPIO:SYS_GPE_MFPH_PE13MFP_GPIO@GPE_MFPH', 'EBI_ADR15:SYS_GPE_MFPH_PE13MFP_EBI_ADR15@GPE_MFPH', 'I2C0_SCL:SYS_GPE_MFPH_PE13MFP_I2C0_SCL@GPE_MFPH', 'UART4_nRTS:SYS_GPE_MFPH_PE13MFP_UART4_nRTS@GPE_MFPH', 'UART1_TXD:SYS_GPE_MFPH_PE13MFP_UART1_TXD@GPE_MFPH', 'PWM0_CH5:SYS_GPE_MFPH_PE13MFP_PWM0_CH5@GPE_MFPH', 'PWM1_CH0:SYS_GPE_MFPH_PE13MFP_PWM1_CH0@GPE_MFPH', 'BPWM1_CH5:SYS_GPE_MFPH_PE13MFP_BPWM1_CH5@GPE_MFPH'] },
	{ f: ['PE.14', 'GPIO:SYS_GPE_MFPH_PE14MFP_GPIO@GPE_MFPH', 'EBI_AD8:SYS_GPE_MFPH_PE14MFP_EBI_AD8@GPE_MFPH', 'UART2_TXD:SYS_GPE_MFPH_PE14MFP_UART2_TXD@GPE_MFPH', 'UART6_TXD:SYS_GPE_MFPH_PE14MFP_UART6_TXD@GPE_MFPH'] },
	{ f: ['PE.15', 'GPIO:SYS_GPE_MFPH_PE15MFP_GPIO@GPE_MFPH', 'EBI_AD9:SYS_GPE_MFPH_PE15MFP_EBI_AD9@GPE_MFPH', 'UART2_RXD:SYS_GPE_MFPH_PE15MFP_UART2_RXD@GPE_MFPH', 'UART6_RXD:SYS_GPE_MFPH_PE15MFP_UART6_RXD@GPE_MFPH'] },

	{ f: ['PF.0', 'GPIO:SYS_GPF_MFPL_PF0MFP_GPIO@GPF_MFPL', 'UART1_TXD:SYS_GPF_MFPL_PF0MFP_UART1_TXD@GPF_MFPL', 'I2C1_SCL:SYS_GPF_MFPL_PF0MFP_I2C1_SCL@GPF_MFPL', 'UART0_TXD:SYS_GPF_MFPL_PF0MFP_UART0_TXD@GPF_MFPL', 'BPWM1_CH0:SYS_GPF_MFPL_PF0MFP_BPWM1_CH0@GPF_MFPL', 'BPWM0_CH5:SYS_GPF_MFPL_PF0MFP_BPWM0_CH5@GPF_MFPL', 'ICE_DAT:SYS_GPF_MFPL_PF0MFP_ICE_DAT@GPF_MFPL'] },
	{ f: ['PF.1', 'GPIO:SYS_GPF_MFPL_PF1MFP_GPIO@GPF_MFPL', 'UART1_RXD:SYS_GPF_MFPL_PF1MFP_UART1_RXD@GPF_MFPL', 'I2C1_SDA:SYS_GPF_MFPL_PF1MFP_I2C1_SDA@GPF_MFPL', 'UART0_RXD:SYS_GPF_MFPL_PF1MFP_UART0_RXD@GPF_MFPL', 'BPWM1_CH1:SYS_GPF_MFPL_PF1MFP_BPWM1_CH1@GPF_MFPL', 'BPWM0_CH4:SYS_GPF_MFPL_PF1MFP_BPWM0_CH4@GPF_MFPL', 'ICE_CLK:SYS_GPF_MFPL_PF1MFP_ICE_CLK@GPF_MFPL'] },
	{ f: ['PF.2', 'GPIO:SYS_GPF_MFPL_PF2MFP_GPIO@GPF_MFPL', 'EBI_nCS1:SYS_GPF_MFPL_PF2MFP_EBI_nCS1@GPF_MFPL', 'UART0_RXD:SYS_GPF_MFPL_PF2MFP_UART0_RXD@GPF_MFPL', 'I2C0_SDA:SYS_GPF_MFPL_PF2MFP_I2C0_SDA@GPF_MFPL', 'QSPI0_CLK:SYS_GPF_MFPL_PF2MFP_QSPI0_CLK@GPF_MFPL', 'XT1_OUT:SYS_GPF_MFPL_PF2MFP_XT1_OUT@GPF_MFPL', 'BPWM1_CH1:SYS_GPF_MFPL_PF2MFP_BPWM1_CH1@GPF_MFPL', 'USCI1_CTL1:SYS_GPF_MFPL_PF2MFP_USCI1_CTL1@GPF_MFPL'] },
	{ f: ['PF.3', 'GPIO:SYS_GPF_MFPL_PF3MFP_GPIO@GPF_MFPL', 'EBI_nCS0:SYS_GPF_MFPL_PF3MFP_EBI_nCS0@GPF_MFPL', 'UART0_TXD:SYS_GPF_MFPL_PF3MFP_UART0_TXD@GPF_MFPL', 'I2C0_SCL:SYS_GPF_MFPL_PF3MFP_I2C0_SCL@GPF_MFPL', 'XT1_IN:SYS_GPF_MFPL_PF3MFP_XT1_IN@GPF_MFPL', 'BPWM1_CH0:SYS_GPF_MFPL_PF3MFP_BPWM1_CH0@GPF_MFPL', 'USCI1_CTL0:SYS_GPF_MFPL_PF3MFP_USCI1_CTL0@GPF_MFPL'] },
	{ f: ['PF.4', 'GPIO:SYS_GPF_MFPL_PF4MFP_GPIO@GPF_MFPL', 'UART2_TXD:SYS_GPF_MFPL_PF4MFP_UART2_TXD@GPF_MFPL', 'QSPI0_MOSI1:SYS_GPF_MFPL_PF4MFP_QSPI0_MOSI1@GPF_MFPL', 'UART2_nRTS:SYS_GPF_MFPL_PF4MFP_UART2_nRTS@GPF_MFPL', 'PWM0_CH1:SYS_GPF_MFPL_PF4MFP_PWM0_CH1@GPF_MFPL', 'BPWM0_CH5:SYS_GPF_MFPL_PF4MFP_BPWM0_CH5@GPF_MFPL', 'X32_OUT:SYS_GPF_MFPL_PF4MFP_X32_OUT@GPF_MFPL'] },
	{ f: ['PF.5', 'GPIO:SYS_GPF_MFPL_PF5MFP_GPIO@GPF_MFPL', 'UART2_RXD:SYS_GPF_MFPL_PF5MFP_UART2_RXD@GPF_MFPL', 'QSPI0_MISO1:SYS_GPF_MFPL_PF5MFP_QSPI0_MISO1@GPF_MFPL', 'UART2_nCTS:SYS_GPF_MFPL_PF5MFP_UART2_nCTS@GPF_MFPL', 'PWM0_CH0:SYS_GPF_MFPL_PF5MFP_PWM0_CH0@GPF_MFPL', 'BPWM0_CH4:SYS_GPF_MFPL_PF5MFP_BPWM0_CH4@GPF_MFPL', 'X32_IN:SYS_GPF_MFPL_PF5MFP_X32_IN@GPF_MFPL', 'ADC_ST:SYS_GPF_MFPL_PF5MFP_ADC_ST@GPF_MFPL', 'ADC0_ST:SYS_GPF_MFPL_PF5MFP_ADC0_ST@GPF_MFPL'] },
	{ f: ['PF.6', 'GPIO:SYS_GPF_MFPL_PF6MFP_GPIO@GPF_MFPL', 'EBI_ADR19:SYS_GPF_MFPL_PF6MFP_EBI_ADR19@GPF_MFPL', 'SPI0_MOSI:SYS_GPF_MFPL_PF6MFP_SPI0_MOSI@GPF_MFPL', 'UART4_RXD:SYS_GPF_MFPL_PF6MFP_UART4_RXD@GPF_MFPL', 'EBI_nCS0:SYS_GPF_MFPL_PF6MFP_EBI_nCS0@GPF_MFPL'] },
	{ f: ['PF.7', 'GPIO:SYS_GPF_MFPL_PF7MFP_GPIO@GPF_MFPL', 'EBI_ADR18:SYS_GPF_MFPL_PF7MFP_EBI_ADR18@GPF_MFPL', 'SPI0_MISO:SYS_GPF_MFPL_PF7MFP_SPI0_MISO@GPF_MFPL', 'UART4_TXD:SYS_GPF_MFPL_PF7MFP_UART4_TXD@GPF_MFPL'] },
	{ f: ['PF.8', 'GPIO:SYS_GPF_MFPH_PF8MFP_GPIO@GPF_MFPH', 'EBI_ADR17:SYS_GPF_MFPH_PF8MFP_EBI_ADR17@GPF_MFPH', 'SPI0_CLK:SYS_GPF_MFPH_PF8MFP_SPI0_CLK@GPF_MFPH', 'UART5_nCTS:SYS_GPF_MFPH_PF8MFP_UART5_nCTS@GPF_MFPH'] },
	{ f: ['PF.9', 'GPIO:SYS_GPF_MFPH_PF9MFP_GPIO@GPF_MFPH', 'EBI_ADR16:SYS_GPF_MFPH_PF9MFP_EBI_ADR16@GPF_MFPH', 'SPI0_SS:SYS_GPF_MFPH_PF9MFP_SPI0_SS@GPF_MFPH', 'UART5_nRTS:SYS_GPF_MFPH_PF9MFP_UART5_nRTS@GPF_MFPH'] },
	{ f: ['PF.10', 'GPIO:SYS_GPF_MFPH_PF10MFP_GPIO@GPF_MFPH', 'EBI_ADR15:SYS_GPF_MFPH_PF10MFP_EBI_ADR15@GPF_MFPH', 'SPI0_I2SMCLK:SYS_GPF_MFPH_PF10MFP_SPI0_I2SMCLK@GPF_MFPH', 'UART5_RXD:SYS_GPF_MFPH_PF10MFP_UART5_RXD@GPF_MFPH'] },
	{ f: ['PF.11', 'GPIO:SYS_GPF_MFPH_PF11MFP_GPIO@GPF_MFPH', 'EBI_ADR14:SYS_GPF_MFPH_PF11MFP_EBI_ADR14@GPF_MFPH', 'UART5_TXD:SYS_GPF_MFPH_PF11MFP_UART5_TXD@GPF_MFPH', 'TM3:SYS_GPF_MFPH_PF11MFP_TM3@GPF_MFPH'] },
	{ f: ['PF.12', 'GPIO:SYS_GPF_MFPH_PF12MFP_GPIO@GPF_MFPH'] },
	{ f: ['PF.13', 'GPIO:SYS_GPF_MFPH_PF13MFP_GPIO@GPF_MFPH'] },
	{ f: ['PF.14', 'GPIO:SYS_GPF_MFPH_PF14MFP_GPIO@GPF_MFPH', 'PWM1_BRAKE0:SYS_GPF_MFPH_PF14MFP_PWM1_BRAKE0@GPF_MFPH', 'PWM0_BRAKE0:SYS_GPF_MFPH_PF14MFP_PWM0_BRAKE0@GPF_MFPH', 'PWM0_CH4:SYS_GPF_MFPH_PF14MFP_PWM0_CH4@GPF_MFPH', 'CLKO:SYS_GPF_MFPH_PF14MFP_CLKO@GPF_MFPH', 'TM3:SYS_GPF_MFPH_PF14MFP_TM3@GPF_MFPH', 'INT5:SYS_GPF_MFPH_PF14MFP_INT5@GPF_MFPH'] },
	{ f: ['PF.15', 'GPIO:SYS_GPF_MFPH_PF15MFP_GPIO@GPF_MFPH', 'PWM0_BRAKE0:SYS_GPF_MFPH_PF15MFP_PWM0_BRAKE0@GPF_MFPH', 'PWM0_CH1:SYS_GPF_MFPH_PF15MFP_PWM0_CH1@GPF_MFPH', 'TM2:SYS_GPF_MFPH_PF15MFP_TM2@GPF_MFPH', 'CLKO:SYS_GPF_MFPH_PF15MFP_CLKO@GPF_MFPH', 'INT4:SYS_GPF_MFPH_PF15MFP_INT4@GPF_MFPH'] },

	{ f: ['PG.0', 'GPIO:SYS_GPG_MFPL_PG0MFP_GPIO@GPG_MFPL'] },
	{ f: ['PG.1', 'GPIO:SYS_GPG_MFPL_PG1MFP_GPIO@GPG_MFPL'] },
	{ f: ['PG.2', 'GPIO:SYS_GPG_MFPL_PG2MFP_GPIO@GPG_MFPL', 'EBI_ADR11:SYS_GPG_MFPL_PG2MFP_EBI_ADR11@GPG_MFPL', 'I2C0_SMBAL:SYS_GPG_MFPL_PG2MFP_I2C0_SMBAL@GPG_MFPL', 'I2C1_SCL:SYS_GPG_MFPL_PG2MFP_I2C1_SCL@GPG_MFPL', 'TM0:SYS_GPG_MFPL_PG2MFP_TM0@GPG_MFPL'] },
	{ f: ['PG.3', 'GPIO:SYS_GPG_MFPL_PG3MFP_GPIO@GPG_MFPL', 'EBI_ADR12:SYS_GPG_MFPL_PG3MFP_EBI_ADR12@GPG_MFPL', 'I2C0_SMBSUS:SYS_GPG_MFPL_PG3MFP_I2C0_SMBSUS@GPG_MFPL', 'I2C1_SDA:SYS_GPG_MFPL_PG3MFP_I2C1_SDA@GPG_MFPL', 'TM1:SYS_GPG_MFPL_PG3MFP_TM1@GPG_MFPL'] },
	{ f: ['PG.4', 'GPIO:SYS_GPG_MFPL_PG4MFP_GPIO@GPG_MFPL', 'EBI_ADR13:SYS_GPG_MFPL_PG4MFP_EBI_ADR13@GPG_MFPL', 'TM2:SYS_GPG_MFPL_PG4MFP_TM2@GPG_MFPL'] },
	{ f: ['PG.5', 'GPIO:SYS_GPG_MFPL_PG5MFP_GPIO@GPG_MFPL'] },
	{ f: ['PG.6', 'GPIO:SYS_GPG_MFPL_PG6MFP_GPIO@GPG_MFPL'] },
	{ f: ['PG.7', 'GPIO:SYS_GPG_MFPL_PG7MFP_GPIO@GPG_MFPL'] },
	{ f: ['PG.8', 'GPIO:SYS_GPG_MFPH_PG8MFP_GPIO@GPG_MFPH'] },
	{ f: ['PG.9', 'GPIO:SYS_GPG_MFPH_PG9MFP_GPIO@GPG_MFPH', 'EBI_AD0:SYS_GPG_MFPH_PG9MFP_EBI_AD0@GPG_MFPH', 'BPWM0_CH5:SYS_GPG_MFPH_PG9MFP_BPWM0_CH5@GPG_MFPH'] },
	{ f: ['PG.10', 'GPIO:SYS_GPG_MFPH_PG10MFP_GPIO@GPG_MFPH', 'EBI_AD1:SYS_GPG_MFPH_PG10MFP_EBI_AD1@GPG_MFPH', 'BPWM0_CH4:SYS_GPG_MFPH_PG10MFP_BPWM0_CH4@GPG_MFPH'] },
	{ f: ['PG.11', 'GPIO:SYS_GPG_MFPH_PG11MFP_GPIO@GPG_MFPH', 'EBI_AD2:SYS_GPG_MFPH_PG11MFP_EBI_AD2@GPG_MFPH', 'UART7_TXD:SYS_GPG_MFPH_PG11MFP_UART7_TXD@GPG_MFPH', 'BPWM0_CH3:SYS_GPG_MFPH_PG11MFP_BPWM0_CH3@GPG_MFPH'] },
	{ f: ['PG.12', 'GPIO:SYS_GPG_MFPH_PG12MFP_GPIO@GPG_MFPH', 'EBI_AD3:SYS_GPG_MFPH_PG12MFP_EBI_AD3@GPG_MFPH', 'UART7_RXD:SYS_GPG_MFPH_PG12MFP_UART7_RXD@GPG_MFPH', 'BPWM0_CH2:SYS_GPG_MFPH_PG12MFP_BPWM0_CH2@GPG_MFPH'] },
	{ f: ['PG.13', 'GPIO:SYS_GPG_MFPH_PG13MFP_GPIO@GPG_MFPH', 'EBI_AD4:SYS_GPG_MFPH_PG13MFP_EBI_AD4@GPG_MFPH', 'UART6_TXD:SYS_GPG_MFPH_PG13MFP_UART6_TXD@GPG_MFPH', 'BPWM0_CH1:SYS_GPG_MFPH_PG13MFP_BPWM0_CH1@GPG_MFPH'] },
	{ f: ['PG.14', 'GPIO:SYS_GPG_MFPH_PG14MFP_GPIO@GPG_MFPH', 'EBI_AD5:SYS_GPG_MFPH_PG14MFP_EBI_AD5@GPG_MFPH', 'UART6_RXD:SYS_GPG_MFPH_PG14MFP_UART6_RXD@GPG_MFPH', 'BPWM0_CH0:SYS_GPG_MFPH_PG14MFP_BPWM0_CH0@GPG_MFPH'] },
	{ f: ['PG.15', 'GPIO:SYS_GPG_MFPH_PG15MFP_GPIO@GPG_MFPH', 'CLKO:SYS_GPG_MFPH_PG15MFP_CLKO@GPG_MFPH', 'ADC_ST:SYS_GPG_MFPH_PG15MFP_ADC_ST@GPG_MFPH', 'ADC0_ST:SYS_GPG_MFPH_PG15MFP_ADC0_ST@GPG_MFPH'] },

	{ f: ['PH.0', 'GPIO:SYS_GPH_MFPL_PH0MFP_GPIO@GPH_MFPL'] },
	{ f: ['PH.1', 'GPIO:SYS_GPH_MFPL_PH1MFP_GPIO@GPH_MFPL'] },
	{ f: ['PH.2', 'GPIO:SYS_GPH_MFPL_PH2MFP_GPIO@GPH_MFPL'] },
	{ f: ['PH.3', 'GPIO:SYS_GPH_MFPL_PH3MFP_GPIO@GPH_MFPL'] },
	{ f: ['PH.4', 'GPIO:SYS_GPH_MFPL_PH4MFP_GPIO@GPH_MFPL', 'EBI_ADR3:SYS_GPH_MFPL_PH4MFP_EBI_ADR3@GPH_MFPL', 'UART7_nRTS:SYS_GPH_MFPL_PH4MFP_UART7_nRTS@GPH_MFPL', 'UART6_TXD:SYS_GPH_MFPL_PH4MFP_UART6_TXD@GPH_MFPL'] },
	{ f: ['PH.5', 'GPIO:SYS_GPH_MFPL_PH5MFP_GPIO@GPH_MFPL', 'EBI_ADR2:SYS_GPH_MFPL_PH5MFP_EBI_ADR2@GPH_MFPL', 'UART7_nCTS:SYS_GPH_MFPL_PH5MFP_UART7_nCTS@GPH_MFPL', 'UART6_RXD:SYS_GPH_MFPL_PH5MFP_UART6_RXD@GPH_MFPL'] },
	{ f: ['PH.6', 'GPIO:SYS_GPH_MFPL_PH6MFP_GPIO@GPH_MFPL', 'EBI_ADR1:SYS_GPH_MFPL_PH6MFP_EBI_ADR1@GPH_MFPL', 'UART7_TXD:SYS_GPH_MFPL_PH6MFP_UART7_TXD@GPH_MFPL'] },
	{ f: ['PH.7', 'GPIO:SYS_GPH_MFPL_PH7MFP_GPIO@GPH_MFPL', 'EBI_ADR0:SYS_GPH_MFPL_PH7MFP_EBI_ADR0@GPH_MFPL', 'UART7_RXD:SYS_GPH_MFPL_PH7MFP_UART7_RXD@GPH_MFPL'] },
	{ f: ['PH.8', 'GPIO:SYS_GPH_MFPH_PH8MFP_GPIO@GPH_MFPH', 'EBI_AD12:SYS_GPH_MFPH_PH8MFP_EBI_AD12@GPH_MFPH', 'QSPI0_CLK:SYS_GPH_MFPH_PH8MFP_QSPI0_CLK@GPH_MFPH', 'UART3_nRTS:SYS_GPH_MFPH_PH8MFP_UART3_nRTS@GPH_MFPH', 'UART1_TXD:SYS_GPH_MFPH_PH8MFP_UART1_TXD@GPH_MFPH'] },
	{ f: ['PH.9', 'GPIO:SYS_GPH_MFPH_PH9MFP_GPIO@GPH_MFPH', 'EBI_AD13:SYS_GPH_MFPH_PH9MFP_EBI_AD13@GPH_MFPH', 'QSPI0_SS:SYS_GPH_MFPH_PH9MFP_QSPI0_SS@GPH_MFPH', 'UART3_nCTS:SYS_GPH_MFPH_PH9MFP_UART3_nCTS@GPH_MFPH', 'UART1_RXD:SYS_GPH_MFPH_PH9MFP_UART1_RXD@GPH_MFPH'] },
	{ f: ['PH.10', 'GPIO:SYS_GPH_MFPH_PH10MFP_GPIO@GPH_MFPH', 'EBI_AD14:SYS_GPH_MFPH_PH10MFP_EBI_AD14@GPH_MFPH', 'QSPI0_MISO1:SYS_GPH_MFPH_PH10MFP_QSPI0_MISO1@GPH_MFPH', 'UART4_TXD:SYS_GPH_MFPH_PH10MFP_UART4_TXD@GPH_MFPH', 'UART0_TXD:SYS_GPH_MFPH_PH10MFP_UART0_TXD@GPH_MFPH'] },
	{ f: ['PH.11', 'GPIO:SYS_GPH_MFPH_PH11MFP_GPIO@GPH_MFPH', 'EBI_AD15:SYS_GPH_MFPH_PH11MFP_EBI_AD15@GPH_MFPH', 'QSPI0_MOSI1:SYS_GPH_MFPH_PH11MFP_QSPI0_MOSI1@GPH_MFPH', 'UART4_RXD:SYS_GPH_MFPH_PH11MFP_UART4_RXD@GPH_MFPH', 'UART0_RXD:SYS_GPH_MFPH_PH11MFP_UART0_RXD@GPH_MFPH', 'PWM0_CH5:SYS_GPH_MFPH_PH11MFP_PWM0_CH5@GPH_MFPH'] },
	{ f: ['PH.12', 'GPIO:SYS_GPH_MFPH_PH12MFP_GPIO@GPH_MFPH'] },
	{ f: ['PH.13', 'GPIO:SYS_GPH_MFPH_PH13MFP_GPIO@GPH_MFPH'] },
	{ f: ['PH.14', 'GPIO:SYS_GPH_MFPH_PH14MFP_GPIO@GPH_MFPH'] },
	{ f: ['PH.15', 'GPIO:SYS_GPH_MFPH_PH15MFP_GPIO@GPH_MFPH'] }
];

NUTOOL_PIN.g_cfg_gpiosDescriptions = [
	'ACMP0_N:Analog comparator 0 negative input pin',
	'ACMP0_O:Analog comparator 0 output pin',
	'ACMP0_P0:Analog comparator 0 positive input 0 pin',
	'ACMP0_P1:Analog comparator 0 positive input 1 pin',
	'ACMP0_P2:Analog comparator 0 positive input 2 pin',
	'ACMP0_P3:Analog comparator 0 positive input 3 pin',
	'ACMP0_WLAT:Analog comparator 0 window latch input pin',
	'ACMP1_N:Analog comparator 1 negative input  pin',
	'ACMP1_O:Analog comparator 1 output pin',
	'ACMP1_P0:Analog comparator 1 positive input 0 pin',
	'ACMP1_P1:Analog comparator 1 positive input 1 pin',
	'ACMP1_P2:Analog comparator 1 positive input 2 pin',
	'ACMP1_P3:Analog comparator 1 positive input 3 pin',
	'ACMP1_WLAT:Analog comparator 1 window latch input pin',
	'ADC0_CH0:ADC0 channel 0 analog input',
	'ADC0_CH1:ADC0 channel 1 analog input',
	'ADC0_CH2:ADC0 channel 2 analog input',
	'ADC0_CH3:ADC0 channel 3 analog input',
	'ADC0_CH4:ADC0 channel 4 analog input',
	'ADC0_CH5:ADC0 channel 5 analog input',
	'ADC0_CH6:ADC0 channel 6 analog input',
	'ADC0_CH7:ADC0 channel 7 analog input',
	'ADC0_CH8:ADC0 channel 8 analog input',
	'ADC0_CH9:ADC0 channel 9 analog input',
	'ADC0_CH10:ADC0 channel 10 analog input',
	'ADC0_CH11:ADC0 channel 11 analog input',
	'ADC0_CH12:ADC0 channel 12 analog input',
	'ADC0_CH13:ADC0 channel 13 analog input',
	'ADC0_CH14:ADC0 channel 14 analog input',
	'ADC0_CH15:ADC0 channel 15 analog input',
	'ADC0_ST:ADC0 external trigger input pin',
	'AVDD:Power supply for internal analog circuit',
	'AVSS:Ground pin for analog circuit',
	'BPWM0_CH0:BPWM0 channel 0 output/capture input',
	'BPWM0_CH1:BPWM0 channel 1 output/capture input',
	'BPWM0_CH2:BPWM0 channel 2 output/capture input',
	'BPWM0_CH3:BPWM0 channel 3 output/capture input',
	'BPWM0_CH4:BPWM0 channel 4 output/capture input',
	'BPWM0_CH5:BPWM0 channel 5 output/capture input',
	'BPWM1_CH0:BPWM1 channel 0 output/capture input',
	'BPWM1_CH1:BPWM1 channel 1 output/capture input',
	'BPWM1_CH2:BPWM1 channel 2 output/capture input',
	'BPWM1_CH3:BPWM1 channel 3 output/capture input',
	'BPWM1_CH4:BPWM1 channel 4 output/capture input',
	'BPWM1_CH5:BPWM1 channel 5 output/capture input',
	'CLKO:Clock Out',
	'EBI_AD0:EBI address/data bus bit 0',
	'EBI_AD1:EBI address/data bus bit 1',
	'EBI_AD2:EBI address/data bus bit 2',
	'EBI_AD3:EBI address/data bus bit 3',
	'EBI_AD4:EBI address/data bus bit 4',
	'EBI_AD5:EBI address/data bus bit 5',
	'EBI_AD6:EBI address/data bus bit 6',
	'EBI_AD7:EBI address/data bus bit 7',
	'EBI_AD8:EBI address/data bus bit 8',
	'EBI_AD9:EBI address/data bus bit 9',
	'EBI_AD10:EBI address/data bus bit 10',
	'EBI_AD11:EBI address/data bus bit 11',
	'EBI_AD12:EBI address/data bus bit 12',
	'EBI_AD13:EBI address/data bus bit 13',
	'EBI_AD14:EBI address/data bus bit 14',
	'EBI_AD15:EBI address/data bus bit 15',
	'EBI_ADR0:EBI address bus bit 0',
	'EBI_ADR1:EBI address bus bit 1',
	'EBI_ADR2:EBI address bus bit 2',
	'EBI_ADR3:EBI address bus bit 3',
	'EBI_ADR4:EBI address bus bit 4',
	'EBI_ADR5:EBI address bus bit 5',
	'EBI_ADR6:EBI address bus bit 6',
	'EBI_ADR7:EBI address bus bit 7',
	'EBI_ADR8:EBI address bus bit 8',
	'EBI_ADR9:EBI address bus bit 9',
	'EBI_ADR10:EBI address bus bit 10',
	'EBI_ADR11:EBI address bus bit 11',
	'EBI_ADR12:EBI address bus bit 12',
	'EBI_ADR13:EBI address bus bit 13',
	'EBI_ADR14:EBI address bus bit 14',
	'EBI_ADR15:EBI address bus bit 15',
	'EBI_ADR16:EBI address bus bit 16',
	'EBI_ADR17:EBI address bus bit 17',
	'EBI_ADR18:EBI address bus bit 18',
	'EBI_ADR19:EBI address bus bit 19',
	'EBI_ALE:EBI address latch enable output pin',
	'EBI_MCLK:EBI external clock output pin',
	'EBI_nCS0:EBI chip select 0 output pin',
	'EBI_nCS1:EBI chip select 1 output pin',
	'EBI_nRD:EBI read enable output pin',
	'EBI_nWR:EBI write enable output pin',
	'EBI_nWRH:EBI high byte write enable output pin',
	'EBI_nWRL:EBI low byte write enable output pin',
	'I2C0_SCL:I2C0 clock pin',
	'I2C0_SDA:I2C0 data input/output pin',
	'I2C0_SMBAL:I2C0 SMBus SMBALTER pin ',
	'I2C0_SMBSUS:I2C0 SMBus SMBSUS pin (PMBus CONTROL pin)',
	'I2C1_SCL:I2C1 clock pin',
	'I2C1_SDA:I2C1 data input/output pin',
	'ICE_CLK:ADC external trigger input',
	'ICE_DAT:ADC external trigger input',
	'INT0:External interrupt 0 input pin',
	'INT1:External interrupt 1 input pin',
	'INT2:External interrupt 2 input pin',
	'INT3:External interrupt 3 input pin',
	'INT4:External interrupt 4 input pin',
	'INT5:External interrupt 5 input pin',
	'LDO_CAP:LDO output pin',
	'nRESET:External reset input: active LOW, with an internal pull-up. Set this pin low reset to initial state',
	'PWM0_BRAKE0:PWM0 Brake 0 input pin',
	'PWM0_BRAKE1:PWM0 Brake 1 input pin',
	'PWM0_CH0:PWM0 channel 0 output/capture input',
	'PWM0_CH1:PWM0 channel 1 output/capture input',
	'PWM0_CH2:PWM0 channel 2 output/capture input',
	'PWM0_CH3:PWM0 channel 3 output/capture input',
	'PWM0_CH4:PWM0 channel 4 output/capture input',
	'PWM0_CH5:PWM0 channel 5 output/capture input',
	'PWM1_BRAKE0:PWM1 Brake 0 input pin',
	'PWM1_BRAKE1:PWM1 Brake 1 input pin',
	'PWM1_CH0:PWM1 channel 0 output/capture input',
	'PWM1_CH1:PWM1 channel 1 output/capture input',
	'PWM1_CH2:PWM1 channel 2 output/capture input',
	'PWM1_CH3:PWM1 channel 3 output/capture input',
	'PWM1_CH4:PWM1 channel 4 output/capture input',
	'PWM1_CH5:PWM1 channel 5 output/capture input',
	'QSPI0_CLK:Quad SPI0 serial clock pin',
	'QSPI0_MISO0:Quad SPI0 MISO0 (Master In, Slave Out) pin',
	'QSPI0_MISO1:Quad SPI0 MISO1 (Master In, Slave Out) pin',
	'QSPI0_MOSI0:Quad SPI0 MOSI0 (Master Out, Slave In) pin',
	'QSPI0_MOSI1:Quad SPI0 MOSI1 (Master Out, Slave In) pin',
	'QSPI0_SS:Quad SPI0 slave select  pin',
	'SPI0_CLK:SPI0 serial clock pin',
	'SPI0_I2SMCLK:SPI0 I2S master clock output pin',
	'SPI0_MISO:SPI0 MISO (Master In, Slave Out) pin',
	'SPI0_MOSI:SPI0 MOSI (Master Out, Slave In) pin',
	'SPI0_SS:SPI0 slave select  pin',
	'TM0:Timer0 event counter input/toggle output pin',
	'TM0_EXT:Timer0 external capture input/toggle output pin',
	'TM1:Timer1 event counter input/toggle output pin',
	'TM1_EXT:Timer1 external capture input/toggle output pin',
	'TM2:Timer2 event counter input/toggle output pin',
	'TM2_EXT:Timer2 external capture input/toggle output pin',
	'TM3:Timer3 event counter input/toggle output pin',
	'TM3_EXT:Timer3 external capture input/toggle output pin',
	'UART0_nCTS:UART0 clear to Send input pin',
	'UART0_nRTS:UART0 request to Send output pin',
	'UART0_RXD:UART0 data receiver input pin',
	'UART0_TXD:UART0 data transmitter output pin',
	'UART1_nCTS:UART1 clear to Send input pin',
	'UART1_nRTS:UART1 request to Send output pin',
	'UART1_RXD:UART1 data receiver input pin',
	'UART1_TXD:UART1 data transmitter output pin',
	'UART2_nCTS:UART2 clear to Send input pin',
	'UART2_nRTS:UART2 request to Send output pin',
	'UART2_RXD:UART2 data receiver input pin',
	'UART2_TXD:UART2 data transmitter output pin',
	'UART3_nCTS:UART3 clear to Send input pin',
	'UART3_nRTS:UART3 request to Send output pin',
	'UART3_RXD:UART3 data receiver input pin',
	'UART3_TXD:UART3 data transmitter output pin',
	'UART4_nCTS:UART4 clear to Send input pin',
	'UART4_nRTS:UART4 request to Send output pin',
	'UART4_RXD:UART4 data receiver input pin',
	'UART4_TXD:UART4 data transmitter output pin',
	'UART5_nCTS:UART5 clear to Send input pin',
	'UART5_nRTS:UART5 request to Send output pin',
	'UART5_RXD:UART5 data receiver input pin',
	'UART5_TXD:UART5 data transmitter output pin',
	'UART6_nCTS:UART6 clear to Send input pin',
	'UART6_nRTS:UART6 request to Send output pin',
	'UART6_RXD:UART6 data receiver input pin',
	'UART6_TXD:UART6 data transmitter output pin',
	'UART7_nCTS:UART7 clear to Send input pin',
	'UART7_nRTS:UART7 request to Send output pin',
	'UART7_RXD:UART7 data receiver input pin',
	'UART7_TXD:UART7 data transmitter output pin',
	'USB_D-:USB differential signal D-',
	'USB_D+:USB differential signal D+',
	'USB_VBUS:Power supply from USB host or HUB',
	'USB_VDD33_CAP:Internal power regulator output 3.3V decoupling pin',
	'USCI0_CLK:USCI0 clock pin',
	'USCI0_CTL0:USCI0 control 0 pin',
	'USCI0_CTL1:USCI0 control 1 pin',
	'USCI0_DAT0:USCI0 data 0 pin',
	'USCI0_DAT1:USCI0 data 1 pin',
	'USCI1_CLK:USCI1 clock pin',
	'USCI1_CTL0:USCI1 control 0 pin',
	'USCI1_CTL1:USCI1 control 1 pin',
	'USCI1_DAT0:USCI1 data 0 pin',
	'USCI1_DAT1:USCI1 data 1 pin',
	'VDD:Power supply for I/O ports and LDO source for internal PLL and digital circuit',
	'VREF:ADC reference voltage input',
	'VSS:Ground pin for digital circuit',
	'X32_IN:External 32.768 kHz crystal input pin',
	'X32_OUT:External 32.768 kHz crystal output pin',
	'XT1_IN:External 4~24 MHz (high speed) crystal input pin',
	'XT1_OUT:External 4~24 MHz (high speed) crystal output pin'
];

NUTOOL_PIN.g_cfg_regDescriptions = {};
NUTOOL_PIN.g_cfg_regDescriptions.GPA_MFPL = '0x40000030';
NUTOOL_PIN.g_cfg_regDescriptions.GPA_MFPH = '0x40000034';
NUTOOL_PIN.g_cfg_regDescriptions.GPB_MFPL = '0x40000038';
NUTOOL_PIN.g_cfg_regDescriptions.GPB_MFPH = '0x4000003C';
NUTOOL_PIN.g_cfg_regDescriptions.GPC_MFPL = '0x40000040';
NUTOOL_PIN.g_cfg_regDescriptions.GPC_MFPH = '0x40000044';
NUTOOL_PIN.g_cfg_regDescriptions.GPD_MFPL = '0x40000048';
NUTOOL_PIN.g_cfg_regDescriptions.GPD_MFPH = '0x4000004C';
NUTOOL_PIN.g_cfg_regDescriptions.GPE_MFPL = '0x40000050';
NUTOOL_PIN.g_cfg_regDescriptions.GPE_MFPH = '0x40000054';
NUTOOL_PIN.g_cfg_regDescriptions.GPF_MFPL = '0x40000058';
NUTOOL_PIN.g_cfg_regDescriptions.GPF_MFPH = '0x4000005C';
NUTOOL_PIN.g_cfg_regDescriptions.GPG_MFPL = '0x40000060';
NUTOOL_PIN.g_cfg_regDescriptions.GPG_MFPH = '0x40000064';
NUTOOL_PIN.g_cfg_regDescriptions.GPH_MFPL = '0x40000068';
NUTOOL_PIN.g_cfg_regDescriptions.GPH_MFPH = '0x4000006C';

NUTOOL_PIN.g_cfg_gpioMatrix = [];
NUTOOL_PIN.g_cfg_shareBits = [];
NUTOOL_PIN.g_cfg_addGPIO = {};
NUTOOL_PIN.g_cfg_unusedGPIO = {
	"M031SIAAE(LQFP64)": {
		"ALL": ["USB"]
	},
	"M031KIAAE(LQFP128)": {
		"ALL": ["USB"]
	},
	"M032BTAIAAN(QFN68)": {
		"ALL": ["EBI", "INT5", "SPI0"]
	}
};

NUTOOL_PIN.decidepackageNumber = function (given_partNumber_package) {
	var partNumber_package,
		partNumber;

	if (typeof given_partNumber_package === 'undefined') {
		partNumber_package = NUTOOL_PIN.getg_partNumber_package();
	}
	else {
		partNumber_package = given_partNumber_package;
	}

	NUTOOL_PIN.g_packageNumber = partNumber_package.substring(partNumber_package.indexOf('(') + 1);
	NUTOOL_PIN.g_packageNumber = NUTOOL_PIN.g_packageNumber.substring(0, NUTOOL_PIN.g_packageNumber.indexOf(')'));

	partNumber = partNumber_package.substring(0, partNumber_package.indexOf('('));
	switch (NUTOOL_PIN.g_packageNumber) {
	case 'LQFP64':
		if (partNumber === "M031SIAAE") {
			NUTOOL_PIN.g_packageNumberIndex = "LQFP64";
		}
		else {
			NUTOOL_PIN.g_packageNumberIndex = "ULQFP64";
		}
		break;
	case 'QFN68':
		NUTOOL_PIN.g_packageNumberIndex = "UQFN68";
		break;
	default:// 'LQFP128'
		if (partNumber === "M031KIAAE") {
			NUTOOL_PIN.g_packageNumberIndex = "LQFP128";
		}
		else {
			NUTOOL_PIN.g_packageNumberIndex = "ULQFP128";
		}
		break;
	}
	partNumber_package = null;
	partNumber = null;
};
