

#if (NUCODEGEN_ACMP)
void ACMP_Init()
{
#if (NUCODEGEN_ACMP0_ENABLE)
    /* Select ACMP0 positive input channel */
    ACMP_SELECT_P(NUCODEGEN_ACMP_MODULE_SEL, ACMP_MODULE_0, NUCODEGEN_ACMP0_P_SEL);

    /* Configure ACMP0. Enable ACMP0 and select output source as the source of ACMP negative input. */
    ACMP_Open(NUCODEGEN_ACMP_MODULE_SEL, ACMP_MODULE_0, NUCODEGEN_ACMP0_N_SEL, NUCODEGEN_ACMP0_HYSTERESIS_SEL);


#if (NUCODEGEN_ACMP0_ADVANCED)

#if (NUCODEGEN_ACMP0_FILTERCNT_EN)

    /* Set ACMP0 output filter */
    ACMP_SET_FILTER(NUCODEGEN_ACMP_MODULE_SEL, ACMP_MODULE_0, NUCODEGEN_ACMP0_FILTERCNT_SEL);

    /* Enable ACMP0 output filter */
    ACMP_ENABLE_FILTER(NUCODEGEN_ACMP_MODULE_SEL,ACMP_MODULE_0);

#endif

#if (NUCODEGEN_ACMP0_OUTPUT_INVERSE_EN)
    /* Enable ACMP0 output inverse */
    ACMP_ENABLE_OUTPUT_INVERSE(NUCODEGEN_ACMP_MODULE_SEL, ACMP_MODULE_0);
#endif /* NUCODEGEN_ACMP0_OUTPUT_INVERSE_EN */

#if (NUCODEGEN_ACMP0_WKP_EN)
    /* Enable ACMP0 ACMP wake-up function */
    ACMP_ENABLE_WAKEUP(NUCODEGEN_ACMP_MODULE_SEL, ACMP_MODULE_0);
#endif /* NUCODEGEN_ACMP0_WKP_EN */

#if (NUCODEGEN_ACMP0_WIN_COMPARE_EN)
    /* Enable ACMP0 window compare function */
    ACMP_ENABLE_WINDOW_COMPARE(NUCODEGEN_ACMP_MODULE_SEL, ACMP_MODULE_0);
#endif /* NUCODEGEN_ACMP0_WIN_COMPARE_EN */

#if (NUCODEGEN_ACMP0_WIN_LATCH_EN)
    /* Enable ACMP0 window latch function */
    ACMP_ENABLE_WINDOW_LATCH(NUCODEGEN_ACMP_MODULE_SEL, ACMP_MODULE_0);
#endif /* NUCODEGEN_ACMP0_WIN_LATCH_EN */

#if (NUCODEGEN_ACMP0_INT_EN)
    /* Clear ACMP 0 interrupt flag */
    ACMP_CLR_INT_FLAG(NUCODEGEN_ACMP_MODULE_SEL, ACMP_MODULE_0);

    /* Set ACMP 0 interrupt condition */
    ACMP_SELECT_INT_COND(NUCODEGEN_ACMP_MODULE_SEL, ACMP_MODULE_0, NUCODEGEN_ACMP0_INT_COND_SEL);

    /* Enable ACMP 0 interrupt */
    ACMP_ENABLE_INT(NUCODEGEN_ACMP_MODULE_SEL, ACMP_MODULE_0);

#endif /* NUCODEGEN_ACMP0_INT_EN */

#endif /* NUCODEGEN_ACMP0_ADVANCED */

#endif /* NUCODEGEN_ACMP0_ENABLE */

#if (NUCODEGEN_ACMP1_ENABLE)
    /* Select ACMP1 positive input channel */
    ACMP_SELECT_P(NUCODEGEN_ACMP_MODULE_SEL, ACMP_MODULE_1, NUCODEGEN_ACMP1_P_SEL);

    /* Configure ACMP1. Enable ACMP1 and select output source as the source of ACMP negative input. */
    ACMP_Open(NUCODEGEN_ACMP_MODULE_SEL, ACMP_MODULE_1, NUCODEGEN_ACMP1_N_SEL, NUCODEGEN_ACMP1_HYSTERESIS_SEL);


#if (NUCODEGEN_ACMP1_ADVANCED)

#if (NUCODEGEN_ACMP1_FILTERCNT_EN)
    /* Set ACMP0 output filter */
    ACMP_SET_FILTER(NUCODEGEN_ACMP_MODULE_SEL, ACMP_MODULE_1, NUCODEGEN_ACMP1_FILTERCNT_SEL);

    /* Enable ACMP1 output filter */
    ACMP_ENABLE_FILTER(NUCODEGEN_ACMP_MODULE_SEL,ACMP_MODULE_1);
#endif

#if (NUCODEGEN_ACMP1_OUTPUT_INVERSE_EN)
    /* Enable ACMP1 output inverse */
    ACMP_ENABLE_OUTPUT_INVERSE(NUCODEGEN_ACMP_MODULE_SEL, ACMP_MODULE_1);

#endif /* NUCODEGEN_ACMP1_OUTPUT_INVERSE_EN */

#if (NUCODEGEN_ACMP1_WKP_EN)
    /* Enable ACMP1 ACMP wake-up function */
    ACMP_ENABLE_WAKEUP(NUCODEGEN_ACMP_MODULE_SEL, ACMP_MODULE_1);
#endif /* NUCODEGEN_ACMP1_WKP_EN */

#if (NUCODEGEN_ACMP1_WIN_COMPARE_EN)
    /* Enable ACMP0 window compare function */
    ACMP_ENABLE_WINDOW_COMPARE(NUCODEGEN_ACMP_MODULE_SEL, ACMP_MODULE_1);
#endif /* NUCODEGEN_ACMP1_WIN_COMPARE_EN */

#if (NUCODEGEN_ACMP1_WIN_LATCH_EN)
    /* Enable ACMP1 window latch function */
    ACMP_ENABLE_WINDOW_LATCH(NUCODEGEN_ACMP_MODULE_SEL, ACMP_MODULE_1);
#endif /* NUCODEGEN_ACMP1_WIN_LATCH_EN */

#if (NUCODEGEN_ACMP1_INT_EN)
    /* Clear ACMP 1 interrupt flag */
    ACMP_CLR_INT_FLAG(NUCODEGEN_ACMP_MODULE_SEL, ACMP_MODULE_1);

    /* Set ACMP 1 interrupt condition */
    ACMP_SELECT_INT_COND(NUCODEGEN_ACMP_MODULE_SEL, ACMP_MODULE_1, NUCODEGEN_ACMP1_INT_COND_SEL);

    /* Enable ACMP 1 interrupt */
    ACMP_ENABLE_INT(NUCODEGEN_ACMP_MODULE_SEL, ACMP_MODULE_1);

#endif /* NUCODEGEN_ACMP1_INT_EN */

#endif /* NUCODEGEN_ACMP1_ADVANCED */

#endif /* NUCODEGEN_ACMP1_ENABLE */

#if (NUCODEGEN_ACMP0_INT_EN) || (NUCODEGEN_ACMP1_INT_EN)
    /* Enable ACMP01 interrupt */
    NVIC_EnableIRQ(NUCODEGEN_ACMP_IRQ_MODULE_SEL);
#endif /* (NUCODEGEN_ACMP0_INT_EN) || (NUCODEGEN_ACMP1_INT_EN) */

    /* select comparator CRV source */
    ACMP_SELECT_CRV_SRC(ACMP01, NUCODEGEN_ACMP_CRV_SEL);

    /* select comparator reference voltage */
    ACMP_CRV_SEL(ACMP01, NUCODEGEN_ACMP_CRV_SET);

}
#endif /* NUCODEGEN_ACMP */
