#if (NUCODEGEN_DAC0)
void DAC0_Init()
{

#if(NUCODEGEN_DAC0_ENABLE)
    /* Enable DAC0 */
    DAC_Open(NUCODEGEN_DAC0_MODULE_SEL, DAC0_MODULE_0, NUCODEGEN_DAC0_TRIGGER_SEL);
    /* DAC0 delay time */
    DAC_SetDelayTime(NUCODEGEN_DAC0_MODULE_SEL, NUCODEDEF_DAC0_DLY_TIME);
#endif

#if (NUCODEGEN_DAC0_DAT_WIDTH)
    /* Setting DAC0 data width */
    DAC0_WIDTH(DAC_BIT_8);
#else
#if (NUCODEGEN_DAC0_DAT_ALIGN)
    /* Setting DAC0 data width */
    DAC0_WIDTH(DAC_BIT_12);
    /* Enable DAC0 data left align */
    DAC_ENABLE_LEFT_ALIGN(NUCODEGEN_DAC0_MODULE_SEL);
#endif /* NUCODEGEN_DAC0_DAT_ALIGN */
#endif /* NUCODEGEN_DAC0_DAT_WIDTH */


#if (!NUCODEGEN_DAC0_VOLT_BUF_EN)
    /* DAC0 bypass buffer */
    DAC_ENABLE_BYPASS_BUFFER(NUCODEGEN_DAC0_MODULE_SEL);
#endif /* NUCODEGEN_DAC0_VOLT_BUF_EN */

#if (NUCODEGEN_DAC0_DMA_EN)
    /* Enable DAC0 PDMA mode */
    DAC_ENABLE_PDMA(NUCODEGEN_DAC0_MODULE_SEL);
#if (NUCODEGEN_DAC0_INT_DMA_UNDERRUN_EN && NUCODEGEN_DAC0_INT_EN)
    /* Enable DAC0 DMA under run interrupt */
    DAC_ENABLE_DMAUDR_INT(NUCODEGEN_DAC0_MODULE_SEL);
#endif /* NUCODEGEN_DAC0_INT_DMA_UNDERRUN_EN && NUCODEGEN_DAC0_INT_EN */

#endif /* NUCODEGEN_DAC0_DMA_EN */

#if (NUCODEGEN_DAC0_INT_EN)
    /* Enable DAC0 interrupt */
    DAC_ENABLE_INT(NUCODEGEN_DAC0_MODULE_SEL, DAC0_MODULE_0);
    /* Enable DAC0 interrupt */
    NVIC_EnableIRQ(NUCODEGEN_DAC_IRQ_MODULE_SEL);
#endif

}
#endif /* NUCODEGEN_DAC0 */


#if (NUCODEGEN_DAC1)
void DAC1_Init()
{

#if (NUCODEGEN_DAC0_GROUP_EN && NUCODEGEN_DAC1_ENABLE)

#if(NUCODEGEN_DAC1_ENABLE)
    /* Enable DAC1 */
    DAC_Open(NUCODEGEN_DAC1_MODULE_SEL, DAC1_MODULE_0, DAC_SOFTWARE_TRIGGER);
    /* DAC1 delay time */
    DAC_SetDelayTime(NUCODEGEN_DAC1_MODULE_SEL, NUCODEDEF_DAC1_DLY_TIME);
    /* Enable DAC0 group function */
    DAC0->CTL |= DAC_CTL_GRPEN_Msk;
#endif/* NUCODEGEN_DAC1_ENABLE */

#else

#if(NUCODEGEN_DAC1_ENABLE)
    /* Enable DAC1 */
    DAC_Open(NUCODEGEN_DAC1_MODULE_SEL, DAC1_MODULE_0, NUCODEGEN_DAC1_TRIGGER_SEL);
    /* DAC1 delay time */
    DAC_SetDelayTime(NUCODEGEN_DAC1_MODULE_SEL, NUCODEDEF_DAC1_DLY_TIME);
#endif /* NUCODEGEN_DAC1_ENABLE */

#if (NUCODEGEN_DAC1_DMA_EN)
    /* Enable DAC1 PDMA mode */
    DAC_ENABLE_PDMA(NUCODEGEN_DAC1_MODULE_SEL);
#if (NUCODEGEN_DAC1_INT_DMA_UNDERRUN_EN && NUCODEGEN_DAC1_INT_EN)
    /* Enable DAC1 DMA under run interrupt */
    DAC_ENABLE_DMAUDR_INT(NUCODEGEN_DAC1_MODULE_SEL);
#endif /* NUCODEGEN_DAC1_INT_DMA_UNDERRUN_EN && NUCODEGEN_DAC1_INT_EN */
#endif /* NUCODEGEN_DAC1_DMA_EN */

#endif /* NUCODEGEN_DAC1_GROUP_EN */

#if (NUCODEGEN_DAC1_DAT_WIDTH)
    /* Setting DAC1 data width */
    DAC1_WIDTH(DAC_BIT_8);
#else
#if (NUCODEGEN_DAC1_DAT_ALIGN)
    /* Setting DAC1 data width */
    DAC1_WIDTH(DAC_BIT_12);
    /* Enable DAC1 data left align */
    DAC_ENABLE_LEFT_ALIGN(NUCODEGEN_DAC1_MODULE_SEL);
#endif /* NUCODEGEN_DAC1_DAT_ALIGN */
#endif /* NUCODEGEN_DAC1_DAT_WIDTH */

#if (!NUCODEGEN_DAC1_VOLT_BUF_EN)
    /* DAC1 bypass buffer */
    DAC_ENABLE_BYPASS_BUFFER(NUCODEGEN_DAC1_MODULE_SEL);
#endif /* NUCODEGEN_DAC1_VOLT_BUF_EN */

#if (NUCODEGEN_DAC1_INT_EN)
    /* Enable DAC1 interrupt */
    DAC_ENABLE_INT(NUCODEGEN_DAC1_MODULE_SEL, DAC1_MODULE_0);
    /* Enable DAC  interrupt */
    NVIC_EnableIRQ(NUCODEGEN_DAC_IRQ_MODULE_SEL);
#endif

}
#endif /* NUCODEGEN_DAC1 */
